/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.CursorWindow;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteConnection;
import android.database.sqlite.SQLiteConnectionPool;
import android.database.sqlite.SQLiteStatementInfo;
import android.database.sqlite.SQLiteTransactionListener;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class SQLiteSession
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private SQLiteConnectionPool mConnectionPool;
    private SQLiteConnection mConnection;
    private int mConnectionFlags;
    private int mConnectionUseCount;
    private Transaction mTransactionPool;
    private Transaction mTransactionStack;
    public static int TRANSACTION_MODE_DEFERRED = 0;
    public static int TRANSACTION_MODE_IMMEDIATE = 1;
    public static int TRANSACTION_MODE_EXCLUSIVE = 2;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_database_sqlite_SQLiteSession$__constructor__(SQLiteConnectionPool connectionPool) {
        if (connectionPool == null) {
            throw new IllegalArgumentException("connectionPool must not be null");
        }
        this.mConnectionPool = connectionPool;
    }

    private final boolean $$robo$$android_database_sqlite_SQLiteSession$hasTransaction() {
        return this.mTransactionStack != null;
    }

    private final boolean $$robo$$android_database_sqlite_SQLiteSession$hasNestedTransaction() {
        return this.mTransactionStack != null && this.mTransactionStack.mParent != null;
    }

    private final boolean $$robo$$android_database_sqlite_SQLiteSession$hasConnection() {
        return this.mConnection != null;
    }

    private final void $$robo$$android_database_sqlite_SQLiteSession$beginTransaction(int transactionMode, SQLiteTransactionListener transactionListener, int connectionFlags, CancellationSignal cancellationSignal) {
        this.throwIfTransactionMarkedSuccessful();
        this.beginTransactionUnchecked(transactionMode, transactionListener, connectionFlags, cancellationSignal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteSession$beginTransactionUnchecked(int transactionMode, SQLiteTransactionListener transactionListener, int connectionFlags, CancellationSignal cancellationSignal) {
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
        }
        if (this.mTransactionStack == null) {
            this.acquireConnection(null, connectionFlags, cancellationSignal);
        }
        try {
            if (this.mTransactionStack == null) {
                switch (transactionMode) {
                    case 1: {
                        this.mConnection.execute("BEGIN IMMEDIATE;", null, cancellationSignal);
                        break;
                    }
                    case 2: {
                        this.mConnection.execute("BEGIN EXCLUSIVE;", null, cancellationSignal);
                        break;
                    }
                    default: {
                        this.mConnection.execute("BEGIN;", null, cancellationSignal);
                    }
                }
            }
            if (transactionListener != null) {
                try {
                    transactionListener.onBegin();
                }
                catch (RuntimeException ex) {
                    if (this.mTransactionStack == null) {
                        this.mConnection.execute("ROLLBACK;", null, cancellationSignal);
                    }
                    throw ex;
                }
            }
            Transaction transaction = this.obtainTransaction(transactionMode, transactionListener);
            transaction.mParent = this.mTransactionStack;
            this.mTransactionStack = transaction;
        }
        finally {
            if (this.mTransactionStack == null) {
                this.releaseConnection();
            }
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteSession$setTransactionSuccessful() {
        this.throwIfNoTransaction();
        this.throwIfTransactionMarkedSuccessful();
        this.mTransactionStack.mMarkedSuccessful = true;
    }

    private final void $$robo$$android_database_sqlite_SQLiteSession$endTransaction(CancellationSignal cancellationSignal) {
        this.throwIfNoTransaction();
        if (!$assertionsDisabled && this.mConnection == null) {
            throw new AssertionError();
        }
        this.endTransactionUnchecked(cancellationSignal, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteSession$endTransactionUnchecked(CancellationSignal cancellationSignal, boolean yielding) {
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
        }
        Transaction top = this.mTransactionStack;
        boolean successful = (top.mMarkedSuccessful || yielding) && !top.mChildFailed;
        RuntimeException listenerException = null;
        SQLiteTransactionListener listener = top.mListener;
        if (listener != null) {
            try {
                if (successful) {
                    listener.onCommit();
                } else {
                    listener.onRollback();
                }
            }
            catch (RuntimeException ex) {
                listenerException = ex;
                successful = false;
            }
        }
        this.mTransactionStack = top.mParent;
        this.recycleTransaction(top);
        if (this.mTransactionStack != null) {
            if (!successful) {
                this.mTransactionStack.mChildFailed = true;
            }
        } else {
            try {
                if (successful) {
                    this.mConnection.execute("COMMIT;", null, cancellationSignal);
                } else {
                    this.mConnection.execute("ROLLBACK;", null, cancellationSignal);
                }
            }
            finally {
                this.releaseConnection();
            }
        }
        if (listenerException != null) {
            throw listenerException;
        }
    }

    private final boolean $$robo$$android_database_sqlite_SQLiteSession$yieldTransaction(long sleepAfterYieldDelayMillis, boolean throwIfUnsafe, CancellationSignal cancellationSignal) {
        if (throwIfUnsafe) {
            this.throwIfNoTransaction();
            this.throwIfTransactionMarkedSuccessful();
            this.throwIfNestedTransaction();
        } else if (this.mTransactionStack == null || this.mTransactionStack.mMarkedSuccessful || this.mTransactionStack.mParent != null) {
            return false;
        }
        if (!$assertionsDisabled && this.mConnection == null) {
            throw new AssertionError();
        }
        if (this.mTransactionStack.mChildFailed) {
            return false;
        }
        return this.yieldTransactionUnchecked(sleepAfterYieldDelayMillis, cancellationSignal);
    }

    private final boolean $$robo$$android_database_sqlite_SQLiteSession$yieldTransactionUnchecked(long sleepAfterYieldDelayMillis, CancellationSignal cancellationSignal) {
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
        }
        if (!this.mConnectionPool.shouldYieldConnection(this.mConnection, this.mConnectionFlags)) {
            return false;
        }
        int transactionMode = this.mTransactionStack.mMode;
        SQLiteTransactionListener listener = this.mTransactionStack.mListener;
        int connectionFlags = this.mConnectionFlags;
        this.endTransactionUnchecked(cancellationSignal, true);
        if (sleepAfterYieldDelayMillis > 0L) {
            try {
                Thread.sleep(sleepAfterYieldDelayMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.beginTransactionUnchecked(transactionMode, listener, connectionFlags, cancellationSignal);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteSession$prepare(String sql, int connectionFlags, CancellationSignal cancellationSignal, SQLiteStatementInfo outStatementInfo) {
        if (sql == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
        }
        this.acquireConnection(sql, connectionFlags, cancellationSignal);
        try {
            this.mConnection.prepare(sql, outStatementInfo);
        }
        finally {
            this.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteSession$execute(String sql, Object[] bindArgs, int connectionFlags, CancellationSignal cancellationSignal) {
        if (sql == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        if (this.executeSpecial(sql, bindArgs, connectionFlags, cancellationSignal)) {
            return;
        }
        this.acquireConnection(sql, connectionFlags, cancellationSignal);
        try {
            this.mConnection.execute(sql, bindArgs, cancellationSignal);
        }
        finally {
            this.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$android_database_sqlite_SQLiteSession$executeForLong(String sql, Object[] bindArgs, int connectionFlags, CancellationSignal cancellationSignal) {
        if (sql == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        if (this.executeSpecial(sql, bindArgs, connectionFlags, cancellationSignal)) {
            return 0L;
        }
        this.acquireConnection(sql, connectionFlags, cancellationSignal);
        try {
            long l = this.mConnection.executeForLong(sql, bindArgs, cancellationSignal);
            return l;
        }
        finally {
            this.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_database_sqlite_SQLiteSession$executeForString(String sql, Object[] bindArgs, int connectionFlags, CancellationSignal cancellationSignal) {
        if (sql == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        if (this.executeSpecial(sql, bindArgs, connectionFlags, cancellationSignal)) {
            return null;
        }
        this.acquireConnection(sql, connectionFlags, cancellationSignal);
        try {
            String string2 = this.mConnection.executeForString(sql, bindArgs, cancellationSignal);
            return string2;
        }
        finally {
            this.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ParcelFileDescriptor $$robo$$android_database_sqlite_SQLiteSession$executeForBlobFileDescriptor(String sql, Object[] bindArgs, int connectionFlags, CancellationSignal cancellationSignal) {
        if (sql == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        if (this.executeSpecial(sql, bindArgs, connectionFlags, cancellationSignal)) {
            return null;
        }
        this.acquireConnection(sql, connectionFlags, cancellationSignal);
        try {
            ParcelFileDescriptor parcelFileDescriptor = this.mConnection.executeForBlobFileDescriptor(sql, bindArgs, cancellationSignal);
            return parcelFileDescriptor;
        }
        finally {
            this.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_database_sqlite_SQLiteSession$executeForChangedRowCount(String sql, Object[] bindArgs, int connectionFlags, CancellationSignal cancellationSignal) {
        if (sql == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        if (this.executeSpecial(sql, bindArgs, connectionFlags, cancellationSignal)) {
            return 0;
        }
        this.acquireConnection(sql, connectionFlags, cancellationSignal);
        try {
            int n = this.mConnection.executeForChangedRowCount(sql, bindArgs, cancellationSignal);
            return n;
        }
        finally {
            this.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$android_database_sqlite_SQLiteSession$executeForLastInsertedRowId(String sql, Object[] bindArgs, int connectionFlags, CancellationSignal cancellationSignal) {
        if (sql == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        if (this.executeSpecial(sql, bindArgs, connectionFlags, cancellationSignal)) {
            return 0L;
        }
        this.acquireConnection(sql, connectionFlags, cancellationSignal);
        try {
            long l = this.mConnection.executeForLastInsertedRowId(sql, bindArgs, cancellationSignal);
            return l;
        }
        finally {
            this.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_database_sqlite_SQLiteSession$executeForCursorWindow(String sql, Object[] bindArgs, CursorWindow window, int startPos, int requiredPos, boolean countAllRows, int connectionFlags, CancellationSignal cancellationSignal) {
        if (sql == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        if (window == null) {
            throw new IllegalArgumentException("window must not be null.");
        }
        if (this.executeSpecial(sql, bindArgs, connectionFlags, cancellationSignal)) {
            window.clear();
            return 0;
        }
        this.acquireConnection(sql, connectionFlags, cancellationSignal);
        try {
            int n = this.mConnection.executeForCursorWindow(sql, bindArgs, window, startPos, requiredPos, countAllRows, cancellationSignal);
            return n;
        }
        finally {
            this.releaseConnection();
        }
    }

    private final boolean $$robo$$android_database_sqlite_SQLiteSession$executeSpecial(String sql, Object[] bindArgs, int connectionFlags, CancellationSignal cancellationSignal) {
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
        }
        int type = DatabaseUtils.getSqlStatementType(sql);
        switch (type) {
            case 4: {
                this.beginTransaction(2, null, connectionFlags, cancellationSignal);
                return true;
            }
            case 5: {
                this.setTransactionSuccessful();
                this.endTransaction(cancellationSignal);
                return true;
            }
            case 6: {
                this.endTransaction(cancellationSignal);
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$android_database_sqlite_SQLiteSession$acquireConnection(String sql, int connectionFlags, CancellationSignal cancellationSignal) {
        if (this.mConnection == null) {
            if (!$assertionsDisabled && this.mConnectionUseCount != 0) {
                throw new AssertionError();
            }
            this.mConnection = this.mConnectionPool.acquireConnection(sql, connectionFlags, cancellationSignal);
            this.mConnectionFlags = connectionFlags;
        }
        ++this.mConnectionUseCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteSession$releaseConnection() {
        if (!$assertionsDisabled && this.mConnection == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mConnectionUseCount <= 0) {
            throw new AssertionError();
        }
        if (--this.mConnectionUseCount == 0) {
            try {
                this.mConnectionPool.releaseConnection(this.mConnection);
            }
            finally {
                this.mConnection = null;
            }
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteSession$throwIfNoTransaction() {
        if (this.mTransactionStack == null) {
            throw new IllegalStateException("Cannot perform this operation because there is no current transaction.");
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteSession$throwIfTransactionMarkedSuccessful() {
        if (this.mTransactionStack != null && this.mTransactionStack.mMarkedSuccessful) {
            throw new IllegalStateException("Cannot perform this operation because the transaction has already been marked successful.  The only thing you can do now is call endTransaction().");
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteSession$throwIfNestedTransaction() {
        if (this.hasNestedTransaction()) {
            throw new IllegalStateException("Cannot perform this operation because a nested transaction is in progress.");
        }
    }

    private final Transaction $$robo$$android_database_sqlite_SQLiteSession$obtainTransaction(int mode, SQLiteTransactionListener listener) {
        Transaction transaction = this.mTransactionPool;
        if (transaction != null) {
            this.mTransactionPool = transaction.mParent;
            transaction.mParent = null;
            transaction.mMarkedSuccessful = false;
            transaction.mChildFailed = false;
        } else {
            transaction = new Transaction();
        }
        transaction.mMode = mode;
        transaction.mListener = listener;
        return transaction;
    }

    private final void $$robo$$android_database_sqlite_SQLiteSession$recycleTransaction(Transaction transaction) {
        transaction.mParent = this.mTransactionPool;
        transaction.mListener = null;
        this.mTransactionPool = transaction;
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !SQLiteSession.class.desiredAssertionStatus();
    }

    private void __constructor__(SQLiteConnectionPool sQLiteConnectionPool) {
        this.$$robo$$android_database_sqlite_SQLiteSession$__constructor__(sQLiteConnectionPool);
    }

    public SQLiteSession(SQLiteConnectionPool sQLiteConnectionPool) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteSession$__constructor__(android.database.sqlite.SQLiteConnectionPool ), 0, this, sQLiteConnectionPool);
    }

    public boolean hasTransaction() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasTransaction", $$robo$$android_database_sqlite_SQLiteSession$hasTransaction(), 0, this);
    }

    public boolean hasNestedTransaction() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasNestedTransaction", $$robo$$android_database_sqlite_SQLiteSession$hasNestedTransaction(), 0, this);
    }

    public boolean hasConnection() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasConnection", $$robo$$android_database_sqlite_SQLiteSession$hasConnection(), 0, this);
    }

    public void beginTransaction(int n, SQLiteTransactionListener sQLiteTransactionListener, int n2, CancellationSignal cancellationSignal) {
        InvokeDynamicSupport.bootstrap("beginTransaction", $$robo$$android_database_sqlite_SQLiteSession$beginTransaction(int android.database.sqlite.SQLiteTransactionListener int android.os.CancellationSignal ), 0, this, n, sQLiteTransactionListener, n2, cancellationSignal);
    }

    private void beginTransactionUnchecked(int n, SQLiteTransactionListener sQLiteTransactionListener, int n2, CancellationSignal cancellationSignal) {
        InvokeDynamicSupport.bootstrap("beginTransactionUnchecked", $$robo$$android_database_sqlite_SQLiteSession$beginTransactionUnchecked(int android.database.sqlite.SQLiteTransactionListener int android.os.CancellationSignal ), 0, this, n, sQLiteTransactionListener, n2, cancellationSignal);
    }

    public void setTransactionSuccessful() {
        InvokeDynamicSupport.bootstrap("setTransactionSuccessful", $$robo$$android_database_sqlite_SQLiteSession$setTransactionSuccessful(), 0, this);
    }

    public void endTransaction(CancellationSignal cancellationSignal) {
        InvokeDynamicSupport.bootstrap("endTransaction", $$robo$$android_database_sqlite_SQLiteSession$endTransaction(android.os.CancellationSignal ), 0, this, cancellationSignal);
    }

    private void endTransactionUnchecked(CancellationSignal cancellationSignal, boolean bl) {
        InvokeDynamicSupport.bootstrap("endTransactionUnchecked", $$robo$$android_database_sqlite_SQLiteSession$endTransactionUnchecked(android.os.CancellationSignal boolean ), 0, this, cancellationSignal, bl);
    }

    public boolean yieldTransaction(long l, boolean bl, CancellationSignal cancellationSignal) {
        return (boolean)InvokeDynamicSupport.bootstrap("yieldTransaction", $$robo$$android_database_sqlite_SQLiteSession$yieldTransaction(long boolean android.os.CancellationSignal ), 0, this, l, bl, cancellationSignal);
    }

    private boolean yieldTransactionUnchecked(long l, CancellationSignal cancellationSignal) {
        return (boolean)InvokeDynamicSupport.bootstrap("yieldTransactionUnchecked", $$robo$$android_database_sqlite_SQLiteSession$yieldTransactionUnchecked(long android.os.CancellationSignal ), 0, this, l, cancellationSignal);
    }

    public void prepare(String string2, int n, CancellationSignal cancellationSignal, SQLiteStatementInfo sQLiteStatementInfo) {
        InvokeDynamicSupport.bootstrap("prepare", $$robo$$android_database_sqlite_SQLiteSession$prepare(java.lang.String int android.os.CancellationSignal android.database.sqlite.SQLiteStatementInfo ), 0, this, string2, n, cancellationSignal, sQLiteStatementInfo);
    }

    public void execute(String string2, Object[] objectArray, int n, CancellationSignal cancellationSignal) {
        InvokeDynamicSupport.bootstrap("execute", $$robo$$android_database_sqlite_SQLiteSession$execute(java.lang.String java.lang.Object[] int android.os.CancellationSignal ), 0, this, string2, objectArray, n, cancellationSignal);
    }

    public long executeForLong(String string2, Object[] objectArray, int n, CancellationSignal cancellationSignal) {
        return (long)InvokeDynamicSupport.bootstrap("executeForLong", $$robo$$android_database_sqlite_SQLiteSession$executeForLong(java.lang.String java.lang.Object[] int android.os.CancellationSignal ), 0, this, string2, objectArray, n, cancellationSignal);
    }

    public String executeForString(String string2, Object[] objectArray, int n, CancellationSignal cancellationSignal) {
        return InvokeDynamicSupport.bootstrap("executeForString", $$robo$$android_database_sqlite_SQLiteSession$executeForString(java.lang.String java.lang.Object[] int android.os.CancellationSignal ), 0, this, string2, objectArray, n, cancellationSignal);
    }

    public ParcelFileDescriptor executeForBlobFileDescriptor(String string2, Object[] objectArray, int n, CancellationSignal cancellationSignal) {
        return InvokeDynamicSupport.bootstrap("executeForBlobFileDescriptor", $$robo$$android_database_sqlite_SQLiteSession$executeForBlobFileDescriptor(java.lang.String java.lang.Object[] int android.os.CancellationSignal ), 0, this, string2, objectArray, n, cancellationSignal);
    }

    public int executeForChangedRowCount(String string2, Object[] objectArray, int n, CancellationSignal cancellationSignal) {
        return (int)InvokeDynamicSupport.bootstrap("executeForChangedRowCount", $$robo$$android_database_sqlite_SQLiteSession$executeForChangedRowCount(java.lang.String java.lang.Object[] int android.os.CancellationSignal ), 0, this, string2, objectArray, n, cancellationSignal);
    }

    public long executeForLastInsertedRowId(String string2, Object[] objectArray, int n, CancellationSignal cancellationSignal) {
        return (long)InvokeDynamicSupport.bootstrap("executeForLastInsertedRowId", $$robo$$android_database_sqlite_SQLiteSession$executeForLastInsertedRowId(java.lang.String java.lang.Object[] int android.os.CancellationSignal ), 0, this, string2, objectArray, n, cancellationSignal);
    }

    public int executeForCursorWindow(String string2, Object[] objectArray, CursorWindow cursorWindow, int n, int n2, boolean bl, int n3, CancellationSignal cancellationSignal) {
        return (int)InvokeDynamicSupport.bootstrap("executeForCursorWindow", $$robo$$android_database_sqlite_SQLiteSession$executeForCursorWindow(java.lang.String java.lang.Object[] android.database.CursorWindow int int boolean int android.os.CancellationSignal ), 0, this, string2, objectArray, cursorWindow, n, n2, bl, n3, cancellationSignal);
    }

    private boolean executeSpecial(String string2, Object[] objectArray, int n, CancellationSignal cancellationSignal) {
        return (boolean)InvokeDynamicSupport.bootstrap("executeSpecial", $$robo$$android_database_sqlite_SQLiteSession$executeSpecial(java.lang.String java.lang.Object[] int android.os.CancellationSignal ), 0, this, string2, objectArray, n, cancellationSignal);
    }

    private void acquireConnection(String string2, int n, CancellationSignal cancellationSignal) {
        InvokeDynamicSupport.bootstrap("acquireConnection", $$robo$$android_database_sqlite_SQLiteSession$acquireConnection(java.lang.String int android.os.CancellationSignal ), 0, this, string2, n, cancellationSignal);
    }

    private void releaseConnection() {
        InvokeDynamicSupport.bootstrap("releaseConnection", $$robo$$android_database_sqlite_SQLiteSession$releaseConnection(), 0, this);
    }

    private void throwIfNoTransaction() {
        InvokeDynamicSupport.bootstrap("throwIfNoTransaction", $$robo$$android_database_sqlite_SQLiteSession$throwIfNoTransaction(), 0, this);
    }

    private void throwIfTransactionMarkedSuccessful() {
        InvokeDynamicSupport.bootstrap("throwIfTransactionMarkedSuccessful", $$robo$$android_database_sqlite_SQLiteSession$throwIfTransactionMarkedSuccessful(), 0, this);
    }

    private void throwIfNestedTransaction() {
        InvokeDynamicSupport.bootstrap("throwIfNestedTransaction", $$robo$$android_database_sqlite_SQLiteSession$throwIfNestedTransaction(), 0, this);
    }

    private Transaction obtainTransaction(int n, SQLiteTransactionListener sQLiteTransactionListener) {
        return InvokeDynamicSupport.bootstrap("obtainTransaction", $$robo$$android_database_sqlite_SQLiteSession$obtainTransaction(int android.database.sqlite.SQLiteTransactionListener ), 0, this, n, sQLiteTransactionListener);
    }

    private void recycleTransaction(Transaction transaction) {
        InvokeDynamicSupport.bootstrap("recycleTransaction", $$robo$$android_database_sqlite_SQLiteSession$recycleTransaction(android.database.sqlite.SQLiteSession$Transaction ), 0, this, transaction);
    }

    static {
        RobolectricInternals.classInitializing(SQLiteSession.class);
    }

    public /* synthetic */ SQLiteSession() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SQLiteSession)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class Transaction
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Transaction mParent;
        public int mMode;
        public SQLiteTransactionListener mListener;
        public boolean mMarkedSuccessful;
        public boolean mChildFailed;

        private void $$robo$$android_database_sqlite_SQLiteSession_Transaction$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_database_sqlite_SQLiteSession_Transaction$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_database_sqlite_SQLiteSession_Transaction$__constructor__();
        }

        private Transaction() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteSession_Transaction$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_database_sqlite_SQLiteSession_Transaction$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Transaction)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

