/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.SimpleFrameManager;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CachedFrameManager
extends SimpleFrameManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private SortedMap<Integer, Frame> mAvailableFrames;
    private int mStorageCapacity;
    private int mStorageSize;
    private int mTimeStamp;

    private void $$robo$$android_filterfw_core_CachedFrameManager$__constructor__() {
        this.mStorageCapacity = 0x1800000;
        this.mStorageSize = 0;
        this.mTimeStamp = 0;
        this.mAvailableFrames = new TreeMap<Integer, Frame>();
    }

    private final Frame $$robo$$android_filterfw_core_CachedFrameManager$newFrame(FrameFormat format) {
        Frame result = this.findAvailableFrame(format, 0, 0L);
        if (result == null) {
            result = super.newFrame(format);
        }
        result.setTimestamp(-2L);
        return result;
    }

    private final Frame $$robo$$android_filterfw_core_CachedFrameManager$newBoundFrame(FrameFormat format, int bindingType, long bindingId) {
        Frame result = this.findAvailableFrame(format, bindingType, bindingId);
        if (result == null) {
            result = super.newBoundFrame(format, bindingType, bindingId);
        }
        result.setTimestamp(-2L);
        return result;
    }

    private final Frame $$robo$$android_filterfw_core_CachedFrameManager$retainFrame(Frame frame) {
        return super.retainFrame(frame);
    }

    private final Frame $$robo$$android_filterfw_core_CachedFrameManager$releaseFrame(Frame frame) {
        if (frame.isReusable()) {
            int refCount = frame.decRefCount();
            if (refCount == 0 && frame.hasNativeAllocation()) {
                if (!this.storeFrame(frame)) {
                    frame.releaseNativeAllocation();
                }
                return null;
            }
            if (refCount < 0) {
                throw new RuntimeException("Frame reference count dropped below 0!");
            }
        } else {
            super.releaseFrame(frame);
        }
        return frame;
    }

    private final void $$robo$$android_filterfw_core_CachedFrameManager$clearCache() {
        for (Frame frame : this.mAvailableFrames.values()) {
            frame.releaseNativeAllocation();
        }
        this.mAvailableFrames.clear();
    }

    private final void $$robo$$android_filterfw_core_CachedFrameManager$tearDown() {
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_filterfw_core_CachedFrameManager$storeFrame(Frame frame) {
        SortedMap<Integer, Frame> sortedMap = this.mAvailableFrames;
        synchronized (sortedMap) {
            int frameSize = frame.getFormat().getSize();
            if (frameSize > this.mStorageCapacity) {
                return false;
            }
            int newStorageSize = this.mStorageSize + frameSize;
            while (newStorageSize > this.mStorageCapacity) {
                this.dropOldestFrame();
                newStorageSize = this.mStorageSize + frameSize;
            }
            frame.onFrameStore();
            this.mStorageSize = newStorageSize;
            this.mAvailableFrames.put(this.mTimeStamp, frame);
            ++this.mTimeStamp;
            return true;
        }
    }

    private final void $$robo$$android_filterfw_core_CachedFrameManager$dropOldestFrame() {
        int oldest = this.mAvailableFrames.firstKey();
        Frame frame = (Frame)this.mAvailableFrames.get(oldest);
        this.mStorageSize -= frame.getFormat().getSize();
        frame.releaseNativeAllocation();
        this.mAvailableFrames.remove(oldest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Frame $$robo$$android_filterfw_core_CachedFrameManager$findAvailableFrame(FrameFormat format, int bindingType, long bindingId) {
        SortedMap<Integer, Frame> sortedMap = this.mAvailableFrames;
        synchronized (sortedMap) {
            for (Map.Entry entry : this.mAvailableFrames.entrySet()) {
                Frame frame = (Frame)entry.getValue();
                if (!frame.getFormat().isReplaceableBy(format) || bindingType != frame.getBindingType() || bindingType != 0 && bindingId != frame.getBindingId()) continue;
                super.retainFrame(frame);
                this.mAvailableFrames.remove(entry.getKey());
                frame.onFrameFetch();
                frame.reset(format);
                this.mStorageSize -= format.getSize();
                return frame;
            }
        }
        return null;
    }

    private void __constructor__() {
        this.$$robo$$android_filterfw_core_CachedFrameManager$__constructor__();
    }

    public CachedFrameManager() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterfw_core_CachedFrameManager$__constructor__(), 0, this);
    }

    @Override
    public Frame newFrame(FrameFormat frameFormat) {
        return InvokeDynamicSupport.bootstrap("newFrame", $$robo$$android_filterfw_core_CachedFrameManager$newFrame(android.filterfw.core.FrameFormat ), 0, this, frameFormat);
    }

    @Override
    public Frame newBoundFrame(FrameFormat frameFormat, int n, long l) {
        return InvokeDynamicSupport.bootstrap("newBoundFrame", $$robo$$android_filterfw_core_CachedFrameManager$newBoundFrame(android.filterfw.core.FrameFormat int long ), 0, this, frameFormat, n, l);
    }

    @Override
    public Frame retainFrame(Frame frame) {
        return InvokeDynamicSupport.bootstrap("retainFrame", $$robo$$android_filterfw_core_CachedFrameManager$retainFrame(android.filterfw.core.Frame ), 0, this, frame);
    }

    @Override
    public Frame releaseFrame(Frame frame) {
        return InvokeDynamicSupport.bootstrap("releaseFrame", $$robo$$android_filterfw_core_CachedFrameManager$releaseFrame(android.filterfw.core.Frame ), 0, this, frame);
    }

    public void clearCache() {
        InvokeDynamicSupport.bootstrap("clearCache", $$robo$$android_filterfw_core_CachedFrameManager$clearCache(), 0, this);
    }

    @Override
    public void tearDown() {
        InvokeDynamicSupport.bootstrap("tearDown", $$robo$$android_filterfw_core_CachedFrameManager$tearDown(), 0, this);
    }

    private boolean storeFrame(Frame frame) {
        return (boolean)InvokeDynamicSupport.bootstrap("storeFrame", $$robo$$android_filterfw_core_CachedFrameManager$storeFrame(android.filterfw.core.Frame ), 0, this, frame);
    }

    private void dropOldestFrame() {
        InvokeDynamicSupport.bootstrap("dropOldestFrame", $$robo$$android_filterfw_core_CachedFrameManager$dropOldestFrame(), 0, this);
    }

    private Frame findAvailableFrame(FrameFormat frameFormat, int n, long l) {
        return InvokeDynamicSupport.bootstrap("findAvailableFrame", $$robo$$android_filterfw_core_CachedFrameManager$findAvailableFrame(android.filterfw.core.FrameFormat int long ), 0, this, frameFormat, n, l);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CachedFrameManager)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

