/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.FieldPort;
import android.filterfw.core.FilterContext;
import android.filterfw.core.FilterPort;
import android.filterfw.core.FinalPort;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.GenerateFinalPort;
import android.filterfw.core.GenerateProgramPort;
import android.filterfw.core.GenerateProgramPorts;
import android.filterfw.core.InputPort;
import android.filterfw.core.KeyValueMap;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.OutputPort;
import android.filterfw.core.Program;
import android.filterfw.core.ProgramPort;
import android.filterfw.core.ProtocolException;
import android.filterfw.core.SerializedFrame;
import android.filterfw.core.SimpleFrame;
import android.filterfw.core.StreamPort;
import android.filterfw.format.ObjectFormat;
import android.filterfw.io.GraphIOException;
import android.filterfw.io.TextGraphReader;
import android.util.Log;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class Filter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static int STATUS_PREINIT = 0;
    static int STATUS_UNPREPARED = 1;
    static int STATUS_PREPARED = 2;
    static int STATUS_PROCESSING = 3;
    static int STATUS_SLEEPING = 4;
    static int STATUS_FINISHED = 5;
    static int STATUS_ERROR = 6;
    static int STATUS_RELEASED = 7;
    private String mName;
    private int mInputCount;
    private int mOutputCount;
    private HashMap<String, InputPort> mInputPorts;
    private HashMap<String, OutputPort> mOutputPorts;
    private HashSet<Frame> mFramesToRelease;
    private HashMap<String, Frame> mFramesToSet;
    private int mStatus;
    private boolean mIsOpen;
    private int mSleepDelay;
    private long mCurrentTimestamp;
    private boolean mLogVerbose;
    private static String TAG = "Filter";

    private void $$robo$$android_filterfw_core_Filter$__constructor__(String name) {
        this.mInputCount = -1;
        this.mOutputCount = -1;
        this.mStatus = 0;
        this.mIsOpen = false;
        this.mName = name;
        this.mFramesToRelease = new HashSet();
        this.mFramesToSet = new HashMap();
        this.mStatus = 0;
        this.mLogVerbose = Log.isLoggable("Filter", 2);
    }

    private static final boolean $$robo$$android_filterfw_core_Filter$isAvailable(String filterName) {
        Class<?> filterClass;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            filterClass = contextClassLoader.loadClass(filterName);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        try {
            filterClass.asSubclass(Filter.class);
        }
        catch (ClassCastException e) {
            return false;
        }
        return true;
    }

    private final void $$robo$$android_filterfw_core_Filter$initWithValueMap(KeyValueMap valueMap) {
        this.initFinalPorts(valueMap);
        this.initRemainingPorts(valueMap);
        this.mStatus = 1;
    }

    private final void $$robo$$android_filterfw_core_Filter$initWithAssignmentString(String assignments) {
        try {
            KeyValueMap valueMap = new TextGraphReader().readKeyValueAssignments(assignments);
            this.initWithValueMap(valueMap);
        }
        catch (GraphIOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private final void $$robo$$android_filterfw_core_Filter$initWithAssignmentList(Object ... keyValues) {
        KeyValueMap valueMap = new KeyValueMap();
        valueMap.setKeyValues(keyValues);
        this.initWithValueMap(valueMap);
    }

    private final void $$robo$$android_filterfw_core_Filter$init() throws ProtocolException {
        KeyValueMap valueMap = new KeyValueMap();
        this.initWithValueMap(valueMap);
    }

    private final String $$robo$$android_filterfw_core_Filter$getFilterClassName() {
        return this.getClass().getSimpleName();
    }

    private final String $$robo$$android_filterfw_core_Filter$getName() {
        return this.mName;
    }

    private final boolean $$robo$$android_filterfw_core_Filter$isOpen() {
        return this.mIsOpen;
    }

    private final void $$robo$$android_filterfw_core_Filter$setInputFrame(String inputName, Frame frame) {
        InputPort port = this.getInputPort(inputName);
        if (!port.isOpen()) {
            ((FilterPort)port).open();
        }
        port.setFrame(frame);
    }

    private final void $$robo$$android_filterfw_core_Filter$setInputValue(String inputName, Object value) {
        this.setInputFrame(inputName, this.wrapInputValue(inputName, value));
    }

    private final void $$robo$$android_filterfw_core_Filter$prepare(FilterContext context) {
    }

    private final void $$robo$$android_filterfw_core_Filter$parametersUpdated(Set<String> updated) {
    }

    private final void $$robo$$android_filterfw_core_Filter$delayNextProcess(int millisecs) {
        this.mSleepDelay = millisecs;
        this.mStatus = 4;
    }

    public abstract void setupPorts();

    private final FrameFormat $$robo$$android_filterfw_core_Filter$getOutputFormat(String portName, FrameFormat inputFormat) {
        return null;
    }

    private final FrameFormat $$robo$$android_filterfw_core_Filter$getInputFormat(String portName) {
        InputPort inputPort = this.getInputPort(portName);
        return inputPort.getSourceFormat();
    }

    private final void $$robo$$android_filterfw_core_Filter$open(FilterContext context) {
    }

    public abstract void process(FilterContext var1);

    private final int $$robo$$android_filterfw_core_Filter$getSleepDelay() {
        return 250;
    }

    private final void $$robo$$android_filterfw_core_Filter$close(FilterContext context) {
    }

    private final void $$robo$$android_filterfw_core_Filter$tearDown(FilterContext context) {
    }

    private final int $$robo$$android_filterfw_core_Filter$getNumberOfConnectedInputs() {
        int c = 0;
        for (InputPort inputPort : this.mInputPorts.values()) {
            if (!inputPort.isConnected()) continue;
            ++c;
        }
        return c;
    }

    private final int $$robo$$android_filterfw_core_Filter$getNumberOfConnectedOutputs() {
        int c = 0;
        for (OutputPort outputPort : this.mOutputPorts.values()) {
            if (!outputPort.isConnected()) continue;
            ++c;
        }
        return c;
    }

    private final int $$robo$$android_filterfw_core_Filter$getNumberOfInputs() {
        return this.mOutputPorts == null ? 0 : this.mInputPorts.size();
    }

    private final int $$robo$$android_filterfw_core_Filter$getNumberOfOutputs() {
        return this.mInputPorts == null ? 0 : this.mOutputPorts.size();
    }

    private final InputPort $$robo$$android_filterfw_core_Filter$getInputPort(String portName) {
        if (this.mInputPorts == null) {
            throw new NullPointerException("Attempting to access input port '" + portName + "' of " + this + " before Filter has been initialized!");
        }
        InputPort result = this.mInputPorts.get(portName);
        if (result == null) {
            throw new IllegalArgumentException("Unknown input port '" + portName + "' on filter " + this + "!");
        }
        return result;
    }

    private final OutputPort $$robo$$android_filterfw_core_Filter$getOutputPort(String portName) {
        if (this.mInputPorts == null) {
            throw new NullPointerException("Attempting to access output port '" + portName + "' of " + this + " before Filter has been initialized!");
        }
        OutputPort result = this.mOutputPorts.get(portName);
        if (result == null) {
            throw new IllegalArgumentException("Unknown output port '" + portName + "' on filter " + this + "!");
        }
        return result;
    }

    private final void $$robo$$android_filterfw_core_Filter$pushOutput(String name, Frame frame) {
        if (frame.getTimestamp() == -2L) {
            if (this.mLogVerbose) {
                Log.v("Filter", "Default-setting output Frame timestamp on port " + name + " to " + this.mCurrentTimestamp);
            }
            frame.setTimestamp(this.mCurrentTimestamp);
        }
        this.getOutputPort(name).pushFrame(frame);
    }

    private final Frame $$robo$$android_filterfw_core_Filter$pullInput(String name) {
        Frame result = this.getInputPort(name).pullFrame();
        if (this.mCurrentTimestamp == -1L) {
            this.mCurrentTimestamp = result.getTimestamp();
            if (this.mLogVerbose) {
                Log.v("Filter", "Default-setting current timestamp from input port " + name + " to " + this.mCurrentTimestamp);
            }
        }
        this.mFramesToRelease.add(result);
        return result;
    }

    private final void $$robo$$android_filterfw_core_Filter$fieldPortValueUpdated(String name, FilterContext context) {
    }

    private final void $$robo$$android_filterfw_core_Filter$transferInputPortFrame(String name, FilterContext context) {
        this.getInputPort(name).transfer(context);
    }

    private final void $$robo$$android_filterfw_core_Filter$initProgramInputs(Program program, FilterContext context) {
        if (program != null) {
            for (InputPort inputPort : this.mInputPorts.values()) {
                if (inputPort.getTarget() != program) continue;
                inputPort.transfer(context);
            }
        }
    }

    private final void $$robo$$android_filterfw_core_Filter$addInputPort(String name) {
        this.addMaskedInputPort(name, null);
    }

    private final void $$robo$$android_filterfw_core_Filter$addMaskedInputPort(String name, FrameFormat formatMask) {
        StreamPort port = new StreamPort(this, name);
        if (this.mLogVerbose) {
            Log.v("Filter", "Filter " + this + " adding " + port);
        }
        this.mInputPorts.put(name, port);
        port.setPortFormat(formatMask);
    }

    private final void $$robo$$android_filterfw_core_Filter$addOutputPort(String name, FrameFormat format) {
        OutputPort port = new OutputPort(this, name);
        if (this.mLogVerbose) {
            Log.v("Filter", "Filter " + this + " adding " + port);
        }
        port.setPortFormat(format);
        this.mOutputPorts.put(name, port);
    }

    private final void $$robo$$android_filterfw_core_Filter$addOutputBasedOnInput(String outputName, String inputName) {
        OutputPort port = new OutputPort(this, outputName);
        if (this.mLogVerbose) {
            Log.v("Filter", "Filter " + this + " adding " + port);
        }
        port.setBasePort(this.getInputPort(inputName));
        this.mOutputPorts.put(outputName, port);
    }

    private final void $$robo$$android_filterfw_core_Filter$addFieldPort(String name, Field field, boolean hasDefault, boolean isFinal) {
        FieldPort fieldPort;
        field.setAccessible(true);
        FieldPort fieldPort2 = fieldPort = isFinal ? new FinalPort(this, name, field, hasDefault) : new FieldPort(this, name, field, hasDefault);
        if (this.mLogVerbose) {
            Log.v("Filter", "Filter " + this + " adding " + fieldPort);
        }
        MutableFrameFormat format = ObjectFormat.fromClass(field.getType(), 1);
        fieldPort.setPortFormat(format);
        this.mInputPorts.put(name, fieldPort);
    }

    private final void $$robo$$android_filterfw_core_Filter$addProgramPort(String name, String varName, Field field, Class varType, boolean hasDefault) {
        field.setAccessible(true);
        ProgramPort programPort = new ProgramPort(this, name, varName, field, hasDefault);
        if (this.mLogVerbose) {
            Log.v("Filter", "Filter " + this + " adding " + programPort);
        }
        MutableFrameFormat format = ObjectFormat.fromClass(varType, 1);
        programPort.setPortFormat(format);
        this.mInputPorts.put(name, programPort);
    }

    private final void $$robo$$android_filterfw_core_Filter$closeOutputPort(String name) {
        this.getOutputPort(name).close();
    }

    private final void $$robo$$android_filterfw_core_Filter$setWaitsOnInputPort(String portName, boolean waits) {
        this.getInputPort(portName).setBlocking(waits);
    }

    private final void $$robo$$android_filterfw_core_Filter$setWaitsOnOutputPort(String portName, boolean waits) {
        this.getOutputPort(portName).setBlocking(waits);
    }

    private final String $$robo$$android_filterfw_core_Filter$toString() {
        return "'" + this.getName() + "' (" + this.getFilterClassName() + ")";
    }

    private final Collection<InputPort> $$robo$$android_filterfw_core_Filter$getInputPorts() {
        return this.mInputPorts.values();
    }

    private final Collection<OutputPort> $$robo$$android_filterfw_core_Filter$getOutputPorts() {
        return this.mOutputPorts.values();
    }

    private final synchronized int $$robo$$android_filterfw_core_Filter$getStatus() {
        return this.mStatus;
    }

    private final synchronized void $$robo$$android_filterfw_core_Filter$unsetStatus(int flag) {
        this.mStatus &= ~flag;
    }

    private final synchronized void $$robo$$android_filterfw_core_Filter$performOpen(FilterContext context) {
        if (!this.mIsOpen) {
            if (this.mStatus == 1) {
                if (this.mLogVerbose) {
                    Log.v("Filter", "Preparing " + this);
                }
                this.prepare(context);
                this.mStatus = 2;
            }
            if (this.mStatus == 2) {
                if (this.mLogVerbose) {
                    Log.v("Filter", "Opening " + this);
                }
                this.open(context);
                this.mStatus = 3;
            }
            if (this.mStatus != 3) {
                throw new RuntimeException("Filter " + this + " was brought into invalid state during " + "opening (state: " + this.mStatus + ")!");
            }
            this.mIsOpen = true;
        }
    }

    private final synchronized void $$robo$$android_filterfw_core_Filter$performProcess(FilterContext context) {
        if (this.mStatus == 7) {
            throw new RuntimeException("Filter " + this + " is already torn down!");
        }
        this.transferInputFrames(context);
        if (this.mStatus < 3) {
            this.performOpen(context);
        }
        if (this.mLogVerbose) {
            Log.v("Filter", "Processing " + this);
        }
        this.mCurrentTimestamp = -1L;
        this.process(context);
        this.releasePulledFrames(context);
        if (this.filterMustClose()) {
            this.performClose(context);
        }
    }

    private final synchronized void $$robo$$android_filterfw_core_Filter$performClose(FilterContext context) {
        if (this.mIsOpen) {
            if (this.mLogVerbose) {
                Log.v("Filter", "Closing " + this);
            }
            this.mIsOpen = false;
            this.mStatus = 2;
            this.close(context);
            this.closePorts();
        }
    }

    private final synchronized void $$robo$$android_filterfw_core_Filter$performTearDown(FilterContext context) {
        this.performClose(context);
        if (this.mStatus != 7) {
            this.tearDown(context);
            this.mStatus = 7;
        }
    }

    private final synchronized boolean $$robo$$android_filterfw_core_Filter$canProcess() {
        if (this.mLogVerbose) {
            Log.v("Filter", "Checking if can process: " + this + " (" + this.mStatus + ").");
        }
        if (this.mStatus <= 3) {
            return this.inputConditionsMet() && this.outputConditionsMet();
        }
        return false;
    }

    private final void $$robo$$android_filterfw_core_Filter$openOutputs() {
        if (this.mLogVerbose) {
            Log.v("Filter", "Opening all output ports on " + this + "!");
        }
        for (OutputPort outputPort : this.mOutputPorts.values()) {
            if (outputPort.isOpen()) continue;
            outputPort.open();
        }
    }

    private final void $$robo$$android_filterfw_core_Filter$clearInputs() {
        for (InputPort inputPort : this.mInputPorts.values()) {
            inputPort.clear();
        }
    }

    private final void $$robo$$android_filterfw_core_Filter$clearOutputs() {
        for (OutputPort outputPort : this.mOutputPorts.values()) {
            outputPort.clear();
        }
    }

    private final void $$robo$$android_filterfw_core_Filter$notifyFieldPortValueUpdated(String name, FilterContext context) {
        if (this.mStatus == 3 || this.mStatus == 2) {
            this.fieldPortValueUpdated(name, context);
        }
    }

    private final synchronized void $$robo$$android_filterfw_core_Filter$pushInputFrame(String inputName, Frame frame) {
        InputPort port = this.getInputPort(inputName);
        if (!port.isOpen()) {
            ((FilterPort)port).open();
        }
        port.pushFrame(frame);
    }

    private final synchronized void $$robo$$android_filterfw_core_Filter$pushInputValue(String inputName, Object value) {
        this.pushInputFrame(inputName, this.wrapInputValue(inputName, value));
    }

    private final void $$robo$$android_filterfw_core_Filter$initFinalPorts(KeyValueMap values) {
        this.mInputPorts = new HashMap();
        this.mOutputPorts = new HashMap();
        this.addAndSetFinalPorts(values);
    }

    private final void $$robo$$android_filterfw_core_Filter$initRemainingPorts(KeyValueMap values) {
        this.addAnnotatedPorts();
        this.setupPorts();
        this.setInitialInputValues(values);
    }

    private final void $$robo$$android_filterfw_core_Filter$addAndSetFinalPorts(KeyValueMap values) {
        Class<?> filterClass = this.getClass();
        for (Field field : filterClass.getDeclaredFields()) {
            GenerateFinalPort annotation = field.getAnnotation(GenerateFinalPort.class);
            if (annotation == null) continue;
            GenerateFinalPort generator = annotation;
            String name = generator.name().isEmpty() ? field.getName() : generator.name();
            boolean hasDefault = generator.hasDefault();
            this.addFieldPort(name, field, hasDefault, true);
            if (values.containsKey(name)) {
                this.setImmediateInputValue(name, values.get(name));
                values.remove(name);
                continue;
            }
            if (generator.hasDefault()) continue;
            throw new RuntimeException("No value specified for final input port '" + name + "' of filter " + this + "!");
        }
    }

    private final void $$robo$$android_filterfw_core_Filter$addAnnotatedPorts() {
        Class<?> filterClass = this.getClass();
        for (Field field : filterClass.getDeclaredFields()) {
            Annotation generator;
            Annotation annotation = field.getAnnotation(GenerateFieldPort.class);
            if (annotation != null) {
                generator = annotation;
                this.addFieldGenerator((GenerateFieldPort)generator, field);
                continue;
            }
            annotation = field.getAnnotation(GenerateProgramPort.class);
            if (annotation != null) {
                generator = (GenerateProgramPort)annotation;
                this.addProgramGenerator((GenerateProgramPort)generator, field);
                continue;
            }
            annotation = field.getAnnotation(GenerateProgramPorts.class);
            if (annotation == null) continue;
            GenerateProgramPorts generators = (GenerateProgramPorts)annotation;
            for (GenerateProgramPort generator2 : generators.value()) {
                this.addProgramGenerator(generator2, field);
            }
        }
    }

    private final void $$robo$$android_filterfw_core_Filter$addFieldGenerator(GenerateFieldPort generator, Field field) {
        String name = generator.name().isEmpty() ? field.getName() : generator.name();
        boolean hasDefault = generator.hasDefault();
        this.addFieldPort(name, field, hasDefault, false);
    }

    private final void $$robo$$android_filterfw_core_Filter$addProgramGenerator(GenerateProgramPort generator, Field field) {
        String name = generator.name();
        String varName = generator.variableName().isEmpty() ? name : generator.variableName();
        Class varType = generator.type();
        boolean hasDefault = generator.hasDefault();
        this.addProgramPort(name, varName, field, varType, hasDefault);
    }

    private final void $$robo$$android_filterfw_core_Filter$setInitialInputValues(KeyValueMap values) {
        for (Map.Entry entry : values.entrySet()) {
            this.setInputValue((String)entry.getKey(), entry.getValue());
        }
    }

    private final void $$robo$$android_filterfw_core_Filter$setImmediateInputValue(String name, Object value) {
        if (this.mLogVerbose) {
            Log.v("Filter", "Setting immediate value " + value + " for port " + name + "!");
        }
        InputPort port = this.getInputPort(name);
        ((FilterPort)port).open();
        port.setFrame(SimpleFrame.wrapObject(value, null));
    }

    private final void $$robo$$android_filterfw_core_Filter$transferInputFrames(FilterContext context) {
        for (InputPort inputPort : this.mInputPorts.values()) {
            inputPort.transfer(context);
        }
    }

    private final Frame $$robo$$android_filterfw_core_Filter$wrapInputValue(String inputName, Object value) {
        MutableFrameFormat inputFormat = ObjectFormat.fromObject(value, 1);
        if (value == null) {
            FrameFormat portFormat = this.getInputPort(inputName).getPortFormat();
            Class portClass = portFormat == null ? null : portFormat.getObjectClass();
            inputFormat.setObjectClass(portClass);
        }
        boolean shouldSerialize = !(value instanceof Number) && !(value instanceof Boolean) && !(value instanceof String) && value instanceof Serializable;
        Frame frame = shouldSerialize ? new SerializedFrame(inputFormat, null) : new SimpleFrame(inputFormat, null);
        frame.setObjectValue(value);
        return frame;
    }

    private final void $$robo$$android_filterfw_core_Filter$releasePulledFrames(FilterContext context) {
        for (Frame frame : this.mFramesToRelease) {
            context.getFrameManager().releaseFrame(frame);
        }
        this.mFramesToRelease.clear();
    }

    private final boolean $$robo$$android_filterfw_core_Filter$inputConditionsMet() {
        for (FilterPort filterPort : this.mInputPorts.values()) {
            if (filterPort.isReady()) continue;
            if (this.mLogVerbose) {
                Log.v("Filter", "Input condition not met: " + filterPort + "!");
            }
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_filterfw_core_Filter$outputConditionsMet() {
        for (FilterPort filterPort : this.mOutputPorts.values()) {
            if (filterPort.isReady()) continue;
            if (this.mLogVerbose) {
                Log.v("Filter", "Output condition not met: " + filterPort + "!");
            }
            return false;
        }
        return true;
    }

    private final void $$robo$$android_filterfw_core_Filter$closePorts() {
        if (this.mLogVerbose) {
            Log.v("Filter", "Closing all ports on " + this + "!");
        }
        for (InputPort inputPort : this.mInputPorts.values()) {
            inputPort.close();
        }
        for (OutputPort outputPort : this.mOutputPorts.values()) {
            outputPort.close();
        }
    }

    private final boolean $$robo$$android_filterfw_core_Filter$filterMustClose() {
        for (InputPort inputPort : this.mInputPorts.values()) {
            if (!inputPort.filterMustClose()) continue;
            if (this.mLogVerbose) {
                Log.v("Filter", "Filter " + this + " must close due to port " + inputPort);
            }
            return true;
        }
        for (OutputPort outputPort : this.mOutputPorts.values()) {
            if (!outputPort.filterMustClose()) continue;
            if (this.mLogVerbose) {
                Log.v("Filter", "Filter " + this + " must close due to port " + outputPort);
            }
            return true;
        }
        return false;
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_filterfw_core_Filter$__constructor__(string2);
    }

    public Filter(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterfw_core_Filter$__constructor__(java.lang.String ), 0, this, string2);
    }

    public static boolean isAvailable(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isAvailable", $$robo$$android_filterfw_core_Filter$isAvailable(java.lang.String ), 0, (String)string2);
    }

    public void initWithValueMap(KeyValueMap keyValueMap) {
        InvokeDynamicSupport.bootstrap("initWithValueMap", $$robo$$android_filterfw_core_Filter$initWithValueMap(android.filterfw.core.KeyValueMap ), 0, this, keyValueMap);
    }

    public void initWithAssignmentString(String string2) {
        InvokeDynamicSupport.bootstrap("initWithAssignmentString", $$robo$$android_filterfw_core_Filter$initWithAssignmentString(java.lang.String ), 0, this, string2);
    }

    public void initWithAssignmentList(Object ... objectArray) {
        InvokeDynamicSupport.bootstrap("initWithAssignmentList", $$robo$$android_filterfw_core_Filter$initWithAssignmentList(java.lang.Object[] ), 0, this, objectArray);
    }

    public void init() throws ProtocolException {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_filterfw_core_Filter$init(), 0, this);
    }

    public String getFilterClassName() {
        return InvokeDynamicSupport.bootstrap("getFilterClassName", $$robo$$android_filterfw_core_Filter$getFilterClassName(), 0, this);
    }

    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_filterfw_core_Filter$getName(), 0, this);
    }

    public boolean isOpen() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOpen", $$robo$$android_filterfw_core_Filter$isOpen(), 0, this);
    }

    public void setInputFrame(String string2, Frame frame) {
        InvokeDynamicSupport.bootstrap("setInputFrame", $$robo$$android_filterfw_core_Filter$setInputFrame(java.lang.String android.filterfw.core.Frame ), 0, this, string2, frame);
    }

    public void setInputValue(String string2, Object object) {
        InvokeDynamicSupport.bootstrap("setInputValue", $$robo$$android_filterfw_core_Filter$setInputValue(java.lang.String java.lang.Object ), 0, this, string2, object);
    }

    protected void prepare(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("prepare", $$robo$$android_filterfw_core_Filter$prepare(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    protected void parametersUpdated(Set<String> set) {
        InvokeDynamicSupport.bootstrap("parametersUpdated", $$robo$$android_filterfw_core_Filter$parametersUpdated(java.util.Set<java.lang.String> ), 0, this, set);
    }

    protected void delayNextProcess(int n) {
        InvokeDynamicSupport.bootstrap("delayNextProcess", $$robo$$android_filterfw_core_Filter$delayNextProcess(int ), 0, this, n);
    }

    public FrameFormat getOutputFormat(String string2, FrameFormat frameFormat) {
        return InvokeDynamicSupport.bootstrap("getOutputFormat", $$robo$$android_filterfw_core_Filter$getOutputFormat(java.lang.String android.filterfw.core.FrameFormat ), 0, this, string2, frameFormat);
    }

    public FrameFormat getInputFormat(String string2) {
        return InvokeDynamicSupport.bootstrap("getInputFormat", $$robo$$android_filterfw_core_Filter$getInputFormat(java.lang.String ), 0, this, string2);
    }

    public void open(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("open", $$robo$$android_filterfw_core_Filter$open(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    public int getSleepDelay() {
        return (int)InvokeDynamicSupport.bootstrap("getSleepDelay", $$robo$$android_filterfw_core_Filter$getSleepDelay(), 0, this);
    }

    public void close(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_filterfw_core_Filter$close(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    public void tearDown(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("tearDown", $$robo$$android_filterfw_core_Filter$tearDown(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    public int getNumberOfConnectedInputs() {
        return (int)InvokeDynamicSupport.bootstrap("getNumberOfConnectedInputs", $$robo$$android_filterfw_core_Filter$getNumberOfConnectedInputs(), 0, this);
    }

    public int getNumberOfConnectedOutputs() {
        return (int)InvokeDynamicSupport.bootstrap("getNumberOfConnectedOutputs", $$robo$$android_filterfw_core_Filter$getNumberOfConnectedOutputs(), 0, this);
    }

    public int getNumberOfInputs() {
        return (int)InvokeDynamicSupport.bootstrap("getNumberOfInputs", $$robo$$android_filterfw_core_Filter$getNumberOfInputs(), 0, this);
    }

    public int getNumberOfOutputs() {
        return (int)InvokeDynamicSupport.bootstrap("getNumberOfOutputs", $$robo$$android_filterfw_core_Filter$getNumberOfOutputs(), 0, this);
    }

    public InputPort getInputPort(String string2) {
        return InvokeDynamicSupport.bootstrap("getInputPort", $$robo$$android_filterfw_core_Filter$getInputPort(java.lang.String ), 0, this, string2);
    }

    public OutputPort getOutputPort(String string2) {
        return InvokeDynamicSupport.bootstrap("getOutputPort", $$robo$$android_filterfw_core_Filter$getOutputPort(java.lang.String ), 0, this, string2);
    }

    protected void pushOutput(String string2, Frame frame) {
        InvokeDynamicSupport.bootstrap("pushOutput", $$robo$$android_filterfw_core_Filter$pushOutput(java.lang.String android.filterfw.core.Frame ), 0, this, string2, frame);
    }

    protected Frame pullInput(String string2) {
        return InvokeDynamicSupport.bootstrap("pullInput", $$robo$$android_filterfw_core_Filter$pullInput(java.lang.String ), 0, this, string2);
    }

    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("fieldPortValueUpdated", $$robo$$android_filterfw_core_Filter$fieldPortValueUpdated(java.lang.String android.filterfw.core.FilterContext ), 0, this, string2, filterContext);
    }

    protected void transferInputPortFrame(String string2, FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("transferInputPortFrame", $$robo$$android_filterfw_core_Filter$transferInputPortFrame(java.lang.String android.filterfw.core.FilterContext ), 0, this, string2, filterContext);
    }

    protected void initProgramInputs(Program program, FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("initProgramInputs", $$robo$$android_filterfw_core_Filter$initProgramInputs(android.filterfw.core.Program android.filterfw.core.FilterContext ), 0, this, program, filterContext);
    }

    protected void addInputPort(String string2) {
        InvokeDynamicSupport.bootstrap("addInputPort", $$robo$$android_filterfw_core_Filter$addInputPort(java.lang.String ), 0, this, string2);
    }

    protected void addMaskedInputPort(String string2, FrameFormat frameFormat) {
        InvokeDynamicSupport.bootstrap("addMaskedInputPort", $$robo$$android_filterfw_core_Filter$addMaskedInputPort(java.lang.String android.filterfw.core.FrameFormat ), 0, this, string2, frameFormat);
    }

    protected void addOutputPort(String string2, FrameFormat frameFormat) {
        InvokeDynamicSupport.bootstrap("addOutputPort", $$robo$$android_filterfw_core_Filter$addOutputPort(java.lang.String android.filterfw.core.FrameFormat ), 0, this, string2, frameFormat);
    }

    protected void addOutputBasedOnInput(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("addOutputBasedOnInput", $$robo$$android_filterfw_core_Filter$addOutputBasedOnInput(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    protected void addFieldPort(String string2, Field field, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("addFieldPort", $$robo$$android_filterfw_core_Filter$addFieldPort(java.lang.String java.lang.reflect.Field boolean boolean ), 0, this, string2, field, bl, bl2);
    }

    protected void addProgramPort(String string2, String string3, Field field, Class clazz, boolean bl) {
        InvokeDynamicSupport.bootstrap("addProgramPort", $$robo$$android_filterfw_core_Filter$addProgramPort(java.lang.String java.lang.String java.lang.reflect.Field java.lang.Class boolean ), 0, this, string2, string3, field, clazz, bl);
    }

    protected void closeOutputPort(String string2) {
        InvokeDynamicSupport.bootstrap("closeOutputPort", $$robo$$android_filterfw_core_Filter$closeOutputPort(java.lang.String ), 0, this, string2);
    }

    protected void setWaitsOnInputPort(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setWaitsOnInputPort", $$robo$$android_filterfw_core_Filter$setWaitsOnInputPort(java.lang.String boolean ), 0, this, string2, bl);
    }

    protected void setWaitsOnOutputPort(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setWaitsOnOutputPort", $$robo$$android_filterfw_core_Filter$setWaitsOnOutputPort(java.lang.String boolean ), 0, this, string2, bl);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_filterfw_core_Filter$toString(), 0, this);
    }

    Collection<InputPort> getInputPorts() {
        return InvokeDynamicSupport.bootstrap("getInputPorts", $$robo$$android_filterfw_core_Filter$getInputPorts(), 0, this);
    }

    Collection<OutputPort> getOutputPorts() {
        return InvokeDynamicSupport.bootstrap("getOutputPorts", $$robo$$android_filterfw_core_Filter$getOutputPorts(), 0, this);
    }

    synchronized int getStatus() {
        return (int)InvokeDynamicSupport.bootstrap("getStatus", $$robo$$android_filterfw_core_Filter$getStatus(), 0, this);
    }

    synchronized void unsetStatus(int n) {
        InvokeDynamicSupport.bootstrap("unsetStatus", $$robo$$android_filterfw_core_Filter$unsetStatus(int ), 0, this, n);
    }

    synchronized void performOpen(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("performOpen", $$robo$$android_filterfw_core_Filter$performOpen(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    synchronized void performProcess(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("performProcess", $$robo$$android_filterfw_core_Filter$performProcess(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    synchronized void performClose(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("performClose", $$robo$$android_filterfw_core_Filter$performClose(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    synchronized void performTearDown(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("performTearDown", $$robo$$android_filterfw_core_Filter$performTearDown(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    synchronized boolean canProcess() {
        return (boolean)InvokeDynamicSupport.bootstrap("canProcess", $$robo$$android_filterfw_core_Filter$canProcess(), 0, this);
    }

    void openOutputs() {
        InvokeDynamicSupport.bootstrap("openOutputs", $$robo$$android_filterfw_core_Filter$openOutputs(), 0, this);
    }

    void clearInputs() {
        InvokeDynamicSupport.bootstrap("clearInputs", $$robo$$android_filterfw_core_Filter$clearInputs(), 0, this);
    }

    void clearOutputs() {
        InvokeDynamicSupport.bootstrap("clearOutputs", $$robo$$android_filterfw_core_Filter$clearOutputs(), 0, this);
    }

    void notifyFieldPortValueUpdated(String string2, FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("notifyFieldPortValueUpdated", $$robo$$android_filterfw_core_Filter$notifyFieldPortValueUpdated(java.lang.String android.filterfw.core.FilterContext ), 0, this, string2, filterContext);
    }

    synchronized void pushInputFrame(String string2, Frame frame) {
        InvokeDynamicSupport.bootstrap("pushInputFrame", $$robo$$android_filterfw_core_Filter$pushInputFrame(java.lang.String android.filterfw.core.Frame ), 0, this, string2, frame);
    }

    synchronized void pushInputValue(String string2, Object object) {
        InvokeDynamicSupport.bootstrap("pushInputValue", $$robo$$android_filterfw_core_Filter$pushInputValue(java.lang.String java.lang.Object ), 0, this, string2, object);
    }

    private void initFinalPorts(KeyValueMap keyValueMap) {
        InvokeDynamicSupport.bootstrap("initFinalPorts", $$robo$$android_filterfw_core_Filter$initFinalPorts(android.filterfw.core.KeyValueMap ), 0, this, keyValueMap);
    }

    private void initRemainingPorts(KeyValueMap keyValueMap) {
        InvokeDynamicSupport.bootstrap("initRemainingPorts", $$robo$$android_filterfw_core_Filter$initRemainingPorts(android.filterfw.core.KeyValueMap ), 0, this, keyValueMap);
    }

    private void addAndSetFinalPorts(KeyValueMap keyValueMap) {
        InvokeDynamicSupport.bootstrap("addAndSetFinalPorts", $$robo$$android_filterfw_core_Filter$addAndSetFinalPorts(android.filterfw.core.KeyValueMap ), 0, this, keyValueMap);
    }

    private void addAnnotatedPorts() {
        InvokeDynamicSupport.bootstrap("addAnnotatedPorts", $$robo$$android_filterfw_core_Filter$addAnnotatedPorts(), 0, this);
    }

    private void addFieldGenerator(GenerateFieldPort generateFieldPort, Field field) {
        InvokeDynamicSupport.bootstrap("addFieldGenerator", $$robo$$android_filterfw_core_Filter$addFieldGenerator(android.filterfw.core.GenerateFieldPort java.lang.reflect.Field ), 0, this, generateFieldPort, field);
    }

    private void addProgramGenerator(GenerateProgramPort generateProgramPort, Field field) {
        InvokeDynamicSupport.bootstrap("addProgramGenerator", $$robo$$android_filterfw_core_Filter$addProgramGenerator(android.filterfw.core.GenerateProgramPort java.lang.reflect.Field ), 0, this, generateProgramPort, field);
    }

    private void setInitialInputValues(KeyValueMap keyValueMap) {
        InvokeDynamicSupport.bootstrap("setInitialInputValues", $$robo$$android_filterfw_core_Filter$setInitialInputValues(android.filterfw.core.KeyValueMap ), 0, this, keyValueMap);
    }

    private void setImmediateInputValue(String string2, Object object) {
        InvokeDynamicSupport.bootstrap("setImmediateInputValue", $$robo$$android_filterfw_core_Filter$setImmediateInputValue(java.lang.String java.lang.Object ), 0, this, string2, object);
    }

    private void transferInputFrames(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("transferInputFrames", $$robo$$android_filterfw_core_Filter$transferInputFrames(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    private Frame wrapInputValue(String string2, Object object) {
        return InvokeDynamicSupport.bootstrap("wrapInputValue", $$robo$$android_filterfw_core_Filter$wrapInputValue(java.lang.String java.lang.Object ), 0, this, string2, object);
    }

    private void releasePulledFrames(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("releasePulledFrames", $$robo$$android_filterfw_core_Filter$releasePulledFrames(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    private boolean inputConditionsMet() {
        return (boolean)InvokeDynamicSupport.bootstrap("inputConditionsMet", $$robo$$android_filterfw_core_Filter$inputConditionsMet(), 0, this);
    }

    private boolean outputConditionsMet() {
        return (boolean)InvokeDynamicSupport.bootstrap("outputConditionsMet", $$robo$$android_filterfw_core_Filter$outputConditionsMet(), 0, this);
    }

    private void closePorts() {
        InvokeDynamicSupport.bootstrap("closePorts", $$robo$$android_filterfw_core_Filter$closePorts(), 0, this);
    }

    private boolean filterMustClose() {
        return (boolean)InvokeDynamicSupport.bootstrap("filterMustClose", $$robo$$android_filterfw_core_Filter$filterMustClose(), 0, this);
    }

    public /* synthetic */ Filter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Filter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

