/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.FrameManager;
import android.filterfw.core.GLEnvironment;
import android.filterfw.core.GLFrameTimer;
import android.filterfw.core.NativeFrame;
import android.filterfw.core.SimpleFrame;
import android.filterfw.core.StopWatchMap;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.opengl.GLES20;
import java.nio.ByteBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GLFrame
extends Frame
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int EXISTING_TEXTURE_BINDING = 100;
    public static int EXISTING_FBO_BINDING = 101;
    public static int NEW_TEXTURE_BINDING = 102;
    public static int NEW_FBO_BINDING = 103;
    public static int EXTERNAL_TEXTURE = 104;
    private int glFrameId;
    private boolean mOwnsTexture;
    private GLEnvironment mGLEnvironment;

    private void $$robo$$android_filterfw_core_GLFrame$__constructor__(FrameFormat format, FrameManager frameManager) {
        this.glFrameId = -1;
        this.mOwnsTexture = true;
    }

    private void $$robo$$android_filterfw_core_GLFrame$__constructor__(FrameFormat format, FrameManager frameManager, int bindingType, long bindingId) {
        this.glFrameId = -1;
        this.mOwnsTexture = true;
    }

    private final void $$robo$$android_filterfw_core_GLFrame$init(GLEnvironment glEnv) {
        FrameFormat format = this.getFormat();
        this.mGLEnvironment = glEnv;
        if (format.getBytesPerSample() != 4) {
            throw new IllegalArgumentException("GL frames must have 4 bytes per sample!");
        }
        if (format.getDimensionCount() != 2) {
            throw new IllegalArgumentException("GL frames must be 2-dimensional!");
        }
        if (this.getFormat().getSize() < 0) {
            throw new IllegalArgumentException("Initializing GL frame with zero size!");
        }
        int bindingType = this.getBindingType();
        boolean reusable = true;
        if (bindingType == 0) {
            this.initNew(false);
        } else if (bindingType == 104) {
            this.initNew(true);
            reusable = false;
        } else if (bindingType == 100) {
            this.initWithTexture((int)this.getBindingId());
        } else if (bindingType == 101) {
            this.initWithFbo((int)this.getBindingId());
        } else if (bindingType == 102) {
            this.initWithTexture((int)this.getBindingId());
        } else if (bindingType == 103) {
            this.initWithFbo((int)this.getBindingId());
        } else {
            throw new RuntimeException("Attempting to create GL frame with unknown binding type " + bindingType + "!");
        }
        this.setReusable(reusable);
    }

    private final void $$robo$$android_filterfw_core_GLFrame$initNew(boolean isExternal) {
        if (isExternal) {
            if (!this.nativeAllocateExternal(this.mGLEnvironment)) {
                throw new RuntimeException("Could not allocate external GL frame!");
            }
        } else if (!this.nativeAllocate(this.mGLEnvironment, this.getFormat().getWidth(), this.getFormat().getHeight())) {
            throw new RuntimeException("Could not allocate GL frame!");
        }
    }

    private final void $$robo$$android_filterfw_core_GLFrame$initWithTexture(int texId) {
        int height;
        int width = this.getFormat().getWidth();
        if (!this.nativeAllocateWithTexture(this.mGLEnvironment, texId, width, height = this.getFormat().getHeight())) {
            throw new RuntimeException("Could not allocate texture backed GL frame!");
        }
        this.mOwnsTexture = false;
        this.markReadOnly();
    }

    private final void $$robo$$android_filterfw_core_GLFrame$initWithFbo(int fboId) {
        int height;
        int width = this.getFormat().getWidth();
        if (!this.nativeAllocateWithFbo(this.mGLEnvironment, fboId, width, height = this.getFormat().getHeight())) {
            throw new RuntimeException("Could not allocate FBO backed GL frame!");
        }
    }

    private final void $$robo$$android_filterfw_core_GLFrame$flushGPU(String message) {
        StopWatchMap timer = GLFrameTimer.get();
        if (timer.LOG_MFF_RUNNING_TIMES) {
            timer.start("glFinish " + message);
            GLES20.glFinish();
            timer.stop("glFinish " + message);
        }
    }

    private final synchronized boolean $$robo$$android_filterfw_core_GLFrame$hasNativeAllocation() {
        return this.glFrameId != -1;
    }

    private final synchronized void $$robo$$android_filterfw_core_GLFrame$releaseNativeAllocation() {
        this.nativeDeallocate();
        this.glFrameId = -1;
    }

    private final GLEnvironment $$robo$$android_filterfw_core_GLFrame$getGLEnvironment() {
        return this.mGLEnvironment;
    }

    private final Object $$robo$$android_filterfw_core_GLFrame$getObjectValue() {
        this.assertGLEnvValid();
        return ByteBuffer.wrap(this.getNativeData());
    }

    private final void $$robo$$android_filterfw_core_GLFrame$setInts(int[] ints) {
        this.assertFrameMutable();
        this.assertGLEnvValid();
        if (!this.setNativeInts(ints)) {
            throw new RuntimeException("Could not set int values for GL frame!");
        }
    }

    private final int[] $$robo$$android_filterfw_core_GLFrame$getInts() {
        this.assertGLEnvValid();
        this.flushGPU("getInts");
        return this.getNativeInts();
    }

    private final void $$robo$$android_filterfw_core_GLFrame$setFloats(float[] floats) {
        this.assertFrameMutable();
        this.assertGLEnvValid();
        if (!this.setNativeFloats(floats)) {
            throw new RuntimeException("Could not set int values for GL frame!");
        }
    }

    private final float[] $$robo$$android_filterfw_core_GLFrame$getFloats() {
        this.assertGLEnvValid();
        this.flushGPU("getFloats");
        return this.getNativeFloats();
    }

    private final void $$robo$$android_filterfw_core_GLFrame$setData(ByteBuffer buffer, int offset, int length) {
        this.assertFrameMutable();
        this.assertGLEnvValid();
        byte[] bytes = buffer.array();
        if (this.getFormat().getSize() != bytes.length) {
            throw new RuntimeException("Data size in setData does not match GL frame size!");
        }
        if (!this.setNativeData(bytes, offset, length)) {
            throw new RuntimeException("Could not set GL frame data!");
        }
    }

    private final ByteBuffer $$robo$$android_filterfw_core_GLFrame$getData() {
        this.assertGLEnvValid();
        this.flushGPU("getData");
        return ByteBuffer.wrap(this.getNativeData());
    }

    private final void $$robo$$android_filterfw_core_GLFrame$setBitmap(Bitmap bitmap) {
        this.assertFrameMutable();
        this.assertGLEnvValid();
        if (this.getFormat().getWidth() != bitmap.getWidth() || this.getFormat().getHeight() != bitmap.getHeight()) {
            throw new RuntimeException("Bitmap dimensions do not match GL frame dimensions!");
        }
        Bitmap rgbaBitmap = GLFrame.convertBitmapToRGBA(bitmap);
        if (!this.setNativeBitmap(rgbaBitmap, rgbaBitmap.getByteCount())) {
            throw new RuntimeException("Could not set GL frame bitmap data!");
        }
    }

    private final Bitmap $$robo$$android_filterfw_core_GLFrame$getBitmap() {
        this.assertGLEnvValid();
        this.flushGPU("getBitmap");
        Bitmap result = Bitmap.createBitmap(this.getFormat().getWidth(), this.getFormat().getHeight(), Bitmap.Config.ARGB_8888);
        if (!this.getNativeBitmap(result)) {
            throw new RuntimeException("Could not get bitmap data from GL frame!");
        }
        return result;
    }

    private final void $$robo$$android_filterfw_core_GLFrame$setDataFromFrame(Frame frame) {
        this.assertGLEnvValid();
        if (this.getFormat().getSize() < frame.getFormat().getSize()) {
            throw new RuntimeException("Attempting to assign frame of size " + frame.getFormat().getSize() + " to " + "smaller GL frame of size " + this.getFormat().getSize() + "!");
        }
        if (frame instanceof NativeFrame) {
            this.nativeCopyFromNative((NativeFrame)frame);
        } else if (frame instanceof GLFrame) {
            this.nativeCopyFromGL((GLFrame)frame);
        } else if (frame instanceof SimpleFrame) {
            this.setObjectValue(frame.getObjectValue());
        } else {
            super.setDataFromFrame(frame);
        }
    }

    private final void $$robo$$android_filterfw_core_GLFrame$setViewport(int x, int y, int width, int height) {
        this.assertFrameMutable();
        this.setNativeViewport(x, y, width, height);
    }

    private final void $$robo$$android_filterfw_core_GLFrame$setViewport(Rect rect) {
        this.assertFrameMutable();
        this.setNativeViewport(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    private final void $$robo$$android_filterfw_core_GLFrame$generateMipMap() {
        this.assertFrameMutable();
        this.assertGLEnvValid();
        if (!this.generateNativeMipMap()) {
            throw new RuntimeException("Could not generate mip-map for GL frame!");
        }
    }

    private final void $$robo$$android_filterfw_core_GLFrame$setTextureParameter(int param, int value) {
        this.assertFrameMutable();
        this.assertGLEnvValid();
        if (!this.setNativeTextureParam(param, value)) {
            throw new RuntimeException("Could not set texture value " + param + " = " + value + " " + "for GLFrame!");
        }
    }

    private final int $$robo$$android_filterfw_core_GLFrame$getTextureId() {
        return this.getNativeTextureId();
    }

    private final int $$robo$$android_filterfw_core_GLFrame$getFboId() {
        return this.getNativeFboId();
    }

    private final void $$robo$$android_filterfw_core_GLFrame$focus() {
        if (!this.nativeFocus()) {
            throw new RuntimeException("Could not focus on GLFrame for drawing!");
        }
    }

    private final String $$robo$$android_filterfw_core_GLFrame$toString() {
        return "GLFrame id: " + this.glFrameId + " (" + this.getFormat() + ") with texture ID " + this.getTextureId() + ", FBO ID " + this.getFboId();
    }

    private final void $$robo$$android_filterfw_core_GLFrame$reset(FrameFormat newFormat) {
        if (!this.nativeResetParams()) {
            throw new RuntimeException("Could not reset GLFrame texture parameters!");
        }
        super.reset(newFormat);
    }

    private final void $$robo$$android_filterfw_core_GLFrame$onFrameStore() {
        if (!this.mOwnsTexture) {
            this.nativeDetachTexFromFbo();
        }
    }

    private final void $$robo$$android_filterfw_core_GLFrame$onFrameFetch() {
        if (!this.mOwnsTexture) {
            this.nativeReattachTexToFbo();
        }
    }

    private final void $$robo$$android_filterfw_core_GLFrame$assertGLEnvValid() {
        if (!this.mGLEnvironment.isContextActive()) {
            if (GLEnvironment.isAnyContextActive()) {
                throw new RuntimeException("Attempting to access " + this + " with foreign GL " + "context active!");
            }
            throw new RuntimeException("Attempting to access " + this + " with no GL context " + " active!");
        }
    }

    private final boolean $$robo$$android_filterfw_core_GLFrame$nativeAllocate(GLEnvironment gLEnvironment, int n, int n2) {
        return false;
    }

    private final boolean $$robo$$android_filterfw_core_GLFrame$nativeAllocateWithTexture(GLEnvironment gLEnvironment, int n, int n2, int n3) {
        return false;
    }

    private final boolean $$robo$$android_filterfw_core_GLFrame$nativeAllocateWithFbo(GLEnvironment gLEnvironment, int n, int n2, int n3) {
        return false;
    }

    private final boolean $$robo$$android_filterfw_core_GLFrame$nativeAllocateExternal(GLEnvironment gLEnvironment) {
        return false;
    }

    private final boolean $$robo$$android_filterfw_core_GLFrame$nativeDeallocate() {
        return false;
    }

    private final boolean $$robo$$android_filterfw_core_GLFrame$setNativeData(byte[] byArray, int n, int n2) {
        return false;
    }

    private final byte[] $$robo$$android_filterfw_core_GLFrame$getNativeData() {
        return null;
    }

    private final boolean $$robo$$android_filterfw_core_GLFrame$setNativeInts(int[] nArray) {
        return false;
    }

    private final boolean $$robo$$android_filterfw_core_GLFrame$setNativeFloats(float[] fArray) {
        return false;
    }

    private final int[] $$robo$$android_filterfw_core_GLFrame$getNativeInts() {
        return null;
    }

    private final float[] $$robo$$android_filterfw_core_GLFrame$getNativeFloats() {
        return null;
    }

    private final boolean $$robo$$android_filterfw_core_GLFrame$setNativeBitmap(Bitmap bitmap, int n) {
        return false;
    }

    private final boolean $$robo$$android_filterfw_core_GLFrame$getNativeBitmap(Bitmap bitmap) {
        return false;
    }

    private final boolean $$robo$$android_filterfw_core_GLFrame$setNativeViewport(int n, int n2, int n3, int n4) {
        return false;
    }

    private final int $$robo$$android_filterfw_core_GLFrame$getNativeTextureId() {
        return 0;
    }

    private final int $$robo$$android_filterfw_core_GLFrame$getNativeFboId() {
        return 0;
    }

    private final boolean $$robo$$android_filterfw_core_GLFrame$generateNativeMipMap() {
        return false;
    }

    private final boolean $$robo$$android_filterfw_core_GLFrame$setNativeTextureParam(int n, int n2) {
        return false;
    }

    private final boolean $$robo$$android_filterfw_core_GLFrame$nativeResetParams() {
        return false;
    }

    private final boolean $$robo$$android_filterfw_core_GLFrame$nativeCopyFromNative(NativeFrame nativeFrame) {
        return false;
    }

    private final boolean $$robo$$android_filterfw_core_GLFrame$nativeCopyFromGL(GLFrame gLFrame) {
        return false;
    }

    private final boolean $$robo$$android_filterfw_core_GLFrame$nativeFocus() {
        return false;
    }

    private final boolean $$robo$$android_filterfw_core_GLFrame$nativeReattachTexToFbo() {
        return false;
    }

    private final boolean $$robo$$android_filterfw_core_GLFrame$nativeDetachTexFromFbo() {
        return false;
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"filterfw");
    }

    private void __constructor__(FrameFormat frameFormat, FrameManager frameManager) {
        this.$$robo$$android_filterfw_core_GLFrame$__constructor__(frameFormat, frameManager);
    }

    GLFrame(FrameFormat frameFormat, FrameManager frameManager) {
        super(frameFormat, frameManager);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterfw_core_GLFrame$__constructor__(android.filterfw.core.FrameFormat android.filterfw.core.FrameManager ), 0, this, frameFormat, frameManager);
    }

    private void __constructor__(FrameFormat frameFormat, FrameManager frameManager, int n, long l) {
        this.$$robo$$android_filterfw_core_GLFrame$__constructor__(frameFormat, frameManager, n, l);
    }

    GLFrame(FrameFormat frameFormat, FrameManager frameManager, int n, long l) {
        super(frameFormat, frameManager, n, l);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterfw_core_GLFrame$__constructor__(android.filterfw.core.FrameFormat android.filterfw.core.FrameManager int long ), 0, this, frameFormat, frameManager, n, l);
    }

    void init(GLEnvironment gLEnvironment) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_filterfw_core_GLFrame$init(android.filterfw.core.GLEnvironment ), 0, this, gLEnvironment);
    }

    private void initNew(boolean bl) {
        InvokeDynamicSupport.bootstrap("initNew", $$robo$$android_filterfw_core_GLFrame$initNew(boolean ), 0, this, bl);
    }

    private void initWithTexture(int n) {
        InvokeDynamicSupport.bootstrap("initWithTexture", $$robo$$android_filterfw_core_GLFrame$initWithTexture(int ), 0, this, n);
    }

    private void initWithFbo(int n) {
        InvokeDynamicSupport.bootstrap("initWithFbo", $$robo$$android_filterfw_core_GLFrame$initWithFbo(int ), 0, this, n);
    }

    void flushGPU(String string2) {
        InvokeDynamicSupport.bootstrap("flushGPU", $$robo$$android_filterfw_core_GLFrame$flushGPU(java.lang.String ), 0, this, string2);
    }

    @Override
    protected synchronized boolean hasNativeAllocation() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasNativeAllocation", $$robo$$android_filterfw_core_GLFrame$hasNativeAllocation(), 0, this);
    }

    @Override
    protected synchronized void releaseNativeAllocation() {
        InvokeDynamicSupport.bootstrap("releaseNativeAllocation", $$robo$$android_filterfw_core_GLFrame$releaseNativeAllocation(), 0, this);
    }

    public GLEnvironment getGLEnvironment() {
        return InvokeDynamicSupport.bootstrap("getGLEnvironment", $$robo$$android_filterfw_core_GLFrame$getGLEnvironment(), 0, this);
    }

    @Override
    public Object getObjectValue() {
        return InvokeDynamicSupport.bootstrap("getObjectValue", $$robo$$android_filterfw_core_GLFrame$getObjectValue(), 0, this);
    }

    @Override
    public void setInts(int[] nArray) {
        InvokeDynamicSupport.bootstrap("setInts", $$robo$$android_filterfw_core_GLFrame$setInts(int[] ), 0, this, nArray);
    }

    @Override
    public int[] getInts() {
        return InvokeDynamicSupport.bootstrap("getInts", $$robo$$android_filterfw_core_GLFrame$getInts(), 0, this);
    }

    @Override
    public void setFloats(float[] fArray) {
        InvokeDynamicSupport.bootstrap("setFloats", $$robo$$android_filterfw_core_GLFrame$setFloats(float[] ), 0, this, fArray);
    }

    @Override
    public float[] getFloats() {
        return InvokeDynamicSupport.bootstrap("getFloats", $$robo$$android_filterfw_core_GLFrame$getFloats(), 0, this);
    }

    @Override
    public void setData(ByteBuffer byteBuffer, int n, int n2) {
        InvokeDynamicSupport.bootstrap("setData", $$robo$$android_filterfw_core_GLFrame$setData(java.nio.ByteBuffer int int ), 0, this, byteBuffer, n, n2);
    }

    @Override
    public ByteBuffer getData() {
        return InvokeDynamicSupport.bootstrap("getData", $$robo$$android_filterfw_core_GLFrame$getData(), 0, this);
    }

    @Override
    public void setBitmap(Bitmap bitmap) {
        InvokeDynamicSupport.bootstrap("setBitmap", $$robo$$android_filterfw_core_GLFrame$setBitmap(android.graphics.Bitmap ), 0, this, bitmap);
    }

    @Override
    public Bitmap getBitmap() {
        return InvokeDynamicSupport.bootstrap("getBitmap", $$robo$$android_filterfw_core_GLFrame$getBitmap(), 0, this);
    }

    @Override
    public void setDataFromFrame(Frame frame) {
        InvokeDynamicSupport.bootstrap("setDataFromFrame", $$robo$$android_filterfw_core_GLFrame$setDataFromFrame(android.filterfw.core.Frame ), 0, this, frame);
    }

    public void setViewport(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setViewport", $$robo$$android_filterfw_core_GLFrame$setViewport(int int int int ), 0, this, n, n2, n3, n4);
    }

    public void setViewport(Rect rect) {
        InvokeDynamicSupport.bootstrap("setViewport", $$robo$$android_filterfw_core_GLFrame$setViewport(android.graphics.Rect ), 0, this, rect);
    }

    public void generateMipMap() {
        InvokeDynamicSupport.bootstrap("generateMipMap", $$robo$$android_filterfw_core_GLFrame$generateMipMap(), 0, this);
    }

    public void setTextureParameter(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setTextureParameter", $$robo$$android_filterfw_core_GLFrame$setTextureParameter(int int ), 0, this, n, n2);
    }

    public int getTextureId() {
        return (int)InvokeDynamicSupport.bootstrap("getTextureId", $$robo$$android_filterfw_core_GLFrame$getTextureId(), 0, this);
    }

    public int getFboId() {
        return (int)InvokeDynamicSupport.bootstrap("getFboId", $$robo$$android_filterfw_core_GLFrame$getFboId(), 0, this);
    }

    public void focus() {
        InvokeDynamicSupport.bootstrap("focus", $$robo$$android_filterfw_core_GLFrame$focus(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_filterfw_core_GLFrame$toString(), 0, this);
    }

    @Override
    protected void reset(FrameFormat frameFormat) {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_filterfw_core_GLFrame$reset(android.filterfw.core.FrameFormat ), 0, this, frameFormat);
    }

    @Override
    protected void onFrameStore() {
        InvokeDynamicSupport.bootstrap("onFrameStore", $$robo$$android_filterfw_core_GLFrame$onFrameStore(), 0, this);
    }

    @Override
    protected void onFrameFetch() {
        InvokeDynamicSupport.bootstrap("onFrameFetch", $$robo$$android_filterfw_core_GLFrame$onFrameFetch(), 0, this);
    }

    private void assertGLEnvValid() {
        InvokeDynamicSupport.bootstrap("assertGLEnvValid", $$robo$$android_filterfw_core_GLFrame$assertGLEnvValid(), 0, this);
    }

    private final native /* synthetic */ boolean $$robo$$nativeAllocate$nativeBinding(GLEnvironment var1, int var2, int var3);

    private boolean nativeAllocate(GLEnvironment gLEnvironment, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("nativeAllocate", $$robo$$android_filterfw_core_GLFrame$nativeAllocate(android.filterfw.core.GLEnvironment int int ), 1, this, gLEnvironment, n, n2);
    }

    private final native /* synthetic */ boolean $$robo$$nativeAllocateWithTexture$nativeBinding(GLEnvironment var1, int var2, int var3, int var4);

    private boolean nativeAllocateWithTexture(GLEnvironment gLEnvironment, int n, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("nativeAllocateWithTexture", $$robo$$android_filterfw_core_GLFrame$nativeAllocateWithTexture(android.filterfw.core.GLEnvironment int int int ), 1, this, gLEnvironment, n, n2, n3);
    }

    private final native /* synthetic */ boolean $$robo$$nativeAllocateWithFbo$nativeBinding(GLEnvironment var1, int var2, int var3, int var4);

    private boolean nativeAllocateWithFbo(GLEnvironment gLEnvironment, int n, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("nativeAllocateWithFbo", $$robo$$android_filterfw_core_GLFrame$nativeAllocateWithFbo(android.filterfw.core.GLEnvironment int int int ), 1, this, gLEnvironment, n, n2, n3);
    }

    private final native /* synthetic */ boolean $$robo$$nativeAllocateExternal$nativeBinding(GLEnvironment var1);

    private boolean nativeAllocateExternal(GLEnvironment gLEnvironment) {
        return (boolean)InvokeDynamicSupport.bootstrap("nativeAllocateExternal", $$robo$$android_filterfw_core_GLFrame$nativeAllocateExternal(android.filterfw.core.GLEnvironment ), 1, this, gLEnvironment);
    }

    private final native /* synthetic */ boolean $$robo$$nativeDeallocate$nativeBinding();

    private boolean nativeDeallocate() {
        return (boolean)InvokeDynamicSupport.bootstrap("nativeDeallocate", $$robo$$android_filterfw_core_GLFrame$nativeDeallocate(), 1, this);
    }

    private final native /* synthetic */ boolean $$robo$$setNativeData$nativeBinding(byte[] var1, int var2, int var3);

    private boolean setNativeData(byte[] byArray, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setNativeData", $$robo$$android_filterfw_core_GLFrame$setNativeData(byte[] int int ), 1, this, byArray, n, n2);
    }

    private final native /* synthetic */ byte[] $$robo$$getNativeData$nativeBinding();

    private byte[] getNativeData() {
        return InvokeDynamicSupport.bootstrap("getNativeData", $$robo$$android_filterfw_core_GLFrame$getNativeData(), 1, this);
    }

    private final native /* synthetic */ boolean $$robo$$setNativeInts$nativeBinding(int[] var1);

    private boolean setNativeInts(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("setNativeInts", $$robo$$android_filterfw_core_GLFrame$setNativeInts(int[] ), 1, this, nArray);
    }

    private final native /* synthetic */ boolean $$robo$$setNativeFloats$nativeBinding(float[] var1);

    private boolean setNativeFloats(float[] fArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("setNativeFloats", $$robo$$android_filterfw_core_GLFrame$setNativeFloats(float[] ), 1, this, fArray);
    }

    private final native /* synthetic */ int[] $$robo$$getNativeInts$nativeBinding();

    private int[] getNativeInts() {
        return InvokeDynamicSupport.bootstrap("getNativeInts", $$robo$$android_filterfw_core_GLFrame$getNativeInts(), 1, this);
    }

    private final native /* synthetic */ float[] $$robo$$getNativeFloats$nativeBinding();

    private float[] getNativeFloats() {
        return InvokeDynamicSupport.bootstrap("getNativeFloats", $$robo$$android_filterfw_core_GLFrame$getNativeFloats(), 1, this);
    }

    private final native /* synthetic */ boolean $$robo$$setNativeBitmap$nativeBinding(Bitmap var1, int var2);

    private boolean setNativeBitmap(Bitmap bitmap, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setNativeBitmap", $$robo$$android_filterfw_core_GLFrame$setNativeBitmap(android.graphics.Bitmap int ), 1, this, bitmap, n);
    }

    private final native /* synthetic */ boolean $$robo$$getNativeBitmap$nativeBinding(Bitmap var1);

    private boolean getNativeBitmap(Bitmap bitmap) {
        return (boolean)InvokeDynamicSupport.bootstrap("getNativeBitmap", $$robo$$android_filterfw_core_GLFrame$getNativeBitmap(android.graphics.Bitmap ), 1, this, bitmap);
    }

    private final native /* synthetic */ boolean $$robo$$setNativeViewport$nativeBinding(int var1, int var2, int var3, int var4);

    private boolean setNativeViewport(int n, int n2, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrap("setNativeViewport", $$robo$$android_filterfw_core_GLFrame$setNativeViewport(int int int int ), 1, this, n, n2, n3, n4);
    }

    private final native /* synthetic */ int $$robo$$getNativeTextureId$nativeBinding();

    private int getNativeTextureId() {
        return (int)InvokeDynamicSupport.bootstrap("getNativeTextureId", $$robo$$android_filterfw_core_GLFrame$getNativeTextureId(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$getNativeFboId$nativeBinding();

    private int getNativeFboId() {
        return (int)InvokeDynamicSupport.bootstrap("getNativeFboId", $$robo$$android_filterfw_core_GLFrame$getNativeFboId(), 1, this);
    }

    private final native /* synthetic */ boolean $$robo$$generateNativeMipMap$nativeBinding();

    private boolean generateNativeMipMap() {
        return (boolean)InvokeDynamicSupport.bootstrap("generateNativeMipMap", $$robo$$android_filterfw_core_GLFrame$generateNativeMipMap(), 1, this);
    }

    private final native /* synthetic */ boolean $$robo$$setNativeTextureParam$nativeBinding(int var1, int var2);

    private boolean setNativeTextureParam(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setNativeTextureParam", $$robo$$android_filterfw_core_GLFrame$setNativeTextureParam(int int ), 1, this, n, n2);
    }

    private final native /* synthetic */ boolean $$robo$$nativeResetParams$nativeBinding();

    private boolean nativeResetParams() {
        return (boolean)InvokeDynamicSupport.bootstrap("nativeResetParams", $$robo$$android_filterfw_core_GLFrame$nativeResetParams(), 1, this);
    }

    private final native /* synthetic */ boolean $$robo$$nativeCopyFromNative$nativeBinding(NativeFrame var1);

    private boolean nativeCopyFromNative(NativeFrame nativeFrame) {
        return (boolean)InvokeDynamicSupport.bootstrap("nativeCopyFromNative", $$robo$$android_filterfw_core_GLFrame$nativeCopyFromNative(android.filterfw.core.NativeFrame ), 1, this, nativeFrame);
    }

    private final native /* synthetic */ boolean $$robo$$nativeCopyFromGL$nativeBinding(GLFrame var1);

    private boolean nativeCopyFromGL(GLFrame gLFrame) {
        return (boolean)InvokeDynamicSupport.bootstrap("nativeCopyFromGL", $$robo$$android_filterfw_core_GLFrame$nativeCopyFromGL(android.filterfw.core.GLFrame ), 1, this, gLFrame);
    }

    private final native /* synthetic */ boolean $$robo$$nativeFocus$nativeBinding();

    private boolean nativeFocus() {
        return (boolean)InvokeDynamicSupport.bootstrap("nativeFocus", $$robo$$android_filterfw_core_GLFrame$nativeFocus(), 1, this);
    }

    private final native /* synthetic */ boolean $$robo$$nativeReattachTexToFbo$nativeBinding();

    private boolean nativeReattachTexToFbo() {
        return (boolean)InvokeDynamicSupport.bootstrap("nativeReattachTexToFbo", $$robo$$android_filterfw_core_GLFrame$nativeReattachTexToFbo(), 1, this);
    }

    private final native /* synthetic */ boolean $$robo$$nativeDetachTexFromFbo$nativeBinding();

    private boolean nativeDetachTexFromFbo() {
        return (boolean)InvokeDynamicSupport.bootstrap("nativeDetachTexFromFbo", $$robo$$android_filterfw_core_GLFrame$nativeDetachTexFromFbo(), 1, this);
    }

    static {
        RobolectricInternals.classInitializing(GLFrame.class);
    }

    public /* synthetic */ GLFrame() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GLFrame)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

