/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.Program;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.filterfw.format.ObjectFormat;
import android.filterfw.geometry.Quad;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CropFilter
extends Filter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Program mProgram;
    private FrameFormat mLastFormat;
    @GenerateFieldPort(name="owidth")
    private int mOutputWidth;
    @GenerateFieldPort(name="oheight")
    private int mOutputHeight;
    @GenerateFieldPort(name="fillblack")
    private boolean mFillBlack;
    private String mFragShader = "precision mediump float;\nuniform sampler2D tex_sampler_0;\nvarying vec2 v_texcoord;\nvoid main() {\n  const vec2 lo = vec2(0.0, 0.0);\n  const vec2 hi = vec2(1.0, 1.0);\n  const vec4 black = vec4(0.0, 0.0, 0.0, 1.0);\n  bool out_of_bounds =\n    any(lessThan(v_texcoord, lo)) ||\n    any(greaterThan(v_texcoord, hi));\n  if (out_of_bounds) {\n    gl_FragColor = black;\n  } else {\n    gl_FragColor = texture2D(tex_sampler_0, v_texcoord);\n  }\n}\n";

    private void $$robo$$android_filterpacks_imageproc_CropFilter$__constructor__(String name) {
        this.mLastFormat = null;
        this.mOutputWidth = -1;
        this.mOutputHeight = -1;
        this.mFillBlack = false;
        this.mFragShader = "precision mediump float;\nuniform sampler2D tex_sampler_0;\nvarying vec2 v_texcoord;\nvoid main() {\n  const vec2 lo = vec2(0.0, 0.0);\n  const vec2 hi = vec2(1.0, 1.0);\n  const vec4 black = vec4(0.0, 0.0, 0.0, 1.0);\n  bool out_of_bounds =\n    any(lessThan(v_texcoord, lo)) ||\n    any(greaterThan(v_texcoord, hi));\n  if (out_of_bounds) {\n    gl_FragColor = black;\n  } else {\n    gl_FragColor = texture2D(tex_sampler_0, v_texcoord);\n  }\n}\n";
    }

    private final void $$robo$$android_filterpacks_imageproc_CropFilter$setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3));
        this.addMaskedInputPort("box", ObjectFormat.fromClass(Quad.class, 1));
        this.addOutputBasedOnInput("image", "image");
    }

    private final FrameFormat $$robo$$android_filterpacks_imageproc_CropFilter$getOutputFormat(String portName, FrameFormat inputFormat) {
        MutableFrameFormat outputFormat = inputFormat.mutableCopy();
        outputFormat.setDimensions(0, 0);
        return outputFormat;
    }

    private final void $$robo$$android_filterpacks_imageproc_CropFilter$createProgram(FilterContext context, FrameFormat format) {
        if (this.mLastFormat != null && this.mLastFormat.getTarget() == format.getTarget()) {
            return;
        }
        this.mLastFormat = format;
        this.mProgram = null;
        switch (format.getTarget()) {
            case 3: {
                this.mProgram = this.mFillBlack ? new ShaderProgram(context, "precision mediump float;\nuniform sampler2D tex_sampler_0;\nvarying vec2 v_texcoord;\nvoid main() {\n  const vec2 lo = vec2(0.0, 0.0);\n  const vec2 hi = vec2(1.0, 1.0);\n  const vec4 black = vec4(0.0, 0.0, 0.0, 1.0);\n  bool out_of_bounds =\n    any(lessThan(v_texcoord, lo)) ||\n    any(greaterThan(v_texcoord, hi));\n  if (out_of_bounds) {\n    gl_FragColor = black;\n  } else {\n    gl_FragColor = texture2D(tex_sampler_0, v_texcoord);\n  }\n}\n") : ShaderProgram.createIdentity(context);
            }
        }
        if (this.mProgram == null) {
            throw new RuntimeException("Could not create a program for crop filter " + this + "!");
        }
    }

    private final void $$robo$$android_filterpacks_imageproc_CropFilter$process(FilterContext env) {
        Frame imageFrame = this.pullInput("image");
        Frame boxFrame = this.pullInput("box");
        this.createProgram(env, imageFrame.getFormat());
        Quad box = (Quad)boxFrame.getObjectValue();
        MutableFrameFormat outputFormat = imageFrame.getFormat().mutableCopy();
        outputFormat.setDimensions(this.mOutputWidth == -1 ? outputFormat.getWidth() : this.mOutputWidth, this.mOutputHeight == -1 ? outputFormat.getHeight() : this.mOutputHeight);
        Frame output = env.getFrameManager().newFrame(outputFormat);
        if (this.mProgram instanceof ShaderProgram) {
            ShaderProgram shaderProgram = (ShaderProgram)this.mProgram;
            shaderProgram.setSourceRegion(box);
        }
        this.mProgram.process(imageFrame, output);
        this.pushOutput("image", output);
        output.release();
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_filterpacks_imageproc_CropFilter$__constructor__(string2);
    }

    public CropFilter(String string2) {
        super(string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterpacks_imageproc_CropFilter$__constructor__(java.lang.String ), 0, this, string2);
    }

    @Override
    public void setupPorts() {
        InvokeDynamicSupport.bootstrap("setupPorts", $$robo$$android_filterpacks_imageproc_CropFilter$setupPorts(), 0, this);
    }

    @Override
    public FrameFormat getOutputFormat(String string2, FrameFormat frameFormat) {
        return InvokeDynamicSupport.bootstrap("getOutputFormat", $$robo$$android_filterpacks_imageproc_CropFilter$getOutputFormat(java.lang.String android.filterfw.core.FrameFormat ), 0, this, string2, frameFormat);
    }

    protected void createProgram(FilterContext filterContext, FrameFormat frameFormat) {
        InvokeDynamicSupport.bootstrap("createProgram", $$robo$$android_filterpacks_imageproc_CropFilter$createProgram(android.filterfw.core.FilterContext android.filterfw.core.FrameFormat ), 0, this, filterContext, frameFormat);
    }

    @Override
    public void process(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("process", $$robo$$android_filterpacks_imageproc_CropFilter$process(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    public /* synthetic */ CropFilter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CropFilter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

