/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.videosrc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.GLFrame;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.GenerateFinalPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.opengl.Matrix;
import android.util.Log;
import java.io.IOException;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CameraSource
extends Filter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    @GenerateFieldPort(name="id", hasDefault=true)
    private int mCameraId;
    @GenerateFieldPort(name="width", hasDefault=true)
    private int mWidth;
    @GenerateFieldPort(name="height", hasDefault=true)
    private int mHeight;
    @GenerateFieldPort(name="framerate", hasDefault=true)
    private int mFps;
    @GenerateFinalPort(name="waitForNewFrame", hasDefault=true)
    private boolean mWaitForNewFrame;
    private Camera mCamera;
    private GLFrame mCameraFrame;
    private SurfaceTexture mSurfaceTexture;
    private ShaderProgram mFrameExtractor;
    private MutableFrameFormat mOutputFormat;
    private float[] mCameraTransform;
    private float[] mMappedCoords;
    private static float[] mSourceCoords;
    private static int NEWFRAME_TIMEOUT = 100;
    private static int NEWFRAME_TIMEOUT_REPEAT = 10;
    private boolean mNewFrameAvailable;
    private Camera.Parameters mCameraParameters;
    private static String mFrameShader = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES tex_sampler_0;\nvarying vec2 v_texcoord;\nvoid main() {\n  gl_FragColor = texture2D(tex_sampler_0, v_texcoord);\n}\n";
    private boolean mLogVerbose;
    private static String TAG = "CameraSource";
    private SurfaceTexture.OnFrameAvailableListener onCameraFrameAvailableListener;

    private void $$robo$$android_filterpacks_videosrc_CameraSource$__constructor__(String name) {
        this.mCameraId = 0;
        this.mWidth = 320;
        this.mHeight = 240;
        this.mFps = 30;
        this.mWaitForNewFrame = true;
        this.onCameraFrameAvailableListener = new SurfaceTexture.OnFrameAvailableListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CameraSource this$0;

            private void $$robo$$android_filterpacks_videosrc_CameraSource_1$__constructor__(CameraSource cameraSource) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_filterpacks_videosrc_CameraSource_1$onFrameAvailable(SurfaceTexture surfaceTexture) {
                if (this.this$0.mLogVerbose) {
                    Log.v("CameraSource", "New frame from camera");
                }
                CameraSource cameraSource = this.this$0;
                synchronized (cameraSource) {
                    this.this$0.mNewFrameAvailable = true;
                    this.this$0.notify();
                }
            }

            private void __constructor__(CameraSource cameraSource) {
                this.$$robo$$android_filterpacks_videosrc_CameraSource_1$__constructor__(cameraSource);
            }
            {
                this.this$0 = cameraSource;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterpacks_videosrc_CameraSource_1$__constructor__(android.filterpacks.videosrc.CameraSource ), 0, this, cameraSource);
            }

            @Override
            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                InvokeDynamicSupport.bootstrap("onFrameAvailable", $$robo$$android_filterpacks_videosrc_CameraSource_1$onFrameAvailable(android.graphics.SurfaceTexture ), 0, this, surfaceTexture);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCameraTransform = new float[16];
        this.mMappedCoords = new float[16];
        this.mLogVerbose = Log.isLoggable("CameraSource", 2);
    }

    private final void $$robo$$android_filterpacks_videosrc_CameraSource$setupPorts() {
        this.addOutputPort("video", ImageFormat.create(3, 3));
    }

    private final void $$robo$$android_filterpacks_videosrc_CameraSource$createFormats() {
        this.mOutputFormat = ImageFormat.create(this.mWidth, this.mHeight, 3, 3);
    }

    private final void $$robo$$android_filterpacks_videosrc_CameraSource$prepare(FilterContext context) {
        if (this.mLogVerbose) {
            Log.v("CameraSource", "Preparing");
        }
        this.mFrameExtractor = new ShaderProgram(context, "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES tex_sampler_0;\nvarying vec2 v_texcoord;\nvoid main() {\n  gl_FragColor = texture2D(tex_sampler_0, v_texcoord);\n}\n");
    }

    private final void $$robo$$android_filterpacks_videosrc_CameraSource$open(FilterContext context) {
        if (this.mLogVerbose) {
            Log.v("CameraSource", "Opening");
        }
        this.mCamera = Camera.open(this.mCameraId);
        this.getCameraParameters();
        this.mCamera.setParameters(this.mCameraParameters);
        this.createFormats();
        this.mCameraFrame = (GLFrame)context.getFrameManager().newBoundFrame(this.mOutputFormat, 104, 0L);
        this.mSurfaceTexture = new SurfaceTexture(this.mCameraFrame.getTextureId());
        try {
            this.mCamera.setPreviewTexture(this.mSurfaceTexture);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not bind camera surface texture: " + e.getMessage() + "!");
        }
        this.mSurfaceTexture.setOnFrameAvailableListener(this.onCameraFrameAvailableListener);
        this.mNewFrameAvailable = false;
        this.mCamera.startPreview();
    }

    private final void $$robo$$android_filterpacks_videosrc_CameraSource$process(FilterContext context) {
        if (this.mLogVerbose) {
            Log.v("CameraSource", "Processing new frame");
        }
        if (this.mWaitForNewFrame) {
            int waitCount = 0;
            while (!this.mNewFrameAvailable) {
                if (waitCount == 10) {
                    throw new RuntimeException("Timeout waiting for new frame");
                }
                try {
                    this.wait(100L);
                }
                catch (InterruptedException e) {
                    if (!this.mLogVerbose) continue;
                    Log.v("CameraSource", "Interrupted while waiting for new frame");
                }
            }
            this.mNewFrameAvailable = false;
            if (this.mLogVerbose) {
                Log.v("CameraSource", "Got new frame");
            }
        }
        this.mSurfaceTexture.updateTexImage();
        if (this.mLogVerbose) {
            Log.v("CameraSource", "Using frame extractor in thread: " + Thread.currentThread());
        }
        this.mSurfaceTexture.getTransformMatrix(this.mCameraTransform);
        Matrix.multiplyMM(this.mMappedCoords, 0, this.mCameraTransform, 0, mSourceCoords, 0);
        this.mFrameExtractor.setSourceRegion(this.mMappedCoords[0], this.mMappedCoords[1], this.mMappedCoords[4], this.mMappedCoords[5], this.mMappedCoords[8], this.mMappedCoords[9], this.mMappedCoords[12], this.mMappedCoords[13]);
        Frame output = context.getFrameManager().newFrame(this.mOutputFormat);
        this.mFrameExtractor.process(this.mCameraFrame, output);
        long timestamp = this.mSurfaceTexture.getTimestamp();
        if (this.mLogVerbose) {
            Log.v("CameraSource", "Timestamp: " + (double)timestamp / 1.0E9 + " s");
        }
        output.setTimestamp(timestamp);
        this.pushOutput("video", output);
        output.release();
        if (this.mLogVerbose) {
            Log.v("CameraSource", "Done processing new frame");
        }
    }

    private final void $$robo$$android_filterpacks_videosrc_CameraSource$close(FilterContext context) {
        if (this.mLogVerbose) {
            Log.v("CameraSource", "Closing");
        }
        this.mCamera.release();
        this.mCamera = null;
        this.mSurfaceTexture.release();
        this.mSurfaceTexture = null;
    }

    private final void $$robo$$android_filterpacks_videosrc_CameraSource$tearDown(FilterContext context) {
        if (this.mCameraFrame != null) {
            this.mCameraFrame.release();
        }
    }

    private final void $$robo$$android_filterpacks_videosrc_CameraSource$fieldPortValueUpdated(String name, FilterContext context) {
        if (name.equals("framerate")) {
            this.getCameraParameters();
            int[] closestRange = this.findClosestFpsRange(this.mFps, this.mCameraParameters);
            this.mCameraParameters.setPreviewFpsRange(closestRange[0], closestRange[1]);
            this.mCamera.setParameters(this.mCameraParameters);
        }
    }

    private final synchronized Camera.Parameters $$robo$$android_filterpacks_videosrc_CameraSource$getCameraParameters() {
        boolean closeCamera = false;
        if (this.mCameraParameters == null) {
            if (this.mCamera == null) {
                this.mCamera = Camera.open(this.mCameraId);
                closeCamera = true;
            }
            this.mCameraParameters = this.mCamera.getParameters();
            if (closeCamera) {
                this.mCamera.release();
                this.mCamera = null;
            }
        }
        int[] closestSize = this.findClosestSize(this.mWidth, this.mHeight, this.mCameraParameters);
        this.mWidth = closestSize[0];
        this.mHeight = closestSize[1];
        this.mCameraParameters.setPreviewSize(this.mWidth, this.mHeight);
        int[] closestRange = this.findClosestFpsRange(this.mFps, this.mCameraParameters);
        this.mCameraParameters.setPreviewFpsRange(closestRange[0], closestRange[1]);
        return this.mCameraParameters;
    }

    private final synchronized void $$robo$$android_filterpacks_videosrc_CameraSource$setCameraParameters(Camera.Parameters params) {
        params.setPreviewSize(this.mWidth, this.mHeight);
        this.mCameraParameters = params;
        if (this.isOpen()) {
            this.mCamera.setParameters(this.mCameraParameters);
        }
    }

    private final int[] $$robo$$android_filterpacks_videosrc_CameraSource$findClosestSize(int width, int height, Camera.Parameters parameters) {
        List<Camera.Size> previewSizes = parameters.getSupportedPreviewSizes();
        int closestWidth = -1;
        int closestHeight = -1;
        int smallestWidth = previewSizes.get((int)0).width;
        int smallestHeight = previewSizes.get((int)0).height;
        for (Camera.Size size : previewSizes) {
            if (size.width <= width && size.height <= height && size.width >= closestWidth && size.height >= closestHeight) {
                closestWidth = size.width;
                closestHeight = size.height;
            }
            if (size.width >= smallestWidth || size.height >= smallestHeight) continue;
            smallestWidth = size.width;
            smallestHeight = size.height;
        }
        if (closestWidth == -1) {
            closestWidth = smallestWidth;
            closestHeight = smallestHeight;
        }
        if (this.mLogVerbose) {
            Log.v("CameraSource", "Requested resolution: (" + width + ", " + height + "). Closest match: (" + closestWidth + ", " + closestHeight + ").");
        }
        int[] closestSize = new int[]{closestWidth, closestHeight};
        return closestSize;
    }

    private final int[] $$robo$$android_filterpacks_videosrc_CameraSource$findClosestFpsRange(int fps, Camera.Parameters params) {
        List<int[]> supportedFpsRanges = params.getSupportedPreviewFpsRange();
        int[] closestRange = supportedFpsRanges.get(0);
        for (int[] range : supportedFpsRanges) {
            if (range[0] >= fps * 1000 || range[1] <= fps * 1000 || range[0] <= closestRange[0] || range[1] >= closestRange[1]) continue;
            closestRange = range;
        }
        if (this.mLogVerbose) {
            Log.v("CameraSource", "Requested fps: " + fps + ".Closest frame rate range: [" + (double)closestRange[0] / 1000.0 + "," + (double)closestRange[1] / 1000.0 + "]");
        }
        return closestRange;
    }

    static void __staticInitializer__() {
        mSourceCoords = new float[]{0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f};
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_filterpacks_videosrc_CameraSource$__constructor__(string2);
    }

    public CameraSource(String string2) {
        super(string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterpacks_videosrc_CameraSource$__constructor__(java.lang.String ), 0, this, string2);
    }

    @Override
    public void setupPorts() {
        InvokeDynamicSupport.bootstrap("setupPorts", $$robo$$android_filterpacks_videosrc_CameraSource$setupPorts(), 0, this);
    }

    private void createFormats() {
        InvokeDynamicSupport.bootstrap("createFormats", $$robo$$android_filterpacks_videosrc_CameraSource$createFormats(), 0, this);
    }

    @Override
    public void prepare(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("prepare", $$robo$$android_filterpacks_videosrc_CameraSource$prepare(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    @Override
    public void open(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("open", $$robo$$android_filterpacks_videosrc_CameraSource$open(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    @Override
    public void process(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("process", $$robo$$android_filterpacks_videosrc_CameraSource$process(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    @Override
    public void close(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_filterpacks_videosrc_CameraSource$close(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    @Override
    public void tearDown(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("tearDown", $$robo$$android_filterpacks_videosrc_CameraSource$tearDown(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    @Override
    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("fieldPortValueUpdated", $$robo$$android_filterpacks_videosrc_CameraSource$fieldPortValueUpdated(java.lang.String android.filterfw.core.FilterContext ), 0, this, string2, filterContext);
    }

    public synchronized Camera.Parameters getCameraParameters() {
        return InvokeDynamicSupport.bootstrap("getCameraParameters", $$robo$$android_filterpacks_videosrc_CameraSource$getCameraParameters(), 0, this);
    }

    public synchronized void setCameraParameters(Camera.Parameters parameters) {
        InvokeDynamicSupport.bootstrap("setCameraParameters", $$robo$$android_filterpacks_videosrc_CameraSource$setCameraParameters(android.hardware.Camera$Parameters ), 0, this, parameters);
    }

    private int[] findClosestSize(int n, int n2, Camera.Parameters parameters) {
        return InvokeDynamicSupport.bootstrap("findClosestSize", $$robo$$android_filterpacks_videosrc_CameraSource$findClosestSize(int int android.hardware.Camera$Parameters ), 0, this, n, n2, parameters);
    }

    private int[] findClosestFpsRange(int n, Camera.Parameters parameters) {
        return InvokeDynamicSupport.bootstrap("findClosestFpsRange", $$robo$$android_filterpacks_videosrc_CameraSource$findClosestFpsRange(int android.hardware.Camera$Parameters ), 0, this, n, parameters);
    }

    static {
        RobolectricInternals.classInitializing(CameraSource.class);
    }

    public /* synthetic */ CameraSource() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CameraSource)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

