/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.videosrc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.GLFrame;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.GenerateFinalPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.graphics.SurfaceTexture;
import android.opengl.Matrix;
import android.os.ConditionVariable;
import android.util.Log;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SurfaceTextureSource
extends Filter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    @GenerateFinalPort(name="sourceListener")
    private SurfaceTextureSourceListener mSourceListener;
    @GenerateFieldPort(name="width")
    private int mWidth;
    @GenerateFieldPort(name="height")
    private int mHeight;
    @GenerateFieldPort(name="waitForNewFrame", hasDefault=true)
    private boolean mWaitForNewFrame;
    @GenerateFieldPort(name="waitTimeout", hasDefault=true)
    private int mWaitTimeout;
    @GenerateFieldPort(name="closeOnTimeout", hasDefault=true)
    private boolean mCloseOnTimeout;
    private GLFrame mMediaFrame;
    private ShaderProgram mFrameExtractor;
    private SurfaceTexture mSurfaceTexture;
    private MutableFrameFormat mOutputFormat;
    private ConditionVariable mNewFrameAvailable;
    private boolean mFirstFrame;
    private float[] mFrameTransform;
    private float[] mMappedCoords;
    private static float[] mSourceCoords;
    private String mRenderShader = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES tex_sampler_0;\nvarying vec2 v_texcoord;\nvoid main() {\n  gl_FragColor = texture2D(tex_sampler_0, v_texcoord);\n}\n";
    private static String TAG = "SurfaceTextureSource";
    private static boolean mLogVerbose;
    private SurfaceTexture.OnFrameAvailableListener onFrameAvailableListener;

    private void $$robo$$android_filterpacks_videosrc_SurfaceTextureSource$__constructor__(String name) {
        this.mWaitForNewFrame = true;
        this.mWaitTimeout = 1000;
        this.mCloseOnTimeout = false;
        this.mRenderShader = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES tex_sampler_0;\nvarying vec2 v_texcoord;\nvoid main() {\n  gl_FragColor = texture2D(tex_sampler_0, v_texcoord);\n}\n";
        this.onFrameAvailableListener = new SurfaceTexture.OnFrameAvailableListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SurfaceTextureSource this$0;

            private void $$robo$$android_filterpacks_videosrc_SurfaceTextureSource_1$__constructor__(SurfaceTextureSource surfaceTextureSource) {
            }

            private final void $$robo$$android_filterpacks_videosrc_SurfaceTextureSource_1$onFrameAvailable(SurfaceTexture surfaceTexture) {
                if (mLogVerbose) {
                    Log.v("SurfaceTextureSource", "New frame from SurfaceTexture");
                }
                this.this$0.mNewFrameAvailable.open();
            }

            private void __constructor__(SurfaceTextureSource surfaceTextureSource) {
                this.$$robo$$android_filterpacks_videosrc_SurfaceTextureSource_1$__constructor__(surfaceTextureSource);
            }
            {
                this.this$0 = surfaceTextureSource;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterpacks_videosrc_SurfaceTextureSource_1$__constructor__(android.filterpacks.videosrc.SurfaceTextureSource ), 0, this, surfaceTextureSource);
            }

            @Override
            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                InvokeDynamicSupport.bootstrap("onFrameAvailable", $$robo$$android_filterpacks_videosrc_SurfaceTextureSource_1$onFrameAvailable(android.graphics.SurfaceTexture ), 0, this, surfaceTexture);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mNewFrameAvailable = new ConditionVariable();
        this.mFrameTransform = new float[16];
        this.mMappedCoords = new float[16];
    }

    private final void $$robo$$android_filterpacks_videosrc_SurfaceTextureSource$setupPorts() {
        this.addOutputPort("video", ImageFormat.create(3, 3));
    }

    private final void $$robo$$android_filterpacks_videosrc_SurfaceTextureSource$createFormats() {
        this.mOutputFormat = ImageFormat.create(this.mWidth, this.mHeight, 3, 3);
    }

    private final void $$robo$$android_filterpacks_videosrc_SurfaceTextureSource$prepare(FilterContext context) {
        if (mLogVerbose) {
            Log.v("SurfaceTextureSource", "Preparing SurfaceTextureSource");
        }
        this.createFormats();
        this.mMediaFrame = (GLFrame)context.getFrameManager().newBoundFrame(this.mOutputFormat, 104, 0L);
        this.mFrameExtractor = new ShaderProgram(context, "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES tex_sampler_0;\nvarying vec2 v_texcoord;\nvoid main() {\n  gl_FragColor = texture2D(tex_sampler_0, v_texcoord);\n}\n");
    }

    private final void $$robo$$android_filterpacks_videosrc_SurfaceTextureSource$open(FilterContext context) {
        if (mLogVerbose) {
            Log.v("SurfaceTextureSource", "Opening SurfaceTextureSource");
        }
        this.mSurfaceTexture = new SurfaceTexture(this.mMediaFrame.getTextureId());
        this.mSurfaceTexture.setOnFrameAvailableListener(this.onFrameAvailableListener);
        this.mSourceListener.onSurfaceTextureSourceReady(this.mSurfaceTexture);
        this.mFirstFrame = true;
    }

    private final void $$robo$$android_filterpacks_videosrc_SurfaceTextureSource$process(FilterContext context) {
        if (mLogVerbose) {
            Log.v("SurfaceTextureSource", "Processing new frame");
        }
        if (this.mWaitForNewFrame || this.mFirstFrame) {
            if (this.mWaitTimeout != 0) {
                boolean gotNewFrame = this.mNewFrameAvailable.block(this.mWaitTimeout);
                if (!gotNewFrame) {
                    if (!this.mCloseOnTimeout) {
                        throw new RuntimeException("Timeout waiting for new frame");
                    }
                    if (mLogVerbose) {
                        Log.v("SurfaceTextureSource", "Timeout waiting for a new frame. Closing.");
                    }
                    this.closeOutputPort("video");
                    return;
                }
            } else {
                this.mNewFrameAvailable.block();
            }
            this.mNewFrameAvailable.close();
            this.mFirstFrame = false;
        }
        this.mSurfaceTexture.updateTexImage();
        this.mSurfaceTexture.getTransformMatrix(this.mFrameTransform);
        Matrix.multiplyMM(this.mMappedCoords, 0, this.mFrameTransform, 0, mSourceCoords, 0);
        this.mFrameExtractor.setSourceRegion(this.mMappedCoords[0], this.mMappedCoords[1], this.mMappedCoords[4], this.mMappedCoords[5], this.mMappedCoords[8], this.mMappedCoords[9], this.mMappedCoords[12], this.mMappedCoords[13]);
        Frame output = context.getFrameManager().newFrame(this.mOutputFormat);
        this.mFrameExtractor.process(this.mMediaFrame, output);
        output.setTimestamp(this.mSurfaceTexture.getTimestamp());
        this.pushOutput("video", output);
        output.release();
    }

    private final void $$robo$$android_filterpacks_videosrc_SurfaceTextureSource$close(FilterContext context) {
        if (mLogVerbose) {
            Log.v("SurfaceTextureSource", "SurfaceTextureSource closed");
        }
        this.mSourceListener.onSurfaceTextureSourceReady(null);
        this.mSurfaceTexture.release();
        this.mSurfaceTexture = null;
    }

    private final void $$robo$$android_filterpacks_videosrc_SurfaceTextureSource$tearDown(FilterContext context) {
        if (this.mMediaFrame != null) {
            this.mMediaFrame.release();
        }
    }

    private final void $$robo$$android_filterpacks_videosrc_SurfaceTextureSource$fieldPortValueUpdated(String name, FilterContext context) {
        if (name.equals("width") || name.equals("height")) {
            this.mOutputFormat.setDimensions(this.mWidth, this.mHeight);
        }
    }

    static void __staticInitializer__() {
        mSourceCoords = new float[]{0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f};
        mLogVerbose = Log.isLoggable("SurfaceTextureSource", 2);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_filterpacks_videosrc_SurfaceTextureSource$__constructor__(string2);
    }

    public SurfaceTextureSource(String string2) {
        super(string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterpacks_videosrc_SurfaceTextureSource$__constructor__(java.lang.String ), 0, this, string2);
    }

    @Override
    public void setupPorts() {
        InvokeDynamicSupport.bootstrap("setupPorts", $$robo$$android_filterpacks_videosrc_SurfaceTextureSource$setupPorts(), 0, this);
    }

    private void createFormats() {
        InvokeDynamicSupport.bootstrap("createFormats", $$robo$$android_filterpacks_videosrc_SurfaceTextureSource$createFormats(), 0, this);
    }

    @Override
    protected void prepare(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("prepare", $$robo$$android_filterpacks_videosrc_SurfaceTextureSource$prepare(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    @Override
    public void open(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("open", $$robo$$android_filterpacks_videosrc_SurfaceTextureSource$open(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    @Override
    public void process(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("process", $$robo$$android_filterpacks_videosrc_SurfaceTextureSource$process(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    @Override
    public void close(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_filterpacks_videosrc_SurfaceTextureSource$close(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    @Override
    public void tearDown(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("tearDown", $$robo$$android_filterpacks_videosrc_SurfaceTextureSource$tearDown(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    @Override
    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("fieldPortValueUpdated", $$robo$$android_filterpacks_videosrc_SurfaceTextureSource$fieldPortValueUpdated(java.lang.String android.filterfw.core.FilterContext ), 0, this, string2, filterContext);
    }

    static {
        RobolectricInternals.classInitializing(SurfaceTextureSource.class);
    }

    public /* synthetic */ SurfaceTextureSource() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SurfaceTextureSource)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface SurfaceTextureSourceListener
    extends InstrumentedInterface {
        public void onSurfaceTextureSourceReady(SurfaceTexture var1);
    }
}

