/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.ColorFilter;
import android.graphics.MaskFilter;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rasterizer;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.TemporaryBuffer;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Paint
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public long mNativePaint;
    public long mNativeTypeface;
    private ColorFilter mColorFilter;
    private MaskFilter mMaskFilter;
    private PathEffect mPathEffect;
    private Rasterizer mRasterizer;
    private Shader mShader;
    private Typeface mTypeface;
    private Xfermode mXfermode;
    private boolean mHasCompatScaling;
    private float mCompatScaling;
    private float mInvCompatScaling;
    private Locale mLocale;
    private String mFontFeatureSettings;
    public int mBidiFlags;
    static Style[] sStyleArray;
    static Cap[] sCapArray;
    static Join[] sJoinArray;
    static Align[] sAlignArray;
    public static int ANTI_ALIAS_FLAG = 1;
    public static int FILTER_BITMAP_FLAG = 2;
    public static int DITHER_FLAG = 4;
    public static int UNDERLINE_TEXT_FLAG = 8;
    public static int STRIKE_THRU_TEXT_FLAG = 16;
    public static int FAKE_BOLD_TEXT_FLAG = 32;
    public static int LINEAR_TEXT_FLAG = 64;
    public static int SUBPIXEL_TEXT_FLAG = 128;
    public static int DEV_KERN_TEXT_FLAG = 256;
    public static int LCD_RENDER_TEXT_FLAG = 512;
    public static int EMBEDDED_BITMAP_TEXT_FLAG = 1024;
    public static int AUTO_HINTING_TEXT_FLAG = 2048;
    public static int VERTICAL_TEXT_FLAG = 4096;
    static int DEFAULT_PAINT_FLAGS = 1280;
    public static int HINTING_OFF = 0;
    public static int HINTING_ON = 1;
    public static int BIDI_LTR = 0;
    public static int BIDI_RTL = 1;
    public static int BIDI_DEFAULT_LTR = 2;
    public static int BIDI_DEFAULT_RTL = 3;
    public static int BIDI_FORCE_LTR = 4;
    public static int BIDI_FORCE_RTL = 5;
    private static int BIDI_MAX_FLAG_VALUE = 5;
    private static int BIDI_FLAG_MASK = 7;
    public static int DIRECTION_LTR = 0;
    public static int DIRECTION_RTL = 1;
    public static int CURSOR_AFTER = 0;
    public static int CURSOR_AT_OR_AFTER = 1;
    public static int CURSOR_BEFORE = 2;
    public static int CURSOR_AT_OR_BEFORE = 3;
    public static int CURSOR_AT = 4;
    private static int CURSOR_OPT_MAX_VALUE = 4;

    private void $$robo$$android_graphics_Paint$__constructor__() {
    }

    private void $$robo$$android_graphics_Paint$__constructor__(int flags) {
        this.mBidiFlags = 2;
        this.mNativePaint = Paint.native_init();
        this.setFlags(flags | 0x500);
        this.mInvCompatScaling = 1.0f;
        this.mCompatScaling = 1.0f;
        this.setTextLocale(Locale.getDefault());
    }

    private void $$robo$$android_graphics_Paint$__constructor__(Paint paint) {
        this.mBidiFlags = 2;
        this.mNativePaint = Paint.native_initWithPaint(paint.mNativePaint);
        this.setClassVariablesFrom(paint);
    }

    private final void $$robo$$android_graphics_Paint$reset() {
        Paint.native_reset(this.mNativePaint);
        this.setFlags(1280);
        this.mColorFilter = null;
        this.mMaskFilter = null;
        this.mPathEffect = null;
        this.mRasterizer = null;
        this.mShader = null;
        this.mTypeface = null;
        this.mNativeTypeface = 0L;
        this.mXfermode = null;
        this.mHasCompatScaling = false;
        this.mCompatScaling = 1.0f;
        this.mInvCompatScaling = 1.0f;
        this.mBidiFlags = 2;
        this.setTextLocale(Locale.getDefault());
        this.setElegantTextHeight(false);
        this.mFontFeatureSettings = null;
    }

    private final void $$robo$$android_graphics_Paint$set(Paint src) {
        if (this != src) {
            Paint.native_set(this.mNativePaint, src.mNativePaint);
            this.setClassVariablesFrom(src);
        }
    }

    private final void $$robo$$android_graphics_Paint$setClassVariablesFrom(Paint paint) {
        this.mColorFilter = paint.mColorFilter;
        this.mMaskFilter = paint.mMaskFilter;
        this.mPathEffect = paint.mPathEffect;
        this.mRasterizer = paint.mRasterizer;
        this.mShader = paint.mShader != null ? paint.mShader.copy() : null;
        this.mTypeface = paint.mTypeface;
        this.mNativeTypeface = paint.mNativeTypeface;
        this.mXfermode = paint.mXfermode;
        this.mHasCompatScaling = paint.mHasCompatScaling;
        this.mCompatScaling = paint.mCompatScaling;
        this.mInvCompatScaling = paint.mInvCompatScaling;
        this.mBidiFlags = paint.mBidiFlags;
        this.mLocale = paint.mLocale;
        this.mFontFeatureSettings = paint.mFontFeatureSettings;
    }

    private final void $$robo$$android_graphics_Paint$setCompatibilityScaling(float factor) {
        if ((double)factor == 1.0) {
            this.mHasCompatScaling = false;
            this.mInvCompatScaling = 1.0f;
            this.mCompatScaling = 1.0f;
        } else {
            this.mHasCompatScaling = true;
            this.mCompatScaling = factor;
            this.mInvCompatScaling = 1.0f / factor;
        }
    }

    private final int $$robo$$android_graphics_Paint$getBidiFlags() {
        return this.mBidiFlags;
    }

    private final void $$robo$$android_graphics_Paint$setBidiFlags(int flags) {
        if ((flags &= 7) > 5) {
            throw new IllegalArgumentException("unknown bidi flag: " + flags);
        }
        this.mBidiFlags = flags;
    }

    private final int $$robo$$android_graphics_Paint$getFlags() {
        return 0;
    }

    private final void $$robo$$android_graphics_Paint$setFlags(int n) {
    }

    private final int $$robo$$android_graphics_Paint$getHinting() {
        return 0;
    }

    private final void $$robo$$android_graphics_Paint$setHinting(int n) {
    }

    private final boolean $$robo$$android_graphics_Paint$isAntiAlias() {
        return (this.getFlags() & 1) != 0;
    }

    private final void $$robo$$android_graphics_Paint$setAntiAlias(boolean bl) {
    }

    private final boolean $$robo$$android_graphics_Paint$isDither() {
        return (this.getFlags() & 4) != 0;
    }

    private final void $$robo$$android_graphics_Paint$setDither(boolean bl) {
    }

    private final boolean $$robo$$android_graphics_Paint$isLinearText() {
        return (this.getFlags() & 0x40) != 0;
    }

    private final void $$robo$$android_graphics_Paint$setLinearText(boolean bl) {
    }

    private final boolean $$robo$$android_graphics_Paint$isSubpixelText() {
        return (this.getFlags() & 0x80) != 0;
    }

    private final void $$robo$$android_graphics_Paint$setSubpixelText(boolean bl) {
    }

    private final boolean $$robo$$android_graphics_Paint$isUnderlineText() {
        return (this.getFlags() & 8) != 0;
    }

    private final void $$robo$$android_graphics_Paint$setUnderlineText(boolean bl) {
    }

    private final boolean $$robo$$android_graphics_Paint$isStrikeThruText() {
        return (this.getFlags() & 0x10) != 0;
    }

    private final void $$robo$$android_graphics_Paint$setStrikeThruText(boolean bl) {
    }

    private final boolean $$robo$$android_graphics_Paint$isFakeBoldText() {
        return (this.getFlags() & 0x20) != 0;
    }

    private final void $$robo$$android_graphics_Paint$setFakeBoldText(boolean bl) {
    }

    private final boolean $$robo$$android_graphics_Paint$isFilterBitmap() {
        return (this.getFlags() & 2) != 0;
    }

    private final void $$robo$$android_graphics_Paint$setFilterBitmap(boolean bl) {
    }

    private final Style $$robo$$android_graphics_Paint$getStyle() {
        return sStyleArray[Paint.native_getStyle(this.mNativePaint)];
    }

    private final void $$robo$$android_graphics_Paint$setStyle(Style style2) {
        Paint.native_setStyle(this.mNativePaint, style2.nativeInt);
    }

    private final int $$robo$$android_graphics_Paint$getColor() {
        return 0;
    }

    private final void $$robo$$android_graphics_Paint$setColor(int n) {
    }

    private final int $$robo$$android_graphics_Paint$getAlpha() {
        return 0;
    }

    private final void $$robo$$android_graphics_Paint$setAlpha(int n) {
    }

    private final void $$robo$$android_graphics_Paint$setARGB(int a, int r, int g, int b) {
        this.setColor(a << 24 | r << 16 | g << 8 | b);
    }

    private final float $$robo$$android_graphics_Paint$getStrokeWidth() {
        return 0.0f;
    }

    private final void $$robo$$android_graphics_Paint$setStrokeWidth(float f) {
    }

    private final float $$robo$$android_graphics_Paint$getStrokeMiter() {
        return 0.0f;
    }

    private final void $$robo$$android_graphics_Paint$setStrokeMiter(float f) {
    }

    private final Cap $$robo$$android_graphics_Paint$getStrokeCap() {
        return sCapArray[Paint.native_getStrokeCap(this.mNativePaint)];
    }

    private final void $$robo$$android_graphics_Paint$setStrokeCap(Cap cap) {
        Paint.native_setStrokeCap(this.mNativePaint, cap.nativeInt);
    }

    private final Join $$robo$$android_graphics_Paint$getStrokeJoin() {
        return sJoinArray[Paint.native_getStrokeJoin(this.mNativePaint)];
    }

    private final void $$robo$$android_graphics_Paint$setStrokeJoin(Join join) {
        Paint.native_setStrokeJoin(this.mNativePaint, join.nativeInt);
    }

    private final boolean $$robo$$android_graphics_Paint$getFillPath(Path src, Path dst) {
        return Paint.native_getFillPath(this.mNativePaint, src.ni(), dst.ni());
    }

    private final Shader $$robo$$android_graphics_Paint$getShader() {
        return this.mShader;
    }

    private final Shader $$robo$$android_graphics_Paint$setShader(Shader shader) {
        long shaderNative = 0L;
        if (shader != null) {
            shaderNative = shader.getNativeInstance();
        }
        Paint.native_setShader(this.mNativePaint, shaderNative);
        this.mShader = shader;
        return shader;
    }

    private final ColorFilter $$robo$$android_graphics_Paint$getColorFilter() {
        return this.mColorFilter;
    }

    private final ColorFilter $$robo$$android_graphics_Paint$setColorFilter(ColorFilter filter) {
        long filterNative = 0L;
        if (filter != null) {
            filterNative = filter.native_instance;
        }
        Paint.native_setColorFilter(this.mNativePaint, filterNative);
        this.mColorFilter = filter;
        return filter;
    }

    private final Xfermode $$robo$$android_graphics_Paint$getXfermode() {
        return this.mXfermode;
    }

    private final Xfermode $$robo$$android_graphics_Paint$setXfermode(Xfermode xfermode) {
        long xfermodeNative = 0L;
        if (xfermode != null) {
            xfermodeNative = xfermode.native_instance;
        }
        Paint.native_setXfermode(this.mNativePaint, xfermodeNative);
        this.mXfermode = xfermode;
        return xfermode;
    }

    private final PathEffect $$robo$$android_graphics_Paint$getPathEffect() {
        return this.mPathEffect;
    }

    private final PathEffect $$robo$$android_graphics_Paint$setPathEffect(PathEffect effect) {
        long effectNative = 0L;
        if (effect != null) {
            effectNative = effect.native_instance;
        }
        Paint.native_setPathEffect(this.mNativePaint, effectNative);
        this.mPathEffect = effect;
        return effect;
    }

    private final MaskFilter $$robo$$android_graphics_Paint$getMaskFilter() {
        return this.mMaskFilter;
    }

    private final MaskFilter $$robo$$android_graphics_Paint$setMaskFilter(MaskFilter maskfilter) {
        long maskfilterNative = 0L;
        if (maskfilter != null) {
            maskfilterNative = maskfilter.native_instance;
        }
        Paint.native_setMaskFilter(this.mNativePaint, maskfilterNative);
        this.mMaskFilter = maskfilter;
        return maskfilter;
    }

    private final Typeface $$robo$$android_graphics_Paint$getTypeface() {
        return this.mTypeface;
    }

    private final Typeface $$robo$$android_graphics_Paint$setTypeface(Typeface typeface) {
        long typefaceNative = 0L;
        if (typeface != null) {
            typefaceNative = typeface.native_instance;
        }
        Paint.native_setTypeface(this.mNativePaint, typefaceNative);
        this.mTypeface = typeface;
        this.mNativeTypeface = typefaceNative;
        return typeface;
    }

    @Deprecated
    private final Rasterizer $$robo$$android_graphics_Paint$getRasterizer() {
        return this.mRasterizer;
    }

    @Deprecated
    private final Rasterizer $$robo$$android_graphics_Paint$setRasterizer(Rasterizer rasterizer) {
        long rasterizerNative = 0L;
        if (rasterizer != null) {
            rasterizerNative = rasterizer.native_instance;
        }
        Paint.native_setRasterizer(this.mNativePaint, rasterizerNative);
        this.mRasterizer = rasterizer;
        return rasterizer;
    }

    private final void $$robo$$android_graphics_Paint$setShadowLayer(float radius, float dx, float dy, int shadowColor) {
        Paint.native_setShadowLayer(this.mNativePaint, radius, dx, dy, shadowColor);
    }

    private final void $$robo$$android_graphics_Paint$clearShadowLayer() {
        this.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
    }

    private final boolean $$robo$$android_graphics_Paint$hasShadowLayer() {
        return Paint.native_hasShadowLayer(this.mNativePaint);
    }

    private final Align $$robo$$android_graphics_Paint$getTextAlign() {
        return sAlignArray[Paint.native_getTextAlign(this.mNativePaint)];
    }

    private final void $$robo$$android_graphics_Paint$setTextAlign(Align align) {
        Paint.native_setTextAlign(this.mNativePaint, align.nativeInt);
    }

    private final Locale $$robo$$android_graphics_Paint$getTextLocale() {
        return this.mLocale;
    }

    private final void $$robo$$android_graphics_Paint$setTextLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale cannot be null");
        }
        if (locale.equals(this.mLocale)) {
            return;
        }
        this.mLocale = locale;
        Paint.native_setTextLocale(this.mNativePaint, locale.toString());
    }

    private final boolean $$robo$$android_graphics_Paint$isElegantTextHeight() {
        return false;
    }

    private final void $$robo$$android_graphics_Paint$setElegantTextHeight(boolean bl) {
    }

    private final float $$robo$$android_graphics_Paint$getTextSize() {
        return 0.0f;
    }

    private final void $$robo$$android_graphics_Paint$setTextSize(float f) {
    }

    private final float $$robo$$android_graphics_Paint$getTextScaleX() {
        return 0.0f;
    }

    private final void $$robo$$android_graphics_Paint$setTextScaleX(float f) {
    }

    private final float $$robo$$android_graphics_Paint$getTextSkewX() {
        return 0.0f;
    }

    private final void $$robo$$android_graphics_Paint$setTextSkewX(float f) {
    }

    private final float $$robo$$android_graphics_Paint$getLetterSpacing() {
        return Paint.native_getLetterSpacing(this.mNativePaint);
    }

    private final void $$robo$$android_graphics_Paint$setLetterSpacing(float letterSpacing) {
        Paint.native_setLetterSpacing(this.mNativePaint, letterSpacing);
    }

    private final String $$robo$$android_graphics_Paint$getFontFeatureSettings() {
        return this.mFontFeatureSettings;
    }

    private final void $$robo$$android_graphics_Paint$setFontFeatureSettings(String settings) {
        if (settings != null && settings.equals("")) {
            settings = null;
        }
        if (settings == null && this.mFontFeatureSettings == null || settings != null && settings.equals(this.mFontFeatureSettings)) {
            return;
        }
        this.mFontFeatureSettings = settings;
        Paint.native_setFontFeatureSettings(this.mNativePaint, settings);
    }

    private final float $$robo$$android_graphics_Paint$ascent() {
        return 0.0f;
    }

    private final float $$robo$$android_graphics_Paint$descent() {
        return 0.0f;
    }

    private final float $$robo$$android_graphics_Paint$getFontMetrics(FontMetrics fontMetrics) {
        return 0.0f;
    }

    private final FontMetrics $$robo$$android_graphics_Paint$getFontMetrics() {
        FontMetrics fm = new FontMetrics();
        this.getFontMetrics(fm);
        return fm;
    }

    private final int $$robo$$android_graphics_Paint$getFontMetricsInt(FontMetricsInt fontMetricsInt) {
        return 0;
    }

    private final FontMetricsInt $$robo$$android_graphics_Paint$getFontMetricsInt() {
        FontMetricsInt fm = new FontMetricsInt();
        this.getFontMetricsInt(fm);
        return fm;
    }

    private final float $$robo$$android_graphics_Paint$getFontSpacing() {
        return this.getFontMetrics(null);
    }

    private final float $$robo$$android_graphics_Paint$measureText(char[] text, int index, int count) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((index | count) < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (text.length == 0 || count == 0) {
            return 0.0f;
        }
        if (!this.mHasCompatScaling) {
            return (float)Math.ceil(this.native_measureText(text, index, count, this.mBidiFlags));
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float w = this.native_measureText(text, index, count, this.mBidiFlags);
        this.setTextSize(oldSize);
        return (float)Math.ceil(w * this.mInvCompatScaling);
    }

    private final float $$robo$$android_graphics_Paint$native_measureText(char[] cArray, int n, int n2, int n3) {
        return 0.0f;
    }

    private final float $$robo$$android_graphics_Paint$measureText(String text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0.0f;
        }
        if (!this.mHasCompatScaling) {
            return (float)Math.ceil(this.native_measureText(text, start, end, this.mBidiFlags));
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float w = this.native_measureText(text, start, end, this.mBidiFlags);
        this.setTextSize(oldSize);
        return (float)Math.ceil(w * this.mInvCompatScaling);
    }

    private final float $$robo$$android_graphics_Paint$native_measureText(String string2, int n, int n2, int n3) {
        return 0.0f;
    }

    private final float $$robo$$android_graphics_Paint$measureText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if (text.length() == 0) {
            return 0.0f;
        }
        if (!this.mHasCompatScaling) {
            return (float)Math.ceil(this.native_measureText(text, this.mBidiFlags));
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float w = this.native_measureText(text, this.mBidiFlags);
        this.setTextSize(oldSize);
        return (float)Math.ceil(w * this.mInvCompatScaling);
    }

    private final float $$robo$$android_graphics_Paint$native_measureText(String string2, int n) {
        return 0.0f;
    }

    private final float $$robo$$android_graphics_Paint$measureText(CharSequence text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0.0f;
        }
        if (text instanceof String) {
            return this.measureText((String)text, start, end);
        }
        if (text instanceof SpannedString || text instanceof SpannableString) {
            return this.measureText(text.toString(), start, end);
        }
        if (text instanceof GraphicsOperations) {
            return ((GraphicsOperations)text).measureText(start, end, this);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        float result = this.measureText(buf, 0, end - start);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    private final int $$robo$$android_graphics_Paint$breakText(char[] text, int index, int count, float maxWidth, float[] measuredWidth) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if (index < 0 || text.length - index < Math.abs(count)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (text.length == 0 || count == 0) {
            return 0;
        }
        if (!this.mHasCompatScaling) {
            return Paint.native_breakText(this.mNativePaint, this.mNativeTypeface, text, index, count, maxWidth, this.mBidiFlags, measuredWidth);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        int res = Paint.native_breakText(this.mNativePaint, this.mNativeTypeface, text, index, count, maxWidth * this.mCompatScaling, this.mBidiFlags, measuredWidth);
        this.setTextSize(oldSize);
        if (measuredWidth != null) {
            measuredWidth[0] = measuredWidth[0] * this.mInvCompatScaling;
        }
        return res;
    }

    private static final int $$robo$$android_graphics_Paint$native_breakText(long l, long l2, char[] cArray, int n, int n2, float f, int n3, float[] fArray) {
        return 0;
    }

    private final int $$robo$$android_graphics_Paint$breakText(CharSequence text, int start, int end, boolean measureForwards, float maxWidth, float[] measuredWidth) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0;
        }
        if (start == 0 && text instanceof String && end == text.length()) {
            return this.breakText((String)text, measureForwards, maxWidth, measuredWidth);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        int result = measureForwards ? this.breakText(buf, 0, end - start, maxWidth, measuredWidth) : this.breakText(buf, 0, -(end - start), maxWidth, measuredWidth);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    private final int $$robo$$android_graphics_Paint$breakText(String text, boolean measureForwards, float maxWidth, float[] measuredWidth) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if (text.length() == 0) {
            return 0;
        }
        if (!this.mHasCompatScaling) {
            return Paint.native_breakText(this.mNativePaint, this.mNativeTypeface, text, measureForwards, maxWidth, this.mBidiFlags, measuredWidth);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        int res = Paint.native_breakText(this.mNativePaint, this.mNativeTypeface, text, measureForwards, maxWidth * this.mCompatScaling, this.mBidiFlags, measuredWidth);
        this.setTextSize(oldSize);
        if (measuredWidth != null) {
            measuredWidth[0] = measuredWidth[0] * this.mInvCompatScaling;
        }
        return res;
    }

    private static final int $$robo$$android_graphics_Paint$native_breakText(long l, long l2, String string2, boolean bl, float f, int n, float[] fArray) {
        return 0;
    }

    private final int $$robo$$android_graphics_Paint$getTextWidths(char[] text, int index, int count, float[] widths) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((index | count) < 0 || index + count > text.length || count > widths.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (text.length == 0 || count == 0) {
            return 0;
        }
        if (!this.mHasCompatScaling) {
            return Paint.native_getTextWidths(this.mNativePaint, this.mNativeTypeface, text, index, count, this.mBidiFlags, widths);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        int res = Paint.native_getTextWidths(this.mNativePaint, this.mNativeTypeface, text, index, count, this.mBidiFlags, widths);
        this.setTextSize(oldSize);
        int i = 0;
        while (i < res) {
            int n = i++;
            widths[n] = widths[n] * this.mInvCompatScaling;
        }
        return res;
    }

    private final int $$robo$$android_graphics_Paint$getTextWidths(CharSequence text, int start, int end, float[] widths) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end - start > widths.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0;
        }
        if (text instanceof String) {
            return this.getTextWidths((String)text, start, end, widths);
        }
        if (text instanceof SpannedString || text instanceof SpannableString) {
            return this.getTextWidths(text.toString(), start, end, widths);
        }
        if (text instanceof GraphicsOperations) {
            return ((GraphicsOperations)text).getTextWidths(start, end, widths, this);
        }
        char[] buf = TemporaryBuffer.obtain(end - start);
        TextUtils.getChars(text, start, end, buf, 0);
        int result = this.getTextWidths(buf, 0, end - start, widths);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    private final int $$robo$$android_graphics_Paint$getTextWidths(String text, int start, int end, float[] widths) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end - start > widths.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0;
        }
        if (!this.mHasCompatScaling) {
            return Paint.native_getTextWidths(this.mNativePaint, this.mNativeTypeface, text, start, end, this.mBidiFlags, widths);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        int res = Paint.native_getTextWidths(this.mNativePaint, this.mNativeTypeface, text, start, end, this.mBidiFlags, widths);
        this.setTextSize(oldSize);
        int i = 0;
        while (i < res) {
            int n = i++;
            widths[n] = widths[n] * this.mInvCompatScaling;
        }
        return res;
    }

    private final int $$robo$$android_graphics_Paint$getTextWidths(String text, float[] widths) {
        return this.getTextWidths(text, 0, text.length(), widths);
    }

    private final float $$robo$$android_graphics_Paint$getTextRunAdvances(char[] chars, int index, int count, int contextIndex, int contextCount, boolean isRtl, float[] advances, int advancesIndex) {
        if (chars == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((index | count | contextIndex | contextCount | advancesIndex | index - contextIndex | contextCount - count | contextIndex + contextCount - (index + count) | chars.length - (contextIndex + contextCount) | (advances == null ? 0 : advances.length - (advancesIndex + count))) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (chars.length == 0 || count == 0) {
            return 0.0f;
        }
        if (!this.mHasCompatScaling) {
            return Paint.native_getTextRunAdvances(this.mNativePaint, this.mNativeTypeface, chars, index, count, contextIndex, contextCount, isRtl, advances, advancesIndex);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float res = Paint.native_getTextRunAdvances(this.mNativePaint, this.mNativeTypeface, chars, index, count, contextIndex, contextCount, isRtl, advances, advancesIndex);
        this.setTextSize(oldSize);
        if (advances != null) {
            int i = advancesIndex;
            int e = i + count;
            while (i < e) {
                int n = i++;
                advances[n] = advances[n] * this.mInvCompatScaling;
            }
        }
        return res * this.mInvCompatScaling;
    }

    private final float $$robo$$android_graphics_Paint$getTextRunAdvances(CharSequence text, int start, int end, int contextStart, int contextEnd, boolean isRtl, float[] advances, int advancesIndex) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | contextStart | contextEnd | advancesIndex | end - start | start - contextStart | contextEnd - end | text.length() - contextEnd | (advances == null ? 0 : advances.length - advancesIndex - (end - start))) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text instanceof String) {
            return this.getTextRunAdvances((String)text, start, end, contextStart, contextEnd, isRtl, advances, advancesIndex);
        }
        if (text instanceof SpannedString || text instanceof SpannableString) {
            return this.getTextRunAdvances(text.toString(), start, end, contextStart, contextEnd, isRtl, advances, advancesIndex);
        }
        if (text instanceof GraphicsOperations) {
            return ((GraphicsOperations)text).getTextRunAdvances(start, end, contextStart, contextEnd, isRtl, advances, advancesIndex, this);
        }
        if (text.length() == 0 || end == start) {
            return 0.0f;
        }
        int contextLen = contextEnd - contextStart;
        int len = end - start;
        char[] buf = TemporaryBuffer.obtain(contextLen);
        TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
        float result = this.getTextRunAdvances(buf, start - contextStart, len, 0, contextLen, isRtl, advances, advancesIndex);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    private final float $$robo$$android_graphics_Paint$getTextRunAdvances(String text, int start, int end, int contextStart, int contextEnd, boolean isRtl, float[] advances, int advancesIndex) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        if ((start | end | contextStart | contextEnd | advancesIndex | end - start | start - contextStart | contextEnd - end | text.length() - contextEnd | (advances == null ? 0 : advances.length - advancesIndex - (end - start))) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (text.length() == 0 || start == end) {
            return 0.0f;
        }
        if (!this.mHasCompatScaling) {
            return Paint.native_getTextRunAdvances(this.mNativePaint, this.mNativeTypeface, text, start, end, contextStart, contextEnd, isRtl, advances, advancesIndex);
        }
        float oldSize = this.getTextSize();
        this.setTextSize(oldSize * this.mCompatScaling);
        float totalAdvance = Paint.native_getTextRunAdvances(this.mNativePaint, this.mNativeTypeface, text, start, end, contextStart, contextEnd, isRtl, advances, advancesIndex);
        this.setTextSize(oldSize);
        if (advances != null) {
            int i = advancesIndex;
            int e = i + (end - start);
            while (i < e) {
                int n = i++;
                advances[n] = advances[n] * this.mInvCompatScaling;
            }
        }
        return totalAdvance * this.mInvCompatScaling;
    }

    private final int $$robo$$android_graphics_Paint$getTextRunCursor(char[] text, int contextStart, int contextLength, int dir, int offset, int cursorOpt) {
        int contextEnd = contextStart + contextLength;
        if ((contextStart | contextEnd | offset | contextEnd - contextStart | offset - contextStart | contextEnd - offset | text.length - contextEnd | cursorOpt) < 0 || cursorOpt > 4) {
            throw new IndexOutOfBoundsException();
        }
        return this.native_getTextRunCursor(this.mNativePaint, text, contextStart, contextLength, dir, offset, cursorOpt);
    }

    private final int $$robo$$android_graphics_Paint$getTextRunCursor(CharSequence text, int contextStart, int contextEnd, int dir, int offset, int cursorOpt) {
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            return this.getTextRunCursor(text.toString(), contextStart, contextEnd, dir, offset, cursorOpt);
        }
        if (text instanceof GraphicsOperations) {
            return ((GraphicsOperations)text).getTextRunCursor(contextStart, contextEnd, dir, offset, cursorOpt, this);
        }
        int contextLen = contextEnd - contextStart;
        char[] buf = TemporaryBuffer.obtain(contextLen);
        TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
        int result = this.getTextRunCursor(buf, 0, contextLen, dir, offset - contextStart, cursorOpt);
        TemporaryBuffer.recycle(buf);
        return result;
    }

    private final int $$robo$$android_graphics_Paint$getTextRunCursor(String text, int contextStart, int contextEnd, int dir, int offset, int cursorOpt) {
        if ((contextStart | contextEnd | offset | contextEnd - contextStart | offset - contextStart | contextEnd - offset | text.length() - contextEnd | cursorOpt) < 0 || cursorOpt > 4) {
            throw new IndexOutOfBoundsException();
        }
        return this.native_getTextRunCursor(this.mNativePaint, text, contextStart, contextEnd, dir, offset, cursorOpt);
    }

    private final void $$robo$$android_graphics_Paint$getTextPath(char[] text, int index, int count, float x, float y, Path path) {
        if ((index | count) < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Paint.native_getTextPath(this.mNativePaint, this.mNativeTypeface, this.mBidiFlags, text, index, count, x, y, path.ni());
    }

    private final void $$robo$$android_graphics_Paint$getTextPath(String text, int start, int end, float x, float y, Path path) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        Paint.native_getTextPath(this.mNativePaint, this.mNativeTypeface, this.mBidiFlags, text, start, end, x, y, path.ni());
    }

    private final void $$robo$$android_graphics_Paint$getTextBounds(String text, int start, int end, Rect bounds) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (bounds == null) {
            throw new NullPointerException("need bounds Rect");
        }
        Paint.nativeGetStringBounds(this.mNativePaint, this.mNativeTypeface, text, start, end, this.mBidiFlags, bounds);
    }

    private final void $$robo$$android_graphics_Paint$getTextBounds(char[] text, int index, int count, Rect bounds) {
        if ((index | count) < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (bounds == null) {
            throw new NullPointerException("need bounds Rect");
        }
        Paint.nativeGetCharArrayBounds(this.mNativePaint, this.mNativeTypeface, text, index, count, this.mBidiFlags, bounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_graphics_Paint$finalize() throws Throwable {
        try {
            Paint.finalizer(this.mNativePaint);
        }
        finally {
            super.finalize();
        }
    }

    private static final long $$robo$$android_graphics_Paint$native_init() {
        return 0L;
    }

    private static final long $$robo$$android_graphics_Paint$native_initWithPaint(long l) {
        return 0L;
    }

    private static final void $$robo$$android_graphics_Paint$native_reset(long l) {
    }

    private static final void $$robo$$android_graphics_Paint$native_set(long l, long l2) {
    }

    private static final int $$robo$$android_graphics_Paint$native_getStyle(long l) {
        return 0;
    }

    private static final void $$robo$$android_graphics_Paint$native_setStyle(long l, int n) {
    }

    private static final int $$robo$$android_graphics_Paint$native_getStrokeCap(long l) {
        return 0;
    }

    private static final void $$robo$$android_graphics_Paint$native_setStrokeCap(long l, int n) {
    }

    private static final int $$robo$$android_graphics_Paint$native_getStrokeJoin(long l) {
        return 0;
    }

    private static final void $$robo$$android_graphics_Paint$native_setStrokeJoin(long l, int n) {
    }

    private static final boolean $$robo$$android_graphics_Paint$native_getFillPath(long l, long l2, long l3) {
        return false;
    }

    private static final long $$robo$$android_graphics_Paint$native_setShader(long l, long l2) {
        return 0L;
    }

    private static final long $$robo$$android_graphics_Paint$native_setColorFilter(long l, long l2) {
        return 0L;
    }

    private static final long $$robo$$android_graphics_Paint$native_setXfermode(long l, long l2) {
        return 0L;
    }

    private static final long $$robo$$android_graphics_Paint$native_setPathEffect(long l, long l2) {
        return 0L;
    }

    private static final long $$robo$$android_graphics_Paint$native_setMaskFilter(long l, long l2) {
        return 0L;
    }

    private static final long $$robo$$android_graphics_Paint$native_setTypeface(long l, long l2) {
        return 0L;
    }

    private static final long $$robo$$android_graphics_Paint$native_setRasterizer(long l, long l2) {
        return 0L;
    }

    private static final int $$robo$$android_graphics_Paint$native_getTextAlign(long l) {
        return 0;
    }

    private static final void $$robo$$android_graphics_Paint$native_setTextAlign(long l, int n) {
    }

    private static final void $$robo$$android_graphics_Paint$native_setTextLocale(long l, String string2) {
    }

    private static final int $$robo$$android_graphics_Paint$native_getTextWidths(long l, long l2, char[] cArray, int n, int n2, int n3, float[] fArray) {
        return 0;
    }

    private static final int $$robo$$android_graphics_Paint$native_getTextWidths(long l, long l2, String string2, int n, int n2, int n3, float[] fArray) {
        return 0;
    }

    private static final int $$robo$$android_graphics_Paint$native_getTextGlyphs(long l, String string2, int n, int n2, int n3, int n4, int n5, char[] cArray) {
        return 0;
    }

    private static final float $$robo$$android_graphics_Paint$native_getTextRunAdvances(long l, long l2, char[] cArray, int n, int n2, int n3, int n4, boolean bl, float[] fArray, int n5) {
        return 0.0f;
    }

    private static final float $$robo$$android_graphics_Paint$native_getTextRunAdvances(long l, long l2, String string2, int n, int n2, int n3, int n4, boolean bl, float[] fArray, int n5) {
        return 0.0f;
    }

    private final int $$robo$$android_graphics_Paint$native_getTextRunCursor(long l, char[] cArray, int n, int n2, int n3, int n4, int n5) {
        return 0;
    }

    private final int $$robo$$android_graphics_Paint$native_getTextRunCursor(long l, String string2, int n, int n2, int n3, int n4, int n5) {
        return 0;
    }

    private static final void $$robo$$android_graphics_Paint$native_getTextPath(long l, long l2, int n, char[] cArray, int n2, int n3, float f, float f2, long l3) {
    }

    private static final void $$robo$$android_graphics_Paint$native_getTextPath(long l, long l2, int n, String string2, int n2, int n3, float f, float f2, long l3) {
    }

    private static final void $$robo$$android_graphics_Paint$nativeGetStringBounds(long l, long l2, String string2, int n, int n2, int n3, Rect rect) {
    }

    private static final void $$robo$$android_graphics_Paint$nativeGetCharArrayBounds(long l, long l2, char[] cArray, int n, int n2, int n3, Rect rect) {
    }

    private static final void $$robo$$android_graphics_Paint$finalizer(long l) {
    }

    private static final void $$robo$$android_graphics_Paint$native_setShadowLayer(long l, float f, float f2, float f3, int n) {
    }

    private static final boolean $$robo$$android_graphics_Paint$native_hasShadowLayer(long l) {
        return false;
    }

    private static final float $$robo$$android_graphics_Paint$native_getLetterSpacing(long l) {
        return 0.0f;
    }

    private static final void $$robo$$android_graphics_Paint$native_setLetterSpacing(long l, float f) {
    }

    private static final void $$robo$$android_graphics_Paint$native_setFontFeatureSettings(long l, String string2) {
    }

    static void __staticInitializer__() {
        sStyleArray = new Style[]{Style.FILL, Style.STROKE, Style.FILL_AND_STROKE};
        sCapArray = new Cap[]{Cap.BUTT, Cap.ROUND, Cap.SQUARE};
        sJoinArray = new Join[]{Join.MITER, Join.ROUND, Join.BEVEL};
        sAlignArray = new Align[]{Align.LEFT, Align.CENTER, Align.RIGHT};
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_Paint$__constructor__();
    }

    public Paint() {
        this(0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Paint$__constructor__(), 0, this);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_graphics_Paint$__constructor__(n);
    }

    public Paint(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Paint$__constructor__(int ), 0, this, n);
    }

    private void __constructor__(Paint paint) {
        this.$$robo$$android_graphics_Paint$__constructor__(paint);
    }

    public Paint(Paint paint) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Paint$__constructor__(android.graphics.Paint ), 0, this, paint);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_graphics_Paint$reset(), 0, this);
    }

    public void set(Paint paint) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_graphics_Paint$set(android.graphics.Paint ), 0, this, paint);
    }

    private void setClassVariablesFrom(Paint paint) {
        InvokeDynamicSupport.bootstrap("setClassVariablesFrom", $$robo$$android_graphics_Paint$setClassVariablesFrom(android.graphics.Paint ), 0, this, paint);
    }

    public void setCompatibilityScaling(float f) {
        InvokeDynamicSupport.bootstrap("setCompatibilityScaling", $$robo$$android_graphics_Paint$setCompatibilityScaling(float ), 0, this, f);
    }

    public int getBidiFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getBidiFlags", $$robo$$android_graphics_Paint$getBidiFlags(), 0, this);
    }

    public void setBidiFlags(int n) {
        InvokeDynamicSupport.bootstrap("setBidiFlags", $$robo$$android_graphics_Paint$setBidiFlags(int ), 0, this, n);
    }

    private final native /* synthetic */ int $$robo$$getFlags$nativeBinding();

    public int getFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getFlags", $$robo$$android_graphics_Paint$getFlags(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$setFlags$nativeBinding(int var1);

    public void setFlags(int n) {
        InvokeDynamicSupport.bootstrap("setFlags", $$robo$$android_graphics_Paint$setFlags(int ), 1, this, n);
    }

    private final native /* synthetic */ int $$robo$$getHinting$nativeBinding();

    public int getHinting() {
        return (int)InvokeDynamicSupport.bootstrap("getHinting", $$robo$$android_graphics_Paint$getHinting(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$setHinting$nativeBinding(int var1);

    public void setHinting(int n) {
        InvokeDynamicSupport.bootstrap("setHinting", $$robo$$android_graphics_Paint$setHinting(int ), 1, this, n);
    }

    public boolean isAntiAlias() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAntiAlias", $$robo$$android_graphics_Paint$isAntiAlias(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$setAntiAlias$nativeBinding(boolean var1);

    public void setAntiAlias(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAntiAlias", $$robo$$android_graphics_Paint$setAntiAlias(boolean ), 1, this, bl);
    }

    public boolean isDither() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDither", $$robo$$android_graphics_Paint$isDither(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$setDither$nativeBinding(boolean var1);

    public void setDither(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDither", $$robo$$android_graphics_Paint$setDither(boolean ), 1, this, bl);
    }

    public boolean isLinearText() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLinearText", $$robo$$android_graphics_Paint$isLinearText(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$setLinearText$nativeBinding(boolean var1);

    public void setLinearText(boolean bl) {
        InvokeDynamicSupport.bootstrap("setLinearText", $$robo$$android_graphics_Paint$setLinearText(boolean ), 1, this, bl);
    }

    public boolean isSubpixelText() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSubpixelText", $$robo$$android_graphics_Paint$isSubpixelText(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$setSubpixelText$nativeBinding(boolean var1);

    public void setSubpixelText(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSubpixelText", $$robo$$android_graphics_Paint$setSubpixelText(boolean ), 1, this, bl);
    }

    public boolean isUnderlineText() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUnderlineText", $$robo$$android_graphics_Paint$isUnderlineText(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$setUnderlineText$nativeBinding(boolean var1);

    public void setUnderlineText(boolean bl) {
        InvokeDynamicSupport.bootstrap("setUnderlineText", $$robo$$android_graphics_Paint$setUnderlineText(boolean ), 1, this, bl);
    }

    public boolean isStrikeThruText() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStrikeThruText", $$robo$$android_graphics_Paint$isStrikeThruText(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$setStrikeThruText$nativeBinding(boolean var1);

    public void setStrikeThruText(boolean bl) {
        InvokeDynamicSupport.bootstrap("setStrikeThruText", $$robo$$android_graphics_Paint$setStrikeThruText(boolean ), 1, this, bl);
    }

    public boolean isFakeBoldText() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFakeBoldText", $$robo$$android_graphics_Paint$isFakeBoldText(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$setFakeBoldText$nativeBinding(boolean var1);

    public void setFakeBoldText(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFakeBoldText", $$robo$$android_graphics_Paint$setFakeBoldText(boolean ), 1, this, bl);
    }

    public boolean isFilterBitmap() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFilterBitmap", $$robo$$android_graphics_Paint$isFilterBitmap(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$setFilterBitmap$nativeBinding(boolean var1);

    public void setFilterBitmap(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFilterBitmap", $$robo$$android_graphics_Paint$setFilterBitmap(boolean ), 1, this, bl);
    }

    public Style getStyle() {
        return InvokeDynamicSupport.bootstrap("getStyle", $$robo$$android_graphics_Paint$getStyle(), 0, this);
    }

    public void setStyle(Style style2) {
        InvokeDynamicSupport.bootstrap("setStyle", $$robo$$android_graphics_Paint$setStyle(android.graphics.Paint$Style ), 0, this, style2);
    }

    private final native /* synthetic */ int $$robo$$getColor$nativeBinding();

    public int getColor() {
        return (int)InvokeDynamicSupport.bootstrap("getColor", $$robo$$android_graphics_Paint$getColor(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$setColor$nativeBinding(int var1);

    public void setColor(int n) {
        InvokeDynamicSupport.bootstrap("setColor", $$robo$$android_graphics_Paint$setColor(int ), 1, this, n);
    }

    private final native /* synthetic */ int $$robo$$getAlpha$nativeBinding();

    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_Paint$getAlpha(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$setAlpha$nativeBinding(int var1);

    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_Paint$setAlpha(int ), 1, this, n);
    }

    public void setARGB(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setARGB", $$robo$$android_graphics_Paint$setARGB(int int int int ), 0, this, n, n2, n3, n4);
    }

    private final native /* synthetic */ float $$robo$$getStrokeWidth$nativeBinding();

    public float getStrokeWidth() {
        return (float)InvokeDynamicSupport.bootstrap("getStrokeWidth", $$robo$$android_graphics_Paint$getStrokeWidth(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$setStrokeWidth$nativeBinding(float var1);

    public void setStrokeWidth(float f) {
        InvokeDynamicSupport.bootstrap("setStrokeWidth", $$robo$$android_graphics_Paint$setStrokeWidth(float ), 1, this, f);
    }

    private final native /* synthetic */ float $$robo$$getStrokeMiter$nativeBinding();

    public float getStrokeMiter() {
        return (float)InvokeDynamicSupport.bootstrap("getStrokeMiter", $$robo$$android_graphics_Paint$getStrokeMiter(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$setStrokeMiter$nativeBinding(float var1);

    public void setStrokeMiter(float f) {
        InvokeDynamicSupport.bootstrap("setStrokeMiter", $$robo$$android_graphics_Paint$setStrokeMiter(float ), 1, this, f);
    }

    public Cap getStrokeCap() {
        return InvokeDynamicSupport.bootstrap("getStrokeCap", $$robo$$android_graphics_Paint$getStrokeCap(), 0, this);
    }

    public void setStrokeCap(Cap cap) {
        InvokeDynamicSupport.bootstrap("setStrokeCap", $$robo$$android_graphics_Paint$setStrokeCap(android.graphics.Paint$Cap ), 0, this, cap);
    }

    public Join getStrokeJoin() {
        return InvokeDynamicSupport.bootstrap("getStrokeJoin", $$robo$$android_graphics_Paint$getStrokeJoin(), 0, this);
    }

    public void setStrokeJoin(Join join) {
        InvokeDynamicSupport.bootstrap("setStrokeJoin", $$robo$$android_graphics_Paint$setStrokeJoin(android.graphics.Paint$Join ), 0, this, join);
    }

    public boolean getFillPath(Path path, Path path2) {
        return (boolean)InvokeDynamicSupport.bootstrap("getFillPath", $$robo$$android_graphics_Paint$getFillPath(android.graphics.Path android.graphics.Path ), 0, this, path, path2);
    }

    public Shader getShader() {
        return InvokeDynamicSupport.bootstrap("getShader", $$robo$$android_graphics_Paint$getShader(), 0, this);
    }

    public Shader setShader(Shader shader) {
        return InvokeDynamicSupport.bootstrap("setShader", $$robo$$android_graphics_Paint$setShader(android.graphics.Shader ), 0, this, shader);
    }

    public ColorFilter getColorFilter() {
        return InvokeDynamicSupport.bootstrap("getColorFilter", $$robo$$android_graphics_Paint$getColorFilter(), 0, this);
    }

    public ColorFilter setColorFilter(ColorFilter colorFilter) {
        return InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_graphics_Paint$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
    }

    public Xfermode getXfermode() {
        return InvokeDynamicSupport.bootstrap("getXfermode", $$robo$$android_graphics_Paint$getXfermode(), 0, this);
    }

    public Xfermode setXfermode(Xfermode xfermode) {
        return InvokeDynamicSupport.bootstrap("setXfermode", $$robo$$android_graphics_Paint$setXfermode(android.graphics.Xfermode ), 0, this, xfermode);
    }

    public PathEffect getPathEffect() {
        return InvokeDynamicSupport.bootstrap("getPathEffect", $$robo$$android_graphics_Paint$getPathEffect(), 0, this);
    }

    public PathEffect setPathEffect(PathEffect pathEffect) {
        return InvokeDynamicSupport.bootstrap("setPathEffect", $$robo$$android_graphics_Paint$setPathEffect(android.graphics.PathEffect ), 0, this, pathEffect);
    }

    public MaskFilter getMaskFilter() {
        return InvokeDynamicSupport.bootstrap("getMaskFilter", $$robo$$android_graphics_Paint$getMaskFilter(), 0, this);
    }

    public MaskFilter setMaskFilter(MaskFilter maskFilter) {
        return InvokeDynamicSupport.bootstrap("setMaskFilter", $$robo$$android_graphics_Paint$setMaskFilter(android.graphics.MaskFilter ), 0, this, maskFilter);
    }

    public Typeface getTypeface() {
        return InvokeDynamicSupport.bootstrap("getTypeface", $$robo$$android_graphics_Paint$getTypeface(), 0, this);
    }

    public Typeface setTypeface(Typeface typeface) {
        return InvokeDynamicSupport.bootstrap("setTypeface", $$robo$$android_graphics_Paint$setTypeface(android.graphics.Typeface ), 0, this, typeface);
    }

    @Deprecated
    public Rasterizer getRasterizer() {
        return InvokeDynamicSupport.bootstrap("getRasterizer", $$robo$$android_graphics_Paint$getRasterizer(), 0, this);
    }

    @Deprecated
    public Rasterizer setRasterizer(Rasterizer rasterizer) {
        return InvokeDynamicSupport.bootstrap("setRasterizer", $$robo$$android_graphics_Paint$setRasterizer(android.graphics.Rasterizer ), 0, this, rasterizer);
    }

    public void setShadowLayer(float f, float f2, float f3, int n) {
        InvokeDynamicSupport.bootstrap("setShadowLayer", $$robo$$android_graphics_Paint$setShadowLayer(float float float int ), 0, this, f, f2, f3, n);
    }

    public void clearShadowLayer() {
        InvokeDynamicSupport.bootstrap("clearShadowLayer", $$robo$$android_graphics_Paint$clearShadowLayer(), 0, this);
    }

    public boolean hasShadowLayer() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasShadowLayer", $$robo$$android_graphics_Paint$hasShadowLayer(), 0, this);
    }

    public Align getTextAlign() {
        return InvokeDynamicSupport.bootstrap("getTextAlign", $$robo$$android_graphics_Paint$getTextAlign(), 0, this);
    }

    public void setTextAlign(Align align) {
        InvokeDynamicSupport.bootstrap("setTextAlign", $$robo$$android_graphics_Paint$setTextAlign(android.graphics.Paint$Align ), 0, this, align);
    }

    public Locale getTextLocale() {
        return InvokeDynamicSupport.bootstrap("getTextLocale", $$robo$$android_graphics_Paint$getTextLocale(), 0, this);
    }

    public void setTextLocale(Locale locale) {
        InvokeDynamicSupport.bootstrap("setTextLocale", $$robo$$android_graphics_Paint$setTextLocale(java.util.Locale ), 0, this, locale);
    }

    private final native /* synthetic */ boolean $$robo$$isElegantTextHeight$nativeBinding();

    public boolean isElegantTextHeight() {
        return (boolean)InvokeDynamicSupport.bootstrap("isElegantTextHeight", $$robo$$android_graphics_Paint$isElegantTextHeight(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$setElegantTextHeight$nativeBinding(boolean var1);

    public void setElegantTextHeight(boolean bl) {
        InvokeDynamicSupport.bootstrap("setElegantTextHeight", $$robo$$android_graphics_Paint$setElegantTextHeight(boolean ), 1, this, bl);
    }

    private final native /* synthetic */ float $$robo$$getTextSize$nativeBinding();

    public float getTextSize() {
        return (float)InvokeDynamicSupport.bootstrap("getTextSize", $$robo$$android_graphics_Paint$getTextSize(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$setTextSize$nativeBinding(float var1);

    public void setTextSize(float f) {
        InvokeDynamicSupport.bootstrap("setTextSize", $$robo$$android_graphics_Paint$setTextSize(float ), 1, this, f);
    }

    private final native /* synthetic */ float $$robo$$getTextScaleX$nativeBinding();

    public float getTextScaleX() {
        return (float)InvokeDynamicSupport.bootstrap("getTextScaleX", $$robo$$android_graphics_Paint$getTextScaleX(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$setTextScaleX$nativeBinding(float var1);

    public void setTextScaleX(float f) {
        InvokeDynamicSupport.bootstrap("setTextScaleX", $$robo$$android_graphics_Paint$setTextScaleX(float ), 1, this, f);
    }

    private final native /* synthetic */ float $$robo$$getTextSkewX$nativeBinding();

    public float getTextSkewX() {
        return (float)InvokeDynamicSupport.bootstrap("getTextSkewX", $$robo$$android_graphics_Paint$getTextSkewX(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$setTextSkewX$nativeBinding(float var1);

    public void setTextSkewX(float f) {
        InvokeDynamicSupport.bootstrap("setTextSkewX", $$robo$$android_graphics_Paint$setTextSkewX(float ), 1, this, f);
    }

    public float getLetterSpacing() {
        return (float)InvokeDynamicSupport.bootstrap("getLetterSpacing", $$robo$$android_graphics_Paint$getLetterSpacing(), 0, this);
    }

    public void setLetterSpacing(float f) {
        InvokeDynamicSupport.bootstrap("setLetterSpacing", $$robo$$android_graphics_Paint$setLetterSpacing(float ), 0, this, f);
    }

    public String getFontFeatureSettings() {
        return InvokeDynamicSupport.bootstrap("getFontFeatureSettings", $$robo$$android_graphics_Paint$getFontFeatureSettings(), 0, this);
    }

    public void setFontFeatureSettings(String string2) {
        InvokeDynamicSupport.bootstrap("setFontFeatureSettings", $$robo$$android_graphics_Paint$setFontFeatureSettings(java.lang.String ), 0, this, string2);
    }

    private final native /* synthetic */ float $$robo$$ascent$nativeBinding();

    public float ascent() {
        return (float)InvokeDynamicSupport.bootstrap("ascent", $$robo$$android_graphics_Paint$ascent(), 1, this);
    }

    private final native /* synthetic */ float $$robo$$descent$nativeBinding();

    public float descent() {
        return (float)InvokeDynamicSupport.bootstrap("descent", $$robo$$android_graphics_Paint$descent(), 1, this);
    }

    private final native /* synthetic */ float $$robo$$getFontMetrics$nativeBinding(FontMetrics var1);

    public float getFontMetrics(FontMetrics fontMetrics) {
        return (float)InvokeDynamicSupport.bootstrap("getFontMetrics", $$robo$$android_graphics_Paint$getFontMetrics(android.graphics.Paint$FontMetrics ), 1, this, fontMetrics);
    }

    public FontMetrics getFontMetrics() {
        return InvokeDynamicSupport.bootstrap("getFontMetrics", $$robo$$android_graphics_Paint$getFontMetrics(), 0, this);
    }

    private final native /* synthetic */ int $$robo$$getFontMetricsInt$nativeBinding(FontMetricsInt var1);

    public int getFontMetricsInt(FontMetricsInt fontMetricsInt) {
        return (int)InvokeDynamicSupport.bootstrap("getFontMetricsInt", $$robo$$android_graphics_Paint$getFontMetricsInt(android.graphics.Paint$FontMetricsInt ), 1, this, fontMetricsInt);
    }

    public FontMetricsInt getFontMetricsInt() {
        return InvokeDynamicSupport.bootstrap("getFontMetricsInt", $$robo$$android_graphics_Paint$getFontMetricsInt(), 0, this);
    }

    public float getFontSpacing() {
        return (float)InvokeDynamicSupport.bootstrap("getFontSpacing", $$robo$$android_graphics_Paint$getFontSpacing(), 0, this);
    }

    public float measureText(char[] cArray, int n, int n2) {
        return (float)InvokeDynamicSupport.bootstrap("measureText", $$robo$$android_graphics_Paint$measureText(char[] int int ), 0, this, cArray, n, n2);
    }

    private final native /* synthetic */ float $$robo$$native_measureText$nativeBinding(char[] var1, int var2, int var3, int var4);

    private float native_measureText(char[] cArray, int n, int n2, int n3) {
        return (float)InvokeDynamicSupport.bootstrap("native_measureText", $$robo$$android_graphics_Paint$native_measureText(char[] int int int ), 1, this, cArray, n, n2, n3);
    }

    public float measureText(String string2, int n, int n2) {
        return (float)InvokeDynamicSupport.bootstrap("measureText", $$robo$$android_graphics_Paint$measureText(java.lang.String int int ), 0, this, string2, n, n2);
    }

    private final native /* synthetic */ float $$robo$$native_measureText$nativeBinding(String var1, int var2, int var3, int var4);

    private float native_measureText(String string2, int n, int n2, int n3) {
        return (float)InvokeDynamicSupport.bootstrap("native_measureText", $$robo$$android_graphics_Paint$native_measureText(java.lang.String int int int ), 1, this, string2, n, n2, n3);
    }

    public float measureText(String string2) {
        return (float)InvokeDynamicSupport.bootstrap("measureText", $$robo$$android_graphics_Paint$measureText(java.lang.String ), 0, this, string2);
    }

    private final native /* synthetic */ float $$robo$$native_measureText$nativeBinding(String var1, int var2);

    private float native_measureText(String string2, int n) {
        return (float)InvokeDynamicSupport.bootstrap("native_measureText", $$robo$$android_graphics_Paint$native_measureText(java.lang.String int ), 1, this, string2, n);
    }

    public float measureText(CharSequence charSequence, int n, int n2) {
        return (float)InvokeDynamicSupport.bootstrap("measureText", $$robo$$android_graphics_Paint$measureText(java.lang.CharSequence int int ), 0, this, charSequence, n, n2);
    }

    public int breakText(char[] cArray, int n, int n2, float f, float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrap("breakText", $$robo$$android_graphics_Paint$breakText(char[] int int float float[] ), 0, this, cArray, n, n2, f, fArray);
    }

    private static final native /* synthetic */ int $$robo$$native_breakText$nativeBinding(long var0, long var2, char[] var4, int var5, int var6, float var7, int var8, float[] var9);

    private static int native_breakText(long l, long l2, char[] cArray, int n, int n2, float f, int n3, float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_breakText", $$robo$$android_graphics_Paint$native_breakText(long long char[] int int float int float[] ), 1, (long)l, (long)l2, (char[])cArray, (int)n, (int)n2, (float)f, (int)n3, (float[])fArray);
    }

    public int breakText(CharSequence charSequence, int n, int n2, boolean bl, float f, float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrap("breakText", $$robo$$android_graphics_Paint$breakText(java.lang.CharSequence int int boolean float float[] ), 0, this, charSequence, n, n2, bl, f, fArray);
    }

    public int breakText(String string2, boolean bl, float f, float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrap("breakText", $$robo$$android_graphics_Paint$breakText(java.lang.String boolean float float[] ), 0, this, string2, bl, f, fArray);
    }

    private static final native /* synthetic */ int $$robo$$native_breakText$nativeBinding(long var0, long var2, String var4, boolean var5, float var6, int var7, float[] var8);

    private static int native_breakText(long l, long l2, String string2, boolean bl, float f, int n, float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_breakText", $$robo$$android_graphics_Paint$native_breakText(long long java.lang.String boolean float int float[] ), 1, (long)l, (long)l2, (String)string2, (boolean)bl, (float)f, (int)n, (float[])fArray);
    }

    public int getTextWidths(char[] cArray, int n, int n2, float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrap("getTextWidths", $$robo$$android_graphics_Paint$getTextWidths(char[] int int float[] ), 0, this, cArray, n, n2, fArray);
    }

    public int getTextWidths(CharSequence charSequence, int n, int n2, float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrap("getTextWidths", $$robo$$android_graphics_Paint$getTextWidths(java.lang.CharSequence int int float[] ), 0, this, charSequence, n, n2, fArray);
    }

    public int getTextWidths(String string2, int n, int n2, float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrap("getTextWidths", $$robo$$android_graphics_Paint$getTextWidths(java.lang.String int int float[] ), 0, this, string2, n, n2, fArray);
    }

    public int getTextWidths(String string2, float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrap("getTextWidths", $$robo$$android_graphics_Paint$getTextWidths(java.lang.String float[] ), 0, this, string2, fArray);
    }

    public float getTextRunAdvances(char[] cArray, int n, int n2, int n3, int n4, boolean bl, float[] fArray, int n5) {
        return (float)InvokeDynamicSupport.bootstrap("getTextRunAdvances", $$robo$$android_graphics_Paint$getTextRunAdvances(char[] int int int int boolean float[] int ), 0, this, cArray, n, n2, n3, n4, bl, fArray, n5);
    }

    public float getTextRunAdvances(CharSequence charSequence, int n, int n2, int n3, int n4, boolean bl, float[] fArray, int n5) {
        return (float)InvokeDynamicSupport.bootstrap("getTextRunAdvances", $$robo$$android_graphics_Paint$getTextRunAdvances(java.lang.CharSequence int int int int boolean float[] int ), 0, this, charSequence, n, n2, n3, n4, bl, fArray, n5);
    }

    public float getTextRunAdvances(String string2, int n, int n2, int n3, int n4, boolean bl, float[] fArray, int n5) {
        return (float)InvokeDynamicSupport.bootstrap("getTextRunAdvances", $$robo$$android_graphics_Paint$getTextRunAdvances(java.lang.String int int int int boolean float[] int ), 0, this, string2, n, n2, n3, n4, bl, fArray, n5);
    }

    public int getTextRunCursor(char[] cArray, int n, int n2, int n3, int n4, int n5) {
        return (int)InvokeDynamicSupport.bootstrap("getTextRunCursor", $$robo$$android_graphics_Paint$getTextRunCursor(char[] int int int int int ), 0, this, cArray, n, n2, n3, n4, n5);
    }

    public int getTextRunCursor(CharSequence charSequence, int n, int n2, int n3, int n4, int n5) {
        return (int)InvokeDynamicSupport.bootstrap("getTextRunCursor", $$robo$$android_graphics_Paint$getTextRunCursor(java.lang.CharSequence int int int int int ), 0, this, charSequence, n, n2, n3, n4, n5);
    }

    public int getTextRunCursor(String string2, int n, int n2, int n3, int n4, int n5) {
        return (int)InvokeDynamicSupport.bootstrap("getTextRunCursor", $$robo$$android_graphics_Paint$getTextRunCursor(java.lang.String int int int int int ), 0, this, string2, n, n2, n3, n4, n5);
    }

    public void getTextPath(char[] cArray, int n, int n2, float f, float f2, Path path) {
        InvokeDynamicSupport.bootstrap("getTextPath", $$robo$$android_graphics_Paint$getTextPath(char[] int int float float android.graphics.Path ), 0, this, cArray, n, n2, f, f2, path);
    }

    public void getTextPath(String string2, int n, int n2, float f, float f2, Path path) {
        InvokeDynamicSupport.bootstrap("getTextPath", $$robo$$android_graphics_Paint$getTextPath(java.lang.String int int float float android.graphics.Path ), 0, this, string2, n, n2, f, f2, path);
    }

    public void getTextBounds(String string2, int n, int n2, Rect rect) {
        InvokeDynamicSupport.bootstrap("getTextBounds", $$robo$$android_graphics_Paint$getTextBounds(java.lang.String int int android.graphics.Rect ), 0, this, string2, n, n2, rect);
    }

    public void getTextBounds(char[] cArray, int n, int n2, Rect rect) {
        InvokeDynamicSupport.bootstrap("getTextBounds", $$robo$$android_graphics_Paint$getTextBounds(char[] int int android.graphics.Rect ), 0, this, cArray, n, n2, rect);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_graphics_Paint$finalize(), 0, this);
    }

    private static final native /* synthetic */ long $$robo$$native_init$nativeBinding();

    private static long native_init() {
        return (long)InvokeDynamicSupport.bootstrapStatic("native_init", $$robo$$android_graphics_Paint$native_init(), 1);
    }

    private static final native /* synthetic */ long $$robo$$native_initWithPaint$nativeBinding(long var0);

    private static long native_initWithPaint(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("native_initWithPaint", $$robo$$android_graphics_Paint$native_initWithPaint(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$native_reset$nativeBinding(long var0);

    private static void native_reset(long l) {
        InvokeDynamicSupport.bootstrapStatic("native_reset", $$robo$$android_graphics_Paint$native_reset(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$native_set$nativeBinding(long var0, long var2);

    private static void native_set(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("native_set", $$robo$$android_graphics_Paint$native_set(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ int $$robo$$native_getStyle$nativeBinding(long var0);

    private static int native_getStyle(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_getStyle", $$robo$$android_graphics_Paint$native_getStyle(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$native_setStyle$nativeBinding(long var0, int var2);

    private static void native_setStyle(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("native_setStyle", $$robo$$android_graphics_Paint$native_setStyle(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$native_getStrokeCap$nativeBinding(long var0);

    private static int native_getStrokeCap(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_getStrokeCap", $$robo$$android_graphics_Paint$native_getStrokeCap(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$native_setStrokeCap$nativeBinding(long var0, int var2);

    private static void native_setStrokeCap(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("native_setStrokeCap", $$robo$$android_graphics_Paint$native_setStrokeCap(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$native_getStrokeJoin$nativeBinding(long var0);

    private static int native_getStrokeJoin(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_getStrokeJoin", $$robo$$android_graphics_Paint$native_getStrokeJoin(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$native_setStrokeJoin$nativeBinding(long var0, int var2);

    private static void native_setStrokeJoin(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("native_setStrokeJoin", $$robo$$android_graphics_Paint$native_setStrokeJoin(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ boolean $$robo$$native_getFillPath$nativeBinding(long var0, long var2, long var4);

    private static boolean native_getFillPath(long l, long l2, long l3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("native_getFillPath", $$robo$$android_graphics_Paint$native_getFillPath(long long long ), 1, (long)l, (long)l2, (long)l3);
    }

    private static final native /* synthetic */ long $$robo$$native_setShader$nativeBinding(long var0, long var2);

    private static long native_setShader(long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("native_setShader", $$robo$$android_graphics_Paint$native_setShader(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ long $$robo$$native_setColorFilter$nativeBinding(long var0, long var2);

    private static long native_setColorFilter(long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("native_setColorFilter", $$robo$$android_graphics_Paint$native_setColorFilter(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ long $$robo$$native_setXfermode$nativeBinding(long var0, long var2);

    private static long native_setXfermode(long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("native_setXfermode", $$robo$$android_graphics_Paint$native_setXfermode(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ long $$robo$$native_setPathEffect$nativeBinding(long var0, long var2);

    private static long native_setPathEffect(long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("native_setPathEffect", $$robo$$android_graphics_Paint$native_setPathEffect(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ long $$robo$$native_setMaskFilter$nativeBinding(long var0, long var2);

    private static long native_setMaskFilter(long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("native_setMaskFilter", $$robo$$android_graphics_Paint$native_setMaskFilter(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ long $$robo$$native_setTypeface$nativeBinding(long var0, long var2);

    private static long native_setTypeface(long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("native_setTypeface", $$robo$$android_graphics_Paint$native_setTypeface(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ long $$robo$$native_setRasterizer$nativeBinding(long var0, long var2);

    private static long native_setRasterizer(long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("native_setRasterizer", $$robo$$android_graphics_Paint$native_setRasterizer(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ int $$robo$$native_getTextAlign$nativeBinding(long var0);

    private static int native_getTextAlign(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_getTextAlign", $$robo$$android_graphics_Paint$native_getTextAlign(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$native_setTextAlign$nativeBinding(long var0, int var2);

    private static void native_setTextAlign(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("native_setTextAlign", $$robo$$android_graphics_Paint$native_setTextAlign(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$native_setTextLocale$nativeBinding(long var0, String var2);

    private static void native_setTextLocale(long l, String string2) {
        InvokeDynamicSupport.bootstrapStatic("native_setTextLocale", $$robo$$android_graphics_Paint$native_setTextLocale(long java.lang.String ), 1, (long)l, (String)string2);
    }

    private static final native /* synthetic */ int $$robo$$native_getTextWidths$nativeBinding(long var0, long var2, char[] var4, int var5, int var6, int var7, float[] var8);

    private static int native_getTextWidths(long l, long l2, char[] cArray, int n, int n2, int n3, float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_getTextWidths", $$robo$$android_graphics_Paint$native_getTextWidths(long long char[] int int int float[] ), 1, (long)l, (long)l2, (char[])cArray, (int)n, (int)n2, (int)n3, (float[])fArray);
    }

    private static final native /* synthetic */ int $$robo$$native_getTextWidths$nativeBinding(long var0, long var2, String var4, int var5, int var6, int var7, float[] var8);

    private static int native_getTextWidths(long l, long l2, String string2, int n, int n2, int n3, float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_getTextWidths", $$robo$$android_graphics_Paint$native_getTextWidths(long long java.lang.String int int int float[] ), 1, (long)l, (long)l2, (String)string2, (int)n, (int)n2, (int)n3, (float[])fArray);
    }

    private static final native /* synthetic */ int $$robo$$native_getTextGlyphs$nativeBinding(long var0, String var2, int var3, int var4, int var5, int var6, int var7, char[] var8);

    private static int native_getTextGlyphs(long l, String string2, int n, int n2, int n3, int n4, int n5, char[] cArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_getTextGlyphs", $$robo$$android_graphics_Paint$native_getTextGlyphs(long java.lang.String int int int int int char[] ), 1, (long)l, (String)string2, (int)n, (int)n2, (int)n3, (int)n4, (int)n5, (char[])cArray);
    }

    private static final native /* synthetic */ float $$robo$$native_getTextRunAdvances$nativeBinding(long var0, long var2, char[] var4, int var5, int var6, int var7, int var8, boolean var9, float[] var10, int var11);

    private static float native_getTextRunAdvances(long l, long l2, char[] cArray, int n, int n2, int n3, int n4, boolean bl, float[] fArray, int n5) {
        return (float)InvokeDynamicSupport.bootstrapStatic("native_getTextRunAdvances", $$robo$$android_graphics_Paint$native_getTextRunAdvances(long long char[] int int int int boolean float[] int ), 1, (long)l, (long)l2, (char[])cArray, (int)n, (int)n2, (int)n3, (int)n4, (boolean)bl, (float[])fArray, (int)n5);
    }

    private static final native /* synthetic */ float $$robo$$native_getTextRunAdvances$nativeBinding(long var0, long var2, String var4, int var5, int var6, int var7, int var8, boolean var9, float[] var10, int var11);

    private static float native_getTextRunAdvances(long l, long l2, String string2, int n, int n2, int n3, int n4, boolean bl, float[] fArray, int n5) {
        return (float)InvokeDynamicSupport.bootstrapStatic("native_getTextRunAdvances", $$robo$$android_graphics_Paint$native_getTextRunAdvances(long long java.lang.String int int int int boolean float[] int ), 1, (long)l, (long)l2, (String)string2, (int)n, (int)n2, (int)n3, (int)n4, (boolean)bl, (float[])fArray, (int)n5);
    }

    private final native /* synthetic */ int $$robo$$native_getTextRunCursor$nativeBinding(long var1, char[] var3, int var4, int var5, int var6, int var7, int var8);

    private int native_getTextRunCursor(long l, char[] cArray, int n, int n2, int n3, int n4, int n5) {
        return (int)InvokeDynamicSupport.bootstrap("native_getTextRunCursor", $$robo$$android_graphics_Paint$native_getTextRunCursor(long char[] int int int int int ), 1, this, l, cArray, n, n2, n3, n4, n5);
    }

    private final native /* synthetic */ int $$robo$$native_getTextRunCursor$nativeBinding(long var1, String var3, int var4, int var5, int var6, int var7, int var8);

    private int native_getTextRunCursor(long l, String string2, int n, int n2, int n3, int n4, int n5) {
        return (int)InvokeDynamicSupport.bootstrap("native_getTextRunCursor", $$robo$$android_graphics_Paint$native_getTextRunCursor(long java.lang.String int int int int int ), 1, this, l, string2, n, n2, n3, n4, n5);
    }

    private static final native /* synthetic */ void $$robo$$native_getTextPath$nativeBinding(long var0, long var2, int var4, char[] var5, int var6, int var7, float var8, float var9, long var10);

    private static void native_getTextPath(long l, long l2, int n, char[] cArray, int n2, int n3, float f, float f2, long l3) {
        InvokeDynamicSupport.bootstrapStatic("native_getTextPath", $$robo$$android_graphics_Paint$native_getTextPath(long long int char[] int int float float long ), 1, (long)l, (long)l2, (int)n, (char[])cArray, (int)n2, (int)n3, (float)f, (float)f2, (long)l3);
    }

    private static final native /* synthetic */ void $$robo$$native_getTextPath$nativeBinding(long var0, long var2, int var4, String var5, int var6, int var7, float var8, float var9, long var10);

    private static void native_getTextPath(long l, long l2, int n, String string2, int n2, int n3, float f, float f2, long l3) {
        InvokeDynamicSupport.bootstrapStatic("native_getTextPath", $$robo$$android_graphics_Paint$native_getTextPath(long long int java.lang.String int int float float long ), 1, (long)l, (long)l2, (int)n, (String)string2, (int)n2, (int)n3, (float)f, (float)f2, (long)l3);
    }

    private static final native /* synthetic */ void $$robo$$nativeGetStringBounds$nativeBinding(long var0, long var2, String var4, int var5, int var6, int var7, Rect var8);

    private static void nativeGetStringBounds(long l, long l2, String string2, int n, int n2, int n3, Rect rect) {
        InvokeDynamicSupport.bootstrapStatic("nativeGetStringBounds", $$robo$$android_graphics_Paint$nativeGetStringBounds(long long java.lang.String int int int android.graphics.Rect ), 1, (long)l, (long)l2, (String)string2, (int)n, (int)n2, (int)n3, (Rect)rect);
    }

    private static final native /* synthetic */ void $$robo$$nativeGetCharArrayBounds$nativeBinding(long var0, long var2, char[] var4, int var5, int var6, int var7, Rect var8);

    private static void nativeGetCharArrayBounds(long l, long l2, char[] cArray, int n, int n2, int n3, Rect rect) {
        InvokeDynamicSupport.bootstrapStatic("nativeGetCharArrayBounds", $$robo$$android_graphics_Paint$nativeGetCharArrayBounds(long long char[] int int int android.graphics.Rect ), 1, (long)l, (long)l2, (char[])cArray, (int)n, (int)n2, (int)n3, (Rect)rect);
    }

    private static final native /* synthetic */ void $$robo$$finalizer$nativeBinding(long var0);

    private static void finalizer(long l) {
        InvokeDynamicSupport.bootstrapStatic("finalizer", $$robo$$android_graphics_Paint$finalizer(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$native_setShadowLayer$nativeBinding(long var0, float var2, float var3, float var4, int var5);

    private static void native_setShadowLayer(long l, float f, float f2, float f3, int n) {
        InvokeDynamicSupport.bootstrapStatic("native_setShadowLayer", $$robo$$android_graphics_Paint$native_setShadowLayer(long float float float int ), 1, (long)l, (float)f, (float)f2, (float)f3, (int)n);
    }

    private static final native /* synthetic */ boolean $$robo$$native_hasShadowLayer$nativeBinding(long var0);

    private static boolean native_hasShadowLayer(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("native_hasShadowLayer", $$robo$$android_graphics_Paint$native_hasShadowLayer(long ), 1, (long)l);
    }

    private static final native /* synthetic */ float $$robo$$native_getLetterSpacing$nativeBinding(long var0);

    private static float native_getLetterSpacing(long l) {
        return (float)InvokeDynamicSupport.bootstrapStatic("native_getLetterSpacing", $$robo$$android_graphics_Paint$native_getLetterSpacing(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$native_setLetterSpacing$nativeBinding(long var0, float var2);

    private static void native_setLetterSpacing(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("native_setLetterSpacing", $$robo$$android_graphics_Paint$native_setLetterSpacing(long float ), 1, (long)l, (float)f);
    }

    private static final native /* synthetic */ void $$robo$$native_setFontFeatureSettings$nativeBinding(long var0, String var2);

    private static void native_setFontFeatureSettings(long l, String string2) {
        InvokeDynamicSupport.bootstrapStatic("native_setFontFeatureSettings", $$robo$$android_graphics_Paint$native_setFontFeatureSettings(long java.lang.String ), 1, (long)l, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(Paint.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Paint)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class FontMetricsInt
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int top;
        public int ascent;
        public int descent;
        public int bottom;
        public int leading;

        private void $$robo$$android_graphics_Paint_FontMetricsInt$__constructor__() {
        }

        private final String $$robo$$android_graphics_Paint_FontMetricsInt$toString() {
            return "FontMetricsInt: top=" + this.top + " ascent=" + this.ascent + " descent=" + this.descent + " bottom=" + this.bottom + " leading=" + this.leading;
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_Paint_FontMetricsInt$__constructor__();
        }

        public FontMetricsInt() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Paint_FontMetricsInt$__constructor__(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_graphics_Paint_FontMetricsInt$toString(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FontMetricsInt)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class FontMetrics
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public float top;
        public float ascent;
        public float descent;
        public float bottom;
        public float leading;

        private void $$robo$$android_graphics_Paint_FontMetrics$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_Paint_FontMetrics$__constructor__();
        }

        public FontMetrics() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Paint_FontMetrics$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FontMetrics)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Align
    extends Enum<Align> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Align LEFT;
        public static /* enum */ Align CENTER;
        public static /* enum */ Align RIGHT;
        int nativeInt;
        private static /* synthetic */ Align[] $VALUES;

        private static final Align[] $$robo$$android_graphics_Paint_Align$values() {
            return (Align[])$VALUES.clone();
        }

        private static final Align $$robo$$android_graphics_Paint_Align$valueOf(String name) {
            return Enum.valueOf(Align.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_Paint_Align$__constructor__(String string2, int n, int nativeInt) {
            this.nativeInt = nativeInt;
        }

        static void __staticInitializer__() {
            LEFT = new Align(0);
            CENTER = new Align(1);
            RIGHT = new Align(2);
            $VALUES = new Align[]{LEFT, CENTER, RIGHT};
        }

        public static Align[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_Paint_Align$values(), 0);
        }

        public static Align valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Paint_Align$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_graphics_Paint_Align$__constructor__(string2, n, n2);
        }

        private Align(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Paint_Align$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(Align.class);
        }

        public /* synthetic */ Align() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Align)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Join
    extends Enum<Join> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Join MITER;
        public static /* enum */ Join ROUND;
        public static /* enum */ Join BEVEL;
        int nativeInt;
        private static /* synthetic */ Join[] $VALUES;

        private static final Join[] $$robo$$android_graphics_Paint_Join$values() {
            return (Join[])$VALUES.clone();
        }

        private static final Join $$robo$$android_graphics_Paint_Join$valueOf(String name) {
            return Enum.valueOf(Join.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_Paint_Join$__constructor__(String string2, int n, int nativeInt) {
            this.nativeInt = nativeInt;
        }

        static void __staticInitializer__() {
            MITER = new Join(0);
            ROUND = new Join(1);
            BEVEL = new Join(2);
            $VALUES = new Join[]{MITER, ROUND, BEVEL};
        }

        public static Join[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_Paint_Join$values(), 0);
        }

        public static Join valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Paint_Join$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_graphics_Paint_Join$__constructor__(string2, n, n2);
        }

        private Join(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Paint_Join$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(Join.class);
        }

        public /* synthetic */ Join() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Join)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Cap
    extends Enum<Cap> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Cap BUTT;
        public static /* enum */ Cap ROUND;
        public static /* enum */ Cap SQUARE;
        int nativeInt;
        private static /* synthetic */ Cap[] $VALUES;

        private static final Cap[] $$robo$$android_graphics_Paint_Cap$values() {
            return (Cap[])$VALUES.clone();
        }

        private static final Cap $$robo$$android_graphics_Paint_Cap$valueOf(String name) {
            return Enum.valueOf(Cap.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_Paint_Cap$__constructor__(String string2, int n, int nativeInt) {
            this.nativeInt = nativeInt;
        }

        static void __staticInitializer__() {
            BUTT = new Cap(0);
            ROUND = new Cap(1);
            SQUARE = new Cap(2);
            $VALUES = new Cap[]{BUTT, ROUND, SQUARE};
        }

        public static Cap[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_Paint_Cap$values(), 0);
        }

        public static Cap valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Paint_Cap$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_graphics_Paint_Cap$__constructor__(string2, n, n2);
        }

        private Cap(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Paint_Cap$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(Cap.class);
        }

        public /* synthetic */ Cap() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Cap)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Style
    extends Enum<Style> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Style FILL;
        public static /* enum */ Style STROKE;
        public static /* enum */ Style FILL_AND_STROKE;
        int nativeInt;
        private static /* synthetic */ Style[] $VALUES;

        private static final Style[] $$robo$$android_graphics_Paint_Style$values() {
            return (Style[])$VALUES.clone();
        }

        private static final Style $$robo$$android_graphics_Paint_Style$valueOf(String name) {
            return Enum.valueOf(Style.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_Paint_Style$__constructor__(String string2, int n, int nativeInt) {
            this.nativeInt = nativeInt;
        }

        static void __staticInitializer__() {
            FILL = new Style(0);
            STROKE = new Style(1);
            FILL_AND_STROKE = new Style(2);
            $VALUES = new Style[]{FILL, STROKE, FILL_AND_STROKE};
        }

        public static Style[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_Paint_Style$values(), 0);
        }

        public static Style valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Paint_Style$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_graphics_Paint_Style$__constructor__(string2, n, n2);
        }

        private Style(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Paint_Style$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(Style.class);
        }

        public /* synthetic */ Style() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Style)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

