/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.Region;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Path
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public long mNativePath;
    public boolean isSimplePath;
    public Region rects;
    private Direction mLastDirection;
    static FillType[] sFillTypeArray;

    private void $$robo$$android_graphics_Path$__constructor__() {
        this.isSimplePath = true;
        this.mLastDirection = null;
        this.mNativePath = Path.init1();
    }

    private void $$robo$$android_graphics_Path$__constructor__(Path src) {
        this.isSimplePath = true;
        this.mLastDirection = null;
        long valNative = 0L;
        if (src != null) {
            valNative = src.mNativePath;
            this.isSimplePath = src.isSimplePath;
            if (src.rects != null) {
                this.rects = new Region(src.rects);
            }
        }
        this.mNativePath = Path.init2(valNative);
    }

    private final void $$robo$$android_graphics_Path$reset() {
        this.isSimplePath = true;
        this.mLastDirection = null;
        if (this.rects != null) {
            this.rects.setEmpty();
        }
        FillType fillType = this.getFillType();
        Path.native_reset(this.mNativePath);
        this.setFillType(fillType);
    }

    private final void $$robo$$android_graphics_Path$rewind() {
        this.isSimplePath = true;
        this.mLastDirection = null;
        if (this.rects != null) {
            this.rects.setEmpty();
        }
        Path.native_rewind(this.mNativePath);
    }

    private final void $$robo$$android_graphics_Path$set(Path src) {
        if (this != src) {
            this.isSimplePath = src.isSimplePath;
            Path.native_set(this.mNativePath, src.mNativePath);
        }
    }

    private final boolean $$robo$$android_graphics_Path$op(Path path, Op op) {
        return this.op(this, path, op);
    }

    private final boolean $$robo$$android_graphics_Path$op(Path path1, Path path2, Op op) {
        if (Path.native_op(path1.mNativePath, path2.mNativePath, op.ordinal(), this.mNativePath)) {
            this.isSimplePath = false;
            this.rects = null;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_graphics_Path$isConvex() {
        return Path.native_isConvex(this.mNativePath);
    }

    private final FillType $$robo$$android_graphics_Path$getFillType() {
        return sFillTypeArray[Path.native_getFillType(this.mNativePath)];
    }

    private final void $$robo$$android_graphics_Path$setFillType(FillType ft) {
        Path.native_setFillType(this.mNativePath, ft.nativeInt);
    }

    private final boolean $$robo$$android_graphics_Path$isInverseFillType() {
        int ft = Path.native_getFillType(this.mNativePath);
        return (ft & FillType.INVERSE_WINDING.nativeInt) != 0;
    }

    private final void $$robo$$android_graphics_Path$toggleInverseFillType() {
        int ft = Path.native_getFillType(this.mNativePath);
        Path.native_setFillType(this.mNativePath, ft ^= FillType.INVERSE_WINDING.nativeInt);
    }

    private final boolean $$robo$$android_graphics_Path$isEmpty() {
        return Path.native_isEmpty(this.mNativePath);
    }

    private final boolean $$robo$$android_graphics_Path$isRect(RectF rect) {
        return Path.native_isRect(this.mNativePath, rect);
    }

    private final void $$robo$$android_graphics_Path$computeBounds(RectF bounds, boolean exact) {
        Path.native_computeBounds(this.mNativePath, bounds);
    }

    private final void $$robo$$android_graphics_Path$incReserve(int extraPtCount) {
        Path.native_incReserve(this.mNativePath, extraPtCount);
    }

    private final void $$robo$$android_graphics_Path$moveTo(float x, float y) {
        Path.native_moveTo(this.mNativePath, x, y);
    }

    private final void $$robo$$android_graphics_Path$rMoveTo(float dx, float dy) {
        Path.native_rMoveTo(this.mNativePath, dx, dy);
    }

    private final void $$robo$$android_graphics_Path$lineTo(float x, float y) {
        this.isSimplePath = false;
        Path.native_lineTo(this.mNativePath, x, y);
    }

    private final void $$robo$$android_graphics_Path$rLineTo(float dx, float dy) {
        this.isSimplePath = false;
        Path.native_rLineTo(this.mNativePath, dx, dy);
    }

    private final void $$robo$$android_graphics_Path$quadTo(float x1, float y1, float x2, float y2) {
        this.isSimplePath = false;
        Path.native_quadTo(this.mNativePath, x1, y1, x2, y2);
    }

    private final void $$robo$$android_graphics_Path$rQuadTo(float dx1, float dy1, float dx2, float dy2) {
        this.isSimplePath = false;
        Path.native_rQuadTo(this.mNativePath, dx1, dy1, dx2, dy2);
    }

    private final void $$robo$$android_graphics_Path$cubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.isSimplePath = false;
        Path.native_cubicTo(this.mNativePath, x1, y1, x2, y2, x3, y3);
    }

    private final void $$robo$$android_graphics_Path$rCubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.isSimplePath = false;
        Path.native_rCubicTo(this.mNativePath, x1, y1, x2, y2, x3, y3);
    }

    private final void $$robo$$android_graphics_Path$arcTo(RectF oval, float startAngle, float sweepAngle, boolean forceMoveTo) {
        this.arcTo(oval.left, oval.top, oval.right, oval.bottom, startAngle, sweepAngle, forceMoveTo);
    }

    private final void $$robo$$android_graphics_Path$arcTo(RectF oval, float startAngle, float sweepAngle) {
        this.arcTo(oval.left, oval.top, oval.right, oval.bottom, startAngle, sweepAngle, false);
    }

    private final void $$robo$$android_graphics_Path$arcTo(float left, float top, float right, float bottom, float startAngle, float sweepAngle, boolean forceMoveTo) {
        this.isSimplePath = false;
        Path.native_arcTo(this.mNativePath, left, top, right, bottom, startAngle, sweepAngle, forceMoveTo);
    }

    private final void $$robo$$android_graphics_Path$close() {
        this.isSimplePath = false;
        Path.native_close(this.mNativePath);
    }

    private final void $$robo$$android_graphics_Path$detectSimplePath(float left, float top, float right, float bottom, Direction dir) {
        if (this.mLastDirection == null) {
            this.mLastDirection = dir;
        }
        if (this.mLastDirection != dir) {
            this.isSimplePath = false;
        } else {
            if (this.rects == null) {
                this.rects = new Region();
            }
            this.rects.op((int)left, (int)top, (int)right, (int)bottom, Region.Op.UNION);
        }
    }

    private final void $$robo$$android_graphics_Path$addRect(RectF rect, Direction dir) {
        this.addRect(rect.left, rect.top, rect.right, rect.bottom, dir);
    }

    private final void $$robo$$android_graphics_Path$addRect(float left, float top, float right, float bottom, Direction dir) {
        this.detectSimplePath(left, top, right, bottom, dir);
        Path.native_addRect(this.mNativePath, left, top, right, bottom, dir.nativeInt);
    }

    private final void $$robo$$android_graphics_Path$addOval(RectF oval, Direction dir) {
        this.addOval(oval.left, oval.top, oval.right, oval.bottom, dir);
    }

    private final void $$robo$$android_graphics_Path$addOval(float left, float top, float right, float bottom, Direction dir) {
        this.isSimplePath = false;
        Path.native_addOval(this.mNativePath, left, top, right, bottom, dir.nativeInt);
    }

    private final void $$robo$$android_graphics_Path$addCircle(float x, float y, float radius, Direction dir) {
        this.isSimplePath = false;
        Path.native_addCircle(this.mNativePath, x, y, radius, dir.nativeInt);
    }

    private final void $$robo$$android_graphics_Path$addArc(RectF oval, float startAngle, float sweepAngle) {
        this.addArc(oval.left, oval.top, oval.right, oval.bottom, startAngle, sweepAngle);
    }

    private final void $$robo$$android_graphics_Path$addArc(float left, float top, float right, float bottom, float startAngle, float sweepAngle) {
        this.isSimplePath = false;
        Path.native_addArc(this.mNativePath, left, top, right, bottom, startAngle, sweepAngle);
    }

    private final void $$robo$$android_graphics_Path$addRoundRect(RectF rect, float rx, float ry, Direction dir) {
        this.addRoundRect(rect.left, rect.top, rect.right, rect.bottom, rx, ry, dir);
    }

    private final void $$robo$$android_graphics_Path$addRoundRect(float left, float top, float right, float bottom, float rx, float ry, Direction dir) {
        this.isSimplePath = false;
        Path.native_addRoundRect(this.mNativePath, left, top, right, bottom, rx, ry, dir.nativeInt);
    }

    private final void $$robo$$android_graphics_Path$addRoundRect(RectF rect, float[] radii, Direction dir) {
        if (rect == null) {
            throw new NullPointerException("need rect parameter");
        }
        this.addRoundRect(rect.left, rect.top, rect.right, rect.bottom, radii, dir);
    }

    private final void $$robo$$android_graphics_Path$addRoundRect(float left, float top, float right, float bottom, float[] radii, Direction dir) {
        if (radii.length < 8) {
            throw new ArrayIndexOutOfBoundsException("radii[] needs 8 values");
        }
        this.isSimplePath = false;
        Path.native_addRoundRect(this.mNativePath, left, top, right, bottom, radii, dir.nativeInt);
    }

    private final void $$robo$$android_graphics_Path$addPath(Path src, float dx, float dy) {
        this.isSimplePath = false;
        Path.native_addPath(this.mNativePath, src.mNativePath, dx, dy);
    }

    private final void $$robo$$android_graphics_Path$addPath(Path src) {
        this.isSimplePath = false;
        Path.native_addPath(this.mNativePath, src.mNativePath);
    }

    private final void $$robo$$android_graphics_Path$addPath(Path src, Matrix matrix) {
        if (!src.isSimplePath) {
            this.isSimplePath = false;
        }
        Path.native_addPath(this.mNativePath, src.mNativePath, matrix.native_instance);
    }

    private final void $$robo$$android_graphics_Path$offset(float dx, float dy, Path dst) {
        long dstNative = 0L;
        if (dst != null) {
            dstNative = dst.mNativePath;
            dst.isSimplePath = false;
        }
        Path.native_offset(this.mNativePath, dx, dy, dstNative);
    }

    private final void $$robo$$android_graphics_Path$offset(float dx, float dy) {
        this.isSimplePath = false;
        Path.native_offset(this.mNativePath, dx, dy);
    }

    private final void $$robo$$android_graphics_Path$setLastPoint(float dx, float dy) {
        this.isSimplePath = false;
        Path.native_setLastPoint(this.mNativePath, dx, dy);
    }

    private final void $$robo$$android_graphics_Path$transform(Matrix matrix, Path dst) {
        long dstNative = 0L;
        if (dst != null) {
            dst.isSimplePath = false;
            dstNative = dst.mNativePath;
        }
        Path.native_transform(this.mNativePath, matrix.native_instance, dstNative);
    }

    private final void $$robo$$android_graphics_Path$transform(Matrix matrix) {
        this.isSimplePath = false;
        Path.native_transform(this.mNativePath, matrix.native_instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_graphics_Path$finalize() throws Throwable {
        try {
            Path.finalizer(this.mNativePath);
        }
        finally {
            super.finalize();
        }
    }

    private final long $$robo$$android_graphics_Path$ni() {
        return this.mNativePath;
    }

    private final float[] $$robo$$android_graphics_Path$approximate(float acceptableError) {
        return Path.native_approximate(this.mNativePath, acceptableError);
    }

    private static final long $$robo$$android_graphics_Path$init1() {
        return 0L;
    }

    private static final long $$robo$$android_graphics_Path$init2(long l) {
        return 0L;
    }

    private static final void $$robo$$android_graphics_Path$native_reset(long l) {
    }

    private static final void $$robo$$android_graphics_Path$native_rewind(long l) {
    }

    private static final void $$robo$$android_graphics_Path$native_set(long l, long l2) {
    }

    private static final boolean $$robo$$android_graphics_Path$native_isConvex(long l) {
        return false;
    }

    private static final int $$robo$$android_graphics_Path$native_getFillType(long l) {
        return 0;
    }

    private static final void $$robo$$android_graphics_Path$native_setFillType(long l, int n) {
    }

    private static final boolean $$robo$$android_graphics_Path$native_isEmpty(long l) {
        return false;
    }

    private static final boolean $$robo$$android_graphics_Path$native_isRect(long l, RectF rectF) {
        return false;
    }

    private static final void $$robo$$android_graphics_Path$native_computeBounds(long l, RectF rectF) {
    }

    private static final void $$robo$$android_graphics_Path$native_incReserve(long l, int n) {
    }

    private static final void $$robo$$android_graphics_Path$native_moveTo(long l, float f, float f2) {
    }

    private static final void $$robo$$android_graphics_Path$native_rMoveTo(long l, float f, float f2) {
    }

    private static final void $$robo$$android_graphics_Path$native_lineTo(long l, float f, float f2) {
    }

    private static final void $$robo$$android_graphics_Path$native_rLineTo(long l, float f, float f2) {
    }

    private static final void $$robo$$android_graphics_Path$native_quadTo(long l, float f, float f2, float f3, float f4) {
    }

    private static final void $$robo$$android_graphics_Path$native_rQuadTo(long l, float f, float f2, float f3, float f4) {
    }

    private static final void $$robo$$android_graphics_Path$native_cubicTo(long l, float f, float f2, float f3, float f4, float f5, float f6) {
    }

    private static final void $$robo$$android_graphics_Path$native_rCubicTo(long l, float f, float f2, float f3, float f4, float f5, float f6) {
    }

    private static final void $$robo$$android_graphics_Path$native_arcTo(long l, float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
    }

    private static final void $$robo$$android_graphics_Path$native_close(long l) {
    }

    private static final void $$robo$$android_graphics_Path$native_addRect(long l, float f, float f2, float f3, float f4, int n) {
    }

    private static final void $$robo$$android_graphics_Path$native_addOval(long l, float f, float f2, float f3, float f4, int n) {
    }

    private static final void $$robo$$android_graphics_Path$native_addCircle(long l, float f, float f2, float f3, int n) {
    }

    private static final void $$robo$$android_graphics_Path$native_addArc(long l, float f, float f2, float f3, float f4, float f5, float f6) {
    }

    private static final void $$robo$$android_graphics_Path$native_addRoundRect(long l, float f, float f2, float f3, float f4, float f5, float f6, int n) {
    }

    private static final void $$robo$$android_graphics_Path$native_addRoundRect(long l, float f, float f2, float f3, float f4, float[] fArray, int n) {
    }

    private static final void $$robo$$android_graphics_Path$native_addPath(long l, long l2, float f, float f2) {
    }

    private static final void $$robo$$android_graphics_Path$native_addPath(long l, long l2) {
    }

    private static final void $$robo$$android_graphics_Path$native_addPath(long l, long l2, long l3) {
    }

    private static final void $$robo$$android_graphics_Path$native_offset(long l, float f, float f2, long l2) {
    }

    private static final void $$robo$$android_graphics_Path$native_offset(long l, float f, float f2) {
    }

    private static final void $$robo$$android_graphics_Path$native_setLastPoint(long l, float f, float f2) {
    }

    private static final void $$robo$$android_graphics_Path$native_transform(long l, long l2, long l3) {
    }

    private static final void $$robo$$android_graphics_Path$native_transform(long l, long l2) {
    }

    private static final boolean $$robo$$android_graphics_Path$native_op(long l, long l2, int n, long l3) {
        return false;
    }

    private static final void $$robo$$android_graphics_Path$finalizer(long l) {
    }

    private static final float[] $$robo$$android_graphics_Path$native_approximate(long l, float f) {
        return null;
    }

    static void __staticInitializer__() {
        sFillTypeArray = new FillType[]{FillType.WINDING, FillType.EVEN_ODD, FillType.INVERSE_WINDING, FillType.INVERSE_EVEN_ODD};
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_Path$__constructor__();
    }

    public Path() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Path$__constructor__(), 0, this);
    }

    private void __constructor__(Path path) {
        this.$$robo$$android_graphics_Path$__constructor__(path);
    }

    public Path(Path path) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Path$__constructor__(android.graphics.Path ), 0, this, path);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_graphics_Path$reset(), 0, this);
    }

    public void rewind() {
        InvokeDynamicSupport.bootstrap("rewind", $$robo$$android_graphics_Path$rewind(), 0, this);
    }

    public void set(Path path) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_graphics_Path$set(android.graphics.Path ), 0, this, path);
    }

    public boolean op(Path path, Op op) {
        return (boolean)InvokeDynamicSupport.bootstrap("op", $$robo$$android_graphics_Path$op(android.graphics.Path android.graphics.Path$Op ), 0, this, path, op);
    }

    public boolean op(Path path, Path path2, Op op) {
        return (boolean)InvokeDynamicSupport.bootstrap("op", $$robo$$android_graphics_Path$op(android.graphics.Path android.graphics.Path android.graphics.Path$Op ), 0, this, path, path2, op);
    }

    public boolean isConvex() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConvex", $$robo$$android_graphics_Path$isConvex(), 0, this);
    }

    public FillType getFillType() {
        return InvokeDynamicSupport.bootstrap("getFillType", $$robo$$android_graphics_Path$getFillType(), 0, this);
    }

    public void setFillType(FillType fillType) {
        InvokeDynamicSupport.bootstrap("setFillType", $$robo$$android_graphics_Path$setFillType(android.graphics.Path$FillType ), 0, this, fillType);
    }

    public boolean isInverseFillType() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInverseFillType", $$robo$$android_graphics_Path$isInverseFillType(), 0, this);
    }

    public void toggleInverseFillType() {
        InvokeDynamicSupport.bootstrap("toggleInverseFillType", $$robo$$android_graphics_Path$toggleInverseFillType(), 0, this);
    }

    public boolean isEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_graphics_Path$isEmpty(), 0, this);
    }

    public boolean isRect(RectF rectF) {
        return (boolean)InvokeDynamicSupport.bootstrap("isRect", $$robo$$android_graphics_Path$isRect(android.graphics.RectF ), 0, this, rectF);
    }

    public void computeBounds(RectF rectF, boolean bl) {
        InvokeDynamicSupport.bootstrap("computeBounds", $$robo$$android_graphics_Path$computeBounds(android.graphics.RectF boolean ), 0, this, rectF, bl);
    }

    public void incReserve(int n) {
        InvokeDynamicSupport.bootstrap("incReserve", $$robo$$android_graphics_Path$incReserve(int ), 0, this, n);
    }

    public void moveTo(float f, float f2) {
        InvokeDynamicSupport.bootstrap("moveTo", $$robo$$android_graphics_Path$moveTo(float float ), 0, this, f, f2);
    }

    public void rMoveTo(float f, float f2) {
        InvokeDynamicSupport.bootstrap("rMoveTo", $$robo$$android_graphics_Path$rMoveTo(float float ), 0, this, f, f2);
    }

    public void lineTo(float f, float f2) {
        InvokeDynamicSupport.bootstrap("lineTo", $$robo$$android_graphics_Path$lineTo(float float ), 0, this, f, f2);
    }

    public void rLineTo(float f, float f2) {
        InvokeDynamicSupport.bootstrap("rLineTo", $$robo$$android_graphics_Path$rLineTo(float float ), 0, this, f, f2);
    }

    public void quadTo(float f, float f2, float f3, float f4) {
        InvokeDynamicSupport.bootstrap("quadTo", $$robo$$android_graphics_Path$quadTo(float float float float ), 0, this, f, f2, f3, f4);
    }

    public void rQuadTo(float f, float f2, float f3, float f4) {
        InvokeDynamicSupport.bootstrap("rQuadTo", $$robo$$android_graphics_Path$rQuadTo(float float float float ), 0, this, f, f2, f3, f4);
    }

    public void cubicTo(float f, float f2, float f3, float f4, float f5, float f6) {
        InvokeDynamicSupport.bootstrap("cubicTo", $$robo$$android_graphics_Path$cubicTo(float float float float float float ), 0, this, f, f2, f3, f4, f5, f6);
    }

    public void rCubicTo(float f, float f2, float f3, float f4, float f5, float f6) {
        InvokeDynamicSupport.bootstrap("rCubicTo", $$robo$$android_graphics_Path$rCubicTo(float float float float float float ), 0, this, f, f2, f3, f4, f5, f6);
    }

    public void arcTo(RectF rectF, float f, float f2, boolean bl) {
        InvokeDynamicSupport.bootstrap("arcTo", $$robo$$android_graphics_Path$arcTo(android.graphics.RectF float float boolean ), 0, this, rectF, f, f2, bl);
    }

    public void arcTo(RectF rectF, float f, float f2) {
        InvokeDynamicSupport.bootstrap("arcTo", $$robo$$android_graphics_Path$arcTo(android.graphics.RectF float float ), 0, this, rectF, f, f2);
    }

    public void arcTo(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        InvokeDynamicSupport.bootstrap("arcTo", $$robo$$android_graphics_Path$arcTo(float float float float float float boolean ), 0, this, f, f2, f3, f4, f5, f6, bl);
    }

    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_graphics_Path$close(), 0, this);
    }

    private void detectSimplePath(float f, float f2, float f3, float f4, Direction direction) {
        InvokeDynamicSupport.bootstrap("detectSimplePath", $$robo$$android_graphics_Path$detectSimplePath(float float float float android.graphics.Path$Direction ), 0, this, f, f2, f3, f4, direction);
    }

    public void addRect(RectF rectF, Direction direction) {
        InvokeDynamicSupport.bootstrap("addRect", $$robo$$android_graphics_Path$addRect(android.graphics.RectF android.graphics.Path$Direction ), 0, this, rectF, direction);
    }

    public void addRect(float f, float f2, float f3, float f4, Direction direction) {
        InvokeDynamicSupport.bootstrap("addRect", $$robo$$android_graphics_Path$addRect(float float float float android.graphics.Path$Direction ), 0, this, f, f2, f3, f4, direction);
    }

    public void addOval(RectF rectF, Direction direction) {
        InvokeDynamicSupport.bootstrap("addOval", $$robo$$android_graphics_Path$addOval(android.graphics.RectF android.graphics.Path$Direction ), 0, this, rectF, direction);
    }

    public void addOval(float f, float f2, float f3, float f4, Direction direction) {
        InvokeDynamicSupport.bootstrap("addOval", $$robo$$android_graphics_Path$addOval(float float float float android.graphics.Path$Direction ), 0, this, f, f2, f3, f4, direction);
    }

    public void addCircle(float f, float f2, float f3, Direction direction) {
        InvokeDynamicSupport.bootstrap("addCircle", $$robo$$android_graphics_Path$addCircle(float float float android.graphics.Path$Direction ), 0, this, f, f2, f3, direction);
    }

    public void addArc(RectF rectF, float f, float f2) {
        InvokeDynamicSupport.bootstrap("addArc", $$robo$$android_graphics_Path$addArc(android.graphics.RectF float float ), 0, this, rectF, f, f2);
    }

    public void addArc(float f, float f2, float f3, float f4, float f5, float f6) {
        InvokeDynamicSupport.bootstrap("addArc", $$robo$$android_graphics_Path$addArc(float float float float float float ), 0, this, f, f2, f3, f4, f5, f6);
    }

    public void addRoundRect(RectF rectF, float f, float f2, Direction direction) {
        InvokeDynamicSupport.bootstrap("addRoundRect", $$robo$$android_graphics_Path$addRoundRect(android.graphics.RectF float float android.graphics.Path$Direction ), 0, this, rectF, f, f2, direction);
    }

    public void addRoundRect(float f, float f2, float f3, float f4, float f5, float f6, Direction direction) {
        InvokeDynamicSupport.bootstrap("addRoundRect", $$robo$$android_graphics_Path$addRoundRect(float float float float float float android.graphics.Path$Direction ), 0, this, f, f2, f3, f4, f5, f6, direction);
    }

    public void addRoundRect(RectF rectF, float[] fArray, Direction direction) {
        InvokeDynamicSupport.bootstrap("addRoundRect", $$robo$$android_graphics_Path$addRoundRect(android.graphics.RectF float[] android.graphics.Path$Direction ), 0, this, rectF, fArray, direction);
    }

    public void addRoundRect(float f, float f2, float f3, float f4, float[] fArray, Direction direction) {
        InvokeDynamicSupport.bootstrap("addRoundRect", $$robo$$android_graphics_Path$addRoundRect(float float float float float[] android.graphics.Path$Direction ), 0, this, f, f2, f3, f4, fArray, direction);
    }

    public void addPath(Path path, float f, float f2) {
        InvokeDynamicSupport.bootstrap("addPath", $$robo$$android_graphics_Path$addPath(android.graphics.Path float float ), 0, this, path, f, f2);
    }

    public void addPath(Path path) {
        InvokeDynamicSupport.bootstrap("addPath", $$robo$$android_graphics_Path$addPath(android.graphics.Path ), 0, this, path);
    }

    public void addPath(Path path, Matrix matrix) {
        InvokeDynamicSupport.bootstrap("addPath", $$robo$$android_graphics_Path$addPath(android.graphics.Path android.graphics.Matrix ), 0, this, path, matrix);
    }

    public void offset(float f, float f2, Path path) {
        InvokeDynamicSupport.bootstrap("offset", $$robo$$android_graphics_Path$offset(float float android.graphics.Path ), 0, this, f, f2, path);
    }

    public void offset(float f, float f2) {
        InvokeDynamicSupport.bootstrap("offset", $$robo$$android_graphics_Path$offset(float float ), 0, this, f, f2);
    }

    public void setLastPoint(float f, float f2) {
        InvokeDynamicSupport.bootstrap("setLastPoint", $$robo$$android_graphics_Path$setLastPoint(float float ), 0, this, f, f2);
    }

    public void transform(Matrix matrix, Path path) {
        InvokeDynamicSupport.bootstrap("transform", $$robo$$android_graphics_Path$transform(android.graphics.Matrix android.graphics.Path ), 0, this, matrix, path);
    }

    public void transform(Matrix matrix) {
        InvokeDynamicSupport.bootstrap("transform", $$robo$$android_graphics_Path$transform(android.graphics.Matrix ), 0, this, matrix);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_graphics_Path$finalize(), 0, this);
    }

    long ni() {
        return (long)InvokeDynamicSupport.bootstrap("ni", $$robo$$android_graphics_Path$ni(), 0, this);
    }

    public float[] approximate(float f) {
        return InvokeDynamicSupport.bootstrap("approximate", $$robo$$android_graphics_Path$approximate(float ), 0, this, f);
    }

    private static final native /* synthetic */ long $$robo$$init1$nativeBinding();

    private static long init1() {
        return (long)InvokeDynamicSupport.bootstrapStatic("init1", $$robo$$android_graphics_Path$init1(), 1);
    }

    private static final native /* synthetic */ long $$robo$$init2$nativeBinding(long var0);

    private static long init2(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("init2", $$robo$$android_graphics_Path$init2(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$native_reset$nativeBinding(long var0);

    private static void native_reset(long l) {
        InvokeDynamicSupport.bootstrapStatic("native_reset", $$robo$$android_graphics_Path$native_reset(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$native_rewind$nativeBinding(long var0);

    private static void native_rewind(long l) {
        InvokeDynamicSupport.bootstrapStatic("native_rewind", $$robo$$android_graphics_Path$native_rewind(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$native_set$nativeBinding(long var0, long var2);

    private static void native_set(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("native_set", $$robo$$android_graphics_Path$native_set(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ boolean $$robo$$native_isConvex$nativeBinding(long var0);

    private static boolean native_isConvex(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("native_isConvex", $$robo$$android_graphics_Path$native_isConvex(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$native_getFillType$nativeBinding(long var0);

    private static int native_getFillType(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_getFillType", $$robo$$android_graphics_Path$native_getFillType(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$native_setFillType$nativeBinding(long var0, int var2);

    private static void native_setFillType(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("native_setFillType", $$robo$$android_graphics_Path$native_setFillType(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ boolean $$robo$$native_isEmpty$nativeBinding(long var0);

    private static boolean native_isEmpty(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("native_isEmpty", $$robo$$android_graphics_Path$native_isEmpty(long ), 1, (long)l);
    }

    private static final native /* synthetic */ boolean $$robo$$native_isRect$nativeBinding(long var0, RectF var2);

    private static boolean native_isRect(long l, RectF rectF) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("native_isRect", $$robo$$android_graphics_Path$native_isRect(long android.graphics.RectF ), 1, (long)l, (RectF)rectF);
    }

    private static final native /* synthetic */ void $$robo$$native_computeBounds$nativeBinding(long var0, RectF var2);

    private static void native_computeBounds(long l, RectF rectF) {
        InvokeDynamicSupport.bootstrapStatic("native_computeBounds", $$robo$$android_graphics_Path$native_computeBounds(long android.graphics.RectF ), 1, (long)l, (RectF)rectF);
    }

    private static final native /* synthetic */ void $$robo$$native_incReserve$nativeBinding(long var0, int var2);

    private static void native_incReserve(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("native_incReserve", $$robo$$android_graphics_Path$native_incReserve(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$native_moveTo$nativeBinding(long var0, float var2, float var3);

    private static void native_moveTo(long l, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("native_moveTo", $$robo$$android_graphics_Path$native_moveTo(long float float ), 1, (long)l, (float)f, (float)f2);
    }

    private static final native /* synthetic */ void $$robo$$native_rMoveTo$nativeBinding(long var0, float var2, float var3);

    private static void native_rMoveTo(long l, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("native_rMoveTo", $$robo$$android_graphics_Path$native_rMoveTo(long float float ), 1, (long)l, (float)f, (float)f2);
    }

    private static final native /* synthetic */ void $$robo$$native_lineTo$nativeBinding(long var0, float var2, float var3);

    private static void native_lineTo(long l, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("native_lineTo", $$robo$$android_graphics_Path$native_lineTo(long float float ), 1, (long)l, (float)f, (float)f2);
    }

    private static final native /* synthetic */ void $$robo$$native_rLineTo$nativeBinding(long var0, float var2, float var3);

    private static void native_rLineTo(long l, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("native_rLineTo", $$robo$$android_graphics_Path$native_rLineTo(long float float ), 1, (long)l, (float)f, (float)f2);
    }

    private static final native /* synthetic */ void $$robo$$native_quadTo$nativeBinding(long var0, float var2, float var3, float var4, float var5);

    private static void native_quadTo(long l, float f, float f2, float f3, float f4) {
        InvokeDynamicSupport.bootstrapStatic("native_quadTo", $$robo$$android_graphics_Path$native_quadTo(long float float float float ), 1, (long)l, (float)f, (float)f2, (float)f3, (float)f4);
    }

    private static final native /* synthetic */ void $$robo$$native_rQuadTo$nativeBinding(long var0, float var2, float var3, float var4, float var5);

    private static void native_rQuadTo(long l, float f, float f2, float f3, float f4) {
        InvokeDynamicSupport.bootstrapStatic("native_rQuadTo", $$robo$$android_graphics_Path$native_rQuadTo(long float float float float ), 1, (long)l, (float)f, (float)f2, (float)f3, (float)f4);
    }

    private static final native /* synthetic */ void $$robo$$native_cubicTo$nativeBinding(long var0, float var2, float var3, float var4, float var5, float var6, float var7);

    private static void native_cubicTo(long l, float f, float f2, float f3, float f4, float f5, float f6) {
        InvokeDynamicSupport.bootstrapStatic("native_cubicTo", $$robo$$android_graphics_Path$native_cubicTo(long float float float float float float ), 1, (long)l, (float)f, (float)f2, (float)f3, (float)f4, (float)f5, (float)f6);
    }

    private static final native /* synthetic */ void $$robo$$native_rCubicTo$nativeBinding(long var0, float var2, float var3, float var4, float var5, float var6, float var7);

    private static void native_rCubicTo(long l, float f, float f2, float f3, float f4, float f5, float f6) {
        InvokeDynamicSupport.bootstrapStatic("native_rCubicTo", $$robo$$android_graphics_Path$native_rCubicTo(long float float float float float float ), 1, (long)l, (float)f, (float)f2, (float)f3, (float)f4, (float)f5, (float)f6);
    }

    private static final native /* synthetic */ void $$robo$$native_arcTo$nativeBinding(long var0, float var2, float var3, float var4, float var5, float var6, float var7, boolean var8);

    private static void native_arcTo(long l, float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("native_arcTo", $$robo$$android_graphics_Path$native_arcTo(long float float float float float float boolean ), 1, (long)l, (float)f, (float)f2, (float)f3, (float)f4, (float)f5, (float)f6, (boolean)bl);
    }

    private static final native /* synthetic */ void $$robo$$native_close$nativeBinding(long var0);

    private static void native_close(long l) {
        InvokeDynamicSupport.bootstrapStatic("native_close", $$robo$$android_graphics_Path$native_close(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$native_addRect$nativeBinding(long var0, float var2, float var3, float var4, float var5, int var6);

    private static void native_addRect(long l, float f, float f2, float f3, float f4, int n) {
        InvokeDynamicSupport.bootstrapStatic("native_addRect", $$robo$$android_graphics_Path$native_addRect(long float float float float int ), 1, (long)l, (float)f, (float)f2, (float)f3, (float)f4, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$native_addOval$nativeBinding(long var0, float var2, float var3, float var4, float var5, int var6);

    private static void native_addOval(long l, float f, float f2, float f3, float f4, int n) {
        InvokeDynamicSupport.bootstrapStatic("native_addOval", $$robo$$android_graphics_Path$native_addOval(long float float float float int ), 1, (long)l, (float)f, (float)f2, (float)f3, (float)f4, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$native_addCircle$nativeBinding(long var0, float var2, float var3, float var4, int var5);

    private static void native_addCircle(long l, float f, float f2, float f3, int n) {
        InvokeDynamicSupport.bootstrapStatic("native_addCircle", $$robo$$android_graphics_Path$native_addCircle(long float float float int ), 1, (long)l, (float)f, (float)f2, (float)f3, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$native_addArc$nativeBinding(long var0, float var2, float var3, float var4, float var5, float var6, float var7);

    private static void native_addArc(long l, float f, float f2, float f3, float f4, float f5, float f6) {
        InvokeDynamicSupport.bootstrapStatic("native_addArc", $$robo$$android_graphics_Path$native_addArc(long float float float float float float ), 1, (long)l, (float)f, (float)f2, (float)f3, (float)f4, (float)f5, (float)f6);
    }

    private static final native /* synthetic */ void $$robo$$native_addRoundRect$nativeBinding(long var0, float var2, float var3, float var4, float var5, float var6, float var7, int var8);

    private static void native_addRoundRect(long l, float f, float f2, float f3, float f4, float f5, float f6, int n) {
        InvokeDynamicSupport.bootstrapStatic("native_addRoundRect", $$robo$$android_graphics_Path$native_addRoundRect(long float float float float float float int ), 1, (long)l, (float)f, (float)f2, (float)f3, (float)f4, (float)f5, (float)f6, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$native_addRoundRect$nativeBinding(long var0, float var2, float var3, float var4, float var5, float[] var6, int var7);

    private static void native_addRoundRect(long l, float f, float f2, float f3, float f4, float[] fArray, int n) {
        InvokeDynamicSupport.bootstrapStatic("native_addRoundRect", $$robo$$android_graphics_Path$native_addRoundRect(long float float float float float[] int ), 1, (long)l, (float)f, (float)f2, (float)f3, (float)f4, (float[])fArray, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$native_addPath$nativeBinding(long var0, long var2, float var4, float var5);

    private static void native_addPath(long l, long l2, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("native_addPath", $$robo$$android_graphics_Path$native_addPath(long long float float ), 1, (long)l, (long)l2, (float)f, (float)f2);
    }

    private static final native /* synthetic */ void $$robo$$native_addPath$nativeBinding(long var0, long var2);

    private static void native_addPath(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("native_addPath", $$robo$$android_graphics_Path$native_addPath(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$native_addPath$nativeBinding(long var0, long var2, long var4);

    private static void native_addPath(long l, long l2, long l3) {
        InvokeDynamicSupport.bootstrapStatic("native_addPath", $$robo$$android_graphics_Path$native_addPath(long long long ), 1, (long)l, (long)l2, (long)l3);
    }

    private static final native /* synthetic */ void $$robo$$native_offset$nativeBinding(long var0, float var2, float var3, long var4);

    private static void native_offset(long l, float f, float f2, long l2) {
        InvokeDynamicSupport.bootstrapStatic("native_offset", $$robo$$android_graphics_Path$native_offset(long float float long ), 1, (long)l, (float)f, (float)f2, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$native_offset$nativeBinding(long var0, float var2, float var3);

    private static void native_offset(long l, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("native_offset", $$robo$$android_graphics_Path$native_offset(long float float ), 1, (long)l, (float)f, (float)f2);
    }

    private static final native /* synthetic */ void $$robo$$native_setLastPoint$nativeBinding(long var0, float var2, float var3);

    private static void native_setLastPoint(long l, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("native_setLastPoint", $$robo$$android_graphics_Path$native_setLastPoint(long float float ), 1, (long)l, (float)f, (float)f2);
    }

    private static final native /* synthetic */ void $$robo$$native_transform$nativeBinding(long var0, long var2, long var4);

    private static void native_transform(long l, long l2, long l3) {
        InvokeDynamicSupport.bootstrapStatic("native_transform", $$robo$$android_graphics_Path$native_transform(long long long ), 1, (long)l, (long)l2, (long)l3);
    }

    private static final native /* synthetic */ void $$robo$$native_transform$nativeBinding(long var0, long var2);

    private static void native_transform(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("native_transform", $$robo$$android_graphics_Path$native_transform(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ boolean $$robo$$native_op$nativeBinding(long var0, long var2, int var4, long var5);

    private static boolean native_op(long l, long l2, int n, long l3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("native_op", $$robo$$android_graphics_Path$native_op(long long int long ), 1, (long)l, (long)l2, (int)n, (long)l3);
    }

    private static final native /* synthetic */ void $$robo$$finalizer$nativeBinding(long var0);

    private static void finalizer(long l) {
        InvokeDynamicSupport.bootstrapStatic("finalizer", $$robo$$android_graphics_Path$finalizer(long ), 1, (long)l);
    }

    private static final native /* synthetic */ float[] $$robo$$native_approximate$nativeBinding(long var0, float var2);

    private static float[] native_approximate(long l, float f) {
        return InvokeDynamicSupport.bootstrapStatic("native_approximate", $$robo$$android_graphics_Path$native_approximate(long float ), 1, (long)l, (float)f);
    }

    static {
        RobolectricInternals.classInitializing(Path.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Path)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Direction
    extends Enum<Direction> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Direction CW;
        public static /* enum */ Direction CCW;
        int nativeInt;
        private static /* synthetic */ Direction[] $VALUES;

        private static final Direction[] $$robo$$android_graphics_Path_Direction$values() {
            return (Direction[])$VALUES.clone();
        }

        private static final Direction $$robo$$android_graphics_Path_Direction$valueOf(String name) {
            return Enum.valueOf(Direction.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_Path_Direction$__constructor__(String string2, int n, int ni) {
            this.nativeInt = ni;
        }

        static void __staticInitializer__() {
            CW = new Direction(1);
            CCW = new Direction(2);
            $VALUES = new Direction[]{CW, CCW};
        }

        public static Direction[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_Path_Direction$values(), 0);
        }

        public static Direction valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Path_Direction$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_graphics_Path_Direction$__constructor__(string2, n, n2);
        }

        private Direction(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Path_Direction$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(Direction.class);
        }

        public /* synthetic */ Direction() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Direction)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class FillType
    extends Enum<FillType> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ FillType WINDING;
        public static /* enum */ FillType EVEN_ODD;
        public static /* enum */ FillType INVERSE_WINDING;
        public static /* enum */ FillType INVERSE_EVEN_ODD;
        int nativeInt;
        private static /* synthetic */ FillType[] $VALUES;

        private static final FillType[] $$robo$$android_graphics_Path_FillType$values() {
            return (FillType[])$VALUES.clone();
        }

        private static final FillType $$robo$$android_graphics_Path_FillType$valueOf(String name) {
            return Enum.valueOf(FillType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_Path_FillType$__constructor__(String string2, int n, int ni) {
            this.nativeInt = ni;
        }

        static void __staticInitializer__() {
            WINDING = new FillType(0);
            EVEN_ODD = new FillType(1);
            INVERSE_WINDING = new FillType(2);
            INVERSE_EVEN_ODD = new FillType(3);
            $VALUES = new FillType[]{WINDING, EVEN_ODD, INVERSE_WINDING, INVERSE_EVEN_ODD};
        }

        public static FillType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_Path_FillType$values(), 0);
        }

        public static FillType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Path_FillType$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_graphics_Path_FillType$__constructor__(string2, n, n2);
        }

        private FillType(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Path_FillType$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(FillType.class);
        }

        public /* synthetic */ FillType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FillType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Op
    extends Enum<Op> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Op DIFFERENCE;
        public static /* enum */ Op INTERSECT;
        public static /* enum */ Op UNION;
        public static /* enum */ Op XOR;
        public static /* enum */ Op REVERSE_DIFFERENCE;
        private static /* synthetic */ Op[] $VALUES;

        private static final Op[] $$robo$$android_graphics_Path_Op$values() {
            return (Op[])$VALUES.clone();
        }

        private static final Op $$robo$$android_graphics_Path_Op$valueOf(String name) {
            return Enum.valueOf(Op.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_Path_Op$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            DIFFERENCE = new Op();
            INTERSECT = new Op();
            UNION = new Op();
            XOR = new Op();
            REVERSE_DIFFERENCE = new Op();
            $VALUES = new Op[]{DIFFERENCE, INTERSECT, UNION, XOR, REVERSE_DIFFERENCE};
        }

        public static Op[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_Path_Op$values(), 0);
        }

        public static Op valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Path_Op$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_graphics_Path_Op$__constructor__(string2, n);
        }

        private Op() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Path_Op$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(Op.class);
        }

        public /* synthetic */ Op() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Op)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

