/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.graphics.FontFamily;
import android.graphics.FontListParser;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.SparseArray;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

public class Typeface
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    public static Typeface DEFAULT;
    public static Typeface DEFAULT_BOLD;
    public static Typeface SANS_SERIF;
    public static Typeface SERIF;
    public static Typeface MONOSPACE;
    static Typeface[] sDefaults;
    private static LongSparseArray<SparseArray<Typeface>> sTypefaceCache;
    static Typeface sDefaultTypeface;
    static Map<String, Typeface> sSystemFontMap;
    static FontFamily[] sFallbackFonts;
    static String FONTS_CONFIG = "fonts.xml";
    public long native_instance;
    public static int NORMAL = 0;
    public static int BOLD = 1;
    public static int ITALIC = 2;
    public static int BOLD_ITALIC = 3;
    private int mStyle;

    private static final void $$robo$$android_graphics_Typeface$setDefault(Typeface t) {
        sDefaultTypeface = t;
        Typeface.nativeSetDefault(t.native_instance);
    }

    private final int $$robo$$android_graphics_Typeface$getStyle() {
        return this.mStyle;
    }

    private final boolean $$robo$$android_graphics_Typeface$isBold() {
        return (this.mStyle & 1) != 0;
    }

    private final boolean $$robo$$android_graphics_Typeface$isItalic() {
        return (this.mStyle & 2) != 0;
    }

    private static final Typeface $$robo$$android_graphics_Typeface$create(String familyName, int style2) {
        if (sSystemFontMap != null) {
            return Typeface.create(sSystemFontMap.get(familyName), style2);
        }
        return null;
    }

    private static final Typeface $$robo$$android_graphics_Typeface$create(Typeface family, int style2) {
        Typeface typeface;
        SparseArray<Typeface> styles;
        if (style2 < 0 || style2 > 3) {
            style2 = 0;
        }
        long ni = 0L;
        if (family != null) {
            if (family.mStyle == style2) {
                return family;
            }
            ni = family.native_instance;
        }
        if ((styles = sTypefaceCache.get(ni)) != null && (typeface = styles.get(style2)) != null) {
            return typeface;
        }
        typeface = new Typeface(Typeface.nativeCreateFromTypeface(ni, style2));
        if (styles == null) {
            styles = new SparseArray(4);
            sTypefaceCache.put(ni, styles);
        }
        styles.put(style2, typeface);
        return typeface;
    }

    private static final Typeface $$robo$$android_graphics_Typeface$defaultFromStyle(int style2) {
        return sDefaults[style2];
    }

    private static final Typeface $$robo$$android_graphics_Typeface$createFromAsset(AssetManager mgr, String path) {
        FontFamily fontFamily;
        if (sFallbackFonts != null && (fontFamily = new FontFamily()).addFontFromAsset(mgr, path)) {
            FontFamily[] families = new FontFamily[]{fontFamily};
            return Typeface.createFromFamiliesWithDefault(families);
        }
        throw new RuntimeException("Font asset not found " + path);
    }

    private static final Typeface $$robo$$android_graphics_Typeface$createFromFile(File path) {
        return Typeface.createFromFile(path.getAbsolutePath());
    }

    private static final Typeface $$robo$$android_graphics_Typeface$createFromFile(String path) {
        FontFamily fontFamily;
        if (sFallbackFonts != null && (fontFamily = new FontFamily()).addFont(path)) {
            FontFamily[] families = new FontFamily[]{fontFamily};
            return Typeface.createFromFamiliesWithDefault(families);
        }
        throw new RuntimeException("Font not found " + path);
    }

    private static final Typeface $$robo$$android_graphics_Typeface$createFromFamilies(FontFamily[] families) {
        long[] ptrArray = new long[families.length];
        for (int i = 0; i < families.length; ++i) {
            ptrArray[i] = families[i].mNativePtr;
        }
        return new Typeface(Typeface.nativeCreateFromArray(ptrArray));
    }

    private static final Typeface $$robo$$android_graphics_Typeface$createFromFamiliesWithDefault(FontFamily[] families) {
        int i;
        long[] ptrArray = new long[families.length + sFallbackFonts.length];
        for (i = 0; i < families.length; ++i) {
            ptrArray[i] = families[i].mNativePtr;
        }
        for (i = 0; i < sFallbackFonts.length; ++i) {
            ptrArray[i + families.length] = Typeface.sFallbackFonts[i].mNativePtr;
        }
        return new Typeface(Typeface.nativeCreateFromArray(ptrArray));
    }

    private void $$robo$$android_graphics_Typeface$__constructor__(long ni) {
        this.mStyle = 0;
        if (ni == 0L) {
            throw new RuntimeException("native typeface cannot be made");
        }
        this.native_instance = ni;
        this.mStyle = Typeface.nativeGetStyle(ni);
    }

    private static final FontFamily $$robo$$android_graphics_Typeface$makeFamilyFromParsed(FontListParser.Family family) {
        FontFamily fontFamily = new FontFamily(family.lang, family.variant);
        for (FontListParser.Font font : family.fonts) {
            fontFamily.addFontWeightStyle(font.fontName, font.weight, font.isItalic);
        }
        return fontFamily;
    }

    private static final void $$robo$$android_graphics_Typeface$init() {
        File systemFontConfigLocation = Typeface.getSystemFontConfigLocation();
        File configFilename = new File(systemFontConfigLocation, "fonts.xml");
        try {
            FileInputStream fontsIn = new FileInputStream(configFilename);
            FontListParser.Config fontConfig = FontListParser.parse(fontsIn);
            ArrayList<FontFamily> familyList = new ArrayList<FontFamily>();
            for (int i = 0; i < fontConfig.families.size(); ++i) {
                FontListParser.Family f = fontConfig.families.get(i);
                if (i != 0 && f.name != null) continue;
                familyList.add(Typeface.makeFamilyFromParsed(f));
            }
            sFallbackFonts = familyList.toArray(new FontFamily[familyList.size()]);
            Typeface.setDefault(Typeface.createFromFamilies(sFallbackFonts));
            HashMap<String, Typeface> systemFonts = new HashMap<String, Typeface>();
            for (int i = 0; i < fontConfig.families.size(); ++i) {
                Typeface typeface;
                FontListParser.Family f = fontConfig.families.get(i);
                if (f.name == null) continue;
                if (i == 0) {
                    typeface = sDefaultTypeface;
                } else {
                    FontFamily fontFamily = Typeface.makeFamilyFromParsed(f);
                    FontFamily[] families = new FontFamily[]{fontFamily};
                    typeface = Typeface.createFromFamiliesWithDefault(families);
                }
                systemFonts.put(f.name, typeface);
            }
            for (FontListParser.Alias alias : fontConfig.aliases) {
                Typeface base;
                Typeface newFace = base = (Typeface)systemFonts.get(alias.toName);
                int weight = alias.weight;
                if (weight != 400) {
                    newFace = new Typeface(Typeface.nativeCreateWeightAlias(base.native_instance, weight));
                }
                systemFonts.put(alias.name, newFace);
            }
            sSystemFontMap = systemFonts;
        }
        catch (RuntimeException e) {
            Log.w(TAG, "Didn't create default family (most likely, non-Minikin build)", e);
        }
        catch (FileNotFoundException e) {
            Log.e(TAG, "Error opening " + configFilename);
        }
        catch (IOException e) {
            Log.e(TAG, "Error reading " + configFilename);
        }
        catch (XmlPullParserException e) {
            Log.e(TAG, "XML parse exception for " + configFilename);
        }
    }

    private static final File $$robo$$android_graphics_Typeface$getSystemFontConfigLocation() {
        return new File("/system/etc/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_graphics_Typeface$finalize() throws Throwable {
        try {
            Typeface.nativeUnref(this.native_instance);
        }
        finally {
            super.finalize();
        }
    }

    private final boolean $$robo$$android_graphics_Typeface$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Typeface typeface = (Typeface)o;
        return this.mStyle == typeface.mStyle && this.native_instance == typeface.native_instance;
    }

    private final int $$robo$$android_graphics_Typeface$hashCode() {
        int result = 17;
        result = 31 * result + (int)(this.native_instance ^ this.native_instance >>> 32);
        result = 31 * result + this.mStyle;
        return result;
    }

    private static final long $$robo$$android_graphics_Typeface$nativeCreateFromTypeface(long l, int n) {
        return 0L;
    }

    private static final long $$robo$$android_graphics_Typeface$nativeCreateWeightAlias(long l, int n) {
        return 0L;
    }

    private static final void $$robo$$android_graphics_Typeface$nativeUnref(long l) {
    }

    private static final int $$robo$$android_graphics_Typeface$nativeGetStyle(long l) {
        return 0;
    }

    private static final long $$robo$$android_graphics_Typeface$nativeCreateFromArray(long[] lArray) {
        return 0L;
    }

    private static final void $$robo$$android_graphics_Typeface$nativeSetDefault(long l) {
    }

    static void __staticInitializer__() {
        TAG = "Typeface";
        sTypefaceCache = new LongSparseArray(3);
        Typeface.init();
        DEFAULT = Typeface.create((String)null, 0);
        DEFAULT_BOLD = Typeface.create((String)null, 1);
        SANS_SERIF = Typeface.create("sans-serif", 0);
        SERIF = Typeface.create("serif", 0);
        MONOSPACE = Typeface.create("monospace", 0);
        sDefaults = new Typeface[]{DEFAULT, DEFAULT_BOLD, Typeface.create((String)null, 2), Typeface.create((String)null, 3)};
    }

    private static void setDefault(Typeface typeface) {
        InvokeDynamicSupport.bootstrapStatic("setDefault", $$robo$$android_graphics_Typeface$setDefault(android.graphics.Typeface ), 0, (Typeface)typeface);
    }

    public int getStyle() {
        return (int)InvokeDynamicSupport.bootstrap("getStyle", $$robo$$android_graphics_Typeface$getStyle(), 0, this);
    }

    public boolean isBold() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBold", $$robo$$android_graphics_Typeface$isBold(), 0, this);
    }

    public boolean isItalic() {
        return (boolean)InvokeDynamicSupport.bootstrap("isItalic", $$robo$$android_graphics_Typeface$isItalic(), 0, this);
    }

    public static Typeface create(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_graphics_Typeface$create(java.lang.String int ), 0, (String)string2, (int)n);
    }

    public static Typeface create(Typeface typeface, int n) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_graphics_Typeface$create(android.graphics.Typeface int ), 0, (Typeface)typeface, (int)n);
    }

    public static Typeface defaultFromStyle(int n) {
        return InvokeDynamicSupport.bootstrapStatic("defaultFromStyle", $$robo$$android_graphics_Typeface$defaultFromStyle(int ), 0, (int)n);
    }

    public static Typeface createFromAsset(AssetManager assetManager, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createFromAsset", $$robo$$android_graphics_Typeface$createFromAsset(android.content.res.AssetManager java.lang.String ), 0, (AssetManager)assetManager, (String)string2);
    }

    public static Typeface createFromFile(File file) {
        return InvokeDynamicSupport.bootstrapStatic("createFromFile", $$robo$$android_graphics_Typeface$createFromFile(java.io.File ), 0, (File)file);
    }

    public static Typeface createFromFile(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createFromFile", $$robo$$android_graphics_Typeface$createFromFile(java.lang.String ), 0, (String)string2);
    }

    public static Typeface createFromFamilies(FontFamily[] fontFamilyArray) {
        return InvokeDynamicSupport.bootstrapStatic("createFromFamilies", $$robo$$android_graphics_Typeface$createFromFamilies(android.graphics.FontFamily[] ), 0, (FontFamily[])fontFamilyArray);
    }

    public static Typeface createFromFamiliesWithDefault(FontFamily[] fontFamilyArray) {
        return InvokeDynamicSupport.bootstrapStatic("createFromFamiliesWithDefault", $$robo$$android_graphics_Typeface$createFromFamiliesWithDefault(android.graphics.FontFamily[] ), 0, (FontFamily[])fontFamilyArray);
    }

    private void __constructor__(long l) {
        this.$$robo$$android_graphics_Typeface$__constructor__(l);
    }

    private Typeface(long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Typeface$__constructor__(long ), 0, this, l);
    }

    private static FontFamily makeFamilyFromParsed(FontListParser.Family family) {
        return InvokeDynamicSupport.bootstrapStatic("makeFamilyFromParsed", $$robo$$android_graphics_Typeface$makeFamilyFromParsed(android.graphics.FontListParser$Family ), 0, (FontListParser.Family)family);
    }

    private static void init() {
        InvokeDynamicSupport.bootstrapStatic("init", $$robo$$android_graphics_Typeface$init(), 0);
    }

    private static File getSystemFontConfigLocation() {
        return InvokeDynamicSupport.bootstrapStatic("getSystemFontConfigLocation", $$robo$$android_graphics_Typeface$getSystemFontConfigLocation(), 0);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_graphics_Typeface$finalize(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_graphics_Typeface$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_graphics_Typeface$hashCode(), 0, this);
    }

    private static final native /* synthetic */ long $$robo$$nativeCreateFromTypeface$nativeBinding(long var0, int var2);

    private static long nativeCreateFromTypeface(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeCreateFromTypeface", $$robo$$android_graphics_Typeface$nativeCreateFromTypeface(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ long $$robo$$nativeCreateWeightAlias$nativeBinding(long var0, int var2);

    private static long nativeCreateWeightAlias(long l, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeCreateWeightAlias", $$robo$$android_graphics_Typeface$nativeCreateWeightAlias(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nativeUnref$nativeBinding(long var0);

    private static void nativeUnref(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeUnref", $$robo$$android_graphics_Typeface$nativeUnref(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetStyle$nativeBinding(long var0);

    private static int nativeGetStyle(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetStyle", $$robo$$android_graphics_Typeface$nativeGetStyle(long ), 1, (long)l);
    }

    private static final native /* synthetic */ long $$robo$$nativeCreateFromArray$nativeBinding(long[] var0);

    private static long nativeCreateFromArray(long[] lArray) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeCreateFromArray", $$robo$$android_graphics_Typeface$nativeCreateFromArray(long[] ), 1, (long[])lArray);
    }

    private static final native /* synthetic */ void $$robo$$nativeSetDefault$nativeBinding(long var0);

    private static void nativeSetDefault(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetDefault", $$robo$$android_graphics_Typeface$nativeSetDefault(long ), 1, (long)l);
    }

    static {
        RobolectricInternals.classInitializing(Typeface.class);
    }

    public /* synthetic */ Typeface() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Typeface)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

