/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatedRotateDrawable
extends Drawable
implements Drawable.Callback,
Runnable,
Animatable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private AnimatedRotateState mState;
    private boolean mMutated;
    private float mCurrentDegrees;
    private float mIncrement;
    private boolean mRunning;

    private void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$__constructor__() {
    }

    private void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$__constructor__(AnimatedRotateState rotateState, Resources res) {
        this.mState = new AnimatedRotateState(rotateState, this, res);
        this.init();
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$init() {
        AnimatedRotateState state = this.mState;
        this.mIncrement = 360.0f / (float)state.mFramesCount;
        Drawable drawable2 = state.mDrawable;
        if (drawable2 != null) {
            drawable2.setFilterBitmap(true);
            if (drawable2 instanceof BitmapDrawable) {
                ((BitmapDrawable)drawable2).setAntiAlias(true);
            }
        }
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$draw(Canvas canvas) {
        int saveCount = canvas.save();
        AnimatedRotateState st = this.mState;
        Drawable drawable2 = st.mDrawable;
        Rect bounds = drawable2.getBounds();
        int w = bounds.right - bounds.left;
        int h = bounds.bottom - bounds.top;
        float px = st.mPivotXRel ? (float)w * st.mPivotX : st.mPivotX;
        float py = st.mPivotYRel ? (float)h * st.mPivotY : st.mPivotY;
        canvas.rotate(this.mCurrentDegrees, px + (float)bounds.left, py + (float)bounds.top);
        drawable2.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$start() {
        if (!this.mRunning) {
            this.mRunning = true;
            this.nextFrame();
        }
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$stop() {
        this.mRunning = false;
        this.unscheduleSelf(this);
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedRotateDrawable$isRunning() {
        return this.mRunning;
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$nextFrame() {
        this.unscheduleSelf(this);
        this.scheduleSelf(this, SystemClock.uptimeMillis() + (long)this.mState.mFrameDuration);
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$run() {
        this.mCurrentDegrees += this.mIncrement;
        if (this.mCurrentDegrees > 360.0f - this.mIncrement) {
            this.mCurrentDegrees = 0.0f;
        }
        this.invalidateSelf();
        this.nextFrame();
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedRotateDrawable$setVisible(boolean visible, boolean restart) {
        this.mState.mDrawable.setVisible(visible, restart);
        boolean changed = super.setVisible(visible, restart);
        if (visible) {
            if (changed || restart) {
                this.mCurrentDegrees = 0.0f;
                this.nextFrame();
            }
        } else {
            this.unscheduleSelf(this);
        }
        return changed;
    }

    private final Drawable $$robo$$android_graphics_drawable_AnimatedRotateDrawable$getDrawable() {
        return this.mState.mDrawable;
    }

    private final int $$robo$$android_graphics_drawable_AnimatedRotateDrawable$getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mState.mChangingConfigurations | this.mState.mDrawable.getChangingConfigurations();
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$setAlpha(int alpha) {
        this.mState.mDrawable.setAlpha(alpha);
    }

    private final int $$robo$$android_graphics_drawable_AnimatedRotateDrawable$getAlpha() {
        return this.mState.mDrawable.getAlpha();
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$setColorFilter(ColorFilter cf) {
        this.mState.mDrawable.setColorFilter(cf);
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$setTintList(ColorStateList tint) {
        this.mState.mDrawable.setTintList(tint);
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$setTintMode(PorterDuff.Mode tintMode) {
        this.mState.mDrawable.setTintMode(tintMode);
    }

    private final int $$robo$$android_graphics_drawable_AnimatedRotateDrawable$getOpacity() {
        return this.mState.mDrawable.getOpacity();
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$invalidateDrawable(Drawable who) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable(this);
        }
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$scheduleDrawable(Drawable who, Runnable what, long when) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable(this, what, when);
        }
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$unscheduleDrawable(Drawable who, Runnable what) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable(this, what);
        }
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedRotateDrawable$getPadding(Rect padding) {
        return this.mState.mDrawable.getPadding(padding);
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedRotateDrawable$isStateful() {
        return this.mState.mDrawable.isStateful();
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$onBoundsChange(Rect bounds) {
        this.mState.mDrawable.setBounds(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedRotateDrawable$onLevelChange(int level) {
        return this.mState.mDrawable.setLevel(level);
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedRotateDrawable$onStateChange(int[] state) {
        return this.mState.mDrawable.setState(state);
    }

    private final int $$robo$$android_graphics_drawable_AnimatedRotateDrawable$getIntrinsicWidth() {
        return this.mState.mDrawable.getIntrinsicWidth();
    }

    private final int $$robo$$android_graphics_drawable_AnimatedRotateDrawable$getIntrinsicHeight() {
        return this.mState.mDrawable.getIntrinsicHeight();
    }

    private final Drawable.ConstantState $$robo$$android_graphics_drawable_AnimatedRotateDrawable$getConstantState() {
        if (this.mState.canConstantState()) {
            this.mState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mState;
        }
        return null;
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int type;
        TypedArray a = AnimatedRotateDrawable.obtainAttributes(r, theme, attrs, R.styleable.AnimatedRotateDrawable);
        super.inflateWithAttributes(r, parser, a, 0);
        TypedValue tv = a.peekValue(2);
        boolean pivotXRel = tv.type == 6;
        float pivotX = pivotXRel ? tv.getFraction(1.0f, 1.0f) : tv.getFloat();
        tv = a.peekValue(3);
        boolean pivotYRel = tv.type == 6;
        float pivotY = pivotYRel ? tv.getFraction(1.0f, 1.0f) : tv.getFloat();
        this.setFramesCount(a.getInt(5, 12));
        this.setFramesDuration(a.getInt(4, 150));
        int res = a.getResourceId(1, 0);
        Drawable drawable2 = null;
        if (res > 0) {
            drawable2 = r.getDrawable(res, theme);
        }
        a.recycle();
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type != 2 || (drawable2 = Drawable.createFromXmlInner(r, parser, attrs, theme)) != null) continue;
            Log.w("drawable", "Bad element under <animated-rotate>: " + parser.getName());
        }
        if (drawable2 == null) {
            Log.w("drawable", "No drawable specified for <animated-rotate>");
        }
        AnimatedRotateState rotateState = this.mState;
        rotateState.mDrawable = drawable2;
        rotateState.mPivotXRel = pivotXRel;
        rotateState.mPivotX = pivotX;
        rotateState.mPivotYRel = pivotYRel;
        rotateState.mPivotY = pivotY;
        this.init();
        if (drawable2 != null) {
            drawable2.setCallback(this);
        }
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$setFramesCount(int framesCount) {
        this.mState.mFramesCount = framesCount;
        this.mIncrement = 360.0f / (float)this.mState.mFramesCount;
    }

    private final void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$setFramesDuration(int framesDuration) {
        this.mState.mFrameDuration = framesDuration;
    }

    private final Drawable $$robo$$android_graphics_drawable_AnimatedRotateDrawable$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mState.mDrawable.mutate();
            this.mMutated = true;
        }
        return this;
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_AnimatedRotateDrawable$__constructor__(AnimatedRotateState x0, Resources x1, 1 x2) {
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_AnimatedRotateDrawable$__constructor__();
    }

    public AnimatedRotateDrawable() {
        this(null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$__constructor__(), 0, this);
    }

    private void __constructor__(AnimatedRotateState animatedRotateState, Resources resources) {
        this.$$robo$$android_graphics_drawable_AnimatedRotateDrawable$__constructor__(animatedRotateState, resources);
    }

    private AnimatedRotateDrawable(AnimatedRotateState animatedRotateState, Resources resources) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$__constructor__(android.graphics.drawable.AnimatedRotateDrawable$AnimatedRotateState android.content.res.Resources ), 0, this, animatedRotateState, resources);
    }

    private void init() {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$init(), 0, this);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$start(), 0, this);
    }

    @Override
    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$stop(), 0, this);
    }

    @Override
    public boolean isRunning() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRunning", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$isRunning(), 0, this);
    }

    private void nextFrame() {
        InvokeDynamicSupport.bootstrap("nextFrame", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$nextFrame(), 0, this);
    }

    @Override
    public void run() {
        InvokeDynamicSupport.bootstrap("run", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$run(), 0, this);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setVisible", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$setVisible(boolean boolean ), 0, this, bl, bl2);
    }

    public Drawable getDrawable() {
        return InvokeDynamicSupport.bootstrap("getDrawable", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$getDrawable(), 0, this);
    }

    @Override
    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$getChangingConfigurations(), 0, this);
    }

    @Override
    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$setAlpha(int ), 0, this, n);
    }

    @Override
    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$getAlpha(), 0, this);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setTintList", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$setTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setTintMode", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$setTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$getOpacity(), 0, this);
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("invalidateDrawable", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$invalidateDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        InvokeDynamicSupport.bootstrap("scheduleDrawable", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$scheduleDrawable(android.graphics.drawable.Drawable java.lang.Runnable long ), 0, this, drawable2, runnable, l);
    }

    @Override
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        InvokeDynamicSupport.bootstrap("unscheduleDrawable", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$unscheduleDrawable(android.graphics.drawable.Drawable java.lang.Runnable ), 0, this, drawable2, runnable);
    }

    @Override
    public boolean getPadding(Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getPadding", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$getPadding(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$isStateful(), 0, this);
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        InvokeDynamicSupport.bootstrap("onBoundsChange", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$onBoundsChange(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    protected boolean onLevelChange(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLevelChange", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$onLevelChange(int ), 0, this, n);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$onStateChange(int[] ), 0, this, nArray);
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicWidth", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$getIntrinsicWidth(), 0, this);
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicHeight", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$getIntrinsicHeight(), 0, this);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$getConstantState(), 0, this);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    public void setFramesCount(int n) {
        InvokeDynamicSupport.bootstrap("setFramesCount", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$setFramesCount(int ), 0, this, n);
    }

    public void setFramesDuration(int n) {
        InvokeDynamicSupport.bootstrap("setFramesDuration", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$setFramesDuration(int ), 0, this, n);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_AnimatedRotateDrawable$mutate(), 0, this);
    }

    private /* synthetic */ void __constructor__(AnimatedRotateState animatedRotateState, Resources resources, 1 var3_3) {
        this.$$robo$$android_graphics_drawable_AnimatedRotateDrawable$__constructor__(animatedRotateState, resources, var3_3);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimatedRotateDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class AnimatedRotateState
    extends Drawable.ConstantState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Drawable mDrawable;
        int mChangingConfigurations;
        boolean mPivotXRel;
        float mPivotX;
        boolean mPivotYRel;
        float mPivotY;
        int mFrameDuration;
        int mFramesCount;
        private boolean mCanConstantState;
        private boolean mCheckedConstantState;

        private void $$robo$$android_graphics_drawable_AnimatedRotateDrawable_AnimatedRotateState$__constructor__(AnimatedRotateState orig, AnimatedRotateDrawable owner, Resources res) {
            if (orig != null) {
                this.mDrawable = res != null ? orig.mDrawable.getConstantState().newDrawable(res) : orig.mDrawable.getConstantState().newDrawable();
                this.mDrawable.setCallback(owner);
                this.mDrawable.setLayoutDirection(orig.mDrawable.getLayoutDirection());
                this.mDrawable.setBounds(orig.mDrawable.getBounds());
                this.mDrawable.setLevel(orig.mDrawable.getLevel());
                this.mPivotXRel = orig.mPivotXRel;
                this.mPivotX = orig.mPivotX;
                this.mPivotYRel = orig.mPivotYRel;
                this.mPivotY = orig.mPivotY;
                this.mFramesCount = orig.mFramesCount;
                this.mFrameDuration = orig.mFrameDuration;
                this.mCheckedConstantState = true;
                this.mCanConstantState = true;
            }
        }

        private final Drawable $$robo$$android_graphics_drawable_AnimatedRotateDrawable_AnimatedRotateState$newDrawable() {
            return new AnimatedRotateDrawable(this, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_AnimatedRotateDrawable_AnimatedRotateState$newDrawable(Resources res) {
            return new AnimatedRotateDrawable(this, res);
        }

        private final int $$robo$$android_graphics_drawable_AnimatedRotateDrawable_AnimatedRotateState$getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        private final boolean $$robo$$android_graphics_drawable_AnimatedRotateDrawable_AnimatedRotateState$canConstantState() {
            if (!this.mCheckedConstantState) {
                this.mCanConstantState = this.mDrawable.getConstantState() != null;
                this.mCheckedConstantState = true;
            }
            return this.mCanConstantState;
        }

        private void __constructor__(AnimatedRotateState animatedRotateState, AnimatedRotateDrawable animatedRotateDrawable, Resources resources) {
            this.$$robo$$android_graphics_drawable_AnimatedRotateDrawable_AnimatedRotateState$__constructor__(animatedRotateState, animatedRotateDrawable, resources);
        }

        public AnimatedRotateState(AnimatedRotateState animatedRotateState, AnimatedRotateDrawable animatedRotateDrawable, Resources resources) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedRotateDrawable_AnimatedRotateState$__constructor__(android.graphics.drawable.AnimatedRotateDrawable$AnimatedRotateState android.graphics.drawable.AnimatedRotateDrawable android.content.res.Resources ), 0, this, animatedRotateState, animatedRotateDrawable, resources);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_AnimatedRotateDrawable_AnimatedRotateState$newDrawable(), 0, this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_AnimatedRotateDrawable_AnimatedRotateState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        @Override
        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_AnimatedRotateDrawable_AnimatedRotateState$getChangingConfigurations(), 0, this);
        }

        public boolean canConstantState() {
            return (boolean)InvokeDynamicSupport.bootstrap("canConstantState", $$robo$$android_graphics_drawable_AnimatedRotateDrawable_AnimatedRotateState$canConstantState(), 0, this);
        }

        public /* synthetic */ AnimatedRotateState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimatedRotateState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

