/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.LongSparseLongArray;
import android.util.SparseIntArray;
import android.util.StateSet;
import com.android.internal.R;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatedStateListDrawable
extends StateListDrawable
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOGTAG;
    private static String ELEMENT_TRANSITION = "transition";
    private static String ELEMENT_ITEM = "item";
    private AnimatedStateListState mState;
    private Transition mTransition;
    private int mTransitionToIndex;
    private int mTransitionFromIndex;
    private boolean mMutated;

    private void $$robo$$android_graphics_drawable_AnimatedStateListDrawable$__constructor__() {
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedStateListDrawable$setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (this.mTransition != null && (changed || restart)) {
            if (visible) {
                this.mTransition.start();
            } else {
                this.jumpToCurrentState();
            }
        }
        return changed;
    }

    private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable$addState(int[] stateSet, Drawable drawable2, int id2) {
        if (drawable2 == null) {
            throw new IllegalArgumentException("Drawable must not be null");
        }
        this.mState.addStateSet(stateSet, drawable2, id2);
        this.onStateChange(this.getState());
    }

    private final <T extends Drawable> void $$robo$$android_graphics_drawable_AnimatedStateListDrawable$addTransition(int fromId, int toId, T transition2, boolean reversible) {
        if (transition2 == null) {
            throw new IllegalArgumentException("Transition drawable must not be null");
        }
        this.mState.addTransition(fromId, toId, transition2, reversible);
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedStateListDrawable$isStateful() {
        return true;
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedStateListDrawable$onStateChange(int[] stateSet) {
        int keyframeIndex = this.mState.indexOfKeyframe(stateSet);
        if (keyframeIndex == this.getCurrentIndex()) {
            Drawable current = this.getCurrent();
            if (current != null) {
                return current.setState(stateSet);
            }
            return false;
        }
        if (this.selectTransition(keyframeIndex)) {
            return true;
        }
        if (this.selectDrawable(keyframeIndex)) {
            return true;
        }
        return super.onStateChange(stateSet);
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedStateListDrawable$selectTransition(int toIndex) {
        Transition transition2;
        int fromIndex;
        Transition currentTransition = this.mTransition;
        if (currentTransition != null) {
            if (toIndex == this.mTransitionToIndex) {
                return true;
            }
            if (toIndex == this.mTransitionFromIndex && currentTransition.canReverse()) {
                currentTransition.reverse();
                this.mTransitionToIndex = this.mTransitionFromIndex;
                this.mTransitionFromIndex = toIndex;
                return true;
            }
            fromIndex = this.mTransitionToIndex;
            currentTransition.stop();
        } else {
            fromIndex = this.getCurrentIndex();
        }
        this.mTransition = null;
        this.mTransitionFromIndex = -1;
        this.mTransitionToIndex = -1;
        AnimatedStateListState state = this.mState;
        int fromId = state.getKeyframeIdAt(fromIndex);
        int toId = state.getKeyframeIdAt(toIndex);
        if (toId == 0 || fromId == 0) {
            return false;
        }
        int transitionIndex = state.indexOfTransition(fromId, toId);
        if (transitionIndex < 0) {
            return false;
        }
        this.selectDrawable(transitionIndex);
        Drawable d = this.getCurrent();
        if (d instanceof AnimationDrawable) {
            boolean reversed = state.isTransitionReversed(fromId, toId);
            transition2 = new AnimationDrawableTransition((AnimationDrawable)d, reversed);
        } else if (d instanceof AnimatedVectorDrawable) {
            boolean reversed = state.isTransitionReversed(fromId, toId);
            transition2 = new AnimatedVectorDrawableTransition((AnimatedVectorDrawable)d, reversed);
        } else if (d instanceof Animatable) {
            transition2 = new AnimatableTransition((Animatable)((Object)d));
        } else {
            return false;
        }
        transition2.start();
        this.mTransition = transition2;
        this.mTransitionFromIndex = fromIndex;
        this.mTransitionToIndex = toIndex;
        return true;
    }

    private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable$jumpToCurrentState() {
        super.jumpToCurrentState();
        if (this.mTransition != null) {
            this.mTransition.stop();
            this.mTransition = null;
            this.selectDrawable(this.mTransitionToIndex);
            this.mTransitionToIndex = -1;
            this.mTransitionFromIndex = -1;
        }
    }

    private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        TypedArray a = AnimatedStateListDrawable.obtainAttributes(r, theme, attrs, R.styleable.AnimatedStateListDrawable);
        super.inflateWithAttributes(r, parser, a, 1);
        StateListDrawable.StateListState stateListState = this.getStateListState();
        stateListState.setVariablePadding(a.getBoolean(2, false));
        stateListState.setConstantSize(a.getBoolean(3, false));
        stateListState.setEnterFadeDuration(a.getInt(4, 0));
        stateListState.setExitFadeDuration(a.getInt(5, 0));
        this.setDither(a.getBoolean(0, true));
        this.setAutoMirrored(a.getBoolean(6, false));
        a.recycle();
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            if (type != 2 || depth > innerDepth) continue;
            if (parser.getName().equals("item")) {
                this.parseItem(r, parser, attrs, theme);
                continue;
            }
            if (!parser.getName().equals("transition")) continue;
            this.parseTransition(r, parser, attrs, theme);
        }
        this.onStateChange(this.getState());
    }

    private final int $$robo$$android_graphics_drawable_AnimatedStateListDrawable$parseTransition(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        Drawable dr;
        int drawableRes = 0;
        int fromId = 0;
        int toId = 0;
        boolean reversible = false;
        int numAttrs = attrs.getAttributeCount();
        block7: for (int i = 0; i < numAttrs; ++i) {
            int stateResId = attrs.getAttributeNameResource(i);
            switch (stateResId) {
                case 0: {
                    continue block7;
                }
                case 16843850: {
                    fromId = attrs.getAttributeResourceValue(i, 0);
                    continue block7;
                }
                case 16843849: {
                    toId = attrs.getAttributeResourceValue(i, 0);
                    continue block7;
                }
                case 0x1010199: {
                    drawableRes = attrs.getAttributeResourceValue(i, 0);
                    continue block7;
                }
                case 16843851: {
                    reversible = attrs.getAttributeBooleanValue(i, false);
                }
            }
        }
        if (drawableRes != 0) {
            dr = r.getDrawable(drawableRes, theme);
        } else {
            int type;
            while ((type = parser.next()) == 4) {
            }
            if (type != 2) {
                throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
            }
            dr = Drawable.createFromXmlInner(r, parser, attrs, theme);
        }
        return this.mState.addTransition(fromId, toId, dr, reversible);
    }

    private final int $$robo$$android_graphics_drawable_AnimatedStateListDrawable$parseItem(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        Drawable dr;
        int drawableRes = 0;
        int keyframeId = 0;
        int j = 0;
        int numAttrs = attrs.getAttributeCount();
        int[] states = new int[numAttrs];
        block5: for (int i = 0; i < numAttrs; ++i) {
            int stateResId = attrs.getAttributeNameResource(i);
            switch (stateResId) {
                case 0: {
                    continue block5;
                }
                case 0x10100D0: {
                    keyframeId = attrs.getAttributeResourceValue(i, 0);
                    continue block5;
                }
                case 0x1010199: {
                    drawableRes = attrs.getAttributeResourceValue(i, 0);
                    continue block5;
                }
                default: {
                    boolean hasState = attrs.getAttributeBooleanValue(i, false);
                    states[j++] = hasState ? stateResId : -stateResId;
                }
            }
        }
        states = StateSet.trimStateSet(states, j);
        if (drawableRes != 0) {
            dr = r.getDrawable(drawableRes, theme);
        } else {
            int type;
            while ((type = parser.next()) == 4) {
            }
            if (type != 2) {
                throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
            }
            dr = Drawable.createFromXmlInner(r, parser, attrs, theme);
        }
        return this.mState.addStateSet(states, dr, keyframeId);
    }

    private final Drawable $$robo$$android_graphics_drawable_AnimatedStateListDrawable$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            AnimatedStateListState newState = new AnimatedStateListState(this.mState, this, null);
            this.setConstantState(newState);
            this.mMutated = true;
        }
        return this;
    }

    private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable$setConstantState(AnimatedStateListState state) {
        super.setConstantState(state);
        this.mState = state;
    }

    private void $$robo$$android_graphics_drawable_AnimatedStateListDrawable$__constructor__(AnimatedStateListState state, Resources res) {
        this.mTransitionToIndex = -1;
        this.mTransitionFromIndex = -1;
        AnimatedStateListState newState = new AnimatedStateListState(state, this, res);
        this.setConstantState(newState);
        this.onStateChange(this.getState());
        this.jumpToCurrentState();
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_AnimatedStateListDrawable$__constructor__(AnimatedStateListState x0, Resources x1, 1 x2) {
    }

    static void __staticInitializer__() {
        LOGTAG = AnimatedStateListDrawable.class.getSimpleName();
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_AnimatedStateListDrawable$__constructor__();
    }

    public AnimatedStateListDrawable() {
        this(null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$__constructor__(), 0, this);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setVisible", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$setVisible(boolean boolean ), 0, this, bl, bl2);
    }

    public void addState(int[] nArray, Drawable drawable2, int n) {
        InvokeDynamicSupport.bootstrap("addState", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$addState(int[] android.graphics.drawable.Drawable int ), 0, this, nArray, drawable2, n);
    }

    public <T extends Drawable> void addTransition(int n, int n2, T t, boolean bl) {
        InvokeDynamicSupport.bootstrap("addTransition", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$addTransition(int int T boolean ), 0, this, n, n2, t, bl);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$isStateful(), 0, this);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$onStateChange(int[] ), 0, this, nArray);
    }

    private boolean selectTransition(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("selectTransition", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$selectTransition(int ), 0, this, n);
    }

    @Override
    public void jumpToCurrentState() {
        InvokeDynamicSupport.bootstrap("jumpToCurrentState", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$jumpToCurrentState(), 0, this);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    private int parseTransition(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        return (int)InvokeDynamicSupport.bootstrap("parseTransition", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$parseTransition(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    private int parseItem(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        return (int)InvokeDynamicSupport.bootstrap("parseItem", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$parseItem(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$mutate(), 0, this);
    }

    void setConstantState(AnimatedStateListState animatedStateListState) {
        InvokeDynamicSupport.bootstrap("setConstantState", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$setConstantState(android.graphics.drawable.AnimatedStateListDrawable$AnimatedStateListState ), 0, this, animatedStateListState);
    }

    private void __constructor__(AnimatedStateListState animatedStateListState, Resources resources) {
        this.$$robo$$android_graphics_drawable_AnimatedStateListDrawable$__constructor__(animatedStateListState, resources);
    }

    private AnimatedStateListDrawable(AnimatedStateListState animatedStateListState, Resources resources) {
        super(null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedStateListDrawable$__constructor__(android.graphics.drawable.AnimatedStateListDrawable$AnimatedStateListState android.content.res.Resources ), 0, this, animatedStateListState, resources);
    }

    private /* synthetic */ void __constructor__(AnimatedStateListState animatedStateListState, Resources resources, 1 var3_3) {
        this.$$robo$$android_graphics_drawable_AnimatedStateListDrawable$__constructor__(animatedStateListState, resources, var3_3);
    }

    static {
        RobolectricInternals.classInitializing(AnimatedStateListDrawable.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimatedStateListDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class FrameInterpolator
    implements TimeInterpolator,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int[] mFrameTimes;
        private int mFrames;
        private int mTotalDuration;

        private void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_FrameInterpolator$__constructor__(AnimationDrawable d, boolean reversed) {
            this.updateFrames(d, reversed);
        }

        private final int $$robo$$android_graphics_drawable_AnimatedStateListDrawable_FrameInterpolator$updateFrames(AnimationDrawable d, boolean reversed) {
            int N;
            this.mFrames = N = d.getNumberOfFrames();
            if (this.mFrameTimes == null || this.mFrameTimes.length < N) {
                this.mFrameTimes = new int[N];
            }
            int[] frameTimes = this.mFrameTimes;
            int totalDuration = 0;
            for (int i = 0; i < N; ++i) {
                int duration;
                frameTimes[i] = duration = d.getDuration(reversed ? N - i - 1 : i);
                totalDuration += duration;
            }
            this.mTotalDuration = totalDuration;
            return totalDuration;
        }

        private final int $$robo$$android_graphics_drawable_AnimatedStateListDrawable_FrameInterpolator$getTotalDuration() {
            return this.mTotalDuration;
        }

        private final float $$robo$$android_graphics_drawable_AnimatedStateListDrawable_FrameInterpolator$getInterpolation(float input) {
            int i;
            int elapsed = (int)(input * (float)this.mTotalDuration + 0.5f);
            int N = this.mFrames;
            int[] frameTimes = this.mFrameTimes;
            int remaining = elapsed;
            for (i = 0; i < N && remaining >= frameTimes[i]; remaining -= frameTimes[i], ++i) {
            }
            float frameElapsed = i < N ? (float)remaining / (float)this.mTotalDuration : 0.0f;
            return (float)i / (float)N + frameElapsed;
        }

        private void __constructor__(AnimationDrawable animationDrawable, boolean bl) {
            this.$$robo$$android_graphics_drawable_AnimatedStateListDrawable_FrameInterpolator$__constructor__(animationDrawable, bl);
        }

        public FrameInterpolator(AnimationDrawable animationDrawable, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_FrameInterpolator$__constructor__(android.graphics.drawable.AnimationDrawable boolean ), 0, this, animationDrawable, bl);
        }

        public int updateFrames(AnimationDrawable animationDrawable, boolean bl) {
            return (int)InvokeDynamicSupport.bootstrap("updateFrames", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_FrameInterpolator$updateFrames(android.graphics.drawable.AnimationDrawable boolean ), 0, this, animationDrawable, bl);
        }

        public int getTotalDuration() {
            return (int)InvokeDynamicSupport.bootstrap("getTotalDuration", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_FrameInterpolator$getTotalDuration(), 0, this);
        }

        @Override
        public float getInterpolation(float f) {
            return (float)InvokeDynamicSupport.bootstrap("getInterpolation", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_FrameInterpolator$getInterpolation(float ), 0, this, f);
        }

        public /* synthetic */ FrameInterpolator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FrameInterpolator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class AnimatedStateListState
    extends StateListDrawable.StateListState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int REVERSE_SHIFT = 32;
        private static int REVERSE_MASK = 1;
        LongSparseLongArray mTransitions;
        SparseIntArray mStateIds;

        private void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$__constructor__(AnimatedStateListState orig, AnimatedStateListDrawable owner, Resources res) {
            if (orig != null) {
                this.mTransitions = orig.mTransitions.clone();
                this.mStateIds = orig.mStateIds.clone();
            } else {
                this.mTransitions = new LongSparseLongArray();
                this.mStateIds = new SparseIntArray();
            }
        }

        private final int $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$addTransition(int fromId, int toId, Drawable anim2, boolean reversible) {
            int pos = super.addChild(anim2);
            long keyFromTo = AnimatedStateListState.generateTransitionKey(fromId, toId);
            this.mTransitions.append(keyFromTo, pos);
            if (reversible) {
                long keyToFrom = AnimatedStateListState.generateTransitionKey(toId, fromId);
                this.mTransitions.append(keyToFrom, (long)pos | 0x100000000L);
            }
            return this.addChild(anim2);
        }

        private final int $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$addStateSet(int[] stateSet, Drawable drawable2, int id2) {
            int index = super.addStateSet(stateSet, drawable2);
            this.mStateIds.put(index, id2);
            return index;
        }

        private final int $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$indexOfKeyframe(int[] stateSet) {
            int index = super.indexOfStateSet(stateSet);
            if (index >= 0) {
                return index;
            }
            return super.indexOfStateSet(StateSet.WILD_CARD);
        }

        private final int $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$getKeyframeIdAt(int index) {
            return index < 0 ? 0 : this.mStateIds.get(index, 0);
        }

        private final int $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$indexOfTransition(int fromId, int toId) {
            long keyFromTo = AnimatedStateListState.generateTransitionKey(fromId, toId);
            return (int)this.mTransitions.get(keyFromTo, -1L);
        }

        private final boolean $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$isTransitionReversed(int fromId, int toId) {
            long keyFromTo = AnimatedStateListState.generateTransitionKey(fromId, toId);
            return (this.mTransitions.get(keyFromTo, -1L) >> 32 & 1L) == 1L;
        }

        private final Drawable $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$newDrawable() {
            return new AnimatedStateListDrawable(this, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$newDrawable(Resources res) {
            return new AnimatedStateListDrawable(this, res);
        }

        private static final long $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$generateTransitionKey(int fromId, int toId) {
            return (long)fromId << 32 | (long)toId;
        }

        private void __constructor__(AnimatedStateListState animatedStateListState, AnimatedStateListDrawable animatedStateListDrawable, Resources resources) {
            this.$$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$__constructor__(animatedStateListState, animatedStateListDrawable, resources);
        }

        AnimatedStateListState(AnimatedStateListState animatedStateListState, AnimatedStateListDrawable animatedStateListDrawable, Resources resources) {
            super(animatedStateListState, animatedStateListDrawable, resources);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$__constructor__(android.graphics.drawable.AnimatedStateListDrawable$AnimatedStateListState android.graphics.drawable.AnimatedStateListDrawable android.content.res.Resources ), 0, this, animatedStateListState, animatedStateListDrawable, resources);
        }

        int addTransition(int n, int n2, Drawable drawable2, boolean bl) {
            return (int)InvokeDynamicSupport.bootstrap("addTransition", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$addTransition(int int android.graphics.drawable.Drawable boolean ), 0, this, n, n2, drawable2, bl);
        }

        int addStateSet(int[] nArray, Drawable drawable2, int n) {
            return (int)InvokeDynamicSupport.bootstrap("addStateSet", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$addStateSet(int[] android.graphics.drawable.Drawable int ), 0, this, nArray, drawable2, n);
        }

        int indexOfKeyframe(int[] nArray) {
            return (int)InvokeDynamicSupport.bootstrap("indexOfKeyframe", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$indexOfKeyframe(int[] ), 0, this, nArray);
        }

        int getKeyframeIdAt(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getKeyframeIdAt", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$getKeyframeIdAt(int ), 0, this, n);
        }

        int indexOfTransition(int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("indexOfTransition", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$indexOfTransition(int int ), 0, this, n, n2);
        }

        boolean isTransitionReversed(int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("isTransitionReversed", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$isTransitionReversed(int int ), 0, this, n, n2);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$newDrawable(), 0, this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        private static long generateTransitionKey(int n, int n2) {
            return (long)InvokeDynamicSupport.bootstrapStatic("generateTransitionKey", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedStateListState$generateTransitionKey(int int ), 0, (int)n, (int)n2);
        }

        public /* synthetic */ AnimatedStateListState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimatedStateListState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class AnimatedVectorDrawableTransition
    extends Transition
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private AnimatedVectorDrawable mAvd;
        private boolean mReversed;

        private void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedVectorDrawableTransition$__constructor__(AnimatedVectorDrawable avd, boolean reversed) {
            this.mAvd = avd;
            this.mReversed = reversed;
        }

        private final boolean $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedVectorDrawableTransition$canReverse() {
            return this.mAvd.canReverse();
        }

        private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedVectorDrawableTransition$start() {
            if (this.mReversed) {
                this.reverse();
            } else {
                this.mAvd.start();
            }
        }

        private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedVectorDrawableTransition$reverse() {
            if (this.canReverse()) {
                this.mAvd.reverse();
            } else {
                Log.w(LOGTAG, "Reverse() is called on a drawable can't reverse");
            }
        }

        private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedVectorDrawableTransition$stop() {
            this.mAvd.stop();
        }

        private void __constructor__(AnimatedVectorDrawable animatedVectorDrawable, boolean bl) {
            this.$$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedVectorDrawableTransition$__constructor__(animatedVectorDrawable, bl);
        }

        public AnimatedVectorDrawableTransition(AnimatedVectorDrawable animatedVectorDrawable, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedVectorDrawableTransition$__constructor__(android.graphics.drawable.AnimatedVectorDrawable boolean ), 0, this, animatedVectorDrawable, bl);
        }

        @Override
        public boolean canReverse() {
            return (boolean)InvokeDynamicSupport.bootstrap("canReverse", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedVectorDrawableTransition$canReverse(), 0, this);
        }

        @Override
        public void start() {
            InvokeDynamicSupport.bootstrap("start", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedVectorDrawableTransition$start(), 0, this);
        }

        @Override
        public void reverse() {
            InvokeDynamicSupport.bootstrap("reverse", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedVectorDrawableTransition$reverse(), 0, this);
        }

        @Override
        public void stop() {
            InvokeDynamicSupport.bootstrap("stop", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatedVectorDrawableTransition$stop(), 0, this);
        }

        public /* synthetic */ AnimatedVectorDrawableTransition() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimatedVectorDrawableTransition)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class AnimationDrawableTransition
    extends Transition
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ObjectAnimator mAnim;

        private void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimationDrawableTransition$__constructor__(AnimationDrawable ad, boolean reversed) {
            int frameCount = ad.getNumberOfFrames();
            int fromFrame = reversed ? frameCount - 1 : 0;
            int toFrame = reversed ? 0 : frameCount - 1;
            FrameInterpolator interp = new FrameInterpolator(ad, reversed);
            ObjectAnimator anim2 = ObjectAnimator.ofInt((Object)ad, "currentIndex", fromFrame, toFrame);
            anim2.setAutoCancel(true);
            anim2.setDuration(interp.getTotalDuration());
            anim2.setInterpolator(interp);
            this.mAnim = anim2;
        }

        private final boolean $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimationDrawableTransition$canReverse() {
            return true;
        }

        private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimationDrawableTransition$start() {
            this.mAnim.start();
        }

        private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimationDrawableTransition$reverse() {
            this.mAnim.reverse();
        }

        private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimationDrawableTransition$stop() {
            this.mAnim.cancel();
        }

        private void __constructor__(AnimationDrawable animationDrawable, boolean bl) {
            this.$$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimationDrawableTransition$__constructor__(animationDrawable, bl);
        }

        public AnimationDrawableTransition(AnimationDrawable animationDrawable, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimationDrawableTransition$__constructor__(android.graphics.drawable.AnimationDrawable boolean ), 0, this, animationDrawable, bl);
        }

        @Override
        public boolean canReverse() {
            return (boolean)InvokeDynamicSupport.bootstrap("canReverse", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimationDrawableTransition$canReverse(), 0, this);
        }

        @Override
        public void start() {
            InvokeDynamicSupport.bootstrap("start", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimationDrawableTransition$start(), 0, this);
        }

        @Override
        public void reverse() {
            InvokeDynamicSupport.bootstrap("reverse", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimationDrawableTransition$reverse(), 0, this);
        }

        @Override
        public void stop() {
            InvokeDynamicSupport.bootstrap("stop", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimationDrawableTransition$stop(), 0, this);
        }

        public /* synthetic */ AnimationDrawableTransition() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimationDrawableTransition)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class AnimatableTransition
    extends Transition
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Animatable mA;

        private void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatableTransition$__constructor__(Animatable a) {
            this.mA = a;
        }

        private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatableTransition$start() {
            this.mA.start();
        }

        private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatableTransition$stop() {
            this.mA.stop();
        }

        private void __constructor__(Animatable animatable) {
            this.$$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatableTransition$__constructor__(animatable);
        }

        public AnimatableTransition(Animatable animatable) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatableTransition$__constructor__(android.graphics.drawable.Animatable ), 0, this, animatable);
        }

        @Override
        public void start() {
            InvokeDynamicSupport.bootstrap("start", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatableTransition$start(), 0, this);
        }

        @Override
        public void stop() {
            InvokeDynamicSupport.bootstrap("stop", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_AnimatableTransition$stop(), 0, this);
        }

        public /* synthetic */ AnimatableTransition() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimatableTransition)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static abstract class Transition
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_Transition$__constructor__() {
        }

        public abstract void start();

        public abstract void stop();

        private final void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_Transition$reverse() {
        }

        private final boolean $$robo$$android_graphics_drawable_AnimatedStateListDrawable_Transition$canReverse() {
            return false;
        }

        private /* synthetic */ void $$robo$$android_graphics_drawable_AnimatedStateListDrawable_Transition$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_drawable_AnimatedStateListDrawable_Transition$__constructor__();
        }

        private Transition() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_Transition$__constructor__(), 0, this);
        }

        public void reverse() {
            InvokeDynamicSupport.bootstrap("reverse", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_Transition$reverse(), 0, this);
        }

        public boolean canReverse() {
            return (boolean)InvokeDynamicSupport.bootstrap("canReverse", $$robo$$android_graphics_drawable_AnimatedStateListDrawable_Transition$canReverse(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_graphics_drawable_AnimatedStateListDrawable_Transition$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Transition)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

