/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.Log;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatedVectorDrawable
extends Drawable
implements Animatable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOGTAG;
    private static String ANIMATED_VECTOR = "animated-vector";
    private static String TARGET = "target";
    private static boolean DBG_ANIMATION_VECTOR_DRAWABLE = false;
    private AnimatedVectorDrawableState mAnimatedVectorState;
    private boolean mMutated;

    private void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$__constructor__() {
        this.mAnimatedVectorState = new AnimatedVectorDrawableState(null);
    }

    private void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$__constructor__(AnimatedVectorDrawableState state, Resources res, Resources.Theme theme) {
        this.mAnimatedVectorState = new AnimatedVectorDrawableState(state);
        if (theme != null && this.canApplyTheme()) {
            this.applyTheme(theme);
        }
    }

    private final Drawable $$robo$$android_graphics_drawable_AnimatedVectorDrawable$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mAnimatedVectorState.mVectorDrawable.mutate();
            this.mMutated = true;
        }
        return this;
    }

    private final Drawable.ConstantState $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getConstantState() {
        this.mAnimatedVectorState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mAnimatedVectorState;
    }

    private final int $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mAnimatedVectorState.mChangingConfigurations;
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$draw(Canvas canvas) {
        this.mAnimatedVectorState.mVectorDrawable.draw(canvas);
        if (this.isStarted()) {
            this.invalidateSelf();
        }
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$onBoundsChange(Rect bounds) {
        this.mAnimatedVectorState.mVectorDrawable.setBounds(bounds);
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable$onStateChange(int[] state) {
        return this.mAnimatedVectorState.mVectorDrawable.setState(state);
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable$onLevelChange(int level) {
        return this.mAnimatedVectorState.mVectorDrawable.setLevel(level);
    }

    private final int $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getAlpha() {
        return this.mAnimatedVectorState.mVectorDrawable.getAlpha();
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setAlpha(int alpha) {
        this.mAnimatedVectorState.mVectorDrawable.setAlpha(alpha);
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setColorFilter(ColorFilter colorFilter) {
        this.mAnimatedVectorState.mVectorDrawable.setColorFilter(colorFilter);
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setTintList(ColorStateList tint) {
        this.mAnimatedVectorState.mVectorDrawable.setTintList(tint);
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setHotspot(float x, float y) {
        this.mAnimatedVectorState.mVectorDrawable.setHotspot(x, y);
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setHotspotBounds(int left, int top, int right, int bottom) {
        this.mAnimatedVectorState.mVectorDrawable.setHotspotBounds(left, top, right, bottom);
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setTintMode(PorterDuff.Mode tintMode) {
        this.mAnimatedVectorState.mVectorDrawable.setTintMode(tintMode);
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setVisible(boolean visible, boolean restart) {
        this.mAnimatedVectorState.mVectorDrawable.setVisible(visible, restart);
        return super.setVisible(visible, restart);
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setLayoutDirection(int layoutDirection) {
        this.mAnimatedVectorState.mVectorDrawable.setLayoutDirection(layoutDirection);
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable$isStateful() {
        return this.mAnimatedVectorState.mVectorDrawable.isStateful();
    }

    private final int $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getOpacity() {
        return this.mAnimatedVectorState.mVectorDrawable.getOpacity();
    }

    private final int $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getIntrinsicWidth() {
        return this.mAnimatedVectorState.mVectorDrawable.getIntrinsicWidth();
    }

    private final int $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getIntrinsicHeight() {
        return this.mAnimatedVectorState.mVectorDrawable.getIntrinsicHeight();
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getOutline(Outline outline) {
        this.mAnimatedVectorState.mVectorDrawable.getOutline(outline);
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$inflate(Resources res, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        float pathErrorScale = 1.0f;
        while (eventType != 1) {
            if (eventType == 2) {
                TypedArray a;
                String tagName = parser.getName();
                if ("animated-vector".equals(tagName)) {
                    a = AnimatedVectorDrawable.obtainAttributes(res, theme, attrs, R.styleable.AnimatedVectorDrawable);
                    int drawableRes = a.getResourceId(0, 0);
                    if (drawableRes != 0) {
                        VectorDrawable vectorDrawable = (VectorDrawable)res.getDrawable(drawableRes, theme).mutate();
                        vectorDrawable.setAllowCaching(false);
                        pathErrorScale = vectorDrawable.getPixelSize();
                        this.mAnimatedVectorState.mVectorDrawable = vectorDrawable;
                    }
                    a.recycle();
                } else if ("target".equals(tagName)) {
                    a = AnimatedVectorDrawable.obtainAttributes(res, theme, attrs, R.styleable.AnimatedVectorDrawableTarget);
                    String target = a.getString(0);
                    int id2 = a.getResourceId(1, 0);
                    if (id2 != 0) {
                        Animator objectAnimator = AnimatorInflater.loadAnimator(res, theme, id2, pathErrorScale);
                        this.setupAnimatorsForTarget(target, objectAnimator);
                    }
                    a.recycle();
                }
            }
            eventType = parser.next();
        }
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable$canApplyTheme() {
        return super.canApplyTheme() || this.mAnimatedVectorState != null && this.mAnimatedVectorState.mVectorDrawable != null && this.mAnimatedVectorState.mVectorDrawable.canApplyTheme();
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        VectorDrawable vectorDrawable = this.mAnimatedVectorState.mVectorDrawable;
        if (vectorDrawable != null && vectorDrawable.canApplyTheme()) {
            vectorDrawable.applyTheme(t);
        }
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setupAnimatorsForTarget(String name, Animator animator2) {
        Object target = this.mAnimatedVectorState.mVectorDrawable.getTargetByName(name);
        animator2.setTarget(target);
        if (this.mAnimatedVectorState.mAnimators == null) {
            this.mAnimatedVectorState.mAnimators = new ArrayList();
            this.mAnimatedVectorState.mTargetNameMap = new ArrayMap();
        }
        this.mAnimatedVectorState.mAnimators.add(animator2);
        this.mAnimatedVectorState.mTargetNameMap.put(animator2, name);
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable$isRunning() {
        ArrayList<Animator> animators = this.mAnimatedVectorState.mAnimators;
        int size = animators.size();
        for (int i = 0; i < size; ++i) {
            Animator animator2 = animators.get(i);
            if (!animator2.isRunning()) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable$isStarted() {
        ArrayList<Animator> animators = this.mAnimatedVectorState.mAnimators;
        int size = animators.size();
        for (int i = 0; i < size; ++i) {
            Animator animator2 = animators.get(i);
            if (!animator2.isStarted()) continue;
            return true;
        }
        return false;
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$start() {
        ArrayList<Animator> animators = this.mAnimatedVectorState.mAnimators;
        int size = animators.size();
        for (int i = 0; i < size; ++i) {
            Animator animator2 = animators.get(i);
            if (animator2.isStarted()) continue;
            animator2.start();
        }
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$stop() {
        ArrayList<Animator> animators = this.mAnimatedVectorState.mAnimators;
        int size = animators.size();
        for (int i = 0; i < size; ++i) {
            Animator animator2 = animators.get(i);
            animator2.end();
        }
    }

    private final void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$reverse() {
        ArrayList<Animator> animators = this.mAnimatedVectorState.mAnimators;
        int size = animators.size();
        for (int i = 0; i < size; ++i) {
            Animator animator2 = animators.get(i);
            if (animator2.canReverse()) {
                animator2.reverse();
                continue;
            }
            Log.w(LOGTAG, "AnimatedVectorDrawable can't reverse()");
        }
    }

    private final boolean $$robo$$android_graphics_drawable_AnimatedVectorDrawable$canReverse() {
        ArrayList<Animator> animators = this.mAnimatedVectorState.mAnimators;
        int size = animators.size();
        for (int i = 0; i < size; ++i) {
            Animator animator2 = animators.get(i);
            if (animator2.canReverse()) continue;
            return false;
        }
        return true;
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_AnimatedVectorDrawable$__constructor__(AnimatedVectorDrawableState x0, Resources x1, Resources.Theme x2, 1 x3) {
    }

    static void __staticInitializer__() {
        LOGTAG = AnimatedVectorDrawable.class.getSimpleName();
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_AnimatedVectorDrawable$__constructor__();
    }

    public AnimatedVectorDrawable() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$__constructor__(), 0, this);
    }

    private void __constructor__(AnimatedVectorDrawableState animatedVectorDrawableState, Resources resources, Resources.Theme theme) {
        this.$$robo$$android_graphics_drawable_AnimatedVectorDrawable$__constructor__(animatedVectorDrawableState, resources, theme);
    }

    private AnimatedVectorDrawable(AnimatedVectorDrawableState animatedVectorDrawableState, Resources resources, Resources.Theme theme) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$__constructor__(android.graphics.drawable.AnimatedVectorDrawable$AnimatedVectorDrawableState android.content.res.Resources android.content.res.Resources$Theme ), 0, this, animatedVectorDrawableState, resources, theme);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$mutate(), 0, this);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getConstantState(), 0, this);
    }

    @Override
    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getChangingConfigurations(), 0, this);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        InvokeDynamicSupport.bootstrap("onBoundsChange", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$onBoundsChange(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$onStateChange(int[] ), 0, this, nArray);
    }

    @Override
    protected boolean onLevelChange(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLevelChange", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$onLevelChange(int ), 0, this, n);
    }

    @Override
    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getAlpha(), 0, this);
    }

    @Override
    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setAlpha(int ), 0, this, n);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setTintList", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    @Override
    public void setHotspot(float f, float f2) {
        InvokeDynamicSupport.bootstrap("setHotspot", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setHotspot(float float ), 0, this, f, f2);
    }

    @Override
    public void setHotspotBounds(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setHotspotBounds", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setHotspotBounds(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setTintMode", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setVisible", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setVisible(boolean boolean ), 0, this, bl, bl2);
    }

    @Override
    public void setLayoutDirection(int n) {
        InvokeDynamicSupport.bootstrap("setLayoutDirection", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setLayoutDirection(int ), 0, this, n);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$isStateful(), 0, this);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getOpacity(), 0, this);
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicWidth", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getIntrinsicWidth(), 0, this);
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicHeight", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getIntrinsicHeight(), 0, this);
    }

    @Override
    public void getOutline(Outline outline) {
        InvokeDynamicSupport.bootstrap("getOutline", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$getOutline(android.graphics.Outline ), 0, this, outline);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    @Override
    public boolean canApplyTheme() {
        return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$canApplyTheme(), 0, this);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
    }

    private void setupAnimatorsForTarget(String string2, Animator animator2) {
        InvokeDynamicSupport.bootstrap("setupAnimatorsForTarget", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$setupAnimatorsForTarget(java.lang.String android.animation.Animator ), 0, this, string2, animator2);
    }

    @Override
    public boolean isRunning() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRunning", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$isRunning(), 0, this);
    }

    private boolean isStarted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStarted", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$isStarted(), 0, this);
    }

    @Override
    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$start(), 0, this);
    }

    @Override
    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$stop(), 0, this);
    }

    public void reverse() {
        InvokeDynamicSupport.bootstrap("reverse", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$reverse(), 0, this);
    }

    public boolean canReverse() {
        return (boolean)InvokeDynamicSupport.bootstrap("canReverse", $$robo$$android_graphics_drawable_AnimatedVectorDrawable$canReverse(), 0, this);
    }

    private /* synthetic */ void __constructor__(AnimatedVectorDrawableState animatedVectorDrawableState, Resources resources, Resources.Theme theme, 1 var4_4) {
        this.$$robo$$android_graphics_drawable_AnimatedVectorDrawable$__constructor__(animatedVectorDrawableState, resources, theme, var4_4);
    }

    static {
        RobolectricInternals.classInitializing(AnimatedVectorDrawable.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimatedVectorDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class AnimatedVectorDrawableState
    extends Drawable.ConstantState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int mChangingConfigurations;
        VectorDrawable mVectorDrawable;
        ArrayList<Animator> mAnimators;
        ArrayMap<Animator, String> mTargetNameMap;

        private void $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$__constructor__(AnimatedVectorDrawableState copy) {
            if (copy != null) {
                this.mChangingConfigurations = copy.mChangingConfigurations;
                if (copy.mVectorDrawable != null) {
                    this.mVectorDrawable = (VectorDrawable)copy.mVectorDrawable.getConstantState().newDrawable();
                    this.mVectorDrawable.mutate();
                    this.mVectorDrawable.setAllowCaching(false);
                    this.mVectorDrawable.setBounds(copy.mVectorDrawable.getBounds());
                }
                if (copy.mAnimators != null) {
                    int numAnimators = copy.mAnimators.size();
                    this.mAnimators = new ArrayList(numAnimators);
                    this.mTargetNameMap = new ArrayMap(numAnimators);
                    for (int i = 0; i < numAnimators; ++i) {
                        Animator anim2 = copy.mAnimators.get(i);
                        Object animClone = anim2.clone();
                        String targetName = copy.mTargetNameMap.get(anim2);
                        Object targetObject = this.mVectorDrawable.getTargetByName(targetName);
                        ((Animator)animClone).setTarget(targetObject);
                        this.mAnimators.add((Animator)animClone);
                        this.mTargetNameMap.put((Animator)animClone, targetName);
                    }
                }
            } else {
                this.mVectorDrawable = new VectorDrawable();
            }
        }

        private final Drawable $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$newDrawable() {
            return new AnimatedVectorDrawable(this, null, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$newDrawable(Resources res) {
            return new AnimatedVectorDrawable(this, res, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$newDrawable(Resources res, Resources.Theme theme) {
            return new AnimatedVectorDrawable(this, res, theme);
        }

        private final int $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        private void __constructor__(AnimatedVectorDrawableState animatedVectorDrawableState) {
            this.$$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$__constructor__(animatedVectorDrawableState);
        }

        public AnimatedVectorDrawableState(AnimatedVectorDrawableState animatedVectorDrawableState) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$__constructor__(android.graphics.drawable.AnimatedVectorDrawable$AnimatedVectorDrawableState ), 0, this, animatedVectorDrawableState);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$newDrawable(), 0, this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        @Override
        public Drawable newDrawable(Resources resources, Resources.Theme theme) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$newDrawable(android.content.res.Resources android.content.res.Resources$Theme ), 0, this, resources, theme);
        }

        @Override
        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_AnimatedVectorDrawable_AnimatedVectorDrawableState$getChangingConfigurations(), 0, this);
        }

        public /* synthetic */ AnimatedVectorDrawableState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimatedVectorDrawableState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

