/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ViewDebug;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ColorDrawable
extends Drawable
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Paint mPaint;
    @ViewDebug.ExportedProperty(deepExport=true, prefix="state_")
    private ColorState mColorState;
    private PorterDuffColorFilter mTintFilter;
    private boolean mMutated;

    private void $$robo$$android_graphics_drawable_ColorDrawable$__constructor__() {
        this.mPaint = new Paint();
        this.mColorState = new ColorState();
    }

    private void $$robo$$android_graphics_drawable_ColorDrawable$__constructor__(int color2) {
        this.mPaint = new Paint();
        this.mColorState = new ColorState();
        this.setColor(color2);
    }

    private final int $$robo$$android_graphics_drawable_ColorDrawable$getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mColorState.mChangingConfigurations;
    }

    private final Drawable $$robo$$android_graphics_drawable_ColorDrawable$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mColorState = new ColorState(this.mColorState);
            this.mMutated = true;
        }
        return this;
    }

    private final void $$robo$$android_graphics_drawable_ColorDrawable$draw(Canvas canvas) {
        ColorFilter colorFilter = this.mPaint.getColorFilter();
        if (this.mColorState.mUseColor >>> 24 != 0 || colorFilter != null || this.mTintFilter != null) {
            if (colorFilter == null) {
                this.mPaint.setColorFilter(this.mTintFilter);
            }
            this.mPaint.setColor(this.mColorState.mUseColor);
            canvas.drawRect(this.getBounds(), this.mPaint);
            this.mPaint.setColorFilter(colorFilter);
        }
    }

    private final int $$robo$$android_graphics_drawable_ColorDrawable$getColor() {
        return this.mColorState.mUseColor;
    }

    private final void $$robo$$android_graphics_drawable_ColorDrawable$setColor(int color2) {
        if (this.mColorState.mBaseColor != color2 || this.mColorState.mUseColor != color2) {
            this.mColorState.mBaseColor = this.mColorState.mUseColor = color2;
            this.invalidateSelf();
        }
    }

    private final int $$robo$$android_graphics_drawable_ColorDrawable$getAlpha() {
        return this.mColorState.mUseColor >>> 24;
    }

    private final void $$robo$$android_graphics_drawable_ColorDrawable$setAlpha(int alpha) {
        int useAlpha;
        int useColor;
        int baseAlpha = this.mColorState.mBaseColor >>> 24;
        if (this.mColorState.mUseColor != (useColor = this.mColorState.mBaseColor << 8 >>> 8 | (useAlpha = baseAlpha * (alpha += alpha >> 7) >> 8) << 24)) {
            this.mColorState.mUseColor = useColor;
            this.invalidateSelf();
        }
    }

    private final void $$robo$$android_graphics_drawable_ColorDrawable$setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    private final void $$robo$$android_graphics_drawable_ColorDrawable$setTintList(ColorStateList tint) {
        this.mColorState.mTint = tint;
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, tint, this.mColorState.mTintMode);
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_ColorDrawable$setTintMode(PorterDuff.Mode tintMode) {
        this.mColorState.mTintMode = tintMode;
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, this.mColorState.mTint, tintMode);
        this.invalidateSelf();
    }

    private final boolean $$robo$$android_graphics_drawable_ColorDrawable$onStateChange(int[] stateSet) {
        ColorState state = this.mColorState;
        if (state.mTint != null && state.mTintMode != null) {
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, state.mTintMode);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_graphics_drawable_ColorDrawable$isStateful() {
        return this.mColorState.mTint != null && this.mColorState.mTint.isStateful();
    }

    private final int $$robo$$android_graphics_drawable_ColorDrawable$getOpacity() {
        if (this.mTintFilter != null || this.mPaint.getColorFilter() != null) {
            return -3;
        }
        switch (this.mColorState.mUseColor >>> 24) {
            case 255: {
                return -1;
            }
            case 0: {
                return -2;
            }
        }
        return -3;
    }

    private final void $$robo$$android_graphics_drawable_ColorDrawable$getOutline(Outline outline) {
        outline.setRect(this.getBounds());
        outline.setAlpha((float)this.getAlpha() / 255.0f);
    }

    private final void $$robo$$android_graphics_drawable_ColorDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs, theme);
        TypedArray a = ColorDrawable.obtainAttributes(r, theme, attrs, R.styleable.ColorDrawable);
        this.updateStateFromTypedArray(a);
        a.recycle();
    }

    private final void $$robo$$android_graphics_drawable_ColorDrawable$updateStateFromTypedArray(TypedArray a) {
        ColorState state = this.mColorState;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mThemeAttrs = a.extractThemeAttrs();
        state.mUseColor = state.mBaseColor = a.getColor(0, state.mBaseColor);
    }

    private final void $$robo$$android_graphics_drawable_ColorDrawable$applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        ColorState state = this.mColorState;
        if (state == null || state.mThemeAttrs == null) {
            return;
        }
        TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.ColorDrawable);
        this.updateStateFromTypedArray(a);
        a.recycle();
    }

    private final Drawable.ConstantState $$robo$$android_graphics_drawable_ColorDrawable$getConstantState() {
        return this.mColorState;
    }

    private void $$robo$$android_graphics_drawable_ColorDrawable$__constructor__(ColorState state, Resources res, Resources.Theme theme) {
        this.mPaint = new Paint();
        if (theme != null && state.canApplyTheme()) {
            this.mColorState = new ColorState(state);
            this.applyTheme(theme);
        } else {
            this.mColorState = state;
        }
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, state.mTintMode);
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_ColorDrawable$__constructor__(ColorState x0, Resources x1, Resources.Theme x2, 1 x3) {
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_ColorDrawable$__constructor__();
    }

    public ColorDrawable() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_ColorDrawable$__constructor__(), 0, this);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_graphics_drawable_ColorDrawable$__constructor__(n);
    }

    public ColorDrawable(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_ColorDrawable$__constructor__(int ), 0, this, n);
    }

    @Override
    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_ColorDrawable$getChangingConfigurations(), 0, this);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_ColorDrawable$mutate(), 0, this);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_ColorDrawable$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    public int getColor() {
        return (int)InvokeDynamicSupport.bootstrap("getColor", $$robo$$android_graphics_drawable_ColorDrawable$getColor(), 0, this);
    }

    public void setColor(int n) {
        InvokeDynamicSupport.bootstrap("setColor", $$robo$$android_graphics_drawable_ColorDrawable$setColor(int ), 0, this, n);
    }

    @Override
    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_drawable_ColorDrawable$getAlpha(), 0, this);
    }

    @Override
    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_drawable_ColorDrawable$setAlpha(int ), 0, this, n);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_graphics_drawable_ColorDrawable$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setTintList", $$robo$$android_graphics_drawable_ColorDrawable$setTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setTintMode", $$robo$$android_graphics_drawable_ColorDrawable$setTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_ColorDrawable$onStateChange(int[] ), 0, this, nArray);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_ColorDrawable$isStateful(), 0, this);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_ColorDrawable$getOpacity(), 0, this);
    }

    @Override
    public void getOutline(Outline outline) {
        InvokeDynamicSupport.bootstrap("getOutline", $$robo$$android_graphics_drawable_ColorDrawable$getOutline(android.graphics.Outline ), 0, this, outline);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_ColorDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    private void updateStateFromTypedArray(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_ColorDrawable$updateStateFromTypedArray(android.content.res.TypedArray ), 0, this, typedArray);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_ColorDrawable$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_graphics_drawable_ColorDrawable$getConstantState(), 0, this);
    }

    private void __constructor__(ColorState colorState, Resources resources, Resources.Theme theme) {
        this.$$robo$$android_graphics_drawable_ColorDrawable$__constructor__(colorState, resources, theme);
    }

    private ColorDrawable(ColorState colorState, Resources resources, Resources.Theme theme) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_ColorDrawable$__constructor__(android.graphics.drawable.ColorDrawable$ColorState android.content.res.Resources android.content.res.Resources$Theme ), 0, this, colorState, resources, theme);
    }

    private /* synthetic */ void __constructor__(ColorState colorState, Resources resources, Resources.Theme theme, 1 var4_4) {
        this.$$robo$$android_graphics_drawable_ColorDrawable$__constructor__(colorState, resources, theme, var4_4);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ColorDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ColorState
    extends Drawable.ConstantState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int[] mThemeAttrs;
        int mBaseColor;
        @ViewDebug.ExportedProperty
        int mUseColor;
        int mChangingConfigurations;
        ColorStateList mTint;
        PorterDuff.Mode mTintMode;

        private void $$robo$$android_graphics_drawable_ColorDrawable_ColorState$__constructor__() {
            this.mTint = null;
            this.mTintMode = Drawable.DEFAULT_TINT_MODE;
        }

        private void $$robo$$android_graphics_drawable_ColorDrawable_ColorState$__constructor__(ColorState state) {
            this.mTint = null;
            this.mTintMode = Drawable.DEFAULT_TINT_MODE;
            this.mThemeAttrs = state.mThemeAttrs;
            this.mBaseColor = state.mBaseColor;
            this.mUseColor = state.mUseColor;
            this.mChangingConfigurations = state.mChangingConfigurations;
            this.mTint = state.mTint;
            this.mTintMode = state.mTintMode;
        }

        private final boolean $$robo$$android_graphics_drawable_ColorDrawable_ColorState$canApplyTheme() {
            return this.mThemeAttrs != null;
        }

        private final Drawable $$robo$$android_graphics_drawable_ColorDrawable_ColorState$newDrawable() {
            return new ColorDrawable(this, null, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_ColorDrawable_ColorState$newDrawable(Resources res) {
            return new ColorDrawable(this, res, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_ColorDrawable_ColorState$newDrawable(Resources res, Resources.Theme theme) {
            return new ColorDrawable(this, res, theme);
        }

        private final int $$robo$$android_graphics_drawable_ColorDrawable_ColorState$getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_drawable_ColorDrawable_ColorState$__constructor__();
        }

        ColorState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_ColorDrawable_ColorState$__constructor__(), 0, this);
        }

        private void __constructor__(ColorState colorState) {
            this.$$robo$$android_graphics_drawable_ColorDrawable_ColorState$__constructor__(colorState);
        }

        ColorState(ColorState colorState) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_ColorDrawable_ColorState$__constructor__(android.graphics.drawable.ColorDrawable$ColorState ), 0, this, colorState);
        }

        @Override
        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_ColorDrawable_ColorState$canApplyTheme(), 0, this);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_ColorDrawable_ColorState$newDrawable(), 0, this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_ColorDrawable_ColorState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        @Override
        public Drawable newDrawable(Resources resources, Resources.Theme theme) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_ColorDrawable_ColorState$newDrawable(android.content.res.Resources android.content.res.Resources$Theme ), 0, this, resources, theme);
        }

        @Override
        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_ColorDrawable_ColorState$getChangingConfigurations(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ColorState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

