/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Insets;
import android.graphics.NinePatch;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Xfermode;
import android.graphics.drawable.AnimatedRotateDrawable;
import android.graphics.drawable.AnimatedStateListDrawable;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.LevelListDrawable;
import android.graphics.drawable.NinePatchDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.RotateDrawable;
import android.graphics.drawable.ScaleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.TransitionDrawable;
import android.graphics.drawable.VectorDrawable;
import android.os.Trace;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.StateSet;
import android.util.TypedValue;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class Drawable
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static Rect ZERO_BOUNDS_RECT;
    static PorterDuff.Mode DEFAULT_TINT_MODE;
    private int[] mStateSet;
    private int mLevel;
    private int mChangingConfigurations;
    private Rect mBounds;
    private WeakReference<Callback> mCallback;
    private boolean mVisible;
    private int mLayoutDirection;

    private void $$robo$$android_graphics_drawable_Drawable$__constructor__() {
        this.mStateSet = StateSet.WILD_CARD;
        this.mLevel = 0;
        this.mChangingConfigurations = 0;
        this.mBounds = ZERO_BOUNDS_RECT;
        this.mCallback = null;
        this.mVisible = true;
    }

    public abstract void draw(Canvas var1);

    private final void $$robo$$android_graphics_drawable_Drawable$setBounds(int left, int top, int right, int bottom) {
        Rect oldBounds = this.mBounds;
        if (oldBounds == ZERO_BOUNDS_RECT) {
            oldBounds = this.mBounds = new Rect();
        }
        if (oldBounds.left != left || oldBounds.top != top || oldBounds.right != right || oldBounds.bottom != bottom) {
            if (!oldBounds.isEmpty()) {
                this.invalidateSelf();
            }
            this.mBounds.set(left, top, right, bottom);
            this.onBoundsChange(this.mBounds);
        }
    }

    private final void $$robo$$android_graphics_drawable_Drawable$setBounds(Rect bounds) {
        this.setBounds(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    private final void $$robo$$android_graphics_drawable_Drawable$copyBounds(Rect bounds) {
        bounds.set(this.mBounds);
    }

    private final Rect $$robo$$android_graphics_drawable_Drawable$copyBounds() {
        return new Rect(this.mBounds);
    }

    private final Rect $$robo$$android_graphics_drawable_Drawable$getBounds() {
        if (this.mBounds == ZERO_BOUNDS_RECT) {
            this.mBounds = new Rect();
        }
        return this.mBounds;
    }

    private final Rect $$robo$$android_graphics_drawable_Drawable$getDirtyBounds() {
        return this.getBounds();
    }

    private final void $$robo$$android_graphics_drawable_Drawable$setChangingConfigurations(int configs) {
        this.mChangingConfigurations = configs;
    }

    private final int $$robo$$android_graphics_drawable_Drawable$getChangingConfigurations() {
        return this.mChangingConfigurations;
    }

    private final void $$robo$$android_graphics_drawable_Drawable$setDither(boolean dither) {
    }

    private final void $$robo$$android_graphics_drawable_Drawable$setFilterBitmap(boolean filter) {
    }

    private final void $$robo$$android_graphics_drawable_Drawable$setCallback(Callback cb) {
        this.mCallback = new WeakReference<Callback>(cb);
    }

    private final Callback $$robo$$android_graphics_drawable_Drawable$getCallback() {
        if (this.mCallback != null) {
            return (Callback)this.mCallback.get();
        }
        return null;
    }

    private final void $$robo$$android_graphics_drawable_Drawable$invalidateSelf() {
        Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable(this);
        }
    }

    private final void $$robo$$android_graphics_drawable_Drawable$scheduleSelf(Runnable what, long when) {
        Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable(this, what, when);
        }
    }

    private final void $$robo$$android_graphics_drawable_Drawable$unscheduleSelf(Runnable what) {
        Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable(this, what);
        }
    }

    private final int $$robo$$android_graphics_drawable_Drawable$getLayoutDirection() {
        return this.mLayoutDirection;
    }

    private final void $$robo$$android_graphics_drawable_Drawable$setLayoutDirection(int layoutDirection) {
        if (this.getLayoutDirection() != layoutDirection) {
            this.mLayoutDirection = layoutDirection;
        }
    }

    public abstract void setAlpha(int var1);

    private final int $$robo$$android_graphics_drawable_Drawable$getAlpha() {
        return 255;
    }

    private final void $$robo$$android_graphics_drawable_Drawable$setXfermode(Xfermode mode) {
    }

    public abstract void setColorFilter(ColorFilter var1);

    private final void $$robo$$android_graphics_drawable_Drawable$setColorFilter(int color2, PorterDuff.Mode mode) {
        this.setColorFilter(new PorterDuffColorFilter(color2, mode));
    }

    private final void $$robo$$android_graphics_drawable_Drawable$setTint(int tint) {
        this.setTintList(ColorStateList.valueOf(tint));
    }

    private final void $$robo$$android_graphics_drawable_Drawable$setTintList(ColorStateList tint) {
    }

    private final void $$robo$$android_graphics_drawable_Drawable$setTintMode(PorterDuff.Mode tintMode) {
    }

    private final ColorFilter $$robo$$android_graphics_drawable_Drawable$getColorFilter() {
        return null;
    }

    private final void $$robo$$android_graphics_drawable_Drawable$clearColorFilter() {
        this.setColorFilter(null);
    }

    private final void $$robo$$android_graphics_drawable_Drawable$setHotspot(float x, float y) {
    }

    private final void $$robo$$android_graphics_drawable_Drawable$setHotspotBounds(int left, int top, int right, int bottom) {
    }

    private final void $$robo$$android_graphics_drawable_Drawable$getHotspotBounds(Rect outRect) {
        outRect.set(this.getBounds());
    }

    private final boolean $$robo$$android_graphics_drawable_Drawable$isProjected() {
        return false;
    }

    private final boolean $$robo$$android_graphics_drawable_Drawable$isStateful() {
        return false;
    }

    private final boolean $$robo$$android_graphics_drawable_Drawable$setState(int[] stateSet) {
        if (!Arrays.equals(this.mStateSet, stateSet)) {
            this.mStateSet = stateSet;
            return this.onStateChange(stateSet);
        }
        return false;
    }

    private final int[] $$robo$$android_graphics_drawable_Drawable$getState() {
        return this.mStateSet;
    }

    private final void $$robo$$android_graphics_drawable_Drawable$jumpToCurrentState() {
    }

    private final Drawable $$robo$$android_graphics_drawable_Drawable$getCurrent() {
        return this;
    }

    private final boolean $$robo$$android_graphics_drawable_Drawable$setLevel(int level) {
        if (this.mLevel != level) {
            this.mLevel = level;
            return this.onLevelChange(level);
        }
        return false;
    }

    private final int $$robo$$android_graphics_drawable_Drawable$getLevel() {
        return this.mLevel;
    }

    private final boolean $$robo$$android_graphics_drawable_Drawable$setVisible(boolean visible, boolean restart) {
        boolean changed;
        boolean bl = changed = this.mVisible != visible;
        if (changed) {
            this.mVisible = visible;
            this.invalidateSelf();
        }
        return changed;
    }

    private final boolean $$robo$$android_graphics_drawable_Drawable$isVisible() {
        return this.mVisible;
    }

    private final void $$robo$$android_graphics_drawable_Drawable$setAutoMirrored(boolean mirrored) {
    }

    private final boolean $$robo$$android_graphics_drawable_Drawable$isAutoMirrored() {
        return false;
    }

    private final void $$robo$$android_graphics_drawable_Drawable$applyTheme(Resources.Theme t) {
    }

    private final boolean $$robo$$android_graphics_drawable_Drawable$canApplyTheme() {
        return false;
    }

    public abstract int getOpacity();

    private static final int $$robo$$android_graphics_drawable_Drawable$resolveOpacity(int op1, int op2) {
        if (op1 == op2) {
            return op1;
        }
        if (op1 == 0 || op2 == 0) {
            return 0;
        }
        if (op1 == -3 || op2 == -3) {
            return -3;
        }
        if (op1 == -2 || op2 == -2) {
            return -2;
        }
        return -1;
    }

    private final Region $$robo$$android_graphics_drawable_Drawable$getTransparentRegion() {
        return null;
    }

    private final boolean $$robo$$android_graphics_drawable_Drawable$onStateChange(int[] state) {
        return false;
    }

    private final boolean $$robo$$android_graphics_drawable_Drawable$onLevelChange(int level) {
        return false;
    }

    private final void $$robo$$android_graphics_drawable_Drawable$onBoundsChange(Rect bounds) {
    }

    private final int $$robo$$android_graphics_drawable_Drawable$getIntrinsicWidth() {
        return -1;
    }

    private final int $$robo$$android_graphics_drawable_Drawable$getIntrinsicHeight() {
        return -1;
    }

    private final int $$robo$$android_graphics_drawable_Drawable$getMinimumWidth() {
        int intrinsicWidth = this.getIntrinsicWidth();
        return intrinsicWidth > 0 ? intrinsicWidth : 0;
    }

    private final int $$robo$$android_graphics_drawable_Drawable$getMinimumHeight() {
        int intrinsicHeight = this.getIntrinsicHeight();
        return intrinsicHeight > 0 ? intrinsicHeight : 0;
    }

    private final boolean $$robo$$android_graphics_drawable_Drawable$getPadding(Rect padding) {
        padding.set(0, 0, 0, 0);
        return false;
    }

    private final Insets $$robo$$android_graphics_drawable_Drawable$getOpticalInsets() {
        return Insets.NONE;
    }

    private final void $$robo$$android_graphics_drawable_Drawable$getOutline(Outline outline) {
        outline.setRect(this.getBounds());
        outline.setAlpha(0.0f);
    }

    private final Drawable $$robo$$android_graphics_drawable_Drawable$mutate() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Drawable $$robo$$android_graphics_drawable_Drawable$createFromStream(InputStream is, String srcName) {
        Trace.traceBegin(8192L, srcName != null ? srcName : "Unknown drawable");
        try {
            Drawable drawable2 = Drawable.createFromResourceStream(null, null, is, srcName);
            return drawable2;
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Drawable $$robo$$android_graphics_drawable_Drawable$createFromResourceStream(Resources res, TypedValue value, InputStream is, String srcName) {
        Trace.traceBegin(8192L, srcName != null ? srcName : "Unknown drawable");
        try {
            Drawable drawable2 = Drawable.createFromResourceStream(res, value, is, srcName, null);
            return drawable2;
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    private static final Drawable $$robo$$android_graphics_drawable_Drawable$createFromResourceStream(Resources res, TypedValue value, InputStream is, String srcName, BitmapFactory.Options opts) {
        if (is == null) {
            return null;
        }
        Rect pad = new Rect();
        if (opts == null) {
            opts = new BitmapFactory.Options();
        }
        opts.inScreenDensity = res != null ? res.getDisplayMetrics().noncompatDensityDpi : DisplayMetrics.DENSITY_DEVICE;
        Bitmap bm = BitmapFactory.decodeResourceStream(res, value, is, pad, opts);
        if (bm != null) {
            byte[] np = bm.getNinePatchChunk();
            if (np == null || !NinePatch.isNinePatchChunk(np)) {
                np = null;
                pad = null;
            }
            Rect opticalInsets = new Rect();
            bm.getOpticalInsets(opticalInsets);
            return Drawable.drawableFromBitmap(res, bm, np, pad, opticalInsets, srcName);
        }
        return null;
    }

    private static final Drawable $$robo$$android_graphics_drawable_Drawable$createFromXml(Resources r, XmlPullParser parser) throws XmlPullParserException, IOException {
        return Drawable.createFromXml(r, parser, null);
    }

    private static final Drawable $$robo$$android_graphics_drawable_Drawable$createFromXml(Resources r, XmlPullParser parser, Resources.Theme theme) throws XmlPullParserException, IOException {
        int type;
        AttributeSet attrs = Xml.asAttributeSet(parser);
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        Drawable drawable2 = Drawable.createFromXmlInner(r, parser, attrs, theme);
        if (drawable2 == null) {
            throw new RuntimeException("Unknown initial tag: " + parser.getName());
        }
        return drawable2;
    }

    private static final Drawable $$robo$$android_graphics_drawable_Drawable$createFromXmlInner(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        return Drawable.createFromXmlInner(r, parser, attrs, null);
    }

    private static final Drawable $$robo$$android_graphics_drawable_Drawable$createFromXmlInner(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        Drawable drawable2;
        String name = parser.getName();
        if (name.equals("selector")) {
            drawable2 = new StateListDrawable();
        } else if (name.equals("animated-selector")) {
            drawable2 = new AnimatedStateListDrawable();
        } else if (name.equals("level-list")) {
            drawable2 = new LevelListDrawable();
        } else if (name.equals("layer-list")) {
            drawable2 = new LayerDrawable();
        } else if (name.equals("transition")) {
            drawable2 = new TransitionDrawable();
        } else if (name.equals("ripple")) {
            drawable2 = new RippleDrawable();
        } else if (name.equals("color")) {
            drawable2 = new ColorDrawable();
        } else if (name.equals("shape")) {
            drawable2 = new GradientDrawable();
        } else if (name.equals("vector")) {
            drawable2 = new VectorDrawable();
        } else if (name.equals("animated-vector")) {
            drawable2 = new AnimatedVectorDrawable();
        } else if (name.equals("scale")) {
            drawable2 = new ScaleDrawable();
        } else if (name.equals("clip")) {
            drawable2 = new ClipDrawable();
        } else if (name.equals("rotate")) {
            drawable2 = new RotateDrawable();
        } else if (name.equals("animated-rotate")) {
            drawable2 = new AnimatedRotateDrawable();
        } else if (name.equals("animation-list")) {
            drawable2 = new AnimationDrawable();
        } else if (name.equals("inset")) {
            drawable2 = new InsetDrawable();
        } else if (name.equals("bitmap")) {
            drawable2 = new BitmapDrawable(r);
            if (r != null) {
                ((BitmapDrawable)drawable2).setTargetDensity(r.getDisplayMetrics());
            }
        } else if (name.equals("nine-patch")) {
            drawable2 = new NinePatchDrawable();
            if (r != null) {
                ((NinePatchDrawable)drawable2).setTargetDensity(r.getDisplayMetrics());
            }
        } else {
            throw new XmlPullParserException(parser.getPositionDescription() + ": invalid drawable tag " + name);
        }
        ((Drawable)drawable2).inflate(r, parser, attrs, theme);
        return drawable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Drawable $$robo$$android_graphics_drawable_Drawable$createFromPath(String pathName) {
        if (pathName == null) {
            return null;
        }
        Trace.traceBegin(8192L, pathName);
        try {
            Bitmap bm = BitmapFactory.decodeFile(pathName);
            if (bm != null) {
                Drawable drawable2 = Drawable.drawableFromBitmap(null, bm, null, null, null, pathName);
                return drawable2;
            }
        }
        finally {
            Trace.traceEnd(8192L);
        }
        return null;
    }

    private final void $$robo$$android_graphics_drawable_Drawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        this.inflate(r, parser, attrs, null);
    }

    private final void $$robo$$android_graphics_drawable_Drawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = theme != null ? theme.obtainStyledAttributes(attrs, R.styleable.Drawable, 0, 0) : r.obtainAttributes(attrs, R.styleable.Drawable);
        this.inflateWithAttributes(r, parser, a, 0);
        a.recycle();
    }

    private final void $$robo$$android_graphics_drawable_Drawable$inflateWithAttributes(Resources r, XmlPullParser parser, TypedArray attrs, int visibleAttr) throws XmlPullParserException, IOException {
        this.mVisible = attrs.getBoolean(visibleAttr, this.mVisible);
    }

    private final ConstantState $$robo$$android_graphics_drawable_Drawable$getConstantState() {
        return null;
    }

    private static final Drawable $$robo$$android_graphics_drawable_Drawable$drawableFromBitmap(Resources res, Bitmap bm, byte[] np, Rect pad, Rect layoutBounds, String srcName) {
        if (np != null) {
            return new NinePatchDrawable(res, bm, np, pad, layoutBounds, srcName);
        }
        return new BitmapDrawable(res, bm);
    }

    private final PorterDuffColorFilter $$robo$$android_graphics_drawable_Drawable$updateTintFilter(PorterDuffColorFilter tintFilter, ColorStateList tint, PorterDuff.Mode tintMode) {
        if (tint == null || tintMode == null) {
            return null;
        }
        int color2 = tint.getColorForState(this.getState(), 0);
        if (tintFilter == null) {
            return new PorterDuffColorFilter(color2, tintMode);
        }
        tintFilter.setColor(color2);
        tintFilter.setMode(tintMode);
        return tintFilter;
    }

    private static final TypedArray $$robo$$android_graphics_drawable_Drawable$obtainAttributes(Resources res, Resources.Theme theme, AttributeSet set, int[] attrs) {
        if (theme == null) {
            return res.obtainAttributes(set, attrs);
        }
        return theme.obtainStyledAttributes(set, attrs, 0, 0);
    }

    private static final PorterDuff.Mode $$robo$$android_graphics_drawable_Drawable$parseTintMode(int value, PorterDuff.Mode defaultMode) {
        switch (value) {
            case 3: {
                return PorterDuff.Mode.SRC_OVER;
            }
            case 5: {
                return PorterDuff.Mode.SRC_IN;
            }
            case 9: {
                return PorterDuff.Mode.SRC_ATOP;
            }
            case 14: {
                return PorterDuff.Mode.MULTIPLY;
            }
            case 15: {
                return PorterDuff.Mode.SCREEN;
            }
            case 16: {
                return PorterDuff.Mode.ADD;
            }
        }
        return defaultMode;
    }

    static void __staticInitializer__() {
        ZERO_BOUNDS_RECT = new Rect();
        DEFAULT_TINT_MODE = PorterDuff.Mode.SRC_IN;
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_Drawable$__constructor__();
    }

    public Drawable() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_Drawable$__constructor__(), 0, this);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setBounds", $$robo$$android_graphics_drawable_Drawable$setBounds(int int int int ), 0, this, n, n2, n3, n4);
    }

    public void setBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("setBounds", $$robo$$android_graphics_drawable_Drawable$setBounds(android.graphics.Rect ), 0, this, rect);
    }

    public void copyBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("copyBounds", $$robo$$android_graphics_drawable_Drawable$copyBounds(android.graphics.Rect ), 0, this, rect);
    }

    public Rect copyBounds() {
        return InvokeDynamicSupport.bootstrap("copyBounds", $$robo$$android_graphics_drawable_Drawable$copyBounds(), 0, this);
    }

    public Rect getBounds() {
        return InvokeDynamicSupport.bootstrap("getBounds", $$robo$$android_graphics_drawable_Drawable$getBounds(), 0, this);
    }

    public Rect getDirtyBounds() {
        return InvokeDynamicSupport.bootstrap("getDirtyBounds", $$robo$$android_graphics_drawable_Drawable$getDirtyBounds(), 0, this);
    }

    public void setChangingConfigurations(int n) {
        InvokeDynamicSupport.bootstrap("setChangingConfigurations", $$robo$$android_graphics_drawable_Drawable$setChangingConfigurations(int ), 0, this, n);
    }

    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_Drawable$getChangingConfigurations(), 0, this);
    }

    public void setDither(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDither", $$robo$$android_graphics_drawable_Drawable$setDither(boolean ), 0, this, bl);
    }

    public void setFilterBitmap(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFilterBitmap", $$robo$$android_graphics_drawable_Drawable$setFilterBitmap(boolean ), 0, this, bl);
    }

    public void setCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("setCallback", $$robo$$android_graphics_drawable_Drawable$setCallback(android.graphics.drawable.Drawable$Callback ), 0, this, callback);
    }

    public Callback getCallback() {
        return InvokeDynamicSupport.bootstrap("getCallback", $$robo$$android_graphics_drawable_Drawable$getCallback(), 0, this);
    }

    public void invalidateSelf() {
        InvokeDynamicSupport.bootstrap("invalidateSelf", $$robo$$android_graphics_drawable_Drawable$invalidateSelf(), 0, this);
    }

    public void scheduleSelf(Runnable runnable, long l) {
        InvokeDynamicSupport.bootstrap("scheduleSelf", $$robo$$android_graphics_drawable_Drawable$scheduleSelf(java.lang.Runnable long ), 0, this, runnable, l);
    }

    public void unscheduleSelf(Runnable runnable) {
        InvokeDynamicSupport.bootstrap("unscheduleSelf", $$robo$$android_graphics_drawable_Drawable$unscheduleSelf(java.lang.Runnable ), 0, this, runnable);
    }

    public int getLayoutDirection() {
        return (int)InvokeDynamicSupport.bootstrap("getLayoutDirection", $$robo$$android_graphics_drawable_Drawable$getLayoutDirection(), 0, this);
    }

    public void setLayoutDirection(int n) {
        InvokeDynamicSupport.bootstrap("setLayoutDirection", $$robo$$android_graphics_drawable_Drawable$setLayoutDirection(int ), 0, this, n);
    }

    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_drawable_Drawable$getAlpha(), 0, this);
    }

    public void setXfermode(Xfermode xfermode) {
        InvokeDynamicSupport.bootstrap("setXfermode", $$robo$$android_graphics_drawable_Drawable$setXfermode(android.graphics.Xfermode ), 0, this, xfermode);
    }

    public void setColorFilter(int n, PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_graphics_drawable_Drawable$setColorFilter(int android.graphics.PorterDuff$Mode ), 0, this, n, mode);
    }

    public void setTint(int n) {
        InvokeDynamicSupport.bootstrap("setTint", $$robo$$android_graphics_drawable_Drawable$setTint(int ), 0, this, n);
    }

    public void setTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setTintList", $$robo$$android_graphics_drawable_Drawable$setTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    public void setTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setTintMode", $$robo$$android_graphics_drawable_Drawable$setTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    public ColorFilter getColorFilter() {
        return InvokeDynamicSupport.bootstrap("getColorFilter", $$robo$$android_graphics_drawable_Drawable$getColorFilter(), 0, this);
    }

    public void clearColorFilter() {
        InvokeDynamicSupport.bootstrap("clearColorFilter", $$robo$$android_graphics_drawable_Drawable$clearColorFilter(), 0, this);
    }

    public void setHotspot(float f, float f2) {
        InvokeDynamicSupport.bootstrap("setHotspot", $$robo$$android_graphics_drawable_Drawable$setHotspot(float float ), 0, this, f, f2);
    }

    public void setHotspotBounds(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setHotspotBounds", $$robo$$android_graphics_drawable_Drawable$setHotspotBounds(int int int int ), 0, this, n, n2, n3, n4);
    }

    public void getHotspotBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("getHotspotBounds", $$robo$$android_graphics_drawable_Drawable$getHotspotBounds(android.graphics.Rect ), 0, this, rect);
    }

    public boolean isProjected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isProjected", $$robo$$android_graphics_drawable_Drawable$isProjected(), 0, this);
    }

    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_Drawable$isStateful(), 0, this);
    }

    public boolean setState(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("setState", $$robo$$android_graphics_drawable_Drawable$setState(int[] ), 0, this, nArray);
    }

    public int[] getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$android_graphics_drawable_Drawable$getState(), 0, this);
    }

    public void jumpToCurrentState() {
        InvokeDynamicSupport.bootstrap("jumpToCurrentState", $$robo$$android_graphics_drawable_Drawable$jumpToCurrentState(), 0, this);
    }

    public Drawable getCurrent() {
        return InvokeDynamicSupport.bootstrap("getCurrent", $$robo$$android_graphics_drawable_Drawable$getCurrent(), 0, this);
    }

    public boolean setLevel(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setLevel", $$robo$$android_graphics_drawable_Drawable$setLevel(int ), 0, this, n);
    }

    public int getLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getLevel", $$robo$$android_graphics_drawable_Drawable$getLevel(), 0, this);
    }

    public boolean setVisible(boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setVisible", $$robo$$android_graphics_drawable_Drawable$setVisible(boolean boolean ), 0, this, bl, bl2);
    }

    public boolean isVisible() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVisible", $$robo$$android_graphics_drawable_Drawable$isVisible(), 0, this);
    }

    public void setAutoMirrored(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAutoMirrored", $$robo$$android_graphics_drawable_Drawable$setAutoMirrored(boolean ), 0, this, bl);
    }

    public boolean isAutoMirrored() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAutoMirrored", $$robo$$android_graphics_drawable_Drawable$isAutoMirrored(), 0, this);
    }

    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_Drawable$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
    }

    public boolean canApplyTheme() {
        return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_Drawable$canApplyTheme(), 0, this);
    }

    public static int resolveOpacity(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("resolveOpacity", $$robo$$android_graphics_drawable_Drawable$resolveOpacity(int int ), 0, (int)n, (int)n2);
    }

    public Region getTransparentRegion() {
        return InvokeDynamicSupport.bootstrap("getTransparentRegion", $$robo$$android_graphics_drawable_Drawable$getTransparentRegion(), 0, this);
    }

    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_Drawable$onStateChange(int[] ), 0, this, nArray);
    }

    protected boolean onLevelChange(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLevelChange", $$robo$$android_graphics_drawable_Drawable$onLevelChange(int ), 0, this, n);
    }

    protected void onBoundsChange(Rect rect) {
        InvokeDynamicSupport.bootstrap("onBoundsChange", $$robo$$android_graphics_drawable_Drawable$onBoundsChange(android.graphics.Rect ), 0, this, rect);
    }

    public int getIntrinsicWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicWidth", $$robo$$android_graphics_drawable_Drawable$getIntrinsicWidth(), 0, this);
    }

    public int getIntrinsicHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicHeight", $$robo$$android_graphics_drawable_Drawable$getIntrinsicHeight(), 0, this);
    }

    public int getMinimumWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getMinimumWidth", $$robo$$android_graphics_drawable_Drawable$getMinimumWidth(), 0, this);
    }

    public int getMinimumHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getMinimumHeight", $$robo$$android_graphics_drawable_Drawable$getMinimumHeight(), 0, this);
    }

    public boolean getPadding(Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getPadding", $$robo$$android_graphics_drawable_Drawable$getPadding(android.graphics.Rect ), 0, this, rect);
    }

    public Insets getOpticalInsets() {
        return InvokeDynamicSupport.bootstrap("getOpticalInsets", $$robo$$android_graphics_drawable_Drawable$getOpticalInsets(), 0, this);
    }

    public void getOutline(Outline outline) {
        InvokeDynamicSupport.bootstrap("getOutline", $$robo$$android_graphics_drawable_Drawable$getOutline(android.graphics.Outline ), 0, this, outline);
    }

    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_Drawable$mutate(), 0, this);
    }

    public static Drawable createFromStream(InputStream inputStream, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createFromStream", $$robo$$android_graphics_drawable_Drawable$createFromStream(java.io.InputStream java.lang.String ), 0, (InputStream)inputStream, (String)string2);
    }

    public static Drawable createFromResourceStream(Resources resources, TypedValue typedValue, InputStream inputStream, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createFromResourceStream", $$robo$$android_graphics_drawable_Drawable$createFromResourceStream(android.content.res.Resources android.util.TypedValue java.io.InputStream java.lang.String ), 0, (Resources)resources, (TypedValue)typedValue, (InputStream)inputStream, (String)string2);
    }

    public static Drawable createFromResourceStream(Resources resources, TypedValue typedValue, InputStream inputStream, String string2, BitmapFactory.Options options) {
        return InvokeDynamicSupport.bootstrapStatic("createFromResourceStream", $$robo$$android_graphics_drawable_Drawable$createFromResourceStream(android.content.res.Resources android.util.TypedValue java.io.InputStream java.lang.String android.graphics.BitmapFactory$Options ), 0, (Resources)resources, (TypedValue)typedValue, (InputStream)inputStream, (String)string2, (BitmapFactory.Options)options);
    }

    public static Drawable createFromXml(Resources resources, XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("createFromXml", $$robo$$android_graphics_drawable_Drawable$createFromXml(android.content.res.Resources org.xmlpull.v1.XmlPullParser ), 0, (Resources)resources, (XmlPullParser)xmlPullParser);
    }

    public static Drawable createFromXml(Resources resources, XmlPullParser xmlPullParser, Resources.Theme theme) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("createFromXml", $$robo$$android_graphics_drawable_Drawable$createFromXml(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.content.res.Resources$Theme ), 0, (Resources)resources, (XmlPullParser)xmlPullParser, (Resources.Theme)theme);
    }

    public static Drawable createFromXmlInner(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("createFromXmlInner", $$robo$$android_graphics_drawable_Drawable$createFromXmlInner(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet ), 0, (Resources)resources, (XmlPullParser)xmlPullParser, (AttributeSet)attributeSet);
    }

    public static Drawable createFromXmlInner(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("createFromXmlInner", $$robo$$android_graphics_drawable_Drawable$createFromXmlInner(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, (Resources)resources, (XmlPullParser)xmlPullParser, (AttributeSet)attributeSet, (Resources.Theme)theme);
    }

    public static Drawable createFromPath(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createFromPath", $$robo$$android_graphics_drawable_Drawable$createFromPath(java.lang.String ), 0, (String)string2);
    }

    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_Drawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet ), 0, this, resources, xmlPullParser, attributeSet);
    }

    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_Drawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    void inflateWithAttributes(Resources resources, XmlPullParser xmlPullParser, TypedArray typedArray, int n) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflateWithAttributes", $$robo$$android_graphics_drawable_Drawable$inflateWithAttributes(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.content.res.TypedArray int ), 0, this, resources, xmlPullParser, typedArray, n);
    }

    public ConstantState getConstantState() {
        return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_graphics_drawable_Drawable$getConstantState(), 0, this);
    }

    private static Drawable drawableFromBitmap(Resources resources, Bitmap bitmap, byte[] byArray, Rect rect, Rect rect2, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("drawableFromBitmap", $$robo$$android_graphics_drawable_Drawable$drawableFromBitmap(android.content.res.Resources android.graphics.Bitmap byte[] android.graphics.Rect android.graphics.Rect java.lang.String ), 0, (Resources)resources, (Bitmap)bitmap, (byte[])byArray, (Rect)rect, (Rect)rect2, (String)string2);
    }

    PorterDuffColorFilter updateTintFilter(PorterDuffColorFilter porterDuffColorFilter, ColorStateList colorStateList, PorterDuff.Mode mode) {
        return InvokeDynamicSupport.bootstrap("updateTintFilter", $$robo$$android_graphics_drawable_Drawable$updateTintFilter(android.graphics.PorterDuffColorFilter android.content.res.ColorStateList android.graphics.PorterDuff$Mode ), 0, this, porterDuffColorFilter, colorStateList, mode);
    }

    static TypedArray obtainAttributes(Resources resources, Resources.Theme theme, AttributeSet attributeSet, int[] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("obtainAttributes", $$robo$$android_graphics_drawable_Drawable$obtainAttributes(android.content.res.Resources android.content.res.Resources$Theme android.util.AttributeSet int[] ), 0, (Resources)resources, (Resources.Theme)theme, (AttributeSet)attributeSet, (int[])nArray);
    }

    public static PorterDuff.Mode parseTintMode(int n, PorterDuff.Mode mode) {
        return InvokeDynamicSupport.bootstrapStatic("parseTintMode", $$robo$$android_graphics_drawable_Drawable$parseTintMode(int android.graphics.PorterDuff$Mode ), 0, (int)n, (PorterDuff.Mode)mode);
    }

    static {
        RobolectricInternals.classInitializing(Drawable.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Drawable)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class ConstantState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_graphics_drawable_Drawable_ConstantState$__constructor__() {
        }

        public abstract Drawable newDrawable();

        private final Drawable $$robo$$android_graphics_drawable_Drawable_ConstantState$newDrawable(Resources res) {
            return this.newDrawable();
        }

        private final Drawable $$robo$$android_graphics_drawable_Drawable_ConstantState$newDrawable(Resources res, Resources.Theme theme) {
            return this.newDrawable();
        }

        public abstract int getChangingConfigurations();

        private final Bitmap $$robo$$android_graphics_drawable_Drawable_ConstantState$getBitmap() {
            return null;
        }

        private final boolean $$robo$$android_graphics_drawable_Drawable_ConstantState$canApplyTheme() {
            return false;
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_drawable_Drawable_ConstantState$__constructor__();
        }

        public ConstantState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_Drawable_ConstantState$__constructor__(), 0, this);
        }

        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_Drawable_ConstantState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        public Drawable newDrawable(Resources resources, Resources.Theme theme) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_Drawable_ConstantState$newDrawable(android.content.res.Resources android.content.res.Resources$Theme ), 0, this, resources, theme);
        }

        public Bitmap getBitmap() {
            return InvokeDynamicSupport.bootstrap("getBitmap", $$robo$$android_graphics_drawable_Drawable_ConstantState$getBitmap(), 0, this);
        }

        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_Drawable_ConstantState$canApplyTheme(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConstantState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface Callback
    extends InstrumentedInterface {
        public void invalidateDrawable(Drawable var1);

        public void scheduleDrawable(Drawable var1, Runnable var2, long var3);

        public void unscheduleDrawable(Drawable var1, Runnable var2);
    }
}

