/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.LinearGradient;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class GradientDrawable
extends Drawable
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int RECTANGLE = 0;
    public static int OVAL = 1;
    public static int LINE = 2;
    public static int RING = 3;
    public static int LINEAR_GRADIENT = 0;
    public static int RADIAL_GRADIENT = 1;
    public static int SWEEP_GRADIENT = 2;
    private static int RADIUS_TYPE_PIXELS = 0;
    private static int RADIUS_TYPE_FRACTION = 1;
    private static int RADIUS_TYPE_FRACTION_PARENT = 2;
    private static float DEFAULT_INNER_RADIUS_RATIO = 3.0f;
    private static float DEFAULT_THICKNESS_RATIO = 9.0f;
    private GradientState mGradientState;
    private Paint mFillPaint;
    private Rect mPadding;
    private Paint mStrokePaint;
    private ColorFilter mColorFilter;
    private int mAlpha;
    private Path mPath;
    private RectF mRect;
    private Paint mLayerPaint;
    private boolean mGradientIsDirty;
    private boolean mMutated;
    private Path mRingPath;
    private boolean mPathIsDirty;
    private float mGradientRadius;

    private void $$robo$$android_graphics_drawable_GradientDrawable$__constructor__() {
    }

    private void $$robo$$android_graphics_drawable_GradientDrawable$__constructor__(Orientation orientation, int[] colors) {
    }

    private final boolean $$robo$$android_graphics_drawable_GradientDrawable$getPadding(Rect padding) {
        if (this.mPadding != null) {
            padding.set(this.mPadding);
            return true;
        }
        return super.getPadding(padding);
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setCornerRadii(float[] radii) {
        this.mGradientState.setCornerRadii(radii);
        this.mPathIsDirty = true;
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setCornerRadius(float radius) {
        this.mGradientState.setCornerRadius(radius);
        this.mPathIsDirty = true;
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setStroke(int width, int color2) {
        this.setStroke(width, color2, 0.0f, 0.0f);
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setStroke(int width, ColorStateList colorStateList) {
        this.setStroke(width, colorStateList, 0.0f, 0.0f);
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setStroke(int width, int color2, float dashWidth, float dashGap) {
        this.mGradientState.setStroke(width, ColorStateList.valueOf(color2), dashWidth, dashGap);
        this.setStrokeInternal(width, color2, dashWidth, dashGap);
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setStroke(int width, ColorStateList colorStateList, float dashWidth, float dashGap) {
        int color2;
        this.mGradientState.setStroke(width, colorStateList, dashWidth, dashGap);
        if (colorStateList == null) {
            color2 = 0;
        } else {
            int[] stateSet = this.getState();
            color2 = colorStateList.getColorForState(stateSet, 0);
        }
        this.setStrokeInternal(width, color2, dashWidth, dashGap);
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setStrokeInternal(int width, int color2, float dashWidth, float dashGap) {
        if (this.mStrokePaint == null) {
            this.mStrokePaint = new Paint(1);
            this.mStrokePaint.setStyle(Paint.Style.STROKE);
        }
        this.mStrokePaint.setStrokeWidth(width);
        this.mStrokePaint.setColor(color2);
        DashPathEffect e = null;
        if (dashWidth > 0.0f) {
            e = new DashPathEffect(new float[]{dashWidth, dashGap}, 0.0f);
        }
        this.mStrokePaint.setPathEffect(e);
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setSize(int width, int height) {
        this.mGradientState.setSize(width, height);
        this.mPathIsDirty = true;
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setShape(int shape) {
        this.mRingPath = null;
        this.mPathIsDirty = true;
        this.mGradientState.setShape(shape);
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setGradientType(int gradient) {
        this.mGradientState.setGradientType(gradient);
        this.mGradientIsDirty = true;
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setGradientCenter(float x, float y) {
        this.mGradientState.setGradientCenter(x, y);
        this.mGradientIsDirty = true;
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setGradientRadius(float gradientRadius) {
        this.mGradientState.setGradientRadius(gradientRadius, 0);
        this.mGradientIsDirty = true;
        this.invalidateSelf();
    }

    private final float $$robo$$android_graphics_drawable_GradientDrawable$getGradientRadius() {
        if (this.mGradientState.mGradient != 1) {
            return 0.0f;
        }
        this.ensureValidRect();
        return this.mGradientRadius;
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setUseLevel(boolean useLevel) {
        this.mGradientState.mUseLevel = useLevel;
        this.mGradientIsDirty = true;
        this.invalidateSelf();
    }

    private final int $$robo$$android_graphics_drawable_GradientDrawable$modulateAlpha(int alpha) {
        int scale = this.mAlpha + (this.mAlpha >> 7);
        return alpha * scale >> 8;
    }

    private final Orientation $$robo$$android_graphics_drawable_GradientDrawable$getOrientation() {
        return this.mGradientState.mOrientation;
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setOrientation(Orientation orientation) {
        this.mGradientState.mOrientation = orientation;
        this.mGradientIsDirty = true;
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setColors(int[] colors) {
        this.mGradientState.setColors(colors);
        this.mGradientIsDirty = true;
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$draw(Canvas canvas) {
        float rad;
        boolean useLayer;
        if (!this.ensureValidRect()) {
            return;
        }
        int prevFillAlpha = this.mFillPaint.getAlpha();
        int prevStrokeAlpha = this.mStrokePaint != null ? this.mStrokePaint.getAlpha() : 0;
        int currFillAlpha = this.modulateAlpha(prevFillAlpha);
        int currStrokeAlpha = this.modulateAlpha(prevStrokeAlpha);
        boolean haveStroke = currStrokeAlpha > 0 && this.mStrokePaint != null && this.mStrokePaint.getStrokeWidth() > 0.0f;
        boolean haveFill = currFillAlpha > 0;
        GradientState st = this.mGradientState;
        boolean bl = useLayer = haveStroke && haveFill && st.mShape != 2 && currStrokeAlpha < 255 && (this.mAlpha < 255 || this.mColorFilter != null);
        if (useLayer) {
            if (this.mLayerPaint == null) {
                this.mLayerPaint = new Paint();
            }
            this.mLayerPaint.setDither(st.mDither);
            this.mLayerPaint.setAlpha(this.mAlpha);
            this.mLayerPaint.setColorFilter(this.mColorFilter);
            rad = this.mStrokePaint.getStrokeWidth();
            canvas.saveLayer(this.mRect.left - rad, this.mRect.top - rad, this.mRect.right + rad, this.mRect.bottom + rad, this.mLayerPaint, 4);
            this.mFillPaint.setColorFilter(null);
            this.mStrokePaint.setColorFilter(null);
        } else {
            this.mFillPaint.setAlpha(currFillAlpha);
            this.mFillPaint.setDither(st.mDither);
            this.mFillPaint.setColorFilter(this.mColorFilter);
            if (this.mColorFilter != null && st.mColorStateList == null) {
                this.mFillPaint.setColor(this.mAlpha << 24);
            }
            if (haveStroke) {
                this.mStrokePaint.setAlpha(currStrokeAlpha);
                this.mStrokePaint.setDither(st.mDither);
                this.mStrokePaint.setColorFilter(this.mColorFilter);
            }
        }
        switch (st.mShape) {
            case 0: {
                if (st.mRadiusArray != null) {
                    this.buildPathIfDirty();
                    canvas.drawPath(this.mPath, this.mFillPaint);
                    if (!haveStroke) break;
                    canvas.drawPath(this.mPath, this.mStrokePaint);
                    break;
                }
                if (st.mRadius > 0.0f) {
                    rad = Math.min(st.mRadius, Math.min(this.mRect.width(), this.mRect.height()) * 0.5f);
                    canvas.drawRoundRect(this.mRect, rad, rad, this.mFillPaint);
                    if (!haveStroke) break;
                    canvas.drawRoundRect(this.mRect, rad, rad, this.mStrokePaint);
                    break;
                }
                if (this.mFillPaint.getColor() != 0 || this.mColorFilter != null || this.mFillPaint.getShader() != null) {
                    canvas.drawRect(this.mRect, this.mFillPaint);
                }
                if (!haveStroke) break;
                canvas.drawRect(this.mRect, this.mStrokePaint);
                break;
            }
            case 1: {
                canvas.drawOval(this.mRect, this.mFillPaint);
                if (!haveStroke) break;
                canvas.drawOval(this.mRect, this.mStrokePaint);
                break;
            }
            case 2: {
                RectF r = this.mRect;
                float y = r.centerY();
                if (!haveStroke) break;
                canvas.drawLine(r.left, y, r.right, y, this.mStrokePaint);
                break;
            }
            case 3: {
                Path path = this.buildRing(st);
                canvas.drawPath(path, this.mFillPaint);
                if (!haveStroke) break;
                canvas.drawPath(path, this.mStrokePaint);
            }
        }
        if (useLayer) {
            canvas.restore();
        } else {
            this.mFillPaint.setAlpha(prevFillAlpha);
            if (haveStroke) {
                this.mStrokePaint.setAlpha(prevStrokeAlpha);
            }
        }
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$buildPathIfDirty() {
        GradientState st = this.mGradientState;
        if (this.mPathIsDirty) {
            this.ensureValidRect();
            this.mPath.reset();
            this.mPath.addRoundRect(this.mRect, st.mRadiusArray, Path.Direction.CW);
            this.mPathIsDirty = false;
        }
    }

    private final Path $$robo$$android_graphics_drawable_GradientDrawable$buildRing(GradientState st) {
        if (!(this.mRingPath == null || st.mUseLevelForShape && this.mPathIsDirty)) {
            return this.mRingPath;
        }
        this.mPathIsDirty = false;
        float sweep = st.mUseLevelForShape ? 360.0f * (float)this.getLevel() / 10000.0f : 360.0f;
        RectF bounds = new RectF(this.mRect);
        float x = bounds.width() / 2.0f;
        float y = bounds.height() / 2.0f;
        float thickness = st.mThickness != -1 ? (float)st.mThickness : bounds.width() / st.mThicknessRatio;
        float radius = st.mInnerRadius != -1 ? (float)st.mInnerRadius : bounds.width() / st.mInnerRadiusRatio;
        RectF innerBounds = new RectF(bounds);
        innerBounds.inset(x - radius, y - radius);
        bounds = new RectF(innerBounds);
        bounds.inset(-thickness, -thickness);
        if (this.mRingPath == null) {
            this.mRingPath = new Path();
        } else {
            this.mRingPath.reset();
        }
        Path ringPath = this.mRingPath;
        if (sweep < 360.0f && sweep > -360.0f) {
            ringPath.setFillType(Path.FillType.EVEN_ODD);
            ringPath.moveTo(x + radius, y);
            ringPath.lineTo(x + radius + thickness, y);
            ringPath.arcTo(bounds, 0.0f, sweep, false);
            ringPath.arcTo(innerBounds, sweep, -sweep, false);
            ringPath.close();
        } else {
            ringPath.addOval(bounds, Path.Direction.CW);
            ringPath.addOval(innerBounds, Path.Direction.CCW);
        }
        return ringPath;
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setColor(int argb) {
        this.mGradientState.setColorStateList(ColorStateList.valueOf(argb));
        this.mFillPaint.setColor(argb);
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setColor(ColorStateList colorStateList) {
        int color2;
        this.mGradientState.setColorStateList(colorStateList);
        if (colorStateList == null) {
            color2 = 0;
        } else {
            int[] stateSet = this.getState();
            color2 = colorStateList.getColorForState(stateSet, 0);
        }
        this.mFillPaint.setColor(color2);
        this.invalidateSelf();
    }

    private final boolean $$robo$$android_graphics_drawable_GradientDrawable$onStateChange(int[] stateSet) {
        ColorStateList strokeStateList;
        Paint strokePaint;
        boolean invalidateSelf = false;
        GradientState s = this.mGradientState;
        ColorStateList stateList = s.mColorStateList;
        if (stateList != null) {
            int newColor = stateList.getColorForState(stateSet, 0);
            int oldColor = this.mFillPaint.getColor();
            if (oldColor != newColor) {
                this.mFillPaint.setColor(newColor);
                invalidateSelf = true;
            }
        }
        if ((strokePaint = this.mStrokePaint) != null && (strokeStateList = s.mStrokeColorStateList) != null) {
            int newStrokeColor = strokeStateList.getColorForState(stateSet, 0);
            int oldStrokeColor = strokePaint.getColor();
            if (oldStrokeColor != newStrokeColor) {
                strokePaint.setColor(newStrokeColor);
                invalidateSelf = true;
            }
        }
        if (invalidateSelf) {
            this.invalidateSelf();
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_graphics_drawable_GradientDrawable$isStateful() {
        GradientState s = this.mGradientState;
        return super.isStateful() || s.mColorStateList != null && s.mColorStateList.isStateful() || s.mStrokeColorStateList != null && s.mStrokeColorStateList.isStateful();
    }

    private final int $$robo$$android_graphics_drawable_GradientDrawable$getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mGradientState.mChangingConfigurations;
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setAlpha(int alpha) {
        if (alpha != this.mAlpha) {
            this.mAlpha = alpha;
            this.invalidateSelf();
        }
    }

    private final int $$robo$$android_graphics_drawable_GradientDrawable$getAlpha() {
        return this.mAlpha;
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setDither(boolean dither) {
        if (dither != this.mGradientState.mDither) {
            this.mGradientState.mDither = dither;
            this.invalidateSelf();
        }
    }

    private final ColorFilter $$robo$$android_graphics_drawable_GradientDrawable$getColorFilter() {
        return this.mColorFilter;
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$setColorFilter(ColorFilter cf) {
        if (cf != this.mColorFilter) {
            this.mColorFilter = cf;
            this.invalidateSelf();
        }
    }

    private final int $$robo$$android_graphics_drawable_GradientDrawable$getOpacity() {
        return this.mAlpha == 255 && this.mGradientState.mOpaqueOverBounds && this.isOpaqueForState() ? -1 : -3;
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$onBoundsChange(Rect r) {
        super.onBoundsChange(r);
        this.mRingPath = null;
        this.mPathIsDirty = true;
        this.mGradientIsDirty = true;
    }

    private final boolean $$robo$$android_graphics_drawable_GradientDrawable$onLevelChange(int level) {
        super.onLevelChange(level);
        this.mGradientIsDirty = true;
        this.mPathIsDirty = true;
        this.invalidateSelf();
        return true;
    }

    private final boolean $$robo$$android_graphics_drawable_GradientDrawable$ensureValidRect() {
        if (this.mGradientIsDirty) {
            this.mGradientIsDirty = false;
            Rect bounds = this.getBounds();
            float inset = 0.0f;
            if (this.mStrokePaint != null) {
                inset = this.mStrokePaint.getStrokeWidth() * 0.5f;
            }
            GradientState st = this.mGradientState;
            this.mRect.set((float)bounds.left + inset, (float)bounds.top + inset, (float)bounds.right - inset, (float)bounds.bottom - inset);
            int[] colors = st.mColors;
            if (colors != null) {
                RectF r = this.mRect;
                if (st.mGradient == 0) {
                    float y1;
                    float x1;
                    float y0;
                    float x0;
                    float level = st.mUseLevel ? (float)this.getLevel() / 10000.0f : 1.0f;
                    switch (1.$SwitchMap$android$graphics$drawable$GradientDrawable$Orientation[st.mOrientation.ordinal()]) {
                        case 1: {
                            x0 = r.left;
                            y0 = r.top;
                            x1 = x0;
                            y1 = level * r.bottom;
                            break;
                        }
                        case 2: {
                            x0 = r.right;
                            y0 = r.top;
                            x1 = level * r.left;
                            y1 = level * r.bottom;
                            break;
                        }
                        case 3: {
                            x0 = r.right;
                            y0 = r.top;
                            x1 = level * r.left;
                            y1 = y0;
                            break;
                        }
                        case 4: {
                            x0 = r.right;
                            y0 = r.bottom;
                            x1 = level * r.left;
                            y1 = level * r.top;
                            break;
                        }
                        case 5: {
                            x0 = r.left;
                            y0 = r.bottom;
                            x1 = x0;
                            y1 = level * r.top;
                            break;
                        }
                        case 6: {
                            x0 = r.left;
                            y0 = r.bottom;
                            x1 = level * r.right;
                            y1 = level * r.top;
                            break;
                        }
                        case 7: {
                            x0 = r.left;
                            y0 = r.top;
                            x1 = level * r.right;
                            y1 = y0;
                            break;
                        }
                        default: {
                            x0 = r.left;
                            y0 = r.top;
                            x1 = level * r.right;
                            y1 = level * r.bottom;
                        }
                    }
                    this.mFillPaint.setShader(new LinearGradient(x0, y0, x1, y1, colors, st.mPositions, Shader.TileMode.CLAMP));
                } else if (st.mGradient == 1) {
                    float x0 = r.left + (r.right - r.left) * st.mCenterX;
                    float y0 = r.top + (r.bottom - r.top) * st.mCenterY;
                    float radius = st.mGradientRadius;
                    if (st.mGradientRadiusType == 1) {
                        radius *= (float)Math.min(st.mWidth, st.mHeight);
                    } else if (st.mGradientRadiusType == 2) {
                        radius *= Math.min(r.width(), r.height());
                    }
                    if (st.mUseLevel) {
                        radius *= (float)this.getLevel() / 10000.0f;
                    }
                    this.mGradientRadius = radius;
                    if (radius == 0.0f) {
                        radius = 0.001f;
                    }
                    this.mFillPaint.setShader(new RadialGradient(x0, y0, radius, colors, null, Shader.TileMode.CLAMP));
                } else if (st.mGradient == 2) {
                    float x0 = r.left + (r.right - r.left) * st.mCenterX;
                    float y0 = r.top + (r.bottom - r.top) * st.mCenterY;
                    int[] tempColors = colors;
                    float[] tempPositions = null;
                    if (st.mUseLevel) {
                        tempColors = st.mTempColors;
                        int length = colors.length;
                        if (tempColors == null || tempColors.length != length + 1) {
                            st.mTempColors = new int[length + 1];
                            tempColors = st.mTempColors;
                        }
                        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])colors, (int)0, (int[])tempColors, (int)0, (int)length);
                        tempColors[length] = colors[length - 1];
                        tempPositions = st.mTempPositions;
                        float fraction2 = 1.0f / (float)(length - 1);
                        if (tempPositions == null || tempPositions.length != length + 1) {
                            tempPositions = st.mTempPositions = new float[length + 1];
                        }
                        float level = (float)this.getLevel() / 10000.0f;
                        for (int i = 0; i < length; ++i) {
                            tempPositions[i] = (float)i * fraction2 * level;
                        }
                        tempPositions[length] = 1.0f;
                    }
                    this.mFillPaint.setShader(new SweepGradient(x0, y0, tempColors, tempPositions));
                }
                if (st.mColorStateList == null) {
                    this.mFillPaint.setColor(-16777216);
                }
            }
        }
        return !this.mRect.isEmpty();
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = GradientDrawable.obtainAttributes(r, theme, attrs, R.styleable.GradientDrawable);
        super.inflateWithAttributes(r, parser, a, 1);
        this.updateStateFromTypedArray(a);
        a.recycle();
        this.inflateChildElements(r, parser, attrs, theme);
        this.mGradientState.computeOpacity();
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        GradientState state = this.mGradientState;
        if (state == null || state.mThemeAttrs == null) {
            return;
        }
        TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.GradientDrawable);
        this.updateStateFromTypedArray(a);
        a.recycle();
        this.applyThemeChildElements(t);
        state.computeOpacity();
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$updateStateFromTypedArray(TypedArray a) {
        GradientState state = this.mGradientState;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mThemeAttrs = a.extractThemeAttrs();
        state.mShape = a.getInt(2, state.mShape);
        state.mDither = a.getBoolean(0, state.mDither);
        if (state.mShape == 3) {
            state.mInnerRadius = a.getDimensionPixelSize(6, state.mInnerRadius);
            if (state.mInnerRadius == -1) {
                state.mInnerRadiusRatio = a.getFloat(3, state.mInnerRadiusRatio);
            }
            state.mThickness = a.getDimensionPixelSize(7, state.mThickness);
            if (state.mThickness == -1) {
                state.mThicknessRatio = a.getFloat(4, state.mThicknessRatio);
            }
            state.mUseLevelForShape = a.getBoolean(5, state.mUseLevelForShape);
        }
    }

    private final boolean $$robo$$android_graphics_drawable_GradientDrawable$canApplyTheme() {
        GradientState st = this.mGradientState;
        return st != null && (st.mThemeAttrs != null || st.mAttrSize != null || st.mAttrGradient != null || st.mAttrSolid != null || st.mAttrStroke != null || st.mAttrCorners != null || st.mAttrPadding != null);
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$applyThemeChildElements(Resources.Theme t) {
        TypedArray a;
        GradientState st = this.mGradientState;
        if (st.mAttrSize != null) {
            a = t.resolveAttributes(st.mAttrSize, R.styleable.GradientDrawableSize);
            this.updateGradientDrawableSize(a);
            a.recycle();
        }
        if (st.mAttrGradient != null) {
            a = t.resolveAttributes(st.mAttrGradient, R.styleable.GradientDrawableGradient);
            try {
                this.updateGradientDrawableGradient(t.getResources(), a);
            }
            catch (XmlPullParserException e) {
                throw new RuntimeException(e);
            }
            finally {
                a.recycle();
            }
        }
        if (st.mAttrSolid != null) {
            a = t.resolveAttributes(st.mAttrSolid, R.styleable.GradientDrawableSolid);
            this.updateGradientDrawableSolid(a);
            a.recycle();
        }
        if (st.mAttrStroke != null) {
            a = t.resolveAttributes(st.mAttrStroke, R.styleable.GradientDrawableStroke);
            this.updateGradientDrawableStroke(a);
            a.recycle();
        }
        if (st.mAttrCorners != null) {
            a = t.resolveAttributes(st.mAttrCorners, R.styleable.DrawableCorners);
            this.updateDrawableCorners(a);
            a.recycle();
        }
        if (st.mAttrPadding != null) {
            a = t.resolveAttributes(st.mAttrPadding, R.styleable.GradientDrawablePadding);
            this.updateGradientDrawablePadding(a);
            a.recycle();
        }
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$inflateChildElements(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            TypedArray a;
            if (type != 2 || depth > innerDepth) continue;
            String name = parser.getName();
            if (name.equals("size")) {
                a = GradientDrawable.obtainAttributes(r, theme, attrs, R.styleable.GradientDrawableSize);
                this.updateGradientDrawableSize(a);
                a.recycle();
                continue;
            }
            if (name.equals("gradient")) {
                a = GradientDrawable.obtainAttributes(r, theme, attrs, R.styleable.GradientDrawableGradient);
                this.updateGradientDrawableGradient(r, a);
                a.recycle();
                continue;
            }
            if (name.equals("solid")) {
                a = GradientDrawable.obtainAttributes(r, theme, attrs, R.styleable.GradientDrawableSolid);
                this.updateGradientDrawableSolid(a);
                a.recycle();
                continue;
            }
            if (name.equals("stroke")) {
                a = GradientDrawable.obtainAttributes(r, theme, attrs, R.styleable.GradientDrawableStroke);
                this.updateGradientDrawableStroke(a);
                a.recycle();
                continue;
            }
            if (name.equals("corners")) {
                a = GradientDrawable.obtainAttributes(r, theme, attrs, R.styleable.DrawableCorners);
                this.updateDrawableCorners(a);
                a.recycle();
                continue;
            }
            if (name.equals("padding")) {
                a = GradientDrawable.obtainAttributes(r, theme, attrs, R.styleable.GradientDrawablePadding);
                this.updateGradientDrawablePadding(a);
                a.recycle();
                continue;
            }
            Log.w("drawable", "Bad element under <shape>: " + name);
        }
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$updateGradientDrawablePadding(TypedArray a) {
        GradientState st = this.mGradientState;
        st.mChangingConfigurations |= a.getChangingConfigurations();
        st.mAttrPadding = a.extractThemeAttrs();
        if (st.mPadding == null) {
            st.mPadding = new Rect();
        }
        Rect pad = st.mPadding;
        pad.set(a.getDimensionPixelOffset(0, pad.left), a.getDimensionPixelOffset(1, pad.top), a.getDimensionPixelOffset(2, pad.right), a.getDimensionPixelOffset(3, pad.bottom));
        this.mPadding = pad;
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$updateDrawableCorners(TypedArray a) {
        GradientState st = this.mGradientState;
        st.mChangingConfigurations |= a.getChangingConfigurations();
        st.mAttrCorners = a.extractThemeAttrs();
        int radius = a.getDimensionPixelSize(0, (int)st.mRadius);
        this.setCornerRadius(radius);
        int topLeftRadius = a.getDimensionPixelSize(1, radius);
        int topRightRadius = a.getDimensionPixelSize(2, radius);
        int bottomLeftRadius = a.getDimensionPixelSize(3, radius);
        int bottomRightRadius = a.getDimensionPixelSize(4, radius);
        if (topLeftRadius != radius || topRightRadius != radius || bottomLeftRadius != radius || bottomRightRadius != radius) {
            this.setCornerRadii(new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomRightRadius, bottomRightRadius, bottomLeftRadius, bottomLeftRadius});
        }
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$updateGradientDrawableStroke(TypedArray a) {
        GradientState st = this.mGradientState;
        st.mChangingConfigurations |= a.getChangingConfigurations();
        st.mAttrStroke = a.extractThemeAttrs();
        int defaultStrokeWidth = Math.max(0, st.mStrokeWidth);
        int width = a.getDimensionPixelSize(0, defaultStrokeWidth);
        float dashWidth = a.getDimension(2, st.mStrokeDashWidth);
        ColorStateList colorStateList = a.getColorStateList(1);
        if (colorStateList == null) {
            colorStateList = st.mStrokeColorStateList;
        }
        if (dashWidth != 0.0f) {
            float dashGap = a.getDimension(3, st.mStrokeDashGap);
            this.setStroke(width, colorStateList, dashWidth, dashGap);
        } else {
            this.setStroke(width, colorStateList);
        }
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$updateGradientDrawableSolid(TypedArray a) {
        GradientState st = this.mGradientState;
        st.mChangingConfigurations |= a.getChangingConfigurations();
        st.mAttrSolid = a.extractThemeAttrs();
        ColorStateList colorStateList = a.getColorStateList(0);
        if (colorStateList != null) {
            this.setColor(colorStateList);
        }
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$updateGradientDrawableGradient(Resources r, TypedArray a) throws XmlPullParserException {
        GradientState st = this.mGradientState;
        st.mChangingConfigurations |= a.getChangingConfigurations();
        st.mAttrGradient = a.extractThemeAttrs();
        st.mCenterX = GradientDrawable.getFloatOrFraction(a, 5, st.mCenterX);
        st.mCenterY = GradientDrawable.getFloatOrFraction(a, 6, st.mCenterY);
        st.mUseLevel = a.getBoolean(2, st.mUseLevel);
        st.mGradient = a.getInt(4, st.mGradient);
        int startColor = a.getColor(0, 0);
        boolean hasCenterColor = a.hasValue(8);
        int centerColor = a.getColor(8, 0);
        int endColor = a.getColor(1, 0);
        if (hasCenterColor) {
            st.mColors = new int[3];
            st.mColors[0] = startColor;
            st.mColors[1] = centerColor;
            st.mColors[2] = endColor;
            st.mPositions = new float[3];
            st.mPositions[0] = 0.0f;
            st.mPositions[1] = st.mCenterX != 0.5f ? st.mCenterX : st.mCenterY;
            st.mPositions[2] = 1.0f;
        } else {
            st.mColors = new int[2];
            st.mColors[0] = startColor;
            st.mColors[1] = endColor;
        }
        if (st.mGradient == 0) {
            int angle = (int)a.getFloat(3, st.mAngle);
            if ((angle %= 360) % 45 != 0) {
                throw new XmlPullParserException(a.getPositionDescription() + "<gradient> tag requires 'angle' attribute to " + "be a multiple of 45");
            }
            st.mAngle = angle;
            switch (angle) {
                case 0: {
                    st.mOrientation = Orientation.LEFT_RIGHT;
                    break;
                }
                case 45: {
                    st.mOrientation = Orientation.BL_TR;
                    break;
                }
                case 90: {
                    st.mOrientation = Orientation.BOTTOM_TOP;
                    break;
                }
                case 135: {
                    st.mOrientation = Orientation.BR_TL;
                    break;
                }
                case 180: {
                    st.mOrientation = Orientation.RIGHT_LEFT;
                    break;
                }
                case 225: {
                    st.mOrientation = Orientation.TR_BL;
                    break;
                }
                case 270: {
                    st.mOrientation = Orientation.TOP_BOTTOM;
                    break;
                }
                case 315: {
                    st.mOrientation = Orientation.TL_BR;
                }
            }
        } else {
            TypedValue tv = a.peekValue(7);
            if (tv != null) {
                int radiusType;
                float radius;
                if (tv.type == 6) {
                    radius = tv.getFraction(1.0f, 1.0f);
                    int unit = tv.data >> 0 & 0xF;
                    radiusType = unit == 1 ? 2 : 1;
                } else {
                    radius = tv.getDimension(r.getDisplayMetrics());
                    radiusType = 0;
                }
                st.mGradientRadius = radius;
                st.mGradientRadiusType = radiusType;
            } else if (st.mGradient == 1) {
                throw new XmlPullParserException(a.getPositionDescription() + "<gradient> tag requires 'gradientRadius' " + "attribute with radial type");
            }
        }
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$updateGradientDrawableSize(TypedArray a) {
        GradientState st = this.mGradientState;
        st.mChangingConfigurations |= a.getChangingConfigurations();
        st.mAttrSize = a.extractThemeAttrs();
        st.mWidth = a.getDimensionPixelSize(1, st.mWidth);
        st.mHeight = a.getDimensionPixelSize(0, st.mHeight);
    }

    private static final float $$robo$$android_graphics_drawable_GradientDrawable$getFloatOrFraction(TypedArray a, int index, float defaultValue) {
        TypedValue tv = a.peekValue(index);
        float v = defaultValue;
        if (tv != null) {
            boolean vIsFraction = tv.type == 6;
            v = vIsFraction ? tv.getFraction(1.0f, 1.0f) : tv.getFloat();
        }
        return v;
    }

    private final int $$robo$$android_graphics_drawable_GradientDrawable$getIntrinsicWidth() {
        return this.mGradientState.mWidth;
    }

    private final int $$robo$$android_graphics_drawable_GradientDrawable$getIntrinsicHeight() {
        return this.mGradientState.mHeight;
    }

    private final Drawable.ConstantState $$robo$$android_graphics_drawable_GradientDrawable$getConstantState() {
        this.mGradientState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mGradientState;
    }

    private final boolean $$robo$$android_graphics_drawable_GradientDrawable$isOpaqueForState() {
        if (this.mGradientState.mStrokeWidth >= 0 && this.mStrokePaint != null && !GradientDrawable.isOpaque(this.mStrokePaint.getColor())) {
            return false;
        }
        return GradientDrawable.isOpaque(this.mFillPaint.getColor());
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$getOutline(Outline outline) {
        GradientState st = this.mGradientState;
        Rect bounds = this.getBounds();
        outline.setAlpha(st.mOpaqueOverShape && this.isOpaqueForState() ? (float)this.mAlpha / 255.0f : 0.0f);
        switch (st.mShape) {
            case 0: {
                if (st.mRadiusArray != null) {
                    this.buildPathIfDirty();
                    outline.setConvexPath(this.mPath);
                    return;
                }
                float rad = 0.0f;
                if (st.mRadius > 0.0f) {
                    rad = Math.min(st.mRadius, (float)Math.min(bounds.width(), bounds.height()) * 0.5f);
                }
                outline.setRoundRect(bounds, rad);
                return;
            }
            case 1: {
                outline.setOval(bounds);
                return;
            }
            case 2: {
                float halfStrokeWidth = this.mStrokePaint == null ? 1.0E-4f : this.mStrokePaint.getStrokeWidth() * 0.5f;
                float centerY = bounds.centerY();
                int top = (int)Math.floor(centerY - halfStrokeWidth);
                int bottom = (int)Math.ceil(centerY + halfStrokeWidth);
                outline.setRect(bounds.left, top, bounds.right, bottom);
                return;
            }
        }
    }

    private final Drawable $$robo$$android_graphics_drawable_GradientDrawable$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mGradientState = new GradientState(this.mGradientState);
            this.initializeWithState(this.mGradientState);
            this.mMutated = true;
        }
        return this;
    }

    private static final boolean $$robo$$android_graphics_drawable_GradientDrawable$isOpaque(int color2) {
        return (color2 >> 24 & 0xFF) == 255;
    }

    private void $$robo$$android_graphics_drawable_GradientDrawable$__constructor__(GradientState state, Resources.Theme theme) {
        this.mFillPaint = new Paint(1);
        this.mAlpha = 255;
        this.mPath = new Path();
        this.mRect = new RectF();
        this.mPathIsDirty = true;
        if (theme != null && state.canApplyTheme()) {
            this.mGradientState = new GradientState(state);
            this.applyTheme(theme);
        } else {
            this.mGradientState = state;
        }
        this.initializeWithState(state);
        this.mGradientIsDirty = true;
        this.mMutated = false;
    }

    private final void $$robo$$android_graphics_drawable_GradientDrawable$initializeWithState(GradientState state) {
        int[] currentState;
        if (state.mColorStateList != null) {
            currentState = this.getState();
            int stateColor = state.mColorStateList.getColorForState(currentState, 0);
            this.mFillPaint.setColor(stateColor);
        } else if (state.mColors == null) {
            this.mFillPaint.setColor(0);
        } else {
            this.mFillPaint.setColor(-16777216);
        }
        this.mPadding = state.mPadding;
        if (state.mStrokeWidth >= 0) {
            this.mStrokePaint = new Paint(1);
            this.mStrokePaint.setStyle(Paint.Style.STROKE);
            this.mStrokePaint.setStrokeWidth(state.mStrokeWidth);
            if (state.mStrokeColorStateList != null) {
                currentState = this.getState();
                int strokeStateColor = state.mStrokeColorStateList.getColorForState(currentState, 0);
                this.mStrokePaint.setColor(strokeStateColor);
            }
            if (state.mStrokeDashWidth != 0.0f) {
                DashPathEffect e = new DashPathEffect(new float[]{state.mStrokeDashWidth, state.mStrokeDashGap}, 0.0f);
                this.mStrokePaint.setPathEffect(e);
            }
        }
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_GradientDrawable$__constructor__(GradientState x0, Resources.Theme x1, 1 x2) {
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_GradientDrawable$__constructor__();
    }

    public GradientDrawable() {
        this(new GradientState(Orientation.TOP_BOTTOM, null), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_GradientDrawable$__constructor__(), 0, this);
    }

    private void __constructor__(Orientation orientation, int[] nArray) {
        this.$$robo$$android_graphics_drawable_GradientDrawable$__constructor__(orientation, nArray);
    }

    public GradientDrawable(Orientation orientation, int[] nArray) {
        this(new GradientState(orientation, nArray), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_GradientDrawable$__constructor__(android.graphics.drawable.GradientDrawable$Orientation int[] ), 0, this, orientation, nArray);
    }

    @Override
    public boolean getPadding(Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getPadding", $$robo$$android_graphics_drawable_GradientDrawable$getPadding(android.graphics.Rect ), 0, this, rect);
    }

    public void setCornerRadii(float[] fArray) {
        InvokeDynamicSupport.bootstrap("setCornerRadii", $$robo$$android_graphics_drawable_GradientDrawable$setCornerRadii(float[] ), 0, this, fArray);
    }

    public void setCornerRadius(float f) {
        InvokeDynamicSupport.bootstrap("setCornerRadius", $$robo$$android_graphics_drawable_GradientDrawable$setCornerRadius(float ), 0, this, f);
    }

    public void setStroke(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setStroke", $$robo$$android_graphics_drawable_GradientDrawable$setStroke(int int ), 0, this, n, n2);
    }

    public void setStroke(int n, ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setStroke", $$robo$$android_graphics_drawable_GradientDrawable$setStroke(int android.content.res.ColorStateList ), 0, this, n, colorStateList);
    }

    public void setStroke(int n, int n2, float f, float f2) {
        InvokeDynamicSupport.bootstrap("setStroke", $$robo$$android_graphics_drawable_GradientDrawable$setStroke(int int float float ), 0, this, n, n2, f, f2);
    }

    public void setStroke(int n, ColorStateList colorStateList, float f, float f2) {
        InvokeDynamicSupport.bootstrap("setStroke", $$robo$$android_graphics_drawable_GradientDrawable$setStroke(int android.content.res.ColorStateList float float ), 0, this, n, colorStateList, f, f2);
    }

    private void setStrokeInternal(int n, int n2, float f, float f2) {
        InvokeDynamicSupport.bootstrap("setStrokeInternal", $$robo$$android_graphics_drawable_GradientDrawable$setStrokeInternal(int int float float ), 0, this, n, n2, f, f2);
    }

    public void setSize(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setSize", $$robo$$android_graphics_drawable_GradientDrawable$setSize(int int ), 0, this, n, n2);
    }

    public void setShape(int n) {
        InvokeDynamicSupport.bootstrap("setShape", $$robo$$android_graphics_drawable_GradientDrawable$setShape(int ), 0, this, n);
    }

    public void setGradientType(int n) {
        InvokeDynamicSupport.bootstrap("setGradientType", $$robo$$android_graphics_drawable_GradientDrawable$setGradientType(int ), 0, this, n);
    }

    public void setGradientCenter(float f, float f2) {
        InvokeDynamicSupport.bootstrap("setGradientCenter", $$robo$$android_graphics_drawable_GradientDrawable$setGradientCenter(float float ), 0, this, f, f2);
    }

    public void setGradientRadius(float f) {
        InvokeDynamicSupport.bootstrap("setGradientRadius", $$robo$$android_graphics_drawable_GradientDrawable$setGradientRadius(float ), 0, this, f);
    }

    public float getGradientRadius() {
        return (float)InvokeDynamicSupport.bootstrap("getGradientRadius", $$robo$$android_graphics_drawable_GradientDrawable$getGradientRadius(), 0, this);
    }

    public void setUseLevel(boolean bl) {
        InvokeDynamicSupport.bootstrap("setUseLevel", $$robo$$android_graphics_drawable_GradientDrawable$setUseLevel(boolean ), 0, this, bl);
    }

    private int modulateAlpha(int n) {
        return (int)InvokeDynamicSupport.bootstrap("modulateAlpha", $$robo$$android_graphics_drawable_GradientDrawable$modulateAlpha(int ), 0, this, n);
    }

    public Orientation getOrientation() {
        return InvokeDynamicSupport.bootstrap("getOrientation", $$robo$$android_graphics_drawable_GradientDrawable$getOrientation(), 0, this);
    }

    public void setOrientation(Orientation orientation) {
        InvokeDynamicSupport.bootstrap("setOrientation", $$robo$$android_graphics_drawable_GradientDrawable$setOrientation(android.graphics.drawable.GradientDrawable$Orientation ), 0, this, orientation);
    }

    public void setColors(int[] nArray) {
        InvokeDynamicSupport.bootstrap("setColors", $$robo$$android_graphics_drawable_GradientDrawable$setColors(int[] ), 0, this, nArray);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_GradientDrawable$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    private void buildPathIfDirty() {
        InvokeDynamicSupport.bootstrap("buildPathIfDirty", $$robo$$android_graphics_drawable_GradientDrawable$buildPathIfDirty(), 0, this);
    }

    private Path buildRing(GradientState gradientState) {
        return InvokeDynamicSupport.bootstrap("buildRing", $$robo$$android_graphics_drawable_GradientDrawable$buildRing(android.graphics.drawable.GradientDrawable$GradientState ), 0, this, gradientState);
    }

    public void setColor(int n) {
        InvokeDynamicSupport.bootstrap("setColor", $$robo$$android_graphics_drawable_GradientDrawable$setColor(int ), 0, this, n);
    }

    public void setColor(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setColor", $$robo$$android_graphics_drawable_GradientDrawable$setColor(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_GradientDrawable$onStateChange(int[] ), 0, this, nArray);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_GradientDrawable$isStateful(), 0, this);
    }

    @Override
    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_GradientDrawable$getChangingConfigurations(), 0, this);
    }

    @Override
    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_drawable_GradientDrawable$setAlpha(int ), 0, this, n);
    }

    @Override
    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_drawable_GradientDrawable$getAlpha(), 0, this);
    }

    @Override
    public void setDither(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDither", $$robo$$android_graphics_drawable_GradientDrawable$setDither(boolean ), 0, this, bl);
    }

    @Override
    public ColorFilter getColorFilter() {
        return InvokeDynamicSupport.bootstrap("getColorFilter", $$robo$$android_graphics_drawable_GradientDrawable$getColorFilter(), 0, this);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_graphics_drawable_GradientDrawable$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_GradientDrawable$getOpacity(), 0, this);
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        InvokeDynamicSupport.bootstrap("onBoundsChange", $$robo$$android_graphics_drawable_GradientDrawable$onBoundsChange(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    protected boolean onLevelChange(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLevelChange", $$robo$$android_graphics_drawable_GradientDrawable$onLevelChange(int ), 0, this, n);
    }

    private boolean ensureValidRect() {
        return (boolean)InvokeDynamicSupport.bootstrap("ensureValidRect", $$robo$$android_graphics_drawable_GradientDrawable$ensureValidRect(), 0, this);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_GradientDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_GradientDrawable$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
    }

    private void updateStateFromTypedArray(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_GradientDrawable$updateStateFromTypedArray(android.content.res.TypedArray ), 0, this, typedArray);
    }

    @Override
    public boolean canApplyTheme() {
        return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_GradientDrawable$canApplyTheme(), 0, this);
    }

    private void applyThemeChildElements(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyThemeChildElements", $$robo$$android_graphics_drawable_GradientDrawable$applyThemeChildElements(android.content.res.Resources$Theme ), 0, this, theme);
    }

    private void inflateChildElements(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflateChildElements", $$robo$$android_graphics_drawable_GradientDrawable$inflateChildElements(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    private void updateGradientDrawablePadding(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateGradientDrawablePadding", $$robo$$android_graphics_drawable_GradientDrawable$updateGradientDrawablePadding(android.content.res.TypedArray ), 0, this, typedArray);
    }

    private void updateDrawableCorners(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateDrawableCorners", $$robo$$android_graphics_drawable_GradientDrawable$updateDrawableCorners(android.content.res.TypedArray ), 0, this, typedArray);
    }

    private void updateGradientDrawableStroke(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateGradientDrawableStroke", $$robo$$android_graphics_drawable_GradientDrawable$updateGradientDrawableStroke(android.content.res.TypedArray ), 0, this, typedArray);
    }

    private void updateGradientDrawableSolid(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateGradientDrawableSolid", $$robo$$android_graphics_drawable_GradientDrawable$updateGradientDrawableSolid(android.content.res.TypedArray ), 0, this, typedArray);
    }

    private void updateGradientDrawableGradient(Resources resources, TypedArray typedArray) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("updateGradientDrawableGradient", $$robo$$android_graphics_drawable_GradientDrawable$updateGradientDrawableGradient(android.content.res.Resources android.content.res.TypedArray ), 0, this, resources, typedArray);
    }

    private void updateGradientDrawableSize(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateGradientDrawableSize", $$robo$$android_graphics_drawable_GradientDrawable$updateGradientDrawableSize(android.content.res.TypedArray ), 0, this, typedArray);
    }

    private static float getFloatOrFraction(TypedArray typedArray, int n, float f) {
        return (float)InvokeDynamicSupport.bootstrapStatic("getFloatOrFraction", $$robo$$android_graphics_drawable_GradientDrawable$getFloatOrFraction(android.content.res.TypedArray int float ), 0, (TypedArray)typedArray, (int)n, (float)f);
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicWidth", $$robo$$android_graphics_drawable_GradientDrawable$getIntrinsicWidth(), 0, this);
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicHeight", $$robo$$android_graphics_drawable_GradientDrawable$getIntrinsicHeight(), 0, this);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_graphics_drawable_GradientDrawable$getConstantState(), 0, this);
    }

    private boolean isOpaqueForState() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOpaqueForState", $$robo$$android_graphics_drawable_GradientDrawable$isOpaqueForState(), 0, this);
    }

    @Override
    public void getOutline(Outline outline) {
        InvokeDynamicSupport.bootstrap("getOutline", $$robo$$android_graphics_drawable_GradientDrawable$getOutline(android.graphics.Outline ), 0, this, outline);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_GradientDrawable$mutate(), 0, this);
    }

    static boolean isOpaque(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isOpaque", $$robo$$android_graphics_drawable_GradientDrawable$isOpaque(int ), 0, (int)n);
    }

    private void __constructor__(GradientState gradientState, Resources.Theme theme) {
        this.$$robo$$android_graphics_drawable_GradientDrawable$__constructor__(gradientState, theme);
    }

    private GradientDrawable(GradientState gradientState, Resources.Theme theme) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_GradientDrawable$__constructor__(android.graphics.drawable.GradientDrawable$GradientState android.content.res.Resources$Theme ), 0, this, gradientState, theme);
    }

    private void initializeWithState(GradientState gradientState) {
        InvokeDynamicSupport.bootstrap("initializeWithState", $$robo$$android_graphics_drawable_GradientDrawable$initializeWithState(android.graphics.drawable.GradientDrawable$GradientState ), 0, this, gradientState);
    }

    private /* synthetic */ void __constructor__(GradientState gradientState, Resources.Theme theme, 1 var3_3) {
        this.$$robo$$android_graphics_drawable_GradientDrawable$__constructor__(gradientState, theme, var3_3);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GradientDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class GradientState
    extends Drawable.ConstantState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int mChangingConfigurations;
        public int mShape;
        public int mGradient;
        public int mAngle;
        public Orientation mOrientation;
        public ColorStateList mColorStateList;
        public ColorStateList mStrokeColorStateList;
        public int[] mColors;
        public int[] mTempColors;
        public float[] mTempPositions;
        public float[] mPositions;
        public int mStrokeWidth;
        public float mStrokeDashWidth;
        public float mStrokeDashGap;
        public float mRadius;
        public float[] mRadiusArray;
        public Rect mPadding;
        public int mWidth;
        public int mHeight;
        public float mInnerRadiusRatio;
        public float mThicknessRatio;
        public int mInnerRadius;
        public int mThickness;
        public boolean mDither;
        private float mCenterX;
        private float mCenterY;
        private float mGradientRadius;
        private int mGradientRadiusType;
        private boolean mUseLevel;
        private boolean mUseLevelForShape;
        private boolean mOpaqueOverBounds;
        private boolean mOpaqueOverShape;
        int[] mThemeAttrs;
        int[] mAttrSize;
        int[] mAttrGradient;
        int[] mAttrSolid;
        int[] mAttrStroke;
        int[] mAttrCorners;
        int[] mAttrPadding;

        private void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$__constructor__(Orientation orientation, int[] colors) {
            this.mShape = 0;
            this.mGradient = 0;
            this.mAngle = 0;
            this.mStrokeWidth = -1;
            this.mStrokeDashWidth = 0.0f;
            this.mStrokeDashGap = 0.0f;
            this.mRadius = 0.0f;
            this.mRadiusArray = null;
            this.mPadding = null;
            this.mWidth = -1;
            this.mHeight = -1;
            this.mInnerRadiusRatio = 3.0f;
            this.mThicknessRatio = 9.0f;
            this.mInnerRadius = -1;
            this.mThickness = -1;
            this.mDither = false;
            this.mCenterX = 0.5f;
            this.mCenterY = 0.5f;
            this.mGradientRadius = 0.5f;
            this.mGradientRadiusType = 0;
            this.mOrientation = orientation;
            this.setColors(colors);
        }

        private void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$__constructor__(GradientState state) {
            this.mShape = 0;
            this.mGradient = 0;
            this.mAngle = 0;
            this.mStrokeWidth = -1;
            this.mStrokeDashWidth = 0.0f;
            this.mStrokeDashGap = 0.0f;
            this.mRadius = 0.0f;
            this.mRadiusArray = null;
            this.mPadding = null;
            this.mWidth = -1;
            this.mHeight = -1;
            this.mInnerRadiusRatio = 3.0f;
            this.mThicknessRatio = 9.0f;
            this.mInnerRadius = -1;
            this.mThickness = -1;
            this.mDither = false;
            this.mCenterX = 0.5f;
            this.mCenterY = 0.5f;
            this.mGradientRadius = 0.5f;
            this.mGradientRadiusType = 0;
            this.mChangingConfigurations = state.mChangingConfigurations;
            this.mShape = state.mShape;
            this.mGradient = state.mGradient;
            this.mAngle = state.mAngle;
            this.mOrientation = state.mOrientation;
            this.mColorStateList = state.mColorStateList;
            if (state.mColors != null) {
                this.mColors = (int[])state.mColors.clone();
            }
            if (state.mPositions != null) {
                this.mPositions = (float[])state.mPositions.clone();
            }
            this.mStrokeColorStateList = state.mStrokeColorStateList;
            this.mStrokeWidth = state.mStrokeWidth;
            this.mStrokeDashWidth = state.mStrokeDashWidth;
            this.mStrokeDashGap = state.mStrokeDashGap;
            this.mRadius = state.mRadius;
            if (state.mRadiusArray != null) {
                this.mRadiusArray = (float[])state.mRadiusArray.clone();
            }
            if (state.mPadding != null) {
                this.mPadding = new Rect(state.mPadding);
            }
            this.mWidth = state.mWidth;
            this.mHeight = state.mHeight;
            this.mInnerRadiusRatio = state.mInnerRadiusRatio;
            this.mThicknessRatio = state.mThicknessRatio;
            this.mInnerRadius = state.mInnerRadius;
            this.mThickness = state.mThickness;
            this.mDither = state.mDither;
            this.mCenterX = state.mCenterX;
            this.mCenterY = state.mCenterY;
            this.mGradientRadius = state.mGradientRadius;
            this.mGradientRadiusType = state.mGradientRadiusType;
            this.mUseLevel = state.mUseLevel;
            this.mUseLevelForShape = state.mUseLevelForShape;
            this.mOpaqueOverBounds = state.mOpaqueOverBounds;
            this.mOpaqueOverShape = state.mOpaqueOverShape;
            this.mThemeAttrs = state.mThemeAttrs;
            this.mAttrSize = state.mAttrSize;
            this.mAttrGradient = state.mAttrGradient;
            this.mAttrSolid = state.mAttrSolid;
            this.mAttrStroke = state.mAttrStroke;
            this.mAttrCorners = state.mAttrCorners;
            this.mAttrPadding = state.mAttrPadding;
        }

        private final boolean $$robo$$android_graphics_drawable_GradientDrawable_GradientState$canApplyTheme() {
            return this.mThemeAttrs != null;
        }

        private final Drawable $$robo$$android_graphics_drawable_GradientDrawable_GradientState$newDrawable() {
            return new GradientDrawable(this, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_GradientDrawable_GradientState$newDrawable(Resources res) {
            return new GradientDrawable(this, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_GradientDrawable_GradientState$newDrawable(Resources res, Resources.Theme theme) {
            return new GradientDrawable(this, theme);
        }

        private final int $$robo$$android_graphics_drawable_GradientDrawable_GradientState$getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        private final void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setShape(int shape) {
            this.mShape = shape;
            this.computeOpacity();
        }

        private final void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setGradientType(int gradient) {
            this.mGradient = gradient;
        }

        private final void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setGradientCenter(float x, float y) {
            this.mCenterX = x;
            this.mCenterY = y;
        }

        private final void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setColors(int[] colors) {
            this.mColors = colors;
            this.mColorStateList = null;
            this.computeOpacity();
        }

        private final void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setColorStateList(ColorStateList colorStateList) {
            this.mColors = null;
            this.mColorStateList = colorStateList;
            this.computeOpacity();
        }

        private final void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$computeOpacity() {
            this.mOpaqueOverBounds = false;
            this.mOpaqueOverShape = false;
            if (this.mColors != null) {
                for (int i = 0; i < this.mColors.length; ++i) {
                    if (GradientDrawable.isOpaque(this.mColors[i])) continue;
                    return;
                }
            }
            if (this.mColors == null && this.mColorStateList == null) {
                return;
            }
            this.mOpaqueOverShape = true;
            this.mOpaqueOverBounds = this.mShape == 0 && this.mRadius <= 0.0f && this.mRadiusArray == null;
        }

        private final void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setStroke(int width, ColorStateList colorStateList, float dashWidth, float dashGap) {
            this.mStrokeWidth = width;
            this.mStrokeColorStateList = colorStateList;
            this.mStrokeDashWidth = dashWidth;
            this.mStrokeDashGap = dashGap;
            this.computeOpacity();
        }

        private final void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setCornerRadius(float radius) {
            if (radius < 0.0f) {
                radius = 0.0f;
            }
            this.mRadius = radius;
            this.mRadiusArray = null;
        }

        private final void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setCornerRadii(float[] radii) {
            this.mRadiusArray = radii;
            if (radii == null) {
                this.mRadius = 0.0f;
            }
        }

        private final void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setSize(int width, int height) {
            this.mWidth = width;
            this.mHeight = height;
        }

        private final void $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setGradientRadius(float gradientRadius, int type) {
            this.mGradientRadius = gradientRadius;
            this.mGradientRadiusType = type;
        }

        private void __constructor__(Orientation orientation, int[] nArray) {
            this.$$robo$$android_graphics_drawable_GradientDrawable_GradientState$__constructor__(orientation, nArray);
        }

        GradientState(Orientation orientation, int[] nArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$__constructor__(android.graphics.drawable.GradientDrawable$Orientation int[] ), 0, this, orientation, nArray);
        }

        private void __constructor__(GradientState gradientState) {
            this.$$robo$$android_graphics_drawable_GradientDrawable_GradientState$__constructor__(gradientState);
        }

        public GradientState(GradientState gradientState) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$__constructor__(android.graphics.drawable.GradientDrawable$GradientState ), 0, this, gradientState);
        }

        @Override
        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$canApplyTheme(), 0, this);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$newDrawable(), 0, this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        @Override
        public Drawable newDrawable(Resources resources, Resources.Theme theme) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$newDrawable(android.content.res.Resources android.content.res.Resources$Theme ), 0, this, resources, theme);
        }

        @Override
        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$getChangingConfigurations(), 0, this);
        }

        public void setShape(int n) {
            InvokeDynamicSupport.bootstrap("setShape", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setShape(int ), 0, this, n);
        }

        public void setGradientType(int n) {
            InvokeDynamicSupport.bootstrap("setGradientType", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setGradientType(int ), 0, this, n);
        }

        public void setGradientCenter(float f, float f2) {
            InvokeDynamicSupport.bootstrap("setGradientCenter", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setGradientCenter(float float ), 0, this, f, f2);
        }

        public void setColors(int[] nArray) {
            InvokeDynamicSupport.bootstrap("setColors", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setColors(int[] ), 0, this, nArray);
        }

        public void setColorStateList(ColorStateList colorStateList) {
            InvokeDynamicSupport.bootstrap("setColorStateList", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setColorStateList(android.content.res.ColorStateList ), 0, this, colorStateList);
        }

        private void computeOpacity() {
            InvokeDynamicSupport.bootstrap("computeOpacity", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$computeOpacity(), 0, this);
        }

        public void setStroke(int n, ColorStateList colorStateList, float f, float f2) {
            InvokeDynamicSupport.bootstrap("setStroke", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setStroke(int android.content.res.ColorStateList float float ), 0, this, n, colorStateList, f, f2);
        }

        public void setCornerRadius(float f) {
            InvokeDynamicSupport.bootstrap("setCornerRadius", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setCornerRadius(float ), 0, this, f);
        }

        public void setCornerRadii(float[] fArray) {
            InvokeDynamicSupport.bootstrap("setCornerRadii", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setCornerRadii(float[] ), 0, this, fArray);
        }

        public void setSize(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setSize", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setSize(int int ), 0, this, n, n2);
        }

        public void setGradientRadius(float f, int n) {
            InvokeDynamicSupport.bootstrap("setGradientRadius", $$robo$$android_graphics_drawable_GradientDrawable_GradientState$setGradientRadius(float int ), 0, this, f, n);
        }

        public /* synthetic */ GradientState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GradientState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Orientation
    extends Enum<Orientation> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Orientation TOP_BOTTOM;
        public static /* enum */ Orientation TR_BL;
        public static /* enum */ Orientation RIGHT_LEFT;
        public static /* enum */ Orientation BR_TL;
        public static /* enum */ Orientation BOTTOM_TOP;
        public static /* enum */ Orientation BL_TR;
        public static /* enum */ Orientation LEFT_RIGHT;
        public static /* enum */ Orientation TL_BR;
        private static /* synthetic */ Orientation[] $VALUES;

        private static final Orientation[] $$robo$$android_graphics_drawable_GradientDrawable_Orientation$values() {
            return (Orientation[])$VALUES.clone();
        }

        private static final Orientation $$robo$$android_graphics_drawable_GradientDrawable_Orientation$valueOf(String name) {
            return Enum.valueOf(Orientation.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_drawable_GradientDrawable_Orientation$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            TOP_BOTTOM = new Orientation();
            TR_BL = new Orientation();
            RIGHT_LEFT = new Orientation();
            BR_TL = new Orientation();
            BOTTOM_TOP = new Orientation();
            BL_TR = new Orientation();
            LEFT_RIGHT = new Orientation();
            TL_BR = new Orientation();
            $VALUES = new Orientation[]{TOP_BOTTOM, TR_BL, RIGHT_LEFT, BR_TL, BOTTOM_TOP, BL_TR, LEFT_RIGHT, TL_BR};
        }

        public static Orientation[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_drawable_GradientDrawable_Orientation$values(), 0);
        }

        public static Orientation valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_drawable_GradientDrawable_Orientation$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_graphics_drawable_GradientDrawable_Orientation$__constructor__(string2, n);
        }

        private Orientation() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_GradientDrawable_Orientation$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(Orientation.class);
        }

        public /* synthetic */ Orientation() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Orientation)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

