/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Insets;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class InsetDrawable
extends Drawable
implements Drawable.Callback,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Rect mTmpRect;
    private InsetState mInsetState;
    private boolean mMutated;

    private void $$robo$$android_graphics_drawable_InsetDrawable$__constructor__() {
    }

    private void $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(Drawable drawable2, int inset) {
    }

    private void $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(Drawable drawable2, int insetLeft, int insetTop, int insetRight, int insetBottom) {
        this.mInsetState.mDrawable = drawable2;
        this.mInsetState.mInsetLeft = insetLeft;
        this.mInsetState.mInsetTop = insetTop;
        this.mInsetState.mInsetRight = insetRight;
        this.mInsetState.mInsetBottom = insetBottom;
        if (drawable2 != null) {
            drawable2.setCallback(this);
        }
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = InsetDrawable.obtainAttributes(r, theme, attrs, R.styleable.InsetDrawable);
        super.inflateWithAttributes(r, parser, a, 0);
        this.mInsetState.mDrawable = null;
        this.updateStateFromTypedArray(a);
        if (this.mInsetState.mDrawable == null) {
            Drawable dr;
            int type;
            while ((type = parser.next()) == 4) {
            }
            if (type != 2) {
                throw new XmlPullParserException(parser.getPositionDescription() + ": <inset> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
            }
            this.mInsetState.mDrawable = dr = Drawable.createFromXmlInner(r, parser, attrs, theme);
            dr.setCallback(this);
        }
        this.verifyRequiredAttributes(a);
        a.recycle();
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$verifyRequiredAttributes(TypedArray a) throws XmlPullParserException {
        if (this.mInsetState.mDrawable == null && (this.mInsetState.mThemeAttrs == null || this.mInsetState.mThemeAttrs[1] == 0)) {
            throw new XmlPullParserException(a.getPositionDescription() + ": <inset> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
        }
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$updateStateFromTypedArray(TypedArray a) throws XmlPullParserException {
        InsetState state = this.mInsetState;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mThemeAttrs = a.extractThemeAttrs();
        int N = a.getIndexCount();
        block8: for (int i = 0; i < N; ++i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 1: {
                    Drawable dr = a.getDrawable(attr2);
                    if (dr == null) continue block8;
                    state.mDrawable = dr;
                    dr.setCallback(this);
                    continue block8;
                }
                case 6: {
                    int inset = a.getDimensionPixelOffset(attr2, Integer.MIN_VALUE);
                    if (inset == Integer.MIN_VALUE) continue block8;
                    state.mInsetLeft = inset;
                    state.mInsetTop = inset;
                    state.mInsetRight = inset;
                    state.mInsetBottom = inset;
                    continue block8;
                }
                case 2: {
                    state.mInsetLeft = a.getDimensionPixelOffset(attr2, state.mInsetLeft);
                    continue block8;
                }
                case 4: {
                    state.mInsetTop = a.getDimensionPixelOffset(attr2, state.mInsetTop);
                    continue block8;
                }
                case 3: {
                    state.mInsetRight = a.getDimensionPixelOffset(attr2, state.mInsetRight);
                    continue block8;
                }
                case 5: {
                    state.mInsetBottom = a.getDimensionPixelOffset(attr2, state.mInsetBottom);
                }
            }
        }
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        InsetState state = this.mInsetState;
        if (state == null || state.mThemeAttrs == null) {
            return;
        }
        TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.InsetDrawable);
        try {
            this.updateStateFromTypedArray(a);
            this.verifyRequiredAttributes(a);
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
        finally {
            a.recycle();
        }
    }

    private final boolean $$robo$$android_graphics_drawable_InsetDrawable$canApplyTheme() {
        return this.mInsetState != null && this.mInsetState.mThemeAttrs != null;
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$invalidateDrawable(Drawable who) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable(this);
        }
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$scheduleDrawable(Drawable who, Runnable what, long when) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable(this, what, when);
        }
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$unscheduleDrawable(Drawable who, Runnable what) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable(this, what);
        }
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$draw(Canvas canvas) {
        this.mInsetState.mDrawable.draw(canvas);
    }

    private final int $$robo$$android_graphics_drawable_InsetDrawable$getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mInsetState.mChangingConfigurations | this.mInsetState.mDrawable.getChangingConfigurations();
    }

    private final boolean $$robo$$android_graphics_drawable_InsetDrawable$getPadding(Rect padding) {
        boolean pad = this.mInsetState.mDrawable.getPadding(padding);
        padding.left += this.mInsetState.mInsetLeft;
        padding.right += this.mInsetState.mInsetRight;
        padding.top += this.mInsetState.mInsetTop;
        padding.bottom += this.mInsetState.mInsetBottom;
        return pad || (this.mInsetState.mInsetLeft | this.mInsetState.mInsetRight | this.mInsetState.mInsetTop | this.mInsetState.mInsetBottom) != 0;
    }

    private final Insets $$robo$$android_graphics_drawable_InsetDrawable$getOpticalInsets() {
        Insets contentInsets = super.getOpticalInsets();
        return Insets.of(contentInsets.left + this.mInsetState.mInsetLeft, contentInsets.top + this.mInsetState.mInsetTop, contentInsets.right + this.mInsetState.mInsetRight, contentInsets.bottom + this.mInsetState.mInsetBottom);
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$setHotspot(float x, float y) {
        this.mInsetState.mDrawable.setHotspot(x, y);
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$setHotspotBounds(int left, int top, int right, int bottom) {
        this.mInsetState.mDrawable.setHotspotBounds(left, top, right, bottom);
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$getHotspotBounds(Rect outRect) {
        this.mInsetState.mDrawable.getHotspotBounds(outRect);
    }

    private final boolean $$robo$$android_graphics_drawable_InsetDrawable$setVisible(boolean visible, boolean restart) {
        this.mInsetState.mDrawable.setVisible(visible, restart);
        return super.setVisible(visible, restart);
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$setAlpha(int alpha) {
        this.mInsetState.mDrawable.setAlpha(alpha);
    }

    private final int $$robo$$android_graphics_drawable_InsetDrawable$getAlpha() {
        return this.mInsetState.mDrawable.getAlpha();
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$setColorFilter(ColorFilter cf) {
        this.mInsetState.mDrawable.setColorFilter(cf);
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$setTintList(ColorStateList tint) {
        this.mInsetState.mDrawable.setTintList(tint);
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$setTintMode(PorterDuff.Mode tintMode) {
        this.mInsetState.mDrawable.setTintMode(tintMode);
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$setLayoutDirection(int layoutDirection) {
        this.mInsetState.mDrawable.setLayoutDirection(layoutDirection);
    }

    private final int $$robo$$android_graphics_drawable_InsetDrawable$getOpacity() {
        return this.mInsetState.mDrawable.getOpacity();
    }

    private final boolean $$robo$$android_graphics_drawable_InsetDrawable$isStateful() {
        return this.mInsetState.mDrawable.isStateful();
    }

    private final boolean $$robo$$android_graphics_drawable_InsetDrawable$onStateChange(int[] state) {
        boolean changed = this.mInsetState.mDrawable.setState(state);
        this.onBoundsChange(this.getBounds());
        return changed;
    }

    private final boolean $$robo$$android_graphics_drawable_InsetDrawable$onLevelChange(int level) {
        return this.mInsetState.mDrawable.setLevel(level);
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$onBoundsChange(Rect bounds) {
        Rect r = this.mTmpRect;
        r.set(bounds);
        r.left += this.mInsetState.mInsetLeft;
        r.top += this.mInsetState.mInsetTop;
        r.right -= this.mInsetState.mInsetRight;
        r.bottom -= this.mInsetState.mInsetBottom;
        this.mInsetState.mDrawable.setBounds(r.left, r.top, r.right, r.bottom);
    }

    private final int $$robo$$android_graphics_drawable_InsetDrawable$getIntrinsicWidth() {
        return this.mInsetState.mDrawable.getIntrinsicWidth();
    }

    private final int $$robo$$android_graphics_drawable_InsetDrawable$getIntrinsicHeight() {
        return this.mInsetState.mDrawable.getIntrinsicHeight();
    }

    private final void $$robo$$android_graphics_drawable_InsetDrawable$getOutline(Outline outline) {
        this.mInsetState.mDrawable.getOutline(outline);
    }

    private final Drawable.ConstantState $$robo$$android_graphics_drawable_InsetDrawable$getConstantState() {
        if (this.mInsetState.canConstantState()) {
            this.mInsetState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mInsetState;
        }
        return null;
    }

    private final Drawable $$robo$$android_graphics_drawable_InsetDrawable$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mInsetState.mDrawable.mutate();
            this.mMutated = true;
        }
        return this;
    }

    private final Drawable $$robo$$android_graphics_drawable_InsetDrawable$getDrawable() {
        return this.mInsetState.mDrawable;
    }

    private void $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(InsetState state, Resources res) {
        this.mTmpRect = new Rect();
        this.mInsetState = new InsetState(state, this, res);
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(InsetState x0, Resources x1, 1 x2) {
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_InsetDrawable$__constructor__();
    }

    InsetDrawable() {
        this(null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(), 0, this);
    }

    private void __constructor__(Drawable drawable2, int n) {
        this.$$robo$$android_graphics_drawable_InsetDrawable$__constructor__(drawable2, n);
    }

    public InsetDrawable(Drawable drawable2, int n) {
        this(drawable2, n, n, n, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(android.graphics.drawable.Drawable int ), 0, this, drawable2, n);
    }

    private void __constructor__(Drawable drawable2, int n, int n2, int n3, int n4) {
        this.$$robo$$android_graphics_drawable_InsetDrawable$__constructor__(drawable2, n, n2, n3, n4);
    }

    public InsetDrawable(Drawable drawable2, int n, int n2, int n3, int n4) {
        this(null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(android.graphics.drawable.Drawable int int int int ), 0, this, drawable2, n, n2, n3, n4);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_InsetDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    private void verifyRequiredAttributes(TypedArray typedArray) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("verifyRequiredAttributes", $$robo$$android_graphics_drawable_InsetDrawable$verifyRequiredAttributes(android.content.res.TypedArray ), 0, this, typedArray);
    }

    private void updateStateFromTypedArray(TypedArray typedArray) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_InsetDrawable$updateStateFromTypedArray(android.content.res.TypedArray ), 0, this, typedArray);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_InsetDrawable$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
    }

    @Override
    public boolean canApplyTheme() {
        return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_InsetDrawable$canApplyTheme(), 0, this);
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("invalidateDrawable", $$robo$$android_graphics_drawable_InsetDrawable$invalidateDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        InvokeDynamicSupport.bootstrap("scheduleDrawable", $$robo$$android_graphics_drawable_InsetDrawable$scheduleDrawable(android.graphics.drawable.Drawable java.lang.Runnable long ), 0, this, drawable2, runnable, l);
    }

    @Override
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        InvokeDynamicSupport.bootstrap("unscheduleDrawable", $$robo$$android_graphics_drawable_InsetDrawable$unscheduleDrawable(android.graphics.drawable.Drawable java.lang.Runnable ), 0, this, drawable2, runnable);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_InsetDrawable$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_InsetDrawable$getChangingConfigurations(), 0, this);
    }

    @Override
    public boolean getPadding(Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getPadding", $$robo$$android_graphics_drawable_InsetDrawable$getPadding(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public Insets getOpticalInsets() {
        return InvokeDynamicSupport.bootstrap("getOpticalInsets", $$robo$$android_graphics_drawable_InsetDrawable$getOpticalInsets(), 0, this);
    }

    @Override
    public void setHotspot(float f, float f2) {
        InvokeDynamicSupport.bootstrap("setHotspot", $$robo$$android_graphics_drawable_InsetDrawable$setHotspot(float float ), 0, this, f, f2);
    }

    @Override
    public void setHotspotBounds(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setHotspotBounds", $$robo$$android_graphics_drawable_InsetDrawable$setHotspotBounds(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void getHotspotBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("getHotspotBounds", $$robo$$android_graphics_drawable_InsetDrawable$getHotspotBounds(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setVisible", $$robo$$android_graphics_drawable_InsetDrawable$setVisible(boolean boolean ), 0, this, bl, bl2);
    }

    @Override
    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_drawable_InsetDrawable$setAlpha(int ), 0, this, n);
    }

    @Override
    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_drawable_InsetDrawable$getAlpha(), 0, this);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_graphics_drawable_InsetDrawable$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setTintList", $$robo$$android_graphics_drawable_InsetDrawable$setTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setTintMode", $$robo$$android_graphics_drawable_InsetDrawable$setTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    @Override
    public void setLayoutDirection(int n) {
        InvokeDynamicSupport.bootstrap("setLayoutDirection", $$robo$$android_graphics_drawable_InsetDrawable$setLayoutDirection(int ), 0, this, n);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_InsetDrawable$getOpacity(), 0, this);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_InsetDrawable$isStateful(), 0, this);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_InsetDrawable$onStateChange(int[] ), 0, this, nArray);
    }

    @Override
    protected boolean onLevelChange(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLevelChange", $$robo$$android_graphics_drawable_InsetDrawable$onLevelChange(int ), 0, this, n);
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        InvokeDynamicSupport.bootstrap("onBoundsChange", $$robo$$android_graphics_drawable_InsetDrawable$onBoundsChange(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicWidth", $$robo$$android_graphics_drawable_InsetDrawable$getIntrinsicWidth(), 0, this);
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicHeight", $$robo$$android_graphics_drawable_InsetDrawable$getIntrinsicHeight(), 0, this);
    }

    @Override
    public void getOutline(Outline outline) {
        InvokeDynamicSupport.bootstrap("getOutline", $$robo$$android_graphics_drawable_InsetDrawable$getOutline(android.graphics.Outline ), 0, this, outline);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_graphics_drawable_InsetDrawable$getConstantState(), 0, this);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_InsetDrawable$mutate(), 0, this);
    }

    public Drawable getDrawable() {
        return InvokeDynamicSupport.bootstrap("getDrawable", $$robo$$android_graphics_drawable_InsetDrawable$getDrawable(), 0, this);
    }

    private void __constructor__(InsetState insetState, Resources resources) {
        this.$$robo$$android_graphics_drawable_InsetDrawable$__constructor__(insetState, resources);
    }

    private InsetDrawable(InsetState insetState, Resources resources) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_InsetDrawable$__constructor__(android.graphics.drawable.InsetDrawable$InsetState android.content.res.Resources ), 0, this, insetState, resources);
    }

    private /* synthetic */ void __constructor__(InsetState insetState, Resources resources, 1 var3_3) {
        this.$$robo$$android_graphics_drawable_InsetDrawable$__constructor__(insetState, resources, var3_3);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InsetDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class InsetState
    extends Drawable.ConstantState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int[] mThemeAttrs;
        int mChangingConfigurations;
        Drawable mDrawable;
        int mInsetLeft;
        int mInsetTop;
        int mInsetRight;
        int mInsetBottom;
        boolean mCheckedConstantState;
        boolean mCanConstantState;

        private void $$robo$$android_graphics_drawable_InsetDrawable_InsetState$__constructor__(InsetState orig, InsetDrawable owner, Resources res) {
            if (orig != null) {
                this.mThemeAttrs = orig.mThemeAttrs;
                this.mChangingConfigurations = orig.mChangingConfigurations;
                this.mDrawable = res != null ? orig.mDrawable.getConstantState().newDrawable(res) : orig.mDrawable.getConstantState().newDrawable();
                this.mDrawable.setCallback(owner);
                this.mDrawable.setLayoutDirection(orig.mDrawable.getLayoutDirection());
                this.mDrawable.setBounds(orig.mDrawable.getBounds());
                this.mDrawable.setLevel(orig.mDrawable.getLevel());
                this.mInsetLeft = orig.mInsetLeft;
                this.mInsetTop = orig.mInsetTop;
                this.mInsetRight = orig.mInsetRight;
                this.mInsetBottom = orig.mInsetBottom;
                this.mCanConstantState = true;
                this.mCheckedConstantState = true;
            }
        }

        private final Drawable $$robo$$android_graphics_drawable_InsetDrawable_InsetState$newDrawable() {
            return new InsetDrawable(this, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_InsetDrawable_InsetState$newDrawable(Resources res) {
            return new InsetDrawable(this, res);
        }

        private final int $$robo$$android_graphics_drawable_InsetDrawable_InsetState$getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        private final boolean $$robo$$android_graphics_drawable_InsetDrawable_InsetState$canConstantState() {
            if (!this.mCheckedConstantState) {
                this.mCanConstantState = this.mDrawable.getConstantState() != null;
                this.mCheckedConstantState = true;
            }
            return this.mCanConstantState;
        }

        private void __constructor__(InsetState insetState, InsetDrawable insetDrawable, Resources resources) {
            this.$$robo$$android_graphics_drawable_InsetDrawable_InsetState$__constructor__(insetState, insetDrawable, resources);
        }

        InsetState(InsetState insetState, InsetDrawable insetDrawable, Resources resources) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_InsetDrawable_InsetState$__constructor__(android.graphics.drawable.InsetDrawable$InsetState android.graphics.drawable.InsetDrawable android.content.res.Resources ), 0, this, insetState, insetDrawable, resources);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_InsetDrawable_InsetState$newDrawable(), 0, this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_InsetDrawable_InsetState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        @Override
        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_InsetDrawable_InsetState$getChangingConfigurations(), 0, this);
        }

        boolean canConstantState() {
            return (boolean)InvokeDynamicSupport.bootstrap("canConstantState", $$robo$$android_graphics_drawable_InsetDrawable_InsetState$canConstantState(), 0, this);
        }

        public /* synthetic */ InsetState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InsetState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

