/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import com.android.internal.R;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LayerDrawable
extends Drawable
implements Drawable.Callback,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int PADDING_MODE_NEST = 0;
    public static int PADDING_MODE_STACK = 1;
    LayerState mLayerState;
    private int mOpacityOverride;
    private int[] mPaddingL;
    private int[] mPaddingT;
    private int[] mPaddingR;
    private int[] mPaddingB;
    private Rect mTmpRect;
    private Rect mHotspotBounds;
    private boolean mMutated;

    private void $$robo$$android_graphics_drawable_LayerDrawable$__constructor__(Drawable[] layers) {
    }

    private void $$robo$$android_graphics_drawable_LayerDrawable$__constructor__(Drawable[] layers, LayerState state) {
        int length = layers.length;
        ChildDrawable[] r = new ChildDrawable[length];
        for (int i = 0; i < length; ++i) {
            r[i] = new ChildDrawable();
            r[i].mDrawable = layers[i];
            layers[i].setCallback(this);
            this.mLayerState.mChildrenChangingConfigurations |= layers[i].getChangingConfigurations();
        }
        this.mLayerState.mNum = length;
        this.mLayerState.mChildren = r;
        this.ensurePadding();
    }

    private void $$robo$$android_graphics_drawable_LayerDrawable$__constructor__() {
    }

    private void $$robo$$android_graphics_drawable_LayerDrawable$__constructor__(LayerState state, Resources res, Resources.Theme theme) {
        LayerState as;
        this.mOpacityOverride = 0;
        this.mTmpRect = new Rect();
        this.mLayerState = as = this.createConstantState(state, res);
        if (as.mNum > 0) {
            this.ensurePadding();
        }
        if (theme != null && this.canApplyTheme()) {
            this.applyTheme(theme);
        }
    }

    private final LayerState $$robo$$android_graphics_drawable_LayerDrawable$createConstantState(LayerState state, Resources res) {
        return new LayerState(state, this, res);
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs, theme);
        TypedArray a = LayerDrawable.obtainAttributes(r, theme, attrs, R.styleable.LayerDrawable);
        this.updateStateFromTypedArray(a);
        a.recycle();
        this.inflateLayers(r, parser, attrs, theme);
        this.ensurePadding();
        this.onStateChange(this.getState());
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$updateStateFromTypedArray(TypedArray a) {
        LayerState state = this.mLayerState;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mThemeAttrs = a.extractThemeAttrs();
        this.mOpacityOverride = a.getInt(0, this.mOpacityOverride);
        state.mAutoMirrored = a.getBoolean(1, state.mAutoMirrored);
        state.mPaddingMode = a.getInteger(2, state.mPaddingMode);
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$inflateLayers(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        LayerState state = this.mLayerState;
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            if (type != 2 || depth > innerDepth || !parser.getName().equals("item")) continue;
            ChildDrawable layer = new ChildDrawable();
            TypedArray a = LayerDrawable.obtainAttributes(r, theme, attrs, R.styleable.LayerDrawableItem);
            this.updateLayerFromTypedArray(layer, a);
            a.recycle();
            if (layer.mDrawable == null) {
                while ((type = parser.next()) == 4) {
                }
                if (type != 2) {
                    throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
                }
                layer.mDrawable = Drawable.createFromXmlInner(r, parser, attrs, theme);
            }
            if (layer.mDrawable != null) {
                state.mChildrenChangingConfigurations |= layer.mDrawable.getChangingConfigurations();
                layer.mDrawable.setCallback(this);
            }
            this.addLayer(layer);
        }
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$updateLayerFromTypedArray(ChildDrawable layer, TypedArray a) {
        LayerState state = this.mLayerState;
        state.mChildrenChangingConfigurations |= a.getChangingConfigurations();
        layer.mThemeAttrs = a.extractThemeAttrs();
        layer.mInsetL = a.getDimensionPixelOffset(2, layer.mInsetL);
        layer.mInsetT = a.getDimensionPixelOffset(3, layer.mInsetT);
        layer.mInsetR = a.getDimensionPixelOffset(4, layer.mInsetR);
        layer.mInsetB = a.getDimensionPixelOffset(5, layer.mInsetB);
        layer.mId = a.getResourceId(0, layer.mId);
        Drawable dr = a.getDrawable(1);
        if (dr != null) {
            layer.mDrawable = dr;
        }
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        LayerState state = this.mLayerState;
        if (state == null) {
            return;
        }
        if (state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.LayerDrawable);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            Drawable d;
            ChildDrawable layer = array2[i];
            if (layer.mThemeAttrs != null) {
                TypedArray a = t.resolveAttributes(layer.mThemeAttrs, R.styleable.LayerDrawableItem);
                this.updateLayerFromTypedArray(layer, a);
                a.recycle();
            }
            if (!(d = layer.mDrawable).canApplyTheme()) continue;
            d.applyTheme(t);
        }
        this.ensurePadding();
        this.onStateChange(this.getState());
    }

    private final boolean $$robo$$android_graphics_drawable_LayerDrawable$canApplyTheme() {
        LayerState state = this.mLayerState;
        if (state == null) {
            return false;
        }
        if (state.mThemeAttrs != null) {
            return true;
        }
        ChildDrawable[] array2 = state.mChildren;
        int N = state.mNum;
        for (int i = 0; i < N; ++i) {
            ChildDrawable layer = array2[i];
            if (layer.mThemeAttrs == null && !layer.mDrawable.canApplyTheme()) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_graphics_drawable_LayerDrawable$isProjected() {
        if (super.isProjected()) {
            return true;
        }
        ChildDrawable[] layers = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            if (!layers[i].mDrawable.isProjected()) continue;
            return true;
        }
        return false;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$addLayer(ChildDrawable layer) {
        LayerState st = this.mLayerState;
        int i = st.mNum;
        int N = st.mChildren != null ? st.mChildren.length : 0;
        if (i >= N) {
            ChildDrawable[] nu = new ChildDrawable[N + 10];
            if (i > 0) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)st.mChildren, (int)0, (Object)nu, (int)0, (int)i);
            }
            st.mChildren = nu;
        }
        st.mChildren[i] = layer;
        ++st.mNum;
        st.invalidateCache();
    }

    private final ChildDrawable $$robo$$android_graphics_drawable_LayerDrawable$addLayer(Drawable layer, int[] themeAttrs, int id2, int left, int top, int right, int bottom) {
        ChildDrawable childDrawable = new ChildDrawable();
        childDrawable.mId = id2;
        childDrawable.mThemeAttrs = themeAttrs;
        childDrawable.mDrawable = layer;
        childDrawable.mDrawable.setAutoMirrored(this.isAutoMirrored());
        childDrawable.mInsetL = left;
        childDrawable.mInsetT = top;
        childDrawable.mInsetR = right;
        childDrawable.mInsetB = bottom;
        this.addLayer(childDrawable);
        this.mLayerState.mChildrenChangingConfigurations |= layer.getChangingConfigurations();
        layer.setCallback(this);
        return childDrawable;
    }

    private final Drawable $$robo$$android_graphics_drawable_LayerDrawable$findDrawableByLayerId(int id2) {
        ChildDrawable[] layers = this.mLayerState.mChildren;
        for (int i = this.mLayerState.mNum - 1; i >= 0; --i) {
            if (layers[i].mId != id2) continue;
            return layers[i].mDrawable;
        }
        return null;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setId(int index, int id2) {
        this.mLayerState.mChildren[index].mId = id2;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getNumberOfLayers() {
        return this.mLayerState.mNum;
    }

    private final Drawable $$robo$$android_graphics_drawable_LayerDrawable$getDrawable(int index) {
        return this.mLayerState.mChildren[index].mDrawable;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getId(int index) {
        return this.mLayerState.mChildren[index].mId;
    }

    private final boolean $$robo$$android_graphics_drawable_LayerDrawable$setDrawableByLayerId(int id2, Drawable drawable2) {
        ChildDrawable[] layers = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            ChildDrawable childDrawable = layers[i];
            if (childDrawable.mId != id2) continue;
            if (childDrawable.mDrawable != null) {
                if (drawable2 != null) {
                    Rect bounds = childDrawable.mDrawable.getBounds();
                    drawable2.setBounds(bounds);
                }
                childDrawable.mDrawable.setCallback(null);
            }
            if (drawable2 != null) {
                drawable2.setCallback(this);
            }
            childDrawable.mDrawable = drawable2;
            this.mLayerState.invalidateCache();
            return true;
        }
        return false;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setLayerInset(int index, int l, int t, int r, int b) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mInsetL = l;
        childDrawable.mInsetT = t;
        childDrawable.mInsetR = r;
        childDrawable.mInsetB = b;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setPaddingMode(int mode) {
        if (this.mLayerState.mPaddingMode != mode) {
            this.mLayerState.mPaddingMode = mode;
        }
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getPaddingMode() {
        return this.mLayerState.mPaddingMode;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$invalidateDrawable(Drawable who) {
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$scheduleDrawable(Drawable who, Runnable what, long when) {
        this.scheduleSelf(what, when);
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$unscheduleDrawable(Drawable who, Runnable what) {
        this.unscheduleSelf(what);
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$draw(Canvas canvas) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.draw(canvas);
        }
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mLayerState.mChangingConfigurations | this.mLayerState.mChildrenChangingConfigurations;
    }

    private final boolean $$robo$$android_graphics_drawable_LayerDrawable$getPadding(Rect padding) {
        if (this.mLayerState.mPaddingMode == 0) {
            this.computeNestedPadding(padding);
        } else {
            this.computeStackedPadding(padding);
        }
        return padding.left != 0 || padding.top != 0 || padding.right != 0 || padding.bottom != 0;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$computeNestedPadding(Rect padding) {
        padding.left = 0;
        padding.top = 0;
        padding.right = 0;
        padding.bottom = 0;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            this.refreshChildPadding(i, array2[i]);
            padding.left += this.mPaddingL[i];
            padding.top += this.mPaddingT[i];
            padding.right += this.mPaddingR[i];
            padding.bottom += this.mPaddingB[i];
        }
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$computeStackedPadding(Rect padding) {
        padding.left = 0;
        padding.top = 0;
        padding.right = 0;
        padding.bottom = 0;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            this.refreshChildPadding(i, array2[i]);
            padding.left = Math.max(padding.left, this.mPaddingL[i]);
            padding.top = Math.max(padding.top, this.mPaddingT[i]);
            padding.right = Math.max(padding.right, this.mPaddingR[i]);
            padding.bottom = Math.max(padding.bottom, this.mPaddingB[i]);
        }
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$getOutline(Outline outline) {
        LayerState state = this.mLayerState;
        ChildDrawable[] children = state.mChildren;
        int N = state.mNum;
        for (int i = 0; i < N; ++i) {
            children[i].mDrawable.getOutline(outline);
            if (outline.isEmpty()) continue;
            return;
        }
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setHotspot(float x, float y) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.setHotspot(x, y);
        }
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setHotspotBounds(int left, int top, int right, int bottom) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.setHotspotBounds(left, top, right, bottom);
        }
        if (this.mHotspotBounds == null) {
            this.mHotspotBounds = new Rect(left, top, right, bottom);
        } else {
            this.mHotspotBounds.set(left, top, right, bottom);
        }
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$getHotspotBounds(Rect outRect) {
        if (this.mHotspotBounds != null) {
            outRect.set(this.mHotspotBounds);
        } else {
            super.getHotspotBounds(outRect);
        }
    }

    private final boolean $$robo$$android_graphics_drawable_LayerDrawable$setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.setVisible(visible, restart);
        }
        return changed;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setDither(boolean dither) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.setDither(dither);
        }
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setAlpha(int alpha) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.setAlpha(alpha);
        }
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getAlpha() {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        if (this.mLayerState.mNum > 0) {
            return array2[0].mDrawable.getAlpha();
        }
        return super.getAlpha();
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setColorFilter(ColorFilter cf) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.setColorFilter(cf);
        }
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setTintList(ColorStateList tint) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.setTintList(tint);
        }
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setTintMode(PorterDuff.Mode tintMode) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.setTintMode(tintMode);
        }
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setOpacity(int opacity) {
        this.mOpacityOverride = opacity;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getOpacity() {
        if (this.mOpacityOverride != 0) {
            return this.mOpacityOverride;
        }
        return this.mLayerState.getOpacity();
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setAutoMirrored(boolean mirrored) {
        this.mLayerState.mAutoMirrored = mirrored;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.setAutoMirrored(mirrored);
        }
    }

    private final boolean $$robo$$android_graphics_drawable_LayerDrawable$isAutoMirrored() {
        return this.mLayerState.mAutoMirrored;
    }

    private final boolean $$robo$$android_graphics_drawable_LayerDrawable$isStateful() {
        return this.mLayerState.isStateful();
    }

    private final boolean $$robo$$android_graphics_drawable_LayerDrawable$onStateChange(int[] state) {
        boolean paddingChanged = false;
        boolean changed = false;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            ChildDrawable r = array2[i];
            if (r.mDrawable.isStateful() && r.mDrawable.setState(state)) {
                changed = true;
            }
            if (!this.refreshChildPadding(i, r)) continue;
            paddingChanged = true;
        }
        if (paddingChanged) {
            this.onBoundsChange(this.getBounds());
        }
        return changed;
    }

    private final boolean $$robo$$android_graphics_drawable_LayerDrawable$onLevelChange(int level) {
        boolean paddingChanged = false;
        boolean changed = false;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            ChildDrawable r = array2[i];
            if (r.mDrawable.setLevel(level)) {
                changed = true;
            }
            if (!this.refreshChildPadding(i, r)) continue;
            paddingChanged = true;
        }
        if (paddingChanged) {
            this.onBoundsChange(this.getBounds());
        }
        return changed;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$onBoundsChange(Rect bounds) {
        int padL = 0;
        int padT = 0;
        int padR = 0;
        int padB = 0;
        boolean nest = this.mLayerState.mPaddingMode == 0;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            ChildDrawable r = array2[i];
            r.mDrawable.setBounds(bounds.left + r.mInsetL + padL, bounds.top + r.mInsetT + padT, bounds.right - r.mInsetR - padR, bounds.bottom - r.mInsetB - padB);
            if (!nest) continue;
            padL += this.mPaddingL[i];
            padR += this.mPaddingR[i];
            padT += this.mPaddingT[i];
            padB += this.mPaddingB[i];
        }
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getIntrinsicWidth() {
        int width = -1;
        int padL = 0;
        int padR = 0;
        boolean nest = this.mLayerState.mPaddingMode == 0;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            ChildDrawable r = array2[i];
            int w = r.mDrawable.getIntrinsicWidth() + r.mInsetL + r.mInsetR + padL + padR;
            if (w > width) {
                width = w;
            }
            if (!nest) continue;
            padL += this.mPaddingL[i];
            padR += this.mPaddingR[i];
        }
        return width;
    }

    private final int $$robo$$android_graphics_drawable_LayerDrawable$getIntrinsicHeight() {
        int height = -1;
        int padT = 0;
        int padB = 0;
        boolean nest = this.mLayerState.mPaddingMode == 0;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            ChildDrawable r = array2[i];
            int h = r.mDrawable.getIntrinsicHeight() + r.mInsetT + r.mInsetB + padT + padB;
            if (h > height) {
                height = h;
            }
            if (!nest) continue;
            padT += this.mPaddingT[i];
            padB += this.mPaddingB[i];
        }
        return height;
    }

    private final boolean $$robo$$android_graphics_drawable_LayerDrawable$refreshChildPadding(int i, ChildDrawable r) {
        Rect rect = this.mTmpRect;
        r.mDrawable.getPadding(rect);
        if (rect.left != this.mPaddingL[i] || rect.top != this.mPaddingT[i] || rect.right != this.mPaddingR[i] || rect.bottom != this.mPaddingB[i]) {
            this.mPaddingL[i] = rect.left;
            this.mPaddingT[i] = rect.top;
            this.mPaddingR[i] = rect.right;
            this.mPaddingB[i] = rect.bottom;
            return true;
        }
        return false;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$ensurePadding() {
        int N = this.mLayerState.mNum;
        if (this.mPaddingL != null && this.mPaddingL.length >= N) {
            return;
        }
        this.mPaddingL = new int[N];
        this.mPaddingT = new int[N];
        this.mPaddingR = new int[N];
        this.mPaddingB = new int[N];
    }

    private final Drawable.ConstantState $$robo$$android_graphics_drawable_LayerDrawable$getConstantState() {
        if (this.mLayerState.canConstantState()) {
            this.mLayerState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mLayerState;
        }
        return null;
    }

    private final Drawable $$robo$$android_graphics_drawable_LayerDrawable$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mLayerState = this.createConstantState(this.mLayerState, null);
            ChildDrawable[] array2 = this.mLayerState.mChildren;
            int N = this.mLayerState.mNum;
            for (int i = 0; i < N; ++i) {
                array2[i].mDrawable.mutate();
            }
            this.mMutated = true;
        }
        return this;
    }

    private final void $$robo$$android_graphics_drawable_LayerDrawable$setLayoutDirection(int layoutDirection) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.setLayoutDirection(layoutDirection);
        }
        super.setLayoutDirection(layoutDirection);
    }

    private void __constructor__(Drawable[] drawableArray) {
        this.$$robo$$android_graphics_drawable_LayerDrawable$__constructor__(drawableArray);
    }

    public LayerDrawable(Drawable[] drawableArray) {
        this(drawableArray, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_LayerDrawable$__constructor__(android.graphics.drawable.Drawable[] ), 0, this, drawableArray);
    }

    private void __constructor__(Drawable[] drawableArray, LayerState layerState) {
        this.$$robo$$android_graphics_drawable_LayerDrawable$__constructor__(drawableArray, layerState);
    }

    LayerDrawable(Drawable[] drawableArray, LayerState layerState) {
        this(layerState, null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_LayerDrawable$__constructor__(android.graphics.drawable.Drawable[] android.graphics.drawable.LayerDrawable$LayerState ), 0, this, drawableArray, layerState);
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_LayerDrawable$__constructor__();
    }

    LayerDrawable() {
        this(null, null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_LayerDrawable$__constructor__(), 0, this);
    }

    private void __constructor__(LayerState layerState, Resources resources, Resources.Theme theme) {
        this.$$robo$$android_graphics_drawable_LayerDrawable$__constructor__(layerState, resources, theme);
    }

    LayerDrawable(LayerState layerState, Resources resources, Resources.Theme theme) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_LayerDrawable$__constructor__(android.graphics.drawable.LayerDrawable$LayerState android.content.res.Resources android.content.res.Resources$Theme ), 0, this, layerState, resources, theme);
    }

    LayerState createConstantState(LayerState layerState, Resources resources) {
        return InvokeDynamicSupport.bootstrap("createConstantState", $$robo$$android_graphics_drawable_LayerDrawable$createConstantState(android.graphics.drawable.LayerDrawable$LayerState android.content.res.Resources ), 0, this, layerState, resources);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_LayerDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    private void updateStateFromTypedArray(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_LayerDrawable$updateStateFromTypedArray(android.content.res.TypedArray ), 0, this, typedArray);
    }

    private void inflateLayers(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflateLayers", $$robo$$android_graphics_drawable_LayerDrawable$inflateLayers(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    private void updateLayerFromTypedArray(ChildDrawable childDrawable, TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateLayerFromTypedArray", $$robo$$android_graphics_drawable_LayerDrawable$updateLayerFromTypedArray(android.graphics.drawable.LayerDrawable$ChildDrawable android.content.res.TypedArray ), 0, this, childDrawable, typedArray);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_LayerDrawable$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
    }

    @Override
    public boolean canApplyTheme() {
        return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_LayerDrawable$canApplyTheme(), 0, this);
    }

    @Override
    public boolean isProjected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isProjected", $$robo$$android_graphics_drawable_LayerDrawable$isProjected(), 0, this);
    }

    void addLayer(ChildDrawable childDrawable) {
        InvokeDynamicSupport.bootstrap("addLayer", $$robo$$android_graphics_drawable_LayerDrawable$addLayer(android.graphics.drawable.LayerDrawable$ChildDrawable ), 0, this, childDrawable);
    }

    ChildDrawable addLayer(Drawable drawable2, int[] nArray, int n, int n2, int n3, int n4, int n5) {
        return InvokeDynamicSupport.bootstrap("addLayer", $$robo$$android_graphics_drawable_LayerDrawable$addLayer(android.graphics.drawable.Drawable int[] int int int int int ), 0, this, drawable2, nArray, n, n2, n3, n4, n5);
    }

    public Drawable findDrawableByLayerId(int n) {
        return InvokeDynamicSupport.bootstrap("findDrawableByLayerId", $$robo$$android_graphics_drawable_LayerDrawable$findDrawableByLayerId(int ), 0, this, n);
    }

    public void setId(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setId", $$robo$$android_graphics_drawable_LayerDrawable$setId(int int ), 0, this, n, n2);
    }

    public int getNumberOfLayers() {
        return (int)InvokeDynamicSupport.bootstrap("getNumberOfLayers", $$robo$$android_graphics_drawable_LayerDrawable$getNumberOfLayers(), 0, this);
    }

    public Drawable getDrawable(int n) {
        return InvokeDynamicSupport.bootstrap("getDrawable", $$robo$$android_graphics_drawable_LayerDrawable$getDrawable(int ), 0, this, n);
    }

    public int getId(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getId", $$robo$$android_graphics_drawable_LayerDrawable$getId(int ), 0, this, n);
    }

    public boolean setDrawableByLayerId(int n, Drawable drawable2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setDrawableByLayerId", $$robo$$android_graphics_drawable_LayerDrawable$setDrawableByLayerId(int android.graphics.drawable.Drawable ), 0, this, n, drawable2);
    }

    public void setLayerInset(int n, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrap("setLayerInset", $$robo$$android_graphics_drawable_LayerDrawable$setLayerInset(int int int int int ), 0, this, n, n2, n3, n4, n5);
    }

    public void setPaddingMode(int n) {
        InvokeDynamicSupport.bootstrap("setPaddingMode", $$robo$$android_graphics_drawable_LayerDrawable$setPaddingMode(int ), 0, this, n);
    }

    public int getPaddingMode() {
        return (int)InvokeDynamicSupport.bootstrap("getPaddingMode", $$robo$$android_graphics_drawable_LayerDrawable$getPaddingMode(), 0, this);
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("invalidateDrawable", $$robo$$android_graphics_drawable_LayerDrawable$invalidateDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        InvokeDynamicSupport.bootstrap("scheduleDrawable", $$robo$$android_graphics_drawable_LayerDrawable$scheduleDrawable(android.graphics.drawable.Drawable java.lang.Runnable long ), 0, this, drawable2, runnable, l);
    }

    @Override
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        InvokeDynamicSupport.bootstrap("unscheduleDrawable", $$robo$$android_graphics_drawable_LayerDrawable$unscheduleDrawable(android.graphics.drawable.Drawable java.lang.Runnable ), 0, this, drawable2, runnable);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_LayerDrawable$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_LayerDrawable$getChangingConfigurations(), 0, this);
    }

    @Override
    public boolean getPadding(Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getPadding", $$robo$$android_graphics_drawable_LayerDrawable$getPadding(android.graphics.Rect ), 0, this, rect);
    }

    private void computeNestedPadding(Rect rect) {
        InvokeDynamicSupport.bootstrap("computeNestedPadding", $$robo$$android_graphics_drawable_LayerDrawable$computeNestedPadding(android.graphics.Rect ), 0, this, rect);
    }

    private void computeStackedPadding(Rect rect) {
        InvokeDynamicSupport.bootstrap("computeStackedPadding", $$robo$$android_graphics_drawable_LayerDrawable$computeStackedPadding(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public void getOutline(Outline outline) {
        InvokeDynamicSupport.bootstrap("getOutline", $$robo$$android_graphics_drawable_LayerDrawable$getOutline(android.graphics.Outline ), 0, this, outline);
    }

    @Override
    public void setHotspot(float f, float f2) {
        InvokeDynamicSupport.bootstrap("setHotspot", $$robo$$android_graphics_drawable_LayerDrawable$setHotspot(float float ), 0, this, f, f2);
    }

    @Override
    public void setHotspotBounds(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setHotspotBounds", $$robo$$android_graphics_drawable_LayerDrawable$setHotspotBounds(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void getHotspotBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("getHotspotBounds", $$robo$$android_graphics_drawable_LayerDrawable$getHotspotBounds(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setVisible", $$robo$$android_graphics_drawable_LayerDrawable$setVisible(boolean boolean ), 0, this, bl, bl2);
    }

    @Override
    public void setDither(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDither", $$robo$$android_graphics_drawable_LayerDrawable$setDither(boolean ), 0, this, bl);
    }

    @Override
    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_drawable_LayerDrawable$setAlpha(int ), 0, this, n);
    }

    @Override
    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_drawable_LayerDrawable$getAlpha(), 0, this);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_graphics_drawable_LayerDrawable$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setTintList", $$robo$$android_graphics_drawable_LayerDrawable$setTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setTintMode", $$robo$$android_graphics_drawable_LayerDrawable$setTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    public void setOpacity(int n) {
        InvokeDynamicSupport.bootstrap("setOpacity", $$robo$$android_graphics_drawable_LayerDrawable$setOpacity(int ), 0, this, n);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_LayerDrawable$getOpacity(), 0, this);
    }

    @Override
    public void setAutoMirrored(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAutoMirrored", $$robo$$android_graphics_drawable_LayerDrawable$setAutoMirrored(boolean ), 0, this, bl);
    }

    @Override
    public boolean isAutoMirrored() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAutoMirrored", $$robo$$android_graphics_drawable_LayerDrawable$isAutoMirrored(), 0, this);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_LayerDrawable$isStateful(), 0, this);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_LayerDrawable$onStateChange(int[] ), 0, this, nArray);
    }

    @Override
    protected boolean onLevelChange(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLevelChange", $$robo$$android_graphics_drawable_LayerDrawable$onLevelChange(int ), 0, this, n);
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        InvokeDynamicSupport.bootstrap("onBoundsChange", $$robo$$android_graphics_drawable_LayerDrawable$onBoundsChange(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicWidth", $$robo$$android_graphics_drawable_LayerDrawable$getIntrinsicWidth(), 0, this);
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicHeight", $$robo$$android_graphics_drawable_LayerDrawable$getIntrinsicHeight(), 0, this);
    }

    private boolean refreshChildPadding(int n, ChildDrawable childDrawable) {
        return (boolean)InvokeDynamicSupport.bootstrap("refreshChildPadding", $$robo$$android_graphics_drawable_LayerDrawable$refreshChildPadding(int android.graphics.drawable.LayerDrawable$ChildDrawable ), 0, this, n, childDrawable);
    }

    void ensurePadding() {
        InvokeDynamicSupport.bootstrap("ensurePadding", $$robo$$android_graphics_drawable_LayerDrawable$ensurePadding(), 0, this);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_graphics_drawable_LayerDrawable$getConstantState(), 0, this);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_LayerDrawable$mutate(), 0, this);
    }

    @Override
    public void setLayoutDirection(int n) {
        InvokeDynamicSupport.bootstrap("setLayoutDirection", $$robo$$android_graphics_drawable_LayerDrawable$setLayoutDirection(int ), 0, this, n);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayerDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class LayerState
    extends Drawable.ConstantState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int mNum;
        ChildDrawable[] mChildren;
        int[] mThemeAttrs;
        int mChangingConfigurations;
        int mChildrenChangingConfigurations;
        private boolean mHaveOpacity;
        private int mOpacity;
        private boolean mHaveIsStateful;
        private boolean mIsStateful;
        private boolean mAutoMirrored;
        private int mPaddingMode;

        private void $$robo$$android_graphics_drawable_LayerDrawable_LayerState$__constructor__(LayerState orig, LayerDrawable owner, Resources res) {
            this.mAutoMirrored = false;
            this.mPaddingMode = 0;
            if (orig != null) {
                int N;
                ChildDrawable[] origChildDrawable = orig.mChildren;
                this.mNum = N = orig.mNum;
                this.mChildren = new ChildDrawable[N];
                this.mChangingConfigurations = orig.mChangingConfigurations;
                this.mChildrenChangingConfigurations = orig.mChildrenChangingConfigurations;
                for (int i = 0; i < N; ++i) {
                    ChildDrawable or = origChildDrawable[i];
                    this.mChildren[i] = new ChildDrawable(or, owner, res);
                }
                this.mHaveOpacity = orig.mHaveOpacity;
                this.mOpacity = orig.mOpacity;
                this.mHaveIsStateful = orig.mHaveIsStateful;
                this.mIsStateful = orig.mIsStateful;
                this.mAutoMirrored = orig.mAutoMirrored;
                this.mPaddingMode = orig.mPaddingMode;
                this.mThemeAttrs = orig.mThemeAttrs;
            } else {
                this.mNum = 0;
                this.mChildren = null;
            }
        }

        private final boolean $$robo$$android_graphics_drawable_LayerDrawable_LayerState$canApplyTheme() {
            return this.mThemeAttrs != null;
        }

        private final Drawable $$robo$$android_graphics_drawable_LayerDrawable_LayerState$newDrawable() {
            return new LayerDrawable(this, null, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_LayerDrawable_LayerState$newDrawable(Resources res) {
            return new LayerDrawable(this, res, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_LayerDrawable_LayerState$newDrawable(Resources res, Resources.Theme theme) {
            return new LayerDrawable(this, res, theme);
        }

        private final int $$robo$$android_graphics_drawable_LayerDrawable_LayerState$getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        private final int $$robo$$android_graphics_drawable_LayerDrawable_LayerState$getOpacity() {
            if (this.mHaveOpacity) {
                return this.mOpacity;
            }
            ChildDrawable[] array2 = this.mChildren;
            int N = this.mNum;
            int op = N > 0 ? array2[0].mDrawable.getOpacity() : -2;
            for (int i = 1; i < N; ++i) {
                op = Drawable.resolveOpacity(op, array2[i].mDrawable.getOpacity());
            }
            this.mOpacity = op;
            this.mHaveOpacity = true;
            return op;
        }

        private final boolean $$robo$$android_graphics_drawable_LayerDrawable_LayerState$isStateful() {
            if (this.mHaveIsStateful) {
                return this.mIsStateful;
            }
            ChildDrawable[] array2 = this.mChildren;
            int N = this.mNum;
            boolean isStateful = false;
            for (int i = 0; i < N; ++i) {
                if (!array2[i].mDrawable.isStateful()) continue;
                isStateful = true;
                break;
            }
            this.mIsStateful = isStateful;
            this.mHaveIsStateful = true;
            return isStateful;
        }

        private final boolean $$robo$$android_graphics_drawable_LayerDrawable_LayerState$canConstantState() {
            ChildDrawable[] array2 = this.mChildren;
            int N = this.mNum;
            for (int i = 0; i < N; ++i) {
                if (array2[i].mDrawable.getConstantState() != null) continue;
                return false;
            }
            return true;
        }

        private final void $$robo$$android_graphics_drawable_LayerDrawable_LayerState$invalidateCache() {
            this.mHaveOpacity = false;
            this.mHaveIsStateful = false;
        }

        private void __constructor__(LayerState layerState, LayerDrawable layerDrawable, Resources resources) {
            this.$$robo$$android_graphics_drawable_LayerDrawable_LayerState$__constructor__(layerState, layerDrawable, resources);
        }

        LayerState(LayerState layerState, LayerDrawable layerDrawable, Resources resources) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_LayerDrawable_LayerState$__constructor__(android.graphics.drawable.LayerDrawable$LayerState android.graphics.drawable.LayerDrawable android.content.res.Resources ), 0, this, layerState, layerDrawable, resources);
        }

        @Override
        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_LayerDrawable_LayerState$canApplyTheme(), 0, this);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_LayerDrawable_LayerState$newDrawable(), 0, this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_LayerDrawable_LayerState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        @Override
        public Drawable newDrawable(Resources resources, Resources.Theme theme) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_LayerDrawable_LayerState$newDrawable(android.content.res.Resources android.content.res.Resources$Theme ), 0, this, resources, theme);
        }

        @Override
        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_LayerDrawable_LayerState$getChangingConfigurations(), 0, this);
        }

        public int getOpacity() {
            return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_LayerDrawable_LayerState$getOpacity(), 0, this);
        }

        public boolean isStateful() {
            return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_LayerDrawable_LayerState$isStateful(), 0, this);
        }

        public boolean canConstantState() {
            return (boolean)InvokeDynamicSupport.bootstrap("canConstantState", $$robo$$android_graphics_drawable_LayerDrawable_LayerState$canConstantState(), 0, this);
        }

        public void invalidateCache() {
            InvokeDynamicSupport.bootstrap("invalidateCache", $$robo$$android_graphics_drawable_LayerDrawable_LayerState$invalidateCache(), 0, this);
        }

        public /* synthetic */ LayerState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayerState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ChildDrawable
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Drawable mDrawable;
        public int[] mThemeAttrs;
        public int mInsetL;
        public int mInsetT;
        public int mInsetR;
        public int mInsetB;
        public int mId;

        private void $$robo$$android_graphics_drawable_LayerDrawable_ChildDrawable$__constructor__() {
            this.mId = -1;
        }

        private void $$robo$$android_graphics_drawable_LayerDrawable_ChildDrawable$__constructor__(ChildDrawable orig, LayerDrawable owner, Resources res) {
            this.mId = -1;
            this.mDrawable = res != null ? orig.mDrawable.getConstantState().newDrawable(res) : orig.mDrawable.getConstantState().newDrawable();
            this.mDrawable.setCallback(owner);
            this.mDrawable.setLayoutDirection(orig.mDrawable.getLayoutDirection());
            this.mDrawable.setBounds(orig.mDrawable.getBounds());
            this.mDrawable.setLevel(orig.mDrawable.getLevel());
            this.mThemeAttrs = orig.mThemeAttrs;
            this.mInsetL = orig.mInsetL;
            this.mInsetT = orig.mInsetT;
            this.mInsetR = orig.mInsetR;
            this.mInsetB = orig.mInsetB;
            this.mId = orig.mId;
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_drawable_LayerDrawable_ChildDrawable$__constructor__();
        }

        ChildDrawable() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_LayerDrawable_ChildDrawable$__constructor__(), 0, this);
        }

        private void __constructor__(ChildDrawable childDrawable, LayerDrawable layerDrawable, Resources resources) {
            this.$$robo$$android_graphics_drawable_LayerDrawable_ChildDrawable$__constructor__(childDrawable, layerDrawable, resources);
        }

        ChildDrawable(ChildDrawable childDrawable, LayerDrawable layerDrawable, Resources resources) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_LayerDrawable_ChildDrawable$__constructor__(android.graphics.drawable.LayerDrawable$ChildDrawable android.graphics.drawable.LayerDrawable android.content.res.Resources ), 0, this, childDrawable, layerDrawable, resources);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChildDrawable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

