/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.util.AttributeSet;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LevelListDrawable
extends DrawableContainer
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private LevelListState mLevelListState;
    private boolean mMutated;

    private void $$robo$$android_graphics_drawable_LevelListDrawable$__constructor__() {
    }

    private final void $$robo$$android_graphics_drawable_LevelListDrawable$addLevel(int low, int high, Drawable drawable2) {
        if (drawable2 != null) {
            this.mLevelListState.addLevel(low, high, drawable2);
            this.onLevelChange(this.getLevel());
        }
    }

    private final boolean $$robo$$android_graphics_drawable_LevelListDrawable$onLevelChange(int level) {
        int idx = this.mLevelListState.indexOfLevel(level);
        if (this.selectDrawable(idx)) {
            return true;
        }
        return super.onLevelChange(level);
    }

    private final void $$robo$$android_graphics_drawable_LevelListDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        super.inflate(r, parser, attrs, theme);
        int low = 0;
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            Drawable dr;
            if (type != 2 || depth > innerDepth || !parser.getName().equals("item")) continue;
            TypedArray a = LevelListDrawable.obtainAttributes(r, theme, attrs, R.styleable.LevelListDrawableItem);
            low = a.getInt(1, 0);
            int high = a.getInt(2, 0);
            int drawableRes = a.getResourceId(0, 0);
            a.recycle();
            if (high < 0) {
                throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'maxLevel' attribute");
            }
            if (drawableRes != 0) {
                dr = r.getDrawable(drawableRes, theme);
            } else {
                while ((type = parser.next()) == 4) {
                }
                if (type != 2) {
                    throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
                }
                dr = Drawable.createFromXmlInner(r, parser, attrs, theme);
            }
            this.mLevelListState.addLevel(low, high, dr);
        }
        this.onLevelChange(this.getLevel());
    }

    private final Drawable $$robo$$android_graphics_drawable_LevelListDrawable$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            LevelListState.access$002(this.mLevelListState, (int[])this.mLevelListState.mLows.clone());
            LevelListState.access$102(this.mLevelListState, (int[])this.mLevelListState.mHighs.clone());
            this.mMutated = true;
        }
        return this;
    }

    private void $$robo$$android_graphics_drawable_LevelListDrawable$__constructor__(LevelListState state, Resources res) {
        LevelListState as;
        this.mLevelListState = as = new LevelListState(state, this, res);
        this.setConstantState(as);
        this.onLevelChange(this.getLevel());
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_LevelListDrawable$__constructor__(LevelListState x0, Resources x1, 1 x2) {
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_LevelListDrawable$__constructor__();
    }

    public LevelListDrawable() {
        this(null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_LevelListDrawable$__constructor__(), 0, this);
    }

    public void addLevel(int n, int n2, Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("addLevel", $$robo$$android_graphics_drawable_LevelListDrawable$addLevel(int int android.graphics.drawable.Drawable ), 0, this, n, n2, drawable2);
    }

    @Override
    protected boolean onLevelChange(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLevelChange", $$robo$$android_graphics_drawable_LevelListDrawable$onLevelChange(int ), 0, this, n);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_LevelListDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_LevelListDrawable$mutate(), 0, this);
    }

    private void __constructor__(LevelListState levelListState, Resources resources) {
        this.$$robo$$android_graphics_drawable_LevelListDrawable$__constructor__(levelListState, resources);
    }

    private LevelListDrawable(LevelListState levelListState, Resources resources) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_LevelListDrawable$__constructor__(android.graphics.drawable.LevelListDrawable$LevelListState android.content.res.Resources ), 0, this, levelListState, resources);
    }

    private /* synthetic */ void __constructor__(LevelListState levelListState, Resources resources, 1 var3_3) {
        this.$$robo$$android_graphics_drawable_LevelListDrawable$__constructor__(levelListState, resources, var3_3);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LevelListDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class LevelListState
    extends DrawableContainer.DrawableContainerState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int[] mLows;
        private int[] mHighs;

        private void $$robo$$android_graphics_drawable_LevelListDrawable_LevelListState$__constructor__(LevelListState orig, LevelListDrawable owner, Resources res) {
            if (orig != null) {
                this.mLows = orig.mLows;
                this.mHighs = orig.mHighs;
            } else {
                this.mLows = new int[this.getCapacity()];
                this.mHighs = new int[this.getCapacity()];
            }
        }

        private final void $$robo$$android_graphics_drawable_LevelListDrawable_LevelListState$addLevel(int low, int high, Drawable drawable2) {
            int pos = this.addChild(drawable2);
            this.mLows[pos] = low;
            this.mHighs[pos] = high;
        }

        private final int $$robo$$android_graphics_drawable_LevelListDrawable_LevelListState$indexOfLevel(int level) {
            int[] lows = this.mLows;
            int[] highs = this.mHighs;
            int N = this.getChildCount();
            for (int i = 0; i < N; ++i) {
                if (level < lows[i] || level > highs[i]) continue;
                return i;
            }
            return -1;
        }

        private final Drawable $$robo$$android_graphics_drawable_LevelListDrawable_LevelListState$newDrawable() {
            return new LevelListDrawable(this, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_LevelListDrawable_LevelListState$newDrawable(Resources res) {
            return new LevelListDrawable(this, res);
        }

        private final void $$robo$$android_graphics_drawable_LevelListDrawable_LevelListState$growArray(int oldSize, int newSize) {
            super.growArray(oldSize, newSize);
            int[] newInts = new int[newSize];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.mLows, (int)0, (int[])newInts, (int)0, (int)oldSize);
            this.mLows = newInts;
            newInts = new int[newSize];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.mHighs, (int)0, (int[])newInts, (int)0, (int)oldSize);
            this.mHighs = newInts;
        }

        static /* synthetic */ int[] access$002(LevelListState x0, int[] x1) {
            x0.mLows = x1;
            return x1;
        }

        static /* synthetic */ int[] access$102(LevelListState x0, int[] x1) {
            x0.mHighs = x1;
            return x1;
        }

        private void __constructor__(LevelListState levelListState, LevelListDrawable levelListDrawable, Resources resources) {
            this.$$robo$$android_graphics_drawable_LevelListDrawable_LevelListState$__constructor__(levelListState, levelListDrawable, resources);
        }

        LevelListState(LevelListState levelListState, LevelListDrawable levelListDrawable, Resources resources) {
            super(levelListState, levelListDrawable, resources);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_LevelListDrawable_LevelListState$__constructor__(android.graphics.drawable.LevelListDrawable$LevelListState android.graphics.drawable.LevelListDrawable android.content.res.Resources ), 0, this, levelListState, levelListDrawable, resources);
        }

        public void addLevel(int n, int n2, Drawable drawable2) {
            InvokeDynamicSupport.bootstrap("addLevel", $$robo$$android_graphics_drawable_LevelListDrawable_LevelListState$addLevel(int int android.graphics.drawable.Drawable ), 0, this, n, n2, drawable2);
        }

        public int indexOfLevel(int n) {
            return (int)InvokeDynamicSupport.bootstrap("indexOfLevel", $$robo$$android_graphics_drawable_LevelListDrawable_LevelListState$indexOfLevel(int ), 0, this, n);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_LevelListDrawable_LevelListState$newDrawable(), 0, this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_LevelListDrawable_LevelListState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        @Override
        public void growArray(int n, int n2) {
            InvokeDynamicSupport.bootstrap("growArray", $$robo$$android_graphics_drawable_LevelListDrawable_LevelListState$growArray(int int ), 0, this, n, n2);
        }

        public /* synthetic */ LevelListState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LevelListState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

