/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Insets;
import android.graphics.NinePatch;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.InputStream;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class NinePatchDrawable
extends Drawable
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEFAULT_DITHER = false;
    private NinePatchState mNinePatchState;
    private NinePatch mNinePatch;
    private PorterDuffColorFilter mTintFilter;
    private Rect mPadding;
    private Insets mOpticalInsets;
    private Paint mPaint;
    private boolean mMutated;
    private int mTargetDensity;
    private int mBitmapWidth;
    private int mBitmapHeight;

    private void $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__() {
        this.mOpticalInsets = Insets.NONE;
        this.mTargetDensity = 160;
        this.mBitmapWidth = -1;
        this.mBitmapHeight = -1;
        this.mNinePatchState = new NinePatchState();
    }

    @Deprecated
    private void $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(Bitmap bitmap, byte[] chunk, Rect padding, String srcName) {
    }

    private void $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(Resources res, Bitmap bitmap, byte[] chunk, Rect padding, String srcName) {
        this.mNinePatchState.mTargetDensity = this.mTargetDensity;
    }

    private void $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(Resources res, Bitmap bitmap, byte[] chunk, Rect padding, Rect opticalInsets, String srcName) {
        this.mNinePatchState.mTargetDensity = this.mTargetDensity;
    }

    @Deprecated
    private void $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(NinePatch patch) {
    }

    private void $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(Resources res, NinePatch patch) {
        this.mNinePatchState.mTargetDensity = this.mTargetDensity;
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$setTargetDensity(Canvas canvas) {
        this.setTargetDensity(canvas.getDensity());
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$setTargetDensity(DisplayMetrics metrics) {
        this.setTargetDensity(metrics.densityDpi);
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$setTargetDensity(int density) {
        if (density != this.mTargetDensity) {
            int n = this.mTargetDensity = density == 0 ? 160 : density;
            if (this.mNinePatch != null) {
                this.computeBitmapSize();
            }
            this.invalidateSelf();
        }
    }

    private static final Insets $$robo$$android_graphics_drawable_NinePatchDrawable$scaleFromDensity(Insets insets, int sdensity, int tdensity) {
        int left = Bitmap.scaleFromDensity(insets.left, sdensity, tdensity);
        int top = Bitmap.scaleFromDensity(insets.top, sdensity, tdensity);
        int right = Bitmap.scaleFromDensity(insets.right, sdensity, tdensity);
        int bottom = Bitmap.scaleFromDensity(insets.bottom, sdensity, tdensity);
        return Insets.of(left, top, right, bottom);
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$computeBitmapSize() {
        int tdensity;
        int sdensity = this.mNinePatch.getDensity();
        if (sdensity == (tdensity = this.mTargetDensity)) {
            this.mBitmapWidth = this.mNinePatch.getWidth();
            this.mBitmapHeight = this.mNinePatch.getHeight();
            this.mOpticalInsets = this.mNinePatchState.mOpticalInsets;
        } else {
            this.mBitmapWidth = Bitmap.scaleFromDensity(this.mNinePatch.getWidth(), sdensity, tdensity);
            this.mBitmapHeight = Bitmap.scaleFromDensity(this.mNinePatch.getHeight(), sdensity, tdensity);
            if (this.mNinePatchState.mPadding != null && this.mPadding != null) {
                Rect dest = this.mPadding;
                Rect src = this.mNinePatchState.mPadding;
                if (dest == src) {
                    this.mPadding = dest = new Rect(src);
                }
                dest.left = Bitmap.scaleFromDensity(src.left, sdensity, tdensity);
                dest.top = Bitmap.scaleFromDensity(src.top, sdensity, tdensity);
                dest.right = Bitmap.scaleFromDensity(src.right, sdensity, tdensity);
                dest.bottom = Bitmap.scaleFromDensity(src.bottom, sdensity, tdensity);
            }
            this.mOpticalInsets = NinePatchDrawable.scaleFromDensity(this.mNinePatchState.mOpticalInsets, sdensity, tdensity);
        }
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$setNinePatch(NinePatch ninePatch) {
        if (this.mNinePatch != ninePatch) {
            this.mNinePatch = ninePatch;
            if (ninePatch != null) {
                this.computeBitmapSize();
            } else {
                this.mBitmapHeight = -1;
                this.mBitmapWidth = -1;
                this.mOpticalInsets = Insets.NONE;
            }
            this.invalidateSelf();
        }
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$draw(Canvas canvas) {
        int restoreAlpha;
        boolean clearColorFilter;
        Rect bounds = this.getBounds();
        if (this.mTintFilter != null && this.getPaint().getColorFilter() == null) {
            this.mPaint.setColorFilter(this.mTintFilter);
            clearColorFilter = true;
        } else {
            clearColorFilter = false;
        }
        boolean needsMirroring = this.needsMirroring();
        if (needsMirroring) {
            canvas.translate(bounds.right - bounds.left, 0.0f);
            canvas.scale(-1.0f, 1.0f);
        }
        if (this.mNinePatchState.mBaseAlpha != 1.0f) {
            restoreAlpha = this.mPaint.getAlpha();
            this.mPaint.setAlpha((int)((float)restoreAlpha * this.mNinePatchState.mBaseAlpha + 0.5f));
        } else {
            restoreAlpha = -1;
        }
        this.mNinePatch.draw(canvas, bounds, this.mPaint);
        if (clearColorFilter) {
            this.mPaint.setColorFilter(null);
        }
        if (restoreAlpha >= 0) {
            this.mPaint.setAlpha(restoreAlpha);
        }
    }

    private final int $$robo$$android_graphics_drawable_NinePatchDrawable$getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mNinePatchState.mChangingConfigurations;
    }

    private final boolean $$robo$$android_graphics_drawable_NinePatchDrawable$getPadding(Rect padding) {
        Rect scaledPadding = this.mPadding;
        if (scaledPadding != null) {
            if (this.needsMirroring()) {
                padding.set(scaledPadding.right, scaledPadding.top, scaledPadding.left, scaledPadding.bottom);
            } else {
                padding.set(scaledPadding);
            }
            return (padding.left | padding.top | padding.right | padding.bottom) != 0;
        }
        return false;
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$getOutline(Outline outline) {
        NinePatch.InsetStruct insets;
        Rect bounds = this.getBounds();
        if (bounds.isEmpty()) {
            return;
        }
        if (this.mNinePatchState != null && (insets = this.mNinePatchState.getBitmap().getNinePatchInsets()) != null) {
            Rect outlineInsets = insets.outlineRect;
            outline.setRoundRect(bounds.left + outlineInsets.left, bounds.top + outlineInsets.top, bounds.right - outlineInsets.right, bounds.bottom - outlineInsets.bottom, insets.outlineRadius);
            outline.setAlpha(insets.outlineAlpha * ((float)this.getAlpha() / 255.0f));
            return;
        }
        super.getOutline(outline);
    }

    private final Insets $$robo$$android_graphics_drawable_NinePatchDrawable$getOpticalInsets() {
        if (this.needsMirroring()) {
            return Insets.of(this.mOpticalInsets.right, this.mOpticalInsets.top, this.mOpticalInsets.left, this.mOpticalInsets.bottom);
        }
        return this.mOpticalInsets;
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$setAlpha(int alpha) {
        if (this.mPaint == null && alpha == 255) {
            return;
        }
        this.getPaint().setAlpha(alpha);
        this.invalidateSelf();
    }

    private final int $$robo$$android_graphics_drawable_NinePatchDrawable$getAlpha() {
        if (this.mPaint == null) {
            return 255;
        }
        return this.getPaint().getAlpha();
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$setColorFilter(ColorFilter cf) {
        if (this.mPaint == null && cf == null) {
            return;
        }
        this.getPaint().setColorFilter(cf);
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$setTintList(ColorStateList tint) {
        this.mNinePatchState.mTint = tint;
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, tint, this.mNinePatchState.mTintMode);
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$setTintMode(PorterDuff.Mode tintMode) {
        this.mNinePatchState.mTintMode = tintMode;
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, this.mNinePatchState.mTint, tintMode);
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$setDither(boolean dither) {
        if (this.mPaint == null && !dither) {
            return;
        }
        this.getPaint().setDither(dither);
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$setAutoMirrored(boolean mirrored) {
        this.mNinePatchState.mAutoMirrored = mirrored;
    }

    private final boolean $$robo$$android_graphics_drawable_NinePatchDrawable$needsMirroring() {
        return this.isAutoMirrored() && this.getLayoutDirection() == 1;
    }

    private final boolean $$robo$$android_graphics_drawable_NinePatchDrawable$isAutoMirrored() {
        return this.mNinePatchState.mAutoMirrored;
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$setFilterBitmap(boolean filter) {
        this.getPaint().setFilterBitmap(filter);
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs, theme);
        TypedArray a = NinePatchDrawable.obtainAttributes(r, theme, attrs, R.styleable.NinePatchDrawable);
        this.updateStateFromTypedArray(a);
        a.recycle();
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$updateStateFromTypedArray(TypedArray a) throws XmlPullParserException {
        ColorStateList tint;
        Resources r = a.getResources();
        NinePatchState state = this.mNinePatchState;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mThemeAttrs = a.extractThemeAttrs();
        state.mDither = a.getBoolean(1, state.mDither);
        int srcResId = a.getResourceId(0, 0);
        if (srcResId != 0) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inDither = !state.mDither;
            options.inScreenDensity = r.getDisplayMetrics().noncompatDensityDpi;
            Rect padding = new Rect();
            Rect opticalInsets = new Rect();
            Bitmap bitmap = null;
            try {
                TypedValue value = new TypedValue();
                InputStream is = r.openRawResource(srcResId, value);
                bitmap = BitmapFactory.decodeResourceStream(r, value, is, padding, options);
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (bitmap == null) {
                throw new XmlPullParserException(a.getPositionDescription() + ": <nine-patch> requires a valid src attribute");
            }
            if (bitmap.getNinePatchChunk() == null) {
                throw new XmlPullParserException(a.getPositionDescription() + ": <nine-patch> requires a valid 9-patch source image");
            }
            bitmap.getOpticalInsets(opticalInsets);
            state.mNinePatch = new NinePatch(bitmap, bitmap.getNinePatchChunk());
            state.mPadding = padding;
            state.mOpticalInsets = Insets.of(opticalInsets);
        }
        state.mAutoMirrored = a.getBoolean(4, state.mAutoMirrored);
        state.mBaseAlpha = a.getFloat(3, state.mBaseAlpha);
        int tintMode = a.getInt(5, -1);
        if (tintMode != -1) {
            state.mTintMode = Drawable.parseTintMode(tintMode, PorterDuff.Mode.SRC_IN);
        }
        if ((tint = a.getColorStateList(2)) != null) {
            state.mTint = tint;
        }
        this.initializeWithState(state, r);
        state.mTargetDensity = this.mTargetDensity;
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        NinePatchState state = this.mNinePatchState;
        if (state == null || state.mThemeAttrs == null) {
            return;
        }
        TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.NinePatchDrawable);
        try {
            this.updateStateFromTypedArray(a);
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
        finally {
            a.recycle();
        }
    }

    private final boolean $$robo$$android_graphics_drawable_NinePatchDrawable$canApplyTheme() {
        return this.mNinePatchState != null && this.mNinePatchState.mThemeAttrs != null;
    }

    private final Paint $$robo$$android_graphics_drawable_NinePatchDrawable$getPaint() {
        if (this.mPaint == null) {
            this.mPaint = new Paint();
            this.mPaint.setDither(false);
        }
        return this.mPaint;
    }

    private final int $$robo$$android_graphics_drawable_NinePatchDrawable$getIntrinsicWidth() {
        return this.mBitmapWidth;
    }

    private final int $$robo$$android_graphics_drawable_NinePatchDrawable$getIntrinsicHeight() {
        return this.mBitmapHeight;
    }

    private final int $$robo$$android_graphics_drawable_NinePatchDrawable$getMinimumWidth() {
        return this.mBitmapWidth;
    }

    private final int $$robo$$android_graphics_drawable_NinePatchDrawable$getMinimumHeight() {
        return this.mBitmapHeight;
    }

    private final int $$robo$$android_graphics_drawable_NinePatchDrawable$getOpacity() {
        return this.mNinePatch.hasAlpha() || this.mPaint != null && this.mPaint.getAlpha() < 255 ? -3 : -1;
    }

    private final Region $$robo$$android_graphics_drawable_NinePatchDrawable$getTransparentRegion() {
        return this.mNinePatch.getTransparentRegion(this.getBounds());
    }

    private final Drawable.ConstantState $$robo$$android_graphics_drawable_NinePatchDrawable$getConstantState() {
        this.mNinePatchState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mNinePatchState;
    }

    private final Drawable $$robo$$android_graphics_drawable_NinePatchDrawable$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mNinePatchState = new NinePatchState(this.mNinePatchState);
            this.mNinePatch = this.mNinePatchState.mNinePatch;
            this.mMutated = true;
        }
        return this;
    }

    private final boolean $$robo$$android_graphics_drawable_NinePatchDrawable$onStateChange(int[] stateSet) {
        NinePatchState state = this.mNinePatchState;
        if (state.mTint != null && state.mTintMode != null) {
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, state.mTintMode);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_graphics_drawable_NinePatchDrawable$isStateful() {
        NinePatchState s = this.mNinePatchState;
        return super.isStateful() || s.mTint != null && s.mTint.isStateful();
    }

    private void $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(NinePatchState state, Resources res, Resources.Theme theme) {
        this.mOpticalInsets = Insets.NONE;
        this.mTargetDensity = 160;
        this.mBitmapWidth = -1;
        this.mBitmapHeight = -1;
        if (theme != null && state.canApplyTheme()) {
            this.mNinePatchState = new NinePatchState(state);
            this.applyTheme(theme);
        } else {
            this.mNinePatchState = state;
        }
        this.initializeWithState(state, res);
    }

    private final void $$robo$$android_graphics_drawable_NinePatchDrawable$initializeWithState(NinePatchState state, Resources res) {
        this.mTargetDensity = res != null ? res.getDisplayMetrics().densityDpi : state.mTargetDensity;
        if (state.mDither) {
            this.setDither(state.mDither);
        }
        if (state.mPadding != null) {
            this.mPadding = new Rect(state.mPadding);
        }
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, state.mTintMode);
        this.setNinePatch(state.mNinePatch);
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(NinePatchState x0, Resources x1, Resources.Theme x2, 1 x3) {
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__();
    }

    NinePatchDrawable() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(), 0, this);
    }

    private void __constructor__(Bitmap bitmap, byte[] byArray, Rect rect, String string2) {
        this.$$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(bitmap, byArray, rect, string2);
    }

    public NinePatchDrawable(Bitmap bitmap, byte[] byArray, Rect rect, String string2) {
        this(new NinePatchState(new NinePatch(bitmap, byArray, string2), rect), null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(android.graphics.Bitmap byte[] android.graphics.Rect java.lang.String ), 0, this, bitmap, byArray, rect, string2);
    }

    private void __constructor__(Resources resources, Bitmap bitmap, byte[] byArray, Rect rect, String string2) {
        this.$$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(resources, bitmap, byArray, rect, string2);
    }

    public NinePatchDrawable(Resources resources, Bitmap bitmap, byte[] byArray, Rect rect, String string2) {
        this(new NinePatchState(new NinePatch(bitmap, byArray, string2), rect), resources, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(android.content.res.Resources android.graphics.Bitmap byte[] android.graphics.Rect java.lang.String ), 0, this, resources, bitmap, byArray, rect, string2);
    }

    private void __constructor__(Resources resources, Bitmap bitmap, byte[] byArray, Rect rect, Rect rect2, String string2) {
        this.$$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(resources, bitmap, byArray, rect, rect2, string2);
    }

    public NinePatchDrawable(Resources resources, Bitmap bitmap, byte[] byArray, Rect rect, Rect rect2, String string2) {
        this(new NinePatchState(new NinePatch(bitmap, byArray, string2), rect, rect2), resources, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(android.content.res.Resources android.graphics.Bitmap byte[] android.graphics.Rect android.graphics.Rect java.lang.String ), 0, this, resources, bitmap, byArray, rect, rect2, string2);
    }

    private void __constructor__(NinePatch ninePatch) {
        this.$$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(ninePatch);
    }

    public NinePatchDrawable(NinePatch ninePatch) {
        this(new NinePatchState(ninePatch, new Rect()), null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(android.graphics.NinePatch ), 0, this, ninePatch);
    }

    private void __constructor__(Resources resources, NinePatch ninePatch) {
        this.$$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(resources, ninePatch);
    }

    public NinePatchDrawable(Resources resources, NinePatch ninePatch) {
        this(new NinePatchState(ninePatch, new Rect()), resources, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(android.content.res.Resources android.graphics.NinePatch ), 0, this, resources, ninePatch);
    }

    public void setTargetDensity(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("setTargetDensity", $$robo$$android_graphics_drawable_NinePatchDrawable$setTargetDensity(android.graphics.Canvas ), 0, this, canvas);
    }

    public void setTargetDensity(DisplayMetrics displayMetrics) {
        InvokeDynamicSupport.bootstrap("setTargetDensity", $$robo$$android_graphics_drawable_NinePatchDrawable$setTargetDensity(android.util.DisplayMetrics ), 0, this, displayMetrics);
    }

    public void setTargetDensity(int n) {
        InvokeDynamicSupport.bootstrap("setTargetDensity", $$robo$$android_graphics_drawable_NinePatchDrawable$setTargetDensity(int ), 0, this, n);
    }

    private static Insets scaleFromDensity(Insets insets, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("scaleFromDensity", $$robo$$android_graphics_drawable_NinePatchDrawable$scaleFromDensity(android.graphics.Insets int int ), 0, (Insets)insets, (int)n, (int)n2);
    }

    private void computeBitmapSize() {
        InvokeDynamicSupport.bootstrap("computeBitmapSize", $$robo$$android_graphics_drawable_NinePatchDrawable$computeBitmapSize(), 0, this);
    }

    private void setNinePatch(NinePatch ninePatch) {
        InvokeDynamicSupport.bootstrap("setNinePatch", $$robo$$android_graphics_drawable_NinePatchDrawable$setNinePatch(android.graphics.NinePatch ), 0, this, ninePatch);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_NinePatchDrawable$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_NinePatchDrawable$getChangingConfigurations(), 0, this);
    }

    @Override
    public boolean getPadding(Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getPadding", $$robo$$android_graphics_drawable_NinePatchDrawable$getPadding(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public void getOutline(Outline outline) {
        InvokeDynamicSupport.bootstrap("getOutline", $$robo$$android_graphics_drawable_NinePatchDrawable$getOutline(android.graphics.Outline ), 0, this, outline);
    }

    @Override
    public Insets getOpticalInsets() {
        return InvokeDynamicSupport.bootstrap("getOpticalInsets", $$robo$$android_graphics_drawable_NinePatchDrawable$getOpticalInsets(), 0, this);
    }

    @Override
    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_drawable_NinePatchDrawable$setAlpha(int ), 0, this, n);
    }

    @Override
    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_drawable_NinePatchDrawable$getAlpha(), 0, this);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_graphics_drawable_NinePatchDrawable$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setTintList", $$robo$$android_graphics_drawable_NinePatchDrawable$setTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setTintMode", $$robo$$android_graphics_drawable_NinePatchDrawable$setTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    @Override
    public void setDither(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDither", $$robo$$android_graphics_drawable_NinePatchDrawable$setDither(boolean ), 0, this, bl);
    }

    @Override
    public void setAutoMirrored(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAutoMirrored", $$robo$$android_graphics_drawable_NinePatchDrawable$setAutoMirrored(boolean ), 0, this, bl);
    }

    private boolean needsMirroring() {
        return (boolean)InvokeDynamicSupport.bootstrap("needsMirroring", $$robo$$android_graphics_drawable_NinePatchDrawable$needsMirroring(), 0, this);
    }

    @Override
    public boolean isAutoMirrored() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAutoMirrored", $$robo$$android_graphics_drawable_NinePatchDrawable$isAutoMirrored(), 0, this);
    }

    @Override
    public void setFilterBitmap(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFilterBitmap", $$robo$$android_graphics_drawable_NinePatchDrawable$setFilterBitmap(boolean ), 0, this, bl);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_NinePatchDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    private void updateStateFromTypedArray(TypedArray typedArray) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_NinePatchDrawable$updateStateFromTypedArray(android.content.res.TypedArray ), 0, this, typedArray);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_NinePatchDrawable$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
    }

    @Override
    public boolean canApplyTheme() {
        return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_NinePatchDrawable$canApplyTheme(), 0, this);
    }

    public Paint getPaint() {
        return InvokeDynamicSupport.bootstrap("getPaint", $$robo$$android_graphics_drawable_NinePatchDrawable$getPaint(), 0, this);
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicWidth", $$robo$$android_graphics_drawable_NinePatchDrawable$getIntrinsicWidth(), 0, this);
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicHeight", $$robo$$android_graphics_drawable_NinePatchDrawable$getIntrinsicHeight(), 0, this);
    }

    @Override
    public int getMinimumWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getMinimumWidth", $$robo$$android_graphics_drawable_NinePatchDrawable$getMinimumWidth(), 0, this);
    }

    @Override
    public int getMinimumHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getMinimumHeight", $$robo$$android_graphics_drawable_NinePatchDrawable$getMinimumHeight(), 0, this);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_NinePatchDrawable$getOpacity(), 0, this);
    }

    @Override
    public Region getTransparentRegion() {
        return InvokeDynamicSupport.bootstrap("getTransparentRegion", $$robo$$android_graphics_drawable_NinePatchDrawable$getTransparentRegion(), 0, this);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_graphics_drawable_NinePatchDrawable$getConstantState(), 0, this);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_NinePatchDrawable$mutate(), 0, this);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_NinePatchDrawable$onStateChange(int[] ), 0, this, nArray);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_NinePatchDrawable$isStateful(), 0, this);
    }

    private void __constructor__(NinePatchState ninePatchState, Resources resources, Resources.Theme theme) {
        this.$$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(ninePatchState, resources, theme);
    }

    private NinePatchDrawable(NinePatchState ninePatchState, Resources resources, Resources.Theme theme) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(android.graphics.drawable.NinePatchDrawable$NinePatchState android.content.res.Resources android.content.res.Resources$Theme ), 0, this, ninePatchState, resources, theme);
    }

    private void initializeWithState(NinePatchState ninePatchState, Resources resources) {
        InvokeDynamicSupport.bootstrap("initializeWithState", $$robo$$android_graphics_drawable_NinePatchDrawable$initializeWithState(android.graphics.drawable.NinePatchDrawable$NinePatchState android.content.res.Resources ), 0, this, ninePatchState, resources);
    }

    private /* synthetic */ void __constructor__(NinePatchState ninePatchState, Resources resources, Resources.Theme theme, 1 var4_4) {
        this.$$robo$$android_graphics_drawable_NinePatchDrawable$__constructor__(ninePatchState, resources, theme, var4_4);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NinePatchDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class NinePatchState
    extends Drawable.ConstantState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int[] mThemeAttrs;
        NinePatch mNinePatch;
        ColorStateList mTint;
        PorterDuff.Mode mTintMode;
        Rect mPadding;
        Insets mOpticalInsets;
        float mBaseAlpha;
        boolean mDither;
        int mTargetDensity;
        boolean mAutoMirrored;
        int mChangingConfigurations;

        private void $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__() {
            this.mThemeAttrs = null;
            this.mNinePatch = null;
            this.mTint = null;
            this.mTintMode = Drawable.DEFAULT_TINT_MODE;
            this.mPadding = null;
            this.mOpticalInsets = Insets.NONE;
            this.mBaseAlpha = 1.0f;
            this.mDither = false;
            this.mTargetDensity = 160;
            this.mAutoMirrored = false;
        }

        private void $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(NinePatch ninePatch, Rect padding) {
        }

        private void $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(NinePatch ninePatch, Rect padding, Rect opticalInsets) {
        }

        private void $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(NinePatch ninePatch, Rect padding, Rect opticalInsets, boolean dither, boolean autoMirror) {
            this.mThemeAttrs = null;
            this.mNinePatch = null;
            this.mTint = null;
            this.mTintMode = Drawable.DEFAULT_TINT_MODE;
            this.mPadding = null;
            this.mOpticalInsets = Insets.NONE;
            this.mBaseAlpha = 1.0f;
            this.mDither = false;
            this.mTargetDensity = 160;
            this.mAutoMirrored = false;
            this.mNinePatch = ninePatch;
            this.mPadding = padding;
            this.mOpticalInsets = Insets.of(opticalInsets);
            this.mDither = dither;
            this.mAutoMirrored = autoMirror;
        }

        private void $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(NinePatchState state) {
            this.mThemeAttrs = null;
            this.mNinePatch = null;
            this.mTint = null;
            this.mTintMode = Drawable.DEFAULT_TINT_MODE;
            this.mPadding = null;
            this.mOpticalInsets = Insets.NONE;
            this.mBaseAlpha = 1.0f;
            this.mDither = false;
            this.mTargetDensity = 160;
            this.mAutoMirrored = false;
            this.mNinePatch = state.mNinePatch;
            this.mTint = state.mTint;
            this.mTintMode = state.mTintMode;
            this.mThemeAttrs = state.mThemeAttrs;
            this.mPadding = state.mPadding;
            this.mOpticalInsets = state.mOpticalInsets;
            this.mBaseAlpha = state.mBaseAlpha;
            this.mDither = state.mDither;
            this.mChangingConfigurations = state.mChangingConfigurations;
            this.mTargetDensity = state.mTargetDensity;
            this.mAutoMirrored = state.mAutoMirrored;
        }

        private final boolean $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$canApplyTheme() {
            return this.mThemeAttrs != null;
        }

        private final Bitmap $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$getBitmap() {
            return this.mNinePatch.getBitmap();
        }

        private final Drawable $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$newDrawable() {
            return new NinePatchDrawable(this, null, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$newDrawable(Resources res) {
            return new NinePatchDrawable(this, res, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$newDrawable(Resources res, Resources.Theme theme) {
            return new NinePatchDrawable(this, res, theme);
        }

        private final int $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__();
        }

        NinePatchState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(), 0, this);
        }

        private void __constructor__(NinePatch ninePatch, Rect rect) {
            this.$$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(ninePatch, rect);
        }

        NinePatchState(NinePatch ninePatch, Rect rect) {
            this(ninePatch, rect, null, false, false);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(android.graphics.NinePatch android.graphics.Rect ), 0, this, ninePatch, rect);
        }

        private void __constructor__(NinePatch ninePatch, Rect rect, Rect rect2) {
            this.$$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(ninePatch, rect, rect2);
        }

        NinePatchState(NinePatch ninePatch, Rect rect, Rect rect2) {
            this(ninePatch, rect, rect2, false, false);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(android.graphics.NinePatch android.graphics.Rect android.graphics.Rect ), 0, this, ninePatch, rect, rect2);
        }

        private void __constructor__(NinePatch ninePatch, Rect rect, Rect rect2, boolean bl, boolean bl2) {
            this.$$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(ninePatch, rect, rect2, bl, bl2);
        }

        NinePatchState(NinePatch ninePatch, Rect rect, Rect rect2, boolean bl, boolean bl2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(android.graphics.NinePatch android.graphics.Rect android.graphics.Rect boolean boolean ), 0, this, ninePatch, rect, rect2, bl, bl2);
        }

        private void __constructor__(NinePatchState ninePatchState) {
            this.$$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(ninePatchState);
        }

        NinePatchState(NinePatchState ninePatchState) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$__constructor__(android.graphics.drawable.NinePatchDrawable$NinePatchState ), 0, this, ninePatchState);
        }

        @Override
        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$canApplyTheme(), 0, this);
        }

        @Override
        public Bitmap getBitmap() {
            return InvokeDynamicSupport.bootstrap("getBitmap", $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$getBitmap(), 0, this);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$newDrawable(), 0, this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        @Override
        public Drawable newDrawable(Resources resources, Resources.Theme theme) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$newDrawable(android.content.res.Resources android.content.res.Resources$Theme ), 0, this, resources, theme);
        }

        @Override
        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_NinePatchDrawable_NinePatchState$getChangingConfigurations(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NinePatchState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

