/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.graphics.Canvas;
import android.graphics.CanvasProperty;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.RippleDrawable;
import android.util.MathUtils;
import android.view.HardwareCanvas;
import android.view.RenderNodeAnimator;
import android.view.animation.LinearInterpolator;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Ripple
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static TimeInterpolator LINEAR_INTERPOLATOR;
    private static TimeInterpolator DECEL_INTERPOLATOR;
    private static float GLOBAL_SPEED = 1.0f;
    private static float WAVE_TOUCH_DOWN_ACCELERATION = 1024.0f;
    private static float WAVE_TOUCH_UP_ACCELERATION = 3400.0f;
    private static float WAVE_OPACITY_DECAY_VELOCITY = 3.0f;
    private static long RIPPLE_ENTER_DELAY = 80L;
    private ArrayList<RenderNodeAnimator> mRunningAnimations;
    private ArrayList<RenderNodeAnimator> mPendingAnimations;
    private RippleDrawable mOwner;
    private Rect mBounds;
    private int mColorOpaque;
    private float mOuterRadius;
    private float mDensity;
    private float mStartingX;
    private float mStartingY;
    private float mClampedStartingX;
    private float mClampedStartingY;
    private CanvasProperty<Paint> mPropPaint;
    private CanvasProperty<Float> mPropRadius;
    private CanvasProperty<Float> mPropX;
    private CanvasProperty<Float> mPropY;
    private ObjectAnimator mAnimRadius;
    private ObjectAnimator mAnimOpacity;
    private ObjectAnimator mAnimX;
    private ObjectAnimator mAnimY;
    private Paint mTempPaint;
    private float mOpacity;
    private float mOuterX;
    private float mOuterY;
    private float mTweenRadius;
    private float mTweenX;
    private float mTweenY;
    private boolean mHardwareAnimating;
    private boolean mCanUseHardware;
    private boolean mHasMaxRadius;
    private boolean mCanceled;
    private AnimatorListenerAdapter mAnimationListener;

    private void $$robo$$android_graphics_drawable_Ripple$__constructor__(RippleDrawable owner, Rect bounds, float startingX, float startingY) {
        this.mRunningAnimations = new ArrayList();
        this.mPendingAnimations = new ArrayList();
        this.mOpacity = 1.0f;
        this.mTweenRadius = 0.0f;
        this.mTweenX = 0.0f;
        this.mTweenY = 0.0f;
        this.mAnimationListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Ripple this$0;

            private void $$robo$$android_graphics_drawable_Ripple_1$__constructor__(Ripple ripple) {
            }

            private final void $$robo$$android_graphics_drawable_Ripple_1$onAnimationEnd(Animator animation) {
                this.this$0.removeSelf();
            }

            private void __constructor__(Ripple ripple) {
                this.$$robo$$android_graphics_drawable_Ripple_1$__constructor__(ripple);
            }
            {
                this.this$0 = ripple;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_Ripple_1$__constructor__(android.graphics.drawable.Ripple ), 0, this, ripple);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_graphics_drawable_Ripple_1$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mOwner = owner;
        this.mBounds = bounds;
        this.mStartingX = startingX;
        this.mStartingY = startingY;
    }

    private final void $$robo$$android_graphics_drawable_Ripple$setup(int maxRadius, int color2, float density) {
        this.mColorOpaque = color2 | 0xFF000000;
        if (maxRadius != -1) {
            this.mHasMaxRadius = true;
            this.mOuterRadius = maxRadius;
        } else {
            float halfWidth = (float)this.mBounds.width() / 2.0f;
            float halfHeight = (float)this.mBounds.height() / 2.0f;
            this.mOuterRadius = (float)Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
        }
        this.mOuterX = 0.0f;
        this.mOuterY = 0.0f;
        this.mDensity = density;
        this.clampStartingPosition();
    }

    private final boolean $$robo$$android_graphics_drawable_Ripple$isHardwareAnimating() {
        return this.mHardwareAnimating;
    }

    private final void $$robo$$android_graphics_drawable_Ripple$clampStartingPosition() {
        float r;
        float cY;
        float dY;
        float cX = this.mBounds.exactCenterX();
        float dX = this.mStartingX - cX;
        if (dX * dX + (dY = this.mStartingY - (cY = this.mBounds.exactCenterY())) * dY > (r = this.mOuterRadius) * r) {
            double angle = Math.atan2(dY, dX);
            this.mClampedStartingX = cX + (float)(Math.cos(angle) * (double)r);
            this.mClampedStartingY = cY + (float)(Math.sin(angle) * (double)r);
        } else {
            this.mClampedStartingX = this.mStartingX;
            this.mClampedStartingY = this.mStartingY;
        }
    }

    private final void $$robo$$android_graphics_drawable_Ripple$onHotspotBoundsChanged() {
        if (!this.mHasMaxRadius) {
            float halfWidth = (float)this.mBounds.width() / 2.0f;
            float halfHeight = (float)this.mBounds.height() / 2.0f;
            this.mOuterRadius = (float)Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
            this.clampStartingPosition();
        }
    }

    private final void $$robo$$android_graphics_drawable_Ripple$setOpacity(float a) {
        this.mOpacity = a;
        this.invalidateSelf();
    }

    private final float $$robo$$android_graphics_drawable_Ripple$getOpacity() {
        return this.mOpacity;
    }

    private final void $$robo$$android_graphics_drawable_Ripple$setRadiusGravity(float r) {
        this.mTweenRadius = r;
        this.invalidateSelf();
    }

    private final float $$robo$$android_graphics_drawable_Ripple$getRadiusGravity() {
        return this.mTweenRadius;
    }

    private final void $$robo$$android_graphics_drawable_Ripple$setXGravity(float x) {
        this.mTweenX = x;
        this.invalidateSelf();
    }

    private final float $$robo$$android_graphics_drawable_Ripple$getXGravity() {
        return this.mTweenX;
    }

    private final void $$robo$$android_graphics_drawable_Ripple$setYGravity(float y) {
        this.mTweenY = y;
        this.invalidateSelf();
    }

    private final float $$robo$$android_graphics_drawable_Ripple$getYGravity() {
        return this.mTweenY;
    }

    private final boolean $$robo$$android_graphics_drawable_Ripple$draw(Canvas c, Paint p) {
        boolean canUseHardware = c.isHardwareAccelerated();
        if (this.mCanUseHardware != canUseHardware && this.mCanUseHardware) {
            this.cancelHardwareAnimations(true);
        }
        this.mCanUseHardware = canUseHardware;
        boolean hasContent = canUseHardware && this.mHardwareAnimating ? this.drawHardware((HardwareCanvas)c) : this.drawSoftware(c, p);
        return hasContent;
    }

    private final boolean $$robo$$android_graphics_drawable_Ripple$drawHardware(HardwareCanvas c) {
        ArrayList<RenderNodeAnimator> pendingAnimations = this.mPendingAnimations;
        int N = pendingAnimations.size();
        if (N > 0) {
            this.cancelHardwareAnimations(false);
            this.mHardwareAnimating = true;
            for (int i = 0; i < N; ++i) {
                pendingAnimations.get(i).setTarget(c);
                pendingAnimations.get(i).start();
            }
            this.mRunningAnimations.addAll(pendingAnimations);
            pendingAnimations.clear();
        }
        c.drawCircle(this.mPropX, this.mPropY, this.mPropRadius, this.mPropPaint);
        return true;
    }

    private final boolean $$robo$$android_graphics_drawable_Ripple$drawSoftware(Canvas c, Paint p) {
        boolean hasContent = false;
        p.setColor(this.mColorOpaque);
        int alpha = (int)(255.0f * this.mOpacity + 0.5f);
        float radius = MathUtils.lerp(0.0f, this.mOuterRadius, this.mTweenRadius);
        if (alpha > 0 && radius > 0.0f) {
            float x = MathUtils.lerp(this.mClampedStartingX - this.mBounds.exactCenterX(), this.mOuterX, this.mTweenX);
            float y = MathUtils.lerp(this.mClampedStartingY - this.mBounds.exactCenterY(), this.mOuterY, this.mTweenY);
            p.setAlpha(alpha);
            p.setStyle(Paint.Style.FILL);
            c.drawCircle(x, y, radius, p);
            hasContent = true;
        }
        return hasContent;
    }

    private final void $$robo$$android_graphics_drawable_Ripple$getBounds(Rect bounds) {
        int outerX = (int)this.mOuterX;
        int outerY = (int)this.mOuterY;
        int r = (int)this.mOuterRadius + 1;
        bounds.set(outerX - r, outerY - r, outerX + r, outerY + r);
    }

    private final void $$robo$$android_graphics_drawable_Ripple$move(float x, float y) {
        this.mStartingX = x;
        this.mStartingY = y;
        this.clampStartingPosition();
    }

    private final void $$robo$$android_graphics_drawable_Ripple$enter() {
        this.cancel();
        int radiusDuration = (int)(1000.0 * Math.sqrt(this.mOuterRadius / 1024.0f * this.mDensity) + 0.5);
        ObjectAnimator radius = ObjectAnimator.ofFloat((Object)this, "radiusGravity", 1.0f);
        radius.setAutoCancel(true);
        radius.setDuration(radiusDuration);
        radius.setInterpolator(LINEAR_INTERPOLATOR);
        radius.setStartDelay(80L);
        ObjectAnimator cX = ObjectAnimator.ofFloat((Object)this, "xGravity", 1.0f);
        cX.setAutoCancel(true);
        cX.setDuration(radiusDuration);
        cX.setInterpolator(LINEAR_INTERPOLATOR);
        cX.setStartDelay(80L);
        ObjectAnimator cY = ObjectAnimator.ofFloat((Object)this, "yGravity", 1.0f);
        cY.setAutoCancel(true);
        cY.setDuration(radiusDuration);
        cY.setInterpolator(LINEAR_INTERPOLATOR);
        cY.setStartDelay(80L);
        this.mAnimRadius = radius;
        this.mAnimX = cX;
        this.mAnimY = cY;
        radius.start();
        cX.start();
        cY.start();
    }

    private final void $$robo$$android_graphics_drawable_Ripple$exit() {
        this.cancel();
        float radius = MathUtils.lerp(0.0f, this.mOuterRadius, this.mTweenRadius);
        float remaining = this.mAnimRadius != null && this.mAnimRadius.isRunning() ? this.mOuterRadius - radius : this.mOuterRadius;
        int radiusDuration = (int)(1000.0 * Math.sqrt(remaining / 4424.0f * this.mDensity) + 0.5);
        int opacityDuration = (int)(1000.0f * this.mOpacity / 3.0f + 0.5f);
        if (this.mCanUseHardware) {
            this.exitHardware(radiusDuration, opacityDuration);
        } else {
            this.exitSoftware(radiusDuration, opacityDuration);
        }
    }

    private final void $$robo$$android_graphics_drawable_Ripple$exitHardware(int radiusDuration, int opacityDuration) {
        this.mPendingAnimations.clear();
        float startX = MathUtils.lerp(this.mClampedStartingX - this.mBounds.exactCenterX(), this.mOuterX, this.mTweenX);
        float startY = MathUtils.lerp(this.mClampedStartingY - this.mBounds.exactCenterY(), this.mOuterY, this.mTweenY);
        float startRadius = MathUtils.lerp(0.0f, this.mOuterRadius, this.mTweenRadius);
        Paint paint = this.getTempPaint();
        paint.setAntiAlias(true);
        paint.setColor(this.mColorOpaque);
        paint.setAlpha((int)(255.0f * this.mOpacity + 0.5f));
        paint.setStyle(Paint.Style.FILL);
        this.mPropPaint = CanvasProperty.createPaint(paint);
        this.mPropRadius = CanvasProperty.createFloat(startRadius);
        this.mPropX = CanvasProperty.createFloat(startX);
        this.mPropY = CanvasProperty.createFloat(startY);
        RenderNodeAnimator radiusAnim = new RenderNodeAnimator(this.mPropRadius, this.mOuterRadius);
        radiusAnim.setDuration(radiusDuration);
        radiusAnim.setInterpolator(DECEL_INTERPOLATOR);
        RenderNodeAnimator xAnim = new RenderNodeAnimator(this.mPropX, this.mOuterX);
        xAnim.setDuration(radiusDuration);
        xAnim.setInterpolator(DECEL_INTERPOLATOR);
        RenderNodeAnimator yAnim = new RenderNodeAnimator(this.mPropY, this.mOuterY);
        yAnim.setDuration(radiusDuration);
        yAnim.setInterpolator(DECEL_INTERPOLATOR);
        RenderNodeAnimator opacityAnim = new RenderNodeAnimator(this.mPropPaint, 1, 0.0f);
        opacityAnim.setDuration(opacityDuration);
        opacityAnim.setInterpolator(LINEAR_INTERPOLATOR);
        opacityAnim.addListener(this.mAnimationListener);
        this.mPendingAnimations.add(radiusAnim);
        this.mPendingAnimations.add(opacityAnim);
        this.mPendingAnimations.add(xAnim);
        this.mPendingAnimations.add(yAnim);
        this.mHardwareAnimating = true;
        this.mOpacity = 0.0f;
        this.mTweenX = 1.0f;
        this.mTweenY = 1.0f;
        this.mTweenRadius = 1.0f;
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_Ripple$jump() {
        this.mCanceled = true;
        this.endSoftwareAnimations();
        this.cancelHardwareAnimations(true);
        this.mCanceled = false;
    }

    private final void $$robo$$android_graphics_drawable_Ripple$endSoftwareAnimations() {
        if (this.mAnimRadius != null) {
            this.mAnimRadius.end();
            this.mAnimRadius = null;
        }
        if (this.mAnimOpacity != null) {
            this.mAnimOpacity.end();
            this.mAnimOpacity = null;
        }
        if (this.mAnimX != null) {
            this.mAnimX.end();
            this.mAnimX = null;
        }
        if (this.mAnimY != null) {
            this.mAnimY.end();
            this.mAnimY = null;
        }
    }

    private final Paint $$robo$$android_graphics_drawable_Ripple$getTempPaint() {
        if (this.mTempPaint == null) {
            this.mTempPaint = new Paint();
        }
        return this.mTempPaint;
    }

    private final void $$robo$$android_graphics_drawable_Ripple$exitSoftware(int radiusDuration, int opacityDuration) {
        ObjectAnimator radiusAnim = ObjectAnimator.ofFloat((Object)this, "radiusGravity", 1.0f);
        radiusAnim.setAutoCancel(true);
        radiusAnim.setDuration(radiusDuration);
        radiusAnim.setInterpolator(DECEL_INTERPOLATOR);
        ObjectAnimator xAnim = ObjectAnimator.ofFloat((Object)this, "xGravity", 1.0f);
        xAnim.setAutoCancel(true);
        xAnim.setDuration(radiusDuration);
        xAnim.setInterpolator(DECEL_INTERPOLATOR);
        ObjectAnimator yAnim = ObjectAnimator.ofFloat((Object)this, "yGravity", 1.0f);
        yAnim.setAutoCancel(true);
        yAnim.setDuration(radiusDuration);
        yAnim.setInterpolator(DECEL_INTERPOLATOR);
        ObjectAnimator opacityAnim = ObjectAnimator.ofFloat((Object)this, "opacity", 0.0f);
        opacityAnim.setAutoCancel(true);
        opacityAnim.setDuration(opacityDuration);
        opacityAnim.setInterpolator(LINEAR_INTERPOLATOR);
        opacityAnim.addListener(this.mAnimationListener);
        this.mAnimRadius = radiusAnim;
        this.mAnimOpacity = opacityAnim;
        this.mAnimX = xAnim;
        this.mAnimY = yAnim;
        radiusAnim.start();
        opacityAnim.start();
        xAnim.start();
        yAnim.start();
    }

    private final void $$robo$$android_graphics_drawable_Ripple$cancel() {
        this.mCanceled = true;
        this.cancelSoftwareAnimations();
        this.cancelHardwareAnimations(true);
        this.mCanceled = false;
    }

    private final void $$robo$$android_graphics_drawable_Ripple$cancelSoftwareAnimations() {
        if (this.mAnimRadius != null) {
            this.mAnimRadius.cancel();
            this.mAnimRadius = null;
        }
        if (this.mAnimOpacity != null) {
            this.mAnimOpacity.cancel();
            this.mAnimOpacity = null;
        }
        if (this.mAnimX != null) {
            this.mAnimX.cancel();
            this.mAnimX = null;
        }
        if (this.mAnimY != null) {
            this.mAnimY.cancel();
            this.mAnimY = null;
        }
    }

    private final void $$robo$$android_graphics_drawable_Ripple$cancelHardwareAnimations(boolean cancelPending) {
        ArrayList<RenderNodeAnimator> runningAnimations = this.mRunningAnimations;
        int N = runningAnimations.size();
        for (int i = 0; i < N; ++i) {
            runningAnimations.get(i).cancel();
        }
        runningAnimations.clear();
        if (cancelPending && !this.mPendingAnimations.isEmpty()) {
            this.mPendingAnimations.clear();
        }
        this.mHardwareAnimating = false;
    }

    private final void $$robo$$android_graphics_drawable_Ripple$removeSelf() {
        if (!this.mCanceled) {
            this.mOwner.removeRipple(this);
        }
    }

    private final void $$robo$$android_graphics_drawable_Ripple$invalidateSelf() {
        this.mOwner.invalidateSelf();
    }

    static void __staticInitializer__() {
        LINEAR_INTERPOLATOR = new LinearInterpolator();
        DECEL_INTERPOLATOR = new LogInterpolator();
    }

    private void __constructor__(RippleDrawable rippleDrawable, Rect rect, float f, float f2) {
        this.$$robo$$android_graphics_drawable_Ripple$__constructor__(rippleDrawable, rect, f, f2);
    }

    public Ripple(RippleDrawable rippleDrawable, Rect rect, float f, float f2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_Ripple$__constructor__(android.graphics.drawable.RippleDrawable android.graphics.Rect float float ), 0, this, rippleDrawable, rect, f, f2);
    }

    public void setup(int n, int n2, float f) {
        InvokeDynamicSupport.bootstrap("setup", $$robo$$android_graphics_drawable_Ripple$setup(int int float ), 0, this, n, n2, f);
    }

    public boolean isHardwareAnimating() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHardwareAnimating", $$robo$$android_graphics_drawable_Ripple$isHardwareAnimating(), 0, this);
    }

    private void clampStartingPosition() {
        InvokeDynamicSupport.bootstrap("clampStartingPosition", $$robo$$android_graphics_drawable_Ripple$clampStartingPosition(), 0, this);
    }

    public void onHotspotBoundsChanged() {
        InvokeDynamicSupport.bootstrap("onHotspotBoundsChanged", $$robo$$android_graphics_drawable_Ripple$onHotspotBoundsChanged(), 0, this);
    }

    public void setOpacity(float f) {
        InvokeDynamicSupport.bootstrap("setOpacity", $$robo$$android_graphics_drawable_Ripple$setOpacity(float ), 0, this, f);
    }

    public float getOpacity() {
        return (float)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_Ripple$getOpacity(), 0, this);
    }

    public void setRadiusGravity(float f) {
        InvokeDynamicSupport.bootstrap("setRadiusGravity", $$robo$$android_graphics_drawable_Ripple$setRadiusGravity(float ), 0, this, f);
    }

    public float getRadiusGravity() {
        return (float)InvokeDynamicSupport.bootstrap("getRadiusGravity", $$robo$$android_graphics_drawable_Ripple$getRadiusGravity(), 0, this);
    }

    public void setXGravity(float f) {
        InvokeDynamicSupport.bootstrap("setXGravity", $$robo$$android_graphics_drawable_Ripple$setXGravity(float ), 0, this, f);
    }

    public float getXGravity() {
        return (float)InvokeDynamicSupport.bootstrap("getXGravity", $$robo$$android_graphics_drawable_Ripple$getXGravity(), 0, this);
    }

    public void setYGravity(float f) {
        InvokeDynamicSupport.bootstrap("setYGravity", $$robo$$android_graphics_drawable_Ripple$setYGravity(float ), 0, this, f);
    }

    public float getYGravity() {
        return (float)InvokeDynamicSupport.bootstrap("getYGravity", $$robo$$android_graphics_drawable_Ripple$getYGravity(), 0, this);
    }

    public boolean draw(Canvas canvas, Paint paint) {
        return (boolean)InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_Ripple$draw(android.graphics.Canvas android.graphics.Paint ), 0, this, canvas, paint);
    }

    private boolean drawHardware(HardwareCanvas hardwareCanvas) {
        return (boolean)InvokeDynamicSupport.bootstrap("drawHardware", $$robo$$android_graphics_drawable_Ripple$drawHardware(android.view.HardwareCanvas ), 0, this, hardwareCanvas);
    }

    private boolean drawSoftware(Canvas canvas, Paint paint) {
        return (boolean)InvokeDynamicSupport.bootstrap("drawSoftware", $$robo$$android_graphics_drawable_Ripple$drawSoftware(android.graphics.Canvas android.graphics.Paint ), 0, this, canvas, paint);
    }

    public void getBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("getBounds", $$robo$$android_graphics_drawable_Ripple$getBounds(android.graphics.Rect ), 0, this, rect);
    }

    public void move(float f, float f2) {
        InvokeDynamicSupport.bootstrap("move", $$robo$$android_graphics_drawable_Ripple$move(float float ), 0, this, f, f2);
    }

    public void enter() {
        InvokeDynamicSupport.bootstrap("enter", $$robo$$android_graphics_drawable_Ripple$enter(), 0, this);
    }

    public void exit() {
        InvokeDynamicSupport.bootstrap("exit", $$robo$$android_graphics_drawable_Ripple$exit(), 0, this);
    }

    private void exitHardware(int n, int n2) {
        InvokeDynamicSupport.bootstrap("exitHardware", $$robo$$android_graphics_drawable_Ripple$exitHardware(int int ), 0, this, n, n2);
    }

    public void jump() {
        InvokeDynamicSupport.bootstrap("jump", $$robo$$android_graphics_drawable_Ripple$jump(), 0, this);
    }

    private void endSoftwareAnimations() {
        InvokeDynamicSupport.bootstrap("endSoftwareAnimations", $$robo$$android_graphics_drawable_Ripple$endSoftwareAnimations(), 0, this);
    }

    private Paint getTempPaint() {
        return InvokeDynamicSupport.bootstrap("getTempPaint", $$robo$$android_graphics_drawable_Ripple$getTempPaint(), 0, this);
    }

    private void exitSoftware(int n, int n2) {
        InvokeDynamicSupport.bootstrap("exitSoftware", $$robo$$android_graphics_drawable_Ripple$exitSoftware(int int ), 0, this, n, n2);
    }

    public void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_graphics_drawable_Ripple$cancel(), 0, this);
    }

    private void cancelSoftwareAnimations() {
        InvokeDynamicSupport.bootstrap("cancelSoftwareAnimations", $$robo$$android_graphics_drawable_Ripple$cancelSoftwareAnimations(), 0, this);
    }

    private void cancelHardwareAnimations(boolean bl) {
        InvokeDynamicSupport.bootstrap("cancelHardwareAnimations", $$robo$$android_graphics_drawable_Ripple$cancelHardwareAnimations(boolean ), 0, this, bl);
    }

    private void removeSelf() {
        InvokeDynamicSupport.bootstrap("removeSelf", $$robo$$android_graphics_drawable_Ripple$removeSelf(), 0, this);
    }

    private void invalidateSelf() {
        InvokeDynamicSupport.bootstrap("invalidateSelf", $$robo$$android_graphics_drawable_Ripple$invalidateSelf(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(Ripple.class);
    }

    public /* synthetic */ Ripple() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Ripple)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class LogInterpolator
    implements TimeInterpolator,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_graphics_drawable_Ripple_LogInterpolator$__constructor__() {
        }

        private final float $$robo$$android_graphics_drawable_Ripple_LogInterpolator$getInterpolation(float input) {
            return 1.0f - (float)Math.pow(400.0, (double)(-input) * 1.4);
        }

        private /* synthetic */ void $$robo$$android_graphics_drawable_Ripple_LogInterpolator$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_drawable_Ripple_LogInterpolator$__constructor__();
        }

        private LogInterpolator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_Ripple_LogInterpolator$__constructor__(), 0, this);
        }

        @Override
        public float getInterpolation(float f) {
            return (float)InvokeDynamicSupport.bootstrap("getInterpolation", $$robo$$android_graphics_drawable_Ripple_LogInterpolator$getInterpolation(float ), 0, this, f);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_graphics_drawable_Ripple_LogInterpolator$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LogInterpolator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

