/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.graphics.Canvas;
import android.graphics.CanvasProperty;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.RippleDrawable;
import android.util.MathUtils;
import android.view.HardwareCanvas;
import android.view.RenderNodeAnimator;
import android.view.animation.LinearInterpolator;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RippleBackground
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static TimeInterpolator LINEAR_INTERPOLATOR;
    private static float GLOBAL_SPEED = 1.0f;
    private static float WAVE_OPACITY_DECAY_VELOCITY = 3.0f;
    private static float WAVE_OUTER_OPACITY_EXIT_VELOCITY_MAX = 4.5f;
    private static float WAVE_OUTER_OPACITY_EXIT_VELOCITY_MIN = 1.5f;
    private static float WAVE_OUTER_OPACITY_ENTER_VELOCITY = 10.0f;
    private static float WAVE_OUTER_SIZE_INFLUENCE_MAX = 200.0f;
    private static float WAVE_OUTER_SIZE_INFLUENCE_MIN = 40.0f;
    private ArrayList<RenderNodeAnimator> mRunningAnimations;
    private ArrayList<RenderNodeAnimator> mPendingAnimations;
    private RippleDrawable mOwner;
    private Rect mBounds;
    private int mColorOpaque;
    private int mColorAlpha;
    private float mOuterRadius;
    private float mDensity;
    private CanvasProperty<Paint> mPropOuterPaint;
    private CanvasProperty<Float> mPropOuterRadius;
    private CanvasProperty<Float> mPropOuterX;
    private CanvasProperty<Float> mPropOuterY;
    private ObjectAnimator mAnimOuterOpacity;
    private Paint mTempPaint;
    private float mOuterOpacity;
    private float mOuterX;
    private float mOuterY;
    private boolean mHardwareAnimating;
    private boolean mCanUseHardware;
    private boolean mHasMaxRadius;
    private AnimatorListenerAdapter mAnimationListener;

    private void $$robo$$android_graphics_drawable_RippleBackground$__constructor__(RippleDrawable owner, Rect bounds) {
        this.mRunningAnimations = new ArrayList();
        this.mPendingAnimations = new ArrayList();
        this.mOuterOpacity = 0.0f;
        this.mAnimationListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ RippleBackground this$0;

            private void $$robo$$android_graphics_drawable_RippleBackground_2$__constructor__(RippleBackground rippleBackground) {
            }

            private final void $$robo$$android_graphics_drawable_RippleBackground_2$onAnimationEnd(Animator animation) {
                this.this$0.mHardwareAnimating = false;
            }

            private void __constructor__(RippleBackground rippleBackground) {
                this.$$robo$$android_graphics_drawable_RippleBackground_2$__constructor__(rippleBackground);
            }
            {
                this.this$0 = rippleBackground;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleBackground_2$__constructor__(android.graphics.drawable.RippleBackground ), 0, this, rippleBackground);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_graphics_drawable_RippleBackground_2$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mOwner = owner;
        this.mBounds = bounds;
    }

    private final void $$robo$$android_graphics_drawable_RippleBackground$setup(int maxRadius, int color2, float density) {
        this.mColorOpaque = color2 | 0xFF000000;
        this.mColorAlpha = Color.alpha(color2) / 2;
        if (maxRadius != -1) {
            this.mHasMaxRadius = true;
            this.mOuterRadius = maxRadius;
        } else {
            float halfWidth = (float)this.mBounds.width() / 2.0f;
            float halfHeight = (float)this.mBounds.height() / 2.0f;
            this.mOuterRadius = (float)Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
        }
        this.mOuterX = 0.0f;
        this.mOuterY = 0.0f;
        this.mDensity = density;
    }

    private final boolean $$robo$$android_graphics_drawable_RippleBackground$isHardwareAnimating() {
        return this.mHardwareAnimating;
    }

    private final void $$robo$$android_graphics_drawable_RippleBackground$onHotspotBoundsChanged() {
        if (!this.mHasMaxRadius) {
            float halfWidth = (float)this.mBounds.width() / 2.0f;
            float halfHeight = (float)this.mBounds.height() / 2.0f;
            this.mOuterRadius = (float)Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleBackground$setOuterOpacity(float a) {
        this.mOuterOpacity = a;
        this.invalidateSelf();
    }

    private final float $$robo$$android_graphics_drawable_RippleBackground$getOuterOpacity() {
        return this.mOuterOpacity;
    }

    private final boolean $$robo$$android_graphics_drawable_RippleBackground$draw(Canvas c, Paint p) {
        boolean canUseHardware = c.isHardwareAccelerated();
        if (this.mCanUseHardware != canUseHardware && this.mCanUseHardware) {
            this.cancelHardwareAnimations(true);
        }
        this.mCanUseHardware = canUseHardware;
        boolean hasContent = canUseHardware && this.mHardwareAnimating ? this.drawHardware((HardwareCanvas)c) : this.drawSoftware(c, p);
        return hasContent;
    }

    private final boolean $$robo$$android_graphics_drawable_RippleBackground$shouldDraw() {
        int outerAlpha = (int)((float)this.mColorAlpha * this.mOuterOpacity + 0.5f);
        return this.mCanUseHardware && this.mHardwareAnimating || outerAlpha > 0 && this.mOuterRadius > 0.0f;
    }

    private final boolean $$robo$$android_graphics_drawable_RippleBackground$drawHardware(HardwareCanvas c) {
        ArrayList<RenderNodeAnimator> pendingAnimations = this.mPendingAnimations;
        int N = pendingAnimations.size();
        if (N > 0) {
            this.cancelHardwareAnimations(false);
            this.mHardwareAnimating = true;
            for (int i = 0; i < N; ++i) {
                pendingAnimations.get(i).setTarget(c);
                pendingAnimations.get(i).start();
            }
            this.mRunningAnimations.addAll(pendingAnimations);
            pendingAnimations.clear();
        }
        c.drawCircle(this.mPropOuterX, this.mPropOuterY, this.mPropOuterRadius, this.mPropOuterPaint);
        return true;
    }

    private final boolean $$robo$$android_graphics_drawable_RippleBackground$drawSoftware(Canvas c, Paint p) {
        boolean hasContent = false;
        p.setColor(this.mColorOpaque);
        int outerAlpha = (int)((float)this.mColorAlpha * this.mOuterOpacity + 0.5f);
        if (outerAlpha > 0 && this.mOuterRadius > 0.0f) {
            p.setAlpha(outerAlpha);
            p.setStyle(Paint.Style.FILL);
            c.drawCircle(this.mOuterX, this.mOuterY, this.mOuterRadius, p);
            hasContent = true;
        }
        return hasContent;
    }

    private final void $$robo$$android_graphics_drawable_RippleBackground$getBounds(Rect bounds) {
        int outerX = (int)this.mOuterX;
        int outerY = (int)this.mOuterY;
        int r = (int)this.mOuterRadius + 1;
        bounds.set(outerX - r, outerY - r, outerX + r, outerY + r);
    }

    private final void $$robo$$android_graphics_drawable_RippleBackground$enter() {
        this.cancel();
        int outerDuration = 100;
        ObjectAnimator outer = ObjectAnimator.ofFloat((Object)this, "outerOpacity", 0.0f, 1.0f);
        outer.setAutoCancel(true);
        outer.setDuration(100L);
        outer.setInterpolator(LINEAR_INTERPOLATOR);
        this.mAnimOuterOpacity = outer;
        outer.start();
    }

    private final void $$robo$$android_graphics_drawable_RippleBackground$exit() {
        this.cancel();
        int opacityDuration = 333;
        float outerSizeInfluence = MathUtils.constrain((this.mOuterRadius - 40.0f * this.mDensity) / (200.0f * this.mDensity), 0.0f, 1.0f);
        float outerOpacityVelocity = MathUtils.lerp(1.5f, 4.5f, outerSizeInfluence);
        int inflectionDuration = Math.max(0, (int)(1000.0f * (1.0f - this.mOuterOpacity) / (3.0f + outerOpacityVelocity) + 0.5f));
        int inflectionOpacity = (int)((float)this.mColorAlpha * (this.mOuterOpacity + (float)inflectionDuration * outerOpacityVelocity * outerSizeInfluence / 1000.0f) + 0.5f);
        if (this.mCanUseHardware) {
            this.exitHardware(333, inflectionDuration, inflectionOpacity);
        } else {
            this.exitSoftware(333, inflectionDuration, inflectionOpacity);
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleBackground$exitHardware(int opacityDuration, int inflectionDuration, int inflectionOpacity) {
        RenderNodeAnimator outerOpacityAnim;
        this.mPendingAnimations.clear();
        Paint outerPaint = this.getTempPaint();
        outerPaint.setAntiAlias(true);
        outerPaint.setColor(this.mColorOpaque);
        outerPaint.setAlpha((int)((float)this.mColorAlpha * this.mOuterOpacity + 0.5f));
        outerPaint.setStyle(Paint.Style.FILL);
        this.mPropOuterPaint = CanvasProperty.createPaint(outerPaint);
        this.mPropOuterRadius = CanvasProperty.createFloat(this.mOuterRadius);
        this.mPropOuterX = CanvasProperty.createFloat(this.mOuterX);
        this.mPropOuterY = CanvasProperty.createFloat(this.mOuterY);
        if (inflectionDuration > 0) {
            outerOpacityAnim = new RenderNodeAnimator(this.mPropOuterPaint, 1, inflectionOpacity);
            outerOpacityAnim.setDuration(inflectionDuration);
            outerOpacityAnim.setInterpolator(LINEAR_INTERPOLATOR);
            int outerDuration = opacityDuration - inflectionDuration;
            if (outerDuration > 0) {
                RenderNodeAnimator outerFadeOutAnim = new RenderNodeAnimator(this.mPropOuterPaint, 1, 0.0f);
                outerFadeOutAnim.setDuration(outerDuration);
                outerFadeOutAnim.setInterpolator(LINEAR_INTERPOLATOR);
                outerFadeOutAnim.setStartDelay(inflectionDuration);
                outerFadeOutAnim.setStartValue(inflectionOpacity);
                outerFadeOutAnim.addListener(this.mAnimationListener);
                this.mPendingAnimations.add(outerFadeOutAnim);
            } else {
                outerOpacityAnim.addListener(this.mAnimationListener);
            }
        } else {
            outerOpacityAnim = new RenderNodeAnimator(this.mPropOuterPaint, 1, 0.0f);
            outerOpacityAnim.setInterpolator(LINEAR_INTERPOLATOR);
            outerOpacityAnim.setDuration(opacityDuration);
            outerOpacityAnim.addListener(this.mAnimationListener);
        }
        this.mPendingAnimations.add(outerOpacityAnim);
        this.mHardwareAnimating = true;
        this.mOuterOpacity = 0.0f;
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_RippleBackground$jump() {
        this.endSoftwareAnimations();
        this.cancelHardwareAnimations(true);
    }

    private final void $$robo$$android_graphics_drawable_RippleBackground$endSoftwareAnimations() {
        if (this.mAnimOuterOpacity != null) {
            this.mAnimOuterOpacity.end();
            this.mAnimOuterOpacity = null;
        }
    }

    private final Paint $$robo$$android_graphics_drawable_RippleBackground$getTempPaint() {
        if (this.mTempPaint == null) {
            this.mTempPaint = new Paint();
        }
        return this.mTempPaint;
    }

    private final void $$robo$$android_graphics_drawable_RippleBackground$exitSoftware(int opacityDuration, int inflectionDuration, int inflectionOpacity) {
        ObjectAnimator outerOpacityAnim;
        if (inflectionDuration > 0) {
            outerOpacityAnim = ObjectAnimator.ofFloat((Object)this, "outerOpacity", (float)inflectionOpacity / 255.0f);
            outerOpacityAnim.setAutoCancel(true);
            outerOpacityAnim.setDuration(inflectionDuration);
            outerOpacityAnim.setInterpolator(LINEAR_INTERPOLATOR);
            int outerDuration = opacityDuration - inflectionDuration;
            if (outerDuration > 0) {
                outerOpacityAnim.addListener((Animator.AnimatorListener)new ShadowedObject(this, outerDuration){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$outerDuration;
                    /* synthetic */ RippleBackground this$0;

                    private void $$robo$$android_graphics_drawable_RippleBackground_1$__constructor__(RippleBackground rippleBackground, int n) {
                    }

                    private final void $$robo$$android_graphics_drawable_RippleBackground_1$onAnimationEnd(Animator animation) {
                        ObjectAnimator outerFadeOutAnim = ObjectAnimator.ofFloat((Object)this.this$0, "outerOpacity", 0.0f);
                        outerFadeOutAnim.setAutoCancel(true);
                        outerFadeOutAnim.setDuration(this.val$outerDuration);
                        outerFadeOutAnim.setInterpolator(LINEAR_INTERPOLATOR);
                        outerFadeOutAnim.addListener(this.this$0.mAnimationListener);
                        this.this$0.mAnimOuterOpacity = outerFadeOutAnim;
                        outerFadeOutAnim.start();
                    }

                    private final void $$robo$$android_graphics_drawable_RippleBackground_1$onAnimationCancel(Animator animation) {
                        animation.removeListener(this);
                    }

                    private void __constructor__(RippleBackground rippleBackground, int n) {
                        this.$$robo$$android_graphics_drawable_RippleBackground_1$__constructor__(rippleBackground, n);
                    }
                    {
                        this.this$0 = rippleBackground;
                        this.val$outerDuration = n;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleBackground_1$__constructor__(android.graphics.drawable.RippleBackground int ), 0, this, rippleBackground, n);
                    }

                    @Override
                    public void onAnimationEnd(Animator animator2) {
                        InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_graphics_drawable_RippleBackground_1$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
                    }

                    @Override
                    public void onAnimationCancel(Animator animator2) {
                        InvokeDynamicSupport.bootstrap("onAnimationCancel", $$robo$$android_graphics_drawable_RippleBackground_1$onAnimationCancel(android.animation.Animator ), 0, this, animator2);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            } else {
                outerOpacityAnim.addListener(this.mAnimationListener);
            }
        } else {
            outerOpacityAnim = ObjectAnimator.ofFloat((Object)this, "outerOpacity", 0.0f);
            outerOpacityAnim.setAutoCancel(true);
            outerOpacityAnim.setDuration(opacityDuration);
            outerOpacityAnim.addListener(this.mAnimationListener);
        }
        this.mAnimOuterOpacity = outerOpacityAnim;
        outerOpacityAnim.start();
    }

    private final void $$robo$$android_graphics_drawable_RippleBackground$cancel() {
        this.cancelSoftwareAnimations();
        this.cancelHardwareAnimations(true);
    }

    private final void $$robo$$android_graphics_drawable_RippleBackground$cancelSoftwareAnimations() {
        if (this.mAnimOuterOpacity != null) {
            this.mAnimOuterOpacity.cancel();
            this.mAnimOuterOpacity = null;
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleBackground$cancelHardwareAnimations(boolean cancelPending) {
        ArrayList<RenderNodeAnimator> runningAnimations = this.mRunningAnimations;
        int N = runningAnimations.size();
        for (int i = 0; i < N; ++i) {
            runningAnimations.get(i).cancel();
        }
        runningAnimations.clear();
        if (cancelPending && !this.mPendingAnimations.isEmpty()) {
            this.mPendingAnimations.clear();
        }
        this.mHardwareAnimating = false;
    }

    private final void $$robo$$android_graphics_drawable_RippleBackground$invalidateSelf() {
        this.mOwner.invalidateSelf();
    }

    static void __staticInitializer__() {
        LINEAR_INTERPOLATOR = new LinearInterpolator();
    }

    private void __constructor__(RippleDrawable rippleDrawable, Rect rect) {
        this.$$robo$$android_graphics_drawable_RippleBackground$__constructor__(rippleDrawable, rect);
    }

    public RippleBackground(RippleDrawable rippleDrawable, Rect rect) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleBackground$__constructor__(android.graphics.drawable.RippleDrawable android.graphics.Rect ), 0, this, rippleDrawable, rect);
    }

    public void setup(int n, int n2, float f) {
        InvokeDynamicSupport.bootstrap("setup", $$robo$$android_graphics_drawable_RippleBackground$setup(int int float ), 0, this, n, n2, f);
    }

    public boolean isHardwareAnimating() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHardwareAnimating", $$robo$$android_graphics_drawable_RippleBackground$isHardwareAnimating(), 0, this);
    }

    public void onHotspotBoundsChanged() {
        InvokeDynamicSupport.bootstrap("onHotspotBoundsChanged", $$robo$$android_graphics_drawable_RippleBackground$onHotspotBoundsChanged(), 0, this);
    }

    public void setOuterOpacity(float f) {
        InvokeDynamicSupport.bootstrap("setOuterOpacity", $$robo$$android_graphics_drawable_RippleBackground$setOuterOpacity(float ), 0, this, f);
    }

    public float getOuterOpacity() {
        return (float)InvokeDynamicSupport.bootstrap("getOuterOpacity", $$robo$$android_graphics_drawable_RippleBackground$getOuterOpacity(), 0, this);
    }

    public boolean draw(Canvas canvas, Paint paint) {
        return (boolean)InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_RippleBackground$draw(android.graphics.Canvas android.graphics.Paint ), 0, this, canvas, paint);
    }

    public boolean shouldDraw() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldDraw", $$robo$$android_graphics_drawable_RippleBackground$shouldDraw(), 0, this);
    }

    private boolean drawHardware(HardwareCanvas hardwareCanvas) {
        return (boolean)InvokeDynamicSupport.bootstrap("drawHardware", $$robo$$android_graphics_drawable_RippleBackground$drawHardware(android.view.HardwareCanvas ), 0, this, hardwareCanvas);
    }

    private boolean drawSoftware(Canvas canvas, Paint paint) {
        return (boolean)InvokeDynamicSupport.bootstrap("drawSoftware", $$robo$$android_graphics_drawable_RippleBackground$drawSoftware(android.graphics.Canvas android.graphics.Paint ), 0, this, canvas, paint);
    }

    public void getBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("getBounds", $$robo$$android_graphics_drawable_RippleBackground$getBounds(android.graphics.Rect ), 0, this, rect);
    }

    public void enter() {
        InvokeDynamicSupport.bootstrap("enter", $$robo$$android_graphics_drawable_RippleBackground$enter(), 0, this);
    }

    public void exit() {
        InvokeDynamicSupport.bootstrap("exit", $$robo$$android_graphics_drawable_RippleBackground$exit(), 0, this);
    }

    private void exitHardware(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("exitHardware", $$robo$$android_graphics_drawable_RippleBackground$exitHardware(int int int ), 0, this, n, n2, n3);
    }

    public void jump() {
        InvokeDynamicSupport.bootstrap("jump", $$robo$$android_graphics_drawable_RippleBackground$jump(), 0, this);
    }

    private void endSoftwareAnimations() {
        InvokeDynamicSupport.bootstrap("endSoftwareAnimations", $$robo$$android_graphics_drawable_RippleBackground$endSoftwareAnimations(), 0, this);
    }

    private Paint getTempPaint() {
        return InvokeDynamicSupport.bootstrap("getTempPaint", $$robo$$android_graphics_drawable_RippleBackground$getTempPaint(), 0, this);
    }

    private void exitSoftware(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("exitSoftware", $$robo$$android_graphics_drawable_RippleBackground$exitSoftware(int int int ), 0, this, n, n2, n3);
    }

    public void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_graphics_drawable_RippleBackground$cancel(), 0, this);
    }

    private void cancelSoftwareAnimations() {
        InvokeDynamicSupport.bootstrap("cancelSoftwareAnimations", $$robo$$android_graphics_drawable_RippleBackground$cancelSoftwareAnimations(), 0, this);
    }

    private void cancelHardwareAnimations(boolean bl) {
        InvokeDynamicSupport.bootstrap("cancelHardwareAnimations", $$robo$$android_graphics_drawable_RippleBackground$cancelHardwareAnimations(boolean ), 0, this, bl);
    }

    private void invalidateSelf() {
        InvokeDynamicSupport.bootstrap("invalidateSelf", $$robo$$android_graphics_drawable_RippleBackground$invalidateSelf(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(RippleBackground.class);
    }

    public /* synthetic */ RippleBackground() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RippleBackground)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

