/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.Ripple;
import android.graphics.drawable.RippleBackground;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import com.android.internal.R;
import java.io.IOException;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RippleDrawable
extends LayerDrawable
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static PorterDuffXfermode DST_IN;
    private static PorterDuffXfermode SRC_ATOP;
    private static PorterDuffXfermode SRC_OVER;
    public static int RADIUS_AUTO = -1;
    private static int MAX_RIPPLES = 10;
    private Rect mTempRect;
    private Rect mHotspotBounds;
    private Rect mDrawingBounds;
    private Rect mDirtyBounds;
    private RippleState mState;
    private Drawable mMask;
    private RippleBackground mBackground;
    private boolean mBackgroundActive;
    private Ripple mRipple;
    private boolean mRippleActive;
    private float mPendingX;
    private float mPendingY;
    private boolean mHasPending;
    private Ripple[] mExitingRipples;
    private int mExitingRipplesCount;
    private Paint mRipplePaint;
    private Paint mMaskingPaint;
    private float mDensity;
    private boolean mOverrideBounds;
    private boolean mNeedsDraw;

    private void $$robo$$android_graphics_drawable_RippleDrawable$__constructor__() {
    }

    private void $$robo$$android_graphics_drawable_RippleDrawable$__constructor__(ColorStateList color2, Drawable content, Drawable mask) {
        if (color2 == null) {
            throw new IllegalArgumentException("RippleDrawable requires a non-null color");
        }
        if (content != null) {
            this.addLayer(content, null, 0, 0, 0, 0, 0);
        }
        if (mask != null) {
            this.addLayer(mask, null, 16908334, 0, 0, 0, 0);
        }
        this.setColor(color2);
        this.ensurePadding();
        this.initializeFromState();
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$jumpToCurrentState() {
        super.jumpToCurrentState();
        boolean needsDraw = false;
        if (this.mRipple != null) {
            needsDraw |= this.mRipple.isHardwareAnimating();
            this.mRipple.jump();
        }
        if (this.mBackground != null) {
            needsDraw |= this.mBackground.isHardwareAnimating();
            this.mBackground.jump();
        }
        this.mNeedsDraw = needsDraw |= this.cancelExitingRipples();
        this.invalidateSelf();
    }

    private final boolean $$robo$$android_graphics_drawable_RippleDrawable$cancelExitingRipples() {
        boolean needsDraw = false;
        int count = this.mExitingRipplesCount;
        Object[] ripples = this.mExitingRipples;
        for (int i = 0; i < count; ++i) {
            needsDraw |= ripples[i].isHardwareAnimating();
            ((Ripple)ripples[i]).cancel();
        }
        if (ripples != null) {
            Arrays.fill(ripples, 0, count, null);
        }
        this.mExitingRipplesCount = 0;
        return needsDraw;
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$setAlpha(int alpha) {
        super.setAlpha(alpha);
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$setColorFilter(ColorFilter cf) {
        super.setColorFilter(cf);
    }

    private final int $$robo$$android_graphics_drawable_RippleDrawable$getOpacity() {
        return -3;
    }

    private final boolean $$robo$$android_graphics_drawable_RippleDrawable$onStateChange(int[] stateSet) {
        boolean changed = super.onStateChange(stateSet);
        boolean enabled = false;
        boolean pressed = false;
        boolean focused = false;
        for (int state : stateSet) {
            if (state == 16842910) {
                enabled = true;
            }
            if (state == 16842908) {
                focused = true;
            }
            if (state != 16842919) continue;
            pressed = true;
        }
        this.setRippleActive(enabled && pressed);
        this.setBackgroundActive(focused || enabled && pressed);
        return changed;
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$setRippleActive(boolean active) {
        if (this.mRippleActive != active) {
            this.mRippleActive = active;
            if (active) {
                this.tryRippleEnter();
            } else {
                this.tryRippleExit();
            }
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$setBackgroundActive(boolean active) {
        if (this.mBackgroundActive != active) {
            this.mBackgroundActive = active;
            if (active) {
                this.tryBackgroundEnter();
            } else {
                this.tryBackgroundExit();
            }
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        if (!this.mOverrideBounds) {
            this.mHotspotBounds.set(bounds);
            this.onHotspotBoundsChanged();
        }
        this.invalidateSelf();
    }

    private final boolean $$robo$$android_graphics_drawable_RippleDrawable$setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (!visible) {
            this.clearHotspots();
        } else if (changed) {
            if (this.mRippleActive) {
                this.tryRippleEnter();
            }
            if (this.mBackgroundActive) {
                this.tryBackgroundEnter();
            }
        }
        return changed;
    }

    private final boolean $$robo$$android_graphics_drawable_RippleDrawable$isProjected() {
        return this.getNumberOfLayers() == 0;
    }

    private final boolean $$robo$$android_graphics_drawable_RippleDrawable$isStateful() {
        return true;
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$setColor(ColorStateList color2) {
        this.mState.mColor = color2;
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = RippleDrawable.obtainAttributes(r, theme, attrs, R.styleable.RippleDrawable);
        this.updateStateFromTypedArray(a);
        a.recycle();
        this.setPaddingMode(1);
        super.inflate(r, parser, attrs, theme);
        this.setTargetDensity(r.getDisplayMetrics());
        this.initializeFromState();
    }

    private final boolean $$robo$$android_graphics_drawable_RippleDrawable$setDrawableByLayerId(int id2, Drawable drawable2) {
        if (super.setDrawableByLayerId(id2, drawable2)) {
            if (id2 == 16908334) {
                this.mMask = drawable2;
            }
            return true;
        }
        return false;
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$setPaddingMode(int mode) {
        super.setPaddingMode(mode);
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$updateStateFromTypedArray(TypedArray a) throws XmlPullParserException {
        RippleState state = this.mState;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mTouchThemeAttrs = a.extractThemeAttrs();
        ColorStateList color2 = a.getColorStateList(0);
        if (color2 != null) {
            this.mState.mColor = color2;
        }
        this.verifyRequiredAttributes(a);
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$verifyRequiredAttributes(TypedArray a) throws XmlPullParserException {
        if (this.mState.mColor == null && (this.mState.mTouchThemeAttrs == null || this.mState.mTouchThemeAttrs[0] == 0)) {
            throw new XmlPullParserException(a.getPositionDescription() + ": <ripple> requires a valid color attribute");
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$setTargetDensity(DisplayMetrics metrics) {
        if (this.mDensity != metrics.density) {
            this.mDensity = metrics.density;
            this.invalidateSelf();
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        RippleState state = this.mState;
        if (state == null || state.mTouchThemeAttrs == null) {
            return;
        }
        TypedArray a = t.resolveAttributes(state.mTouchThemeAttrs, R.styleable.RippleDrawable);
        try {
            this.updateStateFromTypedArray(a);
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
        finally {
            a.recycle();
        }
        this.initializeFromState();
    }

    private final boolean $$robo$$android_graphics_drawable_RippleDrawable$canApplyTheme() {
        return super.canApplyTheme() || this.mState != null && this.mState.mTouchThemeAttrs != null;
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$setHotspot(float x, float y) {
        if (this.mRipple == null || this.mBackground == null) {
            this.mPendingX = x;
            this.mPendingY = y;
            this.mHasPending = true;
        }
        if (this.mRipple != null) {
            this.mRipple.move(x, y);
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$tryBackgroundEnter() {
        if (this.mBackground == null) {
            this.mBackground = new RippleBackground(this, this.mHotspotBounds);
        }
        int color2 = this.mState.mColor.getColorForState(this.getState(), 0);
        this.mBackground.setup(this.mState.mMaxRadius, color2, this.mDensity);
        this.mBackground.enter();
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$tryBackgroundExit() {
        if (this.mBackground != null) {
            this.mBackground.exit();
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$tryRippleEnter() {
        if (this.mExitingRipplesCount >= 10) {
            return;
        }
        if (this.mRipple == null) {
            float y;
            float x;
            if (this.mHasPending) {
                this.mHasPending = false;
                x = this.mPendingX;
                y = this.mPendingY;
            } else {
                x = this.mHotspotBounds.exactCenterX();
                y = this.mHotspotBounds.exactCenterY();
            }
            this.mRipple = new Ripple(this, this.mHotspotBounds, x, y);
        }
        int color2 = this.mState.mColor.getColorForState(this.getState(), 0);
        this.mRipple.setup(this.mState.mMaxRadius, color2, this.mDensity);
        this.mRipple.enter();
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$tryRippleExit() {
        if (this.mRipple != null) {
            if (this.mExitingRipples == null) {
                this.mExitingRipples = new Ripple[10];
            }
            this.mExitingRipples[this.mExitingRipplesCount++] = this.mRipple;
            this.mRipple.exit();
            this.mRipple = null;
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$clearHotspots() {
        boolean needsDraw = false;
        if (this.mRipple != null) {
            needsDraw |= this.mRipple.isHardwareAnimating();
            this.mRipple.cancel();
            this.mRipple = null;
        }
        if (this.mBackground != null) {
            needsDraw |= this.mBackground.isHardwareAnimating();
            this.mBackground.cancel();
            this.mBackground = null;
        }
        this.mNeedsDraw = needsDraw |= this.cancelExitingRipples();
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$setHotspotBounds(int left, int top, int right, int bottom) {
        this.mOverrideBounds = true;
        this.mHotspotBounds.set(left, top, right, bottom);
        this.onHotspotBoundsChanged();
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$getHotspotBounds(Rect outRect) {
        outRect.set(this.mHotspotBounds);
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$onHotspotBoundsChanged() {
        int count = this.mExitingRipplesCount;
        Ripple[] ripples = this.mExitingRipples;
        for (int i = 0; i < count; ++i) {
            ripples[i].onHotspotBoundsChanged();
        }
        if (this.mRipple != null) {
            this.mRipple.onHotspotBoundsChanged();
        }
        if (this.mBackground != null) {
            this.mBackground.onHotspotBoundsChanged();
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$getOutline(Outline outline) {
        LayerDrawable.LayerState state = this.mLayerState;
        LayerDrawable.ChildDrawable[] children = state.mChildren;
        int N = state.mNum;
        for (int i = 0; i < N; ++i) {
            if (children[i].mId == 16908334) continue;
            children[i].mDrawable.getOutline(outline);
            if (outline.isEmpty()) continue;
            return;
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$draw(Canvas canvas) {
        int rippleLayer;
        boolean hasMask = this.mMask != null;
        boolean drawNonMaskContent = this.mLayerState.mNum > (hasMask ? 1 : 0);
        boolean drawMask = hasMask && this.mMask.getOpacity() != -1;
        Rect bounds = this.getDirtyBounds();
        int saveCount = canvas.save(2);
        canvas.clipRect(bounds);
        int contentLayer = drawNonMaskContent ? this.drawContentLayer(canvas, bounds, SRC_OVER) : -1;
        PorterDuffXfermode xfermode = hasMask || !drawNonMaskContent ? SRC_OVER : SRC_ATOP;
        int backgroundLayer = this.drawBackgroundLayer(canvas, bounds, xfermode, drawMask);
        if (backgroundLayer >= 0) {
            if (drawMask) {
                this.drawMaskingLayer(canvas, bounds, DST_IN);
            }
            canvas.restoreToCount(backgroundLayer);
        }
        if ((rippleLayer = this.drawRippleLayer(canvas, bounds, xfermode)) >= 0) {
            if (drawMask) {
                this.drawMaskingLayer(canvas, bounds, DST_IN);
            }
            canvas.restoreToCount(rippleLayer);
        }
        if (contentLayer < 0 && backgroundLayer < 0 && rippleLayer < 0 && this.mNeedsDraw) {
            canvas.drawColor(0);
            this.invalidateSelf();
        }
        this.mNeedsDraw = false;
        canvas.restoreToCount(saveCount);
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$removeRipple(Ripple ripple) {
        Ripple[] ripples = this.mExitingRipples;
        int count = this.mExitingRipplesCount--;
        int index = this.getRippleIndex(ripple);
        if (index >= 0) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)ripples, (int)(index + 1), (Object)ripples, (int)index, (int)(count - (index + 1)));
            ripples[count - 1] = null;
            this.invalidateSelf();
        }
    }

    private final int $$robo$$android_graphics_drawable_RippleDrawable$getRippleIndex(Ripple ripple) {
        Ripple[] ripples = this.mExitingRipples;
        int count = this.mExitingRipplesCount;
        for (int i = 0; i < count; ++i) {
            if (ripples[i] != ripple) continue;
            return i;
        }
        return -1;
    }

    private final int $$robo$$android_graphics_drawable_RippleDrawable$drawContentLayer(Canvas canvas, Rect bounds, PorterDuffXfermode mode) {
        LayerDrawable.ChildDrawable[] array2 = this.mLayerState.mChildren;
        int count = this.mLayerState.mNum;
        boolean needsLayer = false;
        if ((this.mExitingRipplesCount > 0 || this.mBackground != null) && this.mMask == null) {
            for (int i = 0; i < count; ++i) {
                if (array2[i].mId == 16908334 || array2[i].mDrawable.getOpacity() == -1) continue;
                needsLayer = true;
                break;
            }
        }
        Paint maskingPaint = this.getMaskingPaint(mode);
        int restoreToCount = needsLayer ? canvas.saveLayer(bounds.left, bounds.top, bounds.right, bounds.bottom, maskingPaint) : -1;
        for (int i = 0; i < count; ++i) {
            if (array2[i].mId == 16908334) continue;
            array2[i].mDrawable.draw(canvas);
        }
        return restoreToCount;
    }

    private final int $$robo$$android_graphics_drawable_RippleDrawable$drawBackgroundLayer(Canvas canvas, Rect bounds, PorterDuffXfermode mode, boolean drawMask) {
        int saveCount = -1;
        if (this.mBackground != null && this.mBackground.shouldDraw()) {
            if (drawMask || mode != SRC_OVER) {
                saveCount = canvas.saveLayer(bounds.left, bounds.top, bounds.right, bounds.bottom, this.getMaskingPaint(mode));
            }
            float x = this.mHotspotBounds.exactCenterX();
            float y = this.mHotspotBounds.exactCenterY();
            canvas.translate(x, y);
            this.mBackground.draw(canvas, this.getRipplePaint());
            canvas.translate(-x, -y);
        }
        return saveCount;
    }

    private final int $$robo$$android_graphics_drawable_RippleDrawable$drawRippleLayer(Canvas canvas, Rect bounds, PorterDuffXfermode mode) {
        boolean drewRipples = false;
        int restoreToCount = -1;
        int restoreTranslate = -1;
        int count = this.mExitingRipplesCount;
        Ripple[] ripples = this.mExitingRipples;
        for (int i = 0; i <= count; ++i) {
            Ripple ripple;
            if (i < count) {
                ripple = ripples[i];
            } else {
                if (this.mRipple == null) continue;
                ripple = this.mRipple;
            }
            if (restoreToCount < 0) {
                Paint maskingPaint = this.getMaskingPaint(mode);
                int color2 = this.mState.mColor.getColorForState(this.getState(), 0);
                int alpha = Color.alpha(color2);
                maskingPaint.setAlpha(alpha / 2);
                restoreToCount = canvas.saveLayer(bounds.left, bounds.top, bounds.right, bounds.bottom, maskingPaint);
                restoreTranslate = canvas.save();
                canvas.translate(this.mHotspotBounds.exactCenterX(), this.mHotspotBounds.exactCenterY());
            }
            drewRipples |= ripple.draw(canvas, this.getRipplePaint());
        }
        if (restoreTranslate >= 0) {
            canvas.restoreToCount(restoreTranslate);
        }
        if (restoreToCount >= 0 && !drewRipples) {
            canvas.restoreToCount(restoreToCount);
            restoreToCount = -1;
        }
        return restoreToCount;
    }

    private final int $$robo$$android_graphics_drawable_RippleDrawable$drawMaskingLayer(Canvas canvas, Rect bounds, PorterDuffXfermode mode) {
        int restoreToCount = canvas.saveLayer(bounds.left, bounds.top, bounds.right, bounds.bottom, this.getMaskingPaint(mode));
        canvas.drawColor(0);
        this.mMask.draw(canvas);
        return restoreToCount;
    }

    private final Paint $$robo$$android_graphics_drawable_RippleDrawable$getRipplePaint() {
        if (this.mRipplePaint == null) {
            this.mRipplePaint = new Paint();
            this.mRipplePaint.setAntiAlias(true);
        }
        return this.mRipplePaint;
    }

    private final Paint $$robo$$android_graphics_drawable_RippleDrawable$getMaskingPaint(PorterDuffXfermode xfermode) {
        if (this.mMaskingPaint == null) {
            this.mMaskingPaint = new Paint();
        }
        this.mMaskingPaint.setXfermode(xfermode);
        this.mMaskingPaint.setAlpha(255);
        return this.mMaskingPaint;
    }

    private final Rect $$robo$$android_graphics_drawable_RippleDrawable$getDirtyBounds() {
        if (this.isProjected()) {
            Rect drawingBounds = this.mDrawingBounds;
            Rect dirtyBounds = this.mDirtyBounds;
            dirtyBounds.set(drawingBounds);
            drawingBounds.setEmpty();
            int cX = (int)this.mHotspotBounds.exactCenterX();
            int cY = (int)this.mHotspotBounds.exactCenterY();
            Rect rippleBounds = this.mTempRect;
            Ripple[] activeRipples = this.mExitingRipples;
            int N = this.mExitingRipplesCount;
            for (int i = 0; i < N; ++i) {
                activeRipples[i].getBounds(rippleBounds);
                rippleBounds.offset(cX, cY);
                drawingBounds.union(rippleBounds);
            }
            RippleBackground background = this.mBackground;
            if (background != null) {
                background.getBounds(rippleBounds);
                rippleBounds.offset(cX, cY);
                drawingBounds.union(rippleBounds);
            }
            dirtyBounds.union(drawingBounds);
            dirtyBounds.union(super.getDirtyBounds());
            return dirtyBounds;
        }
        return this.getBounds();
    }

    private final Drawable.ConstantState $$robo$$android_graphics_drawable_RippleDrawable$getConstantState() {
        return this.mState;
    }

    private final Drawable $$robo$$android_graphics_drawable_RippleDrawable$mutate() {
        super.mutate();
        this.mState = (RippleState)this.mLayerState;
        return this;
    }

    private final RippleState $$robo$$android_graphics_drawable_RippleDrawable$createConstantState(LayerDrawable.LayerState state, Resources res) {
        return new RippleState(state, this, res);
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$setMaxRadius(int maxRadius) {
        if (maxRadius != -1 && maxRadius < 0) {
            throw new IllegalArgumentException("maxRadius must be RADIUS_AUTO or >= 0");
        }
        this.mState.mMaxRadius = maxRadius;
    }

    private final int $$robo$$android_graphics_drawable_RippleDrawable$getMaxRadius() {
        return this.mState.mMaxRadius;
    }

    private void $$robo$$android_graphics_drawable_RippleDrawable$__constructor__(RippleState state, Resources res, Resources.Theme theme) {
        RippleState ns;
        this.mTempRect = new Rect();
        this.mHotspotBounds = new Rect();
        this.mDrawingBounds = new Rect();
        this.mDirtyBounds = new Rect();
        this.mExitingRipplesCount = 0;
        this.mDensity = 1.0f;
        boolean needsTheme = false;
        if (theme != null && state != null && state.canApplyTheme()) {
            ns = new RippleState((LayerDrawable.LayerState)state, this, res);
            needsTheme = true;
        } else {
            ns = state == null ? new RippleState(null, this, res) : new RippleState((LayerDrawable.LayerState)state, this, res);
        }
        if (res != null) {
            this.mDensity = res.getDisplayMetrics().density;
        }
        this.mState = ns;
        this.mLayerState = ns;
        if (ns.mNum > 0) {
            this.ensurePadding();
        }
        if (needsTheme) {
            this.applyTheme(theme);
        }
        this.initializeFromState();
    }

    private final void $$robo$$android_graphics_drawable_RippleDrawable$initializeFromState() {
        this.mMask = this.findDrawableByLayerId(16908334);
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_RippleDrawable$__constructor__(RippleState x0, Resources x1, Resources.Theme x2, 1 x3) {
    }

    static void __staticInitializer__() {
        DST_IN = new PorterDuffXfermode(PorterDuff.Mode.DST_IN);
        SRC_ATOP = new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP);
        SRC_OVER = new PorterDuffXfermode(PorterDuff.Mode.SRC_OVER);
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_RippleDrawable$__constructor__();
    }

    RippleDrawable() {
        this(new RippleState(null, null, null), null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleDrawable$__constructor__(), 0, this);
    }

    private void __constructor__(ColorStateList colorStateList, Drawable drawable2, Drawable drawable3) {
        this.$$robo$$android_graphics_drawable_RippleDrawable$__constructor__(colorStateList, drawable2, drawable3);
    }

    public RippleDrawable(ColorStateList colorStateList, Drawable drawable2, Drawable drawable3) {
        this(new RippleState(null, null, null), null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleDrawable$__constructor__(android.content.res.ColorStateList android.graphics.drawable.Drawable android.graphics.drawable.Drawable ), 0, this, colorStateList, drawable2, drawable3);
    }

    @Override
    public void jumpToCurrentState() {
        InvokeDynamicSupport.bootstrap("jumpToCurrentState", $$robo$$android_graphics_drawable_RippleDrawable$jumpToCurrentState(), 0, this);
    }

    private boolean cancelExitingRipples() {
        return (boolean)InvokeDynamicSupport.bootstrap("cancelExitingRipples", $$robo$$android_graphics_drawable_RippleDrawable$cancelExitingRipples(), 0, this);
    }

    @Override
    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_drawable_RippleDrawable$setAlpha(int ), 0, this, n);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_graphics_drawable_RippleDrawable$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_RippleDrawable$getOpacity(), 0, this);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_RippleDrawable$onStateChange(int[] ), 0, this, nArray);
    }

    private void setRippleActive(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRippleActive", $$robo$$android_graphics_drawable_RippleDrawable$setRippleActive(boolean ), 0, this, bl);
    }

    private void setBackgroundActive(boolean bl) {
        InvokeDynamicSupport.bootstrap("setBackgroundActive", $$robo$$android_graphics_drawable_RippleDrawable$setBackgroundActive(boolean ), 0, this, bl);
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        InvokeDynamicSupport.bootstrap("onBoundsChange", $$robo$$android_graphics_drawable_RippleDrawable$onBoundsChange(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setVisible", $$robo$$android_graphics_drawable_RippleDrawable$setVisible(boolean boolean ), 0, this, bl, bl2);
    }

    @Override
    public boolean isProjected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isProjected", $$robo$$android_graphics_drawable_RippleDrawable$isProjected(), 0, this);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_RippleDrawable$isStateful(), 0, this);
    }

    public void setColor(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setColor", $$robo$$android_graphics_drawable_RippleDrawable$setColor(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_RippleDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    @Override
    public boolean setDrawableByLayerId(int n, Drawable drawable2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setDrawableByLayerId", $$robo$$android_graphics_drawable_RippleDrawable$setDrawableByLayerId(int android.graphics.drawable.Drawable ), 0, this, n, drawable2);
    }

    @Override
    public void setPaddingMode(int n) {
        InvokeDynamicSupport.bootstrap("setPaddingMode", $$robo$$android_graphics_drawable_RippleDrawable$setPaddingMode(int ), 0, this, n);
    }

    private void updateStateFromTypedArray(TypedArray typedArray) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_RippleDrawable$updateStateFromTypedArray(android.content.res.TypedArray ), 0, this, typedArray);
    }

    private void verifyRequiredAttributes(TypedArray typedArray) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("verifyRequiredAttributes", $$robo$$android_graphics_drawable_RippleDrawable$verifyRequiredAttributes(android.content.res.TypedArray ), 0, this, typedArray);
    }

    private void setTargetDensity(DisplayMetrics displayMetrics) {
        InvokeDynamicSupport.bootstrap("setTargetDensity", $$robo$$android_graphics_drawable_RippleDrawable$setTargetDensity(android.util.DisplayMetrics ), 0, this, displayMetrics);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_RippleDrawable$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
    }

    @Override
    public boolean canApplyTheme() {
        return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_RippleDrawable$canApplyTheme(), 0, this);
    }

    @Override
    public void setHotspot(float f, float f2) {
        InvokeDynamicSupport.bootstrap("setHotspot", $$robo$$android_graphics_drawable_RippleDrawable$setHotspot(float float ), 0, this, f, f2);
    }

    private void tryBackgroundEnter() {
        InvokeDynamicSupport.bootstrap("tryBackgroundEnter", $$robo$$android_graphics_drawable_RippleDrawable$tryBackgroundEnter(), 0, this);
    }

    private void tryBackgroundExit() {
        InvokeDynamicSupport.bootstrap("tryBackgroundExit", $$robo$$android_graphics_drawable_RippleDrawable$tryBackgroundExit(), 0, this);
    }

    private void tryRippleEnter() {
        InvokeDynamicSupport.bootstrap("tryRippleEnter", $$robo$$android_graphics_drawable_RippleDrawable$tryRippleEnter(), 0, this);
    }

    private void tryRippleExit() {
        InvokeDynamicSupport.bootstrap("tryRippleExit", $$robo$$android_graphics_drawable_RippleDrawable$tryRippleExit(), 0, this);
    }

    private void clearHotspots() {
        InvokeDynamicSupport.bootstrap("clearHotspots", $$robo$$android_graphics_drawable_RippleDrawable$clearHotspots(), 0, this);
    }

    @Override
    public void setHotspotBounds(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setHotspotBounds", $$robo$$android_graphics_drawable_RippleDrawable$setHotspotBounds(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void getHotspotBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("getHotspotBounds", $$robo$$android_graphics_drawable_RippleDrawable$getHotspotBounds(android.graphics.Rect ), 0, this, rect);
    }

    private void onHotspotBoundsChanged() {
        InvokeDynamicSupport.bootstrap("onHotspotBoundsChanged", $$robo$$android_graphics_drawable_RippleDrawable$onHotspotBoundsChanged(), 0, this);
    }

    @Override
    public void getOutline(Outline outline) {
        InvokeDynamicSupport.bootstrap("getOutline", $$robo$$android_graphics_drawable_RippleDrawable$getOutline(android.graphics.Outline ), 0, this, outline);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_RippleDrawable$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    void removeRipple(Ripple ripple) {
        InvokeDynamicSupport.bootstrap("removeRipple", $$robo$$android_graphics_drawable_RippleDrawable$removeRipple(android.graphics.drawable.Ripple ), 0, this, ripple);
    }

    private int getRippleIndex(Ripple ripple) {
        return (int)InvokeDynamicSupport.bootstrap("getRippleIndex", $$robo$$android_graphics_drawable_RippleDrawable$getRippleIndex(android.graphics.drawable.Ripple ), 0, this, ripple);
    }

    private int drawContentLayer(Canvas canvas, Rect rect, PorterDuffXfermode porterDuffXfermode) {
        return (int)InvokeDynamicSupport.bootstrap("drawContentLayer", $$robo$$android_graphics_drawable_RippleDrawable$drawContentLayer(android.graphics.Canvas android.graphics.Rect android.graphics.PorterDuffXfermode ), 0, this, canvas, rect, porterDuffXfermode);
    }

    private int drawBackgroundLayer(Canvas canvas, Rect rect, PorterDuffXfermode porterDuffXfermode, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("drawBackgroundLayer", $$robo$$android_graphics_drawable_RippleDrawable$drawBackgroundLayer(android.graphics.Canvas android.graphics.Rect android.graphics.PorterDuffXfermode boolean ), 0, this, canvas, rect, porterDuffXfermode, bl);
    }

    private int drawRippleLayer(Canvas canvas, Rect rect, PorterDuffXfermode porterDuffXfermode) {
        return (int)InvokeDynamicSupport.bootstrap("drawRippleLayer", $$robo$$android_graphics_drawable_RippleDrawable$drawRippleLayer(android.graphics.Canvas android.graphics.Rect android.graphics.PorterDuffXfermode ), 0, this, canvas, rect, porterDuffXfermode);
    }

    private int drawMaskingLayer(Canvas canvas, Rect rect, PorterDuffXfermode porterDuffXfermode) {
        return (int)InvokeDynamicSupport.bootstrap("drawMaskingLayer", $$robo$$android_graphics_drawable_RippleDrawable$drawMaskingLayer(android.graphics.Canvas android.graphics.Rect android.graphics.PorterDuffXfermode ), 0, this, canvas, rect, porterDuffXfermode);
    }

    private Paint getRipplePaint() {
        return InvokeDynamicSupport.bootstrap("getRipplePaint", $$robo$$android_graphics_drawable_RippleDrawable$getRipplePaint(), 0, this);
    }

    private Paint getMaskingPaint(PorterDuffXfermode porterDuffXfermode) {
        return InvokeDynamicSupport.bootstrap("getMaskingPaint", $$robo$$android_graphics_drawable_RippleDrawable$getMaskingPaint(android.graphics.PorterDuffXfermode ), 0, this, porterDuffXfermode);
    }

    @Override
    public Rect getDirtyBounds() {
        return InvokeDynamicSupport.bootstrap("getDirtyBounds", $$robo$$android_graphics_drawable_RippleDrawable$getDirtyBounds(), 0, this);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_graphics_drawable_RippleDrawable$getConstantState(), 0, this);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_RippleDrawable$mutate(), 0, this);
    }

    @Override
    RippleState createConstantState(LayerDrawable.LayerState layerState, Resources resources) {
        return InvokeDynamicSupport.bootstrap("createConstantState", $$robo$$android_graphics_drawable_RippleDrawable$createConstantState(android.graphics.drawable.LayerDrawable$LayerState android.content.res.Resources ), 0, this, layerState, resources);
    }

    public void setMaxRadius(int n) {
        InvokeDynamicSupport.bootstrap("setMaxRadius", $$robo$$android_graphics_drawable_RippleDrawable$setMaxRadius(int ), 0, this, n);
    }

    public int getMaxRadius() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxRadius", $$robo$$android_graphics_drawable_RippleDrawable$getMaxRadius(), 0, this);
    }

    private void __constructor__(RippleState rippleState, Resources resources, Resources.Theme theme) {
        this.$$robo$$android_graphics_drawable_RippleDrawable$__constructor__(rippleState, resources, theme);
    }

    private RippleDrawable(RippleState rippleState, Resources resources, Resources.Theme theme) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleDrawable$__constructor__(android.graphics.drawable.RippleDrawable$RippleState android.content.res.Resources android.content.res.Resources$Theme ), 0, this, rippleState, resources, theme);
    }

    private void initializeFromState() {
        InvokeDynamicSupport.bootstrap("initializeFromState", $$robo$$android_graphics_drawable_RippleDrawable$initializeFromState(), 0, this);
    }

    private /* synthetic */ void __constructor__(RippleState rippleState, Resources resources, Resources.Theme theme, 1 var4_4) {
        this.$$robo$$android_graphics_drawable_RippleDrawable$__constructor__(rippleState, resources, theme, var4_4);
    }

    static {
        RobolectricInternals.classInitializing(RippleDrawable.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RippleDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class RippleState
    extends LayerDrawable.LayerState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int[] mTouchThemeAttrs;
        ColorStateList mColor;
        int mMaxRadius;

        private void $$robo$$android_graphics_drawable_RippleDrawable_RippleState$__constructor__(LayerDrawable.LayerState orig, RippleDrawable owner, Resources res) {
            this.mColor = ColorStateList.valueOf(-65281);
            this.mMaxRadius = -1;
            if (orig != null && orig instanceof RippleState) {
                RippleState origs = (RippleState)orig;
                this.mTouchThemeAttrs = origs.mTouchThemeAttrs;
                this.mColor = origs.mColor;
                this.mMaxRadius = origs.mMaxRadius;
            }
        }

        private final boolean $$robo$$android_graphics_drawable_RippleDrawable_RippleState$canApplyTheme() {
            return this.mTouchThemeAttrs != null || super.canApplyTheme();
        }

        private final Drawable $$robo$$android_graphics_drawable_RippleDrawable_RippleState$newDrawable() {
            return new RippleDrawable(this, null, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_RippleDrawable_RippleState$newDrawable(Resources res) {
            return new RippleDrawable(this, res, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_RippleDrawable_RippleState$newDrawable(Resources res, Resources.Theme theme) {
            return new RippleDrawable(this, res, theme);
        }

        private void __constructor__(LayerDrawable.LayerState layerState, RippleDrawable rippleDrawable, Resources resources) {
            this.$$robo$$android_graphics_drawable_RippleDrawable_RippleState$__constructor__(layerState, rippleDrawable, resources);
        }

        public RippleState(LayerDrawable.LayerState layerState, RippleDrawable rippleDrawable, Resources resources) {
            super(layerState, rippleDrawable, resources);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleDrawable_RippleState$__constructor__(android.graphics.drawable.LayerDrawable$LayerState android.graphics.drawable.RippleDrawable android.content.res.Resources ), 0, this, layerState, rippleDrawable, resources);
        }

        @Override
        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_RippleDrawable_RippleState$canApplyTheme(), 0, this);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_RippleDrawable_RippleState$newDrawable(), 0, this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_RippleDrawable_RippleState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        @Override
        public Drawable newDrawable(Resources resources, Resources.Theme theme) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_RippleDrawable_RippleState$newDrawable(android.content.res.Resources android.content.res.Resources$Theme ), 0, this, resources, theme);
        }

        public /* synthetic */ RippleState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RippleState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

