/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RotateDrawable
extends Drawable
implements Drawable.Callback,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static float MAX_LEVEL = 10000.0f;
    private RotateState mState;
    private boolean mMutated;

    private void $$robo$$android_graphics_drawable_RotateDrawable$__constructor__() {
    }

    private void $$robo$$android_graphics_drawable_RotateDrawable$__constructor__(RotateState rotateState, Resources res) {
        this.mState = new RotateState(rotateState, this, res);
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$draw(Canvas canvas) {
        RotateState st = this.mState;
        Drawable d = st.mDrawable;
        Rect bounds = d.getBounds();
        int w = bounds.right - bounds.left;
        int h = bounds.bottom - bounds.top;
        float px = st.mPivotXRel ? (float)w * st.mPivotX : st.mPivotX;
        float py = st.mPivotYRel ? (float)h * st.mPivotY : st.mPivotY;
        int saveCount = canvas.save();
        canvas.rotate(st.mCurrentDegrees, px + (float)bounds.left, py + (float)bounds.top);
        d.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$setDrawable(Drawable drawable2) {
        Drawable oldDrawable = this.mState.mDrawable;
        if (oldDrawable != drawable2) {
            if (oldDrawable != null) {
                oldDrawable.setCallback(null);
            }
            this.mState.mDrawable = drawable2;
            if (drawable2 != null) {
                drawable2.setCallback(this);
            }
        }
    }

    private final Drawable $$robo$$android_graphics_drawable_RotateDrawable$getDrawable() {
        return this.mState.mDrawable;
    }

    private final int $$robo$$android_graphics_drawable_RotateDrawable$getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mState.mChangingConfigurations | this.mState.mDrawable.getChangingConfigurations();
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$setAlpha(int alpha) {
        this.mState.mDrawable.setAlpha(alpha);
    }

    private final int $$robo$$android_graphics_drawable_RotateDrawable$getAlpha() {
        return this.mState.mDrawable.getAlpha();
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$setColorFilter(ColorFilter cf) {
        this.mState.mDrawable.setColorFilter(cf);
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$setTintList(ColorStateList tint) {
        this.mState.mDrawable.setTintList(tint);
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$setTintMode(PorterDuff.Mode tintMode) {
        this.mState.mDrawable.setTintMode(tintMode);
    }

    private final int $$robo$$android_graphics_drawable_RotateDrawable$getOpacity() {
        return this.mState.mDrawable.getOpacity();
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$setFromDegrees(float fromDegrees) {
        if (this.mState.mFromDegrees != fromDegrees) {
            this.mState.mFromDegrees = fromDegrees;
            this.invalidateSelf();
        }
    }

    private final float $$robo$$android_graphics_drawable_RotateDrawable$getFromDegrees() {
        return this.mState.mFromDegrees;
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$setToDegrees(float toDegrees) {
        if (this.mState.mToDegrees != toDegrees) {
            this.mState.mToDegrees = toDegrees;
            this.invalidateSelf();
        }
    }

    private final float $$robo$$android_graphics_drawable_RotateDrawable$getToDegrees() {
        return this.mState.mToDegrees;
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$setPivotX(float pivotX) {
        if (this.mState.mPivotX == pivotX) {
            this.mState.mPivotX = pivotX;
            this.invalidateSelf();
        }
    }

    private final float $$robo$$android_graphics_drawable_RotateDrawable$getPivotX() {
        return this.mState.mPivotX;
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$setPivotXRelative(boolean relative) {
        if (this.mState.mPivotXRel == relative) {
            this.mState.mPivotXRel = relative;
            this.invalidateSelf();
        }
    }

    private final boolean $$robo$$android_graphics_drawable_RotateDrawable$isPivotXRelative() {
        return this.mState.mPivotXRel;
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$setPivotY(float pivotY) {
        if (this.mState.mPivotY == pivotY) {
            this.mState.mPivotY = pivotY;
            this.invalidateSelf();
        }
    }

    private final float $$robo$$android_graphics_drawable_RotateDrawable$getPivotY() {
        return this.mState.mPivotY;
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$setPivotYRelative(boolean relative) {
        if (this.mState.mPivotYRel == relative) {
            this.mState.mPivotYRel = relative;
            this.invalidateSelf();
        }
    }

    private final boolean $$robo$$android_graphics_drawable_RotateDrawable$isPivotYRelative() {
        return this.mState.mPivotYRel;
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$invalidateDrawable(Drawable who) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable(this);
        }
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$scheduleDrawable(Drawable who, Runnable what, long when) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable(this, what, when);
        }
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$unscheduleDrawable(Drawable who, Runnable what) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable(this, what);
        }
    }

    private final boolean $$robo$$android_graphics_drawable_RotateDrawable$getPadding(Rect padding) {
        return this.mState.mDrawable.getPadding(padding);
    }

    private final boolean $$robo$$android_graphics_drawable_RotateDrawable$setVisible(boolean visible, boolean restart) {
        this.mState.mDrawable.setVisible(visible, restart);
        return super.setVisible(visible, restart);
    }

    private final boolean $$robo$$android_graphics_drawable_RotateDrawable$isStateful() {
        return this.mState.mDrawable.isStateful();
    }

    private final boolean $$robo$$android_graphics_drawable_RotateDrawable$onStateChange(int[] state) {
        boolean changed = this.mState.mDrawable.setState(state);
        this.onBoundsChange(this.getBounds());
        return changed;
    }

    private final boolean $$robo$$android_graphics_drawable_RotateDrawable$onLevelChange(int level) {
        this.mState.mDrawable.setLevel(level);
        this.onBoundsChange(this.getBounds());
        this.mState.mCurrentDegrees = this.mState.mFromDegrees + (this.mState.mToDegrees - this.mState.mFromDegrees) * ((float)level / 10000.0f);
        this.invalidateSelf();
        return true;
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$onBoundsChange(Rect bounds) {
        this.mState.mDrawable.setBounds(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    private final int $$robo$$android_graphics_drawable_RotateDrawable$getIntrinsicWidth() {
        return this.mState.mDrawable.getIntrinsicWidth();
    }

    private final int $$robo$$android_graphics_drawable_RotateDrawable$getIntrinsicHeight() {
        return this.mState.mDrawable.getIntrinsicHeight();
    }

    private final Drawable.ConstantState $$robo$$android_graphics_drawable_RotateDrawable$getConstantState() {
        if (this.mState.canConstantState()) {
            this.mState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mState;
        }
        return null;
    }

    private final void $$robo$$android_graphics_drawable_RotateDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int type;
        float pivotY;
        boolean pivotYRel;
        float pivotX;
        boolean pivotXRel;
        TypedArray a = RotateDrawable.obtainAttributes(r, theme, attrs, R.styleable.RotateDrawable);
        super.inflateWithAttributes(r, parser, a, 0);
        TypedValue tv = a.peekValue(4);
        if (tv == null) {
            pivotXRel = true;
            pivotX = 0.5f;
        } else {
            pivotXRel = tv.type == 6;
            pivotX = pivotXRel ? tv.getFraction(1.0f, 1.0f) : tv.getFloat();
        }
        tv = a.peekValue(5);
        if (tv == null) {
            pivotYRel = true;
            pivotY = 0.5f;
        } else {
            pivotYRel = tv.type == 6;
            pivotY = pivotYRel ? tv.getFraction(1.0f, 1.0f) : tv.getFloat();
        }
        float fromDegrees = a.getFloat(2, 0.0f);
        float toDegrees = a.getFloat(3, 360.0f);
        int res = a.getResourceId(1, 0);
        Drawable drawable2 = null;
        if (res > 0) {
            drawable2 = r.getDrawable(res, theme);
        }
        a.recycle();
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type != 2 || (drawable2 = Drawable.createFromXmlInner(r, parser, attrs, theme)) != null) continue;
            Log.w("drawable", "Bad element under <rotate>: " + parser.getName());
        }
        if (drawable2 == null) {
            Log.w("drawable", "No drawable specified for <rotate>");
        }
        RotateState st = this.mState;
        st.mDrawable = drawable2;
        st.mPivotXRel = pivotXRel;
        st.mPivotX = pivotX;
        st.mPivotYRel = pivotYRel;
        st.mPivotY = pivotY;
        st.mFromDegrees = fromDegrees;
        st.mCurrentDegrees = fromDegrees;
        st.mToDegrees = toDegrees;
        if (drawable2 != null) {
            drawable2.setCallback(this);
        }
    }

    private final Drawable $$robo$$android_graphics_drawable_RotateDrawable$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mState.mDrawable.mutate();
            this.mMutated = true;
        }
        return this;
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_RotateDrawable$__constructor__(RotateState x0, Resources x1, 1 x2) {
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_RotateDrawable$__constructor__();
    }

    public RotateDrawable() {
        this(null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RotateDrawable$__constructor__(), 0, this);
    }

    private void __constructor__(RotateState rotateState, Resources resources) {
        this.$$robo$$android_graphics_drawable_RotateDrawable$__constructor__(rotateState, resources);
    }

    private RotateDrawable(RotateState rotateState, Resources resources) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RotateDrawable$__constructor__(android.graphics.drawable.RotateDrawable$RotateState android.content.res.Resources ), 0, this, rotateState, resources);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_RotateDrawable$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    public void setDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setDrawable", $$robo$$android_graphics_drawable_RotateDrawable$setDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public Drawable getDrawable() {
        return InvokeDynamicSupport.bootstrap("getDrawable", $$robo$$android_graphics_drawable_RotateDrawable$getDrawable(), 0, this);
    }

    @Override
    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_RotateDrawable$getChangingConfigurations(), 0, this);
    }

    @Override
    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_drawable_RotateDrawable$setAlpha(int ), 0, this, n);
    }

    @Override
    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_drawable_RotateDrawable$getAlpha(), 0, this);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_graphics_drawable_RotateDrawable$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setTintList", $$robo$$android_graphics_drawable_RotateDrawable$setTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setTintMode", $$robo$$android_graphics_drawable_RotateDrawable$setTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_RotateDrawable$getOpacity(), 0, this);
    }

    public void setFromDegrees(float f) {
        InvokeDynamicSupport.bootstrap("setFromDegrees", $$robo$$android_graphics_drawable_RotateDrawable$setFromDegrees(float ), 0, this, f);
    }

    public float getFromDegrees() {
        return (float)InvokeDynamicSupport.bootstrap("getFromDegrees", $$robo$$android_graphics_drawable_RotateDrawable$getFromDegrees(), 0, this);
    }

    public void setToDegrees(float f) {
        InvokeDynamicSupport.bootstrap("setToDegrees", $$robo$$android_graphics_drawable_RotateDrawable$setToDegrees(float ), 0, this, f);
    }

    public float getToDegrees() {
        return (float)InvokeDynamicSupport.bootstrap("getToDegrees", $$robo$$android_graphics_drawable_RotateDrawable$getToDegrees(), 0, this);
    }

    public void setPivotX(float f) {
        InvokeDynamicSupport.bootstrap("setPivotX", $$robo$$android_graphics_drawable_RotateDrawable$setPivotX(float ), 0, this, f);
    }

    public float getPivotX() {
        return (float)InvokeDynamicSupport.bootstrap("getPivotX", $$robo$$android_graphics_drawable_RotateDrawable$getPivotX(), 0, this);
    }

    public void setPivotXRelative(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPivotXRelative", $$robo$$android_graphics_drawable_RotateDrawable$setPivotXRelative(boolean ), 0, this, bl);
    }

    public boolean isPivotXRelative() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPivotXRelative", $$robo$$android_graphics_drawable_RotateDrawable$isPivotXRelative(), 0, this);
    }

    public void setPivotY(float f) {
        InvokeDynamicSupport.bootstrap("setPivotY", $$robo$$android_graphics_drawable_RotateDrawable$setPivotY(float ), 0, this, f);
    }

    public float getPivotY() {
        return (float)InvokeDynamicSupport.bootstrap("getPivotY", $$robo$$android_graphics_drawable_RotateDrawable$getPivotY(), 0, this);
    }

    public void setPivotYRelative(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPivotYRelative", $$robo$$android_graphics_drawable_RotateDrawable$setPivotYRelative(boolean ), 0, this, bl);
    }

    public boolean isPivotYRelative() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPivotYRelative", $$robo$$android_graphics_drawable_RotateDrawable$isPivotYRelative(), 0, this);
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("invalidateDrawable", $$robo$$android_graphics_drawable_RotateDrawable$invalidateDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        InvokeDynamicSupport.bootstrap("scheduleDrawable", $$robo$$android_graphics_drawable_RotateDrawable$scheduleDrawable(android.graphics.drawable.Drawable java.lang.Runnable long ), 0, this, drawable2, runnable, l);
    }

    @Override
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        InvokeDynamicSupport.bootstrap("unscheduleDrawable", $$robo$$android_graphics_drawable_RotateDrawable$unscheduleDrawable(android.graphics.drawable.Drawable java.lang.Runnable ), 0, this, drawable2, runnable);
    }

    @Override
    public boolean getPadding(Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getPadding", $$robo$$android_graphics_drawable_RotateDrawable$getPadding(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setVisible", $$robo$$android_graphics_drawable_RotateDrawable$setVisible(boolean boolean ), 0, this, bl, bl2);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_RotateDrawable$isStateful(), 0, this);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_RotateDrawable$onStateChange(int[] ), 0, this, nArray);
    }

    @Override
    protected boolean onLevelChange(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLevelChange", $$robo$$android_graphics_drawable_RotateDrawable$onLevelChange(int ), 0, this, n);
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        InvokeDynamicSupport.bootstrap("onBoundsChange", $$robo$$android_graphics_drawable_RotateDrawable$onBoundsChange(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicWidth", $$robo$$android_graphics_drawable_RotateDrawable$getIntrinsicWidth(), 0, this);
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicHeight", $$robo$$android_graphics_drawable_RotateDrawable$getIntrinsicHeight(), 0, this);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_graphics_drawable_RotateDrawable$getConstantState(), 0, this);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_RotateDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_RotateDrawable$mutate(), 0, this);
    }

    private /* synthetic */ void __constructor__(RotateState rotateState, Resources resources, 1 var3_3) {
        this.$$robo$$android_graphics_drawable_RotateDrawable$__constructor__(rotateState, resources, var3_3);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RotateDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class RotateState
    extends Drawable.ConstantState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Drawable mDrawable;
        int mChangingConfigurations;
        boolean mPivotXRel;
        float mPivotX;
        boolean mPivotYRel;
        float mPivotY;
        float mFromDegrees;
        float mToDegrees;
        float mCurrentDegrees;
        private boolean mCanConstantState;
        private boolean mCheckedConstantState;

        private void $$robo$$android_graphics_drawable_RotateDrawable_RotateState$__constructor__(RotateState orig, RotateDrawable owner, Resources res) {
            if (orig != null) {
                this.mDrawable = res != null ? orig.mDrawable.getConstantState().newDrawable(res) : orig.mDrawable.getConstantState().newDrawable();
                this.mDrawable.setCallback(owner);
                this.mDrawable.setLayoutDirection(orig.mDrawable.getLayoutDirection());
                this.mDrawable.setBounds(orig.mDrawable.getBounds());
                this.mDrawable.setLevel(orig.mDrawable.getLevel());
                this.mPivotXRel = orig.mPivotXRel;
                this.mPivotX = orig.mPivotX;
                this.mPivotYRel = orig.mPivotYRel;
                this.mPivotY = orig.mPivotY;
                this.mFromDegrees = this.mCurrentDegrees = orig.mFromDegrees;
                this.mToDegrees = orig.mToDegrees;
                this.mCheckedConstantState = true;
                this.mCanConstantState = true;
            }
        }

        private final Drawable $$robo$$android_graphics_drawable_RotateDrawable_RotateState$newDrawable() {
            return new RotateDrawable(this, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_RotateDrawable_RotateState$newDrawable(Resources res) {
            return new RotateDrawable(this, res);
        }

        private final int $$robo$$android_graphics_drawable_RotateDrawable_RotateState$getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        private final boolean $$robo$$android_graphics_drawable_RotateDrawable_RotateState$canConstantState() {
            if (!this.mCheckedConstantState) {
                this.mCanConstantState = this.mDrawable.getConstantState() != null;
                this.mCheckedConstantState = true;
            }
            return this.mCanConstantState;
        }

        private void __constructor__(RotateState rotateState, RotateDrawable rotateDrawable, Resources resources) {
            this.$$robo$$android_graphics_drawable_RotateDrawable_RotateState$__constructor__(rotateState, rotateDrawable, resources);
        }

        public RotateState(RotateState rotateState, RotateDrawable rotateDrawable, Resources resources) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RotateDrawable_RotateState$__constructor__(android.graphics.drawable.RotateDrawable$RotateState android.graphics.drawable.RotateDrawable android.content.res.Resources ), 0, this, rotateState, rotateDrawable, resources);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_RotateDrawable_RotateState$newDrawable(), 0, this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_RotateDrawable_RotateState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        @Override
        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_RotateDrawable_RotateState$getChangingConfigurations(), 0, this);
        }

        public boolean canConstantState() {
            return (boolean)InvokeDynamicSupport.bootstrap("canConstantState", $$robo$$android_graphics_drawable_RotateDrawable_RotateState$canConstantState(), 0, this);
        }

        public /* synthetic */ RotateState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RotateState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

