/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Gravity;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ScaleDrawable
extends Drawable
implements Drawable.Callback,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private ScaleState mScaleState;
    private boolean mMutated;
    private Rect mTmpRect;

    private void $$robo$$android_graphics_drawable_ScaleDrawable$__constructor__() {
    }

    private void $$robo$$android_graphics_drawable_ScaleDrawable$__constructor__(Drawable drawable2, int gravity, float scaleWidth, float scaleHeight) {
        this.mScaleState.mDrawable = drawable2;
        this.mScaleState.mGravity = gravity;
        this.mScaleState.mScaleWidth = scaleWidth;
        this.mScaleState.mScaleHeight = scaleHeight;
        if (drawable2 != null) {
            drawable2.setCallback(this);
        }
    }

    private final Drawable $$robo$$android_graphics_drawable_ScaleDrawable$getDrawable() {
        return this.mScaleState.mDrawable;
    }

    private static final float $$robo$$android_graphics_drawable_ScaleDrawable$getPercent(TypedArray a, int name) {
        String s = a.getString(name);
        if (s != null && s.endsWith("%")) {
            String f = s.substring(0, s.length() - 1);
            return Float.parseFloat(f) / 100.0f;
        }
        return -1.0f;
    }

    private final void $$robo$$android_graphics_drawable_ScaleDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int type;
        super.inflate(r, parser, attrs, theme);
        TypedArray a = ScaleDrawable.obtainAttributes(r, theme, attrs, R.styleable.ScaleDrawable);
        float sw = ScaleDrawable.getPercent(a, 1);
        float sh = ScaleDrawable.getPercent(a, 2);
        int g = a.getInt(3, 3);
        boolean min = a.getBoolean(4, false);
        Drawable dr = a.getDrawable(0);
        a.recycle();
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type != 2) continue;
            dr = Drawable.createFromXmlInner(r, parser, attrs, theme);
        }
        if (dr == null) {
            throw new IllegalArgumentException("No drawable specified for <scale>");
        }
        this.mScaleState.mDrawable = dr;
        this.mScaleState.mScaleWidth = sw;
        this.mScaleState.mScaleHeight = sh;
        this.mScaleState.mGravity = g;
        this.mScaleState.mUseIntrinsicSizeAsMin = min;
        if (dr != null) {
            dr.setCallback(this);
        }
    }

    private final void $$robo$$android_graphics_drawable_ScaleDrawable$invalidateDrawable(Drawable who) {
        if (this.getCallback() != null) {
            this.getCallback().invalidateDrawable(this);
        }
    }

    private final void $$robo$$android_graphics_drawable_ScaleDrawable$scheduleDrawable(Drawable who, Runnable what, long when) {
        if (this.getCallback() != null) {
            this.getCallback().scheduleDrawable(this, what, when);
        }
    }

    private final void $$robo$$android_graphics_drawable_ScaleDrawable$unscheduleDrawable(Drawable who, Runnable what) {
        if (this.getCallback() != null) {
            this.getCallback().unscheduleDrawable(this, what);
        }
    }

    private final void $$robo$$android_graphics_drawable_ScaleDrawable$draw(Canvas canvas) {
        if (this.mScaleState.mDrawable.getLevel() != 0) {
            this.mScaleState.mDrawable.draw(canvas);
        }
    }

    private final int $$robo$$android_graphics_drawable_ScaleDrawable$getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mScaleState.mChangingConfigurations | this.mScaleState.mDrawable.getChangingConfigurations();
    }

    private final boolean $$robo$$android_graphics_drawable_ScaleDrawable$getPadding(Rect padding) {
        return this.mScaleState.mDrawable.getPadding(padding);
    }

    private final boolean $$robo$$android_graphics_drawable_ScaleDrawable$setVisible(boolean visible, boolean restart) {
        this.mScaleState.mDrawable.setVisible(visible, restart);
        return super.setVisible(visible, restart);
    }

    private final void $$robo$$android_graphics_drawable_ScaleDrawable$setAlpha(int alpha) {
        this.mScaleState.mDrawable.setAlpha(alpha);
    }

    private final int $$robo$$android_graphics_drawable_ScaleDrawable$getAlpha() {
        return this.mScaleState.mDrawable.getAlpha();
    }

    private final void $$robo$$android_graphics_drawable_ScaleDrawable$setColorFilter(ColorFilter cf) {
        this.mScaleState.mDrawable.setColorFilter(cf);
    }

    private final void $$robo$$android_graphics_drawable_ScaleDrawable$setTintList(ColorStateList tint) {
        this.mScaleState.mDrawable.setTintList(tint);
    }

    private final void $$robo$$android_graphics_drawable_ScaleDrawable$setTintMode(PorterDuff.Mode tintMode) {
        this.mScaleState.mDrawable.setTintMode(tintMode);
    }

    private final int $$robo$$android_graphics_drawable_ScaleDrawable$getOpacity() {
        return this.mScaleState.mDrawable.getOpacity();
    }

    private final boolean $$robo$$android_graphics_drawable_ScaleDrawable$isStateful() {
        return this.mScaleState.mDrawable.isStateful();
    }

    private final boolean $$robo$$android_graphics_drawable_ScaleDrawable$onStateChange(int[] state) {
        boolean changed = this.mScaleState.mDrawable.setState(state);
        this.onBoundsChange(this.getBounds());
        return changed;
    }

    private final boolean $$robo$$android_graphics_drawable_ScaleDrawable$onLevelChange(int level) {
        this.mScaleState.mDrawable.setLevel(level);
        this.onBoundsChange(this.getBounds());
        this.invalidateSelf();
        return true;
    }

    private final void $$robo$$android_graphics_drawable_ScaleDrawable$onBoundsChange(Rect bounds) {
        Rect r = this.mTmpRect;
        boolean min = this.mScaleState.mUseIntrinsicSizeAsMin;
        int level = this.getLevel();
        int w = bounds.width();
        if (this.mScaleState.mScaleWidth > 0.0f) {
            int iw = min ? this.mScaleState.mDrawable.getIntrinsicWidth() : 0;
            w -= (int)((float)((w - iw) * (10000 - level)) * this.mScaleState.mScaleWidth / 10000.0f);
        }
        int h = bounds.height();
        if (this.mScaleState.mScaleHeight > 0.0f) {
            int ih = min ? this.mScaleState.mDrawable.getIntrinsicHeight() : 0;
            h -= (int)((float)((h - ih) * (10000 - level)) * this.mScaleState.mScaleHeight / 10000.0f);
        }
        int layoutDirection = this.getLayoutDirection();
        Gravity.apply(this.mScaleState.mGravity, w, h, bounds, r, layoutDirection);
        if (w > 0 && h > 0) {
            this.mScaleState.mDrawable.setBounds(r.left, r.top, r.right, r.bottom);
        }
    }

    private final int $$robo$$android_graphics_drawable_ScaleDrawable$getIntrinsicWidth() {
        return this.mScaleState.mDrawable.getIntrinsicWidth();
    }

    private final int $$robo$$android_graphics_drawable_ScaleDrawable$getIntrinsicHeight() {
        return this.mScaleState.mDrawable.getIntrinsicHeight();
    }

    private final Drawable.ConstantState $$robo$$android_graphics_drawable_ScaleDrawable$getConstantState() {
        if (this.mScaleState.canConstantState()) {
            this.mScaleState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mScaleState;
        }
        return null;
    }

    private final Drawable $$robo$$android_graphics_drawable_ScaleDrawable$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mScaleState.mDrawable.mutate();
            this.mMutated = true;
        }
        return this;
    }

    private void $$robo$$android_graphics_drawable_ScaleDrawable$__constructor__(ScaleState state, Resources res) {
        this.mTmpRect = new Rect();
        this.mScaleState = new ScaleState(state, this, res);
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_ScaleDrawable$__constructor__(ScaleState x0, Resources x1, 1 x2) {
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_ScaleDrawable$__constructor__();
    }

    ScaleDrawable() {
        this(null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_ScaleDrawable$__constructor__(), 0, this);
    }

    private void __constructor__(Drawable drawable2, int n, float f, float f2) {
        this.$$robo$$android_graphics_drawable_ScaleDrawable$__constructor__(drawable2, n, f, f2);
    }

    public ScaleDrawable(Drawable drawable2, int n, float f, float f2) {
        this(null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_ScaleDrawable$__constructor__(android.graphics.drawable.Drawable int float float ), 0, this, drawable2, n, f, f2);
    }

    public Drawable getDrawable() {
        return InvokeDynamicSupport.bootstrap("getDrawable", $$robo$$android_graphics_drawable_ScaleDrawable$getDrawable(), 0, this);
    }

    private static float getPercent(TypedArray typedArray, int n) {
        return (float)InvokeDynamicSupport.bootstrapStatic("getPercent", $$robo$$android_graphics_drawable_ScaleDrawable$getPercent(android.content.res.TypedArray int ), 0, (TypedArray)typedArray, (int)n);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_ScaleDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("invalidateDrawable", $$robo$$android_graphics_drawable_ScaleDrawable$invalidateDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        InvokeDynamicSupport.bootstrap("scheduleDrawable", $$robo$$android_graphics_drawable_ScaleDrawable$scheduleDrawable(android.graphics.drawable.Drawable java.lang.Runnable long ), 0, this, drawable2, runnable, l);
    }

    @Override
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        InvokeDynamicSupport.bootstrap("unscheduleDrawable", $$robo$$android_graphics_drawable_ScaleDrawable$unscheduleDrawable(android.graphics.drawable.Drawable java.lang.Runnable ), 0, this, drawable2, runnable);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_ScaleDrawable$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_ScaleDrawable$getChangingConfigurations(), 0, this);
    }

    @Override
    public boolean getPadding(Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getPadding", $$robo$$android_graphics_drawable_ScaleDrawable$getPadding(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setVisible", $$robo$$android_graphics_drawable_ScaleDrawable$setVisible(boolean boolean ), 0, this, bl, bl2);
    }

    @Override
    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_drawable_ScaleDrawable$setAlpha(int ), 0, this, n);
    }

    @Override
    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_drawable_ScaleDrawable$getAlpha(), 0, this);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_graphics_drawable_ScaleDrawable$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setTintList", $$robo$$android_graphics_drawable_ScaleDrawable$setTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setTintMode", $$robo$$android_graphics_drawable_ScaleDrawable$setTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_ScaleDrawable$getOpacity(), 0, this);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_ScaleDrawable$isStateful(), 0, this);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_ScaleDrawable$onStateChange(int[] ), 0, this, nArray);
    }

    @Override
    protected boolean onLevelChange(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLevelChange", $$robo$$android_graphics_drawable_ScaleDrawable$onLevelChange(int ), 0, this, n);
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        InvokeDynamicSupport.bootstrap("onBoundsChange", $$robo$$android_graphics_drawable_ScaleDrawable$onBoundsChange(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicWidth", $$robo$$android_graphics_drawable_ScaleDrawable$getIntrinsicWidth(), 0, this);
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicHeight", $$robo$$android_graphics_drawable_ScaleDrawable$getIntrinsicHeight(), 0, this);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_graphics_drawable_ScaleDrawable$getConstantState(), 0, this);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_ScaleDrawable$mutate(), 0, this);
    }

    private void __constructor__(ScaleState scaleState, Resources resources) {
        this.$$robo$$android_graphics_drawable_ScaleDrawable$__constructor__(scaleState, resources);
    }

    private ScaleDrawable(ScaleState scaleState, Resources resources) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_ScaleDrawable$__constructor__(android.graphics.drawable.ScaleDrawable$ScaleState android.content.res.Resources ), 0, this, scaleState, resources);
    }

    private /* synthetic */ void __constructor__(ScaleState scaleState, Resources resources, 1 var3_3) {
        this.$$robo$$android_graphics_drawable_ScaleDrawable$__constructor__(scaleState, resources, var3_3);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScaleDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ScaleState
    extends Drawable.ConstantState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Drawable mDrawable;
        int mChangingConfigurations;
        float mScaleWidth;
        float mScaleHeight;
        int mGravity;
        boolean mUseIntrinsicSizeAsMin;
        private boolean mCheckedConstantState;
        private boolean mCanConstantState;

        private void $$robo$$android_graphics_drawable_ScaleDrawable_ScaleState$__constructor__(ScaleState orig, ScaleDrawable owner, Resources res) {
            if (orig != null) {
                this.mDrawable = res != null ? orig.mDrawable.getConstantState().newDrawable(res) : orig.mDrawable.getConstantState().newDrawable();
                this.mDrawable.setCallback(owner);
                this.mDrawable.setLayoutDirection(orig.mDrawable.getLayoutDirection());
                this.mDrawable.setBounds(orig.mDrawable.getBounds());
                this.mDrawable.setLevel(orig.mDrawable.getLevel());
                this.mScaleWidth = orig.mScaleWidth;
                this.mScaleHeight = orig.mScaleHeight;
                this.mGravity = orig.mGravity;
                this.mUseIntrinsicSizeAsMin = orig.mUseIntrinsicSizeAsMin;
                this.mCanConstantState = true;
                this.mCheckedConstantState = true;
            }
        }

        private final Drawable $$robo$$android_graphics_drawable_ScaleDrawable_ScaleState$newDrawable() {
            return new ScaleDrawable(this, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_ScaleDrawable_ScaleState$newDrawable(Resources res) {
            return new ScaleDrawable(this, res);
        }

        private final int $$robo$$android_graphics_drawable_ScaleDrawable_ScaleState$getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        private final boolean $$robo$$android_graphics_drawable_ScaleDrawable_ScaleState$canConstantState() {
            if (!this.mCheckedConstantState) {
                this.mCanConstantState = this.mDrawable.getConstantState() != null;
                this.mCheckedConstantState = true;
            }
            return this.mCanConstantState;
        }

        private void __constructor__(ScaleState scaleState, ScaleDrawable scaleDrawable, Resources resources) {
            this.$$robo$$android_graphics_drawable_ScaleDrawable_ScaleState$__constructor__(scaleState, scaleDrawable, resources);
        }

        ScaleState(ScaleState scaleState, ScaleDrawable scaleDrawable, Resources resources) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_ScaleDrawable_ScaleState$__constructor__(android.graphics.drawable.ScaleDrawable$ScaleState android.graphics.drawable.ScaleDrawable android.content.res.Resources ), 0, this, scaleState, scaleDrawable, resources);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_ScaleDrawable_ScaleState$newDrawable(), 0, this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_ScaleDrawable_ScaleState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        @Override
        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_ScaleDrawable_ScaleState$getChangingConfigurations(), 0, this);
        }

        boolean canConstantState() {
            return (boolean)InvokeDynamicSupport.bootstrap("canConstantState", $$robo$$android_graphics_drawable_ScaleDrawable_ScaleState$canConstantState(), 0, this);
        }

        public /* synthetic */ ScaleState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScaleState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

