/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.util.AttributeSet;
import android.util.StateSet;
import com.android.internal.R;
import java.io.IOException;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class StateListDrawable
extends DrawableContainer
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static boolean DEBUG = false;
    private static boolean DEFAULT_DITHER = true;
    private StateListState mStateListState;
    private boolean mMutated;

    private void $$robo$$android_graphics_drawable_StateListDrawable$__constructor__() {
    }

    private final void $$robo$$android_graphics_drawable_StateListDrawable$addState(int[] stateSet, Drawable drawable2) {
        if (drawable2 != null) {
            this.mStateListState.addStateSet(stateSet, drawable2);
            this.onStateChange(this.getState());
        }
    }

    private final boolean $$robo$$android_graphics_drawable_StateListDrawable$isStateful() {
        return true;
    }

    private final boolean $$robo$$android_graphics_drawable_StateListDrawable$onStateChange(int[] stateSet) {
        int idx = this.mStateListState.indexOfStateSet(stateSet);
        if (idx < 0) {
            idx = this.mStateListState.indexOfStateSet(StateSet.WILD_CARD);
        }
        if (this.selectDrawable(idx)) {
            return true;
        }
        return super.onStateChange(stateSet);
    }

    private final void $$robo$$android_graphics_drawable_StateListDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        TypedArray a = StateListDrawable.obtainAttributes(r, theme, attrs, R.styleable.StateListDrawable);
        super.inflateWithAttributes(r, parser, a, 1);
        this.mStateListState.setVariablePadding(a.getBoolean(2, false));
        this.mStateListState.setConstantSize(a.getBoolean(3, false));
        this.mStateListState.setEnterFadeDuration(a.getInt(4, 0));
        this.mStateListState.setExitFadeDuration(a.getInt(5, 0));
        this.setDither(a.getBoolean(0, true));
        this.setAutoMirrored(a.getBoolean(6, false));
        a.recycle();
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            Drawable dr;
            int stateResId;
            if (type != 2 || depth > innerDepth || !parser.getName().equals("item")) continue;
            int drawableRes = 0;
            int j = 0;
            int numAttrs = attrs.getAttributeCount();
            int[] states = new int[numAttrs];
            for (int i = 0; i < numAttrs && (stateResId = attrs.getAttributeNameResource(i)) != 0; ++i) {
                if (stateResId == 0x1010199) {
                    drawableRes = attrs.getAttributeResourceValue(i, 0);
                    continue;
                }
                states[j++] = attrs.getAttributeBooleanValue(i, false) ? stateResId : -stateResId;
            }
            states = StateSet.trimStateSet(states, j);
            if (drawableRes != 0) {
                dr = r.getDrawable(drawableRes, theme);
            } else {
                while ((type = parser.next()) == 4) {
                }
                if (type != 2) {
                    throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
                }
                dr = Drawable.createFromXmlInner(r, parser, attrs, theme);
            }
            this.mStateListState.addStateSet(states, dr);
        }
        this.onStateChange(this.getState());
    }

    private final StateListState $$robo$$android_graphics_drawable_StateListDrawable$getStateListState() {
        return this.mStateListState;
    }

    private final int $$robo$$android_graphics_drawable_StateListDrawable$getStateCount() {
        return this.mStateListState.getChildCount();
    }

    private final int[] $$robo$$android_graphics_drawable_StateListDrawable$getStateSet(int index) {
        return this.mStateListState.mStateSets[index];
    }

    private final Drawable $$robo$$android_graphics_drawable_StateListDrawable$getStateDrawable(int index) {
        return this.mStateListState.getChild(index);
    }

    private final int $$robo$$android_graphics_drawable_StateListDrawable$getStateDrawableIndex(int[] stateSet) {
        return this.mStateListState.indexOfStateSet(stateSet);
    }

    private final Drawable $$robo$$android_graphics_drawable_StateListDrawable$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            int[][] sets = this.mStateListState.mStateSets;
            int count = sets.length;
            this.mStateListState.mStateSets = new int[count][];
            for (int i = 0; i < count; ++i) {
                int[] set = sets[i];
                if (set == null) continue;
                this.mStateListState.mStateSets[i] = (int[])set.clone();
            }
            this.mMutated = true;
        }
        return this;
    }

    private final void $$robo$$android_graphics_drawable_StateListDrawable$setLayoutDirection(int layoutDirection) {
        super.setLayoutDirection(layoutDirection);
        this.mStateListState.setLayoutDirection(layoutDirection);
    }

    private final void $$robo$$android_graphics_drawable_StateListDrawable$setConstantState(StateListState state) {
        super.setConstantState(state);
        this.mStateListState = state;
    }

    private void $$robo$$android_graphics_drawable_StateListDrawable$__constructor__(StateListState state, Resources res) {
        StateListState newState = new StateListState(state, this, res);
        this.setConstantState(newState);
        this.onStateChange(this.getState());
    }

    private void $$robo$$android_graphics_drawable_StateListDrawable$__constructor__(StateListState state) {
        if (state != null) {
            this.setConstantState(state);
        }
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_StateListDrawable$__constructor__(StateListState x0, Resources x1, 1 x2) {
    }

    static void __staticInitializer__() {
        TAG = StateListDrawable.class.getSimpleName();
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_StateListDrawable$__constructor__();
    }

    public StateListDrawable() {
        this(null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_StateListDrawable$__constructor__(), 0, this);
    }

    public void addState(int[] nArray, Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("addState", $$robo$$android_graphics_drawable_StateListDrawable$addState(int[] android.graphics.drawable.Drawable ), 0, this, nArray, drawable2);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_StateListDrawable$isStateful(), 0, this);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_StateListDrawable$onStateChange(int[] ), 0, this, nArray);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_StateListDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    StateListState getStateListState() {
        return InvokeDynamicSupport.bootstrap("getStateListState", $$robo$$android_graphics_drawable_StateListDrawable$getStateListState(), 0, this);
    }

    public int getStateCount() {
        return (int)InvokeDynamicSupport.bootstrap("getStateCount", $$robo$$android_graphics_drawable_StateListDrawable$getStateCount(), 0, this);
    }

    public int[] getStateSet(int n) {
        return InvokeDynamicSupport.bootstrap("getStateSet", $$robo$$android_graphics_drawable_StateListDrawable$getStateSet(int ), 0, this, n);
    }

    public Drawable getStateDrawable(int n) {
        return InvokeDynamicSupport.bootstrap("getStateDrawable", $$robo$$android_graphics_drawable_StateListDrawable$getStateDrawable(int ), 0, this, n);
    }

    public int getStateDrawableIndex(int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrap("getStateDrawableIndex", $$robo$$android_graphics_drawable_StateListDrawable$getStateDrawableIndex(int[] ), 0, this, nArray);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_StateListDrawable$mutate(), 0, this);
    }

    @Override
    public void setLayoutDirection(int n) {
        InvokeDynamicSupport.bootstrap("setLayoutDirection", $$robo$$android_graphics_drawable_StateListDrawable$setLayoutDirection(int ), 0, this, n);
    }

    void setConstantState(StateListState stateListState) {
        InvokeDynamicSupport.bootstrap("setConstantState", $$robo$$android_graphics_drawable_StateListDrawable$setConstantState(android.graphics.drawable.StateListDrawable$StateListState ), 0, this, stateListState);
    }

    private void __constructor__(StateListState stateListState, Resources resources) {
        this.$$robo$$android_graphics_drawable_StateListDrawable$__constructor__(stateListState, resources);
    }

    private StateListDrawable(StateListState stateListState, Resources resources) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_StateListDrawable$__constructor__(android.graphics.drawable.StateListDrawable$StateListState android.content.res.Resources ), 0, this, stateListState, resources);
    }

    private void __constructor__(StateListState stateListState) {
        this.$$robo$$android_graphics_drawable_StateListDrawable$__constructor__(stateListState);
    }

    StateListDrawable(StateListState stateListState) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_StateListDrawable$__constructor__(android.graphics.drawable.StateListDrawable$StateListState ), 0, this, stateListState);
    }

    private /* synthetic */ void __constructor__(StateListState stateListState, Resources resources, 1 var3_3) {
        this.$$robo$$android_graphics_drawable_StateListDrawable$__constructor__(stateListState, resources, var3_3);
    }

    static {
        RobolectricInternals.classInitializing(StateListDrawable.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StateListDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class StateListState
    extends DrawableContainer.DrawableContainerState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int[][] mStateSets;

        private void $$robo$$android_graphics_drawable_StateListDrawable_StateListState$__constructor__(StateListState orig, StateListDrawable owner, Resources res) {
            this.mStateSets = orig != null ? (int[][])Arrays.copyOf(orig.mStateSets, orig.mStateSets.length) : (int[][])new int[this.getCapacity()][];
        }

        private final int $$robo$$android_graphics_drawable_StateListDrawable_StateListState$addStateSet(int[] stateSet, Drawable drawable2) {
            int pos = this.addChild(drawable2);
            this.mStateSets[pos] = stateSet;
            return pos;
        }

        private final int $$robo$$android_graphics_drawable_StateListDrawable_StateListState$indexOfStateSet(int[] stateSet) {
            int[][] stateSets = this.mStateSets;
            int N = this.getChildCount();
            for (int i = 0; i < N; ++i) {
                if (!StateSet.stateSetMatches(stateSets[i], stateSet)) continue;
                return i;
            }
            return -1;
        }

        private final Drawable $$robo$$android_graphics_drawable_StateListDrawable_StateListState$newDrawable() {
            return new StateListDrawable(this, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_StateListDrawable_StateListState$newDrawable(Resources res) {
            return new StateListDrawable(this, res);
        }

        private final void $$robo$$android_graphics_drawable_StateListDrawable_StateListState$growArray(int oldSize, int newSize) {
            super.growArray(oldSize, newSize);
            int[][] newStateSets = new int[newSize][];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mStateSets, (int)0, (Object)newStateSets, (int)0, (int)oldSize);
            this.mStateSets = newStateSets;
        }

        private void __constructor__(StateListState stateListState, StateListDrawable stateListDrawable, Resources resources) {
            this.$$robo$$android_graphics_drawable_StateListDrawable_StateListState$__constructor__(stateListState, stateListDrawable, resources);
        }

        StateListState(StateListState stateListState, StateListDrawable stateListDrawable, Resources resources) {
            super(stateListState, stateListDrawable, resources);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_StateListDrawable_StateListState$__constructor__(android.graphics.drawable.StateListDrawable$StateListState android.graphics.drawable.StateListDrawable android.content.res.Resources ), 0, this, stateListState, stateListDrawable, resources);
        }

        int addStateSet(int[] nArray, Drawable drawable2) {
            return (int)InvokeDynamicSupport.bootstrap("addStateSet", $$robo$$android_graphics_drawable_StateListDrawable_StateListState$addStateSet(int[] android.graphics.drawable.Drawable ), 0, this, nArray, drawable2);
        }

        int indexOfStateSet(int[] nArray) {
            return (int)InvokeDynamicSupport.bootstrap("indexOfStateSet", $$robo$$android_graphics_drawable_StateListDrawable_StateListState$indexOfStateSet(int[] ), 0, this, nArray);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_StateListDrawable_StateListState$newDrawable(), 0, this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_StateListDrawable_StateListState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        @Override
        public void growArray(int n, int n2) {
            InvokeDynamicSupport.bootstrap("growArray", $$robo$$android_graphics_drawable_StateListDrawable_StateListState$growArray(int int ), 0, this, n, n2);
        }

        public /* synthetic */ StateListState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StateListState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

