/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.Log;
import android.util.PathParser;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class VectorDrawable
extends Drawable
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOGTAG;
    private static String SHAPE_CLIP_PATH = "clip-path";
    private static String SHAPE_GROUP = "group";
    private static String SHAPE_PATH = "path";
    private static String SHAPE_VECTOR = "vector";
    private static int LINECAP_BUTT = 0;
    private static int LINECAP_ROUND = 1;
    private static int LINECAP_SQUARE = 2;
    private static int LINEJOIN_MITER = 0;
    private static int LINEJOIN_ROUND = 1;
    private static int LINEJOIN_BEVEL = 2;
    private static boolean DBG_VECTOR_DRAWABLE = false;
    private VectorDrawableState mVectorState;
    private PorterDuffColorFilter mTintFilter;
    private ColorFilter mColorFilter;
    private boolean mMutated;
    private boolean mAllowCaching;

    private void $$robo$$android_graphics_drawable_VectorDrawable$__constructor__() {
        this.mAllowCaching = true;
        this.mVectorState = new VectorDrawableState();
    }

    private void $$robo$$android_graphics_drawable_VectorDrawable$__constructor__(VectorDrawableState state, Resources res, Resources.Theme theme) {
        this.mAllowCaching = true;
        if (theme != null && state.canApplyTheme()) {
            this.mVectorState = new VectorDrawableState(state);
            this.applyTheme(theme);
        } else {
            this.mVectorState = state;
        }
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, state.mTintMode);
    }

    private final Drawable $$robo$$android_graphics_drawable_VectorDrawable$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mVectorState = new VectorDrawableState(this.mVectorState);
            this.mMutated = true;
        }
        return this;
    }

    private final Object $$robo$$android_graphics_drawable_VectorDrawable$getTargetByName(String name) {
        return this.mVectorState.mVPathRenderer.mVGTargetsMap.get(name);
    }

    private final Drawable.ConstantState $$robo$$android_graphics_drawable_VectorDrawable$getConstantState() {
        this.mVectorState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mVectorState;
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$draw(Canvas canvas) {
        ColorFilter colorFilter;
        Rect bounds = this.getBounds();
        if (bounds.width() == 0 || bounds.height() == 0) {
            return;
        }
        int saveCount = canvas.save();
        boolean needMirroring = this.needMirroring();
        canvas.translate(bounds.left, bounds.top);
        if (needMirroring) {
            canvas.translate(bounds.width(), 0.0f);
            canvas.scale(-1.0f, 1.0f);
        }
        ColorFilter colorFilter2 = colorFilter = this.mColorFilter == null ? this.mTintFilter : this.mColorFilter;
        if (!this.mAllowCaching) {
            if (!this.mVectorState.hasTranslucentRoot()) {
                this.mVectorState.mVPathRenderer.draw(canvas, bounds.width(), bounds.height(), colorFilter);
            } else {
                this.mVectorState.createCachedBitmapIfNeeded(bounds);
                this.mVectorState.updateCachedBitmap(bounds);
                this.mVectorState.drawCachedBitmapWithRootAlpha(canvas, colorFilter);
            }
        } else {
            this.mVectorState.createCachedBitmapIfNeeded(bounds);
            if (!this.mVectorState.canReuseCache()) {
                this.mVectorState.updateCachedBitmap(bounds);
                this.mVectorState.updateCacheStates();
            }
            this.mVectorState.drawCachedBitmapWithRootAlpha(canvas, colorFilter);
        }
        canvas.restoreToCount(saveCount);
    }

    private final int $$robo$$android_graphics_drawable_VectorDrawable$getAlpha() {
        return this.mVectorState.mVPathRenderer.getRootAlpha();
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$setAlpha(int alpha) {
        if (this.mVectorState.mVPathRenderer.getRootAlpha() != alpha) {
            this.mVectorState.mVPathRenderer.setRootAlpha(alpha);
            this.invalidateSelf();
        }
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$setColorFilter(ColorFilter colorFilter) {
        this.mColorFilter = colorFilter;
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$setTintList(ColorStateList tint) {
        VectorDrawableState state = this.mVectorState;
        if (state.mTint != tint) {
            state.mTint = tint;
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, tint, state.mTintMode);
            this.invalidateSelf();
        }
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$setTintMode(PorterDuff.Mode tintMode) {
        VectorDrawableState state = this.mVectorState;
        if (state.mTintMode != tintMode) {
            state.mTintMode = tintMode;
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, tintMode);
            this.invalidateSelf();
        }
    }

    private final boolean $$robo$$android_graphics_drawable_VectorDrawable$isStateful() {
        return super.isStateful() || this.mVectorState != null && this.mVectorState.mTint != null && this.mVectorState.mTint.isStateful();
    }

    private final boolean $$robo$$android_graphics_drawable_VectorDrawable$onStateChange(int[] stateSet) {
        VectorDrawableState state = this.mVectorState;
        if (state.mTint != null && state.mTintMode != null) {
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, state.mTintMode);
            this.invalidateSelf();
            return true;
        }
        return false;
    }

    private final int $$robo$$android_graphics_drawable_VectorDrawable$getOpacity() {
        return -3;
    }

    private final int $$robo$$android_graphics_drawable_VectorDrawable$getIntrinsicWidth() {
        return (int)this.mVectorState.mVPathRenderer.mBaseWidth;
    }

    private final int $$robo$$android_graphics_drawable_VectorDrawable$getIntrinsicHeight() {
        return (int)this.mVectorState.mVPathRenderer.mBaseHeight;
    }

    private final boolean $$robo$$android_graphics_drawable_VectorDrawable$canApplyTheme() {
        return super.canApplyTheme() || this.mVectorState != null && this.mVectorState.canApplyTheme();
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$applyTheme(Resources.Theme t) {
        VPathRenderer path;
        super.applyTheme(t);
        VectorDrawableState state = this.mVectorState;
        if (state != null && state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.VectorDrawable);
            try {
                state.mCacheDirty = true;
                this.updateStateFromTypedArray(a);
            }
            catch (XmlPullParserException e) {
                throw new RuntimeException(e);
            }
            finally {
                a.recycle();
            }
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, state.mTintMode);
        }
        if ((path = state.mVPathRenderer) != null && path.canApplyTheme()) {
            path.applyTheme(t);
        }
    }

    private final float $$robo$$android_graphics_drawable_VectorDrawable$getPixelSize() {
        if (this.mVectorState == null && this.mVectorState.mVPathRenderer == null || this.mVectorState.mVPathRenderer.mBaseWidth == 0.0f || this.mVectorState.mVPathRenderer.mBaseHeight == 0.0f || this.mVectorState.mVPathRenderer.mViewportHeight == 0.0f || this.mVectorState.mVPathRenderer.mViewportWidth == 0.0f) {
            return 1.0f;
        }
        float intrinsicWidth = this.mVectorState.mVPathRenderer.mBaseWidth;
        float intrinsicHeight = this.mVectorState.mVPathRenderer.mBaseHeight;
        float viewportWidth = this.mVectorState.mVPathRenderer.mViewportWidth;
        float viewportHeight = this.mVectorState.mVPathRenderer.mViewportHeight;
        float scaleX = viewportWidth / intrinsicWidth;
        float scaleY = viewportHeight / intrinsicHeight;
        return Math.min(scaleX, scaleY);
    }

    private static final VectorDrawable $$robo$$android_graphics_drawable_VectorDrawable$create(Resources resources, int rid) {
        try {
            int type;
            XmlResourceParser parser = resources.getXml(rid);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                throw new XmlPullParserException("No start tag found");
            }
            VectorDrawable drawable2 = new VectorDrawable();
            drawable2.inflate(resources, parser, attrs);
            return drawable2;
        }
        catch (XmlPullParserException e) {
            Log.e(LOGTAG, "parser error", e);
        }
        catch (IOException e) {
            Log.e(LOGTAG, "parser error", e);
        }
        return null;
    }

    private static final int $$robo$$android_graphics_drawable_VectorDrawable$applyAlpha(int color2, float alpha) {
        int alphaBytes = Color.alpha(color2);
        color2 &= 0xFFFFFF;
        return color2 |= (int)((float)alphaBytes * alpha) << 24;
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$inflate(Resources res, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        VPathRenderer pathRenderer;
        VectorDrawableState state = this.mVectorState;
        state.mVPathRenderer = pathRenderer = new VPathRenderer();
        TypedArray a = VectorDrawable.obtainAttributes(res, theme, attrs, R.styleable.VectorDrawable);
        this.updateStateFromTypedArray(a);
        a.recycle();
        state.mCacheDirty = true;
        this.inflateInternal(res, parser, attrs, theme);
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, state.mTintMode);
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$updateStateFromTypedArray(TypedArray a) throws XmlPullParserException {
        ColorStateList tint;
        VectorDrawableState state = this.mVectorState;
        VPathRenderer pathRenderer = state.mVPathRenderer;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mThemeAttrs = a.extractThemeAttrs();
        int tintMode = a.getInt(6, -1);
        if (tintMode != -1) {
            state.mTintMode = Drawable.parseTintMode(tintMode, PorterDuff.Mode.SRC_IN);
        }
        if ((tint = a.getColorStateList(1)) != null) {
            state.mTint = tint;
        }
        state.mAutoMirrored = a.getBoolean(5, state.mAutoMirrored);
        pathRenderer.mViewportWidth = a.getFloat(7, pathRenderer.mViewportWidth);
        pathRenderer.mViewportHeight = a.getFloat(8, pathRenderer.mViewportHeight);
        if (pathRenderer.mViewportWidth <= 0.0f) {
            throw new XmlPullParserException(a.getPositionDescription() + "<vector> tag requires viewportWidth > 0");
        }
        if (pathRenderer.mViewportHeight <= 0.0f) {
            throw new XmlPullParserException(a.getPositionDescription() + "<vector> tag requires viewportHeight > 0");
        }
        pathRenderer.mBaseWidth = a.getDimension(3, pathRenderer.mBaseWidth);
        pathRenderer.mBaseHeight = a.getDimension(2, pathRenderer.mBaseHeight);
        if (pathRenderer.mBaseWidth <= 0.0f) {
            throw new XmlPullParserException(a.getPositionDescription() + "<vector> tag requires width > 0");
        }
        if (pathRenderer.mBaseHeight <= 0.0f) {
            throw new XmlPullParserException(a.getPositionDescription() + "<vector> tag requires height > 0");
        }
        float alphaInFloat = a.getFloat(4, pathRenderer.getAlpha());
        pathRenderer.setAlpha(alphaInFloat);
        String name = a.getString(0);
        if (name != null) {
            pathRenderer.mRootName = name;
            pathRenderer.mVGTargetsMap.put(name, pathRenderer);
        }
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$inflateInternal(Resources res, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        VectorDrawableState state = this.mVectorState;
        VPathRenderer pathRenderer = state.mVPathRenderer;
        boolean noPathTag = true;
        Stack<VGroup> groupStack = new Stack<VGroup>();
        groupStack.push(pathRenderer.mRootGroup);
        int eventType = parser.getEventType();
        while (eventType != 1) {
            String tagName;
            if (eventType == 2) {
                VPath path;
                tagName = parser.getName();
                VGroup currentGroup = (VGroup)groupStack.peek();
                if ("path".equals(tagName)) {
                    path = new VFullPath();
                    ((VFullPath)path).inflate(res, attrs, theme);
                    currentGroup.mChildren.add(path);
                    if (path.getPathName() != null) {
                        pathRenderer.mVGTargetsMap.put(path.getPathName(), path);
                    }
                    noPathTag = false;
                    state.mChangingConfigurations |= ((VFullPath)path).mChangingConfigurations;
                } else if ("clip-path".equals(tagName)) {
                    path = new VClipPath();
                    ((VClipPath)path).inflate(res, attrs, theme);
                    currentGroup.mChildren.add(path);
                    if (path.getPathName() != null) {
                        pathRenderer.mVGTargetsMap.put(path.getPathName(), path);
                    }
                    state.mChangingConfigurations |= ((VClipPath)path).mChangingConfigurations;
                } else if ("group".equals(tagName)) {
                    VGroup newChildGroup = new VGroup();
                    newChildGroup.inflate(res, attrs, theme);
                    currentGroup.mChildren.add(newChildGroup);
                    groupStack.push(newChildGroup);
                    if (newChildGroup.getGroupName() != null) {
                        pathRenderer.mVGTargetsMap.put(newChildGroup.getGroupName(), newChildGroup);
                    }
                    state.mChangingConfigurations |= newChildGroup.mChangingConfigurations;
                }
            } else if (eventType == 3 && "group".equals(tagName = parser.getName())) {
                groupStack.pop();
            }
            eventType = parser.next();
        }
        if (noPathTag) {
            StringBuffer tag = new StringBuffer();
            if (tag.length() > 0) {
                tag.append(" or ");
            }
            tag.append("path");
            throw new XmlPullParserException("no " + tag + " defined");
        }
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$printGroupTree(VGroup currentGroup, int level) {
        int i;
        String indent = "";
        for (i = 0; i < level; ++i) {
            indent = indent + "    ";
        }
        Log.v(LOGTAG, indent + "current group is :" + currentGroup.getGroupName() + " rotation is " + currentGroup.mRotate);
        Log.v(LOGTAG, indent + "matrix is :" + currentGroup.getLocalMatrix().toString());
        for (i = 0; i < currentGroup.mChildren.size(); ++i) {
            Object child = currentGroup.mChildren.get(i);
            if (!(child instanceof VGroup)) continue;
            this.printGroupTree((VGroup)child, level + 1);
        }
    }

    private final int $$robo$$android_graphics_drawable_VectorDrawable$getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mVectorState.mChangingConfigurations;
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$setAllowCaching(boolean allowCaching) {
        this.mAllowCaching = allowCaching;
    }

    private final boolean $$robo$$android_graphics_drawable_VectorDrawable$needMirroring() {
        return this.isAutoMirrored() && this.getLayoutDirection() == 1;
    }

    private final void $$robo$$android_graphics_drawable_VectorDrawable$setAutoMirrored(boolean mirrored) {
        if (this.mVectorState.mAutoMirrored != mirrored) {
            this.mVectorState.mAutoMirrored = mirrored;
            this.invalidateSelf();
        }
    }

    private final boolean $$robo$$android_graphics_drawable_VectorDrawable$isAutoMirrored() {
        return this.mVectorState.mAutoMirrored;
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_VectorDrawable$__constructor__(VectorDrawableState x0, Resources x1, Resources.Theme x2, 1 x3) {
    }

    static void __staticInitializer__() {
        LOGTAG = VectorDrawable.class.getSimpleName();
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_VectorDrawable$__constructor__();
    }

    public VectorDrawable() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable$__constructor__(), 0, this);
    }

    private void __constructor__(VectorDrawableState vectorDrawableState, Resources resources, Resources.Theme theme) {
        this.$$robo$$android_graphics_drawable_VectorDrawable$__constructor__(vectorDrawableState, resources, theme);
    }

    private VectorDrawable(VectorDrawableState vectorDrawableState, Resources resources, Resources.Theme theme) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable$__constructor__(android.graphics.drawable.VectorDrawable$VectorDrawableState android.content.res.Resources android.content.res.Resources$Theme ), 0, this, vectorDrawableState, resources, theme);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_VectorDrawable$mutate(), 0, this);
    }

    Object getTargetByName(String string2) {
        return InvokeDynamicSupport.bootstrap("getTargetByName", $$robo$$android_graphics_drawable_VectorDrawable$getTargetByName(java.lang.String ), 0, this, string2);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_graphics_drawable_VectorDrawable$getConstantState(), 0, this);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_VectorDrawable$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_drawable_VectorDrawable$getAlpha(), 0, this);
    }

    @Override
    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_drawable_VectorDrawable$setAlpha(int ), 0, this, n);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_graphics_drawable_VectorDrawable$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setTintList", $$robo$$android_graphics_drawable_VectorDrawable$setTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setTintMode", $$robo$$android_graphics_drawable_VectorDrawable$setTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_VectorDrawable$isStateful(), 0, this);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_VectorDrawable$onStateChange(int[] ), 0, this, nArray);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_VectorDrawable$getOpacity(), 0, this);
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicWidth", $$robo$$android_graphics_drawable_VectorDrawable$getIntrinsicWidth(), 0, this);
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicHeight", $$robo$$android_graphics_drawable_VectorDrawable$getIntrinsicHeight(), 0, this);
    }

    @Override
    public boolean canApplyTheme() {
        return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_VectorDrawable$canApplyTheme(), 0, this);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_VectorDrawable$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
    }

    public float getPixelSize() {
        return (float)InvokeDynamicSupport.bootstrap("getPixelSize", $$robo$$android_graphics_drawable_VectorDrawable$getPixelSize(), 0, this);
    }

    public static VectorDrawable create(Resources resources, int n) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_graphics_drawable_VectorDrawable$create(android.content.res.Resources int ), 0, (Resources)resources, (int)n);
    }

    private static int applyAlpha(int n, float f) {
        return (int)InvokeDynamicSupport.bootstrapStatic("applyAlpha", $$robo$$android_graphics_drawable_VectorDrawable$applyAlpha(int float ), 0, (int)n, (float)f);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_VectorDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    private void updateStateFromTypedArray(TypedArray typedArray) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_VectorDrawable$updateStateFromTypedArray(android.content.res.TypedArray ), 0, this, typedArray);
    }

    private void inflateInternal(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflateInternal", $$robo$$android_graphics_drawable_VectorDrawable$inflateInternal(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    private void printGroupTree(VGroup vGroup, int n) {
        InvokeDynamicSupport.bootstrap("printGroupTree", $$robo$$android_graphics_drawable_VectorDrawable$printGroupTree(android.graphics.drawable.VectorDrawable$VGroup int ), 0, this, vGroup, n);
    }

    @Override
    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_VectorDrawable$getChangingConfigurations(), 0, this);
    }

    void setAllowCaching(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAllowCaching", $$robo$$android_graphics_drawable_VectorDrawable$setAllowCaching(boolean ), 0, this, bl);
    }

    private boolean needMirroring() {
        return (boolean)InvokeDynamicSupport.bootstrap("needMirroring", $$robo$$android_graphics_drawable_VectorDrawable$needMirroring(), 0, this);
    }

    @Override
    public void setAutoMirrored(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAutoMirrored", $$robo$$android_graphics_drawable_VectorDrawable$setAutoMirrored(boolean ), 0, this, bl);
    }

    @Override
    public boolean isAutoMirrored() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAutoMirrored", $$robo$$android_graphics_drawable_VectorDrawable$isAutoMirrored(), 0, this);
    }

    private /* synthetic */ void __constructor__(VectorDrawableState vectorDrawableState, Resources resources, Resources.Theme theme, 1 var4_4) {
        this.$$robo$$android_graphics_drawable_VectorDrawable$__constructor__(vectorDrawableState, resources, theme, var4_4);
    }

    static {
        RobolectricInternals.classInitializing(VectorDrawable.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VectorDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class VFullPath
    extends VPath
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int[] mThemeAttrs;
        int mStrokeColor;
        float mStrokeWidth;
        int mFillColor;
        float mStrokeAlpha;
        int mFillRule;
        float mFillAlpha;
        float mTrimPathStart;
        float mTrimPathEnd;
        float mTrimPathOffset;
        Paint.Cap mStrokeLineCap;
        Paint.Join mStrokeLineJoin;
        float mStrokeMiterlimit;

        private void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$__constructor__() {
            this.mStrokeColor = 0;
            this.mStrokeWidth = 0.0f;
            this.mFillColor = 0;
            this.mStrokeAlpha = 1.0f;
            this.mFillAlpha = 1.0f;
            this.mTrimPathStart = 0.0f;
            this.mTrimPathEnd = 1.0f;
            this.mTrimPathOffset = 0.0f;
            this.mStrokeLineCap = Paint.Cap.BUTT;
            this.mStrokeLineJoin = Paint.Join.MITER;
            this.mStrokeMiterlimit = 4.0f;
        }

        private void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$__constructor__(VFullPath copy) {
            this.mStrokeColor = 0;
            this.mStrokeWidth = 0.0f;
            this.mFillColor = 0;
            this.mStrokeAlpha = 1.0f;
            this.mFillAlpha = 1.0f;
            this.mTrimPathStart = 0.0f;
            this.mTrimPathEnd = 1.0f;
            this.mTrimPathOffset = 0.0f;
            this.mStrokeLineCap = Paint.Cap.BUTT;
            this.mStrokeLineJoin = Paint.Join.MITER;
            this.mStrokeMiterlimit = 4.0f;
            this.mThemeAttrs = copy.mThemeAttrs;
            this.mStrokeColor = copy.mStrokeColor;
            this.mStrokeWidth = copy.mStrokeWidth;
            this.mStrokeAlpha = copy.mStrokeAlpha;
            this.mFillColor = copy.mFillColor;
            this.mFillRule = copy.mFillRule;
            this.mFillAlpha = copy.mFillAlpha;
            this.mTrimPathStart = copy.mTrimPathStart;
            this.mTrimPathEnd = copy.mTrimPathEnd;
            this.mTrimPathOffset = copy.mTrimPathOffset;
            this.mStrokeLineCap = copy.mStrokeLineCap;
            this.mStrokeLineJoin = copy.mStrokeLineJoin;
            this.mStrokeMiterlimit = copy.mStrokeMiterlimit;
        }

        private final Paint.Cap $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getStrokeLineCap(int id2, Paint.Cap defValue) {
            switch (id2) {
                case 0: {
                    return Paint.Cap.BUTT;
                }
                case 1: {
                    return Paint.Cap.ROUND;
                }
                case 2: {
                    return Paint.Cap.SQUARE;
                }
            }
            return defValue;
        }

        private final Paint.Join $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getStrokeLineJoin(int id2, Paint.Join defValue) {
            switch (id2) {
                case 0: {
                    return Paint.Join.MITER;
                }
                case 1: {
                    return Paint.Join.ROUND;
                }
                case 2: {
                    return Paint.Join.BEVEL;
                }
            }
            return defValue;
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$canApplyTheme() {
            return this.mThemeAttrs != null;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$inflate(Resources r, AttributeSet attrs, Resources.Theme theme) {
            TypedArray a = Drawable.obtainAttributes(r, theme, attrs, R.styleable.VectorDrawablePath);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$updateStateFromTypedArray(TypedArray a) {
            String pathData;
            this.mChangingConfigurations |= a.getChangingConfigurations();
            this.mThemeAttrs = a.extractThemeAttrs();
            String pathName = a.getString(0);
            if (pathName != null) {
                this.mPathName = pathName;
            }
            if ((pathData = a.getString(2)) != null) {
                this.mNodes = PathParser.createNodesFromPathData(pathData);
            }
            this.mFillColor = a.getColor(1, this.mFillColor);
            this.mFillAlpha = a.getFloat(12, this.mFillAlpha);
            this.mStrokeLineCap = this.getStrokeLineCap(a.getInt(8, -1), this.mStrokeLineCap);
            this.mStrokeLineJoin = this.getStrokeLineJoin(a.getInt(9, -1), this.mStrokeLineJoin);
            this.mStrokeMiterlimit = a.getFloat(10, this.mStrokeMiterlimit);
            this.mStrokeColor = a.getColor(3, this.mStrokeColor);
            this.mStrokeAlpha = a.getFloat(11, this.mStrokeAlpha);
            this.mStrokeWidth = a.getFloat(4, this.mStrokeWidth);
            this.mTrimPathEnd = a.getFloat(6, this.mTrimPathEnd);
            this.mTrimPathOffset = a.getFloat(7, this.mTrimPathOffset);
            this.mTrimPathStart = a.getFloat(5, this.mTrimPathStart);
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$applyTheme(Resources.Theme t) {
            if (this.mThemeAttrs == null) {
                return;
            }
            TypedArray a = t.resolveAttributes(this.mThemeAttrs, R.styleable.VectorDrawablePath);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }

        private final int $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getStrokeColor() {
            return this.mStrokeColor;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setStrokeColor(int strokeColor) {
            this.mStrokeColor = strokeColor;
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getStrokeWidth() {
            return this.mStrokeWidth;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setStrokeWidth(float strokeWidth) {
            this.mStrokeWidth = strokeWidth;
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getStrokeAlpha() {
            return this.mStrokeAlpha;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setStrokeAlpha(float strokeAlpha) {
            this.mStrokeAlpha = strokeAlpha;
        }

        private final int $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getFillColor() {
            return this.mFillColor;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setFillColor(int fillColor) {
            this.mFillColor = fillColor;
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getFillAlpha() {
            return this.mFillAlpha;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setFillAlpha(float fillAlpha) {
            this.mFillAlpha = fillAlpha;
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getTrimPathStart() {
            return this.mTrimPathStart;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setTrimPathStart(float trimPathStart) {
            this.mTrimPathStart = trimPathStart;
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getTrimPathEnd() {
            return this.mTrimPathEnd;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setTrimPathEnd(float trimPathEnd) {
            this.mTrimPathEnd = trimPathEnd;
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getTrimPathOffset() {
            return this.mTrimPathOffset;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setTrimPathOffset(float trimPathOffset) {
            this.mTrimPathOffset = trimPathOffset;
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_drawable_VectorDrawable_VFullPath$__constructor__();
        }

        public VFullPath() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$__constructor__(), 0, this);
        }

        private void __constructor__(VFullPath vFullPath) {
            this.$$robo$$android_graphics_drawable_VectorDrawable_VFullPath$__constructor__(vFullPath);
        }

        public VFullPath(VFullPath vFullPath) {
            super(vFullPath);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$__constructor__(android.graphics.drawable.VectorDrawable$VFullPath ), 0, this, vFullPath);
        }

        private Paint.Cap getStrokeLineCap(int n, Paint.Cap cap) {
            return InvokeDynamicSupport.bootstrap("getStrokeLineCap", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getStrokeLineCap(int android.graphics.Paint$Cap ), 0, this, n, cap);
        }

        private Paint.Join getStrokeLineJoin(int n, Paint.Join join) {
            return InvokeDynamicSupport.bootstrap("getStrokeLineJoin", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getStrokeLineJoin(int android.graphics.Paint$Join ), 0, this, n, join);
        }

        @Override
        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$canApplyTheme(), 0, this);
        }

        public void inflate(Resources resources, AttributeSet attributeSet, Resources.Theme theme) {
            InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$inflate(android.content.res.Resources android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, attributeSet, theme);
        }

        private void updateStateFromTypedArray(TypedArray typedArray) {
            InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$updateStateFromTypedArray(android.content.res.TypedArray ), 0, this, typedArray);
        }

        @Override
        public void applyTheme(Resources.Theme theme) {
            InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
        }

        int getStrokeColor() {
            return (int)InvokeDynamicSupport.bootstrap("getStrokeColor", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getStrokeColor(), 0, this);
        }

        void setStrokeColor(int n) {
            InvokeDynamicSupport.bootstrap("setStrokeColor", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setStrokeColor(int ), 0, this, n);
        }

        float getStrokeWidth() {
            return (float)InvokeDynamicSupport.bootstrap("getStrokeWidth", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getStrokeWidth(), 0, this);
        }

        void setStrokeWidth(float f) {
            InvokeDynamicSupport.bootstrap("setStrokeWidth", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setStrokeWidth(float ), 0, this, f);
        }

        float getStrokeAlpha() {
            return (float)InvokeDynamicSupport.bootstrap("getStrokeAlpha", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getStrokeAlpha(), 0, this);
        }

        void setStrokeAlpha(float f) {
            InvokeDynamicSupport.bootstrap("setStrokeAlpha", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setStrokeAlpha(float ), 0, this, f);
        }

        int getFillColor() {
            return (int)InvokeDynamicSupport.bootstrap("getFillColor", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getFillColor(), 0, this);
        }

        void setFillColor(int n) {
            InvokeDynamicSupport.bootstrap("setFillColor", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setFillColor(int ), 0, this, n);
        }

        float getFillAlpha() {
            return (float)InvokeDynamicSupport.bootstrap("getFillAlpha", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getFillAlpha(), 0, this);
        }

        void setFillAlpha(float f) {
            InvokeDynamicSupport.bootstrap("setFillAlpha", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setFillAlpha(float ), 0, this, f);
        }

        float getTrimPathStart() {
            return (float)InvokeDynamicSupport.bootstrap("getTrimPathStart", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getTrimPathStart(), 0, this);
        }

        void setTrimPathStart(float f) {
            InvokeDynamicSupport.bootstrap("setTrimPathStart", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setTrimPathStart(float ), 0, this, f);
        }

        float getTrimPathEnd() {
            return (float)InvokeDynamicSupport.bootstrap("getTrimPathEnd", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getTrimPathEnd(), 0, this);
        }

        void setTrimPathEnd(float f) {
            InvokeDynamicSupport.bootstrap("setTrimPathEnd", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setTrimPathEnd(float ), 0, this, f);
        }

        float getTrimPathOffset() {
            return (float)InvokeDynamicSupport.bootstrap("getTrimPathOffset", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$getTrimPathOffset(), 0, this);
        }

        void setTrimPathOffset(float f) {
            InvokeDynamicSupport.bootstrap("setTrimPathOffset", $$robo$$android_graphics_drawable_VectorDrawable_VFullPath$setTrimPathOffset(float ), 0, this, f);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VFullPath)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class VClipPath
    extends VPath
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$__constructor__() {
        }

        private void $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$__constructor__(VClipPath copy) {
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$inflate(Resources r, AttributeSet attrs, Resources.Theme theme) {
            TypedArray a = Drawable.obtainAttributes(r, theme, attrs, R.styleable.VectorDrawableClipPath);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$updateStateFromTypedArray(TypedArray a) {
            String pathData;
            this.mChangingConfigurations |= a.getChangingConfigurations();
            String pathName = a.getString(0);
            if (pathName != null) {
                this.mPathName = pathName;
            }
            if ((pathData = a.getString(1)) != null) {
                this.mNodes = PathParser.createNodesFromPathData(pathData);
            }
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$isClipPath() {
            return true;
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_drawable_VectorDrawable_VClipPath$__constructor__();
        }

        public VClipPath() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$__constructor__(), 0, this);
        }

        private void __constructor__(VClipPath vClipPath) {
            this.$$robo$$android_graphics_drawable_VectorDrawable_VClipPath$__constructor__(vClipPath);
        }

        public VClipPath(VClipPath vClipPath) {
            super(vClipPath);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$__constructor__(android.graphics.drawable.VectorDrawable$VClipPath ), 0, this, vClipPath);
        }

        public void inflate(Resources resources, AttributeSet attributeSet, Resources.Theme theme) {
            InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$inflate(android.content.res.Resources android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, attributeSet, theme);
        }

        private void updateStateFromTypedArray(TypedArray typedArray) {
            InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$updateStateFromTypedArray(android.content.res.TypedArray ), 0, this, typedArray);
        }

        @Override
        public boolean isClipPath() {
            return (boolean)InvokeDynamicSupport.bootstrap("isClipPath", $$robo$$android_graphics_drawable_VectorDrawable_VClipPath$isClipPath(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VClipPath)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class VPath
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        protected PathParser.PathDataNode[] mNodes;
        String mPathName;
        int mChangingConfigurations;

        private void $$robo$$android_graphics_drawable_VectorDrawable_VPath$__constructor__() {
            this.mNodes = null;
        }

        private void $$robo$$android_graphics_drawable_VectorDrawable_VPath$__constructor__(VPath copy) {
            this.mNodes = null;
            this.mPathName = copy.mPathName;
            this.mChangingConfigurations = copy.mChangingConfigurations;
            this.mNodes = PathParser.deepCopyNodes(copy.mNodes);
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VPath$toPath(Path path) {
            path.reset();
            if (this.mNodes != null) {
                PathParser.PathDataNode.nodesToPath(this.mNodes, path);
            }
        }

        private final String $$robo$$android_graphics_drawable_VectorDrawable_VPath$getPathName() {
            return this.mPathName;
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VPath$canApplyTheme() {
            return false;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VPath$applyTheme(Resources.Theme t) {
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VPath$isClipPath() {
            return false;
        }

        private final PathParser.PathDataNode[] $$robo$$android_graphics_drawable_VectorDrawable_VPath$getPathData() {
            return this.mNodes;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VPath$setPathData(PathParser.PathDataNode[] nodes) {
            if (!PathParser.canMorph(this.mNodes, nodes)) {
                this.mNodes = PathParser.deepCopyNodes(nodes);
            } else {
                PathParser.updateNodes(this.mNodes, nodes);
            }
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_drawable_VectorDrawable_VPath$__constructor__();
        }

        public VPath() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VPath$__constructor__(), 0, this);
        }

        private void __constructor__(VPath vPath) {
            this.$$robo$$android_graphics_drawable_VectorDrawable_VPath$__constructor__(vPath);
        }

        public VPath(VPath vPath) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VPath$__constructor__(android.graphics.drawable.VectorDrawable$VPath ), 0, this, vPath);
        }

        public void toPath(Path path) {
            InvokeDynamicSupport.bootstrap("toPath", $$robo$$android_graphics_drawable_VectorDrawable_VPath$toPath(android.graphics.Path ), 0, this, path);
        }

        public String getPathName() {
            return InvokeDynamicSupport.bootstrap("getPathName", $$robo$$android_graphics_drawable_VectorDrawable_VPath$getPathName(), 0, this);
        }

        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_VectorDrawable_VPath$canApplyTheme(), 0, this);
        }

        public void applyTheme(Resources.Theme theme) {
            InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_VectorDrawable_VPath$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
        }

        public boolean isClipPath() {
            return (boolean)InvokeDynamicSupport.bootstrap("isClipPath", $$robo$$android_graphics_drawable_VectorDrawable_VPath$isClipPath(), 0, this);
        }

        public PathParser.PathDataNode[] getPathData() {
            return InvokeDynamicSupport.bootstrap("getPathData", $$robo$$android_graphics_drawable_VectorDrawable_VPath$getPathData(), 0, this);
        }

        public void setPathData(PathParser.PathDataNode[] pathDataNodeArray) {
            InvokeDynamicSupport.bootstrap("setPathData", $$robo$$android_graphics_drawable_VectorDrawable_VPath$setPathData(android.util.PathParser$PathDataNode[] ), 0, this, pathDataNodeArray);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VPath)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class VGroup
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Matrix mStackedMatrix;
        ArrayList<Object> mChildren;
        private float mRotate;
        private float mPivotX;
        private float mPivotY;
        private float mScaleX;
        private float mScaleY;
        private float mTranslateX;
        private float mTranslateY;
        private Matrix mLocalMatrix;
        private int mChangingConfigurations;
        private int[] mThemeAttrs;
        private String mGroupName;

        private void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$__constructor__(VGroup copy, ArrayMap<String, Object> targetsMap) {
            this.mStackedMatrix = new Matrix();
            this.mChildren = new ArrayList();
            this.mRotate = 0.0f;
            this.mPivotX = 0.0f;
            this.mPivotY = 0.0f;
            this.mScaleX = 1.0f;
            this.mScaleY = 1.0f;
            this.mTranslateX = 0.0f;
            this.mTranslateY = 0.0f;
            this.mLocalMatrix = new Matrix();
            this.mGroupName = null;
            this.mRotate = copy.mRotate;
            this.mPivotX = copy.mPivotX;
            this.mPivotY = copy.mPivotY;
            this.mScaleX = copy.mScaleX;
            this.mScaleY = copy.mScaleY;
            this.mTranslateX = copy.mTranslateX;
            this.mTranslateY = copy.mTranslateY;
            this.mThemeAttrs = copy.mThemeAttrs;
            this.mGroupName = copy.mGroupName;
            this.mChangingConfigurations = copy.mChangingConfigurations;
            if (this.mGroupName != null) {
                targetsMap.put(this.mGroupName, this);
            }
            this.mLocalMatrix.set(copy.mLocalMatrix);
            ArrayList<Object> children = copy.mChildren;
            for (int i = 0; i < children.size(); ++i) {
                Object copyChild = children.get(i);
                if (copyChild instanceof VGroup) {
                    VGroup copyGroup = (VGroup)copyChild;
                    this.mChildren.add(new VGroup(copyGroup, targetsMap));
                    continue;
                }
                VPath newPath = null;
                if (copyChild instanceof VFullPath) {
                    newPath = new VFullPath((VFullPath)copyChild);
                } else if (copyChild instanceof VClipPath) {
                    newPath = new VClipPath((VClipPath)copyChild);
                } else {
                    throw new IllegalStateException("Unknown object in the tree!");
                }
                this.mChildren.add(newPath);
                if (newPath.mPathName == null) continue;
                targetsMap.put(newPath.mPathName, newPath);
            }
        }

        private void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$__constructor__() {
            this.mStackedMatrix = new Matrix();
            this.mChildren = new ArrayList();
            this.mRotate = 0.0f;
            this.mPivotX = 0.0f;
            this.mPivotY = 0.0f;
            this.mScaleX = 1.0f;
            this.mScaleY = 1.0f;
            this.mTranslateX = 0.0f;
            this.mTranslateY = 0.0f;
            this.mLocalMatrix = new Matrix();
            this.mGroupName = null;
        }

        private final String $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getGroupName() {
            return this.mGroupName;
        }

        private final Matrix $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getLocalMatrix() {
            return this.mLocalMatrix;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$inflate(Resources res, AttributeSet attrs, Resources.Theme theme) {
            TypedArray a = Drawable.obtainAttributes(res, theme, attrs, R.styleable.VectorDrawableGroup);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$updateStateFromTypedArray(TypedArray a) {
            this.mChangingConfigurations |= a.getChangingConfigurations();
            this.mThemeAttrs = a.extractThemeAttrs();
            this.mRotate = a.getFloat(5, this.mRotate);
            this.mPivotX = a.getFloat(1, this.mPivotX);
            this.mPivotY = a.getFloat(2, this.mPivotY);
            this.mScaleX = a.getFloat(3, this.mScaleX);
            this.mScaleY = a.getFloat(4, this.mScaleY);
            this.mTranslateX = a.getFloat(6, this.mTranslateX);
            this.mTranslateY = a.getFloat(7, this.mTranslateY);
            String groupName = a.getString(0);
            if (groupName != null) {
                this.mGroupName = groupName;
            }
            this.updateLocalMatrix();
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VGroup$canApplyTheme() {
            return this.mThemeAttrs != null;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$applyTheme(Resources.Theme t) {
            if (this.mThemeAttrs == null) {
                return;
            }
            TypedArray a = t.resolveAttributes(this.mThemeAttrs, R.styleable.VectorDrawableGroup);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$updateLocalMatrix() {
            this.mLocalMatrix.reset();
            this.mLocalMatrix.postTranslate(-this.mPivotX, -this.mPivotY);
            this.mLocalMatrix.postScale(this.mScaleX, this.mScaleY);
            this.mLocalMatrix.postRotate(this.mRotate, 0.0f, 0.0f);
            this.mLocalMatrix.postTranslate(this.mTranslateX + this.mPivotX, this.mTranslateY + this.mPivotY);
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getRotation() {
            return this.mRotate;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setRotation(float rotation) {
            if (rotation != this.mRotate) {
                this.mRotate = rotation;
                this.updateLocalMatrix();
            }
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getPivotX() {
            return this.mPivotX;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setPivotX(float pivotX) {
            if (pivotX != this.mPivotX) {
                this.mPivotX = pivotX;
                this.updateLocalMatrix();
            }
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getPivotY() {
            return this.mPivotY;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setPivotY(float pivotY) {
            if (pivotY != this.mPivotY) {
                this.mPivotY = pivotY;
                this.updateLocalMatrix();
            }
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getScaleX() {
            return this.mScaleX;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setScaleX(float scaleX) {
            if (scaleX != this.mScaleX) {
                this.mScaleX = scaleX;
                this.updateLocalMatrix();
            }
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getScaleY() {
            return this.mScaleY;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setScaleY(float scaleY) {
            if (scaleY != this.mScaleY) {
                this.mScaleY = scaleY;
                this.updateLocalMatrix();
            }
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getTranslateX() {
            return this.mTranslateX;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setTranslateX(float translateX) {
            if (translateX != this.mTranslateX) {
                this.mTranslateX = translateX;
                this.updateLocalMatrix();
            }
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getTranslateY() {
            return this.mTranslateY;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setTranslateY(float translateY) {
            if (translateY != this.mTranslateY) {
                this.mTranslateY = translateY;
                this.updateLocalMatrix();
            }
        }

        private void __constructor__(VGroup vGroup, ArrayMap<String, Object> arrayMap) {
            this.$$robo$$android_graphics_drawable_VectorDrawable_VGroup$__constructor__(vGroup, arrayMap);
        }

        public VGroup(VGroup vGroup, ArrayMap<String, Object> arrayMap) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$__constructor__(android.graphics.drawable.VectorDrawable$VGroup android.util.ArrayMap<java.lang.String, java.lang.Object> ), 0, this, vGroup, arrayMap);
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_drawable_VectorDrawable_VGroup$__constructor__();
        }

        public VGroup() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$__constructor__(), 0, this);
        }

        public String getGroupName() {
            return InvokeDynamicSupport.bootstrap("getGroupName", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getGroupName(), 0, this);
        }

        public Matrix getLocalMatrix() {
            return InvokeDynamicSupport.bootstrap("getLocalMatrix", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getLocalMatrix(), 0, this);
        }

        public void inflate(Resources resources, AttributeSet attributeSet, Resources.Theme theme) {
            InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$inflate(android.content.res.Resources android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, attributeSet, theme);
        }

        private void updateStateFromTypedArray(TypedArray typedArray) {
            InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$updateStateFromTypedArray(android.content.res.TypedArray ), 0, this, typedArray);
        }

        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$canApplyTheme(), 0, this);
        }

        public void applyTheme(Resources.Theme theme) {
            InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
        }

        private void updateLocalMatrix() {
            InvokeDynamicSupport.bootstrap("updateLocalMatrix", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$updateLocalMatrix(), 0, this);
        }

        public float getRotation() {
            return (float)InvokeDynamicSupport.bootstrap("getRotation", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getRotation(), 0, this);
        }

        public void setRotation(float f) {
            InvokeDynamicSupport.bootstrap("setRotation", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setRotation(float ), 0, this, f);
        }

        public float getPivotX() {
            return (float)InvokeDynamicSupport.bootstrap("getPivotX", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getPivotX(), 0, this);
        }

        public void setPivotX(float f) {
            InvokeDynamicSupport.bootstrap("setPivotX", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setPivotX(float ), 0, this, f);
        }

        public float getPivotY() {
            return (float)InvokeDynamicSupport.bootstrap("getPivotY", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getPivotY(), 0, this);
        }

        public void setPivotY(float f) {
            InvokeDynamicSupport.bootstrap("setPivotY", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setPivotY(float ), 0, this, f);
        }

        public float getScaleX() {
            return (float)InvokeDynamicSupport.bootstrap("getScaleX", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getScaleX(), 0, this);
        }

        public void setScaleX(float f) {
            InvokeDynamicSupport.bootstrap("setScaleX", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setScaleX(float ), 0, this, f);
        }

        public float getScaleY() {
            return (float)InvokeDynamicSupport.bootstrap("getScaleY", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getScaleY(), 0, this);
        }

        public void setScaleY(float f) {
            InvokeDynamicSupport.bootstrap("setScaleY", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setScaleY(float ), 0, this, f);
        }

        public float getTranslateX() {
            return (float)InvokeDynamicSupport.bootstrap("getTranslateX", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getTranslateX(), 0, this);
        }

        public void setTranslateX(float f) {
            InvokeDynamicSupport.bootstrap("setTranslateX", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setTranslateX(float ), 0, this, f);
        }

        public float getTranslateY() {
            return (float)InvokeDynamicSupport.bootstrap("getTranslateY", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$getTranslateY(), 0, this);
        }

        public void setTranslateY(float f) {
            InvokeDynamicSupport.bootstrap("setTranslateY", $$robo$$android_graphics_drawable_VectorDrawable_VGroup$setTranslateY(float ), 0, this, f);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VGroup)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class VPathRenderer
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Path mPath;
        private Path mRenderPath;
        private static Matrix IDENTITY_MATRIX;
        private Matrix mFinalPathMatrix;
        private Paint mStrokePaint;
        private Paint mFillPaint;
        private PathMeasure mPathMeasure;
        private int mChangingConfigurations;
        private VGroup mRootGroup;
        float mBaseWidth;
        float mBaseHeight;
        float mViewportWidth;
        float mViewportHeight;
        int mRootAlpha;
        String mRootName;
        ArrayMap<String, Object> mVGTargetsMap;

        private void $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$__constructor__() {
            this.mFinalPathMatrix = new Matrix();
            this.mBaseWidth = 0.0f;
            this.mBaseHeight = 0.0f;
            this.mViewportWidth = 0.0f;
            this.mViewportHeight = 0.0f;
            this.mRootAlpha = 255;
            this.mRootName = null;
            this.mVGTargetsMap = new ArrayMap();
            this.mRootGroup = new VGroup();
            this.mPath = new Path();
            this.mRenderPath = new Path();
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$setRootAlpha(int alpha) {
            this.mRootAlpha = alpha;
        }

        private final int $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$getRootAlpha() {
            return this.mRootAlpha;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$setAlpha(float alpha) {
            this.setRootAlpha((int)(alpha * 255.0f));
        }

        private final float $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$getAlpha() {
            return (float)this.getRootAlpha() / 255.0f;
        }

        private void $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$__constructor__(VPathRenderer copy) {
            this.mFinalPathMatrix = new Matrix();
            this.mBaseWidth = 0.0f;
            this.mBaseHeight = 0.0f;
            this.mViewportWidth = 0.0f;
            this.mViewportHeight = 0.0f;
            this.mRootAlpha = 255;
            this.mRootName = null;
            this.mVGTargetsMap = new ArrayMap();
            this.mRootGroup = new VGroup(copy.mRootGroup, this.mVGTargetsMap);
            this.mPath = new Path(copy.mPath);
            this.mRenderPath = new Path(copy.mRenderPath);
            this.mBaseWidth = copy.mBaseWidth;
            this.mBaseHeight = copy.mBaseHeight;
            this.mViewportWidth = copy.mViewportWidth;
            this.mViewportHeight = copy.mViewportHeight;
            this.mChangingConfigurations = copy.mChangingConfigurations;
            this.mRootAlpha = copy.mRootAlpha;
            this.mRootName = copy.mRootName;
            if (copy.mRootName != null) {
                this.mVGTargetsMap.put(copy.mRootName, this);
            }
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$canApplyTheme() {
            return this.recursiveCanApplyTheme(this.mRootGroup);
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$recursiveCanApplyTheme(VGroup currentGroup) {
            ArrayList<Object> children = currentGroup.mChildren;
            for (int i = 0; i < children.size(); ++i) {
                VPath childPath;
                VGroup childGroup;
                Object child = children.get(i);
                if (!(child instanceof VGroup ? (childGroup = (VGroup)child).canApplyTheme() || this.recursiveCanApplyTheme(childGroup) : child instanceof VPath && (childPath = (VPath)child).canApplyTheme())) continue;
                return true;
            }
            return false;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$applyTheme(Resources.Theme t) {
            this.recursiveApplyTheme(this.mRootGroup, t);
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$recursiveApplyTheme(VGroup currentGroup, Resources.Theme t) {
            ArrayList<Object> children = currentGroup.mChildren;
            for (int i = 0; i < children.size(); ++i) {
                VPath childPath;
                Object child = children.get(i);
                if (child instanceof VGroup) {
                    VGroup childGroup = (VGroup)child;
                    if (childGroup.canApplyTheme()) {
                        childGroup.applyTheme(t);
                    }
                    this.recursiveApplyTheme(childGroup, t);
                    continue;
                }
                if (!(child instanceof VPath) || !(childPath = (VPath)child).canApplyTheme()) continue;
                childPath.applyTheme(t);
            }
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$drawGroupTree(VGroup currentGroup, Matrix currentMatrix, Canvas canvas, int w, int h, ColorFilter filter) {
            currentGroup.mStackedMatrix.set(currentMatrix);
            currentGroup.mStackedMatrix.preConcat(currentGroup.mLocalMatrix);
            for (int i = 0; i < currentGroup.mChildren.size(); ++i) {
                Object child = currentGroup.mChildren.get(i);
                if (child instanceof VGroup) {
                    VGroup childGroup = (VGroup)child;
                    this.drawGroupTree(childGroup, currentGroup.mStackedMatrix, canvas, w, h, filter);
                    continue;
                }
                if (!(child instanceof VPath)) continue;
                VPath childPath = (VPath)child;
                this.drawPath(currentGroup, childPath, canvas, w, h, filter);
            }
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$draw(Canvas canvas, int w, int h, ColorFilter filter) {
            this.drawGroupTree(this.mRootGroup, IDENTITY_MATRIX, canvas, w, h, filter);
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$drawPath(VGroup vGroup, VPath vPath, Canvas canvas, int w, int h, ColorFilter filter) {
            float scaleX = (float)w / this.mViewportWidth;
            float scaleY = (float)h / this.mViewportHeight;
            float minScale = Math.min(scaleX, scaleY);
            this.mFinalPathMatrix.set(vGroup.mStackedMatrix);
            this.mFinalPathMatrix.postScale(scaleX, scaleY);
            vPath.toPath(this.mPath);
            Path path = this.mPath;
            this.mRenderPath.reset();
            if (vPath.isClipPath()) {
                this.mRenderPath.addPath(path, this.mFinalPathMatrix);
                canvas.clipPath(this.mRenderPath, Region.Op.REPLACE);
            } else {
                VFullPath fullPath = (VFullPath)vPath;
                if (fullPath.mTrimPathStart != 0.0f || fullPath.mTrimPathEnd != 1.0f) {
                    float start = (fullPath.mTrimPathStart + fullPath.mTrimPathOffset) % 1.0f;
                    float end = (fullPath.mTrimPathEnd + fullPath.mTrimPathOffset) % 1.0f;
                    if (this.mPathMeasure == null) {
                        this.mPathMeasure = new PathMeasure();
                    }
                    this.mPathMeasure.setPath(this.mPath, false);
                    float len = this.mPathMeasure.getLength();
                    start *= len;
                    end *= len;
                    path.reset();
                    if (start > end) {
                        this.mPathMeasure.getSegment(start, len, path, true);
                        this.mPathMeasure.getSegment(0.0f, end, path, true);
                    } else {
                        this.mPathMeasure.getSegment(start, end, path, true);
                    }
                    path.rLineTo(0.0f, 0.0f);
                }
                this.mRenderPath.addPath(path, this.mFinalPathMatrix);
                if (fullPath.mFillColor != 0) {
                    if (this.mFillPaint == null) {
                        this.mFillPaint = new Paint();
                        this.mFillPaint.setStyle(Paint.Style.FILL);
                        this.mFillPaint.setAntiAlias(true);
                    }
                    Paint fillPaint = this.mFillPaint;
                    fillPaint.setColor(VectorDrawable.applyAlpha(fullPath.mFillColor, fullPath.mFillAlpha));
                    fillPaint.setColorFilter(filter);
                    canvas.drawPath(this.mRenderPath, fillPaint);
                }
                if (fullPath.mStrokeColor != 0) {
                    if (this.mStrokePaint == null) {
                        this.mStrokePaint = new Paint();
                        this.mStrokePaint.setStyle(Paint.Style.STROKE);
                        this.mStrokePaint.setAntiAlias(true);
                    }
                    Paint strokePaint = this.mStrokePaint;
                    if (fullPath.mStrokeLineJoin != null) {
                        strokePaint.setStrokeJoin(fullPath.mStrokeLineJoin);
                    }
                    if (fullPath.mStrokeLineCap != null) {
                        strokePaint.setStrokeCap(fullPath.mStrokeLineCap);
                    }
                    strokePaint.setStrokeMiter(fullPath.mStrokeMiterlimit);
                    strokePaint.setColor(VectorDrawable.applyAlpha(fullPath.mStrokeColor, fullPath.mStrokeAlpha));
                    strokePaint.setColorFilter(filter);
                    strokePaint.setStrokeWidth(fullPath.mStrokeWidth * minScale);
                    canvas.drawPath(this.mRenderPath, strokePaint);
                }
            }
        }

        static void __staticInitializer__() {
            IDENTITY_MATRIX = new Matrix();
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$__constructor__();
        }

        public VPathRenderer() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$__constructor__(), 0, this);
        }

        public void setRootAlpha(int n) {
            InvokeDynamicSupport.bootstrap("setRootAlpha", $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$setRootAlpha(int ), 0, this, n);
        }

        public int getRootAlpha() {
            return (int)InvokeDynamicSupport.bootstrap("getRootAlpha", $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$getRootAlpha(), 0, this);
        }

        public void setAlpha(float f) {
            InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$setAlpha(float ), 0, this, f);
        }

        public float getAlpha() {
            return (float)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$getAlpha(), 0, this);
        }

        private void __constructor__(VPathRenderer vPathRenderer) {
            this.$$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$__constructor__(vPathRenderer);
        }

        public VPathRenderer(VPathRenderer vPathRenderer) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$__constructor__(android.graphics.drawable.VectorDrawable$VPathRenderer ), 0, this, vPathRenderer);
        }

        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$canApplyTheme(), 0, this);
        }

        private boolean recursiveCanApplyTheme(VGroup vGroup) {
            return (boolean)InvokeDynamicSupport.bootstrap("recursiveCanApplyTheme", $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$recursiveCanApplyTheme(android.graphics.drawable.VectorDrawable$VGroup ), 0, this, vGroup);
        }

        public void applyTheme(Resources.Theme theme) {
            InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
        }

        private void recursiveApplyTheme(VGroup vGroup, Resources.Theme theme) {
            InvokeDynamicSupport.bootstrap("recursiveApplyTheme", $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$recursiveApplyTheme(android.graphics.drawable.VectorDrawable$VGroup android.content.res.Resources$Theme ), 0, this, vGroup, theme);
        }

        private void drawGroupTree(VGroup vGroup, Matrix matrix, Canvas canvas, int n, int n2, ColorFilter colorFilter) {
            InvokeDynamicSupport.bootstrap("drawGroupTree", $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$drawGroupTree(android.graphics.drawable.VectorDrawable$VGroup android.graphics.Matrix android.graphics.Canvas int int android.graphics.ColorFilter ), 0, this, vGroup, matrix, canvas, n, n2, colorFilter);
        }

        public void draw(Canvas canvas, int n, int n2, ColorFilter colorFilter) {
            InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$draw(android.graphics.Canvas int int android.graphics.ColorFilter ), 0, this, canvas, n, n2, colorFilter);
        }

        private void drawPath(VGroup vGroup, VPath vPath, Canvas canvas, int n, int n2, ColorFilter colorFilter) {
            InvokeDynamicSupport.bootstrap("drawPath", $$robo$$android_graphics_drawable_VectorDrawable_VPathRenderer$drawPath(android.graphics.drawable.VectorDrawable$VGroup android.graphics.drawable.VectorDrawable$VPath android.graphics.Canvas int int android.graphics.ColorFilter ), 0, this, vGroup, vPath, canvas, n, n2, colorFilter);
        }

        static {
            RobolectricInternals.classInitializing(VPathRenderer.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VPathRenderer)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class VectorDrawableState
    extends Drawable.ConstantState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int[] mThemeAttrs;
        int mChangingConfigurations;
        VPathRenderer mVPathRenderer;
        ColorStateList mTint;
        PorterDuff.Mode mTintMode;
        boolean mAutoMirrored;
        Bitmap mCachedBitmap;
        int[] mCachedThemeAttrs;
        ColorStateList mCachedTint;
        PorterDuff.Mode mCachedTintMode;
        int mCachedRootAlpha;
        boolean mCachedAutoMirrored;
        boolean mCacheDirty;
        Paint mTempPaint;

        private void $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$__constructor__(VectorDrawableState copy) {
            this.mTint = null;
            this.mTintMode = Drawable.DEFAULT_TINT_MODE;
            if (copy != null) {
                this.mThemeAttrs = copy.mThemeAttrs;
                this.mChangingConfigurations = copy.mChangingConfigurations;
                this.mVPathRenderer = new VPathRenderer(copy.mVPathRenderer);
                if (copy.mVPathRenderer.mFillPaint != null) {
                    this.mVPathRenderer.mFillPaint = new Paint(copy.mVPathRenderer.mFillPaint);
                }
                if (copy.mVPathRenderer.mStrokePaint != null) {
                    this.mVPathRenderer.mStrokePaint = new Paint(copy.mVPathRenderer.mStrokePaint);
                }
                this.mTint = copy.mTint;
                this.mTintMode = copy.mTintMode;
                this.mAutoMirrored = copy.mAutoMirrored;
            }
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$drawCachedBitmapWithRootAlpha(Canvas canvas, ColorFilter filter) {
            Paint p = this.getPaint(filter);
            canvas.drawBitmap(this.mCachedBitmap, 0.0f, 0.0f, p);
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$hasTranslucentRoot() {
            return this.mVPathRenderer.getRootAlpha() < 255;
        }

        private final Paint $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$getPaint(ColorFilter filter) {
            if (!this.hasTranslucentRoot() && filter == null) {
                return null;
            }
            if (this.mTempPaint == null) {
                this.mTempPaint = new Paint();
                this.mTempPaint.setFilterBitmap(true);
            }
            this.mTempPaint.setAlpha(this.mVPathRenderer.getRootAlpha());
            this.mTempPaint.setColorFilter(filter);
            return this.mTempPaint;
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$updateCachedBitmap(Rect bounds) {
            this.mCachedBitmap.eraseColor(0);
            Canvas tmpCanvas = new Canvas(this.mCachedBitmap);
            this.mVPathRenderer.draw(tmpCanvas, bounds.width(), bounds.height(), null);
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$createCachedBitmapIfNeeded(Rect bounds) {
            if (this.mCachedBitmap == null || !this.canReuseBitmap(bounds.width(), bounds.height())) {
                this.mCachedBitmap = Bitmap.createBitmap(bounds.width(), bounds.height(), Bitmap.Config.ARGB_8888);
                this.mCacheDirty = true;
            }
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$canReuseBitmap(int width, int height) {
            return width == this.mCachedBitmap.getWidth() && height == this.mCachedBitmap.getHeight();
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$canReuseCache() {
            return !this.mCacheDirty && this.mCachedThemeAttrs == this.mThemeAttrs && this.mCachedTint == this.mTint && this.mCachedTintMode == this.mTintMode && this.mCachedAutoMirrored == this.mAutoMirrored && this.mCachedRootAlpha == this.mVPathRenderer.getRootAlpha();
        }

        private final void $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$updateCacheStates() {
            this.mCachedThemeAttrs = this.mThemeAttrs;
            this.mCachedTint = this.mTint;
            this.mCachedTintMode = this.mTintMode;
            this.mCachedRootAlpha = this.mVPathRenderer.getRootAlpha();
            this.mCachedAutoMirrored = this.mAutoMirrored;
            this.mCacheDirty = false;
        }

        private final boolean $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$canApplyTheme() {
            return super.canApplyTheme() || this.mThemeAttrs != null || this.mVPathRenderer != null && this.mVPathRenderer.canApplyTheme();
        }

        private void $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$__constructor__() {
            this.mTint = null;
            this.mTintMode = Drawable.DEFAULT_TINT_MODE;
            this.mVPathRenderer = new VPathRenderer();
        }

        private final Drawable $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$newDrawable() {
            return new VectorDrawable(this, null, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$newDrawable(Resources res) {
            return new VectorDrawable(this, res, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$newDrawable(Resources res, Resources.Theme theme) {
            return new VectorDrawable(this, res, theme);
        }

        private final int $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        private void __constructor__(VectorDrawableState vectorDrawableState) {
            this.$$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$__constructor__(vectorDrawableState);
        }

        public VectorDrawableState(VectorDrawableState vectorDrawableState) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$__constructor__(android.graphics.drawable.VectorDrawable$VectorDrawableState ), 0, this, vectorDrawableState);
        }

        public void drawCachedBitmapWithRootAlpha(Canvas canvas, ColorFilter colorFilter) {
            InvokeDynamicSupport.bootstrap("drawCachedBitmapWithRootAlpha", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$drawCachedBitmapWithRootAlpha(android.graphics.Canvas android.graphics.ColorFilter ), 0, this, canvas, colorFilter);
        }

        public boolean hasTranslucentRoot() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasTranslucentRoot", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$hasTranslucentRoot(), 0, this);
        }

        public Paint getPaint(ColorFilter colorFilter) {
            return InvokeDynamicSupport.bootstrap("getPaint", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$getPaint(android.graphics.ColorFilter ), 0, this, colorFilter);
        }

        public void updateCachedBitmap(Rect rect) {
            InvokeDynamicSupport.bootstrap("updateCachedBitmap", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$updateCachedBitmap(android.graphics.Rect ), 0, this, rect);
        }

        public void createCachedBitmapIfNeeded(Rect rect) {
            InvokeDynamicSupport.bootstrap("createCachedBitmapIfNeeded", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$createCachedBitmapIfNeeded(android.graphics.Rect ), 0, this, rect);
        }

        public boolean canReuseBitmap(int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("canReuseBitmap", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$canReuseBitmap(int int ), 0, this, n, n2);
        }

        public boolean canReuseCache() {
            return (boolean)InvokeDynamicSupport.bootstrap("canReuseCache", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$canReuseCache(), 0, this);
        }

        public void updateCacheStates() {
            InvokeDynamicSupport.bootstrap("updateCacheStates", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$updateCacheStates(), 0, this);
        }

        @Override
        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$canApplyTheme(), 0, this);
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$__constructor__();
        }

        public VectorDrawableState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$__constructor__(), 0, this);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$newDrawable(), 0, this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        @Override
        public Drawable newDrawable(Resources resources, Resources.Theme theme) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$newDrawable(android.content.res.Resources android.content.res.Resources$Theme ), 0, this, resources, theme);
        }

        @Override
        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_VectorDrawable_VectorDrawableState$getChangingConfigurations(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VectorDrawableState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

