/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable.shapes;

import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.shapes.RectShape;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RoundRectShape
extends RectShape
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private float[] mOuterRadii;
    private RectF mInset;
    private float[] mInnerRadii;
    private RectF mInnerRect;
    private Path mPath;

    private void $$robo$$android_graphics_drawable_shapes_RoundRectShape$__constructor__(float[] outerRadii, RectF inset, float[] innerRadii) {
        if (outerRadii != null && outerRadii.length < 8) {
            throw new ArrayIndexOutOfBoundsException("outer radii must have >= 8 values");
        }
        if (innerRadii != null && innerRadii.length < 8) {
            throw new ArrayIndexOutOfBoundsException("inner radii must have >= 8 values");
        }
        this.mOuterRadii = outerRadii;
        this.mInset = inset;
        this.mInnerRadii = innerRadii;
        if (inset != null) {
            this.mInnerRect = new RectF();
        }
        this.mPath = new Path();
    }

    private final void $$robo$$android_graphics_drawable_shapes_RoundRectShape$draw(Canvas canvas, Paint paint) {
        canvas.drawPath(this.mPath, paint);
    }

    private final void $$robo$$android_graphics_drawable_shapes_RoundRectShape$getOutline(Outline outline) {
        if (this.mInnerRect != null) {
            return;
        }
        float radius = 0.0f;
        if (this.mOuterRadii != null) {
            radius = this.mOuterRadii[0];
            for (int i = 1; i < 8; ++i) {
                if (this.mOuterRadii[i] == radius) continue;
                outline.setConvexPath(this.mPath);
                return;
            }
        }
        RectF rect = this.rect();
        outline.setRoundRect((int)Math.ceil(rect.left), (int)Math.ceil(rect.top), (int)Math.floor(rect.right), (int)Math.floor(rect.bottom), radius);
    }

    private final void $$robo$$android_graphics_drawable_shapes_RoundRectShape$onResize(float w, float h) {
        super.onResize(w, h);
        RectF r = this.rect();
        this.mPath.reset();
        if (this.mOuterRadii != null) {
            this.mPath.addRoundRect(r, this.mOuterRadii, Path.Direction.CW);
        } else {
            this.mPath.addRect(r, Path.Direction.CW);
        }
        if (this.mInnerRect != null) {
            this.mInnerRect.set(r.left + this.mInset.left, r.top + this.mInset.top, r.right - this.mInset.right, r.bottom - this.mInset.bottom);
            if (this.mInnerRect.width() < w && this.mInnerRect.height() < h) {
                if (this.mInnerRadii != null) {
                    this.mPath.addRoundRect(this.mInnerRect, this.mInnerRadii, Path.Direction.CCW);
                } else {
                    this.mPath.addRect(this.mInnerRect, Path.Direction.CCW);
                }
            }
        }
    }

    private final RoundRectShape $$robo$$android_graphics_drawable_shapes_RoundRectShape$clone() throws CloneNotSupportedException {
        RoundRectShape shape = (RoundRectShape)super.clone();
        shape.mOuterRadii = this.mOuterRadii != null ? (float[])this.mOuterRadii.clone() : null;
        shape.mInnerRadii = this.mInnerRadii != null ? (float[])this.mInnerRadii.clone() : null;
        shape.mInset = new RectF(this.mInset);
        shape.mInnerRect = new RectF(this.mInnerRect);
        shape.mPath = new Path(this.mPath);
        return shape;
    }

    private void __constructor__(float[] fArray, RectF rectF, float[] fArray2) {
        this.$$robo$$android_graphics_drawable_shapes_RoundRectShape$__constructor__(fArray, rectF, fArray2);
    }

    public RoundRectShape(float[] fArray, RectF rectF, float[] fArray2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_shapes_RoundRectShape$__constructor__(float[] android.graphics.RectF float[] ), 0, this, fArray, rectF, fArray2);
    }

    @Override
    public void draw(Canvas canvas, Paint paint) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_shapes_RoundRectShape$draw(android.graphics.Canvas android.graphics.Paint ), 0, this, canvas, paint);
    }

    @Override
    public void getOutline(Outline outline) {
        InvokeDynamicSupport.bootstrap("getOutline", $$robo$$android_graphics_drawable_shapes_RoundRectShape$getOutline(android.graphics.Outline ), 0, this, outline);
    }

    @Override
    protected void onResize(float f, float f2) {
        InvokeDynamicSupport.bootstrap("onResize", $$robo$$android_graphics_drawable_shapes_RoundRectShape$onResize(float float ), 0, this, f, f2);
    }

    @Override
    public RoundRectShape clone() throws CloneNotSupportedException {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_graphics_drawable_shapes_RoundRectShape$clone(), 0, this);
    }

    public /* synthetic */ RoundRectShape() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RoundRectShape)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

