/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.pdf;

import android.os.ParcelFileDescriptor;
import android.system.ErrnoException;
import android.system.OsConstants;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import libcore.io.IoUtils;
import libcore.io.Libcore;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class PdfEditor
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private CloseGuard mCloseGuard;
    private long mNativeDocument;
    private int mPageCount;
    private ParcelFileDescriptor mInput;

    private void $$robo$$android_graphics_pdf_PdfEditor$__constructor__(ParcelFileDescriptor input) throws IOException {
        long size;
        this.mCloseGuard = CloseGuard.get();
        if (input == null) {
            throw new NullPointerException("input cannot be null");
        }
        try {
            Libcore.os.lseek(input.getFileDescriptor(), 0L, OsConstants.SEEK_SET);
            size = Libcore.os.fstat((FileDescriptor)input.getFileDescriptor()).st_size;
        }
        catch (ErrnoException ee) {
            throw new IllegalArgumentException("file descriptor not seekable");
        }
        this.mInput = input;
        this.mNativeDocument = PdfEditor.nativeOpen(this.mInput.getFd(), size);
        this.mPageCount = PdfEditor.nativeGetPageCount(this.mNativeDocument);
        this.mCloseGuard.open("close");
    }

    private final int $$robo$$android_graphics_pdf_PdfEditor$getPageCount() {
        this.throwIfClosed();
        return this.mPageCount;
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$removePage(int pageIndex) {
        this.throwIfClosed();
        this.throwIfPageNotInDocument(pageIndex);
        this.mPageCount = PdfEditor.nativeRemovePage(this.mNativeDocument, pageIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_graphics_pdf_PdfEditor$write(ParcelFileDescriptor output) throws IOException {
        try {
            this.throwIfClosed();
            PdfEditor.nativeWrite(this.mNativeDocument, output.getFd());
        }
        finally {
            IoUtils.closeQuietly(output);
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$close() {
        this.throwIfClosed();
        this.doClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_graphics_pdf_PdfEditor$finalize() throws Throwable {
        try {
            this.mCloseGuard.warnIfOpen();
            if (this.mInput != null) {
                this.doClose();
            }
        }
        finally {
            super.finalize();
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$doClose() {
        PdfEditor.nativeClose(this.mNativeDocument);
        IoUtils.closeQuietly(this.mInput);
        this.mInput = null;
        this.mCloseGuard.close();
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$throwIfClosed() {
        if (this.mInput == null) {
            throw new IllegalStateException("Already closed");
        }
    }

    private final void $$robo$$android_graphics_pdf_PdfEditor$throwIfPageNotInDocument(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.mPageCount) {
            throw new IllegalArgumentException("Invalid page index");
        }
    }

    private static final long $$robo$$android_graphics_pdf_PdfEditor$nativeOpen(int n, long l) {
        return 0L;
    }

    private static final void $$robo$$android_graphics_pdf_PdfEditor$nativeClose(long l) {
    }

    private static final int $$robo$$android_graphics_pdf_PdfEditor$nativeGetPageCount(long l) {
        return 0;
    }

    private static final int $$robo$$android_graphics_pdf_PdfEditor$nativeRemovePage(long l, int n) {
        return 0;
    }

    private static final void $$robo$$android_graphics_pdf_PdfEditor$nativeWrite(long l, int n) {
    }

    private void __constructor__(ParcelFileDescriptor parcelFileDescriptor) throws IOException {
        this.$$robo$$android_graphics_pdf_PdfEditor$__constructor__(parcelFileDescriptor);
    }

    public PdfEditor(ParcelFileDescriptor parcelFileDescriptor) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_pdf_PdfEditor$__constructor__(android.os.ParcelFileDescriptor ), 0, this, parcelFileDescriptor);
    }

    public int getPageCount() {
        return (int)InvokeDynamicSupport.bootstrap("getPageCount", $$robo$$android_graphics_pdf_PdfEditor$getPageCount(), 0, this);
    }

    public void removePage(int n) {
        InvokeDynamicSupport.bootstrap("removePage", $$robo$$android_graphics_pdf_PdfEditor$removePage(int ), 0, this, n);
    }

    public void write(ParcelFileDescriptor parcelFileDescriptor) throws IOException {
        InvokeDynamicSupport.bootstrap("write", $$robo$$android_graphics_pdf_PdfEditor$write(android.os.ParcelFileDescriptor ), 0, this, parcelFileDescriptor);
    }

    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_graphics_pdf_PdfEditor$close(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_graphics_pdf_PdfEditor$finalize(), 0, this);
    }

    private void doClose() {
        InvokeDynamicSupport.bootstrap("doClose", $$robo$$android_graphics_pdf_PdfEditor$doClose(), 0, this);
    }

    private void throwIfClosed() {
        InvokeDynamicSupport.bootstrap("throwIfClosed", $$robo$$android_graphics_pdf_PdfEditor$throwIfClosed(), 0, this);
    }

    private void throwIfPageNotInDocument(int n) {
        InvokeDynamicSupport.bootstrap("throwIfPageNotInDocument", $$robo$$android_graphics_pdf_PdfEditor$throwIfPageNotInDocument(int ), 0, this, n);
    }

    private static final native /* synthetic */ long $$robo$$nativeOpen$nativeBinding(int var0, long var1);

    private static long nativeOpen(int n, long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeOpen", $$robo$$android_graphics_pdf_PdfEditor$nativeOpen(int long ), 1, (int)n, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nativeClose$nativeBinding(long var0);

    private static void nativeClose(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeClose", $$robo$$android_graphics_pdf_PdfEditor$nativeClose(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetPageCount$nativeBinding(long var0);

    private static int nativeGetPageCount(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetPageCount", $$robo$$android_graphics_pdf_PdfEditor$nativeGetPageCount(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nativeRemovePage$nativeBinding(long var0, int var2);

    private static int nativeRemovePage(long l, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeRemovePage", $$robo$$android_graphics_pdf_PdfEditor$nativeRemovePage(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nativeWrite$nativeBinding(long var0, int var2);

    private static void nativeWrite(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nativeWrite", $$robo$$android_graphics_pdf_PdfEditor$nativeWrite(long int ), 1, (long)l, (int)n);
    }

    public /* synthetic */ PdfEditor() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PdfEditor)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

