/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorEventListener2;
import android.hardware.SensorManager;
import android.hardware.TriggerEvent;
import android.hardware.TriggerEventListener;
import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SystemSensorManager
extends SensorManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean sSensorModuleInitialized;
    private static Object sSensorModuleLock;
    private static ArrayList<Sensor> sFullSensorsList;
    private static SparseArray<Sensor> sHandleToSensor;
    private HashMap<SensorEventListener, SensorEventQueue> mSensorListeners;
    private HashMap<TriggerEventListener, TriggerEventQueue> mTriggerListeners;
    private Looper mMainLooper;
    private int mTargetSdkLevel;

    private static final void $$robo$$android_hardware_SystemSensorManager$nativeClassInit() {
    }

    private static final int $$robo$$android_hardware_SystemSensorManager$nativeGetNextSensor(Sensor sensor, int n) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_hardware_SystemSensorManager$__constructor__(Context context, Looper mainLooper) {
        this.mSensorListeners = new HashMap();
        this.mTriggerListeners = new HashMap();
        this.mMainLooper = mainLooper;
        this.mTargetSdkLevel = context.getApplicationInfo().targetSdkVersion;
        Object object = sSensorModuleLock;
        synchronized (object) {
            if (!sSensorModuleInitialized) {
                sSensorModuleInitialized = true;
                SystemSensorManager.nativeClassInit();
                ArrayList<Sensor> fullList = sFullSensorsList;
                int i = 0;
                do {
                    Sensor sensor;
                    if ((i = SystemSensorManager.nativeGetNextSensor(sensor = new Sensor(), i)) < 0) continue;
                    fullList.add(sensor);
                    sHandleToSensor.append(sensor.getHandle(), sensor);
                } while (i > 0);
            }
        }
    }

    private final List<Sensor> $$robo$$android_hardware_SystemSensorManager$getFullSensorList() {
        return sFullSensorsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_hardware_SystemSensorManager$registerListenerImpl(SensorEventListener listener, Sensor sensor, int delayUs, Handler handler, int maxBatchReportLatencyUs, int reservedFlags) {
        if (listener == null || sensor == null) {
            Log.e("SensorManager", "sensor or listener is null");
            return false;
        }
        if (sensor.getReportingMode() == 2) {
            Log.e("SensorManager", "Trigger Sensors should use the requestTriggerSensor.");
            return false;
        }
        if (maxBatchReportLatencyUs < 0 || delayUs < 0) {
            Log.e("SensorManager", "maxBatchReportLatencyUs and delayUs should be non-negative");
            return false;
        }
        HashMap<SensorEventListener, SensorEventQueue> hashMap = this.mSensorListeners;
        synchronized (hashMap) {
            SensorEventQueue queue = this.mSensorListeners.get(listener);
            if (queue == null) {
                Looper looper = handler != null ? handler.getLooper() : this.mMainLooper;
                queue = new SensorEventQueue(listener, looper, this);
                if (!queue.addSensor(sensor, delayUs, maxBatchReportLatencyUs, reservedFlags)) {
                    queue.dispose();
                    return false;
                }
                this.mSensorListeners.put(listener, queue);
                return true;
            }
            return queue.addSensor(sensor, delayUs, maxBatchReportLatencyUs, reservedFlags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_SystemSensorManager$unregisterListenerImpl(SensorEventListener listener, Sensor sensor) {
        if (sensor != null && sensor.getReportingMode() == 2) {
            return;
        }
        HashMap<SensorEventListener, SensorEventQueue> hashMap = this.mSensorListeners;
        synchronized (hashMap) {
            boolean result;
            SensorEventQueue queue = this.mSensorListeners.get(listener);
            if (queue != null && (result = sensor == null ? queue.removeAllSensors() : queue.removeSensor(sensor, true)) && !queue.hasSensors()) {
                this.mSensorListeners.remove(listener);
                queue.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_hardware_SystemSensorManager$requestTriggerSensorImpl(TriggerEventListener listener, Sensor sensor) {
        if (sensor == null) {
            throw new IllegalArgumentException("sensor cannot be null");
        }
        if (sensor.getReportingMode() != 2) {
            return false;
        }
        HashMap<TriggerEventListener, TriggerEventQueue> hashMap = this.mTriggerListeners;
        synchronized (hashMap) {
            TriggerEventQueue queue = this.mTriggerListeners.get(listener);
            if (queue == null) {
                queue = new TriggerEventQueue(listener, this.mMainLooper, this);
                if (!queue.addSensor(sensor, 0, 0, 0)) {
                    queue.dispose();
                    return false;
                }
                this.mTriggerListeners.put(listener, queue);
                return true;
            }
            return queue.addSensor(sensor, 0, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_hardware_SystemSensorManager$cancelTriggerSensorImpl(TriggerEventListener listener, Sensor sensor, boolean disable) {
        if (sensor != null && sensor.getReportingMode() != 2) {
            return false;
        }
        HashMap<TriggerEventListener, TriggerEventQueue> hashMap = this.mTriggerListeners;
        synchronized (hashMap) {
            TriggerEventQueue queue = this.mTriggerListeners.get(listener);
            if (queue != null) {
                boolean result = sensor == null ? queue.removeAllSensors() : queue.removeSensor(sensor, disable);
                if (result && !queue.hasSensors()) {
                    this.mTriggerListeners.remove(listener);
                    queue.dispose();
                }
                return result;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_hardware_SystemSensorManager$flushImpl(SensorEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        HashMap<SensorEventListener, SensorEventQueue> hashMap = this.mSensorListeners;
        synchronized (hashMap) {
            SensorEventQueue queue = this.mSensorListeners.get(listener);
            if (queue == null) {
                return false;
            }
            return queue.flush() == 0;
        }
    }

    static void __staticInitializer__() {
        sSensorModuleInitialized = false;
        sSensorModuleLock = new Object();
        sFullSensorsList = new ArrayList();
        sHandleToSensor = new SparseArray();
    }

    private static final native /* synthetic */ void $$robo$$nativeClassInit$nativeBinding();

    private static void nativeClassInit() {
        InvokeDynamicSupport.bootstrapStatic("nativeClassInit", $$robo$$android_hardware_SystemSensorManager$nativeClassInit(), 1);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetNextSensor$nativeBinding(Sensor var0, int var1);

    private static int nativeGetNextSensor(Sensor sensor, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetNextSensor", $$robo$$android_hardware_SystemSensorManager$nativeGetNextSensor(android.hardware.Sensor int ), 1, (Sensor)sensor, (int)n);
    }

    private void __constructor__(Context context, Looper looper) {
        this.$$robo$$android_hardware_SystemSensorManager$__constructor__(context, looper);
    }

    public SystemSensorManager(Context context, Looper looper) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_SystemSensorManager$__constructor__(android.content.Context android.os.Looper ), 0, this, context, looper);
    }

    @Override
    protected List<Sensor> getFullSensorList() {
        return InvokeDynamicSupport.bootstrap("getFullSensorList", $$robo$$android_hardware_SystemSensorManager$getFullSensorList(), 0, this);
    }

    @Override
    protected boolean registerListenerImpl(SensorEventListener sensorEventListener, Sensor sensor, int n, Handler handler, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerListenerImpl", $$robo$$android_hardware_SystemSensorManager$registerListenerImpl(android.hardware.SensorEventListener android.hardware.Sensor int android.os.Handler int int ), 0, this, sensorEventListener, sensor, n, handler, n2, n3);
    }

    @Override
    protected void unregisterListenerImpl(SensorEventListener sensorEventListener, Sensor sensor) {
        InvokeDynamicSupport.bootstrap("unregisterListenerImpl", $$robo$$android_hardware_SystemSensorManager$unregisterListenerImpl(android.hardware.SensorEventListener android.hardware.Sensor ), 0, this, sensorEventListener, sensor);
    }

    @Override
    protected boolean requestTriggerSensorImpl(TriggerEventListener triggerEventListener, Sensor sensor) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestTriggerSensorImpl", $$robo$$android_hardware_SystemSensorManager$requestTriggerSensorImpl(android.hardware.TriggerEventListener android.hardware.Sensor ), 0, this, triggerEventListener, sensor);
    }

    @Override
    protected boolean cancelTriggerSensorImpl(TriggerEventListener triggerEventListener, Sensor sensor, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("cancelTriggerSensorImpl", $$robo$$android_hardware_SystemSensorManager$cancelTriggerSensorImpl(android.hardware.TriggerEventListener android.hardware.Sensor boolean ), 0, this, triggerEventListener, sensor, bl);
    }

    @Override
    protected boolean flushImpl(SensorEventListener sensorEventListener) {
        return (boolean)InvokeDynamicSupport.bootstrap("flushImpl", $$robo$$android_hardware_SystemSensorManager$flushImpl(android.hardware.SensorEventListener ), 0, this, sensorEventListener);
    }

    static {
        RobolectricInternals.classInitializing(SystemSensorManager.class);
    }

    public /* synthetic */ SystemSensorManager() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SystemSensorManager)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class TriggerEventQueue
    extends BaseEventQueue
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private TriggerEventListener mListener;
        private SparseArray<TriggerEvent> mTriggerEvents;

        private void $$robo$$android_hardware_SystemSensorManager_TriggerEventQueue$__constructor__(TriggerEventListener listener, Looper looper, SystemSensorManager manager) {
            this.mTriggerEvents = new SparseArray();
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_SystemSensorManager_TriggerEventQueue$addSensorEvent(Sensor sensor) {
            TriggerEvent t = new TriggerEvent(Sensor.getMaxLengthValuesArray(sensor, this.mManager.mTargetSdkLevel));
            SparseArray<TriggerEvent> sparseArray = this.mTriggerEvents;
            synchronized (sparseArray) {
                this.mTriggerEvents.put(sensor.getHandle(), t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_SystemSensorManager_TriggerEventQueue$removeSensorEvent(Sensor sensor) {
            SparseArray<TriggerEvent> sparseArray = this.mTriggerEvents;
            synchronized (sparseArray) {
                this.mTriggerEvents.delete(sensor.getHandle());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_SystemSensorManager_TriggerEventQueue$dispatchSensorEvent(int handle, float[] values, int accuracy, long timestamp) {
            Sensor sensor = (Sensor)sHandleToSensor.get(handle);
            TriggerEvent t = null;
            SparseArray<TriggerEvent> sparseArray = this.mTriggerEvents;
            synchronized (sparseArray) {
                t = this.mTriggerEvents.get(handle);
            }
            if (t == null) {
                Log.e("SensorManager", "Error: Trigger Event is null for Sensor: " + sensor);
                return;
            }
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (float[])values, (int)0, (float[])t.values, (int)0, (int)t.values.length);
            t.timestamp = timestamp;
            t.sensor = sensor;
            this.mManager.cancelTriggerSensorImpl(this.mListener, sensor, false);
            this.mListener.onTrigger(t);
        }

        private final void $$robo$$android_hardware_SystemSensorManager_TriggerEventQueue$dispatchFlushCompleteEvent(int handle) {
        }

        private void __constructor__(TriggerEventListener triggerEventListener, Looper looper, SystemSensorManager systemSensorManager) {
            this.$$robo$$android_hardware_SystemSensorManager_TriggerEventQueue$__constructor__(triggerEventListener, looper, systemSensorManager);
        }

        public TriggerEventQueue(TriggerEventListener triggerEventListener, Looper looper, SystemSensorManager systemSensorManager) {
            super(looper, systemSensorManager);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_SystemSensorManager_TriggerEventQueue$__constructor__(android.hardware.TriggerEventListener android.os.Looper android.hardware.SystemSensorManager ), 0, this, triggerEventListener, looper, systemSensorManager);
        }

        @Override
        public void addSensorEvent(Sensor sensor) {
            InvokeDynamicSupport.bootstrap("addSensorEvent", $$robo$$android_hardware_SystemSensorManager_TriggerEventQueue$addSensorEvent(android.hardware.Sensor ), 0, this, sensor);
        }

        @Override
        public void removeSensorEvent(Sensor sensor) {
            InvokeDynamicSupport.bootstrap("removeSensorEvent", $$robo$$android_hardware_SystemSensorManager_TriggerEventQueue$removeSensorEvent(android.hardware.Sensor ), 0, this, sensor);
        }

        @Override
        protected void dispatchSensorEvent(int n, float[] fArray, int n2, long l) {
            InvokeDynamicSupport.bootstrap("dispatchSensorEvent", $$robo$$android_hardware_SystemSensorManager_TriggerEventQueue$dispatchSensorEvent(int float[] int long ), 0, this, n, fArray, n2, l);
        }

        @Override
        protected void dispatchFlushCompleteEvent(int n) {
            InvokeDynamicSupport.bootstrap("dispatchFlushCompleteEvent", $$robo$$android_hardware_SystemSensorManager_TriggerEventQueue$dispatchFlushCompleteEvent(int ), 0, this, n);
        }

        public /* synthetic */ TriggerEventQueue() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TriggerEventQueue)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class SensorEventQueue
    extends BaseEventQueue
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private SensorEventListener mListener;
        private SparseArray<SensorEvent> mSensorsEvents;

        private void $$robo$$android_hardware_SystemSensorManager_SensorEventQueue$__constructor__(SensorEventListener listener, Looper looper, SystemSensorManager manager) {
            this.mSensorsEvents = new SparseArray();
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_SystemSensorManager_SensorEventQueue$addSensorEvent(Sensor sensor) {
            SensorEvent t = new SensorEvent(Sensor.getMaxLengthValuesArray(sensor, this.mManager.mTargetSdkLevel));
            SparseArray<SensorEvent> sparseArray = this.mSensorsEvents;
            synchronized (sparseArray) {
                this.mSensorsEvents.put(sensor.getHandle(), t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_SystemSensorManager_SensorEventQueue$removeSensorEvent(Sensor sensor) {
            SparseArray<SensorEvent> sparseArray = this.mSensorsEvents;
            synchronized (sparseArray) {
                this.mSensorsEvents.delete(sensor.getHandle());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_SystemSensorManager_SensorEventQueue$dispatchSensorEvent(int handle, float[] values, int inAccuracy, long timestamp) {
            Sensor sensor = (Sensor)sHandleToSensor.get(handle);
            SensorEvent t = null;
            SparseArray<SensorEvent> sparseArray = this.mSensorsEvents;
            synchronized (sparseArray) {
                t = this.mSensorsEvents.get(handle);
            }
            if (t == null) {
                return;
            }
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (float[])values, (int)0, (float[])t.values, (int)0, (int)t.values.length);
            t.timestamp = timestamp;
            t.accuracy = inAccuracy;
            t.sensor = sensor;
            int accuracy = this.mSensorAccuracies.get(handle);
            if (t.accuracy >= 0 && accuracy != t.accuracy) {
                this.mSensorAccuracies.put(handle, t.accuracy);
                this.mListener.onAccuracyChanged(t.sensor, t.accuracy);
            }
            this.mListener.onSensorChanged(t);
        }

        private final void $$robo$$android_hardware_SystemSensorManager_SensorEventQueue$dispatchFlushCompleteEvent(int handle) {
            if (this.mListener instanceof SensorEventListener2) {
                Sensor sensor = (Sensor)sHandleToSensor.get(handle);
                ((SensorEventListener2)this.mListener).onFlushCompleted(sensor);
            }
        }

        private void __constructor__(SensorEventListener sensorEventListener, Looper looper, SystemSensorManager systemSensorManager) {
            this.$$robo$$android_hardware_SystemSensorManager_SensorEventQueue$__constructor__(sensorEventListener, looper, systemSensorManager);
        }

        public SensorEventQueue(SensorEventListener sensorEventListener, Looper looper, SystemSensorManager systemSensorManager) {
            super(looper, systemSensorManager);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_SystemSensorManager_SensorEventQueue$__constructor__(android.hardware.SensorEventListener android.os.Looper android.hardware.SystemSensorManager ), 0, this, sensorEventListener, looper, systemSensorManager);
        }

        @Override
        public void addSensorEvent(Sensor sensor) {
            InvokeDynamicSupport.bootstrap("addSensorEvent", $$robo$$android_hardware_SystemSensorManager_SensorEventQueue$addSensorEvent(android.hardware.Sensor ), 0, this, sensor);
        }

        @Override
        public void removeSensorEvent(Sensor sensor) {
            InvokeDynamicSupport.bootstrap("removeSensorEvent", $$robo$$android_hardware_SystemSensorManager_SensorEventQueue$removeSensorEvent(android.hardware.Sensor ), 0, this, sensor);
        }

        @Override
        protected void dispatchSensorEvent(int n, float[] fArray, int n2, long l) {
            InvokeDynamicSupport.bootstrap("dispatchSensorEvent", $$robo$$android_hardware_SystemSensorManager_SensorEventQueue$dispatchSensorEvent(int float[] int long ), 0, this, n, fArray, n2, l);
        }

        @Override
        protected void dispatchFlushCompleteEvent(int n) {
            InvokeDynamicSupport.bootstrap("dispatchFlushCompleteEvent", $$robo$$android_hardware_SystemSensorManager_SensorEventQueue$dispatchFlushCompleteEvent(int ), 0, this, n);
        }

        public /* synthetic */ SensorEventQueue() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SensorEventQueue)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static abstract class BaseEventQueue
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private long nSensorEventQueue;
        private SparseBooleanArray mActiveSensors;
        protected SparseIntArray mSensorAccuracies;
        protected SparseBooleanArray mFirstEvent;
        private CloseGuard mCloseGuard;
        private float[] mScratch;
        protected SystemSensorManager mManager;

        private final long $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$nativeInitBaseEventQueue(BaseEventQueue baseEventQueue, MessageQueue messageQueue, float[] fArray) {
            return 0L;
        }

        private static final int $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$nativeEnableSensor(long l, int n, int n2, int n3, int n4) {
            return 0;
        }

        private static final int $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$nativeDisableSensor(long l, int n) {
            return 0;
        }

        private static final void $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$nativeDestroySensorEventQueue(long l) {
        }

        private static final int $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$nativeFlushSensor(long l) {
            return 0;
        }

        private void $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$__constructor__(Looper looper, SystemSensorManager manager) {
            this.mActiveSensors = new SparseBooleanArray();
            this.mSensorAccuracies = new SparseIntArray();
            this.mFirstEvent = new SparseBooleanArray();
            this.mCloseGuard = CloseGuard.get();
            this.mScratch = new float[16];
            this.nSensorEventQueue = this.nativeInitBaseEventQueue(this, looper.getQueue(), this.mScratch);
            this.mCloseGuard.open("dispose");
            this.mManager = manager;
        }

        private final void $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$dispose() {
            this.dispose(false);
        }

        private final boolean $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$addSensor(Sensor sensor, int delayUs, int maxBatchReportLatencyUs, int reservedFlags) {
            int handle = sensor.getHandle();
            if (this.mActiveSensors.get(handle)) {
                return false;
            }
            this.mActiveSensors.put(handle, true);
            this.addSensorEvent(sensor);
            if (this.enableSensor(sensor, delayUs, maxBatchReportLatencyUs, reservedFlags) != 0 && (maxBatchReportLatencyUs == 0 || maxBatchReportLatencyUs > 0 && this.enableSensor(sensor, delayUs, 0, 0) != 0)) {
                this.removeSensor(sensor, false);
                return false;
            }
            return true;
        }

        private final boolean $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$removeAllSensors() {
            for (int i = 0; i < this.mActiveSensors.size(); ++i) {
                if (!this.mActiveSensors.valueAt(i)) continue;
                int handle = this.mActiveSensors.keyAt(i);
                Sensor sensor = (Sensor)sHandleToSensor.get(handle);
                if (sensor == null) continue;
                this.disableSensor(sensor);
                this.mActiveSensors.put(handle, false);
                this.removeSensorEvent(sensor);
            }
            return true;
        }

        private final boolean $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$removeSensor(Sensor sensor, boolean disable) {
            int handle = sensor.getHandle();
            if (this.mActiveSensors.get(handle)) {
                if (disable) {
                    this.disableSensor(sensor);
                }
                this.mActiveSensors.put(sensor.getHandle(), false);
                this.removeSensorEvent(sensor);
                return true;
            }
            return false;
        }

        private final int $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$flush() {
            if (this.nSensorEventQueue == 0L) {
                throw new NullPointerException();
            }
            return BaseEventQueue.nativeFlushSensor(this.nSensorEventQueue);
        }

        private final boolean $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$hasSensors() {
            return this.mActiveSensors.indexOfValue(true) >= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$finalize() throws Throwable {
            try {
                this.dispose(true);
            }
            finally {
                super.finalize();
            }
        }

        private final void $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$dispose(boolean finalized) {
            if (this.mCloseGuard != null) {
                if (finalized) {
                    this.mCloseGuard.warnIfOpen();
                }
                this.mCloseGuard.close();
            }
            if (this.nSensorEventQueue != 0L) {
                BaseEventQueue.nativeDestroySensorEventQueue(this.nSensorEventQueue);
                this.nSensorEventQueue = 0L;
            }
        }

        private final int $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$enableSensor(Sensor sensor, int rateUs, int maxBatchReportLatencyUs, int reservedFlags) {
            if (this.nSensorEventQueue == 0L) {
                throw new NullPointerException();
            }
            if (sensor == null) {
                throw new NullPointerException();
            }
            return BaseEventQueue.nativeEnableSensor(this.nSensorEventQueue, sensor.getHandle(), rateUs, maxBatchReportLatencyUs, reservedFlags);
        }

        private final int $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$disableSensor(Sensor sensor) {
            if (this.nSensorEventQueue == 0L) {
                throw new NullPointerException();
            }
            if (sensor == null) {
                throw new NullPointerException();
            }
            return BaseEventQueue.nativeDisableSensor(this.nSensorEventQueue, sensor.getHandle());
        }

        protected abstract void dispatchSensorEvent(int var1, float[] var2, int var3, long var4);

        protected abstract void dispatchFlushCompleteEvent(int var1);

        protected abstract void addSensorEvent(Sensor var1);

        protected abstract void removeSensorEvent(Sensor var1);

        private final native /* synthetic */ long $$robo$$nativeInitBaseEventQueue$nativeBinding(BaseEventQueue var1, MessageQueue var2, float[] var3);

        private long nativeInitBaseEventQueue(BaseEventQueue baseEventQueue, MessageQueue messageQueue, float[] fArray) {
            return (long)InvokeDynamicSupport.bootstrap("nativeInitBaseEventQueue", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$nativeInitBaseEventQueue(android.hardware.SystemSensorManager$BaseEventQueue android.os.MessageQueue float[] ), 1, this, baseEventQueue, messageQueue, fArray);
        }

        private static final native /* synthetic */ int $$robo$$nativeEnableSensor$nativeBinding(long var0, int var2, int var3, int var4, int var5);

        private static int nativeEnableSensor(long l, int n, int n2, int n3, int n4) {
            return (int)InvokeDynamicSupport.bootstrapStatic("nativeEnableSensor", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$nativeEnableSensor(long int int int int ), 1, (long)l, (int)n, (int)n2, (int)n3, (int)n4);
        }

        private static final native /* synthetic */ int $$robo$$nativeDisableSensor$nativeBinding(long var0, int var2);

        private static int nativeDisableSensor(long l, int n) {
            return (int)InvokeDynamicSupport.bootstrapStatic("nativeDisableSensor", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$nativeDisableSensor(long int ), 1, (long)l, (int)n);
        }

        private static final native /* synthetic */ void $$robo$$nativeDestroySensorEventQueue$nativeBinding(long var0);

        private static void nativeDestroySensorEventQueue(long l) {
            InvokeDynamicSupport.bootstrapStatic("nativeDestroySensorEventQueue", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$nativeDestroySensorEventQueue(long ), 1, (long)l);
        }

        private static final native /* synthetic */ int $$robo$$nativeFlushSensor$nativeBinding(long var0);

        private static int nativeFlushSensor(long l) {
            return (int)InvokeDynamicSupport.bootstrapStatic("nativeFlushSensor", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$nativeFlushSensor(long ), 1, (long)l);
        }

        private void __constructor__(Looper looper, SystemSensorManager systemSensorManager) {
            this.$$robo$$android_hardware_SystemSensorManager_BaseEventQueue$__constructor__(looper, systemSensorManager);
        }

        BaseEventQueue(Looper looper, SystemSensorManager systemSensorManager) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$__constructor__(android.os.Looper android.hardware.SystemSensorManager ), 0, this, looper, systemSensorManager);
        }

        public void dispose() {
            InvokeDynamicSupport.bootstrap("dispose", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$dispose(), 0, this);
        }

        public boolean addSensor(Sensor sensor, int n, int n2, int n3) {
            return (boolean)InvokeDynamicSupport.bootstrap("addSensor", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$addSensor(android.hardware.Sensor int int int ), 0, this, sensor, n, n2, n3);
        }

        public boolean removeAllSensors() {
            return (boolean)InvokeDynamicSupport.bootstrap("removeAllSensors", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$removeAllSensors(), 0, this);
        }

        public boolean removeSensor(Sensor sensor, boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("removeSensor", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$removeSensor(android.hardware.Sensor boolean ), 0, this, sensor, bl);
        }

        public int flush() {
            return (int)InvokeDynamicSupport.bootstrap("flush", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$flush(), 0, this);
        }

        public boolean hasSensors() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasSensors", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$hasSensors(), 0, this);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$finalize(), 0, this);
        }

        private void dispose(boolean bl) {
            InvokeDynamicSupport.bootstrap("dispose", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$dispose(boolean ), 0, this, bl);
        }

        private int enableSensor(Sensor sensor, int n, int n2, int n3) {
            return (int)InvokeDynamicSupport.bootstrap("enableSensor", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$enableSensor(android.hardware.Sensor int int int ), 0, this, sensor, n, n2, n3);
        }

        private int disableSensor(Sensor sensor) {
            return (int)InvokeDynamicSupport.bootstrap("disableSensor", $$robo$$android_hardware_SystemSensorManager_BaseEventQueue$disableSensor(android.hardware.Sensor ), 0, this, sensor);
        }

        public /* synthetic */ BaseEventQueue() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BaseEventQueue)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

