/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.content.Context;
import android.hardware.CameraInfo;
import android.hardware.ICameraService;
import android.hardware.ICameraServiceListener;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.ICameraDeviceUser;
import android.hardware.camera2.impl.CameraDeviceImpl;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.legacy.CameraDeviceUserShim;
import android.hardware.camera2.legacy.LegacyMetadataMapper;
import android.hardware.camera2.utils.BinderHolder;
import android.hardware.camera2.utils.CameraRuntimeException;
import android.hardware.camera2.utils.CameraServiceBinderDecorator;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class CameraManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "CameraManager";
    private boolean DEBUG;
    private static String CAMERA_SERVICE_BINDER_NAME = "media.camera";
    private static int USE_CALLING_UID = -1;
    private static int API_VERSION_1 = 1;
    private static int API_VERSION_2 = 2;
    private ICameraService mCameraService;
    private ArrayList<String> mDeviceIdList;
    private ArrayMap<AvailabilityCallback, Handler> mCallbackMap;
    private Context mContext;
    private Object mLock;
    private CameraServiceListener mServiceListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_hardware_camera2_CameraManager$__constructor__(Context context) {
        this.mCallbackMap = new ArrayMap();
        this.mLock = new Object();
        this.mServiceListener = new CameraServiceListener(this);
        this.DEBUG = Log.isLoggable("CameraManager", 3);
        Object object = this.mLock;
        synchronized (object) {
            this.mContext = context;
            this.connectCameraServiceLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String[] $$robo$$android_hardware_camera2_CameraManager$getCameraIdList() throws CameraAccessException {
        Object object = this.mLock;
        synchronized (object) {
            return this.getOrCreateDeviceIdListLocked().toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_CameraManager$registerAvailabilityCallback(AvailabilityCallback callback, Handler handler) {
        if (handler == null) {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                throw new IllegalArgumentException("No handler given, and current thread has no looper!");
            }
            handler = new Handler(looper);
        }
        Object object = this.mLock;
        synchronized (object) {
            Handler oldHandler = this.mCallbackMap.put(callback, handler);
            if (oldHandler == null) {
                this.mServiceListener.updateCallbackLocked(callback, handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_CameraManager$unregisterAvailabilityCallback(AvailabilityCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCallbackMap.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CameraCharacteristics $$robo$$android_hardware_camera2_CameraManager$getCameraCharacteristics(String cameraId) throws CameraAccessException {
        CameraCharacteristics characteristics = null;
        Object object = this.mLock;
        synchronized (object) {
            if (!this.getOrCreateDeviceIdListLocked().contains(cameraId)) {
                throw new IllegalArgumentException(String.format("Camera id %s does not match any currently connected camera device", cameraId));
            }
            int id2 = Integer.valueOf(cameraId);
            ICameraService cameraService = this.getCameraServiceLocked();
            if (cameraService == null) {
                throw new CameraAccessException(2, "Camera service is currently unavailable");
            }
            try {
                if (!this.supportsCamera2ApiLocked(cameraId)) {
                    String[] outParameters = new String[1];
                    cameraService.getLegacyParameters(id2, outParameters);
                    String parameters = outParameters[0];
                    CameraInfo info = new CameraInfo();
                    cameraService.getCameraInfo(id2, info);
                    characteristics = LegacyMetadataMapper.createCharacteristics(parameters, info);
                } else {
                    CameraMetadataNative info = new CameraMetadataNative();
                    cameraService.getCameraCharacteristics(id2, info);
                    characteristics = new CameraCharacteristics(info);
                }
            }
            catch (CameraRuntimeException e) {
                throw e.asChecked();
            }
            catch (RemoteException e) {
                throw new CameraAccessException(2, "Camera service is currently unavailable", e);
            }
        }
        return characteristics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CameraDevice $$robo$$android_hardware_camera2_CameraManager$openCameraDeviceUserAsync(String cameraId, CameraDevice.StateCallback callback, Handler handler) throws CameraAccessException {
        CameraCharacteristics characteristics = this.getCameraCharacteristics(cameraId);
        CameraDeviceImpl device = null;
        try {
            Object object = this.mLock;
            synchronized (object) {
                ICameraDeviceUser cameraUser = null;
                CameraDeviceImpl deviceImpl = new CameraDeviceImpl(cameraId, callback, handler, characteristics);
                BinderHolder holder = new BinderHolder();
                CameraDeviceImpl.CameraDeviceCallbacks callbacks = deviceImpl.getCallbacks();
                int id2 = Integer.parseInt(cameraId);
                try {
                    if (this.supportsCamera2ApiLocked(cameraId)) {
                        ICameraService cameraService = this.getCameraServiceLocked();
                        if (cameraService == null) {
                            throw new CameraRuntimeException(2, "Camera service is currently unavailable");
                        }
                        cameraService.connectDevice(callbacks, id2, this.mContext.getPackageName(), -1, holder);
                        cameraUser = ICameraDeviceUser.Stub.asInterface(holder.getBinder());
                    } else {
                        Log.i("CameraManager", "Using legacy camera HAL.");
                        cameraUser = CameraDeviceUserShim.connectBinderShim(callbacks, id2);
                    }
                }
                catch (CameraRuntimeException e) {
                    if (e.getReason() == 1000) {
                        throw new AssertionError((Object)"Should've gone down the shim path");
                    }
                    if (e.getReason() == 4 || e.getReason() == 5 || e.getReason() == 1 || e.getReason() == 2 || e.getReason() == 3) {
                        deviceImpl.setRemoteFailure(e);
                        if (e.getReason() == 1 || e.getReason() == 2) {
                            throw e.asChecked();
                        }
                    }
                    throw e;
                }
                catch (RemoteException e) {
                    CameraRuntimeException ce = new CameraRuntimeException(2, "Camera service is currently unavailable", e);
                    deviceImpl.setRemoteFailure(ce);
                    throw ce.asChecked();
                }
                deviceImpl.setRemoteDevice(cameraUser);
                device = deviceImpl;
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected cameraId to be numeric, but it was: " + cameraId);
        }
        catch (CameraRuntimeException e) {
            throw e.asChecked();
        }
        return device;
    }

    private final void $$robo$$android_hardware_camera2_CameraManager$openCamera(String cameraId, CameraDevice.StateCallback callback, Handler handler) throws CameraAccessException {
        if (cameraId == null) {
            throw new IllegalArgumentException("cameraId was null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback was null");
        }
        if (handler == null) {
            if (Looper.myLooper() != null) {
                handler = new Handler();
            } else {
                throw new IllegalArgumentException("Looper doesn't exist in the calling thread");
            }
        }
        this.openCameraDeviceUserAsync(cameraId, callback, handler);
    }

    private final ArrayList<String> $$robo$$android_hardware_camera2_CameraManager$getOrCreateDeviceIdListLocked() throws CameraAccessException {
        if (this.mDeviceIdList == null) {
            int numCameras = 0;
            ICameraService cameraService = this.getCameraServiceLocked();
            ArrayList<String> deviceIdList = new ArrayList<String>();
            if (cameraService == null) {
                return deviceIdList;
            }
            try {
                numCameras = cameraService.getNumberOfCameras();
            }
            catch (CameraRuntimeException e) {
                throw e.asChecked();
            }
            catch (RemoteException e) {
                return deviceIdList;
            }
            CameraMetadataNative info = new CameraMetadataNative();
            for (int i = 0; i < numCameras; ++i) {
                boolean isDeviceSupported = false;
                try {
                    cameraService.getCameraCharacteristics(i, info);
                    if (info.isEmpty()) {
                        throw new AssertionError((Object)"Expected to get non-empty characteristics");
                    }
                    isDeviceSupported = true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (CameraRuntimeException e) {
                    if (e.getReason() != 2) {
                        throw e.asChecked();
                    }
                }
                catch (RemoteException e) {
                    deviceIdList.clear();
                    return deviceIdList;
                }
                if (isDeviceSupported) {
                    deviceIdList.add(String.valueOf(i));
                    continue;
                }
                Log.w("CameraManager", "Error querying camera device " + i + " for listing.");
            }
            this.mDeviceIdList = deviceIdList;
        }
        return this.mDeviceIdList;
    }

    private final void $$robo$$android_hardware_camera2_CameraManager$handleRecoverableSetupErrors(CameraRuntimeException e, String msg) {
        int problem = e.getReason();
        switch (problem) {
            case 2: {
                String errorMsg = CameraAccessException.getDefaultMessage(problem);
                Log.w("CameraManager", msg + ": " + errorMsg);
                break;
            }
            default: {
                throw new IllegalStateException(msg, e.asChecked());
            }
        }
    }

    private final boolean $$robo$$android_hardware_camera2_CameraManager$supportsCamera2ApiLocked(String cameraId) {
        return this.supportsCameraApiLocked(cameraId, 2);
    }

    private final boolean $$robo$$android_hardware_camera2_CameraManager$supportsCameraApiLocked(String cameraId, int apiVersion) {
        int id2 = Integer.parseInt(cameraId);
        try {
            ICameraService cameraService = this.getCameraServiceLocked();
            if (cameraService == null) {
                return false;
            }
            int res = cameraService.supportsCameraApi(id2, apiVersion);
            if (res != 0) {
                throw new AssertionError((Object)("Unexpected value " + res));
            }
            return true;
        }
        catch (CameraRuntimeException e) {
            if (e.getReason() != 1000) {
                throw e;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    private final void $$robo$$android_hardware_camera2_CameraManager$connectCameraServiceLocked() {
        this.mCameraService = null;
        IBinder cameraServiceBinder = ServiceManager.getService("media.camera");
        if (cameraServiceBinder == null) {
            return;
        }
        try {
            cameraServiceBinder.linkToDeath(new CameraServiceDeathListener(this), 0);
        }
        catch (RemoteException e) {
            return;
        }
        ICameraService cameraServiceRaw = ICameraService.Stub.asInterface(cameraServiceBinder);
        ICameraService cameraService = CameraServiceBinderDecorator.newInstance(cameraServiceRaw);
        try {
            CameraServiceBinderDecorator.throwOnError(CameraMetadataNative.nativeSetupGlobalVendorTagDescriptor());
        }
        catch (CameraRuntimeException e) {
            this.handleRecoverableSetupErrors(e, "Failed to set up vendor tags");
        }
        try {
            cameraService.addListener(this.mServiceListener);
            this.mCameraService = cameraService;
        }
        catch (CameraRuntimeException e) {
            throw new IllegalStateException("Failed to register a camera service listener", e.asChecked());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final ICameraService $$robo$$android_hardware_camera2_CameraManager$getCameraServiceLocked() {
        if (this.mCameraService == null) {
            Log.i("CameraManager", "getCameraServiceLocked: Reconnecting to camera service");
            this.connectCameraServiceLocked();
            if (this.mCameraService == null) {
                Log.e("CameraManager", "Camera service is unavailable");
            }
        }
        return this.mCameraService;
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_hardware_camera2_CameraManager$__constructor__(context);
    }

    public CameraManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CameraManager$__constructor__(android.content.Context ), 0, this, context);
    }

    public String[] getCameraIdList() throws CameraAccessException {
        return InvokeDynamicSupport.bootstrap("getCameraIdList", $$robo$$android_hardware_camera2_CameraManager$getCameraIdList(), 0, this);
    }

    public void registerAvailabilityCallback(AvailabilityCallback availabilityCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerAvailabilityCallback", $$robo$$android_hardware_camera2_CameraManager$registerAvailabilityCallback(android.hardware.camera2.CameraManager$AvailabilityCallback android.os.Handler ), 0, this, availabilityCallback, handler);
    }

    public void unregisterAvailabilityCallback(AvailabilityCallback availabilityCallback) {
        InvokeDynamicSupport.bootstrap("unregisterAvailabilityCallback", $$robo$$android_hardware_camera2_CameraManager$unregisterAvailabilityCallback(android.hardware.camera2.CameraManager$AvailabilityCallback ), 0, this, availabilityCallback);
    }

    public CameraCharacteristics getCameraCharacteristics(String string2) throws CameraAccessException {
        return InvokeDynamicSupport.bootstrap("getCameraCharacteristics", $$robo$$android_hardware_camera2_CameraManager$getCameraCharacteristics(java.lang.String ), 0, this, string2);
    }

    private CameraDevice openCameraDeviceUserAsync(String string2, CameraDevice.StateCallback stateCallback, Handler handler) throws CameraAccessException {
        return InvokeDynamicSupport.bootstrap("openCameraDeviceUserAsync", $$robo$$android_hardware_camera2_CameraManager$openCameraDeviceUserAsync(java.lang.String android.hardware.camera2.CameraDevice$StateCallback android.os.Handler ), 0, this, string2, stateCallback, handler);
    }

    public void openCamera(String string2, CameraDevice.StateCallback stateCallback, Handler handler) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("openCamera", $$robo$$android_hardware_camera2_CameraManager$openCamera(java.lang.String android.hardware.camera2.CameraDevice$StateCallback android.os.Handler ), 0, this, string2, stateCallback, handler);
    }

    private ArrayList<String> getOrCreateDeviceIdListLocked() throws CameraAccessException {
        return InvokeDynamicSupport.bootstrap("getOrCreateDeviceIdListLocked", $$robo$$android_hardware_camera2_CameraManager$getOrCreateDeviceIdListLocked(), 0, this);
    }

    private void handleRecoverableSetupErrors(CameraRuntimeException cameraRuntimeException, String string2) {
        InvokeDynamicSupport.bootstrap("handleRecoverableSetupErrors", $$robo$$android_hardware_camera2_CameraManager$handleRecoverableSetupErrors(android.hardware.camera2.utils.CameraRuntimeException java.lang.String ), 0, this, cameraRuntimeException, string2);
    }

    private boolean supportsCamera2ApiLocked(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("supportsCamera2ApiLocked", $$robo$$android_hardware_camera2_CameraManager$supportsCamera2ApiLocked(java.lang.String ), 0, this, string2);
    }

    private boolean supportsCameraApiLocked(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("supportsCameraApiLocked", $$robo$$android_hardware_camera2_CameraManager$supportsCameraApiLocked(java.lang.String int ), 0, this, string2, n);
    }

    private void connectCameraServiceLocked() {
        InvokeDynamicSupport.bootstrap("connectCameraServiceLocked", $$robo$$android_hardware_camera2_CameraManager$connectCameraServiceLocked(), 0, this);
    }

    private ICameraService getCameraServiceLocked() {
        return InvokeDynamicSupport.bootstrap("getCameraServiceLocked", $$robo$$android_hardware_camera2_CameraManager$getCameraServiceLocked(), 0, this);
    }

    public /* synthetic */ CameraManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CameraManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class CameraServiceListener
    extends ICameraServiceListener.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int STATUS_NOT_PRESENT = 0;
        public static int STATUS_PRESENT = 1;
        public static int STATUS_ENUMERATING = 2;
        public static int STATUS_NOT_AVAILABLE = Integer.MIN_VALUE;
        private ArrayMap<String, Integer> mDeviceStatus;
        private static String TAG = "CameraServiceListener";
        /* synthetic */ CameraManager this$0;

        private void $$robo$$android_hardware_camera2_CameraManager_CameraServiceListener$__constructor__(CameraManager cameraManager) {
            this.mDeviceStatus = new ArrayMap();
        }

        private final IBinder $$robo$$android_hardware_camera2_CameraManager_CameraServiceListener$asBinder() {
            return this;
        }

        private final boolean $$robo$$android_hardware_camera2_CameraManager_CameraServiceListener$isAvailable(int status) {
            switch (status) {
                case 1: {
                    return true;
                }
            }
            return false;
        }

        private final boolean $$robo$$android_hardware_camera2_CameraManager_CameraServiceListener$validStatus(int status) {
            switch (status) {
                case -2147483648: 
                case 0: 
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }

        private final void $$robo$$android_hardware_camera2_CameraManager_CameraServiceListener$postSingleUpdate(AvailabilityCallback callback, Handler handler, String id2, int status) {
            if (this.isAvailable(status)) {
                handler.post(new Runnable(this, callback, id2){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ AvailabilityCallback val$callback;
                    /* synthetic */ String val$id;
                    /* synthetic */ CameraServiceListener this$1;

                    private void $$robo$$android_hardware_camera2_CameraManager_CameraServiceListener_1$__constructor__(CameraServiceListener cameraServiceListener, AvailabilityCallback availabilityCallback, String string2) {
                    }

                    private final void $$robo$$android_hardware_camera2_CameraManager_CameraServiceListener_1$run() {
                        this.val$callback.onCameraAvailable(this.val$id);
                    }

                    private void __constructor__(CameraServiceListener cameraServiceListener, AvailabilityCallback availabilityCallback, String string2) {
                        this.$$robo$$android_hardware_camera2_CameraManager_CameraServiceListener_1$__constructor__(cameraServiceListener, availabilityCallback, string2);
                    }
                    {
                        this.this$1 = cameraServiceListener;
                        this.val$callback = availabilityCallback;
                        this.val$id = string2;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CameraManager_CameraServiceListener_1$__constructor__(android.hardware.camera2.CameraManager$CameraServiceListener android.hardware.camera2.CameraManager$AvailabilityCallback java.lang.String ), 0, this, cameraServiceListener, availabilityCallback, string2);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_CameraManager_CameraServiceListener_1$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            } else {
                handler.post(new Runnable(this, callback, id2){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ AvailabilityCallback val$callback;
                    /* synthetic */ String val$id;
                    /* synthetic */ CameraServiceListener this$1;

                    private void $$robo$$android_hardware_camera2_CameraManager_CameraServiceListener_2$__constructor__(CameraServiceListener cameraServiceListener, AvailabilityCallback availabilityCallback, String string2) {
                    }

                    private final void $$robo$$android_hardware_camera2_CameraManager_CameraServiceListener_2$run() {
                        this.val$callback.onCameraUnavailable(this.val$id);
                    }

                    private void __constructor__(CameraServiceListener cameraServiceListener, AvailabilityCallback availabilityCallback, String string2) {
                        this.$$robo$$android_hardware_camera2_CameraManager_CameraServiceListener_2$__constructor__(cameraServiceListener, availabilityCallback, string2);
                    }
                    {
                        this.this$1 = cameraServiceListener;
                        this.val$callback = availabilityCallback;
                        this.val$id = string2;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CameraManager_CameraServiceListener_2$__constructor__(android.hardware.camera2.CameraManager$CameraServiceListener android.hardware.camera2.CameraManager$AvailabilityCallback java.lang.String ), 0, this, cameraServiceListener, availabilityCallback, string2);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_CameraManager_CameraServiceListener_2$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        }

        private final void $$robo$$android_hardware_camera2_CameraManager_CameraServiceListener$updateCallbackLocked(AvailabilityCallback callback, Handler handler) {
            for (int i = 0; i < this.mDeviceStatus.size(); ++i) {
                String id2 = this.mDeviceStatus.keyAt(i);
                Integer status = this.mDeviceStatus.valueAt(i);
                this.postSingleUpdate(callback, handler, id2, status);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_camera2_CameraManager_CameraServiceListener$onStatusChanged(int status, int cameraId) throws RemoteException {
            Object object = this.this$0.mLock;
            synchronized (object) {
                this.onStatusChangedLocked(status, String.valueOf(cameraId));
            }
        }

        private final void $$robo$$android_hardware_camera2_CameraManager_CameraServiceListener$onStatusChangedLocked(int status, String id2) {
            if (this.this$0.DEBUG) {
                Log.v("CameraServiceListener", String.format("Camera id %s has status changed to 0x%x", id2, status));
            }
            if (!this.validStatus(status)) {
                Log.e("CameraServiceListener", String.format("Ignoring invalid device %s status 0x%x", id2, status));
                return;
            }
            Integer oldStatus = this.mDeviceStatus.put(id2, status);
            if (oldStatus != null && oldStatus == status) {
                if (this.this$0.DEBUG) {
                    Log.v("CameraServiceListener", String.format("Device status changed to 0x%x, which is what it already was", status));
                }
                return;
            }
            if (oldStatus != null && this.isAvailable(status) == this.isAvailable(oldStatus)) {
                if (this.this$0.DEBUG) {
                    Log.v("CameraServiceListener", String.format("Device status was previously available (%d),  and is now again available (%d)so no new client visible update will be sent", this.isAvailable(status), this.isAvailable(status)));
                }
                return;
            }
            int callbackCount = this.this$0.mCallbackMap.size();
            for (int i = 0; i < callbackCount; ++i) {
                Handler handler = (Handler)this.this$0.mCallbackMap.valueAt(i);
                AvailabilityCallback callback = (AvailabilityCallback)this.this$0.mCallbackMap.keyAt(i);
                this.postSingleUpdate(callback, handler, id2, status);
            }
        }

        private /* synthetic */ void $$robo$$android_hardware_camera2_CameraManager_CameraServiceListener$__constructor__(CameraManager x0, 1 x1) {
        }

        private void __constructor__(CameraManager cameraManager) {
            this.$$robo$$android_hardware_camera2_CameraManager_CameraServiceListener$__constructor__(cameraManager);
        }

        private CameraServiceListener(CameraManager cameraManager) {
            this.this$0 = cameraManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CameraManager_CameraServiceListener$__constructor__(android.hardware.camera2.CameraManager ), 0, this, cameraManager);
        }

        @Override
        public IBinder asBinder() {
            return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_hardware_camera2_CameraManager_CameraServiceListener$asBinder(), 0, this);
        }

        private boolean isAvailable(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isAvailable", $$robo$$android_hardware_camera2_CameraManager_CameraServiceListener$isAvailable(int ), 0, this, n);
        }

        private boolean validStatus(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("validStatus", $$robo$$android_hardware_camera2_CameraManager_CameraServiceListener$validStatus(int ), 0, this, n);
        }

        private void postSingleUpdate(AvailabilityCallback availabilityCallback, Handler handler, String string2, int n) {
            InvokeDynamicSupport.bootstrap("postSingleUpdate", $$robo$$android_hardware_camera2_CameraManager_CameraServiceListener$postSingleUpdate(android.hardware.camera2.CameraManager$AvailabilityCallback android.os.Handler java.lang.String int ), 0, this, availabilityCallback, handler, string2, n);
        }

        public void updateCallbackLocked(AvailabilityCallback availabilityCallback, Handler handler) {
            InvokeDynamicSupport.bootstrap("updateCallbackLocked", $$robo$$android_hardware_camera2_CameraManager_CameraServiceListener$updateCallbackLocked(android.hardware.camera2.CameraManager$AvailabilityCallback android.os.Handler ), 0, this, availabilityCallback, handler);
        }

        @Override
        public void onStatusChanged(int n, int n2) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onStatusChanged", $$robo$$android_hardware_camera2_CameraManager_CameraServiceListener$onStatusChanged(int int ), 0, this, n, n2);
        }

        public void onStatusChangedLocked(int n, String string2) {
            InvokeDynamicSupport.bootstrap("onStatusChangedLocked", $$robo$$android_hardware_camera2_CameraManager_CameraServiceListener$onStatusChangedLocked(int java.lang.String ), 0, this, n, string2);
        }

        private /* synthetic */ void __constructor__(CameraManager cameraManager, 1 var2_2) {
            this.$$robo$$android_hardware_camera2_CameraManager_CameraServiceListener$__constructor__(cameraManager, var2_2);
        }

        public /* synthetic */ CameraServiceListener() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CameraServiceListener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class CameraServiceDeathListener
    implements IBinder.DeathRecipient,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ CameraManager this$0;

        private void $$robo$$android_hardware_camera2_CameraManager_CameraServiceDeathListener$__constructor__(CameraManager cameraManager) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_camera2_CameraManager_CameraServiceDeathListener$binderDied() {
            Object object = this.this$0.mLock;
            synchronized (object) {
                this.this$0.mCameraService = null;
                for (String cameraId : this.this$0.mDeviceIdList) {
                    this.this$0.mServiceListener.onStatusChangedLocked(1, cameraId);
                }
            }
        }

        private /* synthetic */ void $$robo$$android_hardware_camera2_CameraManager_CameraServiceDeathListener$__constructor__(CameraManager x0, 1 x1) {
        }

        private void __constructor__(CameraManager cameraManager) {
            this.$$robo$$android_hardware_camera2_CameraManager_CameraServiceDeathListener$__constructor__(cameraManager);
        }

        private CameraServiceDeathListener(CameraManager cameraManager) {
            this.this$0 = cameraManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CameraManager_CameraServiceDeathListener$__constructor__(android.hardware.camera2.CameraManager ), 0, this, cameraManager);
        }

        @Override
        public void binderDied() {
            InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_hardware_camera2_CameraManager_CameraServiceDeathListener$binderDied(), 0, this);
        }

        private /* synthetic */ void __constructor__(CameraManager cameraManager, 1 var2_2) {
            this.$$robo$$android_hardware_camera2_CameraManager_CameraServiceDeathListener$__constructor__(cameraManager, var2_2);
        }

        public /* synthetic */ CameraServiceDeathListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CameraServiceDeathListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class AvailabilityListener
    extends AvailabilityCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_hardware_camera2_CameraManager_AvailabilityListener$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_hardware_camera2_CameraManager_AvailabilityListener$__constructor__();
        }

        public AvailabilityListener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CameraManager_AvailabilityListener$__constructor__(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AvailabilityListener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class AvailabilityCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_hardware_camera2_CameraManager_AvailabilityCallback$__constructor__() {
        }

        private final void $$robo$$android_hardware_camera2_CameraManager_AvailabilityCallback$onCameraAvailable(String cameraId) {
        }

        private final void $$robo$$android_hardware_camera2_CameraManager_AvailabilityCallback$onCameraUnavailable(String cameraId) {
        }

        private void __constructor__() {
            this.$$robo$$android_hardware_camera2_CameraManager_AvailabilityCallback$__constructor__();
        }

        public AvailabilityCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CameraManager_AvailabilityCallback$__constructor__(), 0, this);
        }

        public void onCameraAvailable(String string2) {
            InvokeDynamicSupport.bootstrap("onCameraAvailable", $$robo$$android_hardware_camera2_CameraManager_AvailabilityCallback$onCameraAvailable(java.lang.String ), 0, this, string2);
        }

        public void onCameraUnavailable(String string2) {
            InvokeDynamicSupport.bootstrap("onCameraUnavailable", $$robo$$android_hardware_camera2_CameraManager_AvailabilityCallback$onCameraUnavailable(java.lang.String ), 0, this, string2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AvailabilityCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

