/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.ICameraDeviceCallbacks;
import android.hardware.camera2.ICameraDeviceUser;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.impl.CameraCaptureSessionImpl;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.impl.CaptureResultExtras;
import android.hardware.camera2.utils.CameraBinderDecorator;
import android.hardware.camera2.utils.CameraRuntimeException;
import android.hardware.camera2.utils.LongParcelable;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import android.view.Surface;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CameraDeviceImpl
extends CameraDevice
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String TAG;
    private boolean DEBUG;
    private static int REQUEST_ID_NONE = -1;
    private ICameraDeviceUser mRemoteDevice;
    Object mInterfaceLock;
    private CameraDeviceCallbacks mCallbacks;
    private CameraDevice.StateCallback mDeviceCallback;
    private volatile StateCallbackKK mSessionStateCallback;
    private Handler mDeviceHandler;
    private volatile boolean mClosing;
    private boolean mInError;
    private boolean mIdle;
    private SparseArray<CaptureCallbackHolder> mCaptureCallbackMap;
    private int mRepeatingRequestId;
    private ArrayList<Integer> mRepeatingRequestIdDeletedList;
    private SparseArray<Surface> mConfiguredOutputs;
    private String mCameraId;
    private CameraCharacteristics mCharacteristics;
    private int mTotalPartialCount;
    private List<AbstractMap.SimpleEntry<Long, Integer>> mFrameNumberRequestPairs;
    private FrameNumberTracker mFrameNumberTracker;
    private CameraCaptureSessionImpl mCurrentSession;
    private int mNextSessionId;
    private Runnable mCallOnOpened;
    private Runnable mCallOnUnconfigured;
    private Runnable mCallOnActive;
    private Runnable mCallOnBusy;
    private Runnable mCallOnClosed;
    private Runnable mCallOnIdle;
    private Runnable mCallOnDisconnected;

    private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$__constructor__(String cameraId, CameraDevice.StateCallback callback, Handler handler, CameraCharacteristics characteristics) {
        this.mInterfaceLock = new Object();
        this.mCallbacks = new CameraDeviceCallbacks(this);
        this.mClosing = false;
        this.mInError = false;
        this.mIdle = true;
        this.mCaptureCallbackMap = new SparseArray();
        this.mRepeatingRequestId = -1;
        this.mRepeatingRequestIdDeletedList = new ArrayList();
        this.mConfiguredOutputs = new SparseArray();
        this.mFrameNumberRequestPairs = new ArrayList<AbstractMap.SimpleEntry<Long, Integer>>();
        this.mFrameNumberTracker = new FrameNumberTracker(this);
        this.mNextSessionId = 0;
        this.mCallOnOpened = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CameraDeviceImpl this$0;

            private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_1$__constructor__(CameraDeviceImpl cameraDeviceImpl) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_1$run() {
                StateCallbackKK sessionCallback = null;
                Object object = this.this$0.mInterfaceLock;
                synchronized (object) {
                    if (this.this$0.mRemoteDevice == null) {
                        return;
                    }
                    sessionCallback = this.this$0.mSessionStateCallback;
                }
                if (sessionCallback != null) {
                    sessionCallback.onOpened(this.this$0);
                }
                this.this$0.mDeviceCallback.onOpened(this.this$0);
            }

            private void __constructor__(CameraDeviceImpl cameraDeviceImpl) {
                this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_1$__constructor__(cameraDeviceImpl);
            }
            {
                this.this$0 = cameraDeviceImpl;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_1$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl ), 0, this, cameraDeviceImpl);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCallOnUnconfigured = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CameraDeviceImpl this$0;

            private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_2$__constructor__(CameraDeviceImpl cameraDeviceImpl) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_2$run() {
                StateCallbackKK sessionCallback = null;
                Object object = this.this$0.mInterfaceLock;
                synchronized (object) {
                    if (this.this$0.mRemoteDevice == null) {
                        return;
                    }
                    sessionCallback = this.this$0.mSessionStateCallback;
                }
                if (sessionCallback != null) {
                    sessionCallback.onUnconfigured(this.this$0);
                }
            }

            private void __constructor__(CameraDeviceImpl cameraDeviceImpl) {
                this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_2$__constructor__(cameraDeviceImpl);
            }
            {
                this.this$0 = cameraDeviceImpl;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_2$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl ), 0, this, cameraDeviceImpl);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_2$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCallOnActive = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CameraDeviceImpl this$0;

            private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_3$__constructor__(CameraDeviceImpl cameraDeviceImpl) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_3$run() {
                StateCallbackKK sessionCallback = null;
                Object object = this.this$0.mInterfaceLock;
                synchronized (object) {
                    if (this.this$0.mRemoteDevice == null) {
                        return;
                    }
                    sessionCallback = this.this$0.mSessionStateCallback;
                }
                if (sessionCallback != null) {
                    sessionCallback.onActive(this.this$0);
                }
            }

            private void __constructor__(CameraDeviceImpl cameraDeviceImpl) {
                this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_3$__constructor__(cameraDeviceImpl);
            }
            {
                this.this$0 = cameraDeviceImpl;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_3$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl ), 0, this, cameraDeviceImpl);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_3$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCallOnBusy = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CameraDeviceImpl this$0;

            private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_4$__constructor__(CameraDeviceImpl cameraDeviceImpl) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_4$run() {
                StateCallbackKK sessionCallback = null;
                Object object = this.this$0.mInterfaceLock;
                synchronized (object) {
                    if (this.this$0.mRemoteDevice == null) {
                        return;
                    }
                    sessionCallback = this.this$0.mSessionStateCallback;
                }
                if (sessionCallback != null) {
                    sessionCallback.onBusy(this.this$0);
                }
            }

            private void __constructor__(CameraDeviceImpl cameraDeviceImpl) {
                this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_4$__constructor__(cameraDeviceImpl);
            }
            {
                this.this$0 = cameraDeviceImpl;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_4$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl ), 0, this, cameraDeviceImpl);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_4$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCallOnClosed = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            private boolean mClosedOnce;
            /* synthetic */ CameraDeviceImpl this$0;

            private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_5$__constructor__(CameraDeviceImpl cameraDeviceImpl) {
                this.mClosedOnce = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_5$run() {
                if (this.mClosedOnce) {
                    throw new AssertionError((Object)"Don't post #onClosed more than once");
                }
                StateCallbackKK sessionCallback = null;
                Object object = this.this$0.mInterfaceLock;
                synchronized (object) {
                    sessionCallback = this.this$0.mSessionStateCallback;
                }
                if (sessionCallback != null) {
                    sessionCallback.onClosed(this.this$0);
                }
                this.this$0.mDeviceCallback.onClosed(this.this$0);
                this.mClosedOnce = true;
            }

            private void __constructor__(CameraDeviceImpl cameraDeviceImpl) {
                this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_5$__constructor__(cameraDeviceImpl);
            }
            {
                this.this$0 = cameraDeviceImpl;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_5$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl ), 0, this, cameraDeviceImpl);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_5$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCallOnIdle = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CameraDeviceImpl this$0;

            private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_6$__constructor__(CameraDeviceImpl cameraDeviceImpl) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_6$run() {
                StateCallbackKK sessionCallback = null;
                Object object = this.this$0.mInterfaceLock;
                synchronized (object) {
                    if (this.this$0.mRemoteDevice == null) {
                        return;
                    }
                    sessionCallback = this.this$0.mSessionStateCallback;
                }
                if (sessionCallback != null) {
                    sessionCallback.onIdle(this.this$0);
                }
            }

            private void __constructor__(CameraDeviceImpl cameraDeviceImpl) {
                this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_6$__constructor__(cameraDeviceImpl);
            }
            {
                this.this$0 = cameraDeviceImpl;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_6$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl ), 0, this, cameraDeviceImpl);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_6$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCallOnDisconnected = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CameraDeviceImpl this$0;

            private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_7$__constructor__(CameraDeviceImpl cameraDeviceImpl) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_7$run() {
                StateCallbackKK sessionCallback = null;
                Object object = this.this$0.mInterfaceLock;
                synchronized (object) {
                    if (this.this$0.mRemoteDevice == null) {
                        return;
                    }
                    sessionCallback = this.this$0.mSessionStateCallback;
                }
                if (sessionCallback != null) {
                    sessionCallback.onDisconnected(this.this$0);
                }
                this.this$0.mDeviceCallback.onDisconnected(this.this$0);
            }

            private void __constructor__(CameraDeviceImpl cameraDeviceImpl) {
                this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_7$__constructor__(cameraDeviceImpl);
            }
            {
                this.this$0 = cameraDeviceImpl;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_7$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl ), 0, this, cameraDeviceImpl);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_7$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        if (cameraId == null || callback == null || handler == null || characteristics == null) {
            throw new IllegalArgumentException("Null argument given");
        }
        this.mCameraId = cameraId;
        this.mDeviceCallback = callback;
        this.mDeviceHandler = handler;
        this.mCharacteristics = characteristics;
        int MAX_TAG_LEN = 23;
        String tag = String.format("CameraDevice-JV-%s", this.mCameraId);
        if (tag.length() > 23) {
            tag = tag.substring(0, 23);
        }
        this.TAG = tag;
        this.DEBUG = Log.isLoggable(this.TAG, 3);
        Integer partialCount = this.mCharacteristics.get(CameraCharacteristics.REQUEST_PARTIAL_RESULT_COUNT);
        this.mTotalPartialCount = partialCount == null ? 1 : partialCount;
    }

    private final CameraDeviceCallbacks $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$getCallbacks() {
        return this.mCallbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$setRemoteDevice(ICameraDeviceUser remoteDevice) {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (this.mInError) {
                return;
            }
            this.mRemoteDevice = CameraBinderDecorator.newInstance(remoteDevice);
            this.mDeviceHandler.post(this.mCallOnOpened);
            this.mDeviceHandler.post(this.mCallOnUnconfigured);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$setRemoteFailure(CameraRuntimeException failure) {
        int failureCode = 4;
        boolean failureIsError = true;
        switch (failure.getReason()) {
            case 4: {
                failureCode = 1;
                break;
            }
            case 5: {
                failureCode = 2;
                break;
            }
            case 1: {
                failureCode = 3;
                break;
            }
            case 2: {
                failureIsError = false;
                break;
            }
            case 3: {
                failureCode = 4;
                break;
            }
            default: {
                Log.wtf(this.TAG, "Unknown failure in opening camera device: " + failure.getReason());
            }
        }
        int code = failureCode;
        boolean isError = failureIsError;
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.mInError = true;
            this.mDeviceHandler.post(new Runnable(this, isError, code){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ boolean val$isError;
                /* synthetic */ int val$code;
                /* synthetic */ CameraDeviceImpl this$0;

                private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_8$__constructor__(CameraDeviceImpl cameraDeviceImpl, boolean bl, int n) {
                }

                private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_8$run() {
                    if (this.val$isError) {
                        this.this$0.mDeviceCallback.onError(this.this$0, this.val$code);
                    } else {
                        this.this$0.mDeviceCallback.onDisconnected(this.this$0);
                    }
                }

                private void __constructor__(CameraDeviceImpl cameraDeviceImpl, boolean bl, int n) {
                    this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_8$__constructor__(cameraDeviceImpl, bl, n);
                }
                {
                    this.this$0 = cameraDeviceImpl;
                    this.val$isError = bl;
                    this.val$code = n;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_8$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl boolean int ), 0, this, cameraDeviceImpl, bl, n);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_8$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final String $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$getId() {
        return this.mCameraId;
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$configureOutputs(List<Surface> outputs) throws CameraAccessException {
        this.configureOutputsChecked(outputs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$configureOutputsChecked(List<Surface> outputs) throws CameraAccessException {
        if (outputs == null) {
            outputs = new ArrayList<Surface>();
        }
        boolean success = false;
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            HashSet<Surface> addSet = new HashSet<Surface>(outputs);
            ArrayList<Integer> deleteList = new ArrayList<Integer>();
            for (int i = 0; i < this.mConfiguredOutputs.size(); ++i) {
                int streamId = this.mConfiguredOutputs.keyAt(i);
                Surface s = this.mConfiguredOutputs.valueAt(i);
                if (!outputs.contains(s)) {
                    deleteList.add(streamId);
                    continue;
                }
                addSet.remove(s);
            }
            this.mDeviceHandler.post(this.mCallOnBusy);
            this.stopRepeating();
            try {
                this.waitUntilIdle();
                this.mRemoteDevice.beginConfigure();
                for (Integer streamId : deleteList) {
                    this.mRemoteDevice.deleteStream(streamId);
                    this.mConfiguredOutputs.delete(streamId);
                }
                for (Surface s : addSet) {
                    int streamId = this.mRemoteDevice.createStream(0, 0, 0, s);
                    this.mConfiguredOutputs.put(streamId, s);
                }
                try {
                    this.mRemoteDevice.endConfigure();
                }
                catch (IllegalArgumentException e) {
                    Log.w(this.TAG, "Stream configuration failed");
                    boolean bl = false;
                    if (success && outputs.size() > 0) {
                        this.mDeviceHandler.post(this.mCallOnIdle);
                    } else {
                        this.mDeviceHandler.post(this.mCallOnUnconfigured);
                    }
                    return bl;
                }
                success = true;
            }
            catch (CameraRuntimeException e) {
                if (e.getReason() != 4) throw e.asChecked();
                throw new IllegalStateException("The camera is currently busy. You must wait until the previous operation completes.");
            }
            catch (RemoteException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (success && outputs.size() > 0) {
                    this.mDeviceHandler.post(this.mCallOnIdle);
                } else {
                    this.mDeviceHandler.post(this.mCallOnUnconfigured);
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$createCaptureSession(List<Surface> outputs, CameraCaptureSession.StateCallback callback, Handler handler) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            CameraCaptureSessionImpl newSession;
            CameraAccessException pendingException;
            boolean configureSuccess;
            block8: {
                if (this.DEBUG) {
                    Log.d(this.TAG, "createCaptureSession");
                }
                this.checkIfCameraClosedOrInError();
                if (this.mCurrentSession != null) {
                    this.mCurrentSession.replaceSessionClose();
                }
                configureSuccess = true;
                pendingException = null;
                try {
                    configureSuccess = this.configureOutputsChecked(outputs);
                }
                catch (CameraAccessException e) {
                    configureSuccess = false;
                    pendingException = e;
                    if (!this.DEBUG) break block8;
                    Log.v(this.TAG, "createCaptureSession - failed with exception ", e);
                }
            }
            this.mCurrentSession = newSession = new CameraCaptureSessionImpl(this.mNextSessionId++, outputs, callback, handler, this, this.mDeviceHandler, configureSuccess);
            if (pendingException != null) {
                throw pendingException;
            }
            this.mSessionStateCallback = this.mCurrentSession.getDeviceStateCallback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$setSessionListener(StateCallbackKK sessionCallback) {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.mSessionStateCallback = sessionCallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CaptureRequest.Builder $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$createCaptureRequest(int templateType) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            CameraMetadataNative templatedRequest = new CameraMetadataNative();
            try {
                this.mRemoteDevice.createDefaultRequest(templateType, templatedRequest);
            }
            catch (CameraRuntimeException e) {
                throw e.asChecked();
            }
            catch (RemoteException e) {
                return null;
            }
            CaptureRequest.Builder builder = new CaptureRequest.Builder(templatedRequest);
            return builder;
        }
    }

    private final int $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$capture(CaptureRequest request, CaptureCallback callback, Handler handler) throws CameraAccessException {
        if (this.DEBUG) {
            Log.d(this.TAG, "calling capture");
        }
        ArrayList<CaptureRequest> requestList = new ArrayList<CaptureRequest>();
        requestList.add(request);
        return this.submitCaptureRequest(requestList, callback, handler, false);
    }

    private final int $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$captureBurst(List<CaptureRequest> requests, CaptureCallback callback, Handler handler) throws CameraAccessException {
        if (requests == null || requests.isEmpty()) {
            throw new IllegalArgumentException("At least one request must be given");
        }
        return this.submitCaptureRequest(requests, callback, handler, false);
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$checkEarlyTriggerSequenceComplete(int requestId, long lastFrameNumber) {
        if (lastFrameNumber == -1L) {
            CaptureCallbackHolder holder;
            int index = this.mCaptureCallbackMap.indexOfKey(requestId);
            CaptureCallbackHolder captureCallbackHolder = holder = index >= 0 ? this.mCaptureCallbackMap.valueAt(index) : null;
            if (holder != null) {
                this.mCaptureCallbackMap.removeAt(index);
                if (this.DEBUG) {
                    Log.v(this.TAG, String.format("remove holder for requestId %d, because lastFrame is %d.", requestId, lastFrameNumber));
                }
            }
            if (holder != null) {
                if (this.DEBUG) {
                    Log.v(this.TAG, "immediately trigger onCaptureSequenceAborted because request did not reach HAL");
                }
                Runnable resultDispatch = new Runnable(this, requestId, lastFrameNumber, holder){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$requestId;
                    /* synthetic */ long val$lastFrameNumber;
                    /* synthetic */ CaptureCallbackHolder val$holder;
                    /* synthetic */ CameraDeviceImpl this$0;

                    private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_9$__constructor__(CameraDeviceImpl cameraDeviceImpl, int n, long l, CaptureCallbackHolder captureCallbackHolder) {
                    }

                    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_9$run() {
                        if (!this.this$0.isClosed()) {
                            if (this.this$0.DEBUG) {
                                Log.d(this.this$0.TAG, String.format("early trigger sequence complete for request %d", this.val$requestId));
                            }
                            if (this.val$lastFrameNumber < Integer.MIN_VALUE || this.val$lastFrameNumber > Integer.MAX_VALUE) {
                                throw new AssertionError((Object)(this.val$lastFrameNumber + " cannot be cast to int"));
                            }
                            this.val$holder.getCallback().onCaptureSequenceAborted(this.this$0, this.val$requestId);
                        }
                    }

                    private void __constructor__(CameraDeviceImpl cameraDeviceImpl, int n, long l, CaptureCallbackHolder captureCallbackHolder) {
                        this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_9$__constructor__(cameraDeviceImpl, n, l, captureCallbackHolder);
                    }
                    {
                        this.this$0 = cameraDeviceImpl;
                        this.val$requestId = n;
                        this.val$lastFrameNumber = l;
                        this.val$holder = captureCallbackHolder;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_9$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl int long android.hardware.camera2.impl.CameraDeviceImpl$CaptureCallbackHolder ), 0, this, cameraDeviceImpl, n, l, captureCallbackHolder);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_9$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
                holder.getHandler().post(resultDispatch);
            } else {
                Log.w(this.TAG, String.format("did not register callback to request %d", requestId));
            }
        } else {
            this.mFrameNumberRequestPairs.add(new AbstractMap.SimpleEntry<Long, Integer>(lastFrameNumber, requestId));
            this.checkAndFireSequenceComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$submitCaptureRequest(List<CaptureRequest> requestList, CaptureCallback callback, Handler handler, boolean repeating) throws CameraAccessException {
        handler = CameraDeviceImpl.checkHandler(handler, callback);
        for (CaptureRequest request : requestList) {
            if (request.getTargets().isEmpty()) {
                throw new IllegalArgumentException("Each request must have at least one Surface target");
            }
            for (Surface surface : request.getTargets()) {
                if (surface != null) continue;
                throw new IllegalArgumentException("Null Surface targets are not allowed");
            }
        }
        Object object = this.mInterfaceLock;
        synchronized (object) {
            int requestId;
            this.checkIfCameraClosedOrInError();
            if (repeating) {
                this.stopRepeating();
            }
            LongParcelable lastFrameNumberRef = new LongParcelable();
            try {
                requestId = this.mRemoteDevice.submitRequestList(requestList, repeating, lastFrameNumberRef);
                if (this.DEBUG) {
                    Log.v(this.TAG, "last frame number " + lastFrameNumberRef.getNumber());
                }
            }
            catch (CameraRuntimeException e) {
                throw e.asChecked();
            }
            catch (RemoteException e) {
                return -1;
            }
            if (callback != null) {
                this.mCaptureCallbackMap.put(requestId, new CaptureCallbackHolder(callback, requestList, handler, repeating));
            } else if (this.DEBUG) {
                Log.d(this.TAG, "Listen for request " + requestId + " is null");
            }
            long lastFrameNumber = lastFrameNumberRef.getNumber();
            if (repeating) {
                if (this.mRepeatingRequestId != -1) {
                    this.checkEarlyTriggerSequenceComplete(this.mRepeatingRequestId, lastFrameNumber);
                }
                this.mRepeatingRequestId = requestId;
            } else {
                this.mFrameNumberRequestPairs.add(new AbstractMap.SimpleEntry<Long, Integer>(lastFrameNumber, requestId));
            }
            if (this.mIdle) {
                this.mDeviceHandler.post(this.mCallOnActive);
            }
            this.mIdle = false;
            return requestId;
        }
    }

    private final int $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$setRepeatingRequest(CaptureRequest request, CaptureCallback callback, Handler handler) throws CameraAccessException {
        ArrayList<CaptureRequest> requestList = new ArrayList<CaptureRequest>();
        requestList.add(request);
        return this.submitCaptureRequest(requestList, callback, handler, true);
    }

    private final int $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$setRepeatingBurst(List<CaptureRequest> requests, CaptureCallback callback, Handler handler) throws CameraAccessException {
        if (requests == null || requests.isEmpty()) {
            throw new IllegalArgumentException("At least one request must be given");
        }
        return this.submitCaptureRequest(requests, callback, handler, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$stopRepeating() throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            if (this.mRepeatingRequestId != -1) {
                int requestId = this.mRepeatingRequestId;
                this.mRepeatingRequestId = -1;
                if (this.mCaptureCallbackMap.get(requestId) != null) {
                    this.mRepeatingRequestIdDeletedList.add(requestId);
                }
                try {
                    LongParcelable lastFrameNumberRef = new LongParcelable();
                    this.mRemoteDevice.cancelRequest(requestId, lastFrameNumberRef);
                    long lastFrameNumber = lastFrameNumberRef.getNumber();
                    this.checkEarlyTriggerSequenceComplete(requestId, lastFrameNumber);
                }
                catch (CameraRuntimeException e) {
                    throw e.asChecked();
                }
                catch (RemoteException e) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$waitUntilIdle() throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            if (this.mRepeatingRequestId != -1) {
                throw new IllegalStateException("Active repeating request ongoing");
            }
            try {
                this.mRemoteDevice.waitUntilIdle();
            }
            catch (CameraRuntimeException e) {
                throw e.asChecked();
            }
            catch (RemoteException e) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$flush() throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            this.mDeviceHandler.post(this.mCallOnBusy);
            if (this.mIdle) {
                this.mDeviceHandler.post(this.mCallOnIdle);
                return;
            }
            try {
                LongParcelable lastFrameNumberRef = new LongParcelable();
                this.mRemoteDevice.flush(lastFrameNumberRef);
                if (this.mRepeatingRequestId != -1) {
                    long lastFrameNumber = lastFrameNumberRef.getNumber();
                    this.checkEarlyTriggerSequenceComplete(this.mRepeatingRequestId, lastFrameNumber);
                    this.mRepeatingRequestId = -1;
                }
            }
            catch (CameraRuntimeException e) {
                throw e.asChecked();
            }
            catch (RemoteException e) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$close() {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            try {
                if (this.mRemoteDevice != null) {
                    this.mRemoteDevice.disconnect();
                }
            }
            catch (CameraRuntimeException e) {
                Log.e(this.TAG, "Exception while closing: ", e.asChecked());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (this.mRemoteDevice != null || this.mInError) {
                this.mDeviceHandler.post(this.mCallOnClosed);
            }
            this.mRemoteDevice = null;
            this.mInError = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$checkAndFireSequenceComplete() {
        long completedFrameNumber = this.mFrameNumberTracker.getCompletedFrameNumber();
        Iterator<AbstractMap.SimpleEntry<Long, Integer>> iter = this.mFrameNumberRequestPairs.iterator();
        while (iter.hasNext()) {
            CaptureCallbackHolder holder;
            AbstractMap.SimpleEntry<Long, Integer> frameNumberRequestPair = iter.next();
            if (frameNumberRequestPair.getKey() > completedFrameNumber) continue;
            int requestId = frameNumberRequestPair.getValue();
            Object object = this.mInterfaceLock;
            synchronized (object) {
                if (this.mRemoteDevice == null) {
                    Log.w(this.TAG, "Camera closed while checking sequences");
                    return;
                }
                int index = this.mCaptureCallbackMap.indexOfKey(requestId);
                CaptureCallbackHolder captureCallbackHolder = holder = index >= 0 ? this.mCaptureCallbackMap.valueAt(index) : null;
                if (holder != null) {
                    this.mCaptureCallbackMap.removeAt(index);
                    if (this.DEBUG) {
                        Log.v(this.TAG, String.format("remove holder for requestId %d, because lastFrame %d is <= %d", requestId, frameNumberRequestPair.getKey(), completedFrameNumber));
                    }
                }
            }
            iter.remove();
            if (holder == null) continue;
            Runnable resultDispatch = new Runnable(this, requestId, frameNumberRequestPair, holder){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ int val$requestId;
                /* synthetic */ AbstractMap.SimpleEntry val$frameNumberRequestPair;
                /* synthetic */ CaptureCallbackHolder val$holder;
                /* synthetic */ CameraDeviceImpl this$0;

                private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_10$__constructor__(CameraDeviceImpl cameraDeviceImpl, int n, AbstractMap.SimpleEntry simpleEntry, CaptureCallbackHolder captureCallbackHolder) {
                }

                private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_10$run() {
                    if (!this.this$0.isClosed()) {
                        long lastFrameNumber;
                        if (this.this$0.DEBUG) {
                            Log.d(this.this$0.TAG, String.format("fire sequence complete for request %d", this.val$requestId));
                        }
                        if ((lastFrameNumber = ((Long)this.val$frameNumberRequestPair.getKey()).longValue()) < Integer.MIN_VALUE || lastFrameNumber > Integer.MAX_VALUE) {
                            throw new AssertionError((Object)(lastFrameNumber + " cannot be cast to int"));
                        }
                        this.val$holder.getCallback().onCaptureSequenceCompleted(this.this$0, this.val$requestId, lastFrameNumber);
                    }
                }

                private void __constructor__(CameraDeviceImpl cameraDeviceImpl, int n, AbstractMap.SimpleEntry simpleEntry, CaptureCallbackHolder captureCallbackHolder) {
                    this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_10$__constructor__(cameraDeviceImpl, n, simpleEntry, captureCallbackHolder);
                }
                {
                    this.this$0 = cameraDeviceImpl;
                    this.val$requestId = n;
                    this.val$frameNumberRequestPair = simpleEntry;
                    this.val$holder = captureCallbackHolder;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_10$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl int java.util.AbstractMap$SimpleEntry android.hardware.camera2.impl.CameraDeviceImpl$CaptureCallbackHolder ), 0, this, cameraDeviceImpl, n, simpleEntry, captureCallbackHolder);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_10$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            holder.getHandler().post(resultDispatch);
        }
    }

    private static final Handler $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$checkHandler(Handler handler) {
        if (handler == null) {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                throw new IllegalArgumentException("No handler given, and current thread has no looper!");
            }
            handler = new Handler(looper);
        }
        return handler;
    }

    private static final <T> Handler $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$checkHandler(Handler handler, T callback) {
        if (callback != null) {
            return CameraDeviceImpl.checkHandler(handler);
        }
        return handler;
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$checkIfCameraClosedOrInError() throws CameraAccessException {
        if (this.mInError) {
            throw new CameraAccessException(3, "The camera device has encountered a serious error");
        }
        if (this.mRemoteDevice == null) {
            throw new IllegalStateException("CameraDevice was already closed");
        }
    }

    private final boolean $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$isClosed() {
        return this.mClosing;
    }

    private final CameraCharacteristics $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$getCharacteristics() {
        return this.mCharacteristics;
    }

    private void __constructor__(String string2, CameraDevice.StateCallback stateCallback, Handler handler, CameraCharacteristics cameraCharacteristics) {
        this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl$__constructor__(string2, stateCallback, handler, cameraCharacteristics);
    }

    public CameraDeviceImpl(String string2, CameraDevice.StateCallback stateCallback, Handler handler, CameraCharacteristics cameraCharacteristics) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$__constructor__(java.lang.String android.hardware.camera2.CameraDevice$StateCallback android.os.Handler android.hardware.camera2.CameraCharacteristics ), 0, this, string2, stateCallback, handler, cameraCharacteristics);
    }

    public CameraDeviceCallbacks getCallbacks() {
        return InvokeDynamicSupport.bootstrap("getCallbacks", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$getCallbacks(), 0, this);
    }

    public void setRemoteDevice(ICameraDeviceUser iCameraDeviceUser) {
        InvokeDynamicSupport.bootstrap("setRemoteDevice", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$setRemoteDevice(android.hardware.camera2.ICameraDeviceUser ), 0, this, iCameraDeviceUser);
    }

    public void setRemoteFailure(CameraRuntimeException cameraRuntimeException) {
        InvokeDynamicSupport.bootstrap("setRemoteFailure", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$setRemoteFailure(android.hardware.camera2.utils.CameraRuntimeException ), 0, this, cameraRuntimeException);
    }

    @Override
    public String getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$getId(), 0, this);
    }

    public void configureOutputs(List<Surface> list) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("configureOutputs", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$configureOutputs(java.util.List<android.view.Surface> ), 0, this, list);
    }

    public boolean configureOutputsChecked(List<Surface> list) throws CameraAccessException {
        return (boolean)InvokeDynamicSupport.bootstrap("configureOutputsChecked", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$configureOutputsChecked(java.util.List<android.view.Surface> ), 0, this, list);
    }

    @Override
    public void createCaptureSession(List<Surface> list, CameraCaptureSession.StateCallback stateCallback, Handler handler) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("createCaptureSession", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$createCaptureSession(java.util.List<android.view.Surface> android.hardware.camera2.CameraCaptureSession$StateCallback android.os.Handler ), 0, this, list, stateCallback, handler);
    }

    public void setSessionListener(StateCallbackKK stateCallbackKK) {
        InvokeDynamicSupport.bootstrap("setSessionListener", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$setSessionListener(android.hardware.camera2.impl.CameraDeviceImpl$StateCallbackKK ), 0, this, stateCallbackKK);
    }

    @Override
    public CaptureRequest.Builder createCaptureRequest(int n) throws CameraAccessException {
        return InvokeDynamicSupport.bootstrap("createCaptureRequest", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$createCaptureRequest(int ), 0, this, n);
    }

    public int capture(CaptureRequest captureRequest, CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("capture", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$capture(android.hardware.camera2.CaptureRequest android.hardware.camera2.impl.CameraDeviceImpl$CaptureCallback android.os.Handler ), 0, this, captureRequest, captureCallback, handler);
    }

    public int captureBurst(List<CaptureRequest> list, CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("captureBurst", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$captureBurst(java.util.List<android.hardware.camera2.CaptureRequest> android.hardware.camera2.impl.CameraDeviceImpl$CaptureCallback android.os.Handler ), 0, this, list, captureCallback, handler);
    }

    private void checkEarlyTriggerSequenceComplete(int n, long l) {
        InvokeDynamicSupport.bootstrap("checkEarlyTriggerSequenceComplete", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$checkEarlyTriggerSequenceComplete(int long ), 0, this, n, l);
    }

    private int submitCaptureRequest(List<CaptureRequest> list, CaptureCallback captureCallback, Handler handler, boolean bl) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("submitCaptureRequest", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$submitCaptureRequest(java.util.List<android.hardware.camera2.CaptureRequest> android.hardware.camera2.impl.CameraDeviceImpl$CaptureCallback android.os.Handler boolean ), 0, this, list, captureCallback, handler, bl);
    }

    public int setRepeatingRequest(CaptureRequest captureRequest, CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("setRepeatingRequest", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$setRepeatingRequest(android.hardware.camera2.CaptureRequest android.hardware.camera2.impl.CameraDeviceImpl$CaptureCallback android.os.Handler ), 0, this, captureRequest, captureCallback, handler);
    }

    public int setRepeatingBurst(List<CaptureRequest> list, CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("setRepeatingBurst", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$setRepeatingBurst(java.util.List<android.hardware.camera2.CaptureRequest> android.hardware.camera2.impl.CameraDeviceImpl$CaptureCallback android.os.Handler ), 0, this, list, captureCallback, handler);
    }

    public void stopRepeating() throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("stopRepeating", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$stopRepeating(), 0, this);
    }

    private void waitUntilIdle() throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("waitUntilIdle", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$waitUntilIdle(), 0, this);
    }

    public void flush() throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("flush", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$flush(), 0, this);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$close(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$finalize(), 0, this);
    }

    private void checkAndFireSequenceComplete() {
        InvokeDynamicSupport.bootstrap("checkAndFireSequenceComplete", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$checkAndFireSequenceComplete(), 0, this);
    }

    static Handler checkHandler(Handler handler) {
        return InvokeDynamicSupport.bootstrapStatic("checkHandler", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$checkHandler(android.os.Handler ), 0, (Handler)handler);
    }

    static <T> Handler checkHandler(Handler handler, T t) {
        return InvokeDynamicSupport.bootstrapStatic("checkHandler", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$checkHandler(android.os.Handler T ), 0, (Handler)handler, t);
    }

    private void checkIfCameraClosedOrInError() throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("checkIfCameraClosedOrInError", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$checkIfCameraClosedOrInError(), 0, this);
    }

    private boolean isClosed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isClosed", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$isClosed(), 0, this);
    }

    private CameraCharacteristics getCharacteristics() {
        return InvokeDynamicSupport.bootstrap("getCharacteristics", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$getCharacteristics(), 0, this);
    }

    public /* synthetic */ CameraDeviceImpl() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CameraDeviceImpl)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class CameraDeviceCallbacks
    extends ICameraDeviceCallbacks.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int ERROR_CAMERA_DISCONNECTED = 0;
        public static int ERROR_CAMERA_DEVICE = 1;
        public static int ERROR_CAMERA_SERVICE = 2;
        public static int ERROR_CAMERA_REQUEST = 3;
        public static int ERROR_CAMERA_RESULT = 4;
        public static int ERROR_CAMERA_BUFFER = 5;
        /* synthetic */ CameraDeviceImpl this$0;

        private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$__constructor__(CameraDeviceImpl cameraDeviceImpl) {
        }

        private final IBinder $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$asBinder() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onDeviceError(int errorCode, CaptureResultExtras resultExtras) {
            if (this.this$0.DEBUG) {
                Log.d(this.this$0.TAG, String.format("Device error received, code %d, frame number %d, request ID %d, subseq ID %d", errorCode, resultExtras.getFrameNumber(), resultExtras.getRequestId(), resultExtras.getSubsequenceId()));
            }
            Object object = this.this$0.mInterfaceLock;
            synchronized (object) {
                if (this.this$0.mRemoteDevice == null) {
                    return;
                }
                switch (errorCode) {
                    case 0: {
                        this.this$0.mDeviceHandler.post(this.this$0.mCallOnDisconnected);
                        break;
                    }
                    default: {
                        Log.e(this.this$0.TAG, "Unknown error from camera device: " + errorCode);
                    }
                    case 1: 
                    case 2: {
                        this.this$0.mInError = true;
                        Runnable r = new Runnable(this, errorCode){
                            public transient /* synthetic */ Object __robo_data__;
                            /* synthetic */ int val$errorCode;
                            /* synthetic */ CameraDeviceCallbacks this$1;

                            private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_1$__constructor__(CameraDeviceCallbacks cameraDeviceCallbacks, int n) {
                            }

                            private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_1$run() {
                                if (!this.this$1.this$0.isClosed()) {
                                    this.this$1.this$0.mDeviceCallback.onError(this.this$1.this$0, this.val$errorCode);
                                }
                            }

                            private void __constructor__(CameraDeviceCallbacks cameraDeviceCallbacks, int n) {
                                this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_1$__constructor__(cameraDeviceCallbacks, n);
                            }
                            {
                                this.this$1 = cameraDeviceCallbacks;
                                this.val$errorCode = n;
                                this.$$robo$init();
                                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_1$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl$CameraDeviceCallbacks int ), 0, this, cameraDeviceCallbacks, n);
                            }

                            @Override
                            public void run() {
                                InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_1$run(), 0, this);
                            }
                            {
                                this.$$robo$init();
                            }

                            protected /* synthetic */ void $$robo$init() {
                                if (this.__robo_data__ == null) {
                                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                }
                            }

                            public /* synthetic */ Object $$robo$getData() {
                                return this.__robo_data__;
                            }
                        };
                        this.this$0.mDeviceHandler.post(r);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        this.onCaptureErrorLocked(errorCode, resultExtras);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onDeviceIdle() {
            if (this.this$0.DEBUG) {
                Log.d(this.this$0.TAG, "Camera now idle");
            }
            Object object = this.this$0.mInterfaceLock;
            synchronized (object) {
                if (this.this$0.mRemoteDevice == null) {
                    return;
                }
                if (!this.this$0.mIdle) {
                    this.this$0.mDeviceHandler.post(this.this$0.mCallOnIdle);
                }
                this.this$0.mIdle = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onCaptureStarted(CaptureResultExtras resultExtras, long timestamp) {
            int requestId = resultExtras.getRequestId();
            long frameNumber = resultExtras.getFrameNumber();
            if (this.this$0.DEBUG) {
                Log.d(this.this$0.TAG, "Capture started for id " + requestId + " frame number " + frameNumber);
            }
            Object object = this.this$0.mInterfaceLock;
            synchronized (object) {
                if (this.this$0.mRemoteDevice == null) {
                    return;
                }
                CaptureCallbackHolder holder = (CaptureCallbackHolder)this.this$0.mCaptureCallbackMap.get(requestId);
                if (holder == null) {
                    return;
                }
                if (this.this$0.isClosed()) {
                    return;
                }
                holder.getHandler().post(new Runnable(this, holder, resultExtras, timestamp, frameNumber){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ CaptureCallbackHolder val$holder;
                    /* synthetic */ CaptureResultExtras val$resultExtras;
                    /* synthetic */ long val$timestamp;
                    /* synthetic */ long val$frameNumber;
                    /* synthetic */ CameraDeviceCallbacks this$1;

                    private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_2$__constructor__(CameraDeviceCallbacks cameraDeviceCallbacks, CaptureCallbackHolder captureCallbackHolder, CaptureResultExtras captureResultExtras, long l, long l2) {
                    }

                    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_2$run() {
                        if (!this.this$1.this$0.isClosed()) {
                            this.val$holder.getCallback().onCaptureStarted(this.this$1.this$0, this.val$holder.getRequest(this.val$resultExtras.getSubsequenceId()), this.val$timestamp, this.val$frameNumber);
                        }
                    }

                    private void __constructor__(CameraDeviceCallbacks cameraDeviceCallbacks, CaptureCallbackHolder captureCallbackHolder, CaptureResultExtras captureResultExtras, long l, long l2) {
                        this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_2$__constructor__(cameraDeviceCallbacks, captureCallbackHolder, captureResultExtras, l, l2);
                    }
                    {
                        this.this$1 = cameraDeviceCallbacks;
                        this.val$holder = captureCallbackHolder;
                        this.val$resultExtras = captureResultExtras;
                        this.val$timestamp = l;
                        this.val$frameNumber = l2;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_2$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl$CameraDeviceCallbacks android.hardware.camera2.impl.CameraDeviceImpl$CaptureCallbackHolder android.hardware.camera2.impl.CaptureResultExtras long long ), 0, this, cameraDeviceCallbacks, captureCallbackHolder, captureResultExtras, l, l2);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_2$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onResultReceived(CameraMetadataNative result, CaptureResultExtras resultExtras) throws RemoteException {
            int requestId = resultExtras.getRequestId();
            long frameNumber = resultExtras.getFrameNumber();
            if (this.this$0.DEBUG) {
                Log.v(this.this$0.TAG, "Received result frame " + frameNumber + " for id " + requestId);
            }
            Object object = this.this$0.mInterfaceLock;
            synchronized (object) {
                CaptureResult finalResult;
                boolean isPartialResult;
                if (this.this$0.mRemoteDevice == null) {
                    return;
                }
                result.set(CameraCharacteristics.LENS_INFO_SHADING_MAP_SIZE, this.this$0.getCharacteristics().get(CameraCharacteristics.LENS_INFO_SHADING_MAP_SIZE));
                CaptureCallbackHolder holder = (CaptureCallbackHolder)this.this$0.mCaptureCallbackMap.get(requestId);
                boolean bl = isPartialResult = resultExtras.getPartialResultCount() < this.this$0.mTotalPartialCount;
                if (holder == null) {
                    if (this.this$0.DEBUG) {
                        Log.d(this.this$0.TAG, "holder is null, early return at frame " + frameNumber);
                    }
                    this.this$0.mFrameNumberTracker.updateTracker(frameNumber, null, isPartialResult);
                    return;
                }
                if (this.this$0.isClosed()) {
                    if (this.this$0.DEBUG) {
                        Log.d(this.this$0.TAG, "camera is closed, early return at frame " + frameNumber);
                    }
                    this.this$0.mFrameNumberTracker.updateTracker(frameNumber, null, isPartialResult);
                    return;
                }
                CaptureRequest request = holder.getRequest(resultExtras.getSubsequenceId());
                Runnable resultDispatch = null;
                if (isPartialResult) {
                    CaptureResult resultAsCapture = new CaptureResult(result, request, resultExtras);
                    resultDispatch = new Runnable(this, holder, request, resultAsCapture){
                        public transient /* synthetic */ Object __robo_data__;
                        /* synthetic */ CaptureCallbackHolder val$holder;
                        /* synthetic */ CaptureRequest val$request;
                        /* synthetic */ CaptureResult val$resultAsCapture;
                        /* synthetic */ CameraDeviceCallbacks this$1;

                        private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_3$__constructor__(CameraDeviceCallbacks cameraDeviceCallbacks, CaptureCallbackHolder captureCallbackHolder, CaptureRequest captureRequest, CaptureResult captureResult) {
                        }

                        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_3$run() {
                            if (!this.this$1.this$0.isClosed()) {
                                this.val$holder.getCallback().onCaptureProgressed(this.this$1.this$0, this.val$request, this.val$resultAsCapture);
                            }
                        }

                        private void __constructor__(CameraDeviceCallbacks cameraDeviceCallbacks, CaptureCallbackHolder captureCallbackHolder, CaptureRequest captureRequest, CaptureResult captureResult) {
                            this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_3$__constructor__(cameraDeviceCallbacks, captureCallbackHolder, captureRequest, captureResult);
                        }
                        {
                            this.this$1 = cameraDeviceCallbacks;
                            this.val$holder = captureCallbackHolder;
                            this.val$request = captureRequest;
                            this.val$resultAsCapture = captureResult;
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_3$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl$CameraDeviceCallbacks android.hardware.camera2.impl.CameraDeviceImpl$CaptureCallbackHolder android.hardware.camera2.CaptureRequest android.hardware.camera2.CaptureResult ), 0, this, cameraDeviceCallbacks, captureCallbackHolder, captureRequest, captureResult);
                        }

                        @Override
                        public void run() {
                            InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_3$run(), 0, this);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    };
                    finalResult = resultAsCapture;
                } else {
                    List<CaptureResult> partialResults = this.this$0.mFrameNumberTracker.popPartialResults(frameNumber);
                    TotalCaptureResult resultAsCapture = new TotalCaptureResult(result, request, resultExtras, partialResults);
                    resultDispatch = new Runnable(this, holder, request, resultAsCapture){
                        public transient /* synthetic */ Object __robo_data__;
                        /* synthetic */ CaptureCallbackHolder val$holder;
                        /* synthetic */ CaptureRequest val$request;
                        /* synthetic */ TotalCaptureResult val$resultAsCapture;
                        /* synthetic */ CameraDeviceCallbacks this$1;

                        private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_4$__constructor__(CameraDeviceCallbacks cameraDeviceCallbacks, CaptureCallbackHolder captureCallbackHolder, CaptureRequest captureRequest, TotalCaptureResult totalCaptureResult) {
                        }

                        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_4$run() {
                            if (!this.this$1.this$0.isClosed()) {
                                this.val$holder.getCallback().onCaptureCompleted(this.this$1.this$0, this.val$request, this.val$resultAsCapture);
                            }
                        }

                        private void __constructor__(CameraDeviceCallbacks cameraDeviceCallbacks, CaptureCallbackHolder captureCallbackHolder, CaptureRequest captureRequest, TotalCaptureResult totalCaptureResult) {
                            this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_4$__constructor__(cameraDeviceCallbacks, captureCallbackHolder, captureRequest, totalCaptureResult);
                        }
                        {
                            this.this$1 = cameraDeviceCallbacks;
                            this.val$holder = captureCallbackHolder;
                            this.val$request = captureRequest;
                            this.val$resultAsCapture = totalCaptureResult;
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_4$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl$CameraDeviceCallbacks android.hardware.camera2.impl.CameraDeviceImpl$CaptureCallbackHolder android.hardware.camera2.CaptureRequest android.hardware.camera2.TotalCaptureResult ), 0, this, cameraDeviceCallbacks, captureCallbackHolder, captureRequest, totalCaptureResult);
                        }

                        @Override
                        public void run() {
                            InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_4$run(), 0, this);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    };
                    finalResult = resultAsCapture;
                }
                holder.getHandler().post(resultDispatch);
                this.this$0.mFrameNumberTracker.updateTracker(frameNumber, finalResult, isPartialResult);
                if (!isPartialResult) {
                    this.this$0.checkAndFireSequenceComplete();
                }
            }
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onCaptureErrorLocked(int errorCode, CaptureResultExtras resultExtras) {
            int requestId = resultExtras.getRequestId();
            int subsequenceId = resultExtras.getSubsequenceId();
            long frameNumber = resultExtras.getFrameNumber();
            CaptureCallbackHolder holder = (CaptureCallbackHolder)this.this$0.mCaptureCallbackMap.get(requestId);
            CaptureRequest request = holder.getRequest(subsequenceId);
            if (errorCode == 5) {
                Log.e(this.this$0.TAG, String.format("Lost output buffer reported for frame %d", frameNumber));
                return;
            }
            boolean mayHaveBuffers = errorCode == 4;
            int reason = this.this$0.mCurrentSession != null && this.this$0.mCurrentSession.isAborting() ? 1 : 0;
            CaptureFailure failure = new CaptureFailure(request, reason, mayHaveBuffers, requestId, frameNumber);
            Runnable failureDispatch = new Runnable(this, holder, request, failure){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ CaptureCallbackHolder val$holder;
                /* synthetic */ CaptureRequest val$request;
                /* synthetic */ CaptureFailure val$failure;
                /* synthetic */ CameraDeviceCallbacks this$1;

                private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_5$__constructor__(CameraDeviceCallbacks cameraDeviceCallbacks, CaptureCallbackHolder captureCallbackHolder, CaptureRequest captureRequest, CaptureFailure captureFailure) {
                }

                private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_5$run() {
                    if (!this.this$1.this$0.isClosed()) {
                        this.val$holder.getCallback().onCaptureFailed(this.this$1.this$0, this.val$request, this.val$failure);
                    }
                }

                private void __constructor__(CameraDeviceCallbacks cameraDeviceCallbacks, CaptureCallbackHolder captureCallbackHolder, CaptureRequest captureRequest, CaptureFailure captureFailure) {
                    this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_5$__constructor__(cameraDeviceCallbacks, captureCallbackHolder, captureRequest, captureFailure);
                }
                {
                    this.this$1 = cameraDeviceCallbacks;
                    this.val$holder = captureCallbackHolder;
                    this.val$request = captureRequest;
                    this.val$failure = captureFailure;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_5$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl$CameraDeviceCallbacks android.hardware.camera2.impl.CameraDeviceImpl$CaptureCallbackHolder android.hardware.camera2.CaptureRequest android.hardware.camera2.CaptureFailure ), 0, this, cameraDeviceCallbacks, captureCallbackHolder, captureRequest, captureFailure);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_5$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            holder.getHandler().post(failureDispatch);
            if (this.this$0.DEBUG) {
                Log.v(this.this$0.TAG, String.format("got error frame %d", frameNumber));
            }
            this.this$0.mFrameNumberTracker.updateTracker(frameNumber, true);
            this.this$0.checkAndFireSequenceComplete();
        }

        private void __constructor__(CameraDeviceImpl cameraDeviceImpl) {
            this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$__constructor__(cameraDeviceImpl);
        }

        public CameraDeviceCallbacks(CameraDeviceImpl cameraDeviceImpl) {
            this.this$0 = cameraDeviceImpl;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl ), 0, this, cameraDeviceImpl);
        }

        @Override
        public IBinder asBinder() {
            return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$asBinder(), 0, this);
        }

        @Override
        public void onDeviceError(int n, CaptureResultExtras captureResultExtras) {
            InvokeDynamicSupport.bootstrap("onDeviceError", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onDeviceError(int android.hardware.camera2.impl.CaptureResultExtras ), 0, this, n, captureResultExtras);
        }

        @Override
        public void onDeviceIdle() {
            InvokeDynamicSupport.bootstrap("onDeviceIdle", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onDeviceIdle(), 0, this);
        }

        @Override
        public void onCaptureStarted(CaptureResultExtras captureResultExtras, long l) {
            InvokeDynamicSupport.bootstrap("onCaptureStarted", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onCaptureStarted(android.hardware.camera2.impl.CaptureResultExtras long ), 0, this, captureResultExtras, l);
        }

        @Override
        public void onResultReceived(CameraMetadataNative cameraMetadataNative, CaptureResultExtras captureResultExtras) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onResultReceived", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onResultReceived(android.hardware.camera2.impl.CameraMetadataNative android.hardware.camera2.impl.CaptureResultExtras ), 0, this, cameraMetadataNative, captureResultExtras);
        }

        private void onCaptureErrorLocked(int n, CaptureResultExtras captureResultExtras) {
            InvokeDynamicSupport.bootstrap("onCaptureErrorLocked", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onCaptureErrorLocked(int android.hardware.camera2.impl.CaptureResultExtras ), 0, this, n, captureResultExtras);
        }

        public /* synthetic */ CameraDeviceCallbacks() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CameraDeviceCallbacks)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class FrameNumberTracker
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private long mCompletedFrameNumber;
        private TreeSet<Long> mFutureErrorSet;
        private HashMap<Long, List<CaptureResult>> mPartialResults;
        /* synthetic */ CameraDeviceImpl this$0;

        private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$__constructor__(CameraDeviceImpl cameraDeviceImpl) {
            this.mCompletedFrameNumber = -1L;
            this.mFutureErrorSet = new TreeSet();
            this.mPartialResults = new HashMap();
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$update() {
            long errorFrameNumber;
            Iterator<Long> iter = this.mFutureErrorSet.iterator();
            while (iter.hasNext() && (errorFrameNumber = iter.next().longValue()) == this.mCompletedFrameNumber + 1L) {
                ++this.mCompletedFrameNumber;
                iter.remove();
            }
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$updateTracker(long frameNumber, boolean isError) {
            if (isError) {
                this.mFutureErrorSet.add(frameNumber);
            } else {
                if (frameNumber != this.mCompletedFrameNumber + 1L) {
                    Log.e(this.this$0.TAG, String.format("result frame number %d comes out of order, should be %d + 1", frameNumber, this.mCompletedFrameNumber));
                }
                this.mCompletedFrameNumber = frameNumber;
            }
            this.update();
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$updateTracker(long frameNumber, CaptureResult result, boolean partial) {
            if (!partial) {
                this.updateTracker(frameNumber, false);
                return;
            }
            if (result == null) {
                return;
            }
            List<CaptureResult> partials = this.mPartialResults.get(frameNumber);
            if (partials == null) {
                partials = new ArrayList<CaptureResult>();
                this.mPartialResults.put(frameNumber, partials);
            }
            partials.add(result);
        }

        private final List<CaptureResult> $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$popPartialResults(long frameNumber) {
            return this.mPartialResults.remove(frameNumber);
        }

        private final long $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$getCompletedFrameNumber() {
            return this.mCompletedFrameNumber;
        }

        private void __constructor__(CameraDeviceImpl cameraDeviceImpl) {
            this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$__constructor__(cameraDeviceImpl);
        }

        public FrameNumberTracker(CameraDeviceImpl cameraDeviceImpl) {
            this.this$0 = cameraDeviceImpl;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl ), 0, this, cameraDeviceImpl);
        }

        private void update() {
            InvokeDynamicSupport.bootstrap("update", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$update(), 0, this);
        }

        public void updateTracker(long l, boolean bl) {
            InvokeDynamicSupport.bootstrap("updateTracker", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$updateTracker(long boolean ), 0, this, l, bl);
        }

        public void updateTracker(long l, CaptureResult captureResult, boolean bl) {
            InvokeDynamicSupport.bootstrap("updateTracker", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$updateTracker(long android.hardware.camera2.CaptureResult boolean ), 0, this, l, captureResult, bl);
        }

        public List<CaptureResult> popPartialResults(long l) {
            return InvokeDynamicSupport.bootstrap("popPartialResults", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$popPartialResults(long ), 0, this, l);
        }

        public long getCompletedFrameNumber() {
            return (long)InvokeDynamicSupport.bootstrap("getCompletedFrameNumber", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$getCompletedFrameNumber(), 0, this);
        }

        public /* synthetic */ FrameNumberTracker() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FrameNumberTracker)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CaptureCallbackHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private boolean mRepeating;
        private CaptureCallback mCallback;
        private List<CaptureRequest> mRequestList;
        private Handler mHandler;

        private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$__constructor__(CaptureCallback callback, List<CaptureRequest> requestList, Handler handler, boolean repeating) {
            if (callback == null || handler == null) {
                throw new UnsupportedOperationException("Must have a valid handler and a valid callback");
            }
            this.mRepeating = repeating;
            this.mHandler = handler;
            this.mRequestList = new ArrayList<CaptureRequest>(requestList);
            this.mCallback = callback;
        }

        private final boolean $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$isRepeating() {
            return this.mRepeating;
        }

        private final CaptureCallback $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$getCallback() {
            return this.mCallback;
        }

        private final CaptureRequest $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$getRequest(int subsequenceId) {
            if (subsequenceId >= this.mRequestList.size()) {
                throw new IllegalArgumentException(String.format("Requested subsequenceId %d is larger than request list size %d.", subsequenceId, this.mRequestList.size()));
            }
            if (subsequenceId < 0) {
                throw new IllegalArgumentException(String.format("Requested subsequenceId %d is negative", subsequenceId));
            }
            return this.mRequestList.get(subsequenceId);
        }

        private final CaptureRequest $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$getRequest() {
            return this.getRequest(0);
        }

        private final Handler $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$getHandler() {
            return this.mHandler;
        }

        private void __constructor__(CaptureCallback captureCallback, List<CaptureRequest> list, Handler handler, boolean bl) {
            this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$__constructor__(captureCallback, list, handler, bl);
        }

        CaptureCallbackHolder(CaptureCallback captureCallback, List<CaptureRequest> list, Handler handler, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl$CaptureCallback java.util.List<android.hardware.camera2.CaptureRequest> android.os.Handler boolean ), 0, this, captureCallback, list, handler, bl);
        }

        public boolean isRepeating() {
            return (boolean)InvokeDynamicSupport.bootstrap("isRepeating", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$isRepeating(), 0, this);
        }

        public CaptureCallback getCallback() {
            return InvokeDynamicSupport.bootstrap("getCallback", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$getCallback(), 0, this);
        }

        public CaptureRequest getRequest(int n) {
            return InvokeDynamicSupport.bootstrap("getRequest", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$getRequest(int ), 0, this, n);
        }

        public CaptureRequest getRequest() {
            return InvokeDynamicSupport.bootstrap("getRequest", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$getRequest(), 0, this);
        }

        public Handler getHandler() {
            return InvokeDynamicSupport.bootstrap("getHandler", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$getHandler(), 0, this);
        }

        public /* synthetic */ CaptureCallbackHolder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CaptureCallbackHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class StateCallbackKK
    extends CameraDevice.StateCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$__constructor__() {
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$onUnconfigured(CameraDevice camera) {
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$onActive(CameraDevice camera) {
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$onBusy(CameraDevice camera) {
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$onIdle(CameraDevice camera) {
        }

        private void __constructor__() {
            this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$__constructor__();
        }

        public StateCallbackKK() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$__constructor__(), 0, this);
        }

        public void onUnconfigured(CameraDevice cameraDevice) {
            InvokeDynamicSupport.bootstrap("onUnconfigured", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$onUnconfigured(android.hardware.camera2.CameraDevice ), 0, this, cameraDevice);
        }

        public void onActive(CameraDevice cameraDevice) {
            InvokeDynamicSupport.bootstrap("onActive", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$onActive(android.hardware.camera2.CameraDevice ), 0, this, cameraDevice);
        }

        public void onBusy(CameraDevice cameraDevice) {
            InvokeDynamicSupport.bootstrap("onBusy", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$onBusy(android.hardware.camera2.CameraDevice ), 0, this, cameraDevice);
        }

        public void onIdle(CameraDevice cameraDevice) {
            InvokeDynamicSupport.bootstrap("onIdle", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$onIdle(android.hardware.camera2.CameraDevice ), 0, this, cameraDevice);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StateCallbackKK)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class CaptureCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int NO_FRAMES_CAPTURED = -1;

        private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallback$__constructor__() {
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallback$onCaptureStarted(CameraDevice camera, CaptureRequest request, long timestamp, long frameNumber) {
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallback$onCapturePartial(CameraDevice camera, CaptureRequest request, CaptureResult result) {
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallback$onCaptureProgressed(CameraDevice camera, CaptureRequest request, CaptureResult partialResult) {
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallback$onCaptureCompleted(CameraDevice camera, CaptureRequest request, TotalCaptureResult result) {
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallback$onCaptureFailed(CameraDevice camera, CaptureRequest request, CaptureFailure failure) {
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallback$onCaptureSequenceCompleted(CameraDevice camera, int sequenceId, long frameNumber) {
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallback$onCaptureSequenceAborted(CameraDevice camera, int sequenceId) {
        }

        private void __constructor__() {
            this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallback$__constructor__();
        }

        public CaptureCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallback$__constructor__(), 0, this);
        }

        public void onCaptureStarted(CameraDevice cameraDevice, CaptureRequest captureRequest, long l, long l2) {
            InvokeDynamicSupport.bootstrap("onCaptureStarted", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallback$onCaptureStarted(android.hardware.camera2.CameraDevice android.hardware.camera2.CaptureRequest long long ), 0, this, cameraDevice, captureRequest, l, l2);
        }

        public void onCapturePartial(CameraDevice cameraDevice, CaptureRequest captureRequest, CaptureResult captureResult) {
            InvokeDynamicSupport.bootstrap("onCapturePartial", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallback$onCapturePartial(android.hardware.camera2.CameraDevice android.hardware.camera2.CaptureRequest android.hardware.camera2.CaptureResult ), 0, this, cameraDevice, captureRequest, captureResult);
        }

        public void onCaptureProgressed(CameraDevice cameraDevice, CaptureRequest captureRequest, CaptureResult captureResult) {
            InvokeDynamicSupport.bootstrap("onCaptureProgressed", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallback$onCaptureProgressed(android.hardware.camera2.CameraDevice android.hardware.camera2.CaptureRequest android.hardware.camera2.CaptureResult ), 0, this, cameraDevice, captureRequest, captureResult);
        }

        public void onCaptureCompleted(CameraDevice cameraDevice, CaptureRequest captureRequest, TotalCaptureResult totalCaptureResult) {
            InvokeDynamicSupport.bootstrap("onCaptureCompleted", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallback$onCaptureCompleted(android.hardware.camera2.CameraDevice android.hardware.camera2.CaptureRequest android.hardware.camera2.TotalCaptureResult ), 0, this, cameraDevice, captureRequest, totalCaptureResult);
        }

        public void onCaptureFailed(CameraDevice cameraDevice, CaptureRequest captureRequest, CaptureFailure captureFailure) {
            InvokeDynamicSupport.bootstrap("onCaptureFailed", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallback$onCaptureFailed(android.hardware.camera2.CameraDevice android.hardware.camera2.CaptureRequest android.hardware.camera2.CaptureFailure ), 0, this, cameraDevice, captureRequest, captureFailure);
        }

        public void onCaptureSequenceCompleted(CameraDevice cameraDevice, int n, long l) {
            InvokeDynamicSupport.bootstrap("onCaptureSequenceCompleted", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallback$onCaptureSequenceCompleted(android.hardware.camera2.CameraDevice int long ), 0, this, cameraDevice, n, l);
        }

        public void onCaptureSequenceAborted(CameraDevice cameraDevice, int n) {
            InvokeDynamicSupport.bootstrap("onCaptureSequenceAborted", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallback$onCaptureSequenceAborted(android.hardware.camera2.CameraDevice int ), 0, this, cameraDevice, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CaptureCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

