/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.hardware.Camera;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.ICameraDeviceCallbacks;
import android.hardware.camera2.ICameraDeviceUser;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.impl.CaptureResultExtras;
import android.hardware.camera2.legacy.LegacyCameraDevice;
import android.hardware.camera2.legacy.LegacyMetadataMapper;
import android.hardware.camera2.utils.CameraBinderDecorator;
import android.hardware.camera2.utils.CameraRuntimeException;
import android.hardware.camera2.utils.LongParcelable;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import android.view.Surface;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CameraDeviceUserShim
implements ICameraDeviceUser,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "CameraDeviceUserShim";
    private static boolean DEBUG;
    private static int OPEN_CAMERA_TIMEOUT_MS = 5000;
    private LegacyCameraDevice mLegacyDevice;
    private Object mConfigureLock;
    private int mSurfaceIdCounter;
    private boolean mConfiguring;
    private SparseArray<Surface> mSurfaces;
    private CameraCharacteristics mCameraCharacteristics;
    private CameraLooper mCameraInit;
    private CameraCallbackThread mCameraCallbacks;

    private void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$__constructor__(int cameraId, LegacyCameraDevice legacyCamera, CameraCharacteristics characteristics, CameraLooper cameraInit, CameraCallbackThread cameraCallbacks) {
        this.mConfigureLock = new Object();
        this.mLegacyDevice = legacyCamera;
        this.mConfiguring = false;
        this.mSurfaces = new SparseArray();
        this.mCameraCharacteristics = characteristics;
        this.mCameraInit = cameraInit;
        this.mCameraCallbacks = cameraCallbacks;
        this.mSurfaceIdCounter = 0;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$translateErrorsFromCamera1(int errorCode) {
        switch (errorCode) {
            case -13: {
                return -1;
            }
        }
        return errorCode;
    }

    private static final CameraDeviceUserShim $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$connectBinderShim(ICameraDeviceCallbacks callbacks, int cameraId) {
        if (DEBUG) {
            Log.d("CameraDeviceUserShim", "Opening shim Camera device");
        }
        CameraLooper init = new CameraLooper(cameraId);
        CameraCallbackThread threadCallbacks = new CameraCallbackThread(callbacks);
        int initErrors = init.waitForOpen(5000);
        Camera legacyCamera = init.getCamera();
        CameraBinderDecorator.throwOnError(initErrors);
        legacyCamera.disableShutterSound();
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo(cameraId, info);
        Camera.Parameters legacyParameters = null;
        try {
            legacyParameters = legacyCamera.getParameters();
        }
        catch (RuntimeException e) {
            throw new CameraRuntimeException(3, "Unable to get initial parameters", e);
        }
        CameraCharacteristics characteristics = LegacyMetadataMapper.createCharacteristics(legacyParameters, info);
        LegacyCameraDevice device = new LegacyCameraDevice(cameraId, legacyCamera, characteristics, threadCallbacks);
        return new CameraDeviceUserShim(cameraId, device, characteristics, init, threadCallbacks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$disconnect() {
        if (DEBUG) {
            Log.d("CameraDeviceUserShim", "disconnect called.");
        }
        if (this.mLegacyDevice.isClosed()) {
            Log.w("CameraDeviceUserShim", "Cannot disconnect, device has already been closed.");
        }
        try {
            this.mLegacyDevice.close();
        }
        finally {
            this.mCameraInit.close();
            this.mCameraCallbacks.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$submitRequest(CaptureRequest request, boolean streaming, LongParcelable lastFrameNumber) {
        if (DEBUG) {
            Log.d("CameraDeviceUserShim", "submitRequest called.");
        }
        if (this.mLegacyDevice.isClosed()) {
            Log.e("CameraDeviceUserShim", "Cannot submit request, device has been closed.");
            return -19;
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (this.mConfiguring) {
                Log.e("CameraDeviceUserShim", "Cannot submit request, configuration change in progress.");
                return -38;
            }
        }
        return this.mLegacyDevice.submitRequest(request, streaming, lastFrameNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$submitRequestList(List<CaptureRequest> request, boolean streaming, LongParcelable lastFrameNumber) {
        if (DEBUG) {
            Log.d("CameraDeviceUserShim", "submitRequestList called.");
        }
        if (this.mLegacyDevice.isClosed()) {
            Log.e("CameraDeviceUserShim", "Cannot submit request list, device has been closed.");
            return -19;
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (this.mConfiguring) {
                Log.e("CameraDeviceUserShim", "Cannot submit request, configuration change in progress.");
                return -38;
            }
        }
        return this.mLegacyDevice.submitRequestList(request, streaming, lastFrameNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$cancelRequest(int requestId, LongParcelable lastFrameNumber) {
        if (DEBUG) {
            Log.d("CameraDeviceUserShim", "cancelRequest called.");
        }
        if (this.mLegacyDevice.isClosed()) {
            Log.e("CameraDeviceUserShim", "Cannot cancel request, device has been closed.");
            return -19;
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (this.mConfiguring) {
                Log.e("CameraDeviceUserShim", "Cannot cancel request, configuration change in progress.");
                return -38;
            }
        }
        long lastFrame = this.mLegacyDevice.cancelRequest(requestId);
        lastFrameNumber.setNumber(lastFrame);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$beginConfigure() {
        if (DEBUG) {
            Log.d("CameraDeviceUserShim", "beginConfigure called.");
        }
        if (this.mLegacyDevice.isClosed()) {
            Log.e("CameraDeviceUserShim", "Cannot begin configure, device has been closed.");
            return -19;
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (this.mConfiguring) {
                Log.e("CameraDeviceUserShim", "Cannot begin configure, configuration change already in progress.");
                return -38;
            }
            this.mConfiguring = true;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$endConfigure() {
        if (DEBUG) {
            Log.d("CameraDeviceUserShim", "endConfigure called.");
        }
        if (this.mLegacyDevice.isClosed()) {
            Log.e("CameraDeviceUserShim", "Cannot end configure, device has been closed.");
            return -19;
        }
        ArrayList<Surface> surfaces = null;
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (!this.mConfiguring) {
                Log.e("CameraDeviceUserShim", "Cannot end configure, no configuration change in progress.");
                return -38;
            }
            int numSurfaces = this.mSurfaces.size();
            if (numSurfaces > 0) {
                surfaces = new ArrayList<Surface>();
                for (int i = 0; i < numSurfaces; ++i) {
                    surfaces.add(this.mSurfaces.valueAt(i));
                }
            }
            this.mConfiguring = false;
        }
        return this.mLegacyDevice.configureOutputs(surfaces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$deleteStream(int streamId) {
        if (DEBUG) {
            Log.d("CameraDeviceUserShim", "deleteStream called.");
        }
        if (this.mLegacyDevice.isClosed()) {
            Log.e("CameraDeviceUserShim", "Cannot delete stream, device has been closed.");
            return -19;
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (!this.mConfiguring) {
                Log.e("CameraDeviceUserShim", "Cannot delete stream, beginConfigure hasn't been called yet.");
                return -38;
            }
            int index = this.mSurfaces.indexOfKey(streamId);
            if (index < 0) {
                Log.e("CameraDeviceUserShim", "Cannot delete stream, stream id " + streamId + " doesn't exist.");
                return -22;
            }
            this.mSurfaces.removeAt(index);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$createStream(int width, int height, int format, Surface surface) {
        if (DEBUG) {
            Log.d("CameraDeviceUserShim", "createStream called.");
        }
        if (this.mLegacyDevice.isClosed()) {
            Log.e("CameraDeviceUserShim", "Cannot create stream, device has been closed.");
            return -19;
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (!this.mConfiguring) {
                Log.e("CameraDeviceUserShim", "Cannot create stream, beginConfigure hasn't been called yet.");
                return -38;
            }
            int id2 = ++this.mSurfaceIdCounter;
            this.mSurfaces.put(id2, surface);
            return id2;
        }
    }

    private final int $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$createDefaultRequest(int templateId, CameraMetadataNative request) {
        CameraMetadataNative template;
        if (DEBUG) {
            Log.d("CameraDeviceUserShim", "createDefaultRequest called.");
        }
        if (this.mLegacyDevice.isClosed()) {
            Log.e("CameraDeviceUserShim", "Cannot create default request, device has been closed.");
            return -19;
        }
        try {
            template = LegacyMetadataMapper.createRequestTemplate(this.mCameraCharacteristics, templateId);
        }
        catch (IllegalArgumentException e) {
            Log.e("CameraDeviceUserShim", "createDefaultRequest - invalid templateId specified");
            return -22;
        }
        request.swap(template);
        return 0;
    }

    private final int $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$getCameraInfo(CameraMetadataNative info) {
        if (DEBUG) {
            Log.d("CameraDeviceUserShim", "getCameraInfo called.");
        }
        Log.e("CameraDeviceUserShim", "getCameraInfo unimplemented.");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$waitUntilIdle() throws RemoteException {
        if (DEBUG) {
            Log.d("CameraDeviceUserShim", "waitUntilIdle called.");
        }
        if (this.mLegacyDevice.isClosed()) {
            Log.e("CameraDeviceUserShim", "Cannot wait until idle, device has been closed.");
            return -19;
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (this.mConfiguring) {
                Log.e("CameraDeviceUserShim", "Cannot wait until idle, configuration change in progress.");
                return -38;
            }
        }
        this.mLegacyDevice.waitUntilIdle();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$flush(LongParcelable lastFrameNumber) {
        if (DEBUG) {
            Log.d("CameraDeviceUserShim", "flush called.");
        }
        if (this.mLegacyDevice.isClosed()) {
            Log.e("CameraDeviceUserShim", "Cannot flush, device has been closed.");
            return -19;
        }
        Object object = this.mConfigureLock;
        synchronized (object) {
            if (this.mConfiguring) {
                Log.e("CameraDeviceUserShim", "Cannot flush, configuration change in progress.");
                return -38;
            }
        }
        long lastFrame = this.mLegacyDevice.flush();
        if (lastFrameNumber != null) {
            lastFrameNumber.setNumber(lastFrame);
        }
        return 0;
    }

    private final IBinder $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$asBinder() {
        return null;
    }

    static void __staticInitializer__() {
        DEBUG = Log.isLoggable("HAL1ShimLogging", 3);
    }

    private void __constructor__(int n, LegacyCameraDevice legacyCameraDevice, CameraCharacteristics cameraCharacteristics, CameraLooper cameraLooper, CameraCallbackThread cameraCallbackThread) {
        this.$$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$__constructor__(n, legacyCameraDevice, cameraCharacteristics, cameraLooper, cameraCallbackThread);
    }

    protected CameraDeviceUserShim(int n, LegacyCameraDevice legacyCameraDevice, CameraCharacteristics cameraCharacteristics, CameraLooper cameraLooper, CameraCallbackThread cameraCallbackThread) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$__constructor__(int android.hardware.camera2.legacy.LegacyCameraDevice android.hardware.camera2.CameraCharacteristics android.hardware.camera2.legacy.CameraDeviceUserShim$CameraLooper android.hardware.camera2.legacy.CameraDeviceUserShim$CameraCallbackThread ), 0, this, n, legacyCameraDevice, cameraCharacteristics, cameraLooper, cameraCallbackThread);
    }

    private static int translateErrorsFromCamera1(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("translateErrorsFromCamera1", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$translateErrorsFromCamera1(int ), 0, (int)n);
    }

    public static CameraDeviceUserShim connectBinderShim(ICameraDeviceCallbacks iCameraDeviceCallbacks, int n) {
        return InvokeDynamicSupport.bootstrapStatic("connectBinderShim", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$connectBinderShim(android.hardware.camera2.ICameraDeviceCallbacks int ), 0, (ICameraDeviceCallbacks)iCameraDeviceCallbacks, (int)n);
    }

    @Override
    public void disconnect() {
        InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$disconnect(), 0, this);
    }

    @Override
    public int submitRequest(CaptureRequest captureRequest, boolean bl, LongParcelable longParcelable) {
        return (int)InvokeDynamicSupport.bootstrap("submitRequest", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$submitRequest(android.hardware.camera2.CaptureRequest boolean android.hardware.camera2.utils.LongParcelable ), 0, this, captureRequest, bl, longParcelable);
    }

    @Override
    public int submitRequestList(List<CaptureRequest> list, boolean bl, LongParcelable longParcelable) {
        return (int)InvokeDynamicSupport.bootstrap("submitRequestList", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$submitRequestList(java.util.List<android.hardware.camera2.CaptureRequest> boolean android.hardware.camera2.utils.LongParcelable ), 0, this, list, bl, longParcelable);
    }

    @Override
    public int cancelRequest(int n, LongParcelable longParcelable) {
        return (int)InvokeDynamicSupport.bootstrap("cancelRequest", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$cancelRequest(int android.hardware.camera2.utils.LongParcelable ), 0, this, n, longParcelable);
    }

    @Override
    public int beginConfigure() {
        return (int)InvokeDynamicSupport.bootstrap("beginConfigure", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$beginConfigure(), 0, this);
    }

    @Override
    public int endConfigure() {
        return (int)InvokeDynamicSupport.bootstrap("endConfigure", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$endConfigure(), 0, this);
    }

    @Override
    public int deleteStream(int n) {
        return (int)InvokeDynamicSupport.bootstrap("deleteStream", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$deleteStream(int ), 0, this, n);
    }

    @Override
    public int createStream(int n, int n2, int n3, Surface surface) {
        return (int)InvokeDynamicSupport.bootstrap("createStream", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$createStream(int int int android.view.Surface ), 0, this, n, n2, n3, surface);
    }

    @Override
    public int createDefaultRequest(int n, CameraMetadataNative cameraMetadataNative) {
        return (int)InvokeDynamicSupport.bootstrap("createDefaultRequest", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$createDefaultRequest(int android.hardware.camera2.impl.CameraMetadataNative ), 0, this, n, cameraMetadataNative);
    }

    @Override
    public int getCameraInfo(CameraMetadataNative cameraMetadataNative) {
        return (int)InvokeDynamicSupport.bootstrap("getCameraInfo", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$getCameraInfo(android.hardware.camera2.impl.CameraMetadataNative ), 0, this, cameraMetadataNative);
    }

    @Override
    public int waitUntilIdle() throws RemoteException {
        return (int)InvokeDynamicSupport.bootstrap("waitUntilIdle", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$waitUntilIdle(), 0, this);
    }

    @Override
    public int flush(LongParcelable longParcelable) {
        return (int)InvokeDynamicSupport.bootstrap("flush", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$flush(android.hardware.camera2.utils.LongParcelable ), 0, this, longParcelable);
    }

    @Override
    public IBinder asBinder() {
        return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim$asBinder(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(CameraDeviceUserShim.class);
    }

    public /* synthetic */ CameraDeviceUserShim() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CameraDeviceUserShim)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class CameraCallbackThread
    implements ICameraDeviceCallbacks,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int CAMERA_ERROR = 0;
        private static int CAMERA_IDLE = 1;
        private static int CAPTURE_STARTED = 2;
        private static int RESULT_RECEIVED = 3;
        private HandlerThread mHandlerThread;
        private Handler mHandler;
        private ICameraDeviceCallbacks mCallbacks;

        private void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$__constructor__(ICameraDeviceCallbacks callbacks) {
            this.mCallbacks = callbacks;
            this.mHandlerThread = new HandlerThread("LegacyCameraCallback");
            this.mHandlerThread.start();
        }

        private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$close() {
            this.mHandlerThread.quitSafely();
        }

        private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$onDeviceError(int errorCode, CaptureResultExtras resultExtras) {
            Message msg = this.getHandler().obtainMessage(0, errorCode, 0, resultExtras);
            this.getHandler().sendMessage(msg);
        }

        private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$onDeviceIdle() {
            Message msg = this.getHandler().obtainMessage(1);
            this.getHandler().sendMessage(msg);
        }

        private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$onCaptureStarted(CaptureResultExtras resultExtras, long timestamp) {
            Message msg = this.getHandler().obtainMessage(2, (int)(timestamp & 0xFFFFFFFFL), (int)(timestamp >> 32 & 0xFFFFFFFFL), resultExtras);
            this.getHandler().sendMessage(msg);
        }

        private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$onResultReceived(CameraMetadataNative result, CaptureResultExtras resultExtras) {
            Object[] resultArray = new Object[]{result, resultExtras};
            Message msg = this.getHandler().obtainMessage(3, resultArray);
            this.getHandler().sendMessage(msg);
        }

        private final IBinder $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$asBinder() {
            return null;
        }

        private final Handler $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$getHandler() {
            if (this.mHandler == null) {
                this.mHandler = new CallbackHandler(this, this.mHandlerThread.getLooper());
            }
            return this.mHandler;
        }

        private void __constructor__(ICameraDeviceCallbacks iCameraDeviceCallbacks) {
            this.$$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$__constructor__(iCameraDeviceCallbacks);
        }

        public CameraCallbackThread(ICameraDeviceCallbacks iCameraDeviceCallbacks) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$__constructor__(android.hardware.camera2.ICameraDeviceCallbacks ), 0, this, iCameraDeviceCallbacks);
        }

        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$close(), 0, this);
        }

        @Override
        public void onDeviceError(int n, CaptureResultExtras captureResultExtras) {
            InvokeDynamicSupport.bootstrap("onDeviceError", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$onDeviceError(int android.hardware.camera2.impl.CaptureResultExtras ), 0, this, n, captureResultExtras);
        }

        @Override
        public void onDeviceIdle() {
            InvokeDynamicSupport.bootstrap("onDeviceIdle", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$onDeviceIdle(), 0, this);
        }

        @Override
        public void onCaptureStarted(CaptureResultExtras captureResultExtras, long l) {
            InvokeDynamicSupport.bootstrap("onCaptureStarted", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$onCaptureStarted(android.hardware.camera2.impl.CaptureResultExtras long ), 0, this, captureResultExtras, l);
        }

        @Override
        public void onResultReceived(CameraMetadataNative cameraMetadataNative, CaptureResultExtras captureResultExtras) {
            InvokeDynamicSupport.bootstrap("onResultReceived", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$onResultReceived(android.hardware.camera2.impl.CameraMetadataNative android.hardware.camera2.impl.CaptureResultExtras ), 0, this, cameraMetadataNative, captureResultExtras);
        }

        @Override
        public IBinder asBinder() {
            return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$asBinder(), 0, this);
        }

        private Handler getHandler() {
            return InvokeDynamicSupport.bootstrap("getHandler", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread$getHandler(), 0, this);
        }

        public /* synthetic */ CameraCallbackThread() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CameraCallbackThread)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private class CallbackHandler
        extends Handler
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CameraCallbackThread this$0;

            private void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread_CallbackHandler$__constructor__(CameraCallbackThread cameraCallbackThread, Looper l) {
            }

            private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread_CallbackHandler$handleMessage(Message msg) {
                try {
                    switch (msg.what) {
                        case 0: {
                            int errorCode = msg.arg1;
                            CaptureResultExtras resultExtras = (CaptureResultExtras)msg.obj;
                            this.this$0.mCallbacks.onDeviceError(errorCode, resultExtras);
                            break;
                        }
                        case 1: {
                            this.this$0.mCallbacks.onDeviceIdle();
                            break;
                        }
                        case 2: {
                            long timestamp = (long)msg.arg2 & 0xFFFFFFFFL;
                            timestamp = timestamp << 32 | (long)msg.arg1 & 0xFFFFFFFFL;
                            CaptureResultExtras resultExtras = (CaptureResultExtras)msg.obj;
                            this.this$0.mCallbacks.onCaptureStarted(resultExtras, timestamp);
                            break;
                        }
                        case 3: {
                            Object[] resultArray = (Object[])msg.obj;
                            CameraMetadataNative result = (CameraMetadataNative)resultArray[0];
                            CaptureResultExtras resultExtras = (CaptureResultExtras)resultArray[1];
                            this.this$0.mCallbacks.onResultReceived(result, resultExtras);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown callback message " + msg.what);
                        }
                    }
                }
                catch (RemoteException e) {
                    throw new IllegalStateException("Received remote exception during camera callback " + msg.what, e);
                }
            }

            private void __constructor__(CameraCallbackThread cameraCallbackThread, Looper looper) {
                this.$$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread_CallbackHandler$__constructor__(cameraCallbackThread, looper);
            }

            public CallbackHandler(CameraCallbackThread cameraCallbackThread, Looper looper) {
                this.this$0 = cameraCallbackThread;
                super(looper);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread_CallbackHandler$__constructor__(android.hardware.camera2.legacy.CameraDeviceUserShim$CameraCallbackThread android.os.Looper ), 0, this, cameraCallbackThread, looper);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraCallbackThread_CallbackHandler$handleMessage(android.os.Message ), 0, this, message);
            }

            public /* synthetic */ CallbackHandler() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackHandler)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    private static class CameraLooper
    implements Runnable,
    AutoCloseable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mCameraId;
        private Looper mLooper;
        private volatile int mInitErrors;
        private Camera mCamera;
        private ConditionVariable mStartDone;
        private Thread mThread;

        private void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraLooper$__constructor__(int cameraId) {
            this.mCamera = Camera.openUninitialized();
            this.mStartDone = new ConditionVariable();
            this.mCameraId = cameraId;
            this.mThread = new Thread(this);
            this.mThread.start();
        }

        private final Camera $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraLooper$getCamera() {
            return this.mCamera;
        }

        private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraLooper$run() {
            Looper.prepare();
            this.mLooper = Looper.myLooper();
            this.mInitErrors = CameraDeviceUserShim.translateErrorsFromCamera1(this.mCamera.cameraInitUnspecified(this.mCameraId));
            this.mStartDone.open();
            Looper.loop();
        }

        private final void $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraLooper$close() {
            if (this.mLooper == null) {
                return;
            }
            this.mLooper.quitSafely();
            try {
                this.mThread.join();
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            this.mLooper = null;
        }

        private final int $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraLooper$waitForOpen(int timeoutMs) {
            if (!this.mStartDone.block(timeoutMs)) {
                Log.e("CameraDeviceUserShim", "waitForOpen - Camera failed to open after timeout of 5000 ms");
                try {
                    this.mCamera.release();
                }
                catch (RuntimeException e) {
                    Log.e("CameraDeviceUserShim", "connectBinderShim - Failed to release camera after timeout ", e);
                }
                throw new CameraRuntimeException(3);
            }
            return this.mInitErrors;
        }

        private void __constructor__(int n) {
            this.$$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraLooper$__constructor__(n);
        }

        public CameraLooper(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraLooper$__constructor__(int ), 0, this, n);
        }

        public Camera getCamera() {
            return InvokeDynamicSupport.bootstrap("getCamera", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraLooper$getCamera(), 0, this);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraLooper$run(), 0, this);
        }

        @Override
        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraLooper$close(), 0, this);
        }

        public int waitForOpen(int n) {
            return (int)InvokeDynamicSupport.bootstrap("waitForOpen", $$robo$$android_hardware_camera2_legacy_CameraDeviceUserShim_CameraLooper$waitForOpen(int ), 0, this, n);
        }

        public /* synthetic */ CameraLooper() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CameraLooper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

