/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.graphics.SurfaceTexture;
import android.hardware.camera2.legacy.CameraDeviceState;
import android.hardware.camera2.legacy.CaptureCollector;
import android.hardware.camera2.legacy.RequestHandlerThread;
import android.hardware.camera2.legacy.RequestThreadManager;
import android.hardware.camera2.legacy.SurfaceTextureRenderer;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.Surface;
import com.android.internal.util.Preconditions;
import java.util.Collection;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GLThreadManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String TAG;
    private static boolean DEBUG;
    private static int MSG_NEW_CONFIGURATION = 1;
    private static int MSG_NEW_FRAME = 2;
    private static int MSG_CLEANUP = 3;
    private static int MSG_DROP_FRAMES = 4;
    private static int MSG_ALLOW_FRAMES = 5;
    private CaptureCollector mCaptureCollector;
    private CameraDeviceState mDeviceState;
    private SurfaceTextureRenderer mTextureRenderer;
    private RequestHandlerThread mGLHandlerThread;
    private RequestThreadManager.FpsCounter mPrevCounter;
    private Handler.Callback mGLHandlerCb;

    private void $$robo$$android_hardware_camera2_legacy_GLThreadManager$__constructor__(int cameraId, int facing, CameraDeviceState state) {
        this.mPrevCounter = new RequestThreadManager.FpsCounter("GL Preview Producer");
        this.mGLHandlerCb = new Handler.Callback(this){
            public transient /* synthetic */ Object __robo_data__;
            private boolean mCleanup;
            private boolean mConfigured;
            private boolean mDroppingFrames;
            /* synthetic */ GLThreadManager this$0;

            private void $$robo$$android_hardware_camera2_legacy_GLThreadManager_1$__constructor__(GLThreadManager gLThreadManager) {
                this.mCleanup = false;
                this.mConfigured = false;
                this.mDroppingFrames = false;
            }

            private final boolean $$robo$$android_hardware_camera2_legacy_GLThreadManager_1$handleMessage(Message msg) {
                if (this.mCleanup) {
                    return true;
                }
                try {
                    switch (msg.what) {
                        case 1: {
                            ConfigureHolder configure = (ConfigureHolder)msg.obj;
                            this.this$0.mTextureRenderer.cleanupEGLContext();
                            this.this$0.mTextureRenderer.configureSurfaces(configure.surfaces);
                            this.this$0.mCaptureCollector = Preconditions.checkNotNull(configure.collector);
                            configure.condition.open();
                            this.mConfigured = true;
                            break;
                        }
                        case 2: {
                            if (this.mDroppingFrames) {
                                Log.w(this.this$0.TAG, "Ignoring frame.");
                                break;
                            }
                            if (DEBUG) {
                                this.this$0.mPrevCounter.countAndLog();
                            }
                            if (!this.mConfigured) {
                                Log.e(this.this$0.TAG, "Dropping frame, EGL context not configured!");
                            }
                            this.this$0.mTextureRenderer.drawIntoSurfaces(this.this$0.mCaptureCollector);
                            break;
                        }
                        case 3: {
                            this.this$0.mTextureRenderer.cleanupEGLContext();
                            this.mCleanup = true;
                            this.mConfigured = false;
                            break;
                        }
                        case 4: {
                            this.mDroppingFrames = true;
                            break;
                        }
                        case 5: {
                            this.mDroppingFrames = false;
                            break;
                        }
                        case -1: {
                            break;
                        }
                        default: {
                            Log.e(this.this$0.TAG, "Unhandled message " + msg.what + " on GLThread.");
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    Log.e(this.this$0.TAG, "Received exception on GL render thread: ", e);
                    this.this$0.mDeviceState.setError(1);
                }
                return true;
            }

            private void __constructor__(GLThreadManager gLThreadManager) {
                this.$$robo$$android_hardware_camera2_legacy_GLThreadManager_1$__constructor__(gLThreadManager);
            }
            {
                this.this$0 = gLThreadManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_GLThreadManager_1$__constructor__(android.hardware.camera2.legacy.GLThreadManager ), 0, this, gLThreadManager);
            }

            @Override
            public boolean handleMessage(Message message) {
                return (boolean)InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_hardware_camera2_legacy_GLThreadManager_1$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mTextureRenderer = new SurfaceTextureRenderer(facing);
        this.TAG = String.format("CameraDeviceGLThread-%d", cameraId);
        this.mGLHandlerThread = new RequestHandlerThread(this.TAG, this.mGLHandlerCb);
        this.mDeviceState = state;
    }

    private final void $$robo$$android_hardware_camera2_legacy_GLThreadManager$start() {
        this.mGLHandlerThread.start();
    }

    private final void $$robo$$android_hardware_camera2_legacy_GLThreadManager$waitUntilStarted() {
        this.mGLHandlerThread.waitUntilStarted();
    }

    private final void $$robo$$android_hardware_camera2_legacy_GLThreadManager$quit() {
        Handler handler = this.mGLHandlerThread.getHandler();
        handler.sendMessageAtFrontOfQueue(handler.obtainMessage(3));
        this.mGLHandlerThread.quitSafely();
        try {
            this.mGLHandlerThread.join();
        }
        catch (InterruptedException e) {
            Log.e(this.TAG, String.format("Thread %s (%d) interrupted while quitting.", this.mGLHandlerThread.getName(), this.mGLHandlerThread.getId()));
        }
    }

    private final void $$robo$$android_hardware_camera2_legacy_GLThreadManager$queueNewFrame() {
        Handler handler = this.mGLHandlerThread.getHandler();
        if (!handler.hasMessages(2)) {
            handler.sendMessage(handler.obtainMessage(2));
        } else {
            Log.e(this.TAG, "GLThread dropping frame.  Not consuming frames quickly enough!");
        }
    }

    private final void $$robo$$android_hardware_camera2_legacy_GLThreadManager$setConfigurationAndWait(Collection<Surface> surfaces, CaptureCollector collector) {
        Preconditions.checkNotNull(collector, "collector must not be null");
        Handler handler = this.mGLHandlerThread.getHandler();
        ConditionVariable condition = new ConditionVariable(false);
        ConfigureHolder configure = new ConfigureHolder(condition, surfaces, collector);
        Message m = handler.obtainMessage(1, 0, 0, configure);
        handler.sendMessage(m);
        condition.block();
    }

    private final SurfaceTexture $$robo$$android_hardware_camera2_legacy_GLThreadManager$getCurrentSurfaceTexture() {
        return this.mTextureRenderer.getSurfaceTexture();
    }

    private final void $$robo$$android_hardware_camera2_legacy_GLThreadManager$ignoreNewFrames() {
        this.mGLHandlerThread.getHandler().sendEmptyMessage(4);
    }

    private final void $$robo$$android_hardware_camera2_legacy_GLThreadManager$waitUntilIdle() {
        this.mGLHandlerThread.waitUntilIdle();
    }

    private final void $$robo$$android_hardware_camera2_legacy_GLThreadManager$allowNewFrames() {
        this.mGLHandlerThread.getHandler().sendEmptyMessage(5);
    }

    static void __staticInitializer__() {
        DEBUG = Log.isLoggable("HAL1ShimLogging", 3);
    }

    private void __constructor__(int n, int n2, CameraDeviceState cameraDeviceState) {
        this.$$robo$$android_hardware_camera2_legacy_GLThreadManager$__constructor__(n, n2, cameraDeviceState);
    }

    public GLThreadManager(int n, int n2, CameraDeviceState cameraDeviceState) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_GLThreadManager$__constructor__(int int android.hardware.camera2.legacy.CameraDeviceState ), 0, this, n, n2, cameraDeviceState);
    }

    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_hardware_camera2_legacy_GLThreadManager$start(), 0, this);
    }

    public void waitUntilStarted() {
        InvokeDynamicSupport.bootstrap("waitUntilStarted", $$robo$$android_hardware_camera2_legacy_GLThreadManager$waitUntilStarted(), 0, this);
    }

    public void quit() {
        InvokeDynamicSupport.bootstrap("quit", $$robo$$android_hardware_camera2_legacy_GLThreadManager$quit(), 0, this);
    }

    public void queueNewFrame() {
        InvokeDynamicSupport.bootstrap("queueNewFrame", $$robo$$android_hardware_camera2_legacy_GLThreadManager$queueNewFrame(), 0, this);
    }

    public void setConfigurationAndWait(Collection<Surface> collection, CaptureCollector captureCollector) {
        InvokeDynamicSupport.bootstrap("setConfigurationAndWait", $$robo$$android_hardware_camera2_legacy_GLThreadManager$setConfigurationAndWait(java.util.Collection<android.view.Surface> android.hardware.camera2.legacy.CaptureCollector ), 0, this, collection, captureCollector);
    }

    public SurfaceTexture getCurrentSurfaceTexture() {
        return InvokeDynamicSupport.bootstrap("getCurrentSurfaceTexture", $$robo$$android_hardware_camera2_legacy_GLThreadManager$getCurrentSurfaceTexture(), 0, this);
    }

    public void ignoreNewFrames() {
        InvokeDynamicSupport.bootstrap("ignoreNewFrames", $$robo$$android_hardware_camera2_legacy_GLThreadManager$ignoreNewFrames(), 0, this);
    }

    public void waitUntilIdle() {
        InvokeDynamicSupport.bootstrap("waitUntilIdle", $$robo$$android_hardware_camera2_legacy_GLThreadManager$waitUntilIdle(), 0, this);
    }

    public void allowNewFrames() {
        InvokeDynamicSupport.bootstrap("allowNewFrames", $$robo$$android_hardware_camera2_legacy_GLThreadManager$allowNewFrames(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(GLThreadManager.class);
    }

    public /* synthetic */ GLThreadManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GLThreadManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class ConfigureHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public ConditionVariable condition;
        public Collection<Surface> surfaces;
        public CaptureCollector collector;

        private void $$robo$$android_hardware_camera2_legacy_GLThreadManager_ConfigureHolder$__constructor__(ConditionVariable condition, Collection<Surface> surfaces, CaptureCollector collector) {
            this.condition = condition;
            this.surfaces = surfaces;
            this.collector = collector;
        }

        private void __constructor__(ConditionVariable conditionVariable, Collection<Surface> collection, CaptureCollector captureCollector) {
            this.$$robo$$android_hardware_camera2_legacy_GLThreadManager_ConfigureHolder$__constructor__(conditionVariable, collection, captureCollector);
        }

        public ConfigureHolder(ConditionVariable conditionVariable, Collection<Surface> collection, CaptureCollector captureCollector) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_GLThreadManager_ConfigureHolder$__constructor__(android.os.ConditionVariable java.util.Collection<android.view.Surface> android.hardware.camera2.legacy.CaptureCollector ), 0, this, conditionVariable, collection, captureCollector);
        }

        public /* synthetic */ ConfigureHolder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConfigureHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

