/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.ICameraDeviceCallbacks;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.impl.CaptureResultExtras;
import android.hardware.camera2.legacy.CameraDeviceState;
import android.hardware.camera2.legacy.LegacyExceptionUtils;
import android.hardware.camera2.legacy.RequestHolder;
import android.hardware.camera2.legacy.RequestThreadManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.utils.ArrayUtils;
import android.hardware.camera2.utils.CameraRuntimeException;
import android.hardware.camera2.utils.LongParcelable;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.RemoteException;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LegacyCameraDevice
implements AutoCloseable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String DEBUG_PROP = "HAL1ShimLogging";
    private String TAG;
    private static boolean DEBUG;
    private int mCameraId;
    private CameraCharacteristics mStaticCharacteristics;
    private ICameraDeviceCallbacks mDeviceCallbacks;
    private CameraDeviceState mDeviceState;
    private List<Surface> mConfiguredSurfaces;
    private boolean mClosed;
    private ConditionVariable mIdle;
    private HandlerThread mResultThread;
    private HandlerThread mCallbackHandlerThread;
    private Handler mCallbackHandler;
    private Handler mResultHandler;
    private static int ILLEGAL_VALUE = -1;
    private CameraDeviceState.CameraDeviceStateListener mStateListener;
    private RequestThreadManager mRequestThreadManager;

    private final CaptureResultExtras $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$getExtrasFromRequest(RequestHolder holder) {
        if (holder == null) {
            return new CaptureResultExtras(-1, -1, -1, -1, -1L, -1);
        }
        return new CaptureResultExtras(holder.getRequestId(), holder.getSubsequeceId(), 0, 0, holder.getFrameNumber(), 1);
    }

    private static final boolean $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$needsConversion(Surface s) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        int nativeType = LegacyCameraDevice.detectSurfaceType(s);
        return nativeType == 35 || nativeType == 842094169 || nativeType == 17;
    }

    private void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$__constructor__(int cameraId, Camera camera, CameraCharacteristics characteristics, ICameraDeviceCallbacks callbacks) {
        this.mDeviceState = new CameraDeviceState();
        this.mClosed = false;
        this.mIdle = new ConditionVariable(true);
        this.mResultThread = new HandlerThread("ResultThread");
        this.mCallbackHandlerThread = new HandlerThread("CallbackThread");
        this.mStateListener = new CameraDeviceState.CameraDeviceStateListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ LegacyCameraDevice this$0;

            private void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$__constructor__(LegacyCameraDevice legacyCameraDevice) {
            }

            private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onError(int errorCode, RequestHolder holder) {
                if (DEBUG) {
                    Log.d(this.this$0.TAG, "onError called, errorCode = " + errorCode);
                }
                switch (errorCode) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.this$0.mIdle.open();
                        if (!DEBUG) break;
                        Log.d(this.this$0.TAG, "onError - opening idle");
                    }
                }
                CaptureResultExtras extras = this.this$0.getExtrasFromRequest(holder);
                this.this$0.mResultHandler.post(new Runnable(this, holder, errorCode, extras){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ RequestHolder val$holder;
                    /* synthetic */ int val$errorCode;
                    /* synthetic */ CaptureResultExtras val$extras;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_1$__constructor__(1 var1_1, RequestHolder requestHolder, int n, CaptureResultExtras captureResultExtras) {
                    }

                    private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_1$run() {
                        if (DEBUG) {
                            Log.d(this.this$1.this$0.TAG, "doing onError callback for request " + this.val$holder.getRequestId() + ", with error code " + this.val$errorCode);
                        }
                        try {
                            this.this$1.this$0.mDeviceCallbacks.onDeviceError(this.val$errorCode, this.val$extras);
                        }
                        catch (RemoteException e) {
                            throw new IllegalStateException("Received remote exception during onCameraError callback: ", e);
                        }
                    }

                    private void __constructor__(1 var1_1, RequestHolder requestHolder, int n, CaptureResultExtras captureResultExtras) {
                        this.$$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_1$__constructor__(var1_1, requestHolder, n, captureResultExtras);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$holder = requestHolder;
                        this.val$errorCode = n;
                        this.val$extras = captureResultExtras;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_1$__constructor__(android.hardware.camera2.legacy.LegacyCameraDevice$1 android.hardware.camera2.legacy.RequestHolder int android.hardware.camera2.impl.CaptureResultExtras ), 0, this, var1_1, requestHolder, n, captureResultExtras);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_1$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onConfiguring() {
                if (DEBUG) {
                    Log.d(this.this$0.TAG, "doing onConfiguring callback.");
                }
            }

            private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onIdle() {
                if (DEBUG) {
                    Log.d(this.this$0.TAG, "onIdle called");
                }
                this.this$0.mIdle.open();
                this.this$0.mResultHandler.post(new Runnable(this){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_2$__constructor__(1 var1_1) {
                    }

                    private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_2$run() {
                        if (DEBUG) {
                            Log.d(this.this$1.this$0.TAG, "doing onIdle callback.");
                        }
                        try {
                            this.this$1.this$0.mDeviceCallbacks.onDeviceIdle();
                        }
                        catch (RemoteException e) {
                            throw new IllegalStateException("Received remote exception during onCameraIdle callback: ", e);
                        }
                    }

                    private void __constructor__(1 var1_1) {
                        this.$$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_2$__constructor__(var1_1);
                    }
                    {
                        this.this$1 = var1_1;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_2$__constructor__(android.hardware.camera2.legacy.LegacyCameraDevice$1 ), 0, this, var1_1);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_2$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onBusy() {
                this.this$0.mIdle.close();
                if (DEBUG) {
                    Log.d(this.this$0.TAG, "onBusy called");
                }
            }

            private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onCaptureStarted(RequestHolder holder, long timestamp) {
                CaptureResultExtras extras = this.this$0.getExtrasFromRequest(holder);
                this.this$0.mResultHandler.post(new Runnable(this, holder, extras, timestamp){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ RequestHolder val$holder;
                    /* synthetic */ CaptureResultExtras val$extras;
                    /* synthetic */ long val$timestamp;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_3$__constructor__(1 var1_1, RequestHolder requestHolder, CaptureResultExtras captureResultExtras, long l) {
                    }

                    private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_3$run() {
                        if (DEBUG) {
                            Log.d(this.this$1.this$0.TAG, "doing onCaptureStarted callback for request " + this.val$holder.getRequestId());
                        }
                        try {
                            this.this$1.this$0.mDeviceCallbacks.onCaptureStarted(this.val$extras, this.val$timestamp);
                        }
                        catch (RemoteException e) {
                            throw new IllegalStateException("Received remote exception during onCameraError callback: ", e);
                        }
                    }

                    private void __constructor__(1 var1_1, RequestHolder requestHolder, CaptureResultExtras captureResultExtras, long l) {
                        this.$$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_3$__constructor__(var1_1, requestHolder, captureResultExtras, l);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$holder = requestHolder;
                        this.val$extras = captureResultExtras;
                        this.val$timestamp = l;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_3$__constructor__(android.hardware.camera2.legacy.LegacyCameraDevice$1 android.hardware.camera2.legacy.RequestHolder android.hardware.camera2.impl.CaptureResultExtras long ), 0, this, var1_1, requestHolder, captureResultExtras, l);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_3$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onCaptureResult(CameraMetadataNative result, RequestHolder holder) {
                CaptureResultExtras extras = this.this$0.getExtrasFromRequest(holder);
                this.this$0.mResultHandler.post(new Runnable(this, holder, result, extras){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ RequestHolder val$holder;
                    /* synthetic */ CameraMetadataNative val$result;
                    /* synthetic */ CaptureResultExtras val$extras;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_4$__constructor__(1 var1_1, RequestHolder requestHolder, CameraMetadataNative cameraMetadataNative, CaptureResultExtras captureResultExtras) {
                    }

                    private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_4$run() {
                        if (DEBUG) {
                            Log.d(this.this$1.this$0.TAG, "doing onCaptureResult callback for request " + this.val$holder.getRequestId());
                        }
                        try {
                            this.this$1.this$0.mDeviceCallbacks.onResultReceived(this.val$result, this.val$extras);
                        }
                        catch (RemoteException e) {
                            throw new IllegalStateException("Received remote exception during onCameraError callback: ", e);
                        }
                    }

                    private void __constructor__(1 var1_1, RequestHolder requestHolder, CameraMetadataNative cameraMetadataNative, CaptureResultExtras captureResultExtras) {
                        this.$$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_4$__constructor__(var1_1, requestHolder, cameraMetadataNative, captureResultExtras);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$holder = requestHolder;
                        this.val$result = cameraMetadataNative;
                        this.val$extras = captureResultExtras;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_4$__constructor__(android.hardware.camera2.legacy.LegacyCameraDevice$1 android.hardware.camera2.legacy.RequestHolder android.hardware.camera2.impl.CameraMetadataNative android.hardware.camera2.impl.CaptureResultExtras ), 0, this, var1_1, requestHolder, cameraMetadataNative, captureResultExtras);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_4$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private void __constructor__(LegacyCameraDevice legacyCameraDevice) {
                this.$$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$__constructor__(legacyCameraDevice);
            }
            {
                this.this$0 = legacyCameraDevice;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$__constructor__(android.hardware.camera2.legacy.LegacyCameraDevice ), 0, this, legacyCameraDevice);
            }

            @Override
            public void onError(int n, RequestHolder requestHolder) {
                InvokeDynamicSupport.bootstrap("onError", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onError(int android.hardware.camera2.legacy.RequestHolder ), 0, this, n, requestHolder);
            }

            @Override
            public void onConfiguring() {
                InvokeDynamicSupport.bootstrap("onConfiguring", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onConfiguring(), 0, this);
            }

            @Override
            public void onIdle() {
                InvokeDynamicSupport.bootstrap("onIdle", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onIdle(), 0, this);
            }

            @Override
            public void onBusy() {
                InvokeDynamicSupport.bootstrap("onBusy", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onBusy(), 0, this);
            }

            @Override
            public void onCaptureStarted(RequestHolder requestHolder, long l) {
                InvokeDynamicSupport.bootstrap("onCaptureStarted", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onCaptureStarted(android.hardware.camera2.legacy.RequestHolder long ), 0, this, requestHolder, l);
            }

            @Override
            public void onCaptureResult(CameraMetadataNative cameraMetadataNative, RequestHolder requestHolder) {
                InvokeDynamicSupport.bootstrap("onCaptureResult", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onCaptureResult(android.hardware.camera2.impl.CameraMetadataNative android.hardware.camera2.legacy.RequestHolder ), 0, this, cameraMetadataNative, requestHolder);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCameraId = cameraId;
        this.mDeviceCallbacks = callbacks;
        this.TAG = String.format("CameraDevice-%d-LE", this.mCameraId);
        this.mResultThread.start();
        this.mResultHandler = new Handler(this.mResultThread.getLooper());
        this.mCallbackHandlerThread.start();
        this.mCallbackHandler = new Handler(this.mCallbackHandlerThread.getLooper());
        this.mDeviceState.setCameraDeviceCallbacks(this.mCallbackHandler, this.mStateListener);
        this.mStaticCharacteristics = characteristics;
        this.mRequestThreadManager = new RequestThreadManager(cameraId, camera, characteristics, this.mDeviceState);
        this.mRequestThreadManager.start();
    }

    private final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$configureOutputs(List<Surface> outputs) {
        if (outputs != null) {
            for (Surface output : outputs) {
                if (output == null) {
                    Log.e(this.TAG, "configureOutputs - null outputs are not allowed");
                    return -22;
                }
                StreamConfigurationMap streamConfigurations = this.mStaticCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                try {
                    Size s = LegacyCameraDevice.getSurfaceSize(output);
                    int surfaceType = LegacyCameraDevice.detectSurfaceType(output);
                    Object[] sizes = streamConfigurations.getOutputSizes(surfaceType);
                    if (sizes == null) {
                        if (surfaceType >= 1 && surfaceType <= 5) {
                            sizes = streamConfigurations.getOutputSizes(35);
                        } else if (surfaceType == 33) {
                            sizes = streamConfigurations.getOutputSizes(256);
                        }
                    }
                    if (ArrayUtils.contains(sizes, s)) continue;
                    String reason = sizes == null ? "format is invalid." : "size not in valid set: " + Arrays.toString(sizes);
                    Log.e(this.TAG, String.format("Surface with size (w=%d, h=%d) and format 0x%x is not valid, %s", s.getWidth(), s.getHeight(), surfaceType, reason));
                    return -22;
                }
                catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
                    Log.e(this.TAG, "Surface bufferqueue is abandoned, cannot configure as output: ", e);
                    return -22;
                }
            }
        }
        boolean success = false;
        if (this.mDeviceState.setConfiguring()) {
            this.mRequestThreadManager.configure(outputs);
            success = this.mDeviceState.setIdle();
        }
        if (!success) {
            return -38;
        }
        this.mConfiguredSurfaces = outputs != null ? new ArrayList<Surface>(outputs) : null;
        return 0;
    }

    private final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$submitRequestList(List<CaptureRequest> requestList, boolean repeating, LongParcelable frameNumber) {
        if (requestList == null || requestList.isEmpty()) {
            Log.e(this.TAG, "submitRequestList - Empty/null requests are not allowed");
            return -22;
        }
        ArrayList<Long> surfaceIds = this.mConfiguredSurfaces == null ? new ArrayList() : LegacyCameraDevice.getSurfaceIds(this.mConfiguredSurfaces);
        for (CaptureRequest request : requestList) {
            if (request.getTargets().isEmpty()) {
                Log.e(this.TAG, "submitRequestList - Each request must have at least one Surface target");
                return -22;
            }
            for (Surface surface : request.getTargets()) {
                if (surface == null) {
                    Log.e(this.TAG, "submitRequestList - Null Surface targets are not allowed");
                    return -22;
                }
                if (this.mConfiguredSurfaces == null) {
                    Log.e(this.TAG, "submitRequestList - must configure  device with valid surfaces before submitting requests");
                    return -38;
                }
                if (LegacyCameraDevice.containsSurfaceId(surface, surfaceIds)) continue;
                Log.e(this.TAG, "submitRequestList - cannot use a surface that wasn't configured");
                return -22;
            }
        }
        this.mIdle.close();
        return this.mRequestThreadManager.submitCaptureRequests(requestList, repeating, frameNumber);
    }

    private final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$submitRequest(CaptureRequest request, boolean repeating, LongParcelable frameNumber) {
        ArrayList<CaptureRequest> requestList = new ArrayList<CaptureRequest>();
        requestList.add(request);
        return this.submitRequestList(requestList, repeating, frameNumber);
    }

    private final long $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$cancelRequest(int requestId) {
        return this.mRequestThreadManager.cancelRepeating(requestId);
    }

    private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$waitUntilIdle() {
        this.mIdle.block();
    }

    private final long $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$flush() {
        long lastFrame = this.mRequestThreadManager.flush();
        this.waitUntilIdle();
        return lastFrame;
    }

    private final boolean $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$isClosed() {
        return this.mClosed;
    }

    private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$close() {
        this.mRequestThreadManager.quit();
        this.mCallbackHandlerThread.quitSafely();
        this.mResultThread.quitSafely();
        try {
            this.mCallbackHandlerThread.join();
        }
        catch (InterruptedException e) {
            Log.e(this.TAG, String.format("Thread %s (%d) interrupted while quitting.", this.mCallbackHandlerThread.getName(), this.mCallbackHandlerThread.getId()));
        }
        try {
            this.mResultThread.join();
        }
        catch (InterruptedException e) {
            Log.e(this.TAG, String.format("Thread %s (%d) interrupted while quitting.", this.mResultThread.getName(), this.mResultThread.getId()));
        }
        this.mClosed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$finalize() throws Throwable {
        try {
            this.close();
        }
        catch (CameraRuntimeException e) {
            Log.e(this.TAG, "Got error while trying to finalize, ignoring: " + e.getMessage());
        }
        finally {
            super.finalize();
        }
    }

    private static final Size $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$getSurfaceSize(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        int[] dimens = new int[2];
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeDetectSurfaceDimens(surface, dimens));
        return new Size(dimens[0], dimens[1]);
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$detectSurfaceType(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        return LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeDetectSurfaceType(surface));
    }

    private static final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$configureSurface(Surface surface, int width, int height, int pixelFormat) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        Preconditions.checkArgumentPositive(width, "width must be positive.");
        Preconditions.checkArgumentPositive(height, "height must be positive.");
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeConfigureSurface(surface, width, height, pixelFormat));
    }

    private static final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$produceFrame(Surface surface, byte[] pixelBuffer, int width, int height, int pixelFormat) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        Preconditions.checkNotNull(pixelBuffer);
        Preconditions.checkArgumentPositive(width, "width must be positive.");
        Preconditions.checkArgumentPositive(height, "height must be positive.");
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeProduceFrame(surface, pixelBuffer, width, height, pixelFormat));
    }

    private static final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$setSurfaceFormat(Surface surface, int pixelFormat) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeSetSurfaceFormat(surface, pixelFormat));
    }

    private static final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$setSurfaceDimens(Surface surface, int width, int height) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        Preconditions.checkArgumentPositive(width, "width must be positive.");
        Preconditions.checkArgumentPositive(height, "height must be positive.");
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeSetSurfaceDimens(surface, width, height));
    }

    private static final long $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$getSurfaceId(Surface surface) {
        Preconditions.checkNotNull(surface);
        return LegacyCameraDevice.nativeGetSurfaceId(surface);
    }

    private static final List<Long> $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$getSurfaceIds(Collection<Surface> surfaces) {
        if (surfaces == null) {
            throw new NullPointerException("Null argument surfaces");
        }
        ArrayList<Long> surfaceIds = new ArrayList<Long>();
        for (Surface s : surfaces) {
            long id2 = LegacyCameraDevice.getSurfaceId(s);
            if (id2 == 0L) {
                throw new IllegalStateException("Configured surface had null native GraphicBufferProducer pointer!");
            }
            surfaceIds.add(id2);
        }
        return surfaceIds;
    }

    private static final boolean $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$containsSurfaceId(Surface s, Collection<Long> ids) {
        long id2 = LegacyCameraDevice.getSurfaceId(s);
        return ids.contains(id2);
    }

    private static final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$setSurfaceOrientation(Surface surface, int facing, int sensorOrientation) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeSetSurfaceOrientation(surface, facing, sensorOrientation));
    }

    private static final Size $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$getTextureSize(SurfaceTexture surfaceTexture) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surfaceTexture);
        int[] dimens = new int[2];
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeDetectTextureDimens(surfaceTexture, dimens));
        return new Size(dimens[0], dimens[1]);
    }

    private static final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$setNextTimestamp(Surface surface, long timestamp) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeSetNextTimestamp(surface, timestamp));
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeDetectSurfaceType(Surface surface) {
        return 0;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeDetectSurfaceDimens(Surface surface, int[] nArray) {
        return 0;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeConfigureSurface(Surface surface, int n, int n2, int n3) {
        return 0;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeProduceFrame(Surface surface, byte[] byArray, int n, int n2, int n3) {
        return 0;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeSetSurfaceFormat(Surface surface, int n) {
        return 0;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeSetSurfaceDimens(Surface surface, int n, int n2) {
        return 0;
    }

    private static final long $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeGetSurfaceId(Surface surface) {
        return 0L;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeSetSurfaceOrientation(Surface surface, int n, int n2) {
        return 0;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeDetectTextureDimens(SurfaceTexture surfaceTexture, int[] nArray) {
        return 0;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeSetNextTimestamp(Surface surface, long l) {
        return 0;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeGetJpegFooterSize() {
        return 0;
    }

    static void __staticInitializer__() {
        DEBUG = Log.isLoggable("HAL1ShimLogging", 3);
    }

    private CaptureResultExtras getExtrasFromRequest(RequestHolder requestHolder) {
        return InvokeDynamicSupport.bootstrap("getExtrasFromRequest", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$getExtrasFromRequest(android.hardware.camera2.legacy.RequestHolder ), 0, this, requestHolder);
    }

    static boolean needsConversion(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("needsConversion", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$needsConversion(android.view.Surface ), 0, (Surface)surface);
    }

    private void __constructor__(int n, Camera camera, CameraCharacteristics cameraCharacteristics, ICameraDeviceCallbacks iCameraDeviceCallbacks) {
        this.$$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$__constructor__(n, camera, cameraCharacteristics, iCameraDeviceCallbacks);
    }

    public LegacyCameraDevice(int n, Camera camera, CameraCharacteristics cameraCharacteristics, ICameraDeviceCallbacks iCameraDeviceCallbacks) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$__constructor__(int android.hardware.Camera android.hardware.camera2.CameraCharacteristics android.hardware.camera2.ICameraDeviceCallbacks ), 0, this, n, camera, cameraCharacteristics, iCameraDeviceCallbacks);
    }

    public int configureOutputs(List<Surface> list) {
        return (int)InvokeDynamicSupport.bootstrap("configureOutputs", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$configureOutputs(java.util.List<android.view.Surface> ), 0, this, list);
    }

    public int submitRequestList(List<CaptureRequest> list, boolean bl, LongParcelable longParcelable) {
        return (int)InvokeDynamicSupport.bootstrap("submitRequestList", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$submitRequestList(java.util.List<android.hardware.camera2.CaptureRequest> boolean android.hardware.camera2.utils.LongParcelable ), 0, this, list, bl, longParcelable);
    }

    public int submitRequest(CaptureRequest captureRequest, boolean bl, LongParcelable longParcelable) {
        return (int)InvokeDynamicSupport.bootstrap("submitRequest", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$submitRequest(android.hardware.camera2.CaptureRequest boolean android.hardware.camera2.utils.LongParcelable ), 0, this, captureRequest, bl, longParcelable);
    }

    public long cancelRequest(int n) {
        return (long)InvokeDynamicSupport.bootstrap("cancelRequest", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$cancelRequest(int ), 0, this, n);
    }

    public void waitUntilIdle() {
        InvokeDynamicSupport.bootstrap("waitUntilIdle", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$waitUntilIdle(), 0, this);
    }

    public long flush() {
        return (long)InvokeDynamicSupport.bootstrap("flush", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$flush(), 0, this);
    }

    public boolean isClosed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isClosed", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$isClosed(), 0, this);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$close(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$finalize(), 0, this);
    }

    static Size getSurfaceSize(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        return InvokeDynamicSupport.bootstrapStatic("getSurfaceSize", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$getSurfaceSize(android.view.Surface ), 0, (Surface)surface);
    }

    static int detectSurfaceType(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        return (int)InvokeDynamicSupport.bootstrapStatic("detectSurfaceType", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$detectSurfaceType(android.view.Surface ), 0, (Surface)surface);
    }

    static void configureSurface(Surface surface, int n, int n2, int n3) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        InvokeDynamicSupport.bootstrapStatic("configureSurface", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$configureSurface(android.view.Surface int int int ), 0, (Surface)surface, (int)n, (int)n2, (int)n3);
    }

    static void produceFrame(Surface surface, byte[] byArray, int n, int n2, int n3) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        InvokeDynamicSupport.bootstrapStatic("produceFrame", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$produceFrame(android.view.Surface byte[] int int int ), 0, (Surface)surface, (byte[])byArray, (int)n, (int)n2, (int)n3);
    }

    static void setSurfaceFormat(Surface surface, int n) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        InvokeDynamicSupport.bootstrapStatic("setSurfaceFormat", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$setSurfaceFormat(android.view.Surface int ), 0, (Surface)surface, (int)n);
    }

    static void setSurfaceDimens(Surface surface, int n, int n2) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        InvokeDynamicSupport.bootstrapStatic("setSurfaceDimens", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$setSurfaceDimens(android.view.Surface int int ), 0, (Surface)surface, (int)n, (int)n2);
    }

    static long getSurfaceId(Surface surface) {
        return (long)InvokeDynamicSupport.bootstrapStatic("getSurfaceId", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$getSurfaceId(android.view.Surface ), 0, (Surface)surface);
    }

    static List<Long> getSurfaceIds(Collection<Surface> collection) {
        return InvokeDynamicSupport.bootstrapStatic("getSurfaceIds", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$getSurfaceIds(java.util.Collection<android.view.Surface> ), 0, collection);
    }

    static boolean containsSurfaceId(Surface surface, Collection<Long> collection) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("containsSurfaceId", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$containsSurfaceId(android.view.Surface java.util.Collection<java.lang.Long> ), 0, (Surface)surface, collection);
    }

    static void setSurfaceOrientation(Surface surface, int n, int n2) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        InvokeDynamicSupport.bootstrapStatic("setSurfaceOrientation", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$setSurfaceOrientation(android.view.Surface int int ), 0, (Surface)surface, (int)n, (int)n2);
    }

    static Size getTextureSize(SurfaceTexture surfaceTexture) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        return InvokeDynamicSupport.bootstrapStatic("getTextureSize", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$getTextureSize(android.graphics.SurfaceTexture ), 0, (SurfaceTexture)surfaceTexture);
    }

    static void setNextTimestamp(Surface surface, long l) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        InvokeDynamicSupport.bootstrapStatic("setNextTimestamp", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$setNextTimestamp(android.view.Surface long ), 0, (Surface)surface, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nativeDetectSurfaceType$nativeBinding(Surface var0);

    private static int nativeDetectSurfaceType(Surface surface) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeDetectSurfaceType", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeDetectSurfaceType(android.view.Surface ), 1, (Surface)surface);
    }

    private static final native /* synthetic */ int $$robo$$nativeDetectSurfaceDimens$nativeBinding(Surface var0, int[] var1);

    private static int nativeDetectSurfaceDimens(Surface surface, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeDetectSurfaceDimens", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeDetectSurfaceDimens(android.view.Surface int[] ), 1, (Surface)surface, (int[])nArray);
    }

    private static final native /* synthetic */ int $$robo$$nativeConfigureSurface$nativeBinding(Surface var0, int var1, int var2, int var3);

    private static int nativeConfigureSurface(Surface surface, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeConfigureSurface", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeConfigureSurface(android.view.Surface int int int ), 1, (Surface)surface, (int)n, (int)n2, (int)n3);
    }

    private static final native /* synthetic */ int $$robo$$nativeProduceFrame$nativeBinding(Surface var0, byte[] var1, int var2, int var3, int var4);

    private static int nativeProduceFrame(Surface surface, byte[] byArray, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeProduceFrame", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeProduceFrame(android.view.Surface byte[] int int int ), 1, (Surface)surface, (byte[])byArray, (int)n, (int)n2, (int)n3);
    }

    private static final native /* synthetic */ int $$robo$$nativeSetSurfaceFormat$nativeBinding(Surface var0, int var1);

    private static int nativeSetSurfaceFormat(Surface surface, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeSetSurfaceFormat", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeSetSurfaceFormat(android.view.Surface int ), 1, (Surface)surface, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$nativeSetSurfaceDimens$nativeBinding(Surface var0, int var1, int var2);

    private static int nativeSetSurfaceDimens(Surface surface, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeSetSurfaceDimens", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeSetSurfaceDimens(android.view.Surface int int ), 1, (Surface)surface, (int)n, (int)n2);
    }

    private static final native /* synthetic */ long $$robo$$nativeGetSurfaceId$nativeBinding(Surface var0);

    private static long nativeGetSurfaceId(Surface surface) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeGetSurfaceId", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeGetSurfaceId(android.view.Surface ), 1, (Surface)surface);
    }

    private static final native /* synthetic */ int $$robo$$nativeSetSurfaceOrientation$nativeBinding(Surface var0, int var1, int var2);

    private static int nativeSetSurfaceOrientation(Surface surface, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeSetSurfaceOrientation", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeSetSurfaceOrientation(android.view.Surface int int ), 1, (Surface)surface, (int)n, (int)n2);
    }

    private static final native /* synthetic */ int $$robo$$nativeDetectTextureDimens$nativeBinding(SurfaceTexture var0, int[] var1);

    private static int nativeDetectTextureDimens(SurfaceTexture surfaceTexture, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeDetectTextureDimens", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeDetectTextureDimens(android.graphics.SurfaceTexture int[] ), 1, (SurfaceTexture)surfaceTexture, (int[])nArray);
    }

    private static final native /* synthetic */ int $$robo$$nativeSetNextTimestamp$nativeBinding(Surface var0, long var1);

    private static int nativeSetNextTimestamp(Surface surface, long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeSetNextTimestamp", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeSetNextTimestamp(android.view.Surface long ), 1, (Surface)surface, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetJpegFooterSize$nativeBinding();

    static int nativeGetJpegFooterSize() {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetJpegFooterSize", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeGetJpegFooterSize(), 1);
    }

    static {
        RobolectricInternals.classInitializing(LegacyCameraDevice.class);
    }

    public /* synthetic */ LegacyCameraDevice() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LegacyCameraDevice)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

