/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.hardware.camera2.params.Face;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.utils.ListUtils;
import android.hardware.camera2.utils.ParamsUtils;
import android.hardware.camera2.utils.SizeAreaComparator;
import android.util.Log;
import android.util.Size;
import android.util.SizeF;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ParameterUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int NORMALIZED_RECTANGLE_MIN = -1000;
    public static int NORMALIZED_RECTANGLE_MAX = 1000;
    public static Rect NORMALIZED_RECTANGLE_DEFAULT;
    public static Camera.Area CAMERA_AREA_DEFAULT;
    public static Rect RECTANGLE_EMPTY;
    private static String TAG = "ParameterUtils";
    private static boolean VERBOSE;
    private static int ZOOM_RATIO_MULTIPLIER = 100;

    private static final Size $$robo$$android_hardware_camera2_legacy_ParameterUtils$convertSize(Camera.Size size) {
        Preconditions.checkNotNull(size, "size must not be null");
        return new Size(size.width, size.height);
    }

    private static final List<Size> $$robo$$android_hardware_camera2_legacy_ParameterUtils$convertSizeList(List<Camera.Size> sizeList) {
        Preconditions.checkNotNull(sizeList, "sizeList must not be null");
        ArrayList<Size> sizes = new ArrayList<Size>(sizeList.size());
        for (Camera.Size s : sizeList) {
            sizes.add(new Size(s.width, s.height));
        }
        return sizes;
    }

    private static final Size[] $$robo$$android_hardware_camera2_legacy_ParameterUtils$convertSizeListToArray(List<Camera.Size> sizeList) {
        Preconditions.checkNotNull(sizeList, "sizeList must not be null");
        Size[] array2 = new Size[sizeList.size()];
        int ctr = 0;
        for (Camera.Size s : sizeList) {
            array2[ctr++] = new Size(s.width, s.height);
        }
        return array2;
    }

    private static final boolean $$robo$$android_hardware_camera2_legacy_ParameterUtils$containsSize(List<Camera.Size> sizeList, int width, int height) {
        Preconditions.checkNotNull(sizeList, "sizeList must not be null");
        for (Camera.Size s : sizeList) {
            if (s.height != height || s.width != width) continue;
            return true;
        }
        return false;
    }

    private static final Size $$robo$$android_hardware_camera2_legacy_ParameterUtils$getLargestSupportedJpegSizeByArea(Camera.Parameters params) {
        Preconditions.checkNotNull(params, "params must not be null");
        List<Size> supportedJpegSizes = ParameterUtils.convertSizeList(params.getSupportedPictureSizes());
        return SizeAreaComparator.findLargestByArea(supportedJpegSizes);
    }

    private static final String $$robo$$android_hardware_camera2_legacy_ParameterUtils$stringFromArea(Camera.Area area) {
        if (area == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Rect r = area.rect;
        sb.setLength(0);
        sb.append("([");
        sb.append(r.left);
        sb.append(',');
        sb.append(r.top);
        sb.append("][");
        sb.append(r.right);
        sb.append(',');
        sb.append(r.bottom);
        sb.append(']');
        sb.append(',');
        sb.append(area.weight);
        sb.append(')');
        return sb.toString();
    }

    private static final String $$robo$$android_hardware_camera2_legacy_ParameterUtils$stringFromAreaList(List<Camera.Area> areaList) {
        StringBuilder sb = new StringBuilder();
        if (areaList == null) {
            return null;
        }
        int i = 0;
        for (Camera.Area area : areaList) {
            if (area == null) {
                sb.append("null");
            } else {
                sb.append(ParameterUtils.stringFromArea(area));
            }
            if (i != areaList.size() - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }

    private static final int $$robo$$android_hardware_camera2_legacy_ParameterUtils$getClosestAvailableZoomCrop(Camera.Parameters params, Rect activeArray, Size streamSize, Rect cropRegion, Rect reportedCropRegion, Rect previewCropRegion) {
        Preconditions.checkNotNull(params, "params must not be null");
        Preconditions.checkNotNull(activeArray, "activeArray must not be null");
        Preconditions.checkNotNull(streamSize, "streamSize must not be null");
        Preconditions.checkNotNull(reportedCropRegion, "reportedCropRegion must not be null");
        Preconditions.checkNotNull(previewCropRegion, "previewCropRegion must not be null");
        Rect actualCrop = new Rect(cropRegion);
        if (!actualCrop.intersect(activeArray)) {
            Log.w("ParameterUtils", "getClosestAvailableZoomCrop - Crop region out of range; setting to active array size");
            actualCrop.set(activeArray);
        }
        Rect previewCrop = ParameterUtils.getPreviewCropRectangleUnzoomed(activeArray, streamSize);
        Rect cropRegionAsPreview = ParameterUtils.shrinkToSameAspectRatioCentered(previewCrop, actualCrop);
        if (VERBOSE) {
            Log.v("ParameterUtils", "getClosestAvailableZoomCrop - actualCrop = " + actualCrop);
            Log.v("ParameterUtils", "getClosestAvailableZoomCrop - previewCrop = " + previewCrop);
            Log.v("ParameterUtils", "getClosestAvailableZoomCrop - cropRegionAsPreview = " + cropRegionAsPreview);
        }
        Rect bestReportedCropRegion = null;
        Rect bestPreviewCropRegion = null;
        int bestZoomIndex = -1;
        List<Rect> availableReportedCropRegions = ParameterUtils.getAvailableZoomCropRectangles(params, activeArray);
        List<Rect> availablePreviewCropRegions = ParameterUtils.getAvailablePreviewZoomCropRectangles(params, activeArray, streamSize);
        if (VERBOSE) {
            Log.v("ParameterUtils", "getClosestAvailableZoomCrop - availableReportedCropRegions = " + ListUtils.listToString(availableReportedCropRegions));
            Log.v("ParameterUtils", "getClosestAvailableZoomCrop - availablePreviewCropRegions = " + ListUtils.listToString(availablePreviewCropRegions));
        }
        if (availableReportedCropRegions.size() != availablePreviewCropRegions.size()) {
            throw new AssertionError((Object)"available reported/preview crop region size mismatch");
        }
        int i = 0;
        while (i < availableReportedCropRegions.size()) {
            Rect currentPreviewCropRegion = availablePreviewCropRegions.get(i);
            Rect currentReportedCropRegion = availableReportedCropRegions.get(i);
            boolean isBest = bestZoomIndex == -1 ? true : currentPreviewCropRegion.width() >= cropRegionAsPreview.width() && currentPreviewCropRegion.height() >= cropRegionAsPreview.height();
            if (!isBest) break;
            bestPreviewCropRegion = currentPreviewCropRegion;
            bestReportedCropRegion = currentReportedCropRegion;
            bestZoomIndex = i++;
        }
        if (bestZoomIndex == -1) {
            throw new AssertionError((Object)"Should've found at least one valid zoom index");
        }
        reportedCropRegion.set(bestReportedCropRegion);
        previewCropRegion.set(bestPreviewCropRegion);
        return bestZoomIndex;
    }

    private static final Rect $$robo$$android_hardware_camera2_legacy_ParameterUtils$getPreviewCropRectangleUnzoomed(Rect activeArray, Size previewSize) {
        float cropW;
        float cropH;
        if (previewSize.getWidth() > activeArray.width()) {
            throw new IllegalArgumentException("previewSize must not be wider than activeArray");
        }
        if (previewSize.getHeight() > activeArray.height()) {
            throw new IllegalArgumentException("previewSize must not be taller than activeArray");
        }
        float aspectRatioArray = (float)activeArray.width() * 1.0f / (float)activeArray.height();
        float aspectRatioPreview = (float)previewSize.getWidth() * 1.0f / (float)previewSize.getHeight();
        if (aspectRatioPreview < aspectRatioArray) {
            cropH = activeArray.height();
            cropW = cropH * aspectRatioPreview;
        } else {
            cropW = activeArray.width();
            cropH = cropW / aspectRatioPreview;
        }
        Matrix translateMatrix = new Matrix();
        RectF cropRect = new RectF(0.0f, 0.0f, cropW, cropH);
        translateMatrix.setTranslate(activeArray.exactCenterX(), activeArray.exactCenterY());
        translateMatrix.postTranslate(-cropRect.centerX(), -cropRect.centerY());
        translateMatrix.mapRect(cropRect);
        return ParamsUtils.createRect(cropRect);
    }

    private static final Rect $$robo$$android_hardware_camera2_legacy_ParameterUtils$shrinkToSameAspectRatioCentered(Rect reference, Rect shrinkTarget) {
        float cropW;
        float cropH;
        float aspectRatioReference = (float)reference.width() * 1.0f / (float)reference.height();
        float aspectRatioShrinkTarget = (float)shrinkTarget.width() * 1.0f / (float)shrinkTarget.height();
        if (aspectRatioShrinkTarget < aspectRatioReference) {
            cropH = reference.height();
            cropW = cropH * aspectRatioShrinkTarget;
        } else {
            cropW = reference.width();
            cropH = cropW / aspectRatioShrinkTarget;
        }
        Matrix translateMatrix = new Matrix();
        RectF shrunkRect = new RectF(shrinkTarget);
        translateMatrix.setScale(cropW / (float)reference.width(), cropH / (float)reference.height(), shrinkTarget.exactCenterX(), shrinkTarget.exactCenterY());
        translateMatrix.mapRect(shrunkRect);
        return ParamsUtils.createRect(shrunkRect);
    }

    private static final List<Rect> $$robo$$android_hardware_camera2_legacy_ParameterUtils$getAvailableZoomCropRectangles(Camera.Parameters params, Rect activeArray) {
        Preconditions.checkNotNull(params, "params must not be null");
        Preconditions.checkNotNull(activeArray, "activeArray must not be null");
        return ParameterUtils.getAvailableCropRectangles(params, activeArray, ParamsUtils.createSize(activeArray));
    }

    private static final List<Rect> $$robo$$android_hardware_camera2_legacy_ParameterUtils$getAvailablePreviewZoomCropRectangles(Camera.Parameters params, Rect activeArray, Size previewSize) {
        Preconditions.checkNotNull(params, "params must not be null");
        Preconditions.checkNotNull(activeArray, "activeArray must not be null");
        Preconditions.checkNotNull(previewSize, "previewSize must not be null");
        return ParameterUtils.getAvailableCropRectangles(params, activeArray, previewSize);
    }

    private static final List<Rect> $$robo$$android_hardware_camera2_legacy_ParameterUtils$getAvailableCropRectangles(Camera.Parameters params, Rect activeArray, Size streamSize) {
        Preconditions.checkNotNull(params, "params must not be null");
        Preconditions.checkNotNull(activeArray, "activeArray must not be null");
        Preconditions.checkNotNull(streamSize, "streamSize must not be null");
        Rect unzoomedStreamCrop = ParameterUtils.getPreviewCropRectangleUnzoomed(activeArray, streamSize);
        if (!params.isZoomSupported()) {
            return new ArrayList<Rect>(Arrays.asList(unzoomedStreamCrop));
        }
        ArrayList<Rect> zoomCropRectangles = new ArrayList<Rect>(params.getMaxZoom() + 1);
        Matrix scaleMatrix = new Matrix();
        RectF scaledRect = new RectF();
        for (int zoom : params.getZoomRatios()) {
            float shrinkRatio = 100.0f / (float)zoom;
            ParamsUtils.convertRectF(unzoomedStreamCrop, scaledRect);
            scaleMatrix.setScale(shrinkRatio, shrinkRatio, activeArray.exactCenterX(), activeArray.exactCenterY());
            scaleMatrix.mapRect(scaledRect);
            Rect intRect = ParamsUtils.createRect(scaledRect);
            zoomCropRectangles.add(intRect);
        }
        return zoomCropRectangles;
    }

    private static final float $$robo$$android_hardware_camera2_legacy_ParameterUtils$getMaxZoomRatio(Camera.Parameters params) {
        if (!params.isZoomSupported()) {
            return 1.0f;
        }
        List<Integer> zoomRatios = params.getZoomRatios();
        int zoom = zoomRatios.get(zoomRatios.size() - 1);
        float zoomRatio = (float)zoom * 1.0f / 100.0f;
        return zoomRatio;
    }

    private static final SizeF $$robo$$android_hardware_camera2_legacy_ParameterUtils$getZoomRatio(Size activeArraySize, Size cropSize) {
        Preconditions.checkNotNull(activeArraySize, "activeArraySize must not be null");
        Preconditions.checkNotNull(cropSize, "cropSize must not be null");
        Preconditions.checkArgumentPositive(cropSize.getWidth(), "cropSize.width must be positive");
        Preconditions.checkArgumentPositive(cropSize.getHeight(), "cropSize.height must be positive");
        float zoomRatioWidth = (float)activeArraySize.getWidth() * 1.0f / (float)cropSize.getWidth();
        float zoomRatioHeight = (float)activeArraySize.getHeight() * 1.0f / (float)cropSize.getHeight();
        return new SizeF(zoomRatioWidth, zoomRatioHeight);
    }

    private static final ZoomData $$robo$$android_hardware_camera2_legacy_ParameterUtils$convertScalerCropRegion(Rect activeArraySize, Rect cropRegion, Size previewSize, Camera.Parameters params) {
        Rect activeArraySizeOnly = new Rect(0, 0, activeArraySize.width(), activeArraySize.height());
        Rect userCropRegion = cropRegion;
        if (userCropRegion == null) {
            userCropRegion = activeArraySizeOnly;
        }
        if (VERBOSE) {
            Log.v("ParameterUtils", "convertScalerCropRegion - user crop region was " + userCropRegion);
        }
        Rect reportedCropRegion = new Rect();
        Rect previewCropRegion = new Rect();
        int zoomIdx = ParameterUtils.getClosestAvailableZoomCrop(params, activeArraySizeOnly, previewSize, userCropRegion, reportedCropRegion, previewCropRegion);
        if (VERBOSE) {
            Log.v("ParameterUtils", "convertScalerCropRegion - zoom calculated to: zoomIndex = " + zoomIdx + ", reported crop region = " + reportedCropRegion + ", preview crop region = " + previewCropRegion);
        }
        return new ZoomData(zoomIdx, previewCropRegion, reportedCropRegion);
    }

    private static final MeteringData $$robo$$android_hardware_camera2_legacy_ParameterUtils$convertMeteringRectangleToLegacy(Rect activeArray, MeteringRectangle meteringRect, ZoomData zoomData) {
        Camera.Area meteringArea;
        Rect previewCrop = zoomData.previewCrop;
        float scaleW = 2000.0f / (float)previewCrop.width();
        float scaleH = 2000.0f / (float)previewCrop.height();
        Matrix transform = new Matrix();
        transform.setTranslate(-previewCrop.left, -previewCrop.top);
        transform.postScale(scaleW, scaleH);
        transform.postTranslate(-1000.0f, -1000.0f);
        Rect normalizedRegionUnbounded = ParamsUtils.mapRect(transform, meteringRect.getRect());
        Rect normalizedIntersected = new Rect(normalizedRegionUnbounded);
        if (!normalizedIntersected.intersect(NORMALIZED_RECTANGLE_DEFAULT)) {
            Log.w("ParameterUtils", "convertMeteringRectangleToLegacy - metering rectangle too small, no metering will be done");
            normalizedIntersected.set(RECTANGLE_EMPTY);
            meteringArea = new Camera.Area(RECTANGLE_EMPTY, 0);
        } else {
            meteringArea = new Camera.Area(normalizedIntersected, meteringRect.getMeteringWeight());
        }
        Rect previewMetering = meteringRect.getRect();
        if (!previewMetering.intersect(previewCrop)) {
            previewMetering.set(RECTANGLE_EMPTY);
        }
        Camera.Area normalizedAreaUnbounded = new Camera.Area(normalizedRegionUnbounded, meteringRect.getMeteringWeight());
        WeightedRectangle reportedMeteringRect = ParameterUtils.convertCameraAreaToActiveArrayRectangle(activeArray, zoomData, normalizedAreaUnbounded, false);
        Rect reportedMetering = reportedMeteringRect.rect;
        if (VERBOSE) {
            Log.v("ParameterUtils", String.format("convertMeteringRectangleToLegacy - activeArray = %s, meteringRect = %s, previewCrop = %s, meteringArea = %s, previewMetering = %s, reportedMetering = %s, normalizedRegionUnbounded = %s", activeArray, meteringRect, previewCrop, ParameterUtils.stringFromArea(meteringArea), previewMetering, reportedMetering, normalizedRegionUnbounded));
        }
        return new MeteringData(meteringArea, previewMetering, reportedMetering);
    }

    private static final WeightedRectangle $$robo$$android_hardware_camera2_legacy_ParameterUtils$convertCameraAreaToActiveArrayRectangle(Rect activeArray, ZoomData zoomData, Camera.Area area) {
        return ParameterUtils.convertCameraAreaToActiveArrayRectangle(activeArray, zoomData, area, true);
    }

    private static final Face $$robo$$android_hardware_camera2_legacy_ParameterUtils$convertFaceFromLegacy(Camera.Face face, Rect activeArray, ZoomData zoomData) {
        Face api2Face;
        Preconditions.checkNotNull(face, "face must not be null");
        Camera.Area fakeArea = new Camera.Area(face.rect, 1);
        WeightedRectangle faceRect = ParameterUtils.convertCameraAreaToActiveArrayRectangle(activeArray, zoomData, fakeArea);
        Point leftEye = face.leftEye;
        Point rightEye = face.rightEye;
        Point mouth = face.mouth;
        if (leftEye != null && rightEye != null && mouth != null) {
            leftEye = ParameterUtils.convertCameraPointToActiveArrayPoint(activeArray, zoomData, leftEye, true);
            rightEye = ParameterUtils.convertCameraPointToActiveArrayPoint(activeArray, zoomData, leftEye, true);
            mouth = ParameterUtils.convertCameraPointToActiveArrayPoint(activeArray, zoomData, leftEye, true);
            api2Face = faceRect.toFace(face.id, leftEye, rightEye, mouth);
        } else {
            api2Face = faceRect.toFace();
        }
        return api2Face;
    }

    private static final Point $$robo$$android_hardware_camera2_legacy_ParameterUtils$convertCameraPointToActiveArrayPoint(Rect activeArray, ZoomData zoomData, Point point, boolean usePreviewCrop) {
        Rect pointedRect = new Rect(point.x, point.y, point.x, point.y);
        Camera.Area pointedArea = new Camera.Area(pointedRect, 1);
        WeightedRectangle adjustedRect = ParameterUtils.convertCameraAreaToActiveArrayRectangle(activeArray, zoomData, pointedArea, usePreviewCrop);
        Point transformedPoint = new Point(adjustedRect.rect.left, adjustedRect.rect.top);
        return transformedPoint;
    }

    private static final WeightedRectangle $$robo$$android_hardware_camera2_legacy_ParameterUtils$convertCameraAreaToActiveArrayRectangle(Rect activeArray, ZoomData zoomData, Camera.Area area, boolean usePreviewCrop) {
        int weight;
        Rect previewCrop = zoomData.previewCrop;
        Rect reportedCrop = zoomData.reportedCrop;
        float scaleW = (float)previewCrop.width() * 1.0f / 2000.0f;
        float scaleH = (float)previewCrop.height() * 1.0f / 2000.0f;
        Matrix transform = new Matrix();
        transform.setTranslate(1000.0f, 1000.0f);
        transform.postScale(scaleW, scaleH);
        transform.postTranslate(previewCrop.left, previewCrop.top);
        Rect cropToIntersectAgainst = usePreviewCrop ? previewCrop : reportedCrop;
        Rect reportedMetering = ParamsUtils.mapRect(transform, area.rect);
        if (!reportedMetering.intersect(cropToIntersectAgainst)) {
            reportedMetering.set(RECTANGLE_EMPTY);
        }
        if ((weight = area.weight) < 0) {
            Log.w("ParameterUtils", "convertCameraAreaToMeteringRectangle - rectangle " + ParameterUtils.stringFromArea(area) + " has too small weight, clip to 0");
            weight = 0;
        }
        return new WeightedRectangle(reportedMetering, area.weight);
    }

    private void $$robo$$android_hardware_camera2_legacy_ParameterUtils$__constructor__() {
        throw new AssertionError();
    }

    static void __staticInitializer__() {
        NORMALIZED_RECTANGLE_DEFAULT = new Rect(-1000, -1000, 1000, 1000);
        CAMERA_AREA_DEFAULT = new Camera.Area(new Rect(NORMALIZED_RECTANGLE_DEFAULT), 1);
        RECTANGLE_EMPTY = new Rect(0, 0, 0, 0);
        VERBOSE = Log.isLoggable("ParameterUtils", 2);
    }

    public static Size convertSize(Camera.Size size) {
        return InvokeDynamicSupport.bootstrapStatic("convertSize", $$robo$$android_hardware_camera2_legacy_ParameterUtils$convertSize(android.hardware.Camera$Size ), 0, (Camera.Size)size);
    }

    public static List<Size> convertSizeList(List<Camera.Size> list) {
        return InvokeDynamicSupport.bootstrapStatic("convertSizeList", $$robo$$android_hardware_camera2_legacy_ParameterUtils$convertSizeList(java.util.List<android.hardware.Camera$Size> ), 0, list);
    }

    public static Size[] convertSizeListToArray(List<Camera.Size> list) {
        return InvokeDynamicSupport.bootstrapStatic("convertSizeListToArray", $$robo$$android_hardware_camera2_legacy_ParameterUtils$convertSizeListToArray(java.util.List<android.hardware.Camera$Size> ), 0, list);
    }

    public static boolean containsSize(List<Camera.Size> list, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("containsSize", $$robo$$android_hardware_camera2_legacy_ParameterUtils$containsSize(java.util.List<android.hardware.Camera$Size> int int ), 0, list, (int)n, (int)n2);
    }

    public static Size getLargestSupportedJpegSizeByArea(Camera.Parameters parameters) {
        return InvokeDynamicSupport.bootstrapStatic("getLargestSupportedJpegSizeByArea", $$robo$$android_hardware_camera2_legacy_ParameterUtils$getLargestSupportedJpegSizeByArea(android.hardware.Camera$Parameters ), 0, (Camera.Parameters)parameters);
    }

    public static String stringFromArea(Camera.Area area) {
        return InvokeDynamicSupport.bootstrapStatic("stringFromArea", $$robo$$android_hardware_camera2_legacy_ParameterUtils$stringFromArea(android.hardware.Camera$Area ), 0, (Camera.Area)area);
    }

    public static String stringFromAreaList(List<Camera.Area> list) {
        return InvokeDynamicSupport.bootstrapStatic("stringFromAreaList", $$robo$$android_hardware_camera2_legacy_ParameterUtils$stringFromAreaList(java.util.List<android.hardware.Camera$Area> ), 0, list);
    }

    public static int getClosestAvailableZoomCrop(Camera.Parameters parameters, Rect rect, Size size, Rect rect2, Rect rect3, Rect rect4) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getClosestAvailableZoomCrop", $$robo$$android_hardware_camera2_legacy_ParameterUtils$getClosestAvailableZoomCrop(android.hardware.Camera$Parameters android.graphics.Rect android.util.Size android.graphics.Rect android.graphics.Rect android.graphics.Rect ), 0, (Camera.Parameters)parameters, (Rect)rect, (Size)size, (Rect)rect2, (Rect)rect3, (Rect)rect4);
    }

    private static Rect getPreviewCropRectangleUnzoomed(Rect rect, Size size) {
        return InvokeDynamicSupport.bootstrapStatic("getPreviewCropRectangleUnzoomed", $$robo$$android_hardware_camera2_legacy_ParameterUtils$getPreviewCropRectangleUnzoomed(android.graphics.Rect android.util.Size ), 0, (Rect)rect, (Size)size);
    }

    private static Rect shrinkToSameAspectRatioCentered(Rect rect, Rect rect2) {
        return InvokeDynamicSupport.bootstrapStatic("shrinkToSameAspectRatioCentered", $$robo$$android_hardware_camera2_legacy_ParameterUtils$shrinkToSameAspectRatioCentered(android.graphics.Rect android.graphics.Rect ), 0, (Rect)rect, (Rect)rect2);
    }

    public static List<Rect> getAvailableZoomCropRectangles(Camera.Parameters parameters, Rect rect) {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableZoomCropRectangles", $$robo$$android_hardware_camera2_legacy_ParameterUtils$getAvailableZoomCropRectangles(android.hardware.Camera$Parameters android.graphics.Rect ), 0, (Camera.Parameters)parameters, (Rect)rect);
    }

    public static List<Rect> getAvailablePreviewZoomCropRectangles(Camera.Parameters parameters, Rect rect, Size size) {
        return InvokeDynamicSupport.bootstrapStatic("getAvailablePreviewZoomCropRectangles", $$robo$$android_hardware_camera2_legacy_ParameterUtils$getAvailablePreviewZoomCropRectangles(android.hardware.Camera$Parameters android.graphics.Rect android.util.Size ), 0, (Camera.Parameters)parameters, (Rect)rect, (Size)size);
    }

    private static List<Rect> getAvailableCropRectangles(Camera.Parameters parameters, Rect rect, Size size) {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableCropRectangles", $$robo$$android_hardware_camera2_legacy_ParameterUtils$getAvailableCropRectangles(android.hardware.Camera$Parameters android.graphics.Rect android.util.Size ), 0, (Camera.Parameters)parameters, (Rect)rect, (Size)size);
    }

    public static float getMaxZoomRatio(Camera.Parameters parameters) {
        return (float)InvokeDynamicSupport.bootstrapStatic("getMaxZoomRatio", $$robo$$android_hardware_camera2_legacy_ParameterUtils$getMaxZoomRatio(android.hardware.Camera$Parameters ), 0, (Camera.Parameters)parameters);
    }

    private static SizeF getZoomRatio(Size size, Size size2) {
        return InvokeDynamicSupport.bootstrapStatic("getZoomRatio", $$robo$$android_hardware_camera2_legacy_ParameterUtils$getZoomRatio(android.util.Size android.util.Size ), 0, (Size)size, (Size)size2);
    }

    public static ZoomData convertScalerCropRegion(Rect rect, Rect rect2, Size size, Camera.Parameters parameters) {
        return InvokeDynamicSupport.bootstrapStatic("convertScalerCropRegion", $$robo$$android_hardware_camera2_legacy_ParameterUtils$convertScalerCropRegion(android.graphics.Rect android.graphics.Rect android.util.Size android.hardware.Camera$Parameters ), 0, (Rect)rect, (Rect)rect2, (Size)size, (Camera.Parameters)parameters);
    }

    public static MeteringData convertMeteringRectangleToLegacy(Rect rect, MeteringRectangle meteringRectangle, ZoomData zoomData) {
        return InvokeDynamicSupport.bootstrapStatic("convertMeteringRectangleToLegacy", $$robo$$android_hardware_camera2_legacy_ParameterUtils$convertMeteringRectangleToLegacy(android.graphics.Rect android.hardware.camera2.params.MeteringRectangle android.hardware.camera2.legacy.ParameterUtils$ZoomData ), 0, (Rect)rect, (MeteringRectangle)meteringRectangle, (ZoomData)zoomData);
    }

    public static WeightedRectangle convertCameraAreaToActiveArrayRectangle(Rect rect, ZoomData zoomData, Camera.Area area) {
        return InvokeDynamicSupport.bootstrapStatic("convertCameraAreaToActiveArrayRectangle", $$robo$$android_hardware_camera2_legacy_ParameterUtils$convertCameraAreaToActiveArrayRectangle(android.graphics.Rect android.hardware.camera2.legacy.ParameterUtils$ZoomData android.hardware.Camera$Area ), 0, (Rect)rect, (ZoomData)zoomData, (Camera.Area)area);
    }

    public static Face convertFaceFromLegacy(Camera.Face face, Rect rect, ZoomData zoomData) {
        return InvokeDynamicSupport.bootstrapStatic("convertFaceFromLegacy", $$robo$$android_hardware_camera2_legacy_ParameterUtils$convertFaceFromLegacy(android.hardware.Camera$Face android.graphics.Rect android.hardware.camera2.legacy.ParameterUtils$ZoomData ), 0, (Camera.Face)face, (Rect)rect, (ZoomData)zoomData);
    }

    private static Point convertCameraPointToActiveArrayPoint(Rect rect, ZoomData zoomData, Point point, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("convertCameraPointToActiveArrayPoint", $$robo$$android_hardware_camera2_legacy_ParameterUtils$convertCameraPointToActiveArrayPoint(android.graphics.Rect android.hardware.camera2.legacy.ParameterUtils$ZoomData android.graphics.Point boolean ), 0, (Rect)rect, (ZoomData)zoomData, (Point)point, (boolean)bl);
    }

    private static WeightedRectangle convertCameraAreaToActiveArrayRectangle(Rect rect, ZoomData zoomData, Camera.Area area, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("convertCameraAreaToActiveArrayRectangle", $$robo$$android_hardware_camera2_legacy_ParameterUtils$convertCameraAreaToActiveArrayRectangle(android.graphics.Rect android.hardware.camera2.legacy.ParameterUtils$ZoomData android.hardware.Camera$Area boolean ), 0, (Rect)rect, (ZoomData)zoomData, (Camera.Area)area, (boolean)bl);
    }

    private void __constructor__() {
        this.$$robo$$android_hardware_camera2_legacy_ParameterUtils$__constructor__();
    }

    private ParameterUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_ParameterUtils$__constructor__(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(ParameterUtils.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParameterUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class WeightedRectangle
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Rect rect;
        public int weight;

        private void $$robo$$android_hardware_camera2_legacy_ParameterUtils_WeightedRectangle$__constructor__(Rect rect, int weight) {
            this.rect = Preconditions.checkNotNull(rect, "rect must not be null");
            this.weight = weight;
        }

        private final MeteringRectangle $$robo$$android_hardware_camera2_legacy_ParameterUtils_WeightedRectangle$toMetering() {
            int weight = WeightedRectangle.clip(this.weight, 0, 1000, this.rect, "weight");
            int x = WeightedRectangle.clipLower(this.rect.left, 0, this.rect, "left");
            int y = WeightedRectangle.clipLower(this.rect.top, 0, this.rect, "top");
            int w = WeightedRectangle.clipLower(this.rect.width(), 0, this.rect, "width");
            int h = WeightedRectangle.clipLower(this.rect.height(), 0, this.rect, "height");
            return new MeteringRectangle(x, y, w, h, weight);
        }

        private final Face $$robo$$android_hardware_camera2_legacy_ParameterUtils_WeightedRectangle$toFace(int id2, Point leftEyePosition, Point rightEyePosition, Point mouthPosition) {
            int idSafe = WeightedRectangle.clipLower(id2, 0, this.rect, "id");
            int score = WeightedRectangle.clip(this.weight, 1, 100, this.rect, "score");
            return new Face(this.rect, score, idSafe, leftEyePosition, rightEyePosition, mouthPosition);
        }

        private final Face $$robo$$android_hardware_camera2_legacy_ParameterUtils_WeightedRectangle$toFace() {
            int score = WeightedRectangle.clip(this.weight, 1, 100, this.rect, "score");
            return new Face(this.rect, score);
        }

        private static final int $$robo$$android_hardware_camera2_legacy_ParameterUtils_WeightedRectangle$clipLower(int value, int lo, Rect rect, String name) {
            return WeightedRectangle.clip(value, lo, Integer.MAX_VALUE, rect, name);
        }

        private static final int $$robo$$android_hardware_camera2_legacy_ParameterUtils_WeightedRectangle$clip(int value, int lo, int hi, Rect rect, String name) {
            if (value < lo) {
                Log.w("ParameterUtils", "toMetering - Rectangle " + rect + " " + name + " too small, clip to " + lo);
                value = lo;
            } else if (value > hi) {
                Log.w("ParameterUtils", "toMetering - Rectangle " + rect + " " + name + " too small, clip to " + hi);
                value = hi;
            }
            return value;
        }

        private void __constructor__(Rect rect, int n) {
            this.$$robo$$android_hardware_camera2_legacy_ParameterUtils_WeightedRectangle$__constructor__(rect, n);
        }

        public WeightedRectangle(Rect rect, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_ParameterUtils_WeightedRectangle$__constructor__(android.graphics.Rect int ), 0, this, rect, n);
        }

        public MeteringRectangle toMetering() {
            return InvokeDynamicSupport.bootstrap("toMetering", $$robo$$android_hardware_camera2_legacy_ParameterUtils_WeightedRectangle$toMetering(), 0, this);
        }

        public Face toFace(int n, Point point, Point point2, Point point3) {
            return InvokeDynamicSupport.bootstrap("toFace", $$robo$$android_hardware_camera2_legacy_ParameterUtils_WeightedRectangle$toFace(int android.graphics.Point android.graphics.Point android.graphics.Point ), 0, this, n, point, point2, point3);
        }

        public Face toFace() {
            return InvokeDynamicSupport.bootstrap("toFace", $$robo$$android_hardware_camera2_legacy_ParameterUtils_WeightedRectangle$toFace(), 0, this);
        }

        private static int clipLower(int n, int n2, Rect rect, String string2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("clipLower", $$robo$$android_hardware_camera2_legacy_ParameterUtils_WeightedRectangle$clipLower(int int android.graphics.Rect java.lang.String ), 0, (int)n, (int)n2, (Rect)rect, (String)string2);
        }

        private static int clip(int n, int n2, int n3, Rect rect, String string2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("clip", $$robo$$android_hardware_camera2_legacy_ParameterUtils_WeightedRectangle$clip(int int int android.graphics.Rect java.lang.String ), 0, (int)n, (int)n2, (int)n3, (Rect)rect, (String)string2);
        }

        public /* synthetic */ WeightedRectangle() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WeightedRectangle)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class MeteringData
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Camera.Area meteringArea;
        public Rect previewMetering;
        public Rect reportedMetering;

        private void $$robo$$android_hardware_camera2_legacy_ParameterUtils_MeteringData$__constructor__(Camera.Area meteringArea, Rect previewMetering, Rect reportedMetering) {
            this.meteringArea = meteringArea;
            this.previewMetering = previewMetering;
            this.reportedMetering = reportedMetering;
        }

        private void __constructor__(Camera.Area area, Rect rect, Rect rect2) {
            this.$$robo$$android_hardware_camera2_legacy_ParameterUtils_MeteringData$__constructor__(area, rect, rect2);
        }

        public MeteringData(Camera.Area area, Rect rect, Rect rect2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_ParameterUtils_MeteringData$__constructor__(android.hardware.Camera$Area android.graphics.Rect android.graphics.Rect ), 0, this, area, rect, rect2);
        }

        public /* synthetic */ MeteringData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MeteringData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ZoomData
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int zoomIndex;
        public Rect previewCrop;
        public Rect reportedCrop;

        private void $$robo$$android_hardware_camera2_legacy_ParameterUtils_ZoomData$__constructor__(int zoomIndex, Rect previewCrop, Rect reportedCrop) {
            this.zoomIndex = zoomIndex;
            this.previewCrop = previewCrop;
            this.reportedCrop = reportedCrop;
        }

        private void __constructor__(int n, Rect rect, Rect rect2) {
            this.$$robo$$android_hardware_camera2_legacy_ParameterUtils_ZoomData$__constructor__(n, rect, rect2);
        }

        public ZoomData(int n, Rect rect, Rect rect2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_ParameterUtils_ZoomData$__constructor__(int android.graphics.Rect android.graphics.Rect ), 0, this, n, rect, rect2);
        }

        public /* synthetic */ ZoomData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ZoomData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

