/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.legacy.BurstHolder;
import android.hardware.camera2.legacy.CameraDeviceState;
import android.hardware.camera2.legacy.CaptureCollector;
import android.hardware.camera2.legacy.GLThreadManager;
import android.hardware.camera2.legacy.LegacyCameraDevice;
import android.hardware.camera2.legacy.LegacyExceptionUtils;
import android.hardware.camera2.legacy.LegacyFaceDetectMapper;
import android.hardware.camera2.legacy.LegacyFocusStateMapper;
import android.hardware.camera2.legacy.LegacyMetadataMapper;
import android.hardware.camera2.legacy.LegacyRequest;
import android.hardware.camera2.legacy.LegacyResultMapper;
import android.hardware.camera2.legacy.ParameterUtils;
import android.hardware.camera2.legacy.RequestHandlerThread;
import android.hardware.camera2.legacy.RequestHolder;
import android.hardware.camera2.legacy.RequestQueue;
import android.hardware.camera2.utils.LongParcelable;
import android.hardware.camera2.utils.SizeAreaComparator;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import android.util.MutableLong;
import android.util.Pair;
import android.util.Size;
import android.view.Surface;
import com.android.internal.util.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RequestThreadManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String TAG;
    private int mCameraId;
    private RequestHandlerThread mRequestThread;
    private static boolean DEBUG;
    private static boolean VERBOSE;
    private Camera mCamera;
    private CameraCharacteristics mCharacteristics;
    private CameraDeviceState mDeviceState;
    private CaptureCollector mCaptureCollector;
    private LegacyFocusStateMapper mFocusStateMapper;
    private LegacyFaceDetectMapper mFaceDetectMapper;
    private static int MSG_CONFIGURE_OUTPUTS = 1;
    private static int MSG_SUBMIT_CAPTURE_REQUEST = 2;
    private static int MSG_CLEANUP = 3;
    private static int MAX_IN_FLIGHT_REQUESTS = 2;
    private static int PREVIEW_FRAME_TIMEOUT = 1000;
    private static int JPEG_FRAME_TIMEOUT = 3000;
    private static int REQUEST_COMPLETE_TIMEOUT = 3000;
    private static float ASPECT_RATIO_TOLERANCE = 0.01f;
    private boolean mPreviewRunning;
    private List<Surface> mPreviewOutputs;
    private List<Surface> mCallbackOutputs;
    private GLThreadManager mGLThreadManager;
    private SurfaceTexture mPreviewTexture;
    private Camera.Parameters mParams;
    private List<Long> mJpegSurfaceIds;
    private Size mIntermediateBufferSize;
    private RequestQueue mRequestQueue;
    private LegacyRequest mLastRequest;
    private SurfaceTexture mDummyTexture;
    private Surface mDummySurface;
    private Object mIdleLock;
    private FpsCounter mPrevCounter;
    private FpsCounter mRequestCounter;
    private static boolean USE_BLOB_FORMAT_OVERRIDE = true;
    private Camera.ErrorCallback mErrorCallback;
    private ConditionVariable mReceivedJpeg;
    private Camera.PictureCallback mJpegCallback;
    private Camera.ShutterCallback mJpegShutterCallback;
    private SurfaceTexture.OnFrameAvailableListener mPreviewCallback;
    private Handler.Callback mRequestHandlerCb;

    private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager$createDummySurface() {
        if (this.mDummyTexture == null || this.mDummySurface == null) {
            this.mDummyTexture = new SurfaceTexture(0);
            this.mDummyTexture.setDefaultBufferSize(640, 480);
            this.mDummySurface = new Surface(this.mDummyTexture);
        }
    }

    private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager$stopPreview() {
        if (VERBOSE) {
            Log.v(this.TAG, "stopPreview - preview running? " + this.mPreviewRunning);
        }
        if (this.mPreviewRunning) {
            this.mCamera.stopPreview();
            this.mPreviewRunning = false;
        }
    }

    private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager$startPreview() {
        if (VERBOSE) {
            Log.v(this.TAG, "startPreview - preview running? " + this.mPreviewRunning);
        }
        if (!this.mPreviewRunning) {
            this.mCamera.startPreview();
            this.mPreviewRunning = true;
        }
    }

    private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager$doJpegCapturePrepare(RequestHolder request) throws IOException {
        if (DEBUG) {
            Log.d(this.TAG, "doJpegCapturePrepare - preview running? " + this.mPreviewRunning);
        }
        if (!this.mPreviewRunning) {
            if (DEBUG) {
                Log.d(this.TAG, "doJpegCapture - create fake surface");
            }
            this.createDummySurface();
            this.mCamera.setPreviewTexture(this.mDummyTexture);
            this.startPreview();
        }
    }

    private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager$doJpegCapture(RequestHolder request) {
        if (DEBUG) {
            Log.d(this.TAG, "doJpegCapturePrepare");
        }
        this.mCamera.takePicture(this.mJpegShutterCallback, null, this.mJpegCallback);
        this.mPreviewRunning = false;
    }

    private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager$doPreviewCapture(RequestHolder request) throws IOException {
        if (VERBOSE) {
            Log.v(this.TAG, "doPreviewCapture - preview running? " + this.mPreviewRunning);
        }
        if (this.mPreviewRunning) {
            return;
        }
        if (this.mPreviewTexture == null) {
            throw new IllegalStateException("Preview capture called with no preview surfaces configured.");
        }
        this.mPreviewTexture.setDefaultBufferSize(this.mIntermediateBufferSize.getWidth(), this.mIntermediateBufferSize.getHeight());
        this.mCamera.setPreviewTexture(this.mPreviewTexture);
        this.startPreview();
    }

    private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager$configureOutputs(Collection<Surface> outputs) {
        if (DEBUG) {
            String outputsStr = outputs == null ? "null" : outputs.size() + " surfaces";
            Log.d(this.TAG, "configureOutputs with " + outputsStr);
        }
        this.stopPreview();
        try {
            this.mCamera.setPreviewTexture(null);
        }
        catch (IOException e) {
            Log.w(this.TAG, "Failed to clear prior SurfaceTexture, may cause GL deadlock: ", e);
        }
        if (this.mGLThreadManager != null) {
            this.mGLThreadManager.waitUntilStarted();
            this.mGLThreadManager.ignoreNewFrames();
            this.mGLThreadManager.waitUntilIdle();
        }
        this.resetJpegSurfaceFormats(this.mCallbackOutputs);
        this.mPreviewOutputs.clear();
        this.mCallbackOutputs.clear();
        this.mJpegSurfaceIds.clear();
        this.mPreviewTexture = null;
        int facing = this.mCharacteristics.get(CameraCharacteristics.LENS_FACING);
        int orientation = this.mCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        if (outputs != null) {
            for (Surface s : outputs) {
                try {
                    int format = LegacyCameraDevice.detectSurfaceType(s);
                    LegacyCameraDevice.setSurfaceOrientation(s, facing, orientation);
                    switch (format) {
                        case 33: {
                            LegacyCameraDevice.setSurfaceFormat(s, 1);
                            this.mJpegSurfaceIds.add(LegacyCameraDevice.getSurfaceId(s));
                            this.mCallbackOutputs.add(s);
                            break;
                        }
                        default: {
                            this.mPreviewOutputs.add(s);
                            break;
                        }
                    }
                }
                catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
                    Log.w(this.TAG, "Surface abandoned, skipping...", e);
                }
            }
        }
        try {
            this.mParams = this.mCamera.getParameters();
        }
        catch (RuntimeException e) {
            Log.e(this.TAG, "Received device exception: ", e);
            this.mDeviceState.setError(1);
            return;
        }
        List<int[]> supportedFpsRanges = this.mParams.getSupportedPreviewFpsRange();
        int[] bestRange = this.getPhotoPreviewFpsRange(supportedFpsRanges);
        if (DEBUG) {
            Log.d(this.TAG, "doPreviewCapture - Selected range [" + bestRange[0] + "," + bestRange[1] + "]");
        }
        this.mParams.setPreviewFpsRange(bestRange[0], bestRange[1]);
        if (this.mPreviewOutputs.size() > 0) {
            ArrayList<Size> outputSizes = new ArrayList<Size>(outputs.size());
            for (Surface s : this.mPreviewOutputs) {
                try {
                    Size size = LegacyCameraDevice.getSurfaceSize(s);
                    outputSizes.add(size);
                }
                catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
                    Log.w(this.TAG, "Surface abandoned, skipping...", e);
                }
            }
            Size largestOutput = SizeAreaComparator.findLargestByArea(outputSizes);
            Size largestJpegDimen = ParameterUtils.getLargestSupportedJpegSizeByArea(this.mParams);
            List<Size> supportedPreviewSizes = ParameterUtils.convertSizeList(this.mParams.getSupportedPreviewSizes());
            long largestOutputArea = (long)largestOutput.getHeight() * (long)largestOutput.getWidth();
            Size bestPreviewDimen = SizeAreaComparator.findLargestByArea(supportedPreviewSizes);
            for (Size s : supportedPreviewSizes) {
                long currArea = s.getWidth() * s.getHeight();
                long bestArea = bestPreviewDimen.getWidth() * bestPreviewDimen.getHeight();
                if (!RequestThreadManager.checkAspectRatiosMatch(largestJpegDimen, s) || currArea >= bestArea || currArea < largestOutputArea) continue;
                bestPreviewDimen = s;
            }
            this.mIntermediateBufferSize = bestPreviewDimen;
            this.mParams.setPreviewSize(this.mIntermediateBufferSize.getWidth(), this.mIntermediateBufferSize.getHeight());
            if (DEBUG) {
                Log.d(this.TAG, "Intermediate buffer selected with dimens: " + bestPreviewDimen.toString());
            }
        } else {
            this.mIntermediateBufferSize = null;
            if (DEBUG) {
                Log.d(this.TAG, "No Intermediate buffer selected, no preview outputs were configured");
            }
        }
        Size smallestSupportedJpegSize = this.calculatePictureSize(this.mCallbackOutputs, this.mParams);
        if (smallestSupportedJpegSize != null) {
            Log.i(this.TAG, "configureOutputs - set take picture size to " + smallestSupportedJpegSize);
            this.mParams.setPictureSize(smallestSupportedJpegSize.getWidth(), smallestSupportedJpegSize.getHeight());
        }
        if (this.mGLThreadManager == null) {
            this.mGLThreadManager = new GLThreadManager(this.mCameraId, facing, this.mDeviceState);
            this.mGLThreadManager.start();
        }
        this.mGLThreadManager.waitUntilStarted();
        this.mGLThreadManager.setConfigurationAndWait(this.mPreviewOutputs, this.mCaptureCollector);
        this.mGLThreadManager.allowNewFrames();
        this.mPreviewTexture = this.mGLThreadManager.getCurrentSurfaceTexture();
        if (this.mPreviewTexture != null) {
            this.mPreviewTexture.setOnFrameAvailableListener(this.mPreviewCallback);
        }
        this.mCamera.setParameters(this.mParams);
    }

    private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager$resetJpegSurfaceFormats(Collection<Surface> surfaces) {
        if (surfaces == null) {
            return;
        }
        for (Surface s : surfaces) {
            try {
                LegacyCameraDevice.setSurfaceFormat(s, 33);
            }
            catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
                Log.w(this.TAG, "Surface abandoned, skipping...", e);
            }
        }
    }

    private final Size $$robo$$android_hardware_camera2_legacy_RequestThreadManager$calculatePictureSize(Collection<Surface> callbackOutputs, Camera.Parameters params) {
        ArrayList<Size> configuredJpegSizes = new ArrayList<Size>();
        for (Surface callbackSurface : callbackOutputs) {
            try {
                if (!LegacyCameraDevice.containsSurfaceId(callbackSurface, this.mJpegSurfaceIds)) continue;
                Size jpegSize = LegacyCameraDevice.getSurfaceSize(callbackSurface);
                configuredJpegSizes.add(jpegSize);
            }
            catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
                Log.w(this.TAG, "Surface abandoned, skipping...", e);
            }
        }
        if (!configuredJpegSizes.isEmpty()) {
            int maxConfiguredJpegWidth = -1;
            int maxConfiguredJpegHeight = -1;
            for (Size jpegSize : configuredJpegSizes) {
                maxConfiguredJpegWidth = jpegSize.getWidth() > maxConfiguredJpegWidth ? jpegSize.getWidth() : maxConfiguredJpegWidth;
                maxConfiguredJpegHeight = jpegSize.getHeight() > maxConfiguredJpegHeight ? jpegSize.getHeight() : maxConfiguredJpegHeight;
            }
            Size smallestBoundJpegSize = new Size(maxConfiguredJpegWidth, maxConfiguredJpegHeight);
            List<Size> supportedJpegSizes = ParameterUtils.convertSizeList(params.getSupportedPictureSizes());
            ArrayList<Size> candidateSupportedJpegSizes = new ArrayList<Size>();
            for (Size supportedJpegSize : supportedJpegSizes) {
                if (supportedJpegSize.getWidth() < maxConfiguredJpegWidth || supportedJpegSize.getHeight() < maxConfiguredJpegHeight) continue;
                candidateSupportedJpegSizes.add(supportedJpegSize);
            }
            if (candidateSupportedJpegSizes.isEmpty()) {
                throw new AssertionError((Object)("Could not find any supported JPEG sizes large enough to fit " + smallestBoundJpegSize));
            }
            Size smallestSupportedJpegSize = Collections.min(candidateSupportedJpegSizes, new SizeAreaComparator());
            if (!smallestSupportedJpegSize.equals(smallestBoundJpegSize)) {
                Log.w(this.TAG, String.format("configureOutputs - Will need to crop picture %s into smallest bound size %s", smallestSupportedJpegSize, smallestBoundJpegSize));
            }
            return smallestSupportedJpegSize;
        }
        return null;
    }

    private static final boolean $$robo$$android_hardware_camera2_legacy_RequestThreadManager$checkAspectRatiosMatch(Size a, Size b) {
        float bAspect;
        float aAspect = (float)a.getWidth() / (float)a.getHeight();
        return Math.abs(aAspect - (bAspect = (float)b.getWidth() / (float)b.getHeight())) < 0.01f;
    }

    private final int[] $$robo$$android_hardware_camera2_legacy_RequestThreadManager$getPhotoPreviewFpsRange(List<int[]> frameRates) {
        if (frameRates.size() == 0) {
            Log.e(this.TAG, "No supported frame rates returned!");
            return null;
        }
        int bestMin = 0;
        int bestMax = 0;
        int bestIndex = 0;
        int index = 0;
        for (int[] rate : frameRates) {
            int minFps = rate[0];
            int maxFps = rate[1];
            if (maxFps > bestMax || maxFps == bestMax && minFps > bestMin) {
                bestMin = minFps;
                bestMax = maxFps;
                bestIndex = index;
            }
            ++index;
        }
        return frameRates.get(bestIndex);
    }

    private void $$robo$$android_hardware_camera2_legacy_RequestThreadManager$__constructor__(int cameraId, Camera camera, CameraCharacteristics characteristics, CameraDeviceState deviceState) {
        String name;
        this.mPreviewRunning = false;
        this.mPreviewOutputs = new ArrayList<Surface>();
        this.mCallbackOutputs = new ArrayList<Surface>();
        this.mJpegSurfaceIds = new ArrayList<Long>();
        this.mRequestQueue = new RequestQueue(this.mJpegSurfaceIds);
        this.mLastRequest = null;
        this.mIdleLock = new Object();
        this.mPrevCounter = new FpsCounter("Incoming Preview");
        this.mRequestCounter = new FpsCounter("Incoming Requests");
        this.mErrorCallback = new Camera.ErrorCallback(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ RequestThreadManager this$0;

            private void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_1$__constructor__(RequestThreadManager requestThreadManager) {
            }

            private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_1$onError(int i, Camera camera) {
                Log.e(this.this$0.TAG, "Received error " + i + " from the Camera1 ErrorCallback");
                this.this$0.mDeviceState.setError(1);
            }

            private void __constructor__(RequestThreadManager requestThreadManager) {
                this.$$robo$$android_hardware_camera2_legacy_RequestThreadManager_1$__constructor__(requestThreadManager);
            }
            {
                this.this$0 = requestThreadManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_1$__constructor__(android.hardware.camera2.legacy.RequestThreadManager ), 0, this, requestThreadManager);
            }

            @Override
            public void onError(int n, Camera camera) {
                InvokeDynamicSupport.bootstrap("onError", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_1$onError(int android.hardware.Camera ), 0, this, n, camera);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mReceivedJpeg = new ConditionVariable(false);
        this.mJpegCallback = new Camera.PictureCallback(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ RequestThreadManager this$0;

            private void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_2$__constructor__(RequestThreadManager requestThreadManager) {
            }

            private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_2$onPictureTaken(byte[] data, Camera camera) {
                Log.i(this.this$0.TAG, "Received jpeg.");
                Pair<RequestHolder, Long> captureInfo = this.this$0.mCaptureCollector.jpegProduced();
                if (captureInfo == null || captureInfo.first == null) {
                    Log.e(this.this$0.TAG, "Dropping jpeg frame.");
                    return;
                }
                RequestHolder holder = (RequestHolder)captureInfo.first;
                long timestamp = (Long)captureInfo.second;
                for (Surface s : holder.getHolderTargets()) {
                    try {
                        if (!LegacyCameraDevice.containsSurfaceId(s, this.this$0.mJpegSurfaceIds)) continue;
                        Log.i(this.this$0.TAG, "Producing jpeg buffer...");
                        int totalSize = data.length + LegacyCameraDevice.nativeGetJpegFooterSize();
                        totalSize = totalSize + 3 & 0xFFFFFFFC;
                        LegacyCameraDevice.setNextTimestamp(s, timestamp);
                        LegacyCameraDevice.setSurfaceFormat(s, 1);
                        int dimen2 = (int)Math.ceil(Math.sqrt(totalSize));
                        dimen2 = dimen2 + 15 & 0xFFFFFFF0;
                        LegacyCameraDevice.setSurfaceDimens(s, dimen2, dimen2);
                        LegacyCameraDevice.produceFrame(s, data, dimen2, dimen2, 33);
                    }
                    catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
                        Log.w(this.this$0.TAG, "Surface abandoned, dropping frame. ", e);
                    }
                }
                this.this$0.mReceivedJpeg.open();
            }

            private void __constructor__(RequestThreadManager requestThreadManager) {
                this.$$robo$$android_hardware_camera2_legacy_RequestThreadManager_2$__constructor__(requestThreadManager);
            }
            {
                this.this$0 = requestThreadManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_2$__constructor__(android.hardware.camera2.legacy.RequestThreadManager ), 0, this, requestThreadManager);
            }

            @Override
            public void onPictureTaken(byte[] byArray, Camera camera) {
                InvokeDynamicSupport.bootstrap("onPictureTaken", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_2$onPictureTaken(byte[] android.hardware.Camera ), 0, this, byArray, camera);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mJpegShutterCallback = new Camera.ShutterCallback(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ RequestThreadManager this$0;

            private void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_3$__constructor__(RequestThreadManager requestThreadManager) {
            }

            private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_3$onShutter() {
                this.this$0.mCaptureCollector.jpegCaptured(SystemClock.elapsedRealtimeNanos());
            }

            private void __constructor__(RequestThreadManager requestThreadManager) {
                this.$$robo$$android_hardware_camera2_legacy_RequestThreadManager_3$__constructor__(requestThreadManager);
            }
            {
                this.this$0 = requestThreadManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_3$__constructor__(android.hardware.camera2.legacy.RequestThreadManager ), 0, this, requestThreadManager);
            }

            @Override
            public void onShutter() {
                InvokeDynamicSupport.bootstrap("onShutter", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_3$onShutter(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPreviewCallback = new SurfaceTexture.OnFrameAvailableListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ RequestThreadManager this$0;

            private void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_4$__constructor__(RequestThreadManager requestThreadManager) {
            }

            private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_4$onFrameAvailable(SurfaceTexture surfaceTexture) {
                if (DEBUG) {
                    this.this$0.mPrevCounter.countAndLog();
                }
                this.this$0.mGLThreadManager.queueNewFrame();
            }

            private void __constructor__(RequestThreadManager requestThreadManager) {
                this.$$robo$$android_hardware_camera2_legacy_RequestThreadManager_4$__constructor__(requestThreadManager);
            }
            {
                this.this$0 = requestThreadManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_4$__constructor__(android.hardware.camera2.legacy.RequestThreadManager ), 0, this, requestThreadManager);
            }

            @Override
            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                InvokeDynamicSupport.bootstrap("onFrameAvailable", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_4$onFrameAvailable(android.graphics.SurfaceTexture ), 0, this, surfaceTexture);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mRequestHandlerCb = new Handler.Callback(this){
            public transient /* synthetic */ Object __robo_data__;
            private boolean mCleanup;
            private LegacyResultMapper mMapper;
            /* synthetic */ RequestThreadManager this$0;

            private void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_5$__constructor__(RequestThreadManager requestThreadManager) {
                this.mCleanup = false;
                this.mMapper = new LegacyResultMapper();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            private final boolean $$robo$$android_hardware_camera2_legacy_RequestThreadManager_5$handleMessage(Message msg) {
                if (this.mCleanup) {
                    return true;
                }
                if (RequestThreadManager.access$500()) {
                    Log.d(RequestThreadManager.access$000(this.this$0), "Request thread handling message:" + msg.what);
                }
                startTime = 0L;
                if (RequestThreadManager.access$500()) {
                    startTime = SystemClock.elapsedRealtimeNanos();
                }
                switch (msg.what) {
                    case 1: {
                        config = (ConfigureHolder)msg.obj;
                        sizes = config.surfaces != null ? config.surfaces.size() : 0;
                        Log.i(RequestThreadManager.access$000(this.this$0), "Configure outputs: " + sizes + " surfaces configured.");
                        try {
                            success = RequestThreadManager.access$200(this.this$0).waitForEmpty(3000L, TimeUnit.MILLISECONDS);
                            if (!success) {
                                Log.e(RequestThreadManager.access$000(this.this$0), "Timed out while queueing configure request.");
                                RequestThreadManager.access$200(this.this$0).failAll();
                            }
                        }
                        catch (InterruptedException e) {
                            Log.e(RequestThreadManager.access$000(this.this$0), "Interrupted while waiting for requests to complete.");
                            RequestThreadManager.access$100(this.this$0).setError(1);
                            break;
                        }
                        RequestThreadManager.access$800(this.this$0, config.surfaces);
                        config.condition.open();
                        if (!RequestThreadManager.access$500()) break;
                        totalTime = SystemClock.elapsedRealtimeNanos() - startTime;
                        Log.d(RequestThreadManager.access$000(this.this$0), "Configure took " + totalTime + " ns");
                        break;
                    }
                    case 2: {
                        handler = RequestThreadManager.access$900(this.this$0).getHandler();
                        nextBurst = RequestThreadManager.access$1000(this.this$0).getNext();
                        if (nextBurst != null) ** GOTO lbl63
                        try {
                            success = RequestThreadManager.access$200(this.this$0).waitForEmpty(3000L, TimeUnit.MILLISECONDS);
                            if (!success) {
                                Log.e(RequestThreadManager.access$000(this.this$0), "Timed out while waiting for prior requests to complete.");
                                RequestThreadManager.access$200(this.this$0).failAll();
                            }
                        }
                        catch (InterruptedException e) {
                            Log.e(RequestThreadManager.access$000(this.this$0), "Interrupted while waiting for requests to complete: ", e);
                            RequestThreadManager.access$100(this.this$0).setError(1);
                            break;
                        }
                        e = RequestThreadManager.access$1100(this.this$0);
                        synchronized (e) {
                            nextBurst = RequestThreadManager.access$1000(this.this$0).getNext();
                            if (nextBurst == null) {
                                RequestThreadManager.access$100(this.this$0).setIdle();
                                break;
                            }
                        }
lbl63:
                        // 2 sources

                        if (nextBurst != null) {
                            handler.sendEmptyMessage(2);
                        }
                        requests = ((BurstHolder)nextBurst.first).produceRequestHolders((Long)nextBurst.second);
                        for (RequestHolder holder : requests) {
                            request = holder.getRequest();
                            paramsChanged = false;
                            if (RequestThreadManager.access$1200(this.this$0) == null || RequestThreadManager.access$1200((RequestThreadManager)this.this$0).captureRequest != request) {
                                previewSize = ParameterUtils.convertSize(RequestThreadManager.access$1300(this.this$0).getPreviewSize());
                                legacyRequest = new LegacyRequest(RequestThreadManager.access$1400(this.this$0), request, previewSize, RequestThreadManager.access$1300(this.this$0));
                                LegacyMetadataMapper.convertRequestMetadata(legacyRequest);
                                if (!RequestThreadManager.access$1300(this.this$0).same(legacyRequest.parameters)) {
                                    try {
                                        RequestThreadManager.access$1500(this.this$0).setParameters(legacyRequest.parameters);
                                    }
                                    catch (RuntimeException e) {
                                        Log.e(RequestThreadManager.access$000(this.this$0), "Exception while setting camera parameters: ", e);
                                        holder.failRequest();
                                        RequestThreadManager.access$100(this.this$0).setCaptureStart(holder, 0L, 3);
                                        continue;
                                    }
                                    paramsChanged = true;
                                    RequestThreadManager.access$1302(this.this$0, legacyRequest.parameters);
                                }
                                RequestThreadManager.access$1202(this.this$0, legacyRequest);
                            }
                            try {
                                success = RequestThreadManager.access$200(this.this$0).queueRequest(holder, RequestThreadManager.access$1200(this.this$0), 3000L, TimeUnit.MILLISECONDS);
                                if (!success) {
                                    Log.e(RequestThreadManager.access$000(this.this$0), "Timed out while queueing capture request.");
                                    holder.failRequest();
                                    RequestThreadManager.access$100(this.this$0).setCaptureStart(holder, 0L, 3);
                                    continue;
                                }
                                if (holder.hasPreviewTargets()) {
                                    RequestThreadManager.access$1600(this.this$0, holder);
                                }
                                if (holder.hasJpegTargets()) {
                                    while (!RequestThreadManager.access$200(this.this$0).waitForPreviewsEmpty(1000L, TimeUnit.MILLISECONDS)) {
                                        Log.e(RequestThreadManager.access$000(this.this$0), "Timed out while waiting for preview requests to complete.");
                                        RequestThreadManager.access$200(this.this$0).failNextPreview();
                                    }
                                    RequestThreadManager.access$400(this.this$0).close();
                                    RequestThreadManager.access$1700(this.this$0, holder);
                                }
                                RequestThreadManager.access$1800(this.this$0).processFaceDetectMode(request, RequestThreadManager.access$1300(this.this$0));
                                RequestThreadManager.access$1900(this.this$0).processRequestTriggers(request, RequestThreadManager.access$1300(this.this$0));
                                if (!holder.hasJpegTargets()) ** GOTO lbl129
                                RequestThreadManager.access$2000(this.this$0, holder);
                                if (!RequestThreadManager.access$400(this.this$0).block(3000L)) {
                                    Log.e(RequestThreadManager.access$000(this.this$0), "Hit timeout for jpeg callback!");
                                    RequestThreadManager.access$200(this.this$0).failNextJpeg();
                                }
                            }
                            catch (IOException e) {
                                Log.e(RequestThreadManager.access$000(this.this$0), "Received device exception: ", e);
                                RequestThreadManager.access$100(this.this$0).setError(1);
                                break;
                            }
                            catch (InterruptedException e) {
                                Log.e(RequestThreadManager.access$000(this.this$0), "Interrupted during capture: ", e);
                                RequestThreadManager.access$100(this.this$0).setError(1);
                                break;
                            }
lbl129:
                            // 3 sources

                            if (paramsChanged) {
                                if (RequestThreadManager.access$500()) {
                                    Log.d(RequestThreadManager.access$000(this.this$0), "Params changed -- getting new Parameters from HAL.");
                                }
                                try {
                                    RequestThreadManager.access$1302(this.this$0, RequestThreadManager.access$1500(this.this$0).getParameters());
                                }
                                catch (RuntimeException e) {
                                    Log.e(RequestThreadManager.access$000(this.this$0), "Received device exception: ", e);
                                    RequestThreadManager.access$100(this.this$0).setError(1);
                                    break;
                                }
                                RequestThreadManager.access$1200(this.this$0).setParameters(RequestThreadManager.access$1300(this.this$0));
                            }
                            timestampMutable = new MutableLong(0L);
                            try {
                                success = RequestThreadManager.access$200(this.this$0).waitForRequestCompleted(holder, 3000L, TimeUnit.MILLISECONDS, timestampMutable);
                                if (!success) {
                                    Log.e(RequestThreadManager.access$000(this.this$0), "Timed out while waiting for request to complete.");
                                    RequestThreadManager.access$200(this.this$0).failAll();
                                }
                            }
                            catch (InterruptedException e) {
                                Log.e(RequestThreadManager.access$000(this.this$0), "Interrupted waiting for request completion: ", e);
                                RequestThreadManager.access$100(this.this$0).setError(1);
                                break;
                            }
                            result = this.mMapper.cachedConvertResultMetadata(RequestThreadManager.access$1200(this.this$0), timestampMutable.value);
                            RequestThreadManager.access$1900(this.this$0).mapResultTriggers(result);
                            RequestThreadManager.access$1800(this.this$0).mapResultFaces(result, RequestThreadManager.access$1200(this.this$0));
                            if (holder.requestFailed()) continue;
                            RequestThreadManager.access$100(this.this$0).setCaptureResult(holder, result, -1);
                        }
                        if (!RequestThreadManager.access$500()) break;
                        totalTime = SystemClock.elapsedRealtimeNanos() - startTime;
                        Log.d(RequestThreadManager.access$000(this.this$0), "Capture request took " + totalTime + " ns");
                        RequestThreadManager.access$2100(this.this$0).countAndLog();
                        break;
                    }
                    case 3: {
                        this.mCleanup = true;
                        try {
                            success = RequestThreadManager.access$200(this.this$0).waitForEmpty(3000L, TimeUnit.MILLISECONDS);
                            if (!success) {
                                Log.e(RequestThreadManager.access$000(this.this$0), "Timed out while queueing cleanup request.");
                                RequestThreadManager.access$200(this.this$0).failAll();
                            }
                        }
                        catch (InterruptedException e) {
                            Log.e(RequestThreadManager.access$000(this.this$0), "Interrupted while waiting for requests to complete: ", e);
                            RequestThreadManager.access$100(this.this$0).setError(1);
                        }
                        if (RequestThreadManager.access$700(this.this$0) != null) {
                            RequestThreadManager.access$700(this.this$0).quit();
                        }
                        if (RequestThreadManager.access$1500(this.this$0) != null) {
                            RequestThreadManager.access$1500(this.this$0).release();
                        }
                        RequestThreadManager.access$2300(this.this$0, RequestThreadManager.access$2200(this.this$0));
                        break;
                    }
                    case -1: {
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled message " + msg.what + " on RequestThread."));
                    }
                }
                return true;
            }

            private void __constructor__(RequestThreadManager requestThreadManager) {
                this.$$robo$$android_hardware_camera2_legacy_RequestThreadManager_5$__constructor__(requestThreadManager);
            }
            {
                this.this$0 = requestThreadManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_5$__constructor__(android.hardware.camera2.legacy.RequestThreadManager ), 0, this, requestThreadManager);
            }

            @Override
            public boolean handleMessage(Message message) {
                return (boolean)InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_5$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCamera = Preconditions.checkNotNull(camera, "camera must not be null");
        this.mCameraId = cameraId;
        this.mCharacteristics = Preconditions.checkNotNull(characteristics, "characteristics must not be null");
        this.TAG = name = String.format("RequestThread-%d", cameraId);
        this.mDeviceState = Preconditions.checkNotNull(deviceState, "deviceState must not be null");
        this.mFocusStateMapper = new LegacyFocusStateMapper(this.mCamera);
        this.mFaceDetectMapper = new LegacyFaceDetectMapper(this.mCamera, this.mCharacteristics);
        this.mCaptureCollector = new CaptureCollector(2, this.mDeviceState);
        this.mRequestThread = new RequestHandlerThread(name, this.mRequestHandlerCb);
        this.mCamera.setErrorCallback(this.mErrorCallback);
    }

    private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager$start() {
        this.mRequestThread.start();
    }

    private final long $$robo$$android_hardware_camera2_legacy_RequestThreadManager$flush() {
        Log.i(this.TAG, "Flushing all pending requests.");
        long lastFrame = this.mRequestQueue.stopRepeating();
        this.mCaptureCollector.failAll();
        return lastFrame;
    }

    private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager$quit() {
        Handler handler = this.mRequestThread.waitAndGetHandler();
        handler.sendMessageAtFrontOfQueue(handler.obtainMessage(3));
        this.mRequestThread.quitSafely();
        try {
            this.mRequestThread.join();
        }
        catch (InterruptedException e) {
            Log.e(this.TAG, String.format("Thread %s (%d) interrupted while quitting.", this.mRequestThread.getName(), this.mRequestThread.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_hardware_camera2_legacy_RequestThreadManager$submitCaptureRequests(List<CaptureRequest> requests, boolean repeating, LongParcelable frameNumber) {
        int ret;
        Handler handler = this.mRequestThread.waitAndGetHandler();
        Object object = this.mIdleLock;
        synchronized (object) {
            ret = this.mRequestQueue.submit(requests, repeating, frameNumber);
            handler.sendEmptyMessage(2);
        }
        return ret;
    }

    private final long $$robo$$android_hardware_camera2_legacy_RequestThreadManager$cancelRepeating(int requestId) {
        return this.mRequestQueue.stopRepeating(requestId);
    }

    private final void $$robo$$android_hardware_camera2_legacy_RequestThreadManager$configure(Collection<Surface> outputs) {
        Handler handler = this.mRequestThread.waitAndGetHandler();
        ConditionVariable condition = new ConditionVariable(false);
        ConfigureHolder holder = new ConfigureHolder(condition, outputs);
        handler.sendMessage(handler.obtainMessage(1, 0, 0, holder));
        condition.block();
    }

    static /* synthetic */ void access$800(RequestThreadManager x0, Collection x1) {
        x0.configureOutputs(x1);
    }

    static /* synthetic */ RequestHandlerThread access$900(RequestThreadManager x0) {
        return x0.mRequestThread;
    }

    static /* synthetic */ RequestQueue access$1000(RequestThreadManager x0) {
        return x0.mRequestQueue;
    }

    static /* synthetic */ Object access$1100(RequestThreadManager x0) {
        return x0.mIdleLock;
    }

    static /* synthetic */ LegacyRequest access$1200(RequestThreadManager x0) {
        return x0.mLastRequest;
    }

    static /* synthetic */ Camera.Parameters access$1300(RequestThreadManager x0) {
        return x0.mParams;
    }

    static /* synthetic */ CameraCharacteristics access$1400(RequestThreadManager x0) {
        return x0.mCharacteristics;
    }

    static /* synthetic */ Camera access$1500(RequestThreadManager x0) {
        return x0.mCamera;
    }

    static /* synthetic */ Camera.Parameters access$1302(RequestThreadManager x0, Camera.Parameters x1) {
        x0.mParams = x1;
        return x0.mParams;
    }

    static /* synthetic */ LegacyRequest access$1202(RequestThreadManager x0, LegacyRequest x1) {
        x0.mLastRequest = x1;
        return x0.mLastRequest;
    }

    static /* synthetic */ void access$1600(RequestThreadManager x0, RequestHolder x1) throws IOException {
        x0.doPreviewCapture(x1);
    }

    static /* synthetic */ void access$1700(RequestThreadManager x0, RequestHolder x1) throws IOException {
        x0.doJpegCapturePrepare(x1);
    }

    static /* synthetic */ LegacyFaceDetectMapper access$1800(RequestThreadManager x0) {
        return x0.mFaceDetectMapper;
    }

    static /* synthetic */ LegacyFocusStateMapper access$1900(RequestThreadManager x0) {
        return x0.mFocusStateMapper;
    }

    static /* synthetic */ void access$2000(RequestThreadManager x0, RequestHolder x1) {
        x0.doJpegCapture(x1);
    }

    static /* synthetic */ FpsCounter access$2100(RequestThreadManager x0) {
        return x0.mRequestCounter;
    }

    static /* synthetic */ List access$2200(RequestThreadManager x0) {
        return x0.mCallbackOutputs;
    }

    static /* synthetic */ void access$2300(RequestThreadManager x0, Collection x1) {
        x0.resetJpegSurfaceFormats(x1);
    }

    static void __staticInitializer__() {
        DEBUG = Log.isLoggable("HAL1ShimLogging", 3);
        VERBOSE = Log.isLoggable("HAL1ShimLogging", 2);
    }

    private void createDummySurface() {
        InvokeDynamicSupport.bootstrap("createDummySurface", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$createDummySurface(), 0, this);
    }

    private void stopPreview() {
        InvokeDynamicSupport.bootstrap("stopPreview", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$stopPreview(), 0, this);
    }

    private void startPreview() {
        InvokeDynamicSupport.bootstrap("startPreview", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$startPreview(), 0, this);
    }

    private void doJpegCapturePrepare(RequestHolder requestHolder) throws IOException {
        InvokeDynamicSupport.bootstrap("doJpegCapturePrepare", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$doJpegCapturePrepare(android.hardware.camera2.legacy.RequestHolder ), 0, this, requestHolder);
    }

    private void doJpegCapture(RequestHolder requestHolder) {
        InvokeDynamicSupport.bootstrap("doJpegCapture", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$doJpegCapture(android.hardware.camera2.legacy.RequestHolder ), 0, this, requestHolder);
    }

    private void doPreviewCapture(RequestHolder requestHolder) throws IOException {
        InvokeDynamicSupport.bootstrap("doPreviewCapture", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$doPreviewCapture(android.hardware.camera2.legacy.RequestHolder ), 0, this, requestHolder);
    }

    private void configureOutputs(Collection<Surface> collection) {
        InvokeDynamicSupport.bootstrap("configureOutputs", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$configureOutputs(java.util.Collection<android.view.Surface> ), 0, this, collection);
    }

    private void resetJpegSurfaceFormats(Collection<Surface> collection) {
        InvokeDynamicSupport.bootstrap("resetJpegSurfaceFormats", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$resetJpegSurfaceFormats(java.util.Collection<android.view.Surface> ), 0, this, collection);
    }

    private Size calculatePictureSize(Collection<Surface> collection, Camera.Parameters parameters) {
        return InvokeDynamicSupport.bootstrap("calculatePictureSize", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$calculatePictureSize(java.util.Collection<android.view.Surface> android.hardware.Camera$Parameters ), 0, this, collection, parameters);
    }

    private static boolean checkAspectRatiosMatch(Size size, Size size2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkAspectRatiosMatch", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$checkAspectRatiosMatch(android.util.Size android.util.Size ), 0, (Size)size, (Size)size2);
    }

    private int[] getPhotoPreviewFpsRange(List<int[]> list) {
        return InvokeDynamicSupport.bootstrap("getPhotoPreviewFpsRange", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$getPhotoPreviewFpsRange(java.util.List<int[]> ), 0, this, list);
    }

    private void __constructor__(int n, Camera camera, CameraCharacteristics cameraCharacteristics, CameraDeviceState cameraDeviceState) {
        this.$$robo$$android_hardware_camera2_legacy_RequestThreadManager$__constructor__(n, camera, cameraCharacteristics, cameraDeviceState);
    }

    public RequestThreadManager(int n, Camera camera, CameraCharacteristics cameraCharacteristics, CameraDeviceState cameraDeviceState) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$__constructor__(int android.hardware.Camera android.hardware.camera2.CameraCharacteristics android.hardware.camera2.legacy.CameraDeviceState ), 0, this, n, camera, cameraCharacteristics, cameraDeviceState);
    }

    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$start(), 0, this);
    }

    public long flush() {
        return (long)InvokeDynamicSupport.bootstrap("flush", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$flush(), 0, this);
    }

    public void quit() {
        InvokeDynamicSupport.bootstrap("quit", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$quit(), 0, this);
    }

    public int submitCaptureRequests(List<CaptureRequest> list, boolean bl, LongParcelable longParcelable) {
        return (int)InvokeDynamicSupport.bootstrap("submitCaptureRequests", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$submitCaptureRequests(java.util.List<android.hardware.camera2.CaptureRequest> boolean android.hardware.camera2.utils.LongParcelable ), 0, this, list, bl, longParcelable);
    }

    public long cancelRepeating(int n) {
        return (long)InvokeDynamicSupport.bootstrap("cancelRepeating", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$cancelRepeating(int ), 0, this, n);
    }

    public void configure(Collection<Surface> collection) {
        InvokeDynamicSupport.bootstrap("configure", $$robo$$android_hardware_camera2_legacy_RequestThreadManager$configure(java.util.Collection<android.view.Surface> ), 0, this, collection);
    }

    static {
        RobolectricInternals.classInitializing(RequestThreadManager.class);
    }

    public /* synthetic */ RequestThreadManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RequestThreadManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class FpsCounter
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String TAG = "FpsCounter";
        private int mFrameCount;
        private long mLastTime;
        private long mLastPrintTime;
        private double mLastFps;
        private String mStreamType;
        private static long NANO_PER_SECOND = 1000000000L;

        private void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_FpsCounter$__constructor__(String streamType) {
            this.mFrameCount = 0;
            this.mLastTime = 0L;
            this.mLastPrintTime = 0L;
            this.mLastFps = 0.0;
            this.mStreamType = streamType;
        }

        private final synchronized void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_FpsCounter$countFrame() {
            ++this.mFrameCount;
            long nextTime = SystemClock.elapsedRealtimeNanos();
            if (this.mLastTime == 0L) {
                this.mLastTime = nextTime;
            }
            if (nextTime > this.mLastTime + 1000000000L) {
                long elapsed = nextTime - this.mLastTime;
                this.mLastFps = (double)this.mFrameCount * (1.0E9 / (double)elapsed);
                this.mFrameCount = 0;
                this.mLastTime = nextTime;
            }
        }

        private final synchronized double $$robo$$android_hardware_camera2_legacy_RequestThreadManager_FpsCounter$checkFps() {
            return this.mLastFps;
        }

        private final synchronized void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_FpsCounter$staggeredLog() {
            if (this.mLastTime > this.mLastPrintTime + 5000000000L) {
                this.mLastPrintTime = this.mLastTime;
                Log.d("FpsCounter", "FPS for " + this.mStreamType + " stream: " + this.mLastFps);
            }
        }

        private final synchronized void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_FpsCounter$countAndLog() {
            this.countFrame();
            this.staggeredLog();
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_hardware_camera2_legacy_RequestThreadManager_FpsCounter$__constructor__(string2);
        }

        public FpsCounter(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_FpsCounter$__constructor__(java.lang.String ), 0, this, string2);
        }

        public synchronized void countFrame() {
            InvokeDynamicSupport.bootstrap("countFrame", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_FpsCounter$countFrame(), 0, this);
        }

        public synchronized double checkFps() {
            return (double)InvokeDynamicSupport.bootstrap("checkFps", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_FpsCounter$checkFps(), 0, this);
        }

        public synchronized void staggeredLog() {
            InvokeDynamicSupport.bootstrap("staggeredLog", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_FpsCounter$staggeredLog(), 0, this);
        }

        public synchronized void countAndLog() {
            InvokeDynamicSupport.bootstrap("countAndLog", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_FpsCounter$countAndLog(), 0, this);
        }

        public /* synthetic */ FpsCounter() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FpsCounter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ConfigureHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public ConditionVariable condition;
        public Collection<Surface> surfaces;

        private void $$robo$$android_hardware_camera2_legacy_RequestThreadManager_ConfigureHolder$__constructor__(ConditionVariable condition, Collection<Surface> surfaces) {
            this.condition = condition;
            this.surfaces = surfaces;
        }

        private void __constructor__(ConditionVariable conditionVariable, Collection<Surface> collection) {
            this.$$robo$$android_hardware_camera2_legacy_RequestThreadManager_ConfigureHolder$__constructor__(conditionVariable, collection);
        }

        public ConfigureHolder(ConditionVariable conditionVariable, Collection<Surface> collection) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_RequestThreadManager_ConfigureHolder$__constructor__(android.os.ConditionVariable java.util.Collection<android.view.Surface> ), 0, this, conditionVariable, collection);
        }

        public /* synthetic */ ConfigureHolder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConfigureHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

