/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal;

import android.hardware.camera2.marshal.MarshalHelpers;
import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.utils.TypeReference;
import com.android.internal.util.Preconditions;
import java.nio.ByteBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;

public abstract class Marshaler<T> {
    public transient /* synthetic */ Object __robo_data__;
    protected TypeReference<T> mTypeReference;
    protected int mNativeType;
    public static int NATIVE_SIZE_DYNAMIC;

    private void $$robo$$android_hardware_camera2_marshal_Marshaler$__constructor__(MarshalQueryable<T> query, TypeReference<T> typeReference, int nativeType) {
        this.mTypeReference = Preconditions.checkNotNull(typeReference, "typeReference must not be null");
        this.mNativeType = MarshalHelpers.checkNativeType(nativeType);
        if (!query.isTypeMappingSupported(typeReference, nativeType)) {
            throw new UnsupportedOperationException("Unsupported type marshaling for managed type " + typeReference + " and native type " + MarshalHelpers.toStringNativeType(nativeType));
        }
    }

    public abstract void marshal(T var1, ByteBuffer var2);

    private final int $$robo$$android_hardware_camera2_marshal_Marshaler$calculateMarshalSize(T value) {
        int nativeSize = this.getNativeSize();
        if (nativeSize == NATIVE_SIZE_DYNAMIC) {
            throw new AssertionError((Object)"Override this function for dynamically-sized objects");
        }
        return nativeSize;
    }

    public abstract T unmarshal(ByteBuffer var1);

    public abstract int getNativeSize();

    private final TypeReference<T> $$robo$$android_hardware_camera2_marshal_Marshaler$getTypeReference() {
        return this.mTypeReference;
    }

    private final int $$robo$$android_hardware_camera2_marshal_Marshaler$getNativeType() {
        return this.mNativeType;
    }

    static void __staticInitializer__() {
        NATIVE_SIZE_DYNAMIC = -1;
    }

    private void __constructor__(MarshalQueryable<T> marshalQueryable, TypeReference<T> typeReference, int n) {
        this.$$robo$$android_hardware_camera2_marshal_Marshaler$__constructor__(marshalQueryable, typeReference, n);
    }

    protected Marshaler(MarshalQueryable<T> marshalQueryable, TypeReference<T> typeReference, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_marshal_Marshaler$__constructor__(android.hardware.camera2.marshal.MarshalQueryable<T> android.hardware.camera2.utils.TypeReference<T> int ), 0, this, marshalQueryable, typeReference, n);
    }

    public int calculateMarshalSize(T t) {
        return (int)InvokeDynamicSupport.bootstrap("calculateMarshalSize", $$robo$$android_hardware_camera2_marshal_Marshaler$calculateMarshalSize(T ), 0, this, t);
    }

    public TypeReference<T> getTypeReference() {
        return InvokeDynamicSupport.bootstrap("getTypeReference", $$robo$$android_hardware_camera2_marshal_Marshaler$getTypeReference(), 0, this);
    }

    public int getNativeType() {
        return (int)InvokeDynamicSupport.bootstrap("getNativeType", $$robo$$android_hardware_camera2_marshal_Marshaler$getNativeType(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(Marshaler.class);
    }

    public /* synthetic */ Marshaler() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Marshaler)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

