/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.hardware.camera2.utils.HashCodeHelpers;
import android.util.Rational;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ColorSpaceTransform
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int ROWS = 3;
    private static int COLUMNS = 3;
    private static int COUNT = 9;
    private static int RATIONAL_SIZE = 2;
    private static int OFFSET_NUMERATOR = 0;
    private static int OFFSET_DENOMINATOR = 1;
    private static int COUNT_INT = 18;
    private int[] mElements;

    private void $$robo$$android_hardware_camera2_params_ColorSpaceTransform$__constructor__(Rational[] elements) {
        Preconditions.checkNotNull(elements, "elements must not be null");
        if (elements.length != 9) {
            throw new IllegalArgumentException("elements must be 9 length");
        }
        this.mElements = new int[18];
        for (int i = 0; i < elements.length; ++i) {
            Preconditions.checkNotNull(elements, "element[" + i + "] must not be null");
            this.mElements[i * 2 + 0] = elements[i].getNumerator();
            this.mElements[i * 2 + 1] = elements[i].getDenominator();
        }
    }

    private void $$robo$$android_hardware_camera2_params_ColorSpaceTransform$__constructor__(int[] elements) {
        Preconditions.checkNotNull(elements, "elements must not be null");
        if (elements.length != 18) {
            throw new IllegalArgumentException("elements must be 18 length");
        }
        for (int i = 0; i < elements.length; ++i) {
            Preconditions.checkNotNull(elements, "element " + i + " must not be null");
        }
        this.mElements = Arrays.copyOf(elements, elements.length);
    }

    private final Rational $$robo$$android_hardware_camera2_params_ColorSpaceTransform$getElement(int column, int row) {
        if (column < 0 || column >= 3) {
            throw new IllegalArgumentException("column out of range");
        }
        if (row < 0 || row >= 3) {
            throw new IllegalArgumentException("row out of range");
        }
        int numerator = this.mElements[(row * 3 + column) * 2 + 0];
        int denominator = this.mElements[(row * 3 + column) * 2 + 1];
        return new Rational(numerator, denominator);
    }

    private final void $$robo$$android_hardware_camera2_params_ColorSpaceTransform$copyElements(Rational[] destination, int offset) {
        Preconditions.checkArgumentNonnegative(offset, "offset must not be negative");
        Preconditions.checkNotNull(destination, "destination must not be null");
        if (destination.length - offset < 9) {
            throw new ArrayIndexOutOfBoundsException("destination too small to fit elements");
        }
        int i = 0;
        int j = 0;
        while (i < 9) {
            int numerator = this.mElements[j + 0];
            int denominator = this.mElements[j + 1];
            destination[i + offset] = new Rational(numerator, denominator);
            ++i;
            j += 2;
        }
    }

    private final void $$robo$$android_hardware_camera2_params_ColorSpaceTransform$copyElements(int[] destination, int offset) {
        Preconditions.checkArgumentNonnegative(offset, "offset must not be negative");
        Preconditions.checkNotNull(destination, "destination must not be null");
        if (destination.length - offset < 18) {
            throw new ArrayIndexOutOfBoundsException("destination too small to fit elements");
        }
        for (int i = 0; i < 18; ++i) {
            destination[i + offset] = this.mElements[i];
        }
    }

    private final boolean $$robo$$android_hardware_camera2_params_ColorSpaceTransform$equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof ColorSpaceTransform) {
            ColorSpaceTransform other = (ColorSpaceTransform)obj;
            int i = 0;
            int j = 0;
            while (i < 9) {
                int numerator = this.mElements[j + 0];
                int denominator = this.mElements[j + 1];
                Rational r = new Rational(numerator, denominator);
                int numeratorOther = other.mElements[j + 0];
                int denominatorOther = other.mElements[j + 1];
                Rational rOther = new Rational(numeratorOther, denominatorOther);
                if (!r.equals((Object)rOther)) {
                    return false;
                }
                ++i;
                j += 2;
            }
            return true;
        }
        return false;
    }

    private final int $$robo$$android_hardware_camera2_params_ColorSpaceTransform$hashCode() {
        return HashCodeHelpers.hashCode(this.mElements);
    }

    private final String $$robo$$android_hardware_camera2_params_ColorSpaceTransform$toString() {
        return String.format("ColorSpaceTransform%s", this.toShortString());
    }

    private final String $$robo$$android_hardware_camera2_params_ColorSpaceTransform$toShortString() {
        StringBuilder sb = new StringBuilder("(");
        int i = 0;
        for (int row = 0; row < 3; ++row) {
            sb.append("[");
            int col = 0;
            while (col < 3) {
                int numerator = this.mElements[i + 0];
                int denominator = this.mElements[i + 1];
                sb.append(numerator);
                sb.append("/");
                sb.append(denominator);
                if (col < 2) {
                    sb.append(", ");
                }
                ++col;
                i += 2;
            }
            sb.append("]");
            if (row >= 2) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    private void __constructor__(Rational[] rationalArray) {
        this.$$robo$$android_hardware_camera2_params_ColorSpaceTransform$__constructor__(rationalArray);
    }

    public ColorSpaceTransform(Rational[] rationalArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_params_ColorSpaceTransform$__constructor__(android.util.Rational[] ), 0, this, rationalArray);
    }

    private void __constructor__(int[] nArray) {
        this.$$robo$$android_hardware_camera2_params_ColorSpaceTransform$__constructor__(nArray);
    }

    public ColorSpaceTransform(int[] nArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_params_ColorSpaceTransform$__constructor__(int[] ), 0, this, nArray);
    }

    public Rational getElement(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getElement", $$robo$$android_hardware_camera2_params_ColorSpaceTransform$getElement(int int ), 0, this, n, n2);
    }

    public void copyElements(Rational[] rationalArray, int n) {
        InvokeDynamicSupport.bootstrap("copyElements", $$robo$$android_hardware_camera2_params_ColorSpaceTransform$copyElements(android.util.Rational[] int ), 0, this, rationalArray, n);
    }

    public void copyElements(int[] nArray, int n) {
        InvokeDynamicSupport.bootstrap("copyElements", $$robo$$android_hardware_camera2_params_ColorSpaceTransform$copyElements(int[] int ), 0, this, nArray, n);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_camera2_params_ColorSpaceTransform$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_camera2_params_ColorSpaceTransform$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_hardware_camera2_params_ColorSpaceTransform$toString(), 0, this);
    }

    private String toShortString() {
        return InvokeDynamicSupport.bootstrap("toShortString", $$robo$$android_hardware_camera2_params_ColorSpaceTransform$toShortString(), 0, this);
    }

    public /* synthetic */ ColorSpaceTransform() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ColorSpaceTransform)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

