/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.hardware.camera2.params.RggbChannelVector;
import android.hardware.camera2.utils.HashCodeHelpers;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class LensShadingMap
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static float MINIMUM_GAIN_FACTOR = 1.0f;
    private int mRows;
    private int mColumns;
    private float[] mElements;

    private void $$robo$$android_hardware_camera2_params_LensShadingMap$__constructor__(float[] elements, int rows, int columns) {
        this.mRows = Preconditions.checkArgumentPositive(rows, "rows must be positive");
        this.mColumns = Preconditions.checkArgumentPositive(columns, "columns must be positive");
        this.mElements = Preconditions.checkNotNull(elements, "elements must not be null");
        if (elements.length != this.getGainFactorCount()) {
            throw new IllegalArgumentException("elements must be " + this.getGainFactorCount() + " length, received " + elements.length);
        }
        Preconditions.checkArrayElementsInRange(elements, 1.0f, Float.MAX_VALUE, "elements");
    }

    private final int $$robo$$android_hardware_camera2_params_LensShadingMap$getRowCount() {
        return this.mRows;
    }

    private final int $$robo$$android_hardware_camera2_params_LensShadingMap$getColumnCount() {
        return this.mColumns;
    }

    private final int $$robo$$android_hardware_camera2_params_LensShadingMap$getGainFactorCount() {
        return this.mRows * this.mColumns * 4;
    }

    private final float $$robo$$android_hardware_camera2_params_LensShadingMap$getGainFactor(int colorChannel, int column, int row) {
        if (colorChannel < 0 || colorChannel > 4) {
            throw new IllegalArgumentException("colorChannel out of range");
        }
        if (column < 0 || column >= this.mColumns) {
            throw new IllegalArgumentException("column out of range");
        }
        if (row < 0 || row >= this.mRows) {
            throw new IllegalArgumentException("row out of range");
        }
        return this.mElements[colorChannel + (row * this.mColumns + column) * 4];
    }

    private final RggbChannelVector $$robo$$android_hardware_camera2_params_LensShadingMap$getGainFactorVector(int column, int row) {
        if (column < 0 || column >= this.mColumns) {
            throw new IllegalArgumentException("column out of range");
        }
        if (row < 0 || row >= this.mRows) {
            throw new IllegalArgumentException("row out of range");
        }
        int offset = (row * this.mColumns + column) * 4;
        float red = this.mElements[0 + offset];
        float greenEven = this.mElements[1 + offset];
        float greenOdd = this.mElements[2 + offset];
        float blue = this.mElements[3 + offset];
        return new RggbChannelVector(red, greenEven, greenOdd, blue);
    }

    private final void $$robo$$android_hardware_camera2_params_LensShadingMap$copyGainFactors(float[] destination, int offset) {
        Preconditions.checkArgumentNonnegative(offset, "offset must not be negative");
        Preconditions.checkNotNull(destination, "destination must not be null");
        if (destination.length + offset < this.getGainFactorCount()) {
            throw new ArrayIndexOutOfBoundsException("destination too small to fit elements");
        }
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (float[])this.mElements, (int)0, (float[])destination, (int)offset, (int)this.getGainFactorCount());
    }

    private final boolean $$robo$$android_hardware_camera2_params_LensShadingMap$equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof LensShadingMap) {
            LensShadingMap other = (LensShadingMap)obj;
            return this.mRows == other.mRows && this.mColumns == other.mColumns && Arrays.equals(this.mElements, other.mElements);
        }
        return false;
    }

    private final int $$robo$$android_hardware_camera2_params_LensShadingMap$hashCode() {
        int elemsHash = HashCodeHelpers.hashCode(this.mElements);
        return HashCodeHelpers.hashCode(this.mRows, this.mColumns, elemsHash);
    }

    private void __constructor__(float[] fArray, int n, int n2) {
        this.$$robo$$android_hardware_camera2_params_LensShadingMap$__constructor__(fArray, n, n2);
    }

    public LensShadingMap(float[] fArray, int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_params_LensShadingMap$__constructor__(float[] int int ), 0, this, fArray, n, n2);
    }

    public int getRowCount() {
        return (int)InvokeDynamicSupport.bootstrap("getRowCount", $$robo$$android_hardware_camera2_params_LensShadingMap$getRowCount(), 0, this);
    }

    public int getColumnCount() {
        return (int)InvokeDynamicSupport.bootstrap("getColumnCount", $$robo$$android_hardware_camera2_params_LensShadingMap$getColumnCount(), 0, this);
    }

    public int getGainFactorCount() {
        return (int)InvokeDynamicSupport.bootstrap("getGainFactorCount", $$robo$$android_hardware_camera2_params_LensShadingMap$getGainFactorCount(), 0, this);
    }

    public float getGainFactor(int n, int n2, int n3) {
        return (float)InvokeDynamicSupport.bootstrap("getGainFactor", $$robo$$android_hardware_camera2_params_LensShadingMap$getGainFactor(int int int ), 0, this, n, n2, n3);
    }

    public RggbChannelVector getGainFactorVector(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getGainFactorVector", $$robo$$android_hardware_camera2_params_LensShadingMap$getGainFactorVector(int int ), 0, this, n, n2);
    }

    public void copyGainFactors(float[] fArray, int n) {
        InvokeDynamicSupport.bootstrap("copyGainFactors", $$robo$$android_hardware_camera2_params_LensShadingMap$copyGainFactors(float[] int ), 0, this, fArray, n);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_camera2_params_LensShadingMap$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_camera2_params_LensShadingMap$hashCode(), 0, this);
    }

    public /* synthetic */ LensShadingMap() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LensShadingMap)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

