/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.graphics.ImageFormat;
import android.graphics.PixelFormat;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.params.HighSpeedVideoConfiguration;
import android.hardware.camera2.params.StreamConfiguration;
import android.hardware.camera2.params.StreamConfigurationDuration;
import android.hardware.camera2.utils.HashCodeHelpers;
import android.media.ImageReader;
import android.media.MediaCodec;
import android.media.MediaRecorder;
import android.renderscript.Allocation;
import android.util.Range;
import android.util.Size;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class StreamConfigurationMap
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "StreamConfigurationMap";
    private static int HAL_PIXEL_FORMAT_BLOB = 33;
    private static int HAL_PIXEL_FORMAT_IMPLEMENTATION_DEFINED = 34;
    private static int HAL_PIXEL_FORMAT_RAW_OPAQUE = 36;
    private static int DURATION_MIN_FRAME = 0;
    private static int DURATION_STALL = 1;
    private StreamConfiguration[] mConfigurations;
    private StreamConfigurationDuration[] mMinFrameDurations;
    private StreamConfigurationDuration[] mStallDurations;
    private HighSpeedVideoConfiguration[] mHighSpeedVideoConfigurations;
    private HashMap<Integer, Integer> mOutputFormats;
    private HashMap<Integer, Integer> mInputFormats;
    private HashMap<Size, Integer> mHighSpeedVideoSizeMap;
    private HashMap<Range<Integer>, Integer> mHighSpeedVideoFpsRangeMap;

    private void $$robo$$android_hardware_camera2_params_StreamConfigurationMap$__constructor__(StreamConfiguration[] configurations, StreamConfigurationDuration[] minFrameDurations, StreamConfigurationDuration[] stallDurations, HighSpeedVideoConfiguration[] highSpeedVideoConfigurations) {
        this.mOutputFormats = new HashMap();
        this.mInputFormats = new HashMap();
        this.mHighSpeedVideoSizeMap = new HashMap();
        this.mHighSpeedVideoFpsRangeMap = new HashMap();
        this.mConfigurations = Preconditions.checkArrayElementsNotNull(configurations, "configurations");
        this.mMinFrameDurations = Preconditions.checkArrayElementsNotNull(minFrameDurations, "minFrameDurations");
        this.mStallDurations = Preconditions.checkArrayElementsNotNull(stallDurations, "stallDurations");
        this.mHighSpeedVideoConfigurations = highSpeedVideoConfigurations == null ? new HighSpeedVideoConfiguration[0] : Preconditions.checkArrayElementsNotNull(highSpeedVideoConfigurations, "highSpeedVideoConfigurations");
        for (StreamConfiguration streamConfiguration : configurations) {
            HashMap<Integer, Integer> map = streamConfiguration.isOutput() ? this.mOutputFormats : this.mInputFormats;
            Integer count = map.get(streamConfiguration.getFormat());
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            map.put(streamConfiguration.getFormat(), count);
        }
        if (!this.mOutputFormats.containsKey(34)) {
            throw new AssertionError((Object)"At least one stream configuration for IMPLEMENTATION_DEFINED must exist");
        }
        for (HighSpeedVideoConfiguration highSpeedVideoConfiguration : this.mHighSpeedVideoConfigurations) {
            Size size = highSpeedVideoConfiguration.getSize();
            Range<Integer> fpsRange = highSpeedVideoConfiguration.getFpsRange();
            Integer fpsRangeCount = this.mHighSpeedVideoSizeMap.get(size);
            if (fpsRangeCount == null) {
                fpsRangeCount = 0;
            }
            this.mHighSpeedVideoSizeMap.put(size, fpsRangeCount + 1);
            Integer sizeCount = this.mHighSpeedVideoFpsRangeMap.get(fpsRange);
            if (sizeCount == null) {
                sizeCount = 0;
            }
            this.mHighSpeedVideoFpsRangeMap.put(fpsRange, sizeCount + 1);
        }
    }

    private final int[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputFormats() {
        return this.getPublicFormats(true);
    }

    private final int[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getInputFormats() {
        return this.getPublicFormats(false);
    }

    private final Size[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getInputSizes(int format) {
        return this.getPublicFormatSizes(format, false);
    }

    private final boolean $$robo$$android_hardware_camera2_params_StreamConfigurationMap$isOutputSupportedFor(int format) {
        StreamConfigurationMap.checkArgumentFormat(format);
        format = StreamConfigurationMap.imageFormatToInternal(format);
        return this.getFormatsMap(true).containsKey(format);
    }

    private static final <T> boolean $$robo$$android_hardware_camera2_params_StreamConfigurationMap$isOutputSupportedFor(Class<T> klass) {
        Preconditions.checkNotNull(klass, "klass must not be null");
        if (klass == ImageReader.class) {
            return true;
        }
        if (klass == MediaRecorder.class) {
            return true;
        }
        if (klass == MediaCodec.class) {
            return true;
        }
        if (klass == Allocation.class) {
            return true;
        }
        if (klass == SurfaceHolder.class) {
            return true;
        }
        return klass == SurfaceTexture.class;
    }

    private final boolean $$robo$$android_hardware_camera2_params_StreamConfigurationMap$isOutputSupportedFor(Surface surface) {
        Preconditions.checkNotNull(surface, "surface must not be null");
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private final <T> Size[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputSizes(Class<T> klass) {
        if (ImageReader.class.isAssignableFrom(klass)) {
            return new Size[0];
        }
        if (!StreamConfigurationMap.isOutputSupportedFor(klass)) {
            return null;
        }
        return this.getInternalFormatSizes(34, true);
    }

    private final Size[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputSizes(int format) {
        return this.getPublicFormatSizes(format, true);
    }

    private final Size[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getHighSpeedVideoSizes() {
        Set<Size> keySet = this.mHighSpeedVideoSizeMap.keySet();
        return keySet.toArray(new Size[keySet.size()]);
    }

    private final Range<Integer>[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getHighSpeedVideoFpsRangesFor(Size size) {
        Integer fpsRangeCount = this.mHighSpeedVideoSizeMap.get(size);
        if (fpsRangeCount == null || fpsRangeCount == 0) {
            throw new IllegalArgumentException(String.format("Size %s does not support high speed video recording", size));
        }
        Range[] fpsRanges = new Range[fpsRangeCount.intValue()];
        int i = 0;
        for (HighSpeedVideoConfiguration config : this.mHighSpeedVideoConfigurations) {
            if (!size.equals(config.getSize())) continue;
            fpsRanges[i++] = config.getFpsRange();
        }
        return fpsRanges;
    }

    private final Range<Integer>[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getHighSpeedVideoFpsRanges() {
        Set<Range<Integer>> keySet = this.mHighSpeedVideoFpsRangeMap.keySet();
        return keySet.toArray(new Range[keySet.size()]);
    }

    private final Size[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getHighSpeedVideoSizesFor(Range<Integer> fpsRange) {
        Integer sizeCount = this.mHighSpeedVideoFpsRangeMap.get(fpsRange);
        if (sizeCount == null || sizeCount == 0) {
            throw new IllegalArgumentException(String.format("FpsRange %s does not support high speed video recording", fpsRange));
        }
        Size[] sizes = new Size[sizeCount.intValue()];
        int i = 0;
        for (HighSpeedVideoConfiguration config : this.mHighSpeedVideoConfigurations) {
            if (!fpsRange.equals(config.getFpsRange())) continue;
            sizes[i++] = config.getSize();
        }
        return sizes;
    }

    private final long $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputMinFrameDuration(int format, Size size) {
        Preconditions.checkNotNull(size, "size must not be null");
        this.checkArgumentFormatSupported(format, true);
        return this.getInternalFormatDuration(StreamConfigurationMap.imageFormatToInternal(format), size, 0);
    }

    private final <T> long $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputMinFrameDuration(Class<T> klass, Size size) {
        if (!StreamConfigurationMap.isOutputSupportedFor(klass)) {
            throw new IllegalArgumentException("klass was not supported");
        }
        return this.getInternalFormatDuration(34, size, 0);
    }

    private final long $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputStallDuration(int format, Size size) {
        this.checkArgumentFormatSupported(format, true);
        return this.getInternalFormatDuration(StreamConfigurationMap.imageFormatToInternal(format), size, 1);
    }

    private final <T> long $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputStallDuration(Class<T> klass, Size size) {
        if (!StreamConfigurationMap.isOutputSupportedFor(klass)) {
            throw new IllegalArgumentException("klass was not supported");
        }
        return this.getInternalFormatDuration(34, size, 1);
    }

    private final boolean $$robo$$android_hardware_camera2_params_StreamConfigurationMap$equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof StreamConfigurationMap) {
            StreamConfigurationMap other = (StreamConfigurationMap)obj;
            return Arrays.equals(this.mConfigurations, other.mConfigurations) && Arrays.equals(this.mMinFrameDurations, other.mMinFrameDurations) && Arrays.equals(this.mStallDurations, other.mStallDurations) && Arrays.equals(this.mHighSpeedVideoConfigurations, other.mHighSpeedVideoConfigurations);
        }
        return false;
    }

    private final int $$robo$$android_hardware_camera2_params_StreamConfigurationMap$hashCode() {
        return HashCodeHelpers.hashCode(this.mConfigurations, this.mMinFrameDurations, this.mStallDurations, this.mHighSpeedVideoConfigurations);
    }

    private final int $$robo$$android_hardware_camera2_params_StreamConfigurationMap$checkArgumentFormatSupported(int format, boolean output) {
        StreamConfigurationMap.checkArgumentFormat(format);
        int[] formats = output ? this.getOutputFormats() : this.getInputFormats();
        for (int i = 0; i < formats.length; ++i) {
            if (format != formats[i]) continue;
            return format;
        }
        throw new IllegalArgumentException(String.format("format %x is not supported by this stream configuration map", format));
    }

    private static final int $$robo$$android_hardware_camera2_params_StreamConfigurationMap$checkArgumentFormatInternal(int format) {
        switch (format) {
            case 33: 
            case 34: 
            case 36: {
                return format;
            }
            case 256: {
                throw new IllegalArgumentException("ImageFormat.JPEG is an unknown internal format");
            }
        }
        return StreamConfigurationMap.checkArgumentFormat(format);
    }

    private static final int $$robo$$android_hardware_camera2_params_StreamConfigurationMap$checkArgumentFormat(int format) {
        if (!ImageFormat.isPublicFormat(format) && !PixelFormat.isPublicFormat(format)) {
            throw new IllegalArgumentException(String.format("format 0x%x was not defined in either ImageFormat or PixelFormat", format));
        }
        return format;
    }

    private static final int $$robo$$android_hardware_camera2_params_StreamConfigurationMap$imageFormatToPublic(int format) {
        switch (format) {
            case 33: {
                return 256;
            }
            case 256: {
                throw new IllegalArgumentException("ImageFormat.JPEG is an unknown internal format");
            }
            case 34: {
                throw new IllegalArgumentException("IMPLEMENTATION_DEFINED must not leak to public API");
            }
        }
        return format;
    }

    private static final int[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$imageFormatToPublic(int[] formats) {
        if (formats == null) {
            return null;
        }
        for (int i = 0; i < formats.length; ++i) {
            formats[i] = StreamConfigurationMap.imageFormatToPublic(formats[i]);
        }
        return formats;
    }

    private static final int $$robo$$android_hardware_camera2_params_StreamConfigurationMap$imageFormatToInternal(int format) {
        switch (format) {
            case 256: {
                return 33;
            }
            case 34: {
                throw new IllegalArgumentException("IMPLEMENTATION_DEFINED is not allowed via public API");
            }
        }
        return format;
    }

    private static final int[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$imageFormatToInternal(int[] formats) {
        if (formats == null) {
            return null;
        }
        for (int i = 0; i < formats.length; ++i) {
            formats[i] = StreamConfigurationMap.imageFormatToInternal(formats[i]);
        }
        return formats;
    }

    private final Size[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getPublicFormatSizes(int format, boolean output) {
        try {
            this.checkArgumentFormatSupported(format, output);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        format = StreamConfigurationMap.imageFormatToInternal(format);
        return this.getInternalFormatSizes(format, output);
    }

    private final Size[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getInternalFormatSizes(int format, boolean output) {
        HashMap<Integer, Integer> formatsMap = this.getFormatsMap(output);
        Integer sizesCount = formatsMap.get(format);
        if (sizesCount == null) {
            throw new IllegalArgumentException("format not available");
        }
        int len = sizesCount;
        Size[] sizes = new Size[len];
        int sizeIndex = 0;
        for (StreamConfiguration config : this.mConfigurations) {
            if (config.getFormat() != format || config.isOutput() != output) continue;
            sizes[sizeIndex++] = config.getSize();
        }
        if (sizeIndex != len) {
            throw new AssertionError((Object)("Too few sizes (expected " + len + ", actual " + sizeIndex + ")"));
        }
        return sizes;
    }

    private final int[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getPublicFormats(boolean output) {
        int[] formats = new int[this.getPublicFormatCount(output)];
        int i = 0;
        for (int format : this.getFormatsMap(output).keySet()) {
            if (format == 34) continue;
            formats[i++] = format;
        }
        if (formats.length != i) {
            throw new AssertionError((Object)("Too few formats " + i + ", expected " + formats.length));
        }
        return StreamConfigurationMap.imageFormatToPublic(formats);
    }

    private final HashMap<Integer, Integer> $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getFormatsMap(boolean output) {
        return output ? this.mOutputFormats : this.mInputFormats;
    }

    private final long $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getInternalFormatDuration(int format, Size size, int duration) {
        StreamConfigurationDuration[] durations;
        if (!StreamConfigurationMap.arrayContains(this.getInternalFormatSizes(format, true), size)) {
            throw new IllegalArgumentException("size was not supported");
        }
        for (StreamConfigurationDuration configurationDuration : durations = this.getDurations(duration)) {
            if (configurationDuration.getFormat() != format || configurationDuration.getWidth() != size.getWidth() || configurationDuration.getHeight() != size.getHeight()) continue;
            return configurationDuration.getDuration();
        }
        return 0L;
    }

    private final StreamConfigurationDuration[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getDurations(int duration) {
        switch (duration) {
            case 0: {
                return this.mMinFrameDurations;
            }
            case 1: {
                return this.mStallDurations;
            }
        }
        throw new IllegalArgumentException("duration was invalid");
    }

    private final int $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getPublicFormatCount(boolean output) {
        HashMap<Integer, Integer> formatsMap = this.getFormatsMap(output);
        int size = formatsMap.size();
        if (formatsMap.containsKey(34)) {
            --size;
        }
        return size;
    }

    private static final <T> boolean $$robo$$android_hardware_camera2_params_StreamConfigurationMap$arrayContains(T[] array2, T element) {
        if (array2 == null) {
            return false;
        }
        for (T el : array2) {
            if (!Objects.equals(el, element)) continue;
            return true;
        }
        return false;
    }

    private void __constructor__(StreamConfiguration[] streamConfigurationArray, StreamConfigurationDuration[] streamConfigurationDurationArray, StreamConfigurationDuration[] streamConfigurationDurationArray2, HighSpeedVideoConfiguration[] highSpeedVideoConfigurationArray) {
        this.$$robo$$android_hardware_camera2_params_StreamConfigurationMap$__constructor__(streamConfigurationArray, streamConfigurationDurationArray, streamConfigurationDurationArray2, highSpeedVideoConfigurationArray);
    }

    public StreamConfigurationMap(StreamConfiguration[] streamConfigurationArray, StreamConfigurationDuration[] streamConfigurationDurationArray, StreamConfigurationDuration[] streamConfigurationDurationArray2, HighSpeedVideoConfiguration[] highSpeedVideoConfigurationArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$__constructor__(android.hardware.camera2.params.StreamConfiguration[] android.hardware.camera2.params.StreamConfigurationDuration[] android.hardware.camera2.params.StreamConfigurationDuration[] android.hardware.camera2.params.HighSpeedVideoConfiguration[] ), 0, this, streamConfigurationArray, streamConfigurationDurationArray, streamConfigurationDurationArray2, highSpeedVideoConfigurationArray);
    }

    public int[] getOutputFormats() {
        return InvokeDynamicSupport.bootstrap("getOutputFormats", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputFormats(), 0, this);
    }

    public int[] getInputFormats() {
        return InvokeDynamicSupport.bootstrap("getInputFormats", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getInputFormats(), 0, this);
    }

    public Size[] getInputSizes(int n) {
        return InvokeDynamicSupport.bootstrap("getInputSizes", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getInputSizes(int ), 0, this, n);
    }

    public boolean isOutputSupportedFor(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOutputSupportedFor", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$isOutputSupportedFor(int ), 0, this, n);
    }

    public static <T> boolean isOutputSupportedFor(Class<T> clazz) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isOutputSupportedFor", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$isOutputSupportedFor(java.lang.Class<T> ), 0, clazz);
    }

    public boolean isOutputSupportedFor(Surface surface) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOutputSupportedFor", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$isOutputSupportedFor(android.view.Surface ), 0, this, surface);
    }

    public <T> Size[] getOutputSizes(Class<T> clazz) {
        return InvokeDynamicSupport.bootstrap("getOutputSizes", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputSizes(java.lang.Class<T> ), 0, this, clazz);
    }

    public Size[] getOutputSizes(int n) {
        return InvokeDynamicSupport.bootstrap("getOutputSizes", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputSizes(int ), 0, this, n);
    }

    public Size[] getHighSpeedVideoSizes() {
        return InvokeDynamicSupport.bootstrap("getHighSpeedVideoSizes", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getHighSpeedVideoSizes(), 0, this);
    }

    public Range<Integer>[] getHighSpeedVideoFpsRangesFor(Size size) {
        return InvokeDynamicSupport.bootstrap("getHighSpeedVideoFpsRangesFor", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getHighSpeedVideoFpsRangesFor(android.util.Size ), 0, this, size);
    }

    public Range<Integer>[] getHighSpeedVideoFpsRanges() {
        return InvokeDynamicSupport.bootstrap("getHighSpeedVideoFpsRanges", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getHighSpeedVideoFpsRanges(), 0, this);
    }

    public Size[] getHighSpeedVideoSizesFor(Range<Integer> range) {
        return InvokeDynamicSupport.bootstrap("getHighSpeedVideoSizesFor", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getHighSpeedVideoSizesFor(android.util.Range<java.lang.Integer> ), 0, this, range);
    }

    public long getOutputMinFrameDuration(int n, Size size) {
        return (long)InvokeDynamicSupport.bootstrap("getOutputMinFrameDuration", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputMinFrameDuration(int android.util.Size ), 0, this, n, size);
    }

    public <T> long getOutputMinFrameDuration(Class<T> clazz, Size size) {
        return (long)InvokeDynamicSupport.bootstrap("getOutputMinFrameDuration", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputMinFrameDuration(java.lang.Class<T> android.util.Size ), 0, this, clazz, size);
    }

    public long getOutputStallDuration(int n, Size size) {
        return (long)InvokeDynamicSupport.bootstrap("getOutputStallDuration", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputStallDuration(int android.util.Size ), 0, this, n, size);
    }

    public <T> long getOutputStallDuration(Class<T> clazz, Size size) {
        return (long)InvokeDynamicSupport.bootstrap("getOutputStallDuration", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputStallDuration(java.lang.Class<T> android.util.Size ), 0, this, clazz, size);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$hashCode(), 0, this);
    }

    private int checkArgumentFormatSupported(int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("checkArgumentFormatSupported", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$checkArgumentFormatSupported(int boolean ), 0, this, n, bl);
    }

    static int checkArgumentFormatInternal(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkArgumentFormatInternal", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$checkArgumentFormatInternal(int ), 0, (int)n);
    }

    static int checkArgumentFormat(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkArgumentFormat", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$checkArgumentFormat(int ), 0, (int)n);
    }

    static int imageFormatToPublic(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("imageFormatToPublic", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$imageFormatToPublic(int ), 0, (int)n);
    }

    static int[] imageFormatToPublic(int[] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("imageFormatToPublic", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$imageFormatToPublic(int[] ), 0, (int[])nArray);
    }

    static int imageFormatToInternal(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("imageFormatToInternal", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$imageFormatToInternal(int ), 0, (int)n);
    }

    public static int[] imageFormatToInternal(int[] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("imageFormatToInternal", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$imageFormatToInternal(int[] ), 0, (int[])nArray);
    }

    private Size[] getPublicFormatSizes(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getPublicFormatSizes", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getPublicFormatSizes(int boolean ), 0, this, n, bl);
    }

    private Size[] getInternalFormatSizes(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getInternalFormatSizes", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getInternalFormatSizes(int boolean ), 0, this, n, bl);
    }

    private int[] getPublicFormats(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getPublicFormats", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getPublicFormats(boolean ), 0, this, bl);
    }

    private HashMap<Integer, Integer> getFormatsMap(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getFormatsMap", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getFormatsMap(boolean ), 0, this, bl);
    }

    private long getInternalFormatDuration(int n, Size size, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("getInternalFormatDuration", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getInternalFormatDuration(int android.util.Size int ), 0, this, n, size, n2);
    }

    private StreamConfigurationDuration[] getDurations(int n) {
        return InvokeDynamicSupport.bootstrap("getDurations", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getDurations(int ), 0, this, n);
    }

    private int getPublicFormatCount(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getPublicFormatCount", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getPublicFormatCount(boolean ), 0, this, bl);
    }

    private static <T> boolean arrayContains(T[] TArray, T t) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("arrayContains", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$arrayContains(T[] T ), 0, (Object[])TArray, t);
    }

    public /* synthetic */ StreamConfigurationMap() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StreamConfigurationMap)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

