/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.graphics.PointF;
import android.hardware.camera2.utils.HashCodeHelpers;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class TonemapCurve
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static float LEVEL_BLACK = 0.0f;
    public static float LEVEL_WHITE = 1.0f;
    public static int POINT_SIZE = 2;
    public static int CHANNEL_RED = 0;
    public static int CHANNEL_GREEN = 1;
    public static int CHANNEL_BLUE = 2;
    private static int OFFSET_POINT_IN = 0;
    private static int OFFSET_POINT_OUT = 1;
    private static int TONEMAP_MIN_CURVE_POINTS = 2;
    private static int MIN_CURVE_LENGTH = 4;
    private float[] mRed;
    private float[] mGreen;
    private float[] mBlue;
    private int mHashCode;
    private boolean mHashCalculated;

    private void $$robo$$android_hardware_camera2_params_TonemapCurve$__constructor__(float[] red, float[] green, float[] blue) {
        this.mHashCalculated = false;
        Preconditions.checkNotNull(red, "red must not be null");
        Preconditions.checkNotNull(green, "green must not be null");
        Preconditions.checkNotNull(blue, "blue must not be null");
        TonemapCurve.checkArgumentArrayLengthDivisibleBy(red, 2, "red");
        TonemapCurve.checkArgumentArrayLengthDivisibleBy(green, 2, "green");
        TonemapCurve.checkArgumentArrayLengthDivisibleBy(blue, 2, "blue");
        TonemapCurve.checkArgumentArrayLengthNoLessThan(red, 4, "red");
        TonemapCurve.checkArgumentArrayLengthNoLessThan(green, 4, "green");
        TonemapCurve.checkArgumentArrayLengthNoLessThan(blue, 4, "blue");
        Preconditions.checkArrayElementsInRange(red, 0.0f, 1.0f, "red");
        Preconditions.checkArrayElementsInRange(green, 0.0f, 1.0f, "green");
        Preconditions.checkArrayElementsInRange(blue, 0.0f, 1.0f, "blue");
        this.mRed = Arrays.copyOf(red, red.length);
        this.mGreen = Arrays.copyOf(green, green.length);
        this.mBlue = Arrays.copyOf(blue, blue.length);
    }

    private static final void $$robo$$android_hardware_camera2_params_TonemapCurve$checkArgumentArrayLengthDivisibleBy(float[] array2, int divisible, String arrayName) {
        if (array2.length % divisible != 0) {
            throw new IllegalArgumentException(arrayName + " size must be divisible by " + divisible);
        }
    }

    private static final int $$robo$$android_hardware_camera2_params_TonemapCurve$checkArgumentColorChannel(int colorChannel) {
        switch (colorChannel) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("colorChannel out of range");
            }
        }
        return colorChannel;
    }

    private static final void $$robo$$android_hardware_camera2_params_TonemapCurve$checkArgumentArrayLengthNoLessThan(float[] array2, int minLength, String arrayName) {
        if (array2.length < minLength) {
            throw new IllegalArgumentException(arrayName + " size must be at least " + minLength);
        }
    }

    private final int $$robo$$android_hardware_camera2_params_TonemapCurve$getPointCount(int colorChannel) {
        TonemapCurve.checkArgumentColorChannel(colorChannel);
        return this.getCurve(colorChannel).length / 2;
    }

    private final PointF $$robo$$android_hardware_camera2_params_TonemapCurve$getPoint(int colorChannel, int index) {
        TonemapCurve.checkArgumentColorChannel(colorChannel);
        if (index < 0 || index >= this.getPointCount(colorChannel)) {
            throw new IllegalArgumentException("index out of range");
        }
        float[] curve = this.getCurve(colorChannel);
        float pIn = curve[index * 2 + 0];
        float pOut = curve[index * 2 + 1];
        return new PointF(pIn, pOut);
    }

    private final void $$robo$$android_hardware_camera2_params_TonemapCurve$copyColorCurve(int colorChannel, float[] destination, int offset) {
        Preconditions.checkArgumentNonnegative(offset, "offset must not be negative");
        Preconditions.checkNotNull(destination, "destination must not be null");
        if (destination.length + offset < this.getPointCount(colorChannel) * 2) {
            throw new ArrayIndexOutOfBoundsException("destination too small to fit elements");
        }
        float[] curve = this.getCurve(colorChannel);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (float[])curve, (int)0, (float[])destination, (int)offset, (int)curve.length);
    }

    private final boolean $$robo$$android_hardware_camera2_params_TonemapCurve$equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof TonemapCurve) {
            TonemapCurve other = (TonemapCurve)obj;
            return Arrays.equals(this.mRed, other.mRed) && Arrays.equals(this.mGreen, other.mGreen) && Arrays.equals(this.mBlue, other.mBlue);
        }
        return false;
    }

    private final int $$robo$$android_hardware_camera2_params_TonemapCurve$hashCode() {
        if (this.mHashCalculated) {
            return this.mHashCode;
        }
        this.mHashCode = HashCodeHelpers.hashCode(this.mRed, this.mGreen, this.mBlue);
        this.mHashCalculated = true;
        return this.mHashCode;
    }

    private final String $$robo$$android_hardware_camera2_params_TonemapCurve$toString() {
        StringBuilder sb = new StringBuilder("TonemapCurve{");
        sb.append("R:");
        sb.append(this.curveToString(0));
        sb.append(", G:");
        sb.append(this.curveToString(1));
        sb.append(", B:");
        sb.append(this.curveToString(2));
        sb.append("}");
        return sb.toString();
    }

    private final String $$robo$$android_hardware_camera2_params_TonemapCurve$curveToString(int colorChannel) {
        TonemapCurve.checkArgumentColorChannel(colorChannel);
        StringBuilder sb = new StringBuilder("[");
        float[] curve = this.getCurve(colorChannel);
        int pointCount = curve.length / 2;
        int i = 0;
        int j = 0;
        while (i < pointCount) {
            sb.append("(");
            sb.append(curve[j]);
            sb.append(", ");
            sb.append(curve[j + 1]);
            sb.append("), ");
            ++i;
            j += 2;
        }
        sb.setLength(sb.length() - 2);
        sb.append("]");
        return sb.toString();
    }

    private final float[] $$robo$$android_hardware_camera2_params_TonemapCurve$getCurve(int colorChannel) {
        switch (colorChannel) {
            case 0: {
                return this.mRed;
            }
            case 1: {
                return this.mGreen;
            }
            case 2: {
                return this.mBlue;
            }
        }
        throw new AssertionError((Object)"colorChannel out of range");
    }

    private void __constructor__(float[] fArray, float[] fArray2, float[] fArray3) {
        this.$$robo$$android_hardware_camera2_params_TonemapCurve$__constructor__(fArray, fArray2, fArray3);
    }

    public TonemapCurve(float[] fArray, float[] fArray2, float[] fArray3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_params_TonemapCurve$__constructor__(float[] float[] float[] ), 0, this, fArray, fArray2, fArray3);
    }

    private static void checkArgumentArrayLengthDivisibleBy(float[] fArray, int n, String string2) {
        InvokeDynamicSupport.bootstrapStatic("checkArgumentArrayLengthDivisibleBy", $$robo$$android_hardware_camera2_params_TonemapCurve$checkArgumentArrayLengthDivisibleBy(float[] int java.lang.String ), 0, (float[])fArray, (int)n, (String)string2);
    }

    private static int checkArgumentColorChannel(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkArgumentColorChannel", $$robo$$android_hardware_camera2_params_TonemapCurve$checkArgumentColorChannel(int ), 0, (int)n);
    }

    private static void checkArgumentArrayLengthNoLessThan(float[] fArray, int n, String string2) {
        InvokeDynamicSupport.bootstrapStatic("checkArgumentArrayLengthNoLessThan", $$robo$$android_hardware_camera2_params_TonemapCurve$checkArgumentArrayLengthNoLessThan(float[] int java.lang.String ), 0, (float[])fArray, (int)n, (String)string2);
    }

    public int getPointCount(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPointCount", $$robo$$android_hardware_camera2_params_TonemapCurve$getPointCount(int ), 0, this, n);
    }

    public PointF getPoint(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getPoint", $$robo$$android_hardware_camera2_params_TonemapCurve$getPoint(int int ), 0, this, n, n2);
    }

    public void copyColorCurve(int n, float[] fArray, int n2) {
        InvokeDynamicSupport.bootstrap("copyColorCurve", $$robo$$android_hardware_camera2_params_TonemapCurve$copyColorCurve(int float[] int ), 0, this, n, fArray, n2);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_camera2_params_TonemapCurve$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_camera2_params_TonemapCurve$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_hardware_camera2_params_TonemapCurve$toString(), 0, this);
    }

    private String curveToString(int n) {
        return InvokeDynamicSupport.bootstrap("curveToString", $$robo$$android_hardware_camera2_params_TonemapCurve$curveToString(int ), 0, this, n);
    }

    private float[] getCurve(int n) {
        return InvokeDynamicSupport.bootstrap("getCurve", $$robo$$android_hardware_camera2_params_TonemapCurve$getCurve(int ), 0, this, n);
    }

    public /* synthetic */ TonemapCurve() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TonemapCurve)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

