/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.hardware.hdmi.HdmiControlManager;
import android.hardware.hdmi.HdmiDeviceInfo;
import android.hardware.hdmi.IHdmiControlService;
import android.hardware.hdmi.IHdmiVendorCommandListener;
import android.os.RemoteException;
import android.util.Log;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class HdmiClient
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "HdmiClient";
    protected IHdmiControlService mService;

    protected abstract int getDeviceType();

    private void $$robo$$android_hardware_hdmi_HdmiClient$__constructor__(IHdmiControlService service) {
        this.mService = service;
    }

    private final HdmiDeviceInfo $$robo$$android_hardware_hdmi_HdmiClient$getActiveSource() {
        try {
            return this.mService.getActiveSource();
        }
        catch (RemoteException e) {
            Log.e("HdmiClient", "getActiveSource threw exception ", e);
            return null;
        }
    }

    private final void $$robo$$android_hardware_hdmi_HdmiClient$sendKeyEvent(int keyCode, boolean isPressed) {
        try {
            this.mService.sendKeyEvent(this.getDeviceType(), keyCode, isPressed);
        }
        catch (RemoteException e) {
            Log.e("HdmiClient", "sendKeyEvent threw exception ", e);
        }
    }

    private final void $$robo$$android_hardware_hdmi_HdmiClient$sendVendorCommand(int targetAddress, byte[] params, boolean hasVendorId) {
        try {
            this.mService.sendVendorCommand(this.getDeviceType(), targetAddress, params, hasVendorId);
        }
        catch (RemoteException e) {
            Log.e("HdmiClient", "failed to send vendor command: ", e);
        }
    }

    private final void $$robo$$android_hardware_hdmi_HdmiClient$addVendorCommandListener(HdmiControlManager.VendorCommandListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        try {
            this.mService.addVendorCommandListener(HdmiClient.getListenerWrapper(listener), this.getDeviceType());
        }
        catch (RemoteException e) {
            Log.e("HdmiClient", "failed to add vendor command listener: ", e);
        }
    }

    private static final IHdmiVendorCommandListener $$robo$$android_hardware_hdmi_HdmiClient$getListenerWrapper(HdmiControlManager.VendorCommandListener listener) {
        return new ShadowedObject(listener){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ HdmiControlManager.VendorCommandListener val$listener;

            private void $$robo$$android_hardware_hdmi_HdmiClient_1$__constructor__(HdmiControlManager.VendorCommandListener vendorCommandListener) {
            }

            private final void $$robo$$android_hardware_hdmi_HdmiClient_1$onReceived(int srcAddress, byte[] params, boolean hasVendorId) {
                this.val$listener.onReceived(srcAddress, params, hasVendorId);
            }

            private void __constructor__(HdmiControlManager.VendorCommandListener vendorCommandListener) {
                this.$$robo$$android_hardware_hdmi_HdmiClient_1$__constructor__(vendorCommandListener);
            }
            {
                this.val$listener = vendorCommandListener;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiClient_1$__constructor__(android.hardware.hdmi.HdmiControlManager$VendorCommandListener ), 0, this, vendorCommandListener);
            }

            @Override
            public void onReceived(int n, byte[] byArray, boolean bl) {
                InvokeDynamicSupport.bootstrap("onReceived", $$robo$$android_hardware_hdmi_HdmiClient_1$onReceived(int byte[] boolean ), 0, this, n, byArray, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(IHdmiControlService iHdmiControlService) {
        this.$$robo$$android_hardware_hdmi_HdmiClient$__constructor__(iHdmiControlService);
    }

    public HdmiClient(IHdmiControlService iHdmiControlService) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiClient$__constructor__(android.hardware.hdmi.IHdmiControlService ), 0, this, iHdmiControlService);
    }

    public HdmiDeviceInfo getActiveSource() {
        return InvokeDynamicSupport.bootstrap("getActiveSource", $$robo$$android_hardware_hdmi_HdmiClient$getActiveSource(), 0, this);
    }

    public void sendKeyEvent(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("sendKeyEvent", $$robo$$android_hardware_hdmi_HdmiClient$sendKeyEvent(int boolean ), 0, this, n, bl);
    }

    public void sendVendorCommand(int n, byte[] byArray, boolean bl) {
        InvokeDynamicSupport.bootstrap("sendVendorCommand", $$robo$$android_hardware_hdmi_HdmiClient$sendVendorCommand(int byte[] boolean ), 0, this, n, byArray, bl);
    }

    public void addVendorCommandListener(HdmiControlManager.VendorCommandListener vendorCommandListener) {
        InvokeDynamicSupport.bootstrap("addVendorCommandListener", $$robo$$android_hardware_hdmi_HdmiClient$addVendorCommandListener(android.hardware.hdmi.HdmiControlManager$VendorCommandListener ), 0, this, vendorCommandListener);
    }

    private static IHdmiVendorCommandListener getListenerWrapper(HdmiControlManager.VendorCommandListener vendorCommandListener) {
        return InvokeDynamicSupport.bootstrapStatic("getListenerWrapper", $$robo$$android_hardware_hdmi_HdmiClient$getListenerWrapper(android.hardware.hdmi.HdmiControlManager$VendorCommandListener ), 0, (HdmiControlManager.VendorCommandListener)vendorCommandListener);
    }

    public /* synthetic */ HdmiClient() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HdmiClient)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

