/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.os.Parcel;
import android.os.Parcelable;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class HdmiDeviceInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int DEVICE_TV = 0;
    public static int DEVICE_RECORDER = 1;
    public static int DEVICE_RESERVED = 2;
    public static int DEVICE_TUNER = 3;
    public static int DEVICE_PLAYBACK = 4;
    public static int DEVICE_AUDIO_SYSTEM = 5;
    public static int DEVICE_PURE_CEC_SWITCH = 6;
    public static int DEVICE_VIDEO_PROCESSOR = 7;
    public static int DEVICE_INACTIVE = -1;
    public static int ADDR_INTERNAL = 0;
    public static int PATH_INTERNAL = 0;
    public static int PATH_INVALID = 65535;
    public static int PORT_INVALID = -1;
    private static int HDMI_DEVICE_TYPE_CEC = 0;
    private static int HDMI_DEVICE_TYPE_MHL = 1;
    private static int HDMI_DEVICE_TYPE_HARDWARE = 2;
    private static int ID_OFFSET_CEC = 0;
    private static int ID_OFFSET_MHL = 128;
    private static int ID_OFFSET_HARDWARE = 192;
    private int mId;
    private int mHdmiDeviceType;
    private int mPhysicalAddress;
    private int mPortId;
    private int mLogicalAddress;
    private int mDeviceType;
    private int mVendorId;
    private String mDisplayName;
    private int mDevicePowerStatus;
    private int mDeviceId;
    private int mAdopterId;
    public static Parcelable.Creator<HdmiDeviceInfo> CREATOR;

    private void $$robo$$android_hardware_hdmi_HdmiDeviceInfo$__constructor__(int logicalAddress, int physicalAddress, int portId, int deviceType, int vendorId, String displayName, int powerStatus) {
        this.mHdmiDeviceType = 0;
        this.mPhysicalAddress = physicalAddress;
        this.mPortId = portId;
        this.mId = HdmiDeviceInfo.idForCecDevice(logicalAddress);
        this.mLogicalAddress = logicalAddress;
        this.mDeviceType = deviceType;
        this.mVendorId = vendorId;
        this.mDevicePowerStatus = powerStatus;
        this.mDisplayName = displayName;
        this.mDeviceId = -1;
        this.mAdopterId = -1;
    }

    private void $$robo$$android_hardware_hdmi_HdmiDeviceInfo$__constructor__(int logicalAddress, int physicalAddress, int portId, int deviceType, int vendorId, String displayName) {
    }

    private void $$robo$$android_hardware_hdmi_HdmiDeviceInfo$__constructor__(int physicalAddress, int portId) {
        this.mHdmiDeviceType = 2;
        this.mPhysicalAddress = physicalAddress;
        this.mPortId = portId;
        this.mId = HdmiDeviceInfo.idForHardware(portId);
        this.mLogicalAddress = -1;
        this.mDeviceType = 2;
        this.mVendorId = 0;
        this.mDevicePowerStatus = -1;
        this.mDisplayName = "HDMI" + portId;
        this.mDeviceId = -1;
        this.mAdopterId = -1;
    }

    private void $$robo$$android_hardware_hdmi_HdmiDeviceInfo$__constructor__(int physicalAddress, int portId, int adopterId, int deviceId) {
        this.mHdmiDeviceType = 1;
        this.mPhysicalAddress = physicalAddress;
        this.mPortId = portId;
        this.mId = HdmiDeviceInfo.idForMhlDevice(portId);
        this.mLogicalAddress = -1;
        this.mDeviceType = 2;
        this.mVendorId = 0;
        this.mDevicePowerStatus = -1;
        this.mDisplayName = "Mobile";
        this.mDeviceId = adopterId;
        this.mAdopterId = deviceId;
    }

    private final int $$robo$$android_hardware_hdmi_HdmiDeviceInfo$getId() {
        return this.mId;
    }

    private static final int $$robo$$android_hardware_hdmi_HdmiDeviceInfo$idForCecDevice(int address) {
        return 0 + address;
    }

    private static final int $$robo$$android_hardware_hdmi_HdmiDeviceInfo$idForMhlDevice(int portId) {
        return 128 + portId;
    }

    private static final int $$robo$$android_hardware_hdmi_HdmiDeviceInfo$idForHardware(int portId) {
        return 192 + portId;
    }

    private final int $$robo$$android_hardware_hdmi_HdmiDeviceInfo$getLogicalAddress() {
        return this.mLogicalAddress;
    }

    private final int $$robo$$android_hardware_hdmi_HdmiDeviceInfo$getPhysicalAddress() {
        return this.mPhysicalAddress;
    }

    private final int $$robo$$android_hardware_hdmi_HdmiDeviceInfo$getPortId() {
        return this.mPortId;
    }

    private final int $$robo$$android_hardware_hdmi_HdmiDeviceInfo$getDeviceType() {
        return this.mDeviceType;
    }

    private final int $$robo$$android_hardware_hdmi_HdmiDeviceInfo$getDevicePowerStatus() {
        return this.mDevicePowerStatus;
    }

    private final int $$robo$$android_hardware_hdmi_HdmiDeviceInfo$getDeviceId() {
        return this.mDeviceId;
    }

    private final int $$robo$$android_hardware_hdmi_HdmiDeviceInfo$getAdopterId() {
        return this.mAdopterId;
    }

    private final boolean $$robo$$android_hardware_hdmi_HdmiDeviceInfo$isSourceType() {
        return this.mDeviceType == 4 || this.mDeviceType == 1 || this.mDeviceType == 3;
    }

    private final boolean $$robo$$android_hardware_hdmi_HdmiDeviceInfo$isCecDevice() {
        return this.mHdmiDeviceType == 0;
    }

    private final boolean $$robo$$android_hardware_hdmi_HdmiDeviceInfo$isMhlDevice() {
        return this.mHdmiDeviceType == 1;
    }

    private final String $$robo$$android_hardware_hdmi_HdmiDeviceInfo$getDisplayName() {
        return this.mDisplayName;
    }

    private final int $$robo$$android_hardware_hdmi_HdmiDeviceInfo$getVendorId() {
        return this.mVendorId;
    }

    private final int $$robo$$android_hardware_hdmi_HdmiDeviceInfo$describeContents() {
        return 0;
    }

    private final void $$robo$$android_hardware_hdmi_HdmiDeviceInfo$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mHdmiDeviceType);
        dest.writeInt(this.mPhysicalAddress);
        dest.writeInt(this.mPortId);
        switch (this.mHdmiDeviceType) {
            case 0: {
                dest.writeInt(this.mLogicalAddress);
                dest.writeInt(this.mDeviceType);
                dest.writeInt(this.mVendorId);
                dest.writeInt(this.mDevicePowerStatus);
                dest.writeString(this.mDisplayName);
                break;
            }
            case 1: {
                dest.writeInt(this.mDeviceId);
                dest.writeInt(this.mAdopterId);
                break;
            }
        }
    }

    private final String $$robo$$android_hardware_hdmi_HdmiDeviceInfo$toString() {
        StringBuffer s = new StringBuffer();
        switch (this.mHdmiDeviceType) {
            case 0: {
                s.append("CEC: ");
                s.append("logical_address: ").append(String.format("0x%02X", this.mLogicalAddress));
                s.append(" ");
                s.append("device_type: ").append(this.mDeviceType).append(" ");
                s.append("vendor_id: ").append(this.mVendorId).append(" ");
                s.append("display_name: ").append(this.mDisplayName).append(" ");
                s.append("power_status: ").append(this.mDevicePowerStatus).append(" ");
                break;
            }
            case 1: {
                s.append("MHL: ");
                s.append("device_id: ").append(String.format("0x%04X", this.mDeviceId)).append(" ");
                s.append("adopter_id: ").append(String.format("0x%04X", this.mAdopterId)).append(" ");
                break;
            }
            case 2: {
                s.append("Hardware: ");
                break;
            }
            default: {
                return "";
            }
        }
        s.append("physical_address: ").append(String.format("0x%04X", this.mPhysicalAddress));
        s.append(" ");
        s.append("port_id: ").append(this.mPortId);
        return s.toString();
    }

    private final boolean $$robo$$android_hardware_hdmi_HdmiDeviceInfo$equals(Object obj) {
        if (!(obj instanceof HdmiDeviceInfo)) {
            return false;
        }
        HdmiDeviceInfo other = (HdmiDeviceInfo)obj;
        return this.mHdmiDeviceType == other.mHdmiDeviceType && this.mPhysicalAddress == other.mPhysicalAddress && this.mPortId == other.mPortId && this.mLogicalAddress == other.mLogicalAddress && this.mDeviceType == other.mDeviceType && this.mVendorId == other.mVendorId && this.mDevicePowerStatus == other.mDevicePowerStatus && this.mDisplayName.equals(other.mDisplayName) && this.mDeviceId == other.mDeviceId && this.mAdopterId == other.mAdopterId;
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<HdmiDeviceInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_hdmi_HdmiDeviceInfo_1$__constructor__() {
            }

            private final HdmiDeviceInfo $$robo$$android_hardware_hdmi_HdmiDeviceInfo_1$createFromParcel(Parcel source) {
                int hdmiDeviceType = source.readInt();
                int physicalAddress = source.readInt();
                int portId = source.readInt();
                switch (hdmiDeviceType) {
                    case 0: {
                        int logicalAddress = source.readInt();
                        int deviceType = source.readInt();
                        int vendorId = source.readInt();
                        int powerStatus = source.readInt();
                        String displayName = source.readString();
                        return new HdmiDeviceInfo(logicalAddress, physicalAddress, portId, deviceType, vendorId, displayName, powerStatus);
                    }
                    case 1: {
                        int deviceId = source.readInt();
                        int adopterId = source.readInt();
                        return new HdmiDeviceInfo(physicalAddress, portId, adopterId, deviceId);
                    }
                    case 2: {
                        return new HdmiDeviceInfo(physicalAddress, portId);
                    }
                }
                return null;
            }

            private final HdmiDeviceInfo[] $$robo$$android_hardware_hdmi_HdmiDeviceInfo_1$newArray(int size) {
                return new HdmiDeviceInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_hdmi_HdmiDeviceInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiDeviceInfo_1$__constructor__(), 0, this);
            }

            @Override
            public HdmiDeviceInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_hardware_hdmi_HdmiDeviceInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public HdmiDeviceInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_hardware_hdmi_HdmiDeviceInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5, String string2, int n6) {
        this.$$robo$$android_hardware_hdmi_HdmiDeviceInfo$__constructor__(n, n2, n3, n4, n5, string2, n6);
    }

    public HdmiDeviceInfo(int n, int n2, int n3, int n4, int n5, String string2, int n6) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiDeviceInfo$__constructor__(int int int int int java.lang.String int ), 0, this, n, n2, n3, n4, n5, string2, n6);
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5, String string2) {
        this.$$robo$$android_hardware_hdmi_HdmiDeviceInfo$__constructor__(n, n2, n3, n4, n5, string2);
    }

    public HdmiDeviceInfo(int n, int n2, int n3, int n4, int n5, String string2) {
        this(n, n2, n3, n4, n5, string2, -1);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiDeviceInfo$__constructor__(int int int int int java.lang.String ), 0, this, n, n2, n3, n4, n5, string2);
    }

    private void __constructor__(int n, int n2) {
        this.$$robo$$android_hardware_hdmi_HdmiDeviceInfo$__constructor__(n, n2);
    }

    public HdmiDeviceInfo(int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiDeviceInfo$__constructor__(int int ), 0, this, n, n2);
    }

    private void __constructor__(int n, int n2, int n3, int n4) {
        this.$$robo$$android_hardware_hdmi_HdmiDeviceInfo$__constructor__(n, n2, n3, n4);
    }

    public HdmiDeviceInfo(int n, int n2, int n3, int n4) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_hdmi_HdmiDeviceInfo$__constructor__(int int int int ), 0, this, n, n2, n3, n4);
    }

    public int getId() {
        return (int)InvokeDynamicSupport.bootstrap("getId", $$robo$$android_hardware_hdmi_HdmiDeviceInfo$getId(), 0, this);
    }

    public static int idForCecDevice(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("idForCecDevice", $$robo$$android_hardware_hdmi_HdmiDeviceInfo$idForCecDevice(int ), 0, (int)n);
    }

    public static int idForMhlDevice(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("idForMhlDevice", $$robo$$android_hardware_hdmi_HdmiDeviceInfo$idForMhlDevice(int ), 0, (int)n);
    }

    public static int idForHardware(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("idForHardware", $$robo$$android_hardware_hdmi_HdmiDeviceInfo$idForHardware(int ), 0, (int)n);
    }

    public int getLogicalAddress() {
        return (int)InvokeDynamicSupport.bootstrap("getLogicalAddress", $$robo$$android_hardware_hdmi_HdmiDeviceInfo$getLogicalAddress(), 0, this);
    }

    public int getPhysicalAddress() {
        return (int)InvokeDynamicSupport.bootstrap("getPhysicalAddress", $$robo$$android_hardware_hdmi_HdmiDeviceInfo$getPhysicalAddress(), 0, this);
    }

    public int getPortId() {
        return (int)InvokeDynamicSupport.bootstrap("getPortId", $$robo$$android_hardware_hdmi_HdmiDeviceInfo$getPortId(), 0, this);
    }

    public int getDeviceType() {
        return (int)InvokeDynamicSupport.bootstrap("getDeviceType", $$robo$$android_hardware_hdmi_HdmiDeviceInfo$getDeviceType(), 0, this);
    }

    public int getDevicePowerStatus() {
        return (int)InvokeDynamicSupport.bootstrap("getDevicePowerStatus", $$robo$$android_hardware_hdmi_HdmiDeviceInfo$getDevicePowerStatus(), 0, this);
    }

    public int getDeviceId() {
        return (int)InvokeDynamicSupport.bootstrap("getDeviceId", $$robo$$android_hardware_hdmi_HdmiDeviceInfo$getDeviceId(), 0, this);
    }

    public int getAdopterId() {
        return (int)InvokeDynamicSupport.bootstrap("getAdopterId", $$robo$$android_hardware_hdmi_HdmiDeviceInfo$getAdopterId(), 0, this);
    }

    public boolean isSourceType() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSourceType", $$robo$$android_hardware_hdmi_HdmiDeviceInfo$isSourceType(), 0, this);
    }

    public boolean isCecDevice() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCecDevice", $$robo$$android_hardware_hdmi_HdmiDeviceInfo$isCecDevice(), 0, this);
    }

    public boolean isMhlDevice() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMhlDevice", $$robo$$android_hardware_hdmi_HdmiDeviceInfo$isMhlDevice(), 0, this);
    }

    public String getDisplayName() {
        return InvokeDynamicSupport.bootstrap("getDisplayName", $$robo$$android_hardware_hdmi_HdmiDeviceInfo$getDisplayName(), 0, this);
    }

    public int getVendorId() {
        return (int)InvokeDynamicSupport.bootstrap("getVendorId", $$robo$$android_hardware_hdmi_HdmiDeviceInfo$getVendorId(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_hardware_hdmi_HdmiDeviceInfo$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_hardware_hdmi_HdmiDeviceInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_hardware_hdmi_HdmiDeviceInfo$toString(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_hdmi_HdmiDeviceInfo$equals(java.lang.Object ), 0, this, object);
    }

    static {
        RobolectricInternals.classInitializing(HdmiDeviceInfo.class);
    }

    public /* synthetic */ HdmiDeviceInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HdmiDeviceInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

