/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.content.Context;
import android.hardware.input.IInputDevicesChangedListener;
import android.hardware.input.IInputManager;
import android.hardware.input.InputDeviceIdentifier;
import android.hardware.input.KeyboardLayout;
import android.hardware.input.TouchCalibration;
import android.media.AudioAttributes;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.Vibrator;
import android.provider.Settings;
import android.util.Log;
import android.util.SparseArray;
import android.view.InputDevice;
import android.view.InputEvent;
import com.android.internal.util.ArrayUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class InputManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "InputManager";
    private static boolean DEBUG = false;
    private static int MSG_DEVICE_ADDED = 1;
    private static int MSG_DEVICE_REMOVED = 2;
    private static int MSG_DEVICE_CHANGED = 3;
    private static InputManager sInstance;
    private IInputManager mIm;
    private Object mInputDevicesLock;
    private SparseArray<InputDevice> mInputDevices;
    private InputDevicesChangedListener mInputDevicesChangedListener;
    private ArrayList<InputDeviceListenerDelegate> mInputDeviceListeners;
    public static String ACTION_QUERY_KEYBOARD_LAYOUTS = "android.hardware.input.action.QUERY_KEYBOARD_LAYOUTS";
    public static String META_DATA_KEYBOARD_LAYOUTS = "android.hardware.input.metadata.KEYBOARD_LAYOUTS";
    public static int MIN_POINTER_SPEED = -7;
    public static int MAX_POINTER_SPEED = 7;
    public static int DEFAULT_POINTER_SPEED = 0;
    public static int INJECT_INPUT_EVENT_MODE_ASYNC = 0;
    public static int INJECT_INPUT_EVENT_MODE_WAIT_FOR_RESULT = 1;
    public static int INJECT_INPUT_EVENT_MODE_WAIT_FOR_FINISH = 2;

    private void $$robo$$android_hardware_input_InputManager$__constructor__(IInputManager im) {
        this.mInputDevicesLock = new Object();
        this.mInputDeviceListeners = new ArrayList();
        this.mIm = im;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final InputManager $$robo$$android_hardware_input_InputManager$getInstance() {
        Class<InputManager> clazz = InputManager.class;
        synchronized (InputManager.class) {
            if (sInstance == null) {
                IBinder b = ServiceManager.getService("input");
                sInstance = new InputManager(IInputManager.Stub.asInterface(b));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final InputDevice $$robo$$android_hardware_input_InputManager$getInputDevice(int id2) {
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            this.populateInputDevicesLocked();
            int index = this.mInputDevices.indexOfKey(id2);
            if (index < 0) {
                return null;
            }
            InputDevice inputDevice = this.mInputDevices.valueAt(index);
            if (inputDevice == null) {
                try {
                    inputDevice = this.mIm.getInputDevice(id2);
                }
                catch (RemoteException ex) {
                    throw new RuntimeException("Could not get input device information.", ex);
                }
                if (inputDevice != null) {
                    this.mInputDevices.setValueAt(index, inputDevice);
                }
            }
            return inputDevice;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final InputDevice $$robo$$android_hardware_input_InputManager$getInputDeviceByDescriptor(String descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor must not be null.");
        }
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            this.populateInputDevicesLocked();
            int numDevices = this.mInputDevices.size();
            for (int i = 0; i < numDevices; ++i) {
                InputDevice inputDevice = this.mInputDevices.valueAt(i);
                if (inputDevice == null) {
                    int id2 = this.mInputDevices.keyAt(i);
                    try {
                        inputDevice = this.mIm.getInputDevice(id2);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    if (inputDevice == null) continue;
                    this.mInputDevices.setValueAt(i, inputDevice);
                }
                if (!descriptor.equals(inputDevice.getDescriptor())) continue;
                return inputDevice;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int[] $$robo$$android_hardware_input_InputManager$getInputDeviceIds() {
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            this.populateInputDevicesLocked();
            int count = this.mInputDevices.size();
            int[] ids = new int[count];
            for (int i = 0; i < count; ++i) {
                ids[i] = this.mInputDevices.keyAt(i);
            }
            return ids;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_input_InputManager$registerInputDeviceListener(InputDeviceListener listener, Handler handler) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            int index = this.findInputDeviceListenerLocked(listener);
            if (index < 0) {
                this.mInputDeviceListeners.add(new InputDeviceListenerDelegate(listener, handler));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_input_InputManager$unregisterInputDeviceListener(InputDeviceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            int index = this.findInputDeviceListenerLocked(listener);
            if (index >= 0) {
                InputDeviceListenerDelegate d = this.mInputDeviceListeners.get(index);
                d.removeCallbacksAndMessages(null);
                this.mInputDeviceListeners.remove(index);
            }
        }
    }

    private final int $$robo$$android_hardware_input_InputManager$findInputDeviceListenerLocked(InputDeviceListener listener) {
        int numListeners = this.mInputDeviceListeners.size();
        for (int i = 0; i < numListeners; ++i) {
            if (this.mInputDeviceListeners.get((int)i).mListener != listener) continue;
            return i;
        }
        return -1;
    }

    private final KeyboardLayout[] $$robo$$android_hardware_input_InputManager$getKeyboardLayouts() {
        try {
            return this.mIm.getKeyboardLayouts();
        }
        catch (RemoteException ex) {
            Log.w("InputManager", "Could not get list of keyboard layout informations.", ex);
            return new KeyboardLayout[0];
        }
    }

    private final KeyboardLayout $$robo$$android_hardware_input_InputManager$getKeyboardLayout(String keyboardLayoutDescriptor) {
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            return this.mIm.getKeyboardLayout(keyboardLayoutDescriptor);
        }
        catch (RemoteException ex) {
            Log.w("InputManager", "Could not get keyboard layout information.", ex);
            return null;
        }
    }

    private final String $$robo$$android_hardware_input_InputManager$getCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier) {
        try {
            return this.mIm.getCurrentKeyboardLayoutForInputDevice(identifier);
        }
        catch (RemoteException ex) {
            Log.w("InputManager", "Could not get current keyboard layout for input device.", ex);
            return null;
        }
    }

    private final void $$robo$$android_hardware_input_InputManager$setCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) {
        if (identifier == null) {
            throw new IllegalArgumentException("identifier must not be null");
        }
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            this.mIm.setCurrentKeyboardLayoutForInputDevice(identifier, keyboardLayoutDescriptor);
        }
        catch (RemoteException ex) {
            Log.w("InputManager", "Could not set current keyboard layout for input device.", ex);
        }
    }

    private final String[] $$robo$$android_hardware_input_InputManager$getKeyboardLayoutsForInputDevice(InputDeviceIdentifier identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        try {
            return this.mIm.getKeyboardLayoutsForInputDevice(identifier);
        }
        catch (RemoteException ex) {
            Log.w("InputManager", "Could not get keyboard layouts for input device.", ex);
            return ArrayUtils.emptyArray(String.class);
        }
    }

    private final void $$robo$$android_hardware_input_InputManager$addKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) {
        if (identifier == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            this.mIm.addKeyboardLayoutForInputDevice(identifier, keyboardLayoutDescriptor);
        }
        catch (RemoteException ex) {
            Log.w("InputManager", "Could not add keyboard layout for input device.", ex);
        }
    }

    private final void $$robo$$android_hardware_input_InputManager$removeKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) {
        if (identifier == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            this.mIm.removeKeyboardLayoutForInputDevice(identifier, keyboardLayoutDescriptor);
        }
        catch (RemoteException ex) {
            Log.w("InputManager", "Could not remove keyboard layout for input device.", ex);
        }
    }

    private final TouchCalibration $$robo$$android_hardware_input_InputManager$getTouchCalibration(String inputDeviceDescriptor, int surfaceRotation) {
        try {
            return this.mIm.getTouchCalibrationForInputDevice(inputDeviceDescriptor, surfaceRotation);
        }
        catch (RemoteException ex) {
            Log.w("InputManager", "Could not get calibration matrix for input device.", ex);
            return TouchCalibration.IDENTITY;
        }
    }

    private final void $$robo$$android_hardware_input_InputManager$setTouchCalibration(String inputDeviceDescriptor, int surfaceRotation, TouchCalibration calibration) {
        try {
            this.mIm.setTouchCalibrationForInputDevice(inputDeviceDescriptor, surfaceRotation, calibration);
        }
        catch (RemoteException ex) {
            Log.w("InputManager", "Could not set calibration matrix for input device.", ex);
        }
    }

    private final int $$robo$$android_hardware_input_InputManager$getPointerSpeed(Context context) {
        int speed = 0;
        try {
            speed = Settings.System.getInt(context.getContentResolver(), "pointer_speed");
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            // empty catch block
        }
        return speed;
    }

    private final void $$robo$$android_hardware_input_InputManager$setPointerSpeed(Context context, int speed) {
        if (speed < -7 || speed > 7) {
            throw new IllegalArgumentException("speed out of range");
        }
        Settings.System.putInt(context.getContentResolver(), "pointer_speed", speed);
    }

    private final void $$robo$$android_hardware_input_InputManager$tryPointerSpeed(int speed) {
        if (speed < -7 || speed > 7) {
            throw new IllegalArgumentException("speed out of range");
        }
        try {
            this.mIm.tryPointerSpeed(speed);
        }
        catch (RemoteException ex) {
            Log.w("InputManager", "Could not set temporary pointer speed.", ex);
        }
    }

    private final boolean[] $$robo$$android_hardware_input_InputManager$deviceHasKeys(int[] keyCodes) {
        return this.deviceHasKeys(-1, keyCodes);
    }

    private final boolean[] $$robo$$android_hardware_input_InputManager$deviceHasKeys(int id2, int[] keyCodes) {
        boolean[] ret = new boolean[keyCodes.length];
        try {
            this.mIm.hasKeys(id2, -256, keyCodes, ret);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return ret;
    }

    private final boolean $$robo$$android_hardware_input_InputManager$injectInputEvent(InputEvent event, int mode) {
        if (event == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        if (mode != 0 && mode != 2 && mode != 1) {
            throw new IllegalArgumentException("mode is invalid");
        }
        try {
            return this.mIm.injectInputEvent(event, mode);
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    private final void $$robo$$android_hardware_input_InputManager$populateInputDevicesLocked() {
        if (this.mInputDevicesChangedListener == null) {
            InputDevicesChangedListener listener = new InputDevicesChangedListener(this);
            try {
                this.mIm.registerInputDevicesChangedListener(listener);
            }
            catch (RemoteException ex) {
                throw new RuntimeException("Could not get register input device changed listener", ex);
            }
            this.mInputDevicesChangedListener = listener;
        }
        if (this.mInputDevices == null) {
            int[] ids;
            try {
                ids = this.mIm.getInputDeviceIds();
            }
            catch (RemoteException ex) {
                throw new RuntimeException("Could not get input device ids.", ex);
            }
            this.mInputDevices = new SparseArray();
            for (int i = 0; i < ids.length; ++i) {
                this.mInputDevices.put(ids[i], null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_input_InputManager$onInputDevicesChanged(int[] deviceIdAndGeneration) {
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            int deviceId;
            int i = this.mInputDevices.size();
            while (--i > 0) {
                deviceId = this.mInputDevices.keyAt(i);
                if (InputManager.containsDeviceId(deviceIdAndGeneration, deviceId)) continue;
                this.mInputDevices.removeAt(i);
                this.sendMessageToInputDeviceListenersLocked(2, deviceId);
            }
            for (i = 0; i < deviceIdAndGeneration.length; i += 2) {
                deviceId = deviceIdAndGeneration[i];
                int index = this.mInputDevices.indexOfKey(deviceId);
                if (index >= 0) {
                    InputDevice device = this.mInputDevices.valueAt(index);
                    if (device == null) continue;
                    int generation = deviceIdAndGeneration[i + 1];
                    if (device.getGeneration() == generation) continue;
                    this.mInputDevices.setValueAt(index, null);
                    this.sendMessageToInputDeviceListenersLocked(3, deviceId);
                    continue;
                }
                this.mInputDevices.put(deviceId, null);
                this.sendMessageToInputDeviceListenersLocked(1, deviceId);
            }
        }
    }

    private final void $$robo$$android_hardware_input_InputManager$sendMessageToInputDeviceListenersLocked(int what, int deviceId) {
        int numListeners = this.mInputDeviceListeners.size();
        for (int i = 0; i < numListeners; ++i) {
            InputDeviceListenerDelegate listener = this.mInputDeviceListeners.get(i);
            listener.sendMessage(listener.obtainMessage(what, deviceId, 0));
        }
    }

    private static final boolean $$robo$$android_hardware_input_InputManager$containsDeviceId(int[] deviceIdAndGeneration, int deviceId) {
        for (int i = 0; i < deviceIdAndGeneration.length; i += 2) {
            if (deviceIdAndGeneration[i] != deviceId) continue;
            return true;
        }
        return false;
    }

    private final Vibrator $$robo$$android_hardware_input_InputManager$getInputDeviceVibrator(int deviceId) {
        return new InputDeviceVibrator(this, deviceId);
    }

    private void __constructor__(IInputManager iInputManager) {
        this.$$robo$$android_hardware_input_InputManager$__constructor__(iInputManager);
    }

    private InputManager(IInputManager iInputManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_input_InputManager$__constructor__(android.hardware.input.IInputManager ), 0, this, iInputManager);
    }

    public static InputManager getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_hardware_input_InputManager$getInstance(), 0);
    }

    public InputDevice getInputDevice(int n) {
        return InvokeDynamicSupport.bootstrap("getInputDevice", $$robo$$android_hardware_input_InputManager$getInputDevice(int ), 0, this, n);
    }

    public InputDevice getInputDeviceByDescriptor(String string2) {
        return InvokeDynamicSupport.bootstrap("getInputDeviceByDescriptor", $$robo$$android_hardware_input_InputManager$getInputDeviceByDescriptor(java.lang.String ), 0, this, string2);
    }

    public int[] getInputDeviceIds() {
        return InvokeDynamicSupport.bootstrap("getInputDeviceIds", $$robo$$android_hardware_input_InputManager$getInputDeviceIds(), 0, this);
    }

    public void registerInputDeviceListener(InputDeviceListener inputDeviceListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerInputDeviceListener", $$robo$$android_hardware_input_InputManager$registerInputDeviceListener(android.hardware.input.InputManager$InputDeviceListener android.os.Handler ), 0, this, inputDeviceListener, handler);
    }

    public void unregisterInputDeviceListener(InputDeviceListener inputDeviceListener) {
        InvokeDynamicSupport.bootstrap("unregisterInputDeviceListener", $$robo$$android_hardware_input_InputManager$unregisterInputDeviceListener(android.hardware.input.InputManager$InputDeviceListener ), 0, this, inputDeviceListener);
    }

    private int findInputDeviceListenerLocked(InputDeviceListener inputDeviceListener) {
        return (int)InvokeDynamicSupport.bootstrap("findInputDeviceListenerLocked", $$robo$$android_hardware_input_InputManager$findInputDeviceListenerLocked(android.hardware.input.InputManager$InputDeviceListener ), 0, this, inputDeviceListener);
    }

    public KeyboardLayout[] getKeyboardLayouts() {
        return InvokeDynamicSupport.bootstrap("getKeyboardLayouts", $$robo$$android_hardware_input_InputManager$getKeyboardLayouts(), 0, this);
    }

    public KeyboardLayout getKeyboardLayout(String string2) {
        return InvokeDynamicSupport.bootstrap("getKeyboardLayout", $$robo$$android_hardware_input_InputManager$getKeyboardLayout(java.lang.String ), 0, this, string2);
    }

    public String getCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier inputDeviceIdentifier) {
        return InvokeDynamicSupport.bootstrap("getCurrentKeyboardLayoutForInputDevice", $$robo$$android_hardware_input_InputManager$getCurrentKeyboardLayoutForInputDevice(android.hardware.input.InputDeviceIdentifier ), 0, this, inputDeviceIdentifier);
    }

    public void setCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier inputDeviceIdentifier, String string2) {
        InvokeDynamicSupport.bootstrap("setCurrentKeyboardLayoutForInputDevice", $$robo$$android_hardware_input_InputManager$setCurrentKeyboardLayoutForInputDevice(android.hardware.input.InputDeviceIdentifier java.lang.String ), 0, this, inputDeviceIdentifier, string2);
    }

    public String[] getKeyboardLayoutsForInputDevice(InputDeviceIdentifier inputDeviceIdentifier) {
        return InvokeDynamicSupport.bootstrap("getKeyboardLayoutsForInputDevice", $$robo$$android_hardware_input_InputManager$getKeyboardLayoutsForInputDevice(android.hardware.input.InputDeviceIdentifier ), 0, this, inputDeviceIdentifier);
    }

    public void addKeyboardLayoutForInputDevice(InputDeviceIdentifier inputDeviceIdentifier, String string2) {
        InvokeDynamicSupport.bootstrap("addKeyboardLayoutForInputDevice", $$robo$$android_hardware_input_InputManager$addKeyboardLayoutForInputDevice(android.hardware.input.InputDeviceIdentifier java.lang.String ), 0, this, inputDeviceIdentifier, string2);
    }

    public void removeKeyboardLayoutForInputDevice(InputDeviceIdentifier inputDeviceIdentifier, String string2) {
        InvokeDynamicSupport.bootstrap("removeKeyboardLayoutForInputDevice", $$robo$$android_hardware_input_InputManager$removeKeyboardLayoutForInputDevice(android.hardware.input.InputDeviceIdentifier java.lang.String ), 0, this, inputDeviceIdentifier, string2);
    }

    public TouchCalibration getTouchCalibration(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("getTouchCalibration", $$robo$$android_hardware_input_InputManager$getTouchCalibration(java.lang.String int ), 0, this, string2, n);
    }

    public void setTouchCalibration(String string2, int n, TouchCalibration touchCalibration) {
        InvokeDynamicSupport.bootstrap("setTouchCalibration", $$robo$$android_hardware_input_InputManager$setTouchCalibration(java.lang.String int android.hardware.input.TouchCalibration ), 0, this, string2, n, touchCalibration);
    }

    public int getPointerSpeed(Context context) {
        return (int)InvokeDynamicSupport.bootstrap("getPointerSpeed", $$robo$$android_hardware_input_InputManager$getPointerSpeed(android.content.Context ), 0, this, context);
    }

    public void setPointerSpeed(Context context, int n) {
        InvokeDynamicSupport.bootstrap("setPointerSpeed", $$robo$$android_hardware_input_InputManager$setPointerSpeed(android.content.Context int ), 0, this, context, n);
    }

    public void tryPointerSpeed(int n) {
        InvokeDynamicSupport.bootstrap("tryPointerSpeed", $$robo$$android_hardware_input_InputManager$tryPointerSpeed(int ), 0, this, n);
    }

    public boolean[] deviceHasKeys(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("deviceHasKeys", $$robo$$android_hardware_input_InputManager$deviceHasKeys(int[] ), 0, this, nArray);
    }

    public boolean[] deviceHasKeys(int n, int[] nArray) {
        return InvokeDynamicSupport.bootstrap("deviceHasKeys", $$robo$$android_hardware_input_InputManager$deviceHasKeys(int int[] ), 0, this, n, nArray);
    }

    public boolean injectInputEvent(InputEvent inputEvent, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("injectInputEvent", $$robo$$android_hardware_input_InputManager$injectInputEvent(android.view.InputEvent int ), 0, this, inputEvent, n);
    }

    private void populateInputDevicesLocked() {
        InvokeDynamicSupport.bootstrap("populateInputDevicesLocked", $$robo$$android_hardware_input_InputManager$populateInputDevicesLocked(), 0, this);
    }

    private void onInputDevicesChanged(int[] nArray) {
        InvokeDynamicSupport.bootstrap("onInputDevicesChanged", $$robo$$android_hardware_input_InputManager$onInputDevicesChanged(int[] ), 0, this, nArray);
    }

    private void sendMessageToInputDeviceListenersLocked(int n, int n2) {
        InvokeDynamicSupport.bootstrap("sendMessageToInputDeviceListenersLocked", $$robo$$android_hardware_input_InputManager$sendMessageToInputDeviceListenersLocked(int int ), 0, this, n, n2);
    }

    private static boolean containsDeviceId(int[] nArray, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("containsDeviceId", $$robo$$android_hardware_input_InputManager$containsDeviceId(int[] int ), 0, (int[])nArray, (int)n);
    }

    public Vibrator getInputDeviceVibrator(int n) {
        return InvokeDynamicSupport.bootstrap("getInputDeviceVibrator", $$robo$$android_hardware_input_InputManager$getInputDeviceVibrator(int ), 0, this, n);
    }

    public /* synthetic */ InputManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class InputDeviceVibrator
    extends Vibrator
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mDeviceId;
        private Binder mToken;
        /* synthetic */ InputManager this$0;

        private void $$robo$$android_hardware_input_InputManager_InputDeviceVibrator$__constructor__(InputManager inputManager, int deviceId) {
            this.mDeviceId = deviceId;
            this.mToken = new Binder();
        }

        private final boolean $$robo$$android_hardware_input_InputManager_InputDeviceVibrator$hasVibrator() {
            return true;
        }

        private final void $$robo$$android_hardware_input_InputManager_InputDeviceVibrator$vibrate(int uid, String opPkg, long milliseconds, AudioAttributes attributes) {
            this.vibrate(new long[]{0L, milliseconds}, -1);
        }

        private final void $$robo$$android_hardware_input_InputManager_InputDeviceVibrator$vibrate(int uid, String opPkg, long[] pattern, int repeat, AudioAttributes attributes) {
            if (repeat >= pattern.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            try {
                this.this$0.mIm.vibrate(this.mDeviceId, pattern, repeat, this.mToken);
            }
            catch (RemoteException ex) {
                Log.w("InputManager", "Failed to vibrate.", ex);
            }
        }

        private final void $$robo$$android_hardware_input_InputManager_InputDeviceVibrator$cancel() {
            try {
                this.this$0.mIm.cancelVibrate(this.mDeviceId, this.mToken);
            }
            catch (RemoteException ex) {
                Log.w("InputManager", "Failed to cancel vibration.", ex);
            }
        }

        private void __constructor__(InputManager inputManager, int n) {
            this.$$robo$$android_hardware_input_InputManager_InputDeviceVibrator$__constructor__(inputManager, n);
        }

        public InputDeviceVibrator(InputManager inputManager, int n) {
            this.this$0 = inputManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_input_InputManager_InputDeviceVibrator$__constructor__(android.hardware.input.InputManager int ), 0, this, inputManager, n);
        }

        @Override
        public boolean hasVibrator() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasVibrator", $$robo$$android_hardware_input_InputManager_InputDeviceVibrator$hasVibrator(), 0, this);
        }

        @Override
        public void vibrate(int n, String string2, long l, AudioAttributes audioAttributes) {
            InvokeDynamicSupport.bootstrap("vibrate", $$robo$$android_hardware_input_InputManager_InputDeviceVibrator$vibrate(int java.lang.String long android.media.AudioAttributes ), 0, this, n, string2, l, audioAttributes);
        }

        @Override
        public void vibrate(int n, String string2, long[] lArray, int n2, AudioAttributes audioAttributes) {
            InvokeDynamicSupport.bootstrap("vibrate", $$robo$$android_hardware_input_InputManager_InputDeviceVibrator$vibrate(int java.lang.String long[] int android.media.AudioAttributes ), 0, this, n, string2, lArray, n2, audioAttributes);
        }

        @Override
        public void cancel() {
            InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_hardware_input_InputManager_InputDeviceVibrator$cancel(), 0, this);
        }

        public /* synthetic */ InputDeviceVibrator() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputDeviceVibrator)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class InputDeviceListenerDelegate
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public InputDeviceListener mListener;

        private void $$robo$$android_hardware_input_InputManager_InputDeviceListenerDelegate$__constructor__(InputDeviceListener listener, Handler handler) {
            this.mListener = listener;
        }

        private final void $$robo$$android_hardware_input_InputManager_InputDeviceListenerDelegate$handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.mListener.onInputDeviceAdded(msg.arg1);
                    break;
                }
                case 2: {
                    this.mListener.onInputDeviceRemoved(msg.arg1);
                    break;
                }
                case 3: {
                    this.mListener.onInputDeviceChanged(msg.arg1);
                }
            }
        }

        private void __constructor__(InputDeviceListener inputDeviceListener, Handler handler) {
            this.$$robo$$android_hardware_input_InputManager_InputDeviceListenerDelegate$__constructor__(inputDeviceListener, handler);
        }

        public InputDeviceListenerDelegate(InputDeviceListener inputDeviceListener, Handler handler) {
            super(handler != null ? handler.getLooper() : Looper.myLooper());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_input_InputManager_InputDeviceListenerDelegate$__constructor__(android.hardware.input.InputManager$InputDeviceListener android.os.Handler ), 0, this, inputDeviceListener, handler);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_hardware_input_InputManager_InputDeviceListenerDelegate$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ InputDeviceListenerDelegate() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputDeviceListenerDelegate)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class InputDevicesChangedListener
    extends IInputDevicesChangedListener.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ InputManager this$0;

        private void $$robo$$android_hardware_input_InputManager_InputDevicesChangedListener$__constructor__(InputManager inputManager) {
        }

        private final void $$robo$$android_hardware_input_InputManager_InputDevicesChangedListener$onInputDevicesChanged(int[] deviceIdAndGeneration) throws RemoteException {
            this.this$0.onInputDevicesChanged(deviceIdAndGeneration);
        }

        private /* synthetic */ void $$robo$$android_hardware_input_InputManager_InputDevicesChangedListener$__constructor__(InputManager x0, 1 x1) {
        }

        private void __constructor__(InputManager inputManager) {
            this.$$robo$$android_hardware_input_InputManager_InputDevicesChangedListener$__constructor__(inputManager);
        }

        private InputDevicesChangedListener(InputManager inputManager) {
            this.this$0 = inputManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_input_InputManager_InputDevicesChangedListener$__constructor__(android.hardware.input.InputManager ), 0, this, inputManager);
        }

        @Override
        public void onInputDevicesChanged(int[] nArray) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onInputDevicesChanged", $$robo$$android_hardware_input_InputManager_InputDevicesChangedListener$onInputDevicesChanged(int[] ), 0, this, nArray);
        }

        private /* synthetic */ void __constructor__(InputManager inputManager, 1 var2_2) {
            this.$$robo$$android_hardware_input_InputManager_InputDevicesChangedListener$__constructor__(inputManager, var2_2);
        }

        public /* synthetic */ InputDevicesChangedListener() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputDevicesChangedListener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface InputDeviceListener
    extends InstrumentedInterface {
        public void onInputDeviceAdded(int var1);

        public void onInputDeviceRemoved(int var1);

        public void onInputDeviceChanged(int var1);
    }
}

