/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.content.Context;
import android.hardware.location.ActivityChangedEvent;
import android.hardware.location.ActivityRecognitionEvent;
import android.hardware.location.IActivityRecognitionHardware;
import android.hardware.location.IActivityRecognitionHardwareSink;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ActivityRecognitionHardware
extends IActivityRecognitionHardware.Stub
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ActivityRecognitionHardware";
    private static String HARDWARE_PERMISSION = "android.permission.LOCATION_HARDWARE";
    private static int INVALID_ACTIVITY_TYPE = -1;
    private static int NATIVE_SUCCESS_RESULT = 0;
    private static ActivityRecognitionHardware sSingletonInstance;
    private static Object sSingletonInstanceLock;
    private Context mContext;
    private String[] mSupportedActivities;
    private RemoteCallbackList<IActivityRecognitionHardwareSink> mSinks;

    private void $$robo$$android_hardware_location_ActivityRecognitionHardware$__constructor__(Context context) {
        this.mSinks = new RemoteCallbackList();
        this.nativeInitialize();
        this.mContext = context;
        this.mSupportedActivities = this.fetchSupportedActivities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ActivityRecognitionHardware $$robo$$android_hardware_location_ActivityRecognitionHardware$getInstance(Context context) {
        Object object = sSingletonInstanceLock;
        synchronized (object) {
            if (sSingletonInstance == null) {
                sSingletonInstance = new ActivityRecognitionHardware(context);
            }
            return sSingletonInstance;
        }
    }

    private static final boolean $$robo$$android_hardware_location_ActivityRecognitionHardware$isSupported() {
        return ActivityRecognitionHardware.nativeIsSupported();
    }

    private final String[] $$robo$$android_hardware_location_ActivityRecognitionHardware$getSupportedActivities() {
        this.checkPermissions();
        return this.mSupportedActivities;
    }

    private final boolean $$robo$$android_hardware_location_ActivityRecognitionHardware$isActivitySupported(String activity) {
        this.checkPermissions();
        int activityType = this.getActivityType(activity);
        return activityType != -1;
    }

    private final boolean $$robo$$android_hardware_location_ActivityRecognitionHardware$registerSink(IActivityRecognitionHardwareSink sink) {
        this.checkPermissions();
        return this.mSinks.register(sink);
    }

    private final boolean $$robo$$android_hardware_location_ActivityRecognitionHardware$unregisterSink(IActivityRecognitionHardwareSink sink) {
        this.checkPermissions();
        return this.mSinks.unregister(sink);
    }

    private final boolean $$robo$$android_hardware_location_ActivityRecognitionHardware$enableActivityEvent(String activity, int eventType, long reportLatencyNs) {
        this.checkPermissions();
        int activityType = this.getActivityType(activity);
        if (activityType == -1) {
            return false;
        }
        int result = this.nativeEnableActivityEvent(activityType, eventType, reportLatencyNs);
        return result == 0;
    }

    private final boolean $$robo$$android_hardware_location_ActivityRecognitionHardware$disableActivityEvent(String activity, int eventType) {
        this.checkPermissions();
        int activityType = this.getActivityType(activity);
        if (activityType == -1) {
            return false;
        }
        int result = this.nativeDisableActivityEvent(activityType, eventType);
        return result == 0;
    }

    private final boolean $$robo$$android_hardware_location_ActivityRecognitionHardware$flush() {
        this.checkPermissions();
        int result = this.nativeFlush();
        return result == 0;
    }

    private final void $$robo$$android_hardware_location_ActivityRecognitionHardware$onActivityChanged(Event[] events) {
        if (events == null || events.length == 0) {
            Log.d("ActivityRecognitionHardware", "No events to broadcast for onActivityChanged.");
            return;
        }
        int eventsLength = events.length;
        ActivityRecognitionEvent[] activityRecognitionEventArray = new ActivityRecognitionEvent[eventsLength];
        for (int i = 0; i < eventsLength; ++i) {
            Event event = events[i];
            String activityName = this.getActivityName(event.activity);
            activityRecognitionEventArray[i] = new ActivityRecognitionEvent(activityName, event.type, event.timestamp);
        }
        ActivityChangedEvent activityChangedEvent = new ActivityChangedEvent(activityRecognitionEventArray);
        int size = this.mSinks.beginBroadcast();
        for (int i = 0; i < size; ++i) {
            IActivityRecognitionHardwareSink sink = this.mSinks.getBroadcastItem(i);
            try {
                sink.onActivityChanged(activityChangedEvent);
                continue;
            }
            catch (RemoteException e) {
                Log.e("ActivityRecognitionHardware", "Error delivering activity changed event.", e);
            }
        }
        this.mSinks.finishBroadcast();
    }

    private final String $$robo$$android_hardware_location_ActivityRecognitionHardware$getActivityName(int activityType) {
        if (activityType < 0 || activityType >= this.mSupportedActivities.length) {
            String message = String.format("Invalid ActivityType: %d, SupportedActivities: %d", activityType, this.mSupportedActivities.length);
            Log.e("ActivityRecognitionHardware", message);
            return null;
        }
        return this.mSupportedActivities[activityType];
    }

    private final int $$robo$$android_hardware_location_ActivityRecognitionHardware$getActivityType(String activity) {
        if (TextUtils.isEmpty(activity)) {
            return -1;
        }
        int supportedActivitiesLength = this.mSupportedActivities.length;
        for (int i = 0; i < supportedActivitiesLength; ++i) {
            if (!activity.equals(this.mSupportedActivities[i])) continue;
            return i;
        }
        return -1;
    }

    private final void $$robo$$android_hardware_location_ActivityRecognitionHardware$checkPermissions() {
        String message = String.format("Permission '%s' not granted to access ActivityRecognitionHardware", "android.permission.LOCATION_HARDWARE");
        this.mContext.enforceCallingPermission("android.permission.LOCATION_HARDWARE", message);
    }

    private final String[] $$robo$$android_hardware_location_ActivityRecognitionHardware$fetchSupportedActivities() {
        String[] supportedActivities = this.nativeGetSupportedActivities();
        if (supportedActivities != null) {
            return supportedActivities;
        }
        return new String[0];
    }

    private static final void $$robo$$android_hardware_location_ActivityRecognitionHardware$nativeClassInit() {
    }

    private static final boolean $$robo$$android_hardware_location_ActivityRecognitionHardware$nativeIsSupported() {
        return false;
    }

    private final void $$robo$$android_hardware_location_ActivityRecognitionHardware$nativeInitialize() {
    }

    private final void $$robo$$android_hardware_location_ActivityRecognitionHardware$nativeRelease() {
    }

    private final String[] $$robo$$android_hardware_location_ActivityRecognitionHardware$nativeGetSupportedActivities() {
        return null;
    }

    private final int $$robo$$android_hardware_location_ActivityRecognitionHardware$nativeEnableActivityEvent(int n, int n2, long l) {
        return 0;
    }

    private final int $$robo$$android_hardware_location_ActivityRecognitionHardware$nativeDisableActivityEvent(int n, int n2) {
        return 0;
    }

    private final int $$robo$$android_hardware_location_ActivityRecognitionHardware$nativeFlush() {
        return 0;
    }

    static void __staticInitializer__() {
        sSingletonInstance = null;
        sSingletonInstanceLock = new Object();
        ActivityRecognitionHardware.nativeClassInit();
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_hardware_location_ActivityRecognitionHardware$__constructor__(context);
    }

    private ActivityRecognitionHardware(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_ActivityRecognitionHardware$__constructor__(android.content.Context ), 0, this, context);
    }

    public static ActivityRecognitionHardware getInstance(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_hardware_location_ActivityRecognitionHardware$getInstance(android.content.Context ), 0, (Context)context);
    }

    public static boolean isSupported() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSupported", $$robo$$android_hardware_location_ActivityRecognitionHardware$isSupported(), 0);
    }

    @Override
    public String[] getSupportedActivities() {
        return InvokeDynamicSupport.bootstrap("getSupportedActivities", $$robo$$android_hardware_location_ActivityRecognitionHardware$getSupportedActivities(), 0, this);
    }

    @Override
    public boolean isActivitySupported(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isActivitySupported", $$robo$$android_hardware_location_ActivityRecognitionHardware$isActivitySupported(java.lang.String ), 0, this, string2);
    }

    @Override
    public boolean registerSink(IActivityRecognitionHardwareSink iActivityRecognitionHardwareSink) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerSink", $$robo$$android_hardware_location_ActivityRecognitionHardware$registerSink(android.hardware.location.IActivityRecognitionHardwareSink ), 0, this, iActivityRecognitionHardwareSink);
    }

    @Override
    public boolean unregisterSink(IActivityRecognitionHardwareSink iActivityRecognitionHardwareSink) {
        return (boolean)InvokeDynamicSupport.bootstrap("unregisterSink", $$robo$$android_hardware_location_ActivityRecognitionHardware$unregisterSink(android.hardware.location.IActivityRecognitionHardwareSink ), 0, this, iActivityRecognitionHardwareSink);
    }

    @Override
    public boolean enableActivityEvent(String string2, int n, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("enableActivityEvent", $$robo$$android_hardware_location_ActivityRecognitionHardware$enableActivityEvent(java.lang.String int long ), 0, this, string2, n, l);
    }

    @Override
    public boolean disableActivityEvent(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("disableActivityEvent", $$robo$$android_hardware_location_ActivityRecognitionHardware$disableActivityEvent(java.lang.String int ), 0, this, string2, n);
    }

    @Override
    public boolean flush() {
        return (boolean)InvokeDynamicSupport.bootstrap("flush", $$robo$$android_hardware_location_ActivityRecognitionHardware$flush(), 0, this);
    }

    private void onActivityChanged(Event[] eventArray) {
        InvokeDynamicSupport.bootstrap("onActivityChanged", $$robo$$android_hardware_location_ActivityRecognitionHardware$onActivityChanged(android.hardware.location.ActivityRecognitionHardware$Event[] ), 0, this, eventArray);
    }

    private String getActivityName(int n) {
        return InvokeDynamicSupport.bootstrap("getActivityName", $$robo$$android_hardware_location_ActivityRecognitionHardware$getActivityName(int ), 0, this, n);
    }

    private int getActivityType(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getActivityType", $$robo$$android_hardware_location_ActivityRecognitionHardware$getActivityType(java.lang.String ), 0, this, string2);
    }

    private void checkPermissions() {
        InvokeDynamicSupport.bootstrap("checkPermissions", $$robo$$android_hardware_location_ActivityRecognitionHardware$checkPermissions(), 0, this);
    }

    private String[] fetchSupportedActivities() {
        return InvokeDynamicSupport.bootstrap("fetchSupportedActivities", $$robo$$android_hardware_location_ActivityRecognitionHardware$fetchSupportedActivities(), 0, this);
    }

    private static final native /* synthetic */ void $$robo$$nativeClassInit$nativeBinding();

    private static void nativeClassInit() {
        InvokeDynamicSupport.bootstrapStatic("nativeClassInit", $$robo$$android_hardware_location_ActivityRecognitionHardware$nativeClassInit(), 1);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeIsSupported$nativeBinding();

    private static boolean nativeIsSupported() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeIsSupported", $$robo$$android_hardware_location_ActivityRecognitionHardware$nativeIsSupported(), 1);
    }

    private final native /* synthetic */ void $$robo$$nativeInitialize$nativeBinding();

    private void nativeInitialize() {
        InvokeDynamicSupport.bootstrap("nativeInitialize", $$robo$$android_hardware_location_ActivityRecognitionHardware$nativeInitialize(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$nativeRelease$nativeBinding();

    private void nativeRelease() {
        InvokeDynamicSupport.bootstrap("nativeRelease", $$robo$$android_hardware_location_ActivityRecognitionHardware$nativeRelease(), 1, this);
    }

    private final native /* synthetic */ String[] $$robo$$nativeGetSupportedActivities$nativeBinding();

    private String[] nativeGetSupportedActivities() {
        return InvokeDynamicSupport.bootstrap("nativeGetSupportedActivities", $$robo$$android_hardware_location_ActivityRecognitionHardware$nativeGetSupportedActivities(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$nativeEnableActivityEvent$nativeBinding(int var1, int var2, long var3);

    private int nativeEnableActivityEvent(int n, int n2, long l) {
        return (int)InvokeDynamicSupport.bootstrap("nativeEnableActivityEvent", $$robo$$android_hardware_location_ActivityRecognitionHardware$nativeEnableActivityEvent(int int long ), 1, this, n, n2, l);
    }

    private final native /* synthetic */ int $$robo$$nativeDisableActivityEvent$nativeBinding(int var1, int var2);

    private int nativeDisableActivityEvent(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("nativeDisableActivityEvent", $$robo$$android_hardware_location_ActivityRecognitionHardware$nativeDisableActivityEvent(int int ), 1, this, n, n2);
    }

    private final native /* synthetic */ int $$robo$$nativeFlush$nativeBinding();

    private int nativeFlush() {
        return (int)InvokeDynamicSupport.bootstrap("nativeFlush", $$robo$$android_hardware_location_ActivityRecognitionHardware$nativeFlush(), 1, this);
    }

    static {
        RobolectricInternals.classInitializing(ActivityRecognitionHardware.class);
    }

    public /* synthetic */ ActivityRecognitionHardware() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityRecognitionHardware)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class Event
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int activity;
        public int type;
        public long timestamp;

        private void $$robo$$android_hardware_location_ActivityRecognitionHardware_Event$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_hardware_location_ActivityRecognitionHardware_Event$__constructor__();
        }

        private Event() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_ActivityRecognitionHardware_Event$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Event)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

