/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.soundtrigger;

import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.hardware.soundtrigger.KeyphraseMetadata;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.AttributeSet;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.R;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class KeyphraseEnrollmentInfo
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "KeyphraseEnrollmentInfo";
    private static String VOICE_KEYPHRASE_META_DATA = "android.voice_enrollment";
    public static String ACTION_MANAGE_VOICE_KEYPHRASES = "com.android.intent.action.MANAGE_VOICE_KEYPHRASES";
    public static String EXTRA_VOICE_KEYPHRASE_ACTION = "com.android.intent.extra.VOICE_KEYPHRASE_ACTION";
    public static String EXTRA_VOICE_KEYPHRASE_HINT_TEXT = "com.android.intent.extra.VOICE_KEYPHRASE_HINT_TEXT";
    public static String EXTRA_VOICE_KEYPHRASE_LOCALE = "com.android.intent.extra.VOICE_KEYPHRASE_LOCALE";
    private KeyphraseMetadata[] mKeyphrases;
    private String mEnrollmentPackage;
    private String mParseError;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$__constructor__(PackageManager pm) {
        List<ResolveInfo> ris = pm.queryIntentActivities(new Intent("com.android.intent.action.MANAGE_VOICE_KEYPHRASES"), 65536);
        if (ris == null || ris.isEmpty()) {
            this.mParseError = "No enrollment application found";
            return;
        }
        boolean found = false;
        PackageItemInfo ai = null;
        for (ResolveInfo ri : ris) {
            try {
                ai = pm.getApplicationInfo(ri.activityInfo.packageName, 128);
                if ((((ApplicationInfo)ai).flags & 0x40000000) == 0) {
                    Slog.w("KeyphraseEnrollmentInfo", ((ApplicationInfo)ai).packageName + "is not a privileged system app");
                    continue;
                }
                if (!"android.permission.MANAGE_VOICE_KEYPHRASES".equals(((ApplicationInfo)ai).permission)) {
                    Slog.w("KeyphraseEnrollmentInfo", ((ApplicationInfo)ai).packageName + " does not require MANAGE_VOICE_KEYPHRASES");
                    continue;
                }
                this.mEnrollmentPackage = ((ApplicationInfo)ai).packageName;
                found = true;
                break;
            }
            catch (PackageManager.NameNotFoundException e) {
                Slog.w("KeyphraseEnrollmentInfo", "error parsing voice enrollment meta-data", e);
            }
        }
        if (!found) {
            this.mKeyphrases = null;
            this.mParseError = "No suitable enrollment application found";
            return;
        }
        try (XmlResourceParser parser = null;){
            int type;
            parser = ai.loadXmlMetaData(pm, "android.voice_enrollment");
            if (parser == null) {
                this.mParseError = "No android.voice_enrollment meta-data for " + ((ApplicationInfo)ai).packageName;
                return;
            }
            Resources res = pm.getResourcesForApplication((ApplicationInfo)ai);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!"voice-enrollment-application".equals(nodeName)) {
                this.mParseError = "Meta-data does not start with voice-enrollment-application tag";
                return;
            }
            TypedArray array2 = res.obtainAttributes(attrs, R.styleable.VoiceEnrollmentApplication);
            this.initializeKeyphrasesFromTypedArray(array2);
            array2.recycle();
        }
    }

    private final void $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$initializeKeyphrasesFromTypedArray(TypedArray array2) {
        int recognitionModes;
        int searchKeyphraseId = array2.getInt(0, -1);
        if (searchKeyphraseId <= 0) {
            this.mParseError = "No valid searchKeyphraseId specified in meta-data";
            Slog.w("KeyphraseEnrollmentInfo", this.mParseError);
            return;
        }
        String searchKeyphrase = array2.getString(1);
        if (searchKeyphrase == null) {
            this.mParseError = "No valid searchKeyphrase specified in meta-data";
            Slog.w("KeyphraseEnrollmentInfo", this.mParseError);
            return;
        }
        String searchKeyphraseSupportedLocales = array2.getString(2);
        if (searchKeyphraseSupportedLocales == null) {
            this.mParseError = "No valid searchKeyphraseSupportedLocales specified in meta-data";
            Slog.w("KeyphraseEnrollmentInfo", this.mParseError);
            return;
        }
        ArraySet<Locale> locales = new ArraySet<Locale>();
        if (!TextUtils.isEmpty(searchKeyphraseSupportedLocales)) {
            try {
                String[] supportedLocalesDelimited = searchKeyphraseSupportedLocales.split(",");
                for (int i = 0; i < supportedLocalesDelimited.length; ++i) {
                    locales.add(Locale.forLanguageTag(supportedLocalesDelimited[i]));
                }
            }
            catch (Exception ex) {
                this.mParseError = "Error reading searchKeyphraseSupportedLocales from meta-data";
                Slog.w("KeyphraseEnrollmentInfo", this.mParseError, ex);
                return;
            }
        }
        if ((recognitionModes = array2.getInt(3, -1)) < 0) {
            this.mParseError = "No valid searchKeyphraseRecognitionFlags specified in meta-data";
            Slog.w("KeyphraseEnrollmentInfo", this.mParseError);
            return;
        }
        this.mKeyphrases = new KeyphraseMetadata[1];
        this.mKeyphrases[0] = new KeyphraseMetadata(searchKeyphraseId, searchKeyphrase, locales, recognitionModes);
    }

    private final String $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$getParseError() {
        return this.mParseError;
    }

    private final KeyphraseMetadata[] $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$listKeyphraseMetadata() {
        return this.mKeyphrases;
    }

    private final Intent $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$getManageKeyphraseIntent(int action, String keyphrase, Locale locale) {
        if (this.mEnrollmentPackage == null || this.mEnrollmentPackage.isEmpty()) {
            Slog.w("KeyphraseEnrollmentInfo", "No enrollment application exists");
            return null;
        }
        if (this.getKeyphraseMetadata(keyphrase, locale) != null) {
            Intent intent = new Intent("com.android.intent.action.MANAGE_VOICE_KEYPHRASES").setPackage(this.mEnrollmentPackage).putExtra("com.android.intent.extra.VOICE_KEYPHRASE_HINT_TEXT", keyphrase).putExtra("com.android.intent.extra.VOICE_KEYPHRASE_LOCALE", locale.toLanguageTag()).putExtra("com.android.intent.extra.VOICE_KEYPHRASE_ACTION", action);
            return intent;
        }
        return null;
    }

    private final KeyphraseMetadata $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$getKeyphraseMetadata(String keyphrase, Locale locale) {
        if (this.mKeyphrases == null || this.mKeyphrases.length == 0) {
            Slog.w("KeyphraseEnrollmentInfo", "Enrollment application doesn't support keyphrases");
            return null;
        }
        for (KeyphraseMetadata keyphraseMetadata : this.mKeyphrases) {
            if (!keyphraseMetadata.supportsPhrase(keyphrase) || !keyphraseMetadata.supportsLocale(locale)) continue;
            return keyphraseMetadata;
        }
        Slog.w("KeyphraseEnrollmentInfo", "Enrollment application doesn't support the given keyphrase/locale");
        return null;
    }

    private final String $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$toString() {
        return "KeyphraseEnrollmentInfo [Keyphrases=" + Arrays.toString(this.mKeyphrases) + ", EnrollmentPackage=" + this.mEnrollmentPackage + ", ParseError=" + this.mParseError + "]";
    }

    private void __constructor__(PackageManager packageManager) {
        this.$$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$__constructor__(packageManager);
    }

    public KeyphraseEnrollmentInfo(PackageManager packageManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$__constructor__(android.content.pm.PackageManager ), 0, this, packageManager);
    }

    private void initializeKeyphrasesFromTypedArray(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("initializeKeyphrasesFromTypedArray", $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$initializeKeyphrasesFromTypedArray(android.content.res.TypedArray ), 0, this, typedArray);
    }

    public String getParseError() {
        return InvokeDynamicSupport.bootstrap("getParseError", $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$getParseError(), 0, this);
    }

    public KeyphraseMetadata[] listKeyphraseMetadata() {
        return InvokeDynamicSupport.bootstrap("listKeyphraseMetadata", $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$listKeyphraseMetadata(), 0, this);
    }

    public Intent getManageKeyphraseIntent(int n, String string2, Locale locale) {
        return InvokeDynamicSupport.bootstrap("getManageKeyphraseIntent", $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$getManageKeyphraseIntent(int java.lang.String java.util.Locale ), 0, this, n, string2, locale);
    }

    public KeyphraseMetadata getKeyphraseMetadata(String string2, Locale locale) {
        return InvokeDynamicSupport.bootstrap("getKeyphraseMetadata", $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$getKeyphraseMetadata(java.lang.String java.util.Locale ), 0, this, string2, locale);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_hardware_soundtrigger_KeyphraseEnrollmentInfo$toString(), 0, this);
    }

    public /* synthetic */ KeyphraseEnrollmentInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyphraseEnrollmentInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

