/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.app.PendingIntent;
import android.content.Context;
import android.hardware.usb.IUsbManager;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.util.Log;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class UsbManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "UsbManager";
    public static String ACTION_USB_STATE = "android.hardware.usb.action.USB_STATE";
    public static String ACTION_USB_DEVICE_ATTACHED = "android.hardware.usb.action.USB_DEVICE_ATTACHED";
    public static String ACTION_USB_DEVICE_DETACHED = "android.hardware.usb.action.USB_DEVICE_DETACHED";
    public static String ACTION_USB_ACCESSORY_ATTACHED = "android.hardware.usb.action.USB_ACCESSORY_ATTACHED";
    public static String ACTION_USB_ACCESSORY_DETACHED = "android.hardware.usb.action.USB_ACCESSORY_DETACHED";
    public static String USB_CONNECTED = "connected";
    public static String USB_CONFIGURED = "configured";
    public static String USB_FUNCTION_MASS_STORAGE = "mass_storage";
    public static String USB_FUNCTION_ADB = "adb";
    public static String USB_FUNCTION_RNDIS = "rndis";
    public static String USB_FUNCTION_MTP = "mtp";
    public static String USB_FUNCTION_PTP = "ptp";
    public static String USB_FUNCTION_AUDIO_SOURCE = "audio_source";
    public static String USB_FUNCTION_ACCESSORY = "accessory";
    public static String EXTRA_DEVICE = "device";
    public static String EXTRA_ACCESSORY = "accessory";
    public static String EXTRA_PERMISSION_GRANTED = "permission";
    private Context mContext;
    private IUsbManager mService;

    private void $$robo$$android_hardware_usb_UsbManager$__constructor__(Context context, IUsbManager service) {
        this.mContext = context;
        this.mService = service;
    }

    private final HashMap<String, UsbDevice> $$robo$$android_hardware_usb_UsbManager$getDeviceList() {
        Bundle bundle = new Bundle();
        try {
            this.mService.getDeviceList(bundle);
            HashMap<String, UsbDevice> result = new HashMap<String, UsbDevice>();
            for (String name : bundle.keySet()) {
                result.put(name, (UsbDevice)bundle.get(name));
            }
            return result;
        }
        catch (RemoteException e) {
            Log.e("UsbManager", "RemoteException in getDeviceList", e);
            return null;
        }
    }

    private final UsbDeviceConnection $$robo$$android_hardware_usb_UsbManager$openDevice(UsbDevice device) {
        try {
            String deviceName = device.getDeviceName();
            ParcelFileDescriptor pfd = this.mService.openDevice(deviceName);
            if (pfd != null) {
                UsbDeviceConnection connection = new UsbDeviceConnection(device);
                boolean result = connection.open(deviceName, pfd);
                pfd.close();
                if (result) {
                    return connection;
                }
            }
        }
        catch (Exception e) {
            Log.e("UsbManager", "exception in UsbManager.openDevice", e);
        }
        return null;
    }

    private final UsbAccessory[] $$robo$$android_hardware_usb_UsbManager$getAccessoryList() {
        try {
            UsbAccessory accessory = this.mService.getCurrentAccessory();
            if (accessory == null) {
                return null;
            }
            return new UsbAccessory[]{accessory};
        }
        catch (RemoteException e) {
            Log.e("UsbManager", "RemoteException in getAccessoryList", e);
            return null;
        }
    }

    private final ParcelFileDescriptor $$robo$$android_hardware_usb_UsbManager$openAccessory(UsbAccessory accessory) {
        try {
            return this.mService.openAccessory(accessory);
        }
        catch (RemoteException e) {
            Log.e("UsbManager", "RemoteException in openAccessory", e);
            return null;
        }
    }

    private final boolean $$robo$$android_hardware_usb_UsbManager$hasPermission(UsbDevice device) {
        try {
            return this.mService.hasDevicePermission(device);
        }
        catch (RemoteException e) {
            Log.e("UsbManager", "RemoteException in hasPermission", e);
            return false;
        }
    }

    private final boolean $$robo$$android_hardware_usb_UsbManager$hasPermission(UsbAccessory accessory) {
        try {
            return this.mService.hasAccessoryPermission(accessory);
        }
        catch (RemoteException e) {
            Log.e("UsbManager", "RemoteException in hasPermission", e);
            return false;
        }
    }

    private final void $$robo$$android_hardware_usb_UsbManager$requestPermission(UsbDevice device, PendingIntent pi) {
        try {
            this.mService.requestDevicePermission(device, this.mContext.getPackageName(), pi);
        }
        catch (RemoteException e) {
            Log.e("UsbManager", "RemoteException in requestPermission", e);
        }
    }

    private final void $$robo$$android_hardware_usb_UsbManager$requestPermission(UsbAccessory accessory, PendingIntent pi) {
        try {
            this.mService.requestAccessoryPermission(accessory, this.mContext.getPackageName(), pi);
        }
        catch (RemoteException e) {
            Log.e("UsbManager", "RemoteException in requestPermission", e);
        }
    }

    private static final boolean $$robo$$android_hardware_usb_UsbManager$propertyContainsFunction(String property, String function) {
        String functions = SystemProperties.get(property, "");
        int index = functions.indexOf(function);
        if (index < 0) {
            return false;
        }
        if (index > 0 && functions.charAt(index - 1) != ',') {
            return false;
        }
        int charAfter = index + function.length();
        return charAfter >= functions.length() || functions.charAt(charAfter) == ',';
    }

    private final boolean $$robo$$android_hardware_usb_UsbManager$isFunctionEnabled(String function) {
        return UsbManager.propertyContainsFunction("sys.usb.config", function);
    }

    private final String $$robo$$android_hardware_usb_UsbManager$getDefaultFunction() {
        String functions = SystemProperties.get("persist.sys.usb.config", "");
        int commaIndex = functions.indexOf(44);
        if (commaIndex > 0) {
            return functions.substring(0, commaIndex);
        }
        return functions;
    }

    private final void $$robo$$android_hardware_usb_UsbManager$setCurrentFunction(String function, boolean makeDefault) {
        try {
            this.mService.setCurrentFunction(function, makeDefault);
        }
        catch (RemoteException e) {
            Log.e("UsbManager", "RemoteException in setCurrentFunction", e);
        }
    }

    private final void $$robo$$android_hardware_usb_UsbManager$setMassStorageBackingFile(String path) {
        try {
            this.mService.setMassStorageBackingFile(path);
        }
        catch (RemoteException e) {
            Log.e("UsbManager", "RemoteException in setDefaultFunction", e);
        }
    }

    private void __constructor__(Context context, IUsbManager iUsbManager) {
        this.$$robo$$android_hardware_usb_UsbManager$__constructor__(context, iUsbManager);
    }

    public UsbManager(Context context, IUsbManager iUsbManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_usb_UsbManager$__constructor__(android.content.Context android.hardware.usb.IUsbManager ), 0, this, context, iUsbManager);
    }

    public HashMap<String, UsbDevice> getDeviceList() {
        return InvokeDynamicSupport.bootstrap("getDeviceList", $$robo$$android_hardware_usb_UsbManager$getDeviceList(), 0, this);
    }

    public UsbDeviceConnection openDevice(UsbDevice usbDevice) {
        return InvokeDynamicSupport.bootstrap("openDevice", $$robo$$android_hardware_usb_UsbManager$openDevice(android.hardware.usb.UsbDevice ), 0, this, usbDevice);
    }

    public UsbAccessory[] getAccessoryList() {
        return InvokeDynamicSupport.bootstrap("getAccessoryList", $$robo$$android_hardware_usb_UsbManager$getAccessoryList(), 0, this);
    }

    public ParcelFileDescriptor openAccessory(UsbAccessory usbAccessory) {
        return InvokeDynamicSupport.bootstrap("openAccessory", $$robo$$android_hardware_usb_UsbManager$openAccessory(android.hardware.usb.UsbAccessory ), 0, this, usbAccessory);
    }

    public boolean hasPermission(UsbDevice usbDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasPermission", $$robo$$android_hardware_usb_UsbManager$hasPermission(android.hardware.usb.UsbDevice ), 0, this, usbDevice);
    }

    public boolean hasPermission(UsbAccessory usbAccessory) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasPermission", $$robo$$android_hardware_usb_UsbManager$hasPermission(android.hardware.usb.UsbAccessory ), 0, this, usbAccessory);
    }

    public void requestPermission(UsbDevice usbDevice, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("requestPermission", $$robo$$android_hardware_usb_UsbManager$requestPermission(android.hardware.usb.UsbDevice android.app.PendingIntent ), 0, this, usbDevice, pendingIntent);
    }

    public void requestPermission(UsbAccessory usbAccessory, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("requestPermission", $$robo$$android_hardware_usb_UsbManager$requestPermission(android.hardware.usb.UsbAccessory android.app.PendingIntent ), 0, this, usbAccessory, pendingIntent);
    }

    private static boolean propertyContainsFunction(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("propertyContainsFunction", $$robo$$android_hardware_usb_UsbManager$propertyContainsFunction(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public boolean isFunctionEnabled(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isFunctionEnabled", $$robo$$android_hardware_usb_UsbManager$isFunctionEnabled(java.lang.String ), 0, this, string2);
    }

    public String getDefaultFunction() {
        return InvokeDynamicSupport.bootstrap("getDefaultFunction", $$robo$$android_hardware_usb_UsbManager$getDefaultFunction(), 0, this);
    }

    public void setCurrentFunction(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setCurrentFunction", $$robo$$android_hardware_usb_UsbManager$setCurrentFunction(java.lang.String boolean ), 0, this, string2, bl);
    }

    public void setMassStorageBackingFile(String string2) {
        InvokeDynamicSupport.bootstrap("setMassStorageBackingFile", $$robo$$android_hardware_usb_UsbManager$setMassStorageBackingFile(java.lang.String ), 0, this, string2);
    }

    public /* synthetic */ UsbManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UsbManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

