/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.util.Log;
import java.nio.ByteBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class UsbRequest
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "UsbRequest";
    private long mNativeContext;
    private UsbEndpoint mEndpoint;
    private ByteBuffer mBuffer;
    private int mLength;
    private Object mClientData;

    private void $$robo$$android_hardware_usb_UsbRequest$__constructor__() {
    }

    private final boolean $$robo$$android_hardware_usb_UsbRequest$initialize(UsbDeviceConnection connection, UsbEndpoint endpoint) {
        this.mEndpoint = endpoint;
        return this.native_init(connection, endpoint.getAddress(), endpoint.getAttributes(), endpoint.getMaxPacketSize(), endpoint.getInterval());
    }

    private final void $$robo$$android_hardware_usb_UsbRequest$close() {
        this.mEndpoint = null;
        this.native_close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_usb_UsbRequest$finalize() throws Throwable {
        try {
            if (this.mEndpoint != null) {
                Log.v("UsbRequest", "endpoint still open in finalize(): " + this);
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    private final UsbEndpoint $$robo$$android_hardware_usb_UsbRequest$getEndpoint() {
        return this.mEndpoint;
    }

    private final Object $$robo$$android_hardware_usb_UsbRequest$getClientData() {
        return this.mClientData;
    }

    private final void $$robo$$android_hardware_usb_UsbRequest$setClientData(Object data) {
        this.mClientData = data;
    }

    private final boolean $$robo$$android_hardware_usb_UsbRequest$queue(ByteBuffer buffer, int length) {
        boolean result;
        boolean out;
        boolean bl = out = this.mEndpoint.getDirection() == 0;
        if (buffer.isDirect()) {
            result = this.native_queue_direct(buffer, length, out);
        } else if (buffer.hasArray()) {
            result = this.native_queue_array(buffer.array(), length, out);
        } else {
            throw new IllegalArgumentException("buffer is not direct and has no array");
        }
        if (result) {
            this.mBuffer = buffer;
            this.mLength = length;
        }
        return result;
    }

    private final void $$robo$$android_hardware_usb_UsbRequest$dequeue() {
        boolean out = this.mEndpoint.getDirection() == 0;
        int bytesRead = this.mBuffer.isDirect() ? this.native_dequeue_direct() : this.native_dequeue_array(this.mBuffer.array(), this.mLength, out);
        if (bytesRead >= 0) {
            this.mBuffer.position(Math.min(bytesRead, this.mLength));
        }
        this.mBuffer = null;
        this.mLength = 0;
    }

    private final boolean $$robo$$android_hardware_usb_UsbRequest$cancel() {
        return this.native_cancel();
    }

    private final boolean $$robo$$android_hardware_usb_UsbRequest$native_init(UsbDeviceConnection usbDeviceConnection, int n, int n2, int n3, int n4) {
        return false;
    }

    private final void $$robo$$android_hardware_usb_UsbRequest$native_close() {
    }

    private final boolean $$robo$$android_hardware_usb_UsbRequest$native_queue_array(byte[] byArray, int n, boolean bl) {
        return false;
    }

    private final int $$robo$$android_hardware_usb_UsbRequest$native_dequeue_array(byte[] byArray, int n, boolean bl) {
        return 0;
    }

    private final boolean $$robo$$android_hardware_usb_UsbRequest$native_queue_direct(ByteBuffer byteBuffer, int n, boolean bl) {
        return false;
    }

    private final int $$robo$$android_hardware_usb_UsbRequest$native_dequeue_direct() {
        return 0;
    }

    private final boolean $$robo$$android_hardware_usb_UsbRequest$native_cancel() {
        return false;
    }

    private void __constructor__() {
        this.$$robo$$android_hardware_usb_UsbRequest$__constructor__();
    }

    public UsbRequest() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_usb_UsbRequest$__constructor__(), 0, this);
    }

    public boolean initialize(UsbDeviceConnection usbDeviceConnection, UsbEndpoint usbEndpoint) {
        return (boolean)InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_hardware_usb_UsbRequest$initialize(android.hardware.usb.UsbDeviceConnection android.hardware.usb.UsbEndpoint ), 0, this, usbDeviceConnection, usbEndpoint);
    }

    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_hardware_usb_UsbRequest$close(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_hardware_usb_UsbRequest$finalize(), 0, this);
    }

    public UsbEndpoint getEndpoint() {
        return InvokeDynamicSupport.bootstrap("getEndpoint", $$robo$$android_hardware_usb_UsbRequest$getEndpoint(), 0, this);
    }

    public Object getClientData() {
        return InvokeDynamicSupport.bootstrap("getClientData", $$robo$$android_hardware_usb_UsbRequest$getClientData(), 0, this);
    }

    public void setClientData(Object object) {
        InvokeDynamicSupport.bootstrap("setClientData", $$robo$$android_hardware_usb_UsbRequest$setClientData(java.lang.Object ), 0, this, object);
    }

    public boolean queue(ByteBuffer byteBuffer, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("queue", $$robo$$android_hardware_usb_UsbRequest$queue(java.nio.ByteBuffer int ), 0, this, byteBuffer, n);
    }

    void dequeue() {
        InvokeDynamicSupport.bootstrap("dequeue", $$robo$$android_hardware_usb_UsbRequest$dequeue(), 0, this);
    }

    public boolean cancel() {
        return (boolean)InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_hardware_usb_UsbRequest$cancel(), 0, this);
    }

    private final native /* synthetic */ boolean $$robo$$native_init$nativeBinding(UsbDeviceConnection var1, int var2, int var3, int var4, int var5);

    private boolean native_init(UsbDeviceConnection usbDeviceConnection, int n, int n2, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrap("native_init", $$robo$$android_hardware_usb_UsbRequest$native_init(android.hardware.usb.UsbDeviceConnection int int int int ), 1, this, usbDeviceConnection, n, n2, n3, n4);
    }

    private final native /* synthetic */ void $$robo$$native_close$nativeBinding();

    private void native_close() {
        InvokeDynamicSupport.bootstrap("native_close", $$robo$$android_hardware_usb_UsbRequest$native_close(), 1, this);
    }

    private final native /* synthetic */ boolean $$robo$$native_queue_array$nativeBinding(byte[] var1, int var2, boolean var3);

    private boolean native_queue_array(byte[] byArray, int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("native_queue_array", $$robo$$android_hardware_usb_UsbRequest$native_queue_array(byte[] int boolean ), 1, this, byArray, n, bl);
    }

    private final native /* synthetic */ int $$robo$$native_dequeue_array$nativeBinding(byte[] var1, int var2, boolean var3);

    private int native_dequeue_array(byte[] byArray, int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("native_dequeue_array", $$robo$$android_hardware_usb_UsbRequest$native_dequeue_array(byte[] int boolean ), 1, this, byArray, n, bl);
    }

    private final native /* synthetic */ boolean $$robo$$native_queue_direct$nativeBinding(ByteBuffer var1, int var2, boolean var3);

    private boolean native_queue_direct(ByteBuffer byteBuffer, int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("native_queue_direct", $$robo$$android_hardware_usb_UsbRequest$native_queue_direct(java.nio.ByteBuffer int boolean ), 1, this, byteBuffer, n, bl);
    }

    private final native /* synthetic */ int $$robo$$native_dequeue_direct$nativeBinding();

    private int native_dequeue_direct() {
        return (int)InvokeDynamicSupport.bootstrap("native_dequeue_direct", $$robo$$android_hardware_usb_UsbRequest$native_dequeue_direct(), 1, this);
    }

    private final native /* synthetic */ boolean $$robo$$native_cancel$nativeBinding();

    private boolean native_cancel() {
        return (boolean)InvokeDynamicSupport.bootstrap("native_cancel", $$robo$$android_hardware_usb_UsbRequest$native_cancel(), 1, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UsbRequest)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

