/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Geofence
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int TYPE_HORIZONTAL_CIRCLE = 1;
    private int mType;
    private double mLatitude;
    private double mLongitude;
    private float mRadius;
    public static Parcelable.Creator<Geofence> CREATOR;

    private static final Geofence $$robo$$android_location_Geofence$createCircle(double latitude, double longitude, float radius) {
        return new Geofence(latitude, longitude, radius);
    }

    private void $$robo$$android_location_Geofence$__constructor__(double latitude, double longitude, float radius) {
        Geofence.checkRadius(radius);
        Geofence.checkLatLong(latitude, longitude);
        this.mType = 1;
        this.mLatitude = latitude;
        this.mLongitude = longitude;
        this.mRadius = radius;
    }

    private final int $$robo$$android_location_Geofence$getType() {
        return this.mType;
    }

    private final double $$robo$$android_location_Geofence$getLatitude() {
        return this.mLatitude;
    }

    private final double $$robo$$android_location_Geofence$getLongitude() {
        return this.mLongitude;
    }

    private final float $$robo$$android_location_Geofence$getRadius() {
        return this.mRadius;
    }

    private static final void $$robo$$android_location_Geofence$checkRadius(float radius) {
        if (radius <= 0.0f) {
            throw new IllegalArgumentException("invalid radius: " + radius);
        }
    }

    private static final void $$robo$$android_location_Geofence$checkLatLong(double latitude, double longitude) {
        if (latitude > 90.0 || latitude < -90.0) {
            throw new IllegalArgumentException("invalid latitude: " + latitude);
        }
        if (longitude > 180.0 || longitude < -180.0) {
            throw new IllegalArgumentException("invalid longitude: " + longitude);
        }
    }

    private static final void $$robo$$android_location_Geofence$checkType(int type) {
        if (type != 1) {
            throw new IllegalArgumentException("invalid type: " + type);
        }
    }

    private final int $$robo$$android_location_Geofence$describeContents() {
        return 0;
    }

    private final void $$robo$$android_location_Geofence$writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mType);
        parcel.writeDouble(this.mLatitude);
        parcel.writeDouble(this.mLongitude);
        parcel.writeFloat(this.mRadius);
    }

    private static final String $$robo$$android_location_Geofence$typeToString(int type) {
        switch (type) {
            case 1: {
                return "CIRCLE";
            }
        }
        Geofence.checkType(type);
        return null;
    }

    private final String $$robo$$android_location_Geofence$toString() {
        return String.format("Geofence[%s %.6f, %.6f %.0fm]", Geofence.typeToString(this.mType), this.mLatitude, this.mLongitude, Float.valueOf(this.mRadius));
    }

    private final int $$robo$$android_location_Geofence$hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.mLatitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.mLongitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + Float.floatToIntBits(this.mRadius);
        result = 31 * result + this.mType;
        return result;
    }

    private final boolean $$robo$$android_location_Geofence$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Geofence)) {
            return false;
        }
        Geofence other = (Geofence)obj;
        if (this.mRadius != other.mRadius) {
            return false;
        }
        if (this.mLatitude != other.mLatitude) {
            return false;
        }
        if (this.mLongitude != other.mLongitude) {
            return false;
        }
        return this.mType == other.mType;
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<Geofence>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_location_Geofence_1$__constructor__() {
            }

            private final Geofence $$robo$$android_location_Geofence_1$createFromParcel(Parcel in) {
                int type = in.readInt();
                double latitude = in.readDouble();
                double longitude = in.readDouble();
                float radius = in.readFloat();
                Geofence.checkType(type);
                return Geofence.createCircle(latitude, longitude, radius);
            }

            private final Geofence[] $$robo$$android_location_Geofence_1$newArray(int size) {
                return new Geofence[size];
            }

            private void __constructor__() {
                this.$$robo$$android_location_Geofence_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_Geofence_1$__constructor__(), 0, this);
            }

            @Override
            public Geofence createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_location_Geofence_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public Geofence[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_location_Geofence_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static Geofence createCircle(double d, double d2, float f) {
        return InvokeDynamicSupport.bootstrapStatic("createCircle", $$robo$$android_location_Geofence$createCircle(double double float ), 0, (double)d, (double)d2, (float)f);
    }

    private void __constructor__(double d, double d2, float f) {
        this.$$robo$$android_location_Geofence$__constructor__(d, d2, f);
    }

    private Geofence(double d, double d2, float f) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_Geofence$__constructor__(double double float ), 0, this, d, d2, f);
    }

    public int getType() {
        return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_location_Geofence$getType(), 0, this);
    }

    public double getLatitude() {
        return (double)InvokeDynamicSupport.bootstrap("getLatitude", $$robo$$android_location_Geofence$getLatitude(), 0, this);
    }

    public double getLongitude() {
        return (double)InvokeDynamicSupport.bootstrap("getLongitude", $$robo$$android_location_Geofence$getLongitude(), 0, this);
    }

    public float getRadius() {
        return (float)InvokeDynamicSupport.bootstrap("getRadius", $$robo$$android_location_Geofence$getRadius(), 0, this);
    }

    private static void checkRadius(float f) {
        InvokeDynamicSupport.bootstrapStatic("checkRadius", $$robo$$android_location_Geofence$checkRadius(float ), 0, (float)f);
    }

    private static void checkLatLong(double d, double d2) {
        InvokeDynamicSupport.bootstrapStatic("checkLatLong", $$robo$$android_location_Geofence$checkLatLong(double double ), 0, (double)d, (double)d2);
    }

    private static void checkType(int n) {
        InvokeDynamicSupport.bootstrapStatic("checkType", $$robo$$android_location_Geofence$checkType(int ), 0, (int)n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_location_Geofence$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_location_Geofence$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private static String typeToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("typeToString", $$robo$$android_location_Geofence$typeToString(int ), 0, (int)n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_location_Geofence$toString(), 0, this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_location_Geofence$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_location_Geofence$equals(java.lang.Object ), 0, this, object);
    }

    static {
        RobolectricInternals.classInitializing(Geofence.class);
    }

    public /* synthetic */ Geofence() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Geofence)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

